import { __awaiter, __generator, __values } from "tslib";
import { HttpResponse } from "@aws-sdk/protocol-http";
import { buildQueryString } from "@aws-sdk/querystring-builder";
import { requestTimeout } from "./request-timeout";
var FetchHttpHandler = (function () {
    function FetchHttpHandler(options) {
        if (typeof options === "function") {
            this.configProvider = options().then(function (opts) { return opts || {}; });
        }
        else {
            this.config = options !== null && options !== void 0 ? options : {};
            this.configProvider = Promise.resolve(this.config);
        }
    }
    FetchHttpHandler.prototype.destroy = function () {
    };
    FetchHttpHandler.prototype.handle = function (request, _a) {
        var _b = _a === void 0 ? {} : _a, abortSignal = _b.abortSignal;
        return __awaiter(this, void 0, void 0, function () {
            var _c, requestTimeoutInMs, abortError, path, queryString, port, method, url, body, requestOptions, fetchRequest, raceOfPromises;
            return __generator(this, function (_d) {
                switch (_d.label) {
                    case 0:
                        if (!!this.config) return [3, 2];
                        _c = this;
                        return [4, this.configProvider];
                    case 1:
                        _c.config = _d.sent();
                        _d.label = 2;
                    case 2:
                        requestTimeoutInMs = this.config.requestTimeout;
                        if (abortSignal === null || abortSignal === void 0 ? void 0 : abortSignal.aborted) {
                            abortError = new Error("Request aborted");
                            abortError.name = "AbortError";
                            return [2, Promise.reject(abortError)];
                        }
                        path = request.path;
                        if (request.query) {
                            queryString = buildQueryString(request.query);
                            if (queryString) {
                                path += "?".concat(queryString);
                            }
                        }
                        port = request.port, method = request.method;
                        url = "".concat(request.protocol, "//").concat(request.hostname).concat(port ? ":".concat(port) : "").concat(path);
                        body = method === "GET" || method === "HEAD" ? undefined : request.body;
                        requestOptions = {
                            body: body,
                            headers: new Headers(request.headers),
                            method: method,
                        };
                        if (typeof AbortController !== "undefined") {
                            requestOptions["signal"] = abortSignal;
                        }
                        fetchRequest = new Request(url, requestOptions);
                        raceOfPromises = [
                            fetch(fetchRequest).then(function (response) {
                                var e_1, _a;
                                var fetchHeaders = response.headers;
                                var transformedHeaders = {};
                                try {
                                    for (var _b = __values(fetchHeaders.entries()), _c = _b.next(); !_c.done; _c = _b.next()) {
                                        var pair = _c.value;
                                        transformedHeaders[pair[0]] = pair[1];
                                    }
                                }
                                catch (e_1_1) { e_1 = { error: e_1_1 }; }
                                finally {
                                    try {
                                        if (_c && !_c.done && (_a = _b.return)) _a.call(_b);
                                    }
                                    finally { if (e_1) throw e_1.error; }
                                }
                                var hasReadableStream = response.body !== undefined;
                                if (!hasReadableStream) {
                                    return response.blob().then(function (body) { return ({
                                        response: new HttpResponse({
                                            headers: transformedHeaders,
                                            statusCode: response.status,
                                            body: body,
                                        }),
                                    }); });
                                }
                                return {
                                    response: new HttpResponse({
                                        headers: transformedHeaders,
                                        statusCode: response.status,
                                        body: response.body,
                                    }),
                                };
                            }),
                            requestTimeout(requestTimeoutInMs),
                        ];
                        if (abortSignal) {
                            raceOfPromises.push(new Promise(function (resolve, reject) {
                                abortSignal.onabort = function () {
                                    var abortError = new Error("Request aborted");
                                    abortError.name = "AbortError";
                                    reject(abortError);
                                };
                            }));
                        }
                        return [2, Promise.race(raceOfPromises)];
                }
            });
        });
    };
    return FetchHttpHandler;
}());
export { FetchHttpHandler };
