import { ExceptionOptionType as __ExceptionOptionType } from "@aws-sdk/smithy-client";
import { LoggingInfo, MaintenanceWindowTaskCutoffBehavior, MaintenanceWindowTaskParameterValueExpression, MetadataValue, OperatingSystem, OpsItemDataValue, OpsItemNotification, OpsItemStatus, PatchAction, PatchComplianceLevel, PatchFilterGroup, PatchRuleGroup, PatchSource, RelatedOpsItem, ResourceDataSyncSource, Target } from "./models_0";
import { DocumentReviews, InventoryFilter, InventoryGroup, MaintenanceWindowTaskInvocationParameters, OpsFilter, OpsResultAttribute, ResultAttribute } from "./models_1";
import { SSMServiceException as __BaseException } from "./SSMServiceException";
export interface UpdateDocumentMetadataRequest {
    
    Name: string | undefined;
    
    DocumentVersion?: string;
    
    DocumentReviews: DocumentReviews | undefined;
}
export interface UpdateDocumentMetadataResponse {
}
export interface UpdateMaintenanceWindowRequest {
    
    WindowId: string | undefined;
    
    Name?: string;
    
    Description?: string;
    
    StartDate?: string;
    
    EndDate?: string;
    
    Schedule?: string;
    
    ScheduleTimezone?: string;
    
    ScheduleOffset?: number;
    
    Duration?: number;
    
    Cutoff?: number;
    
    AllowUnassociatedTargets?: boolean;
    
    Enabled?: boolean;
    
    Replace?: boolean;
}
export interface UpdateMaintenanceWindowResult {
    
    WindowId?: string;
    
    Name?: string;
    
    Description?: string;
    
    StartDate?: string;
    
    EndDate?: string;
    
    Schedule?: string;
    
    ScheduleTimezone?: string;
    
    ScheduleOffset?: number;
    
    Duration?: number;
    
    Cutoff?: number;
    
    AllowUnassociatedTargets?: boolean;
    
    Enabled?: boolean;
}
export interface UpdateMaintenanceWindowTargetRequest {
    
    WindowId: string | undefined;
    
    WindowTargetId: string | undefined;
    
    Targets?: Target[];
    
    OwnerInformation?: string;
    
    Name?: string;
    
    Description?: string;
    
    Replace?: boolean;
}
export interface UpdateMaintenanceWindowTargetResult {
    
    WindowId?: string;
    
    WindowTargetId?: string;
    
    Targets?: Target[];
    
    OwnerInformation?: string;
    
    Name?: string;
    
    Description?: string;
}
export interface UpdateMaintenanceWindowTaskRequest {
    
    WindowId: string | undefined;
    
    WindowTaskId: string | undefined;
    
    Targets?: Target[];
    
    TaskArn?: string;
    
    ServiceRoleArn?: string;
    
    TaskParameters?: Record<string, MaintenanceWindowTaskParameterValueExpression>;
    
    TaskInvocationParameters?: MaintenanceWindowTaskInvocationParameters;
    
    Priority?: number;
    
    MaxConcurrency?: string;
    
    MaxErrors?: string;
    
    LoggingInfo?: LoggingInfo;
    
    Name?: string;
    
    Description?: string;
    
    Replace?: boolean;
    
    CutoffBehavior?: MaintenanceWindowTaskCutoffBehavior | string;
}
export interface UpdateMaintenanceWindowTaskResult {
    
    WindowId?: string;
    
    WindowTaskId?: string;
    
    Targets?: Target[];
    
    TaskArn?: string;
    
    ServiceRoleArn?: string;
    
    TaskParameters?: Record<string, MaintenanceWindowTaskParameterValueExpression>;
    
    TaskInvocationParameters?: MaintenanceWindowTaskInvocationParameters;
    
    Priority?: number;
    
    MaxConcurrency?: string;
    
    MaxErrors?: string;
    
    LoggingInfo?: LoggingInfo;
    
    Name?: string;
    
    Description?: string;
    
    CutoffBehavior?: MaintenanceWindowTaskCutoffBehavior | string;
}
export interface UpdateManagedInstanceRoleRequest {
    
    InstanceId: string | undefined;
    
    IamRole: string | undefined;
}
export interface UpdateManagedInstanceRoleResult {
}
export interface UpdateOpsItemRequest {
    
    Description?: string;
    
    OperationalData?: Record<string, OpsItemDataValue>;
    
    OperationalDataToDelete?: string[];
    
    Notifications?: OpsItemNotification[];
    
    Priority?: number;
    
    RelatedOpsItems?: RelatedOpsItem[];
    
    Status?: OpsItemStatus | string;
    
    OpsItemId: string | undefined;
    
    Title?: string;
    
    Category?: string;
    
    Severity?: string;
    
    ActualStartTime?: Date;
    
    ActualEndTime?: Date;
    
    PlannedStartTime?: Date;
    
    PlannedEndTime?: Date;
}
export interface UpdateOpsItemResponse {
}

export declare class OpsMetadataKeyLimitExceededException extends __BaseException {
    readonly name: "OpsMetadataKeyLimitExceededException";
    readonly $fault: "client";
    
    constructor(opts: __ExceptionOptionType<OpsMetadataKeyLimitExceededException, __BaseException>);
}
export interface UpdateOpsMetadataRequest {
    
    OpsMetadataArn: string | undefined;
    
    MetadataToUpdate?: Record<string, MetadataValue>;
    
    KeysToDelete?: string[];
}
export interface UpdateOpsMetadataResult {
    
    OpsMetadataArn?: string;
}
export interface UpdatePatchBaselineRequest {
    
    BaselineId: string | undefined;
    
    Name?: string;
    
    GlobalFilters?: PatchFilterGroup;
    
    ApprovalRules?: PatchRuleGroup;
    
    ApprovedPatches?: string[];
    
    ApprovedPatchesComplianceLevel?: PatchComplianceLevel | string;
    
    ApprovedPatchesEnableNonSecurity?: boolean;
    
    RejectedPatches?: string[];
    
    RejectedPatchesAction?: PatchAction | string;
    
    Description?: string;
    
    Sources?: PatchSource[];
    
    Replace?: boolean;
}
export interface UpdatePatchBaselineResult {
    
    BaselineId?: string;
    
    Name?: string;
    
    OperatingSystem?: OperatingSystem | string;
    
    GlobalFilters?: PatchFilterGroup;
    
    ApprovalRules?: PatchRuleGroup;
    
    ApprovedPatches?: string[];
    
    ApprovedPatchesComplianceLevel?: PatchComplianceLevel | string;
    
    ApprovedPatchesEnableNonSecurity?: boolean;
    
    RejectedPatches?: string[];
    
    RejectedPatchesAction?: PatchAction | string;
    
    CreatedDate?: Date;
    
    ModifiedDate?: Date;
    
    Description?: string;
    
    Sources?: PatchSource[];
}

export declare class ResourceDataSyncConflictException extends __BaseException {
    readonly name: "ResourceDataSyncConflictException";
    readonly $fault: "client";
    Message?: string;
    
    constructor(opts: __ExceptionOptionType<ResourceDataSyncConflictException, __BaseException>);
}
export interface UpdateResourceDataSyncRequest {
    
    SyncName: string | undefined;
    
    SyncType: string | undefined;
    
    SyncSource: ResourceDataSyncSource | undefined;
}
export interface UpdateResourceDataSyncResult {
}

export interface UpdateServiceSettingRequest {
    
    SettingId: string | undefined;
    
    SettingValue: string | undefined;
}

export interface UpdateServiceSettingResult {
}

export interface InventoryAggregator {
    
    Expression?: string;
    
    Aggregators?: InventoryAggregator[];
    
    Groups?: InventoryGroup[];
}

export interface OpsAggregator {
    
    AggregatorType?: string;
    
    TypeName?: string;
    
    AttributeName?: string;
    
    Values?: Record<string, string>;
    
    Filters?: OpsFilter[];
    
    Aggregators?: OpsAggregator[];
}
export interface GetInventoryRequest {
    
    Filters?: InventoryFilter[];
    
    Aggregators?: InventoryAggregator[];
    
    ResultAttributes?: ResultAttribute[];
    
    NextToken?: string;
    
    MaxResults?: number;
}
export interface GetOpsSummaryRequest {
    
    SyncName?: string;
    
    Filters?: OpsFilter[];
    
    Aggregators?: OpsAggregator[];
    
    ResultAttributes?: OpsResultAttribute[];
    
    NextToken?: string;
    
    MaxResults?: number;
}

export declare const UpdateDocumentMetadataRequestFilterSensitiveLog: (obj: UpdateDocumentMetadataRequest) => any;

export declare const UpdateDocumentMetadataResponseFilterSensitiveLog: (obj: UpdateDocumentMetadataResponse) => any;

export declare const UpdateMaintenanceWindowRequestFilterSensitiveLog: (obj: UpdateMaintenanceWindowRequest) => any;

export declare const UpdateMaintenanceWindowResultFilterSensitiveLog: (obj: UpdateMaintenanceWindowResult) => any;

export declare const UpdateMaintenanceWindowTargetRequestFilterSensitiveLog: (obj: UpdateMaintenanceWindowTargetRequest) => any;

export declare const UpdateMaintenanceWindowTargetResultFilterSensitiveLog: (obj: UpdateMaintenanceWindowTargetResult) => any;

export declare const UpdateMaintenanceWindowTaskRequestFilterSensitiveLog: (obj: UpdateMaintenanceWindowTaskRequest) => any;

export declare const UpdateMaintenanceWindowTaskResultFilterSensitiveLog: (obj: UpdateMaintenanceWindowTaskResult) => any;

export declare const UpdateManagedInstanceRoleRequestFilterSensitiveLog: (obj: UpdateManagedInstanceRoleRequest) => any;

export declare const UpdateManagedInstanceRoleResultFilterSensitiveLog: (obj: UpdateManagedInstanceRoleResult) => any;

export declare const UpdateOpsItemRequestFilterSensitiveLog: (obj: UpdateOpsItemRequest) => any;

export declare const UpdateOpsItemResponseFilterSensitiveLog: (obj: UpdateOpsItemResponse) => any;

export declare const UpdateOpsMetadataRequestFilterSensitiveLog: (obj: UpdateOpsMetadataRequest) => any;

export declare const UpdateOpsMetadataResultFilterSensitiveLog: (obj: UpdateOpsMetadataResult) => any;

export declare const UpdatePatchBaselineRequestFilterSensitiveLog: (obj: UpdatePatchBaselineRequest) => any;

export declare const UpdatePatchBaselineResultFilterSensitiveLog: (obj: UpdatePatchBaselineResult) => any;

export declare const UpdateResourceDataSyncRequestFilterSensitiveLog: (obj: UpdateResourceDataSyncRequest) => any;

export declare const UpdateResourceDataSyncResultFilterSensitiveLog: (obj: UpdateResourceDataSyncResult) => any;

export declare const UpdateServiceSettingRequestFilterSensitiveLog: (obj: UpdateServiceSettingRequest) => any;

export declare const UpdateServiceSettingResultFilterSensitiveLog: (obj: UpdateServiceSettingResult) => any;

export declare const InventoryAggregatorFilterSensitiveLog: (obj: InventoryAggregator) => any;

export declare const OpsAggregatorFilterSensitiveLog: (obj: OpsAggregator) => any;

export declare const GetInventoryRequestFilterSensitiveLog: (obj: GetInventoryRequest) => any;

export declare const GetOpsSummaryRequestFilterSensitiveLog: (obj: GetOpsSummaryRequest) => any;
