import { ExceptionOptionType as __ExceptionOptionType } from "@aws-sdk/smithy-client";
import { AssociationComplianceSeverity, AssociationDescription, AssociationOverview, AssociationStatus, AssociationSyncCompliance, AttachmentsSource, AutomationExecutionStatus, AutomationSubtype, DocumentDescription, DocumentFormat, DocumentHashType, DocumentPermissionType, DocumentRequires, DocumentStatus, DocumentType, ExecutionMode, InstanceAssociationOutputLocation, LoggingInfo, MaintenanceWindowExecutionStatus, MaintenanceWindowResourceType, MaintenanceWindowTaskCutoffBehavior, MaintenanceWindowTaskParameterValueExpression, MaintenanceWindowTaskType, MetadataValue, OperatingSystem, OpsItemDataValue, OpsItemNotification, OpsItemStatus, ParameterInlinePolicy, ParameterStringFilter, PatchAction, PatchComplianceLevel, PatchFilterGroup, PatchOrchestratorFilter, PatchRuleGroup, PatchSource, PlatformType, RelatedOpsItem, ResolvedTargets, ResourceDataSyncAwsOrganizationsSource, ResourceDataSyncS3Destination, ResourceTypeForTagging, ReviewStatus, Runbook, StepExecution, Tag, Target, TargetLocation } from "./models_0";
import { SSMServiceException as __BaseException } from "./SSMServiceException";
export declare enum ParameterTier {
    ADVANCED = "Advanced",
    INTELLIGENT_TIERING = "Intelligent-Tiering",
    STANDARD = "Standard"
}
export declare enum ParameterType {
    SECURE_STRING = "SecureString",
    STRING = "String",
    STRING_LIST = "StringList"
}

export interface ParameterMetadata {
    
    Name?: string;
    
    Type?: ParameterType | string;
    
    KeyId?: string;
    
    LastModifiedDate?: Date;
    
    LastModifiedUser?: string;
    
    Description?: string;
    
    AllowedPattern?: string;
    
    Version?: number;
    
    Tier?: ParameterTier | string;
    
    Policies?: ParameterInlinePolicy[];
    
    DataType?: string;
}
export interface DescribeParametersResult {
    
    Parameters?: ParameterMetadata[];
    
    NextToken?: string;
}

export declare class InvalidFilterOption extends __BaseException {
    readonly name: "InvalidFilterOption";
    readonly $fault: "client";
    
    constructor(opts: __ExceptionOptionType<InvalidFilterOption, __BaseException>);
}
export interface DescribePatchBaselinesRequest {
    
    Filters?: PatchOrchestratorFilter[];
    
    MaxResults?: number;
    
    NextToken?: string;
}

export interface PatchBaselineIdentity {
    
    BaselineId?: string;
    
    BaselineName?: string;
    
    OperatingSystem?: OperatingSystem | string;
    
    BaselineDescription?: string;
    
    DefaultBaseline?: boolean;
}
export interface DescribePatchBaselinesResult {
    
    BaselineIdentities?: PatchBaselineIdentity[];
    
    NextToken?: string;
}
export interface DescribePatchGroupsRequest {
    
    MaxResults?: number;
    
    Filters?: PatchOrchestratorFilter[];
    
    NextToken?: string;
}

export interface PatchGroupPatchBaselineMapping {
    
    PatchGroup?: string;
    
    BaselineIdentity?: PatchBaselineIdentity;
}
export interface DescribePatchGroupsResult {
    
    Mappings?: PatchGroupPatchBaselineMapping[];
    
    NextToken?: string;
}
export interface DescribePatchGroupStateRequest {
    
    PatchGroup: string | undefined;
}
export interface DescribePatchGroupStateResult {
    
    Instances?: number;
    
    InstancesWithInstalledPatches?: number;
    
    InstancesWithInstalledOtherPatches?: number;
    
    InstancesWithInstalledPendingRebootPatches?: number;
    
    InstancesWithInstalledRejectedPatches?: number;
    
    InstancesWithMissingPatches?: number;
    
    InstancesWithFailedPatches?: number;
    
    InstancesWithNotApplicablePatches?: number;
    
    InstancesWithUnreportedNotApplicablePatches?: number;
    
    InstancesWithCriticalNonCompliantPatches?: number;
    
    InstancesWithSecurityNonCompliantPatches?: number;
    
    InstancesWithOtherNonCompliantPatches?: number;
}
export declare enum PatchSet {
    Application = "APPLICATION",
    Os = "OS"
}
export declare enum PatchProperty {
    PatchClassification = "CLASSIFICATION",
    PatchMsrcSeverity = "MSRC_SEVERITY",
    PatchPriority = "PRIORITY",
    PatchProductFamily = "PRODUCT_FAMILY",
    PatchSeverity = "SEVERITY",
    Product = "PRODUCT"
}
export interface DescribePatchPropertiesRequest {
    
    OperatingSystem: OperatingSystem | string | undefined;
    
    Property: PatchProperty | string | undefined;
    
    PatchSet?: PatchSet | string;
    
    MaxResults?: number;
    
    NextToken?: string;
}
export interface DescribePatchPropertiesResult {
    
    Properties?: Record<string, string>[];
    
    NextToken?: string;
}
export declare enum SessionFilterKey {
    INVOKED_AFTER = "InvokedAfter",
    INVOKED_BEFORE = "InvokedBefore",
    OWNER = "Owner",
    SESSION_ID = "SessionId",
    STATUS = "Status",
    TARGET_ID = "Target"
}

export interface SessionFilter {
    
    key: SessionFilterKey | string | undefined;
    
    value: string | undefined;
}
export declare enum SessionState {
    ACTIVE = "Active",
    HISTORY = "History"
}
export interface DescribeSessionsRequest {
    
    State: SessionState | string | undefined;
    
    MaxResults?: number;
    
    NextToken?: string;
    
    Filters?: SessionFilter[];
}

export interface SessionManagerOutputUrl {
    
    S3OutputUrl?: string;
    
    CloudWatchOutputUrl?: string;
}
export declare enum SessionStatus {
    CONNECTED = "Connected",
    CONNECTING = "Connecting",
    DISCONNECTED = "Disconnected",
    FAILED = "Failed",
    TERMINATED = "Terminated",
    TERMINATING = "Terminating"
}

export interface Session {
    
    SessionId?: string;
    
    Target?: string;
    
    Status?: SessionStatus | string;
    
    StartDate?: Date;
    
    EndDate?: Date;
    
    DocumentName?: string;
    
    Owner?: string;
    
    Reason?: string;
    
    Details?: string;
    
    OutputUrl?: SessionManagerOutputUrl;
    
    MaxSessionDuration?: string;
}
export interface DescribeSessionsResponse {
    
    Sessions?: Session[];
    
    NextToken?: string;
}
export interface DisassociateOpsItemRelatedItemRequest {
    
    OpsItemId: string | undefined;
    
    AssociationId: string | undefined;
}
export interface DisassociateOpsItemRelatedItemResponse {
}

export declare class OpsItemRelatedItemAssociationNotFoundException extends __BaseException {
    readonly name: "OpsItemRelatedItemAssociationNotFoundException";
    readonly $fault: "client";
    Message?: string;
    
    constructor(opts: __ExceptionOptionType<OpsItemRelatedItemAssociationNotFoundException, __BaseException>);
}
export interface GetAutomationExecutionRequest {
    
    AutomationExecutionId: string | undefined;
}

export interface ProgressCounters {
    
    TotalSteps?: number;
    
    SuccessSteps?: number;
    
    FailedSteps?: number;
    
    CancelledSteps?: number;
    
    TimedOutSteps?: number;
}

export interface AutomationExecution {
    
    AutomationExecutionId?: string;
    
    DocumentName?: string;
    
    DocumentVersion?: string;
    
    ExecutionStartTime?: Date;
    
    ExecutionEndTime?: Date;
    
    AutomationExecutionStatus?: AutomationExecutionStatus | string;
    
    StepExecutions?: StepExecution[];
    
    StepExecutionsTruncated?: boolean;
    
    Parameters?: Record<string, string[]>;
    
    Outputs?: Record<string, string[]>;
    
    FailureMessage?: string;
    
    Mode?: ExecutionMode | string;
    
    ParentAutomationExecutionId?: string;
    
    ExecutedBy?: string;
    
    CurrentStepName?: string;
    
    CurrentAction?: string;
    
    TargetParameterName?: string;
    
    Targets?: Target[];
    
    TargetMaps?: Record<string, string[]>[];
    
    ResolvedTargets?: ResolvedTargets;
    
    MaxConcurrency?: string;
    
    MaxErrors?: string;
    
    Target?: string;
    
    TargetLocations?: TargetLocation[];
    
    ProgressCounters?: ProgressCounters;
    
    AutomationSubtype?: AutomationSubtype | string;
    
    ScheduledTime?: Date;
    
    Runbooks?: Runbook[];
    
    OpsItemId?: string;
    
    AssociationId?: string;
    
    ChangeRequestName?: string;
}
export interface GetAutomationExecutionResult {
    
    AutomationExecution?: AutomationExecution;
}
export interface GetCalendarStateRequest {
    
    CalendarNames: string[] | undefined;
    
    AtTime?: string;
}
export declare enum CalendarState {
    CLOSED = "CLOSED",
    OPEN = "OPEN"
}
export interface GetCalendarStateResponse {
    
    State?: CalendarState | string;
    
    AtTime?: string;
    
    NextTransitionTime?: string;
}

export declare class InvalidDocumentType extends __BaseException {
    readonly name: "InvalidDocumentType";
    readonly $fault: "client";
    Message?: string;
    
    constructor(opts: __ExceptionOptionType<InvalidDocumentType, __BaseException>);
}

export declare class UnsupportedCalendarException extends __BaseException {
    readonly name: "UnsupportedCalendarException";
    readonly $fault: "client";
    Message?: string;
    
    constructor(opts: __ExceptionOptionType<UnsupportedCalendarException, __BaseException>);
}
export interface GetCommandInvocationRequest {
    
    CommandId: string | undefined;
    
    InstanceId: string | undefined;
    
    PluginName?: string;
}

export interface CloudWatchOutputConfig {
    
    CloudWatchLogGroupName?: string;
    
    CloudWatchOutputEnabled?: boolean;
}
export declare enum CommandInvocationStatus {
    CANCELLED = "Cancelled",
    CANCELLING = "Cancelling",
    DELAYED = "Delayed",
    FAILED = "Failed",
    IN_PROGRESS = "InProgress",
    PENDING = "Pending",
    SUCCESS = "Success",
    TIMED_OUT = "TimedOut"
}
export interface GetCommandInvocationResult {
    
    CommandId?: string;
    
    InstanceId?: string;
    
    Comment?: string;
    
    DocumentName?: string;
    
    DocumentVersion?: string;
    
    PluginName?: string;
    
    ResponseCode?: number;
    
    ExecutionStartDateTime?: string;
    
    ExecutionElapsedTime?: string;
    
    ExecutionEndDateTime?: string;
    
    Status?: CommandInvocationStatus | string;
    
    StatusDetails?: string;
    
    StandardOutputContent?: string;
    
    StandardOutputUrl?: string;
    
    StandardErrorContent?: string;
    
    StandardErrorUrl?: string;
    
    CloudWatchOutputConfig?: CloudWatchOutputConfig;
}

export declare class InvalidPluginName extends __BaseException {
    readonly name: "InvalidPluginName";
    readonly $fault: "client";
    
    constructor(opts: __ExceptionOptionType<InvalidPluginName, __BaseException>);
}

export declare class InvocationDoesNotExist extends __BaseException {
    readonly name: "InvocationDoesNotExist";
    readonly $fault: "client";
    
    constructor(opts: __ExceptionOptionType<InvocationDoesNotExist, __BaseException>);
}
export interface GetConnectionStatusRequest {
    
    Target: string | undefined;
}
export declare enum ConnectionStatus {
    CONNECTED = "Connected",
    NOT_CONNECTED = "NotConnected"
}
export interface GetConnectionStatusResponse {
    
    Target?: string;
    
    Status?: ConnectionStatus | string;
}
export interface GetDefaultPatchBaselineRequest {
    
    OperatingSystem?: OperatingSystem | string;
}
export interface GetDefaultPatchBaselineResult {
    
    BaselineId?: string;
    
    OperatingSystem?: OperatingSystem | string;
}

export interface BaselineOverride {
    
    OperatingSystem?: OperatingSystem | string;
    
    GlobalFilters?: PatchFilterGroup;
    
    ApprovalRules?: PatchRuleGroup;
    
    ApprovedPatches?: string[];
    
    ApprovedPatchesComplianceLevel?: PatchComplianceLevel | string;
    
    RejectedPatches?: string[];
    
    RejectedPatchesAction?: PatchAction | string;
    
    ApprovedPatchesEnableNonSecurity?: boolean;
    
    Sources?: PatchSource[];
}
export interface GetDeployablePatchSnapshotForInstanceRequest {
    
    InstanceId: string | undefined;
    
    SnapshotId: string | undefined;
    
    BaselineOverride?: BaselineOverride;
}
export interface GetDeployablePatchSnapshotForInstanceResult {
    
    InstanceId?: string;
    
    SnapshotId?: string;
    
    SnapshotDownloadUrl?: string;
    
    Product?: string;
}

export declare class UnsupportedFeatureRequiredException extends __BaseException {
    readonly name: "UnsupportedFeatureRequiredException";
    readonly $fault: "client";
    Message?: string;
    
    constructor(opts: __ExceptionOptionType<UnsupportedFeatureRequiredException, __BaseException>);
}
export interface GetDocumentRequest {
    
    Name: string | undefined;
    
    VersionName?: string;
    
    DocumentVersion?: string;
    
    DocumentFormat?: DocumentFormat | string;
}
export declare enum AttachmentHashType {
    SHA256 = "Sha256"
}

export interface AttachmentContent {
    
    Name?: string;
    
    Size?: number;
    
    Hash?: string;
    
    HashType?: AttachmentHashType | string;
    
    Url?: string;
}
export interface GetDocumentResult {
    
    Name?: string;
    
    CreatedDate?: Date;
    
    DisplayName?: string;
    
    VersionName?: string;
    
    DocumentVersion?: string;
    
    Status?: DocumentStatus | string;
    
    StatusInformation?: string;
    
    Content?: string;
    
    DocumentType?: DocumentType | string;
    
    DocumentFormat?: DocumentFormat | string;
    
    Requires?: DocumentRequires[];
    
    AttachmentsContent?: AttachmentContent[];
    
    ReviewStatus?: ReviewStatus | string;
}
export declare enum InventoryQueryOperatorType {
    BEGIN_WITH = "BeginWith",
    EQUAL = "Equal",
    EXISTS = "Exists",
    GREATER_THAN = "GreaterThan",
    LESS_THAN = "LessThan",
    NOT_EQUAL = "NotEqual"
}

export interface InventoryFilter {
    
    Key: string | undefined;
    
    Values: string[] | undefined;
    
    Type?: InventoryQueryOperatorType | string;
}

export interface InventoryGroup {
    
    Name: string | undefined;
    
    Filters: InventoryFilter[] | undefined;
}

export interface ResultAttribute {
    
    TypeName: string | undefined;
}

export interface InventoryResultItem {
    
    TypeName: string | undefined;
    
    SchemaVersion: string | undefined;
    
    CaptureTime?: string;
    
    ContentHash?: string;
    
    Content: Record<string, string>[] | undefined;
}

export interface InventoryResultEntity {
    
    Id?: string;
    
    Data?: Record<string, InventoryResultItem>;
}
export interface GetInventoryResult {
    
    Entities?: InventoryResultEntity[];
    
    NextToken?: string;
}

export declare class InvalidAggregatorException extends __BaseException {
    readonly name: "InvalidAggregatorException";
    readonly $fault: "client";
    Message?: string;
    
    constructor(opts: __ExceptionOptionType<InvalidAggregatorException, __BaseException>);
}

export declare class InvalidInventoryGroupException extends __BaseException {
    readonly name: "InvalidInventoryGroupException";
    readonly $fault: "client";
    Message?: string;
    
    constructor(opts: __ExceptionOptionType<InvalidInventoryGroupException, __BaseException>);
}

export declare class InvalidResultAttributeException extends __BaseException {
    readonly name: "InvalidResultAttributeException";
    readonly $fault: "client";
    Message?: string;
    
    constructor(opts: __ExceptionOptionType<InvalidResultAttributeException, __BaseException>);
}
export interface GetInventorySchemaRequest {
    
    TypeName?: string;
    
    NextToken?: string;
    
    MaxResults?: number;
    
    Aggregator?: boolean;
    
    SubType?: boolean;
}
export declare enum InventoryAttributeDataType {
    NUMBER = "number",
    STRING = "string"
}

export interface InventoryItemAttribute {
    
    Name: string | undefined;
    
    DataType: InventoryAttributeDataType | string | undefined;
}

export interface InventoryItemSchema {
    
    TypeName: string | undefined;
    
    Version?: string;
    
    Attributes: InventoryItemAttribute[] | undefined;
    
    DisplayName?: string;
}
export interface GetInventorySchemaResult {
    
    Schemas?: InventoryItemSchema[];
    
    NextToken?: string;
}
export interface GetMaintenanceWindowRequest {
    
    WindowId: string | undefined;
}
export interface GetMaintenanceWindowResult {
    
    WindowId?: string;
    
    Name?: string;
    
    Description?: string;
    
    StartDate?: string;
    
    EndDate?: string;
    
    Schedule?: string;
    
    ScheduleTimezone?: string;
    
    ScheduleOffset?: number;
    
    NextExecutionTime?: string;
    
    Duration?: number;
    
    Cutoff?: number;
    
    AllowUnassociatedTargets?: boolean;
    
    Enabled?: boolean;
    
    CreatedDate?: Date;
    
    ModifiedDate?: Date;
}
export interface GetMaintenanceWindowExecutionRequest {
    
    WindowExecutionId: string | undefined;
}
export interface GetMaintenanceWindowExecutionResult {
    
    WindowExecutionId?: string;
    
    TaskIds?: string[];
    
    Status?: MaintenanceWindowExecutionStatus | string;
    
    StatusDetails?: string;
    
    StartTime?: Date;
    
    EndTime?: Date;
}
export interface GetMaintenanceWindowExecutionTaskRequest {
    
    WindowExecutionId: string | undefined;
    
    TaskId: string | undefined;
}
export interface GetMaintenanceWindowExecutionTaskResult {
    
    WindowExecutionId?: string;
    
    TaskExecutionId?: string;
    
    TaskArn?: string;
    
    ServiceRole?: string;
    
    Type?: MaintenanceWindowTaskType | string;
    
    TaskParameters?: Record<string, MaintenanceWindowTaskParameterValueExpression>[];
    
    Priority?: number;
    
    MaxConcurrency?: string;
    
    MaxErrors?: string;
    
    Status?: MaintenanceWindowExecutionStatus | string;
    
    StatusDetails?: string;
    
    StartTime?: Date;
    
    EndTime?: Date;
}
export interface GetMaintenanceWindowExecutionTaskInvocationRequest {
    
    WindowExecutionId: string | undefined;
    
    TaskId: string | undefined;
    
    InvocationId: string | undefined;
}
export interface GetMaintenanceWindowExecutionTaskInvocationResult {
    
    WindowExecutionId?: string;
    
    TaskExecutionId?: string;
    
    InvocationId?: string;
    
    ExecutionId?: string;
    
    TaskType?: MaintenanceWindowTaskType | string;
    
    Parameters?: string;
    
    Status?: MaintenanceWindowExecutionStatus | string;
    
    StatusDetails?: string;
    
    StartTime?: Date;
    
    EndTime?: Date;
    
    OwnerInformation?: string;
    
    WindowTargetId?: string;
}
export interface GetMaintenanceWindowTaskRequest {
    
    WindowId: string | undefined;
    
    WindowTaskId: string | undefined;
}

export interface MaintenanceWindowAutomationParameters {
    
    DocumentVersion?: string;
    
    Parameters?: Record<string, string[]>;
}

export interface MaintenanceWindowLambdaParameters {
    
    ClientContext?: string;
    
    Qualifier?: string;
    
    Payload?: Uint8Array;
}
export declare enum NotificationEvent {
    ALL = "All",
    CANCELLED = "Cancelled",
    FAILED = "Failed",
    IN_PROGRESS = "InProgress",
    SUCCESS = "Success",
    TIMED_OUT = "TimedOut"
}
export declare enum NotificationType {
    Command = "Command",
    Invocation = "Invocation"
}

export interface NotificationConfig {
    
    NotificationArn?: string;
    
    NotificationEvents?: (NotificationEvent | string)[];
    
    NotificationType?: NotificationType | string;
}

export interface MaintenanceWindowRunCommandParameters {
    
    Comment?: string;
    
    CloudWatchOutputConfig?: CloudWatchOutputConfig;
    
    DocumentHash?: string;
    
    DocumentHashType?: DocumentHashType | string;
    
    DocumentVersion?: string;
    
    NotificationConfig?: NotificationConfig;
    
    OutputS3BucketName?: string;
    
    OutputS3KeyPrefix?: string;
    
    Parameters?: Record<string, string[]>;
    
    ServiceRoleArn?: string;
    
    TimeoutSeconds?: number;
}

export interface MaintenanceWindowStepFunctionsParameters {
    
    Input?: string;
    
    Name?: string;
}

export interface MaintenanceWindowTaskInvocationParameters {
    
    RunCommand?: MaintenanceWindowRunCommandParameters;
    
    Automation?: MaintenanceWindowAutomationParameters;
    
    StepFunctions?: MaintenanceWindowStepFunctionsParameters;
    
    Lambda?: MaintenanceWindowLambdaParameters;
}
export interface GetMaintenanceWindowTaskResult {
    
    WindowId?: string;
    
    WindowTaskId?: string;
    
    Targets?: Target[];
    
    TaskArn?: string;
    
    ServiceRoleArn?: string;
    
    TaskType?: MaintenanceWindowTaskType | string;
    
    TaskParameters?: Record<string, MaintenanceWindowTaskParameterValueExpression>;
    
    TaskInvocationParameters?: MaintenanceWindowTaskInvocationParameters;
    
    Priority?: number;
    
    MaxConcurrency?: string;
    
    MaxErrors?: string;
    
    LoggingInfo?: LoggingInfo;
    
    Name?: string;
    
    Description?: string;
    
    CutoffBehavior?: MaintenanceWindowTaskCutoffBehavior | string;
}
export interface GetOpsItemRequest {
    
    OpsItemId: string | undefined;
}

export interface OpsItem {
    
    CreatedBy?: string;
    
    OpsItemType?: string;
    
    CreatedTime?: Date;
    
    Description?: string;
    
    LastModifiedBy?: string;
    
    LastModifiedTime?: Date;
    
    Notifications?: OpsItemNotification[];
    
    Priority?: number;
    
    RelatedOpsItems?: RelatedOpsItem[];
    
    Status?: OpsItemStatus | string;
    
    OpsItemId?: string;
    
    Version?: string;
    
    Title?: string;
    
    Source?: string;
    
    OperationalData?: Record<string, OpsItemDataValue>;
    
    Category?: string;
    
    Severity?: string;
    
    ActualStartTime?: Date;
    
    ActualEndTime?: Date;
    
    PlannedStartTime?: Date;
    
    PlannedEndTime?: Date;
}
export interface GetOpsItemResponse {
    
    OpsItem?: OpsItem;
}
export interface GetOpsMetadataRequest {
    
    OpsMetadataArn: string | undefined;
    
    MaxResults?: number;
    
    NextToken?: string;
}
export interface GetOpsMetadataResult {
    
    ResourceId?: string;
    
    Metadata?: Record<string, MetadataValue>;
    
    NextToken?: string;
}
export declare enum OpsFilterOperatorType {
    BEGIN_WITH = "BeginWith",
    EQUAL = "Equal",
    EXISTS = "Exists",
    GREATER_THAN = "GreaterThan",
    LESS_THAN = "LessThan",
    NOT_EQUAL = "NotEqual"
}

export interface OpsFilter {
    
    Key: string | undefined;
    
    Values: string[] | undefined;
    
    Type?: OpsFilterOperatorType | string;
}

export interface OpsResultAttribute {
    
    TypeName: string | undefined;
}

export interface OpsEntityItem {
    
    CaptureTime?: string;
    
    Content?: Record<string, string>[];
}

export interface OpsEntity {
    
    Id?: string;
    
    Data?: Record<string, OpsEntityItem>;
}
export interface GetOpsSummaryResult {
    
    Entities?: OpsEntity[];
    
    NextToken?: string;
}
export interface GetParameterRequest {
    
    Name: string | undefined;
    
    WithDecryption?: boolean;
}

export interface Parameter {
    
    Name?: string;
    
    Type?: ParameterType | string;
    
    Value?: string;
    
    Version?: number;
    
    Selector?: string;
    
    SourceResult?: string;
    
    LastModifiedDate?: Date;
    
    ARN?: string;
    
    DataType?: string;
}
export interface GetParameterResult {
    
    Parameter?: Parameter;
}

export declare class InvalidKeyId extends __BaseException {
    readonly name: "InvalidKeyId";
    readonly $fault: "client";
    
    constructor(opts: __ExceptionOptionType<InvalidKeyId, __BaseException>);
}

export declare class ParameterVersionNotFound extends __BaseException {
    readonly name: "ParameterVersionNotFound";
    readonly $fault: "client";
    
    constructor(opts: __ExceptionOptionType<ParameterVersionNotFound, __BaseException>);
}
export interface GetParameterHistoryRequest {
    
    Name: string | undefined;
    
    WithDecryption?: boolean;
    
    MaxResults?: number;
    
    NextToken?: string;
}

export interface ParameterHistory {
    
    Name?: string;
    
    Type?: ParameterType | string;
    
    KeyId?: string;
    
    LastModifiedDate?: Date;
    
    LastModifiedUser?: string;
    
    Description?: string;
    
    Value?: string;
    
    AllowedPattern?: string;
    
    Version?: number;
    
    Labels?: string[];
    
    Tier?: ParameterTier | string;
    
    Policies?: ParameterInlinePolicy[];
    
    DataType?: string;
}
export interface GetParameterHistoryResult {
    
    Parameters?: ParameterHistory[];
    
    NextToken?: string;
}
export interface GetParametersRequest {
    
    Names: string[] | undefined;
    
    WithDecryption?: boolean;
}
export interface GetParametersResult {
    
    Parameters?: Parameter[];
    
    InvalidParameters?: string[];
}
export interface GetParametersByPathRequest {
    
    Path: string | undefined;
    
    Recursive?: boolean;
    
    ParameterFilters?: ParameterStringFilter[];
    
    WithDecryption?: boolean;
    
    MaxResults?: number;
    
    NextToken?: string;
}
export interface GetParametersByPathResult {
    
    Parameters?: Parameter[];
    
    NextToken?: string;
}
export interface GetPatchBaselineRequest {
    
    BaselineId: string | undefined;
}
export interface GetPatchBaselineResult {
    
    BaselineId?: string;
    
    Name?: string;
    
    OperatingSystem?: OperatingSystem | string;
    
    GlobalFilters?: PatchFilterGroup;
    
    ApprovalRules?: PatchRuleGroup;
    
    ApprovedPatches?: string[];
    
    ApprovedPatchesComplianceLevel?: PatchComplianceLevel | string;
    
    ApprovedPatchesEnableNonSecurity?: boolean;
    
    RejectedPatches?: string[];
    
    RejectedPatchesAction?: PatchAction | string;
    
    PatchGroups?: string[];
    
    CreatedDate?: Date;
    
    ModifiedDate?: Date;
    
    Description?: string;
    
    Sources?: PatchSource[];
}
export interface GetPatchBaselineForPatchGroupRequest {
    
    PatchGroup: string | undefined;
    
    OperatingSystem?: OperatingSystem | string;
}
export interface GetPatchBaselineForPatchGroupResult {
    
    BaselineId?: string;
    
    PatchGroup?: string;
    
    OperatingSystem?: OperatingSystem | string;
}

export interface GetServiceSettingRequest {
    
    SettingId: string | undefined;
}

export interface ServiceSetting {
    
    SettingId?: string;
    
    SettingValue?: string;
    
    LastModifiedDate?: Date;
    
    LastModifiedUser?: string;
    
    ARN?: string;
    
    Status?: string;
}

export interface GetServiceSettingResult {
    
    ServiceSetting?: ServiceSetting;
}

export declare class ServiceSettingNotFound extends __BaseException {
    readonly name: "ServiceSettingNotFound";
    readonly $fault: "client";
    Message?: string;
    
    constructor(opts: __ExceptionOptionType<ServiceSettingNotFound, __BaseException>);
}
export interface LabelParameterVersionRequest {
    
    Name: string | undefined;
    
    ParameterVersion?: number;
    
    Labels: string[] | undefined;
}
export interface LabelParameterVersionResult {
    
    InvalidLabels?: string[];
    
    ParameterVersion?: number;
}

export declare class ParameterVersionLabelLimitExceeded extends __BaseException {
    readonly name: "ParameterVersionLabelLimitExceeded";
    readonly $fault: "client";
    
    constructor(opts: __ExceptionOptionType<ParameterVersionLabelLimitExceeded, __BaseException>);
}
export declare enum AssociationFilterKey {
    AssociationId = "AssociationId",
    AssociationName = "AssociationName",
    InstanceId = "InstanceId",
    LastExecutedAfter = "LastExecutedAfter",
    LastExecutedBefore = "LastExecutedBefore",
    Name = "Name",
    ResourceGroupName = "ResourceGroupName",
    Status = "AssociationStatusName"
}

export interface AssociationFilter {
    
    key: AssociationFilterKey | string | undefined;
    
    value: string | undefined;
}
export interface ListAssociationsRequest {
    
    AssociationFilterList?: AssociationFilter[];
    
    MaxResults?: number;
    
    NextToken?: string;
}

export interface Association {
    
    Name?: string;
    
    InstanceId?: string;
    
    AssociationId?: string;
    
    AssociationVersion?: string;
    
    DocumentVersion?: string;
    
    Targets?: Target[];
    
    LastExecutionDate?: Date;
    
    Overview?: AssociationOverview;
    
    ScheduleExpression?: string;
    
    AssociationName?: string;
    
    ScheduleOffset?: number;
    
    TargetMaps?: Record<string, string[]>[];
}
export interface ListAssociationsResult {
    
    Associations?: Association[];
    
    NextToken?: string;
}
export interface ListAssociationVersionsRequest {
    
    AssociationId: string | undefined;
    
    MaxResults?: number;
    
    NextToken?: string;
}

export interface AssociationVersionInfo {
    
    AssociationId?: string;
    
    AssociationVersion?: string;
    
    CreatedDate?: Date;
    
    Name?: string;
    
    DocumentVersion?: string;
    
    Parameters?: Record<string, string[]>;
    
    Targets?: Target[];
    
    ScheduleExpression?: string;
    
    OutputLocation?: InstanceAssociationOutputLocation;
    
    AssociationName?: string;
    
    MaxErrors?: string;
    
    MaxConcurrency?: string;
    
    ComplianceSeverity?: AssociationComplianceSeverity | string;
    
    SyncCompliance?: AssociationSyncCompliance | string;
    
    ApplyOnlyAtCronInterval?: boolean;
    
    CalendarNames?: string[];
    
    TargetLocations?: TargetLocation[];
    
    ScheduleOffset?: number;
    
    TargetMaps?: Record<string, string[]>[];
}
export interface ListAssociationVersionsResult {
    
    AssociationVersions?: AssociationVersionInfo[];
    
    NextToken?: string;
}
export declare enum CommandFilterKey {
    DOCUMENT_NAME = "DocumentName",
    EXECUTION_STAGE = "ExecutionStage",
    INVOKED_AFTER = "InvokedAfter",
    INVOKED_BEFORE = "InvokedBefore",
    STATUS = "Status"
}

export interface CommandFilter {
    
    key: CommandFilterKey | string | undefined;
    
    value: string | undefined;
}
export interface ListCommandInvocationsRequest {
    
    CommandId?: string;
    
    InstanceId?: string;
    
    MaxResults?: number;
    
    NextToken?: string;
    
    Filters?: CommandFilter[];
    
    Details?: boolean;
}
export declare enum CommandPluginStatus {
    CANCELLED = "Cancelled",
    FAILED = "Failed",
    IN_PROGRESS = "InProgress",
    PENDING = "Pending",
    SUCCESS = "Success",
    TIMED_OUT = "TimedOut"
}

export interface CommandPlugin {
    
    Name?: string;
    
    Status?: CommandPluginStatus | string;
    
    StatusDetails?: string;
    
    ResponseCode?: number;
    
    ResponseStartDateTime?: Date;
    
    ResponseFinishDateTime?: Date;
    
    Output?: string;
    
    StandardOutputUrl?: string;
    
    StandardErrorUrl?: string;
    
    OutputS3Region?: string;
    
    OutputS3BucketName?: string;
    
    OutputS3KeyPrefix?: string;
}

export interface CommandInvocation {
    
    CommandId?: string;
    
    InstanceId?: string;
    
    InstanceName?: string;
    
    Comment?: string;
    
    DocumentName?: string;
    
    DocumentVersion?: string;
    
    RequestedDateTime?: Date;
    
    Status?: CommandInvocationStatus | string;
    
    StatusDetails?: string;
    
    TraceOutput?: string;
    
    StandardOutputUrl?: string;
    
    StandardErrorUrl?: string;
    
    CommandPlugins?: CommandPlugin[];
    
    ServiceRole?: string;
    
    NotificationConfig?: NotificationConfig;
    
    CloudWatchOutputConfig?: CloudWatchOutputConfig;
}
export interface ListCommandInvocationsResult {
    
    CommandInvocations?: CommandInvocation[];
    
    NextToken?: string;
}
export interface ListCommandsRequest {
    
    CommandId?: string;
    
    InstanceId?: string;
    
    MaxResults?: number;
    
    NextToken?: string;
    
    Filters?: CommandFilter[];
}
export declare enum CommandStatus {
    CANCELLED = "Cancelled",
    CANCELLING = "Cancelling",
    FAILED = "Failed",
    IN_PROGRESS = "InProgress",
    PENDING = "Pending",
    SUCCESS = "Success",
    TIMED_OUT = "TimedOut"
}

export interface Command {
    
    CommandId?: string;
    
    DocumentName?: string;
    
    DocumentVersion?: string;
    
    Comment?: string;
    
    ExpiresAfter?: Date;
    
    Parameters?: Record<string, string[]>;
    
    InstanceIds?: string[];
    
    Targets?: Target[];
    
    RequestedDateTime?: Date;
    
    Status?: CommandStatus | string;
    
    StatusDetails?: string;
    
    OutputS3Region?: string;
    
    OutputS3BucketName?: string;
    
    OutputS3KeyPrefix?: string;
    
    MaxConcurrency?: string;
    
    MaxErrors?: string;
    
    TargetCount?: number;
    
    CompletedCount?: number;
    
    ErrorCount?: number;
    
    DeliveryTimedOutCount?: number;
    
    ServiceRole?: string;
    
    NotificationConfig?: NotificationConfig;
    
    CloudWatchOutputConfig?: CloudWatchOutputConfig;
    
    TimeoutSeconds?: number;
}
export interface ListCommandsResult {
    
    Commands?: Command[];
    
    NextToken?: string;
}
export declare enum ComplianceQueryOperatorType {
    BeginWith = "BEGIN_WITH",
    Equal = "EQUAL",
    GreaterThan = "GREATER_THAN",
    LessThan = "LESS_THAN",
    NotEqual = "NOT_EQUAL"
}

export interface ComplianceStringFilter {
    
    Key?: string;
    
    Values?: string[];
    
    Type?: ComplianceQueryOperatorType | string;
}
export interface ListComplianceItemsRequest {
    
    Filters?: ComplianceStringFilter[];
    
    ResourceIds?: string[];
    
    ResourceTypes?: string[];
    
    NextToken?: string;
    
    MaxResults?: number;
}

export interface ComplianceExecutionSummary {
    
    ExecutionTime: Date | undefined;
    
    ExecutionId?: string;
    
    ExecutionType?: string;
}
export declare enum ComplianceSeverity {
    Critical = "CRITICAL",
    High = "HIGH",
    Informational = "INFORMATIONAL",
    Low = "LOW",
    Medium = "MEDIUM",
    Unspecified = "UNSPECIFIED"
}
export declare enum ComplianceStatus {
    Compliant = "COMPLIANT",
    NonCompliant = "NON_COMPLIANT"
}

export interface ComplianceItem {
    
    ComplianceType?: string;
    
    ResourceType?: string;
    
    ResourceId?: string;
    
    Id?: string;
    
    Title?: string;
    
    Status?: ComplianceStatus | string;
    
    Severity?: ComplianceSeverity | string;
    
    ExecutionSummary?: ComplianceExecutionSummary;
    
    Details?: Record<string, string>;
}
export interface ListComplianceItemsResult {
    
    ComplianceItems?: ComplianceItem[];
    
    NextToken?: string;
}
export interface ListComplianceSummariesRequest {
    
    Filters?: ComplianceStringFilter[];
    
    NextToken?: string;
    
    MaxResults?: number;
}

export interface SeveritySummary {
    
    CriticalCount?: number;
    
    HighCount?: number;
    
    MediumCount?: number;
    
    LowCount?: number;
    
    InformationalCount?: number;
    
    UnspecifiedCount?: number;
}

export interface CompliantSummary {
    
    CompliantCount?: number;
    
    SeveritySummary?: SeveritySummary;
}

export interface NonCompliantSummary {
    
    NonCompliantCount?: number;
    
    SeveritySummary?: SeveritySummary;
}

export interface ComplianceSummaryItem {
    
    ComplianceType?: string;
    
    CompliantSummary?: CompliantSummary;
    
    NonCompliantSummary?: NonCompliantSummary;
}
export interface ListComplianceSummariesResult {
    
    ComplianceSummaryItems?: ComplianceSummaryItem[];
    
    NextToken?: string;
}
export declare enum DocumentMetadataEnum {
    DocumentReviews = "DocumentReviews"
}
export interface ListDocumentMetadataHistoryRequest {
    
    Name: string | undefined;
    
    DocumentVersion?: string;
    
    Metadata: DocumentMetadataEnum | string | undefined;
    
    NextToken?: string;
    
    MaxResults?: number;
}
export declare enum DocumentReviewCommentType {
    Comment = "Comment"
}

export interface DocumentReviewCommentSource {
    
    Type?: DocumentReviewCommentType | string;
    
    Content?: string;
}

export interface DocumentReviewerResponseSource {
    
    CreateTime?: Date;
    
    UpdatedTime?: Date;
    
    ReviewStatus?: ReviewStatus | string;
    
    Comment?: DocumentReviewCommentSource[];
    
    Reviewer?: string;
}

export interface DocumentMetadataResponseInfo {
    
    ReviewerResponse?: DocumentReviewerResponseSource[];
}
export interface ListDocumentMetadataHistoryResponse {
    
    Name?: string;
    
    DocumentVersion?: string;
    
    Author?: string;
    
    Metadata?: DocumentMetadataResponseInfo;
    
    NextToken?: string;
}
export declare enum DocumentFilterKey {
    DocumentType = "DocumentType",
    Name = "Name",
    Owner = "Owner",
    PlatformTypes = "PlatformTypes"
}

export interface DocumentFilter {
    
    key: DocumentFilterKey | string | undefined;
    
    value: string | undefined;
}

export interface DocumentKeyValuesFilter {
    
    Key?: string;
    
    Values?: string[];
}
export interface ListDocumentsRequest {
    
    DocumentFilterList?: DocumentFilter[];
    
    Filters?: DocumentKeyValuesFilter[];
    
    MaxResults?: number;
    
    NextToken?: string;
}

export interface DocumentIdentifier {
    
    Name?: string;
    
    CreatedDate?: Date;
    
    DisplayName?: string;
    
    Owner?: string;
    
    VersionName?: string;
    
    PlatformTypes?: (PlatformType | string)[];
    
    DocumentVersion?: string;
    
    DocumentType?: DocumentType | string;
    
    SchemaVersion?: string;
    
    DocumentFormat?: DocumentFormat | string;
    
    TargetType?: string;
    
    Tags?: Tag[];
    
    Requires?: DocumentRequires[];
    
    ReviewStatus?: ReviewStatus | string;
    
    Author?: string;
}
export interface ListDocumentsResult {
    
    DocumentIdentifiers?: DocumentIdentifier[];
    
    NextToken?: string;
}
export interface ListDocumentVersionsRequest {
    
    Name: string | undefined;
    
    MaxResults?: number;
    
    NextToken?: string;
}

export interface DocumentVersionInfo {
    
    Name?: string;
    
    DisplayName?: string;
    
    DocumentVersion?: string;
    
    VersionName?: string;
    
    CreatedDate?: Date;
    
    IsDefaultVersion?: boolean;
    
    DocumentFormat?: DocumentFormat | string;
    
    Status?: DocumentStatus | string;
    
    StatusInformation?: string;
    
    ReviewStatus?: ReviewStatus | string;
}
export interface ListDocumentVersionsResult {
    
    DocumentVersions?: DocumentVersionInfo[];
    
    NextToken?: string;
}
export interface ListInventoryEntriesRequest {
    
    InstanceId: string | undefined;
    
    TypeName: string | undefined;
    
    Filters?: InventoryFilter[];
    
    NextToken?: string;
    
    MaxResults?: number;
}
export interface ListInventoryEntriesResult {
    
    TypeName?: string;
    
    InstanceId?: string;
    
    SchemaVersion?: string;
    
    CaptureTime?: string;
    
    Entries?: Record<string, string>[];
    
    NextToken?: string;
}
export declare enum OpsItemEventFilterKey {
    OPSITEM_ID = "OpsItemId"
}
export declare enum OpsItemEventFilterOperator {
    EQUAL = "Equal"
}

export interface OpsItemEventFilter {
    
    Key: OpsItemEventFilterKey | string | undefined;
    
    Values: string[] | undefined;
    
    Operator: OpsItemEventFilterOperator | string | undefined;
}
export interface ListOpsItemEventsRequest {
    
    Filters?: OpsItemEventFilter[];
    
    MaxResults?: number;
    
    NextToken?: string;
}

export interface OpsItemIdentity {
    
    Arn?: string;
}

export interface OpsItemEventSummary {
    
    OpsItemId?: string;
    
    EventId?: string;
    
    Source?: string;
    
    DetailType?: string;
    
    Detail?: string;
    
    CreatedBy?: OpsItemIdentity;
    
    CreatedTime?: Date;
}
export interface ListOpsItemEventsResponse {
    
    NextToken?: string;
    
    Summaries?: OpsItemEventSummary[];
}
export declare enum OpsItemRelatedItemsFilterKey {
    ASSOCIATION_ID = "AssociationId",
    RESOURCE_TYPE = "ResourceType",
    RESOURCE_URI = "ResourceUri"
}
export declare enum OpsItemRelatedItemsFilterOperator {
    EQUAL = "Equal"
}

export interface OpsItemRelatedItemsFilter {
    
    Key: OpsItemRelatedItemsFilterKey | string | undefined;
    
    Values: string[] | undefined;
    
    Operator: OpsItemRelatedItemsFilterOperator | string | undefined;
}
export interface ListOpsItemRelatedItemsRequest {
    
    OpsItemId?: string;
    
    Filters?: OpsItemRelatedItemsFilter[];
    
    MaxResults?: number;
    
    NextToken?: string;
}

export interface OpsItemRelatedItemSummary {
    
    OpsItemId?: string;
    
    AssociationId?: string;
    
    ResourceType?: string;
    
    AssociationType?: string;
    
    ResourceUri?: string;
    
    CreatedBy?: OpsItemIdentity;
    
    CreatedTime?: Date;
    
    LastModifiedBy?: OpsItemIdentity;
    
    LastModifiedTime?: Date;
}
export interface ListOpsItemRelatedItemsResponse {
    
    NextToken?: string;
    
    Summaries?: OpsItemRelatedItemSummary[];
}

export interface OpsMetadataFilter {
    
    Key: string | undefined;
    
    Values: string[] | undefined;
}
export interface ListOpsMetadataRequest {
    
    Filters?: OpsMetadataFilter[];
    
    MaxResults?: number;
    
    NextToken?: string;
}

export interface OpsMetadata {
    
    ResourceId?: string;
    
    OpsMetadataArn?: string;
    
    LastModifiedDate?: Date;
    
    LastModifiedUser?: string;
    
    CreationDate?: Date;
}
export interface ListOpsMetadataResult {
    
    OpsMetadataList?: OpsMetadata[];
    
    NextToken?: string;
}
export interface ListResourceComplianceSummariesRequest {
    
    Filters?: ComplianceStringFilter[];
    
    NextToken?: string;
    
    MaxResults?: number;
}

export interface ResourceComplianceSummaryItem {
    
    ComplianceType?: string;
    
    ResourceType?: string;
    
    ResourceId?: string;
    
    Status?: ComplianceStatus | string;
    
    OverallSeverity?: ComplianceSeverity | string;
    
    ExecutionSummary?: ComplianceExecutionSummary;
    
    CompliantSummary?: CompliantSummary;
    
    NonCompliantSummary?: NonCompliantSummary;
}
export interface ListResourceComplianceSummariesResult {
    
    ResourceComplianceSummaryItems?: ResourceComplianceSummaryItem[];
    
    NextToken?: string;
}
export interface ListResourceDataSyncRequest {
    
    SyncType?: string;
    
    NextToken?: string;
    
    MaxResults?: number;
}
export declare enum LastResourceDataSyncStatus {
    FAILED = "Failed",
    INPROGRESS = "InProgress",
    SUCCESSFUL = "Successful"
}

export interface ResourceDataSyncSourceWithState {
    
    SourceType?: string;
    
    AwsOrganizationsSource?: ResourceDataSyncAwsOrganizationsSource;
    
    SourceRegions?: string[];
    
    IncludeFutureRegions?: boolean;
    
    State?: string;
    
    EnableAllOpsDataSources?: boolean;
}

export interface ResourceDataSyncItem {
    
    SyncName?: string;
    
    SyncType?: string;
    
    SyncSource?: ResourceDataSyncSourceWithState;
    
    S3Destination?: ResourceDataSyncS3Destination;
    
    LastSyncTime?: Date;
    
    LastSuccessfulSyncTime?: Date;
    
    SyncLastModifiedTime?: Date;
    
    LastStatus?: LastResourceDataSyncStatus | string;
    
    SyncCreatedTime?: Date;
    
    LastSyncStatusMessage?: string;
}
export interface ListResourceDataSyncResult {
    
    ResourceDataSyncItems?: ResourceDataSyncItem[];
    
    NextToken?: string;
}
export interface ListTagsForResourceRequest {
    
    ResourceType: ResourceTypeForTagging | string | undefined;
    
    ResourceId: string | undefined;
}
export interface ListTagsForResourceResult {
    
    TagList?: Tag[];
}

export declare class DocumentPermissionLimit extends __BaseException {
    readonly name: "DocumentPermissionLimit";
    readonly $fault: "client";
    Message?: string;
    
    constructor(opts: __ExceptionOptionType<DocumentPermissionLimit, __BaseException>);
}
export interface ModifyDocumentPermissionRequest {
    
    Name: string | undefined;
    
    PermissionType: DocumentPermissionType | string | undefined;
    
    AccountIdsToAdd?: string[];
    
    AccountIdsToRemove?: string[];
    
    SharedDocumentVersion?: string;
}
export interface ModifyDocumentPermissionResponse {
}

export declare class ComplianceTypeCountLimitExceededException extends __BaseException {
    readonly name: "ComplianceTypeCountLimitExceededException";
    readonly $fault: "client";
    Message?: string;
    
    constructor(opts: __ExceptionOptionType<ComplianceTypeCountLimitExceededException, __BaseException>);
}

export declare class InvalidItemContentException extends __BaseException {
    readonly name: "InvalidItemContentException";
    readonly $fault: "client";
    TypeName?: string;
    Message?: string;
    
    constructor(opts: __ExceptionOptionType<InvalidItemContentException, __BaseException>);
}

export declare class ItemSizeLimitExceededException extends __BaseException {
    readonly name: "ItemSizeLimitExceededException";
    readonly $fault: "client";
    TypeName?: string;
    Message?: string;
    
    constructor(opts: __ExceptionOptionType<ItemSizeLimitExceededException, __BaseException>);
}

export interface ComplianceItemEntry {
    
    Id?: string;
    
    Title?: string;
    
    Severity: ComplianceSeverity | string | undefined;
    
    Status: ComplianceStatus | string | undefined;
    
    Details?: Record<string, string>;
}
export declare enum ComplianceUploadType {
    Complete = "COMPLETE",
    Partial = "PARTIAL"
}
export interface PutComplianceItemsRequest {
    
    ResourceId: string | undefined;
    
    ResourceType: string | undefined;
    
    ComplianceType: string | undefined;
    
    ExecutionSummary: ComplianceExecutionSummary | undefined;
    
    Items: ComplianceItemEntry[] | undefined;
    
    ItemContentHash?: string;
    
    UploadType?: ComplianceUploadType | string;
}
export interface PutComplianceItemsResult {
}

export declare class TotalSizeLimitExceededException extends __BaseException {
    readonly name: "TotalSizeLimitExceededException";
    readonly $fault: "client";
    Message?: string;
    
    constructor(opts: __ExceptionOptionType<TotalSizeLimitExceededException, __BaseException>);
}

export declare class CustomSchemaCountLimitExceededException extends __BaseException {
    readonly name: "CustomSchemaCountLimitExceededException";
    readonly $fault: "client";
    Message?: string;
    
    constructor(opts: __ExceptionOptionType<CustomSchemaCountLimitExceededException, __BaseException>);
}

export declare class InvalidInventoryItemContextException extends __BaseException {
    readonly name: "InvalidInventoryItemContextException";
    readonly $fault: "client";
    Message?: string;
    
    constructor(opts: __ExceptionOptionType<InvalidInventoryItemContextException, __BaseException>);
}

export declare class ItemContentMismatchException extends __BaseException {
    readonly name: "ItemContentMismatchException";
    readonly $fault: "client";
    TypeName?: string;
    Message?: string;
    
    constructor(opts: __ExceptionOptionType<ItemContentMismatchException, __BaseException>);
}

export interface InventoryItem {
    
    TypeName: string | undefined;
    
    SchemaVersion: string | undefined;
    
    CaptureTime: string | undefined;
    
    ContentHash?: string;
    
    Content?: Record<string, string>[];
    
    Context?: Record<string, string>;
}
export interface PutInventoryRequest {
    
    InstanceId: string | undefined;
    
    Items: InventoryItem[] | undefined;
}
export interface PutInventoryResult {
    
    Message?: string;
}

export declare class SubTypeCountLimitExceededException extends __BaseException {
    readonly name: "SubTypeCountLimitExceededException";
    readonly $fault: "client";
    Message?: string;
    
    constructor(opts: __ExceptionOptionType<SubTypeCountLimitExceededException, __BaseException>);
}

export declare class UnsupportedInventoryItemContextException extends __BaseException {
    readonly name: "UnsupportedInventoryItemContextException";
    readonly $fault: "client";
    TypeName?: string;
    Message?: string;
    
    constructor(opts: __ExceptionOptionType<UnsupportedInventoryItemContextException, __BaseException>);
}

export declare class UnsupportedInventorySchemaVersionException extends __BaseException {
    readonly name: "UnsupportedInventorySchemaVersionException";
    readonly $fault: "client";
    Message?: string;
    
    constructor(opts: __ExceptionOptionType<UnsupportedInventorySchemaVersionException, __BaseException>);
}

export declare class HierarchyLevelLimitExceededException extends __BaseException {
    readonly name: "HierarchyLevelLimitExceededException";
    readonly $fault: "client";
    
    constructor(opts: __ExceptionOptionType<HierarchyLevelLimitExceededException, __BaseException>);
}

export declare class HierarchyTypeMismatchException extends __BaseException {
    readonly name: "HierarchyTypeMismatchException";
    readonly $fault: "client";
    
    constructor(opts: __ExceptionOptionType<HierarchyTypeMismatchException, __BaseException>);
}

export declare class IncompatiblePolicyException extends __BaseException {
    readonly name: "IncompatiblePolicyException";
    readonly $fault: "client";
    
    constructor(opts: __ExceptionOptionType<IncompatiblePolicyException, __BaseException>);
}

export declare class InvalidAllowedPatternException extends __BaseException {
    readonly name: "InvalidAllowedPatternException";
    readonly $fault: "client";
    
    constructor(opts: __ExceptionOptionType<InvalidAllowedPatternException, __BaseException>);
}

export declare class InvalidPolicyAttributeException extends __BaseException {
    readonly name: "InvalidPolicyAttributeException";
    readonly $fault: "client";
    
    constructor(opts: __ExceptionOptionType<InvalidPolicyAttributeException, __BaseException>);
}

export declare class InvalidPolicyTypeException extends __BaseException {
    readonly name: "InvalidPolicyTypeException";
    readonly $fault: "client";
    
    constructor(opts: __ExceptionOptionType<InvalidPolicyTypeException, __BaseException>);
}

export declare class ParameterAlreadyExists extends __BaseException {
    readonly name: "ParameterAlreadyExists";
    readonly $fault: "client";
    
    constructor(opts: __ExceptionOptionType<ParameterAlreadyExists, __BaseException>);
}

export declare class ParameterLimitExceeded extends __BaseException {
    readonly name: "ParameterLimitExceeded";
    readonly $fault: "client";
    
    constructor(opts: __ExceptionOptionType<ParameterLimitExceeded, __BaseException>);
}

export declare class ParameterMaxVersionLimitExceeded extends __BaseException {
    readonly name: "ParameterMaxVersionLimitExceeded";
    readonly $fault: "client";
    
    constructor(opts: __ExceptionOptionType<ParameterMaxVersionLimitExceeded, __BaseException>);
}

export declare class ParameterPatternMismatchException extends __BaseException {
    readonly name: "ParameterPatternMismatchException";
    readonly $fault: "client";
    
    constructor(opts: __ExceptionOptionType<ParameterPatternMismatchException, __BaseException>);
}

export declare class PoliciesLimitExceededException extends __BaseException {
    readonly name: "PoliciesLimitExceededException";
    readonly $fault: "client";
    
    constructor(opts: __ExceptionOptionType<PoliciesLimitExceededException, __BaseException>);
}
export interface PutParameterRequest {
    
    Name: string | undefined;
    
    Description?: string;
    
    Value: string | undefined;
    
    Type?: ParameterType | string;
    
    KeyId?: string;
    
    Overwrite?: boolean;
    
    AllowedPattern?: string;
    
    Tags?: Tag[];
    
    Tier?: ParameterTier | string;
    
    Policies?: string;
    
    DataType?: string;
}
export interface PutParameterResult {
    
    Version?: number;
    
    Tier?: ParameterTier | string;
}

export declare class UnsupportedParameterType extends __BaseException {
    readonly name: "UnsupportedParameterType";
    readonly $fault: "client";
    
    constructor(opts: __ExceptionOptionType<UnsupportedParameterType, __BaseException>);
}
export interface RegisterDefaultPatchBaselineRequest {
    
    BaselineId: string | undefined;
}
export interface RegisterDefaultPatchBaselineResult {
    
    BaselineId?: string;
}
export interface RegisterPatchBaselineForPatchGroupRequest {
    
    BaselineId: string | undefined;
    
    PatchGroup: string | undefined;
}
export interface RegisterPatchBaselineForPatchGroupResult {
    
    BaselineId?: string;
    
    PatchGroup?: string;
}
export interface RegisterTargetWithMaintenanceWindowRequest {
    
    WindowId: string | undefined;
    
    ResourceType: MaintenanceWindowResourceType | string | undefined;
    
    Targets: Target[] | undefined;
    
    OwnerInformation?: string;
    
    Name?: string;
    
    Description?: string;
    
    ClientToken?: string;
}
export interface RegisterTargetWithMaintenanceWindowResult {
    
    WindowTargetId?: string;
}

export declare class FeatureNotAvailableException extends __BaseException {
    readonly name: "FeatureNotAvailableException";
    readonly $fault: "client";
    Message?: string;
    
    constructor(opts: __ExceptionOptionType<FeatureNotAvailableException, __BaseException>);
}
export interface RegisterTaskWithMaintenanceWindowRequest {
    
    WindowId: string | undefined;
    
    Targets?: Target[];
    
    TaskArn: string | undefined;
    
    ServiceRoleArn?: string;
    
    TaskType: MaintenanceWindowTaskType | string | undefined;
    
    TaskParameters?: Record<string, MaintenanceWindowTaskParameterValueExpression>;
    
    TaskInvocationParameters?: MaintenanceWindowTaskInvocationParameters;
    
    Priority?: number;
    
    MaxConcurrency?: string;
    
    MaxErrors?: string;
    
    LoggingInfo?: LoggingInfo;
    
    Name?: string;
    
    Description?: string;
    
    ClientToken?: string;
    
    CutoffBehavior?: MaintenanceWindowTaskCutoffBehavior | string;
}
export interface RegisterTaskWithMaintenanceWindowResult {
    
    WindowTaskId?: string;
}
export interface RemoveTagsFromResourceRequest {
    
    ResourceType: ResourceTypeForTagging | string | undefined;
    
    ResourceId: string | undefined;
    
    TagKeys: string[] | undefined;
}
export interface RemoveTagsFromResourceResult {
}

export interface ResetServiceSettingRequest {
    
    SettingId: string | undefined;
}

export interface ResetServiceSettingResult {
    
    ServiceSetting?: ServiceSetting;
}
export interface ResumeSessionRequest {
    
    SessionId: string | undefined;
}
export interface ResumeSessionResponse {
    
    SessionId?: string;
    
    TokenValue?: string;
    
    StreamUrl?: string;
}

export declare class AutomationStepNotFoundException extends __BaseException {
    readonly name: "AutomationStepNotFoundException";
    readonly $fault: "client";
    Message?: string;
    
    constructor(opts: __ExceptionOptionType<AutomationStepNotFoundException, __BaseException>);
}

export declare class InvalidAutomationSignalException extends __BaseException {
    readonly name: "InvalidAutomationSignalException";
    readonly $fault: "client";
    Message?: string;
    
    constructor(opts: __ExceptionOptionType<InvalidAutomationSignalException, __BaseException>);
}
export declare enum SignalType {
    APPROVE = "Approve",
    REJECT = "Reject",
    RESUME = "Resume",
    START_STEP = "StartStep",
    STOP_STEP = "StopStep"
}
export interface SendAutomationSignalRequest {
    
    AutomationExecutionId: string | undefined;
    
    SignalType: SignalType | string | undefined;
    
    Payload?: Record<string, string[]>;
}
export interface SendAutomationSignalResult {
}

export declare class InvalidNotificationConfig extends __BaseException {
    readonly name: "InvalidNotificationConfig";
    readonly $fault: "client";
    Message?: string;
    
    constructor(opts: __ExceptionOptionType<InvalidNotificationConfig, __BaseException>);
}

export declare class InvalidOutputFolder extends __BaseException {
    readonly name: "InvalidOutputFolder";
    readonly $fault: "client";
    
    constructor(opts: __ExceptionOptionType<InvalidOutputFolder, __BaseException>);
}

export declare class InvalidRole extends __BaseException {
    readonly name: "InvalidRole";
    readonly $fault: "client";
    Message?: string;
    
    constructor(opts: __ExceptionOptionType<InvalidRole, __BaseException>);
}
export interface SendCommandRequest {
    
    InstanceIds?: string[];
    
    Targets?: Target[];
    
    DocumentName: string | undefined;
    
    DocumentVersion?: string;
    
    DocumentHash?: string;
    
    DocumentHashType?: DocumentHashType | string;
    
    TimeoutSeconds?: number;
    
    Comment?: string;
    
    Parameters?: Record<string, string[]>;
    
    OutputS3Region?: string;
    
    OutputS3BucketName?: string;
    
    OutputS3KeyPrefix?: string;
    
    MaxConcurrency?: string;
    
    MaxErrors?: string;
    
    ServiceRoleArn?: string;
    
    NotificationConfig?: NotificationConfig;
    
    CloudWatchOutputConfig?: CloudWatchOutputConfig;
}
export interface SendCommandResult {
    
    Command?: Command;
}

export declare class InvalidAssociation extends __BaseException {
    readonly name: "InvalidAssociation";
    readonly $fault: "client";
    Message?: string;
    
    constructor(opts: __ExceptionOptionType<InvalidAssociation, __BaseException>);
}
export interface StartAssociationsOnceRequest {
    
    AssociationIds: string[] | undefined;
}
export interface StartAssociationsOnceResult {
}

export declare class AutomationDefinitionNotFoundException extends __BaseException {
    readonly name: "AutomationDefinitionNotFoundException";
    readonly $fault: "client";
    Message?: string;
    
    constructor(opts: __ExceptionOptionType<AutomationDefinitionNotFoundException, __BaseException>);
}

export declare class AutomationDefinitionVersionNotFoundException extends __BaseException {
    readonly name: "AutomationDefinitionVersionNotFoundException";
    readonly $fault: "client";
    Message?: string;
    
    constructor(opts: __ExceptionOptionType<AutomationDefinitionVersionNotFoundException, __BaseException>);
}

export declare class AutomationExecutionLimitExceededException extends __BaseException {
    readonly name: "AutomationExecutionLimitExceededException";
    readonly $fault: "client";
    Message?: string;
    
    constructor(opts: __ExceptionOptionType<AutomationExecutionLimitExceededException, __BaseException>);
}

export declare class InvalidAutomationExecutionParametersException extends __BaseException {
    readonly name: "InvalidAutomationExecutionParametersException";
    readonly $fault: "client";
    Message?: string;
    
    constructor(opts: __ExceptionOptionType<InvalidAutomationExecutionParametersException, __BaseException>);
}
export interface StartAutomationExecutionRequest {
    
    DocumentName: string | undefined;
    
    DocumentVersion?: string;
    
    Parameters?: Record<string, string[]>;
    
    ClientToken?: string;
    
    Mode?: ExecutionMode | string;
    
    TargetParameterName?: string;
    
    Targets?: Target[];
    
    TargetMaps?: Record<string, string[]>[];
    
    MaxConcurrency?: string;
    
    MaxErrors?: string;
    
    TargetLocations?: TargetLocation[];
    
    Tags?: Tag[];
}
export interface StartAutomationExecutionResult {
    
    AutomationExecutionId?: string;
}

export declare class AutomationDefinitionNotApprovedException extends __BaseException {
    readonly name: "AutomationDefinitionNotApprovedException";
    readonly $fault: "client";
    Message?: string;
    
    constructor(opts: __ExceptionOptionType<AutomationDefinitionNotApprovedException, __BaseException>);
}
export interface StartChangeRequestExecutionRequest {
    
    ScheduledTime?: Date;
    
    DocumentName: string | undefined;
    
    DocumentVersion?: string;
    
    Parameters?: Record<string, string[]>;
    
    ChangeRequestName?: string;
    
    ClientToken?: string;
    
    AutoApprove?: boolean;
    
    Runbooks: Runbook[] | undefined;
    
    Tags?: Tag[];
    
    ScheduledEndTime?: Date;
    
    ChangeDetails?: string;
}
export interface StartChangeRequestExecutionResult {
    
    AutomationExecutionId?: string;
}
export interface StartSessionRequest {
    
    Target: string | undefined;
    
    DocumentName?: string;
    
    Reason?: string;
    
    Parameters?: Record<string, string[]>;
}
export interface StartSessionResponse {
    
    SessionId?: string;
    
    TokenValue?: string;
    
    StreamUrl?: string;
}

export declare class TargetNotConnected extends __BaseException {
    readonly name: "TargetNotConnected";
    readonly $fault: "client";
    Message?: string;
    
    constructor(opts: __ExceptionOptionType<TargetNotConnected, __BaseException>);
}

export declare class InvalidAutomationStatusUpdateException extends __BaseException {
    readonly name: "InvalidAutomationStatusUpdateException";
    readonly $fault: "client";
    Message?: string;
    
    constructor(opts: __ExceptionOptionType<InvalidAutomationStatusUpdateException, __BaseException>);
}
export declare enum StopType {
    CANCEL = "Cancel",
    COMPLETE = "Complete"
}
export interface StopAutomationExecutionRequest {
    
    AutomationExecutionId: string | undefined;
    
    Type?: StopType | string;
}
export interface StopAutomationExecutionResult {
}
export interface TerminateSessionRequest {
    
    SessionId: string | undefined;
}
export interface TerminateSessionResponse {
    
    SessionId?: string;
}
export interface UnlabelParameterVersionRequest {
    
    Name: string | undefined;
    
    ParameterVersion: number | undefined;
    
    Labels: string[] | undefined;
}
export interface UnlabelParameterVersionResult {
    
    RemovedLabels?: string[];
    
    InvalidLabels?: string[];
}

export declare class AssociationVersionLimitExceeded extends __BaseException {
    readonly name: "AssociationVersionLimitExceeded";
    readonly $fault: "client";
    Message?: string;
    
    constructor(opts: __ExceptionOptionType<AssociationVersionLimitExceeded, __BaseException>);
}

export declare class InvalidUpdate extends __BaseException {
    readonly name: "InvalidUpdate";
    readonly $fault: "client";
    Message?: string;
    
    constructor(opts: __ExceptionOptionType<InvalidUpdate, __BaseException>);
}
export interface UpdateAssociationRequest {
    
    AssociationId: string | undefined;
    
    Parameters?: Record<string, string[]>;
    
    DocumentVersion?: string;
    
    ScheduleExpression?: string;
    
    OutputLocation?: InstanceAssociationOutputLocation;
    
    Name?: string;
    
    Targets?: Target[];
    
    AssociationName?: string;
    
    AssociationVersion?: string;
    
    AutomationTargetParameterName?: string;
    
    MaxErrors?: string;
    
    MaxConcurrency?: string;
    
    ComplianceSeverity?: AssociationComplianceSeverity | string;
    
    SyncCompliance?: AssociationSyncCompliance | string;
    
    ApplyOnlyAtCronInterval?: boolean;
    
    CalendarNames?: string[];
    
    TargetLocations?: TargetLocation[];
    
    ScheduleOffset?: number;
    
    TargetMaps?: Record<string, string[]>[];
}
export interface UpdateAssociationResult {
    
    AssociationDescription?: AssociationDescription;
}

export declare class StatusUnchanged extends __BaseException {
    readonly name: "StatusUnchanged";
    readonly $fault: "client";
    
    constructor(opts: __ExceptionOptionType<StatusUnchanged, __BaseException>);
}
export interface UpdateAssociationStatusRequest {
    
    Name: string | undefined;
    
    InstanceId: string | undefined;
    
    AssociationStatus: AssociationStatus | undefined;
}
export interface UpdateAssociationStatusResult {
    
    AssociationDescription?: AssociationDescription;
}

export declare class DocumentVersionLimitExceeded extends __BaseException {
    readonly name: "DocumentVersionLimitExceeded";
    readonly $fault: "client";
    Message?: string;
    
    constructor(opts: __ExceptionOptionType<DocumentVersionLimitExceeded, __BaseException>);
}

export declare class DuplicateDocumentContent extends __BaseException {
    readonly name: "DuplicateDocumentContent";
    readonly $fault: "client";
    Message?: string;
    
    constructor(opts: __ExceptionOptionType<DuplicateDocumentContent, __BaseException>);
}

export declare class DuplicateDocumentVersionName extends __BaseException {
    readonly name: "DuplicateDocumentVersionName";
    readonly $fault: "client";
    Message?: string;
    
    constructor(opts: __ExceptionOptionType<DuplicateDocumentVersionName, __BaseException>);
}
export interface UpdateDocumentRequest {
    
    Content: string | undefined;
    
    Attachments?: AttachmentsSource[];
    
    Name: string | undefined;
    
    DisplayName?: string;
    
    VersionName?: string;
    
    DocumentVersion?: string;
    
    DocumentFormat?: DocumentFormat | string;
    
    TargetType?: string;
}
export interface UpdateDocumentResult {
    
    DocumentDescription?: DocumentDescription;
}
export interface UpdateDocumentDefaultVersionRequest {
    
    Name: string | undefined;
    
    DocumentVersion: string | undefined;
}

export interface DocumentDefaultVersionDescription {
    
    Name?: string;
    
    DefaultVersion?: string;
    
    DefaultVersionName?: string;
}
export interface UpdateDocumentDefaultVersionResult {
    
    Description?: DocumentDefaultVersionDescription;
}
export declare enum DocumentReviewAction {
    Approve = "Approve",
    Reject = "Reject",
    SendForReview = "SendForReview",
    UpdateReview = "UpdateReview"
}

export interface DocumentReviews {
    
    Action: DocumentReviewAction | string | undefined;
    
    Comment?: DocumentReviewCommentSource[];
}

export declare const ParameterMetadataFilterSensitiveLog: (obj: ParameterMetadata) => any;

export declare const DescribeParametersResultFilterSensitiveLog: (obj: DescribeParametersResult) => any;

export declare const DescribePatchBaselinesRequestFilterSensitiveLog: (obj: DescribePatchBaselinesRequest) => any;

export declare const PatchBaselineIdentityFilterSensitiveLog: (obj: PatchBaselineIdentity) => any;

export declare const DescribePatchBaselinesResultFilterSensitiveLog: (obj: DescribePatchBaselinesResult) => any;

export declare const DescribePatchGroupsRequestFilterSensitiveLog: (obj: DescribePatchGroupsRequest) => any;

export declare const PatchGroupPatchBaselineMappingFilterSensitiveLog: (obj: PatchGroupPatchBaselineMapping) => any;

export declare const DescribePatchGroupsResultFilterSensitiveLog: (obj: DescribePatchGroupsResult) => any;

export declare const DescribePatchGroupStateRequestFilterSensitiveLog: (obj: DescribePatchGroupStateRequest) => any;

export declare const DescribePatchGroupStateResultFilterSensitiveLog: (obj: DescribePatchGroupStateResult) => any;

export declare const DescribePatchPropertiesRequestFilterSensitiveLog: (obj: DescribePatchPropertiesRequest) => any;

export declare const DescribePatchPropertiesResultFilterSensitiveLog: (obj: DescribePatchPropertiesResult) => any;

export declare const SessionFilterFilterSensitiveLog: (obj: SessionFilter) => any;

export declare const DescribeSessionsRequestFilterSensitiveLog: (obj: DescribeSessionsRequest) => any;

export declare const SessionManagerOutputUrlFilterSensitiveLog: (obj: SessionManagerOutputUrl) => any;

export declare const SessionFilterSensitiveLog: (obj: Session) => any;

export declare const DescribeSessionsResponseFilterSensitiveLog: (obj: DescribeSessionsResponse) => any;

export declare const DisassociateOpsItemRelatedItemRequestFilterSensitiveLog: (obj: DisassociateOpsItemRelatedItemRequest) => any;

export declare const DisassociateOpsItemRelatedItemResponseFilterSensitiveLog: (obj: DisassociateOpsItemRelatedItemResponse) => any;

export declare const GetAutomationExecutionRequestFilterSensitiveLog: (obj: GetAutomationExecutionRequest) => any;

export declare const ProgressCountersFilterSensitiveLog: (obj: ProgressCounters) => any;

export declare const AutomationExecutionFilterSensitiveLog: (obj: AutomationExecution) => any;

export declare const GetAutomationExecutionResultFilterSensitiveLog: (obj: GetAutomationExecutionResult) => any;

export declare const GetCalendarStateRequestFilterSensitiveLog: (obj: GetCalendarStateRequest) => any;

export declare const GetCalendarStateResponseFilterSensitiveLog: (obj: GetCalendarStateResponse) => any;

export declare const GetCommandInvocationRequestFilterSensitiveLog: (obj: GetCommandInvocationRequest) => any;

export declare const CloudWatchOutputConfigFilterSensitiveLog: (obj: CloudWatchOutputConfig) => any;

export declare const GetCommandInvocationResultFilterSensitiveLog: (obj: GetCommandInvocationResult) => any;

export declare const GetConnectionStatusRequestFilterSensitiveLog: (obj: GetConnectionStatusRequest) => any;

export declare const GetConnectionStatusResponseFilterSensitiveLog: (obj: GetConnectionStatusResponse) => any;

export declare const GetDefaultPatchBaselineRequestFilterSensitiveLog: (obj: GetDefaultPatchBaselineRequest) => any;

export declare const GetDefaultPatchBaselineResultFilterSensitiveLog: (obj: GetDefaultPatchBaselineResult) => any;

export declare const BaselineOverrideFilterSensitiveLog: (obj: BaselineOverride) => any;

export declare const GetDeployablePatchSnapshotForInstanceRequestFilterSensitiveLog: (obj: GetDeployablePatchSnapshotForInstanceRequest) => any;

export declare const GetDeployablePatchSnapshotForInstanceResultFilterSensitiveLog: (obj: GetDeployablePatchSnapshotForInstanceResult) => any;

export declare const GetDocumentRequestFilterSensitiveLog: (obj: GetDocumentRequest) => any;

export declare const AttachmentContentFilterSensitiveLog: (obj: AttachmentContent) => any;

export declare const GetDocumentResultFilterSensitiveLog: (obj: GetDocumentResult) => any;

export declare const InventoryFilterFilterSensitiveLog: (obj: InventoryFilter) => any;

export declare const InventoryGroupFilterSensitiveLog: (obj: InventoryGroup) => any;

export declare const ResultAttributeFilterSensitiveLog: (obj: ResultAttribute) => any;

export declare const InventoryResultItemFilterSensitiveLog: (obj: InventoryResultItem) => any;

export declare const InventoryResultEntityFilterSensitiveLog: (obj: InventoryResultEntity) => any;

export declare const GetInventoryResultFilterSensitiveLog: (obj: GetInventoryResult) => any;

export declare const GetInventorySchemaRequestFilterSensitiveLog: (obj: GetInventorySchemaRequest) => any;

export declare const InventoryItemAttributeFilterSensitiveLog: (obj: InventoryItemAttribute) => any;

export declare const InventoryItemSchemaFilterSensitiveLog: (obj: InventoryItemSchema) => any;

export declare const GetInventorySchemaResultFilterSensitiveLog: (obj: GetInventorySchemaResult) => any;

export declare const GetMaintenanceWindowRequestFilterSensitiveLog: (obj: GetMaintenanceWindowRequest) => any;

export declare const GetMaintenanceWindowResultFilterSensitiveLog: (obj: GetMaintenanceWindowResult) => any;

export declare const GetMaintenanceWindowExecutionRequestFilterSensitiveLog: (obj: GetMaintenanceWindowExecutionRequest) => any;

export declare const GetMaintenanceWindowExecutionResultFilterSensitiveLog: (obj: GetMaintenanceWindowExecutionResult) => any;

export declare const GetMaintenanceWindowExecutionTaskRequestFilterSensitiveLog: (obj: GetMaintenanceWindowExecutionTaskRequest) => any;

export declare const GetMaintenanceWindowExecutionTaskResultFilterSensitiveLog: (obj: GetMaintenanceWindowExecutionTaskResult) => any;

export declare const GetMaintenanceWindowExecutionTaskInvocationRequestFilterSensitiveLog: (obj: GetMaintenanceWindowExecutionTaskInvocationRequest) => any;

export declare const GetMaintenanceWindowExecutionTaskInvocationResultFilterSensitiveLog: (obj: GetMaintenanceWindowExecutionTaskInvocationResult) => any;

export declare const GetMaintenanceWindowTaskRequestFilterSensitiveLog: (obj: GetMaintenanceWindowTaskRequest) => any;

export declare const MaintenanceWindowAutomationParametersFilterSensitiveLog: (obj: MaintenanceWindowAutomationParameters) => any;

export declare const MaintenanceWindowLambdaParametersFilterSensitiveLog: (obj: MaintenanceWindowLambdaParameters) => any;

export declare const NotificationConfigFilterSensitiveLog: (obj: NotificationConfig) => any;

export declare const MaintenanceWindowRunCommandParametersFilterSensitiveLog: (obj: MaintenanceWindowRunCommandParameters) => any;

export declare const MaintenanceWindowStepFunctionsParametersFilterSensitiveLog: (obj: MaintenanceWindowStepFunctionsParameters) => any;

export declare const MaintenanceWindowTaskInvocationParametersFilterSensitiveLog: (obj: MaintenanceWindowTaskInvocationParameters) => any;

export declare const GetMaintenanceWindowTaskResultFilterSensitiveLog: (obj: GetMaintenanceWindowTaskResult) => any;

export declare const GetOpsItemRequestFilterSensitiveLog: (obj: GetOpsItemRequest) => any;

export declare const OpsItemFilterSensitiveLog: (obj: OpsItem) => any;

export declare const GetOpsItemResponseFilterSensitiveLog: (obj: GetOpsItemResponse) => any;

export declare const GetOpsMetadataRequestFilterSensitiveLog: (obj: GetOpsMetadataRequest) => any;

export declare const GetOpsMetadataResultFilterSensitiveLog: (obj: GetOpsMetadataResult) => any;

export declare const OpsFilterFilterSensitiveLog: (obj: OpsFilter) => any;

export declare const OpsResultAttributeFilterSensitiveLog: (obj: OpsResultAttribute) => any;

export declare const OpsEntityItemFilterSensitiveLog: (obj: OpsEntityItem) => any;

export declare const OpsEntityFilterSensitiveLog: (obj: OpsEntity) => any;

export declare const GetOpsSummaryResultFilterSensitiveLog: (obj: GetOpsSummaryResult) => any;

export declare const GetParameterRequestFilterSensitiveLog: (obj: GetParameterRequest) => any;

export declare const ParameterFilterSensitiveLog: (obj: Parameter) => any;

export declare const GetParameterResultFilterSensitiveLog: (obj: GetParameterResult) => any;

export declare const GetParameterHistoryRequestFilterSensitiveLog: (obj: GetParameterHistoryRequest) => any;

export declare const ParameterHistoryFilterSensitiveLog: (obj: ParameterHistory) => any;

export declare const GetParameterHistoryResultFilterSensitiveLog: (obj: GetParameterHistoryResult) => any;

export declare const GetParametersRequestFilterSensitiveLog: (obj: GetParametersRequest) => any;

export declare const GetParametersResultFilterSensitiveLog: (obj: GetParametersResult) => any;

export declare const GetParametersByPathRequestFilterSensitiveLog: (obj: GetParametersByPathRequest) => any;

export declare const GetParametersByPathResultFilterSensitiveLog: (obj: GetParametersByPathResult) => any;

export declare const GetPatchBaselineRequestFilterSensitiveLog: (obj: GetPatchBaselineRequest) => any;

export declare const GetPatchBaselineResultFilterSensitiveLog: (obj: GetPatchBaselineResult) => any;

export declare const GetPatchBaselineForPatchGroupRequestFilterSensitiveLog: (obj: GetPatchBaselineForPatchGroupRequest) => any;

export declare const GetPatchBaselineForPatchGroupResultFilterSensitiveLog: (obj: GetPatchBaselineForPatchGroupResult) => any;

export declare const GetServiceSettingRequestFilterSensitiveLog: (obj: GetServiceSettingRequest) => any;

export declare const ServiceSettingFilterSensitiveLog: (obj: ServiceSetting) => any;

export declare const GetServiceSettingResultFilterSensitiveLog: (obj: GetServiceSettingResult) => any;

export declare const LabelParameterVersionRequestFilterSensitiveLog: (obj: LabelParameterVersionRequest) => any;

export declare const LabelParameterVersionResultFilterSensitiveLog: (obj: LabelParameterVersionResult) => any;

export declare const AssociationFilterFilterSensitiveLog: (obj: AssociationFilter) => any;

export declare const ListAssociationsRequestFilterSensitiveLog: (obj: ListAssociationsRequest) => any;

export declare const AssociationFilterSensitiveLog: (obj: Association) => any;

export declare const ListAssociationsResultFilterSensitiveLog: (obj: ListAssociationsResult) => any;

export declare const ListAssociationVersionsRequestFilterSensitiveLog: (obj: ListAssociationVersionsRequest) => any;

export declare const AssociationVersionInfoFilterSensitiveLog: (obj: AssociationVersionInfo) => any;

export declare const ListAssociationVersionsResultFilterSensitiveLog: (obj: ListAssociationVersionsResult) => any;

export declare const CommandFilterFilterSensitiveLog: (obj: CommandFilter) => any;

export declare const ListCommandInvocationsRequestFilterSensitiveLog: (obj: ListCommandInvocationsRequest) => any;

export declare const CommandPluginFilterSensitiveLog: (obj: CommandPlugin) => any;

export declare const CommandInvocationFilterSensitiveLog: (obj: CommandInvocation) => any;

export declare const ListCommandInvocationsResultFilterSensitiveLog: (obj: ListCommandInvocationsResult) => any;

export declare const ListCommandsRequestFilterSensitiveLog: (obj: ListCommandsRequest) => any;

export declare const CommandFilterSensitiveLog: (obj: Command) => any;

export declare const ListCommandsResultFilterSensitiveLog: (obj: ListCommandsResult) => any;

export declare const ComplianceStringFilterFilterSensitiveLog: (obj: ComplianceStringFilter) => any;

export declare const ListComplianceItemsRequestFilterSensitiveLog: (obj: ListComplianceItemsRequest) => any;

export declare const ComplianceExecutionSummaryFilterSensitiveLog: (obj: ComplianceExecutionSummary) => any;

export declare const ComplianceItemFilterSensitiveLog: (obj: ComplianceItem) => any;

export declare const ListComplianceItemsResultFilterSensitiveLog: (obj: ListComplianceItemsResult) => any;

export declare const ListComplianceSummariesRequestFilterSensitiveLog: (obj: ListComplianceSummariesRequest) => any;

export declare const SeveritySummaryFilterSensitiveLog: (obj: SeveritySummary) => any;

export declare const CompliantSummaryFilterSensitiveLog: (obj: CompliantSummary) => any;

export declare const NonCompliantSummaryFilterSensitiveLog: (obj: NonCompliantSummary) => any;

export declare const ComplianceSummaryItemFilterSensitiveLog: (obj: ComplianceSummaryItem) => any;

export declare const ListComplianceSummariesResultFilterSensitiveLog: (obj: ListComplianceSummariesResult) => any;

export declare const ListDocumentMetadataHistoryRequestFilterSensitiveLog: (obj: ListDocumentMetadataHistoryRequest) => any;

export declare const DocumentReviewCommentSourceFilterSensitiveLog: (obj: DocumentReviewCommentSource) => any;

export declare const DocumentReviewerResponseSourceFilterSensitiveLog: (obj: DocumentReviewerResponseSource) => any;

export declare const DocumentMetadataResponseInfoFilterSensitiveLog: (obj: DocumentMetadataResponseInfo) => any;

export declare const ListDocumentMetadataHistoryResponseFilterSensitiveLog: (obj: ListDocumentMetadataHistoryResponse) => any;

export declare const DocumentFilterFilterSensitiveLog: (obj: DocumentFilter) => any;

export declare const DocumentKeyValuesFilterFilterSensitiveLog: (obj: DocumentKeyValuesFilter) => any;

export declare const ListDocumentsRequestFilterSensitiveLog: (obj: ListDocumentsRequest) => any;

export declare const DocumentIdentifierFilterSensitiveLog: (obj: DocumentIdentifier) => any;

export declare const ListDocumentsResultFilterSensitiveLog: (obj: ListDocumentsResult) => any;

export declare const ListDocumentVersionsRequestFilterSensitiveLog: (obj: ListDocumentVersionsRequest) => any;

export declare const DocumentVersionInfoFilterSensitiveLog: (obj: DocumentVersionInfo) => any;

export declare const ListDocumentVersionsResultFilterSensitiveLog: (obj: ListDocumentVersionsResult) => any;

export declare const ListInventoryEntriesRequestFilterSensitiveLog: (obj: ListInventoryEntriesRequest) => any;

export declare const ListInventoryEntriesResultFilterSensitiveLog: (obj: ListInventoryEntriesResult) => any;

export declare const OpsItemEventFilterFilterSensitiveLog: (obj: OpsItemEventFilter) => any;

export declare const ListOpsItemEventsRequestFilterSensitiveLog: (obj: ListOpsItemEventsRequest) => any;

export declare const OpsItemIdentityFilterSensitiveLog: (obj: OpsItemIdentity) => any;

export declare const OpsItemEventSummaryFilterSensitiveLog: (obj: OpsItemEventSummary) => any;

export declare const ListOpsItemEventsResponseFilterSensitiveLog: (obj: ListOpsItemEventsResponse) => any;

export declare const OpsItemRelatedItemsFilterFilterSensitiveLog: (obj: OpsItemRelatedItemsFilter) => any;

export declare const ListOpsItemRelatedItemsRequestFilterSensitiveLog: (obj: ListOpsItemRelatedItemsRequest) => any;

export declare const OpsItemRelatedItemSummaryFilterSensitiveLog: (obj: OpsItemRelatedItemSummary) => any;

export declare const ListOpsItemRelatedItemsResponseFilterSensitiveLog: (obj: ListOpsItemRelatedItemsResponse) => any;

export declare const OpsMetadataFilterFilterSensitiveLog: (obj: OpsMetadataFilter) => any;

export declare const ListOpsMetadataRequestFilterSensitiveLog: (obj: ListOpsMetadataRequest) => any;

export declare const OpsMetadataFilterSensitiveLog: (obj: OpsMetadata) => any;

export declare const ListOpsMetadataResultFilterSensitiveLog: (obj: ListOpsMetadataResult) => any;

export declare const ListResourceComplianceSummariesRequestFilterSensitiveLog: (obj: ListResourceComplianceSummariesRequest) => any;

export declare const ResourceComplianceSummaryItemFilterSensitiveLog: (obj: ResourceComplianceSummaryItem) => any;

export declare const ListResourceComplianceSummariesResultFilterSensitiveLog: (obj: ListResourceComplianceSummariesResult) => any;

export declare const ListResourceDataSyncRequestFilterSensitiveLog: (obj: ListResourceDataSyncRequest) => any;

export declare const ResourceDataSyncSourceWithStateFilterSensitiveLog: (obj: ResourceDataSyncSourceWithState) => any;

export declare const ResourceDataSyncItemFilterSensitiveLog: (obj: ResourceDataSyncItem) => any;

export declare const ListResourceDataSyncResultFilterSensitiveLog: (obj: ListResourceDataSyncResult) => any;

export declare const ListTagsForResourceRequestFilterSensitiveLog: (obj: ListTagsForResourceRequest) => any;

export declare const ListTagsForResourceResultFilterSensitiveLog: (obj: ListTagsForResourceResult) => any;

export declare const ModifyDocumentPermissionRequestFilterSensitiveLog: (obj: ModifyDocumentPermissionRequest) => any;

export declare const ModifyDocumentPermissionResponseFilterSensitiveLog: (obj: ModifyDocumentPermissionResponse) => any;

export declare const ComplianceItemEntryFilterSensitiveLog: (obj: ComplianceItemEntry) => any;

export declare const PutComplianceItemsRequestFilterSensitiveLog: (obj: PutComplianceItemsRequest) => any;

export declare const PutComplianceItemsResultFilterSensitiveLog: (obj: PutComplianceItemsResult) => any;

export declare const InventoryItemFilterSensitiveLog: (obj: InventoryItem) => any;

export declare const PutInventoryRequestFilterSensitiveLog: (obj: PutInventoryRequest) => any;

export declare const PutInventoryResultFilterSensitiveLog: (obj: PutInventoryResult) => any;

export declare const PutParameterRequestFilterSensitiveLog: (obj: PutParameterRequest) => any;

export declare const PutParameterResultFilterSensitiveLog: (obj: PutParameterResult) => any;

export declare const RegisterDefaultPatchBaselineRequestFilterSensitiveLog: (obj: RegisterDefaultPatchBaselineRequest) => any;

export declare const RegisterDefaultPatchBaselineResultFilterSensitiveLog: (obj: RegisterDefaultPatchBaselineResult) => any;

export declare const RegisterPatchBaselineForPatchGroupRequestFilterSensitiveLog: (obj: RegisterPatchBaselineForPatchGroupRequest) => any;

export declare const RegisterPatchBaselineForPatchGroupResultFilterSensitiveLog: (obj: RegisterPatchBaselineForPatchGroupResult) => any;

export declare const RegisterTargetWithMaintenanceWindowRequestFilterSensitiveLog: (obj: RegisterTargetWithMaintenanceWindowRequest) => any;

export declare const RegisterTargetWithMaintenanceWindowResultFilterSensitiveLog: (obj: RegisterTargetWithMaintenanceWindowResult) => any;

export declare const RegisterTaskWithMaintenanceWindowRequestFilterSensitiveLog: (obj: RegisterTaskWithMaintenanceWindowRequest) => any;

export declare const RegisterTaskWithMaintenanceWindowResultFilterSensitiveLog: (obj: RegisterTaskWithMaintenanceWindowResult) => any;

export declare const RemoveTagsFromResourceRequestFilterSensitiveLog: (obj: RemoveTagsFromResourceRequest) => any;

export declare const RemoveTagsFromResourceResultFilterSensitiveLog: (obj: RemoveTagsFromResourceResult) => any;

export declare const ResetServiceSettingRequestFilterSensitiveLog: (obj: ResetServiceSettingRequest) => any;

export declare const ResetServiceSettingResultFilterSensitiveLog: (obj: ResetServiceSettingResult) => any;

export declare const ResumeSessionRequestFilterSensitiveLog: (obj: ResumeSessionRequest) => any;

export declare const ResumeSessionResponseFilterSensitiveLog: (obj: ResumeSessionResponse) => any;

export declare const SendAutomationSignalRequestFilterSensitiveLog: (obj: SendAutomationSignalRequest) => any;

export declare const SendAutomationSignalResultFilterSensitiveLog: (obj: SendAutomationSignalResult) => any;

export declare const SendCommandRequestFilterSensitiveLog: (obj: SendCommandRequest) => any;

export declare const SendCommandResultFilterSensitiveLog: (obj: SendCommandResult) => any;

export declare const StartAssociationsOnceRequestFilterSensitiveLog: (obj: StartAssociationsOnceRequest) => any;

export declare const StartAssociationsOnceResultFilterSensitiveLog: (obj: StartAssociationsOnceResult) => any;

export declare const StartAutomationExecutionRequestFilterSensitiveLog: (obj: StartAutomationExecutionRequest) => any;

export declare const StartAutomationExecutionResultFilterSensitiveLog: (obj: StartAutomationExecutionResult) => any;

export declare const StartChangeRequestExecutionRequestFilterSensitiveLog: (obj: StartChangeRequestExecutionRequest) => any;

export declare const StartChangeRequestExecutionResultFilterSensitiveLog: (obj: StartChangeRequestExecutionResult) => any;

export declare const StartSessionRequestFilterSensitiveLog: (obj: StartSessionRequest) => any;

export declare const StartSessionResponseFilterSensitiveLog: (obj: StartSessionResponse) => any;

export declare const StopAutomationExecutionRequestFilterSensitiveLog: (obj: StopAutomationExecutionRequest) => any;

export declare const StopAutomationExecutionResultFilterSensitiveLog: (obj: StopAutomationExecutionResult) => any;

export declare const TerminateSessionRequestFilterSensitiveLog: (obj: TerminateSessionRequest) => any;

export declare const TerminateSessionResponseFilterSensitiveLog: (obj: TerminateSessionResponse) => any;

export declare const UnlabelParameterVersionRequestFilterSensitiveLog: (obj: UnlabelParameterVersionRequest) => any;

export declare const UnlabelParameterVersionResultFilterSensitiveLog: (obj: UnlabelParameterVersionResult) => any;

export declare const UpdateAssociationRequestFilterSensitiveLog: (obj: UpdateAssociationRequest) => any;

export declare const UpdateAssociationResultFilterSensitiveLog: (obj: UpdateAssociationResult) => any;

export declare const UpdateAssociationStatusRequestFilterSensitiveLog: (obj: UpdateAssociationStatusRequest) => any;

export declare const UpdateAssociationStatusResultFilterSensitiveLog: (obj: UpdateAssociationStatusResult) => any;

export declare const UpdateDocumentRequestFilterSensitiveLog: (obj: UpdateDocumentRequest) => any;

export declare const UpdateDocumentResultFilterSensitiveLog: (obj: UpdateDocumentResult) => any;

export declare const UpdateDocumentDefaultVersionRequestFilterSensitiveLog: (obj: UpdateDocumentDefaultVersionRequest) => any;

export declare const DocumentDefaultVersionDescriptionFilterSensitiveLog: (obj: DocumentDefaultVersionDescription) => any;

export declare const UpdateDocumentDefaultVersionResultFilterSensitiveLog: (obj: UpdateDocumentDefaultVersionResult) => any;

export declare const DocumentReviewsFilterSensitiveLog: (obj: DocumentReviews) => any;
