import { ExceptionOptionType as __ExceptionOptionType } from "@aws-sdk/smithy-client";
import { SSMServiceException as __BaseException } from "./SSMServiceException";

export interface AccountSharingInfo {
    
    AccountId?: string;
    
    SharedDocumentVersion?: string;
}

export interface Tag {
    
    Key: string | undefined;
    
    Value: string | undefined;
}

export interface Activation {
    
    ActivationId?: string;
    
    Description?: string;
    
    DefaultInstanceName?: string;
    
    IamRole?: string;
    
    RegistrationLimit?: number;
    
    RegistrationsCount?: number;
    
    ExpirationDate?: Date;
    
    Expired?: boolean;
    
    CreatedDate?: Date;
    
    Tags?: Tag[];
}
export declare enum ResourceTypeForTagging {
    AUTOMATION = "Automation",
    DOCUMENT = "Document",
    MAINTENANCE_WINDOW = "MaintenanceWindow",
    MANAGED_INSTANCE = "ManagedInstance",
    OPSMETADATA = "OpsMetadata",
    OPS_ITEM = "OpsItem",
    PARAMETER = "Parameter",
    PATCH_BASELINE = "PatchBaseline"
}
export interface AddTagsToResourceRequest {
    
    ResourceType: ResourceTypeForTagging | string | undefined;
    
    ResourceId: string | undefined;
    
    Tags: Tag[] | undefined;
}
export interface AddTagsToResourceResult {
}

export declare class InternalServerError extends __BaseException {
    readonly name: "InternalServerError";
    readonly $fault: "server";
    Message?: string;
    
    constructor(opts: __ExceptionOptionType<InternalServerError, __BaseException>);
}

export declare class InvalidResourceId extends __BaseException {
    readonly name: "InvalidResourceId";
    readonly $fault: "client";
    
    constructor(opts: __ExceptionOptionType<InvalidResourceId, __BaseException>);
}

export declare class InvalidResourceType extends __BaseException {
    readonly name: "InvalidResourceType";
    readonly $fault: "client";
    
    constructor(opts: __ExceptionOptionType<InvalidResourceType, __BaseException>);
}

export declare class TooManyTagsError extends __BaseException {
    readonly name: "TooManyTagsError";
    readonly $fault: "client";
    
    constructor(opts: __ExceptionOptionType<TooManyTagsError, __BaseException>);
}

export declare class TooManyUpdates extends __BaseException {
    readonly name: "TooManyUpdates";
    readonly $fault: "client";
    Message?: string;
    
    constructor(opts: __ExceptionOptionType<TooManyUpdates, __BaseException>);
}

export declare class AlreadyExistsException extends __BaseException {
    readonly name: "AlreadyExistsException";
    readonly $fault: "client";
    Message?: string;
    
    constructor(opts: __ExceptionOptionType<AlreadyExistsException, __BaseException>);
}
export interface AssociateOpsItemRelatedItemRequest {
    
    OpsItemId: string | undefined;
    
    AssociationType: string | undefined;
    
    ResourceType: string | undefined;
    
    ResourceUri: string | undefined;
}
export interface AssociateOpsItemRelatedItemResponse {
    
    AssociationId?: string;
}

export declare class OpsItemInvalidParameterException extends __BaseException {
    readonly name: "OpsItemInvalidParameterException";
    readonly $fault: "client";
    ParameterNames?: string[];
    Message?: string;
    
    constructor(opts: __ExceptionOptionType<OpsItemInvalidParameterException, __BaseException>);
}

export declare class OpsItemLimitExceededException extends __BaseException {
    readonly name: "OpsItemLimitExceededException";
    readonly $fault: "client";
    ResourceTypes?: string[];
    Limit?: number;
    LimitType?: string;
    Message?: string;
    
    constructor(opts: __ExceptionOptionType<OpsItemLimitExceededException, __BaseException>);
}

export declare class OpsItemNotFoundException extends __BaseException {
    readonly name: "OpsItemNotFoundException";
    readonly $fault: "client";
    Message?: string;
    
    constructor(opts: __ExceptionOptionType<OpsItemNotFoundException, __BaseException>);
}

export declare class OpsItemRelatedItemAlreadyExistsException extends __BaseException {
    readonly name: "OpsItemRelatedItemAlreadyExistsException";
    readonly $fault: "client";
    Message?: string;
    ResourceUri?: string;
    OpsItemId?: string;
    
    constructor(opts: __ExceptionOptionType<OpsItemRelatedItemAlreadyExistsException, __BaseException>);
}

export interface CancelCommandRequest {
    
    CommandId: string | undefined;
    
    InstanceIds?: string[];
}

export interface CancelCommandResult {
}

export declare class DuplicateInstanceId extends __BaseException {
    readonly name: "DuplicateInstanceId";
    readonly $fault: "client";
    
    constructor(opts: __ExceptionOptionType<DuplicateInstanceId, __BaseException>);
}

export declare class InvalidCommandId extends __BaseException {
    readonly name: "InvalidCommandId";
    readonly $fault: "client";
    
    constructor(opts: __ExceptionOptionType<InvalidCommandId, __BaseException>);
}

export declare class InvalidInstanceId extends __BaseException {
    readonly name: "InvalidInstanceId";
    readonly $fault: "client";
    Message?: string;
    
    constructor(opts: __ExceptionOptionType<InvalidInstanceId, __BaseException>);
}
export interface CancelMaintenanceWindowExecutionRequest {
    
    WindowExecutionId: string | undefined;
}
export interface CancelMaintenanceWindowExecutionResult {
    
    WindowExecutionId?: string;
}

export declare class DoesNotExistException extends __BaseException {
    readonly name: "DoesNotExistException";
    readonly $fault: "client";
    Message?: string;
    
    constructor(opts: __ExceptionOptionType<DoesNotExistException, __BaseException>);
}

export interface RegistrationMetadataItem {
    
    Key: string | undefined;
    
    Value: string | undefined;
}
export interface CreateActivationRequest {
    
    Description?: string;
    
    DefaultInstanceName?: string;
    
    IamRole: string | undefined;
    
    RegistrationLimit?: number;
    
    ExpirationDate?: Date;
    
    Tags?: Tag[];
    
    RegistrationMetadata?: RegistrationMetadataItem[];
}
export interface CreateActivationResult {
    
    ActivationId?: string;
    
    ActivationCode?: string;
}

export declare class InvalidParameters extends __BaseException {
    readonly name: "InvalidParameters";
    readonly $fault: "client";
    Message?: string;
    
    constructor(opts: __ExceptionOptionType<InvalidParameters, __BaseException>);
}

export declare class AssociationAlreadyExists extends __BaseException {
    readonly name: "AssociationAlreadyExists";
    readonly $fault: "client";
    
    constructor(opts: __ExceptionOptionType<AssociationAlreadyExists, __BaseException>);
}

export declare class AssociationLimitExceeded extends __BaseException {
    readonly name: "AssociationLimitExceeded";
    readonly $fault: "client";
    
    constructor(opts: __ExceptionOptionType<AssociationLimitExceeded, __BaseException>);
}
export declare enum AssociationComplianceSeverity {
    Critical = "CRITICAL",
    High = "HIGH",
    Low = "LOW",
    Medium = "MEDIUM",
    Unspecified = "UNSPECIFIED"
}

export interface S3OutputLocation {
    
    OutputS3Region?: string;
    
    OutputS3BucketName?: string;
    
    OutputS3KeyPrefix?: string;
}

export interface InstanceAssociationOutputLocation {
    
    S3Location?: S3OutputLocation;
}
export declare enum AssociationSyncCompliance {
    Auto = "AUTO",
    Manual = "MANUAL"
}

export interface TargetLocation {
    
    Accounts?: string[];
    
    Regions?: string[];
    
    TargetLocationMaxConcurrency?: string;
    
    TargetLocationMaxErrors?: string;
    
    ExecutionRoleName?: string;
}

export interface Target {
    
    Key?: string;
    
    Values?: string[];
}
export interface CreateAssociationRequest {
    
    Name: string | undefined;
    
    DocumentVersion?: string;
    
    InstanceId?: string;
    
    Parameters?: Record<string, string[]>;
    
    Targets?: Target[];
    
    ScheduleExpression?: string;
    
    OutputLocation?: InstanceAssociationOutputLocation;
    
    AssociationName?: string;
    
    AutomationTargetParameterName?: string;
    
    MaxErrors?: string;
    
    MaxConcurrency?: string;
    
    ComplianceSeverity?: AssociationComplianceSeverity | string;
    
    SyncCompliance?: AssociationSyncCompliance | string;
    
    ApplyOnlyAtCronInterval?: boolean;
    
    CalendarNames?: string[];
    
    TargetLocations?: TargetLocation[];
    
    ScheduleOffset?: number;
    
    TargetMaps?: Record<string, string[]>[];
}

export interface AssociationOverview {
    
    Status?: string;
    
    DetailedStatus?: string;
    
    AssociationStatusAggregatedCount?: Record<string, number>;
}
export declare enum AssociationStatusName {
    Failed = "Failed",
    Pending = "Pending",
    Success = "Success"
}

export interface AssociationStatus {
    
    Date: Date | undefined;
    
    Name: AssociationStatusName | string | undefined;
    
    Message: string | undefined;
    
    AdditionalInfo?: string;
}

export interface AssociationDescription {
    
    Name?: string;
    
    InstanceId?: string;
    
    AssociationVersion?: string;
    
    Date?: Date;
    
    LastUpdateAssociationDate?: Date;
    
    Status?: AssociationStatus;
    
    Overview?: AssociationOverview;
    
    DocumentVersion?: string;
    
    AutomationTargetParameterName?: string;
    
    Parameters?: Record<string, string[]>;
    
    AssociationId?: string;
    
    Targets?: Target[];
    
    ScheduleExpression?: string;
    
    OutputLocation?: InstanceAssociationOutputLocation;
    
    LastExecutionDate?: Date;
    
    LastSuccessfulExecutionDate?: Date;
    
    AssociationName?: string;
    
    MaxErrors?: string;
    
    MaxConcurrency?: string;
    
    ComplianceSeverity?: AssociationComplianceSeverity | string;
    
    SyncCompliance?: AssociationSyncCompliance | string;
    
    ApplyOnlyAtCronInterval?: boolean;
    
    CalendarNames?: string[];
    
    TargetLocations?: TargetLocation[];
    
    ScheduleOffset?: number;
    
    TargetMaps?: Record<string, string[]>[];
}
export interface CreateAssociationResult {
    
    AssociationDescription?: AssociationDescription;
}

export declare class InvalidDocument extends __BaseException {
    readonly name: "InvalidDocument";
    readonly $fault: "client";
    
    Message?: string;
    
    constructor(opts: __ExceptionOptionType<InvalidDocument, __BaseException>);
}

export declare class InvalidDocumentVersion extends __BaseException {
    readonly name: "InvalidDocumentVersion";
    readonly $fault: "client";
    Message?: string;
    
    constructor(opts: __ExceptionOptionType<InvalidDocumentVersion, __BaseException>);
}

export declare class InvalidOutputLocation extends __BaseException {
    readonly name: "InvalidOutputLocation";
    readonly $fault: "client";
    
    constructor(opts: __ExceptionOptionType<InvalidOutputLocation, __BaseException>);
}

export declare class InvalidSchedule extends __BaseException {
    readonly name: "InvalidSchedule";
    readonly $fault: "client";
    Message?: string;
    
    constructor(opts: __ExceptionOptionType<InvalidSchedule, __BaseException>);
}

export declare class InvalidTarget extends __BaseException {
    readonly name: "InvalidTarget";
    readonly $fault: "client";
    Message?: string;
    
    constructor(opts: __ExceptionOptionType<InvalidTarget, __BaseException>);
}

export declare class InvalidTargetMaps extends __BaseException {
    readonly name: "InvalidTargetMaps";
    readonly $fault: "client";
    Message?: string;
    
    constructor(opts: __ExceptionOptionType<InvalidTargetMaps, __BaseException>);
}

export declare class UnsupportedPlatformType extends __BaseException {
    readonly name: "UnsupportedPlatformType";
    readonly $fault: "client";
    Message?: string;
    
    constructor(opts: __ExceptionOptionType<UnsupportedPlatformType, __BaseException>);
}

export interface CreateAssociationBatchRequestEntry {
    
    Name: string | undefined;
    
    InstanceId?: string;
    
    Parameters?: Record<string, string[]>;
    
    AutomationTargetParameterName?: string;
    
    DocumentVersion?: string;
    
    Targets?: Target[];
    
    ScheduleExpression?: string;
    
    OutputLocation?: InstanceAssociationOutputLocation;
    
    AssociationName?: string;
    
    MaxErrors?: string;
    
    MaxConcurrency?: string;
    
    ComplianceSeverity?: AssociationComplianceSeverity | string;
    
    SyncCompliance?: AssociationSyncCompliance | string;
    
    ApplyOnlyAtCronInterval?: boolean;
    
    CalendarNames?: string[];
    
    TargetLocations?: TargetLocation[];
    
    ScheduleOffset?: number;
    
    TargetMaps?: Record<string, string[]>[];
}
export interface CreateAssociationBatchRequest {
    
    Entries: CreateAssociationBatchRequestEntry[] | undefined;
}
export declare type Fault = "Client" | "Server" | "Unknown";

export interface FailedCreateAssociation {
    
    Entry?: CreateAssociationBatchRequestEntry;
    
    Message?: string;
    
    Fault?: Fault | string;
}
export interface CreateAssociationBatchResult {
    
    Successful?: AssociationDescription[];
    
    Failed?: FailedCreateAssociation[];
}
export declare enum AttachmentsSourceKey {
    AttachmentReference = "AttachmentReference",
    S3FileUrl = "S3FileUrl",
    SourceUrl = "SourceUrl"
}

export interface AttachmentsSource {
    
    Key?: AttachmentsSourceKey | string;
    
    Values?: string[];
    
    Name?: string;
}
export declare enum DocumentFormat {
    JSON = "JSON",
    TEXT = "TEXT",
    YAML = "YAML"
}
export declare enum DocumentType {
    ApplicationConfiguration = "ApplicationConfiguration",
    ApplicationConfigurationSchema = "ApplicationConfigurationSchema",
    Automation = "Automation",
    ChangeCalendar = "ChangeCalendar",
    ChangeTemplate = "Automation.ChangeTemplate",
    Command = "Command",
    DeploymentStrategy = "DeploymentStrategy",
    Package = "Package",
    Policy = "Policy",
    ProblemAnalysis = "ProblemAnalysis",
    ProblemAnalysisTemplate = "ProblemAnalysisTemplate",
    Session = "Session"
}

export interface DocumentRequires {
    
    Name: string | undefined;
    
    Version?: string;
}
export interface CreateDocumentRequest {
    
    Content: string | undefined;
    
    Requires?: DocumentRequires[];
    
    Attachments?: AttachmentsSource[];
    
    Name: string | undefined;
    
    DisplayName?: string;
    
    VersionName?: string;
    
    DocumentType?: DocumentType | string;
    
    DocumentFormat?: DocumentFormat | string;
    
    TargetType?: string;
    
    Tags?: Tag[];
}

export interface AttachmentInformation {
    
    Name?: string;
}
export declare enum DocumentHashType {
    SHA1 = "Sha1",
    SHA256 = "Sha256"
}
export declare type DocumentParameterType = "String" | "StringList";

export interface DocumentParameter {
    
    Name?: string;
    
    Type?: DocumentParameterType | string;
    
    Description?: string;
    
    DefaultValue?: string;
}
export declare enum PlatformType {
    LINUX = "Linux",
    MACOS = "MacOS",
    WINDOWS = "Windows"
}
export declare enum ReviewStatus {
    APPROVED = "APPROVED",
    NOT_REVIEWED = "NOT_REVIEWED",
    PENDING = "PENDING",
    REJECTED = "REJECTED"
}

export interface ReviewInformation {
    
    ReviewedTime?: Date;
    
    Status?: ReviewStatus | string;
    
    Reviewer?: string;
}
export declare enum DocumentStatus {
    Active = "Active",
    Creating = "Creating",
    Deleting = "Deleting",
    Failed = "Failed",
    Updating = "Updating"
}

export interface DocumentDescription {
    
    Sha1?: string;
    
    Hash?: string;
    
    HashType?: DocumentHashType | string;
    
    Name?: string;
    
    DisplayName?: string;
    
    VersionName?: string;
    
    Owner?: string;
    
    CreatedDate?: Date;
    
    Status?: DocumentStatus | string;
    
    StatusInformation?: string;
    
    DocumentVersion?: string;
    
    Description?: string;
    
    Parameters?: DocumentParameter[];
    
    PlatformTypes?: (PlatformType | string)[];
    
    DocumentType?: DocumentType | string;
    
    SchemaVersion?: string;
    
    LatestVersion?: string;
    
    DefaultVersion?: string;
    
    DocumentFormat?: DocumentFormat | string;
    
    TargetType?: string;
    
    Tags?: Tag[];
    
    AttachmentsInformation?: AttachmentInformation[];
    
    Requires?: DocumentRequires[];
    
    Author?: string;
    
    ReviewInformation?: ReviewInformation[];
    
    ApprovedVersion?: string;
    
    PendingReviewVersion?: string;
    
    ReviewStatus?: ReviewStatus | string;
    
    Category?: string[];
    
    CategoryEnum?: string[];
}
export interface CreateDocumentResult {
    
    DocumentDescription?: DocumentDescription;
}

export declare class DocumentAlreadyExists extends __BaseException {
    readonly name: "DocumentAlreadyExists";
    readonly $fault: "client";
    Message?: string;
    
    constructor(opts: __ExceptionOptionType<DocumentAlreadyExists, __BaseException>);
}

export declare class DocumentLimitExceeded extends __BaseException {
    readonly name: "DocumentLimitExceeded";
    readonly $fault: "client";
    Message?: string;
    
    constructor(opts: __ExceptionOptionType<DocumentLimitExceeded, __BaseException>);
}

export declare class InvalidDocumentContent extends __BaseException {
    readonly name: "InvalidDocumentContent";
    readonly $fault: "client";
    
    Message?: string;
    
    constructor(opts: __ExceptionOptionType<InvalidDocumentContent, __BaseException>);
}

export declare class InvalidDocumentSchemaVersion extends __BaseException {
    readonly name: "InvalidDocumentSchemaVersion";
    readonly $fault: "client";
    Message?: string;
    
    constructor(opts: __ExceptionOptionType<InvalidDocumentSchemaVersion, __BaseException>);
}

export declare class MaxDocumentSizeExceeded extends __BaseException {
    readonly name: "MaxDocumentSizeExceeded";
    readonly $fault: "client";
    Message?: string;
    
    constructor(opts: __ExceptionOptionType<MaxDocumentSizeExceeded, __BaseException>);
}
export interface CreateMaintenanceWindowRequest {
    
    Name: string | undefined;
    
    Description?: string;
    
    StartDate?: string;
    
    EndDate?: string;
    
    Schedule: string | undefined;
    
    ScheduleTimezone?: string;
    
    ScheduleOffset?: number;
    
    Duration: number | undefined;
    
    Cutoff: number | undefined;
    
    AllowUnassociatedTargets: boolean | undefined;
    
    ClientToken?: string;
    
    Tags?: Tag[];
}
export interface CreateMaintenanceWindowResult {
    
    WindowId?: string;
}

export declare class IdempotentParameterMismatch extends __BaseException {
    readonly name: "IdempotentParameterMismatch";
    readonly $fault: "client";
    Message?: string;
    
    constructor(opts: __ExceptionOptionType<IdempotentParameterMismatch, __BaseException>);
}

export declare class ResourceLimitExceededException extends __BaseException {
    readonly name: "ResourceLimitExceededException";
    readonly $fault: "client";
    Message?: string;
    
    constructor(opts: __ExceptionOptionType<ResourceLimitExceededException, __BaseException>);
}

export interface OpsItemNotification {
    
    Arn?: string;
}
export declare enum OpsItemDataType {
    SEARCHABLE_STRING = "SearchableString",
    STRING = "String"
}

export interface OpsItemDataValue {
    
    Value?: string;
    
    Type?: OpsItemDataType | string;
}

export interface RelatedOpsItem {
    
    OpsItemId: string | undefined;
}
export interface CreateOpsItemRequest {
    
    Description: string | undefined;
    
    OpsItemType?: string;
    
    OperationalData?: Record<string, OpsItemDataValue>;
    
    Notifications?: OpsItemNotification[];
    
    Priority?: number;
    
    RelatedOpsItems?: RelatedOpsItem[];
    
    Source: string | undefined;
    
    Title: string | undefined;
    
    Tags?: Tag[];
    
    Category?: string;
    
    Severity?: string;
    
    ActualStartTime?: Date;
    
    ActualEndTime?: Date;
    
    PlannedStartTime?: Date;
    
    PlannedEndTime?: Date;
}
export interface CreateOpsItemResponse {
    
    OpsItemId?: string;
}

export declare class OpsItemAlreadyExistsException extends __BaseException {
    readonly name: "OpsItemAlreadyExistsException";
    readonly $fault: "client";
    Message?: string;
    OpsItemId?: string;
    
    constructor(opts: __ExceptionOptionType<OpsItemAlreadyExistsException, __BaseException>);
}

export interface MetadataValue {
    
    Value?: string;
}
export interface CreateOpsMetadataRequest {
    
    ResourceId: string | undefined;
    
    Metadata?: Record<string, MetadataValue>;
    
    Tags?: Tag[];
}
export interface CreateOpsMetadataResult {
    
    OpsMetadataArn?: string;
}

export declare class OpsMetadataAlreadyExistsException extends __BaseException {
    readonly name: "OpsMetadataAlreadyExistsException";
    readonly $fault: "client";
    
    constructor(opts: __ExceptionOptionType<OpsMetadataAlreadyExistsException, __BaseException>);
}

export declare class OpsMetadataInvalidArgumentException extends __BaseException {
    readonly name: "OpsMetadataInvalidArgumentException";
    readonly $fault: "client";
    
    constructor(opts: __ExceptionOptionType<OpsMetadataInvalidArgumentException, __BaseException>);
}

export declare class OpsMetadataLimitExceededException extends __BaseException {
    readonly name: "OpsMetadataLimitExceededException";
    readonly $fault: "client";
    
    constructor(opts: __ExceptionOptionType<OpsMetadataLimitExceededException, __BaseException>);
}

export declare class OpsMetadataTooManyUpdatesException extends __BaseException {
    readonly name: "OpsMetadataTooManyUpdatesException";
    readonly $fault: "client";
    
    constructor(opts: __ExceptionOptionType<OpsMetadataTooManyUpdatesException, __BaseException>);
}
export declare enum PatchComplianceLevel {
    Critical = "CRITICAL",
    High = "HIGH",
    Informational = "INFORMATIONAL",
    Low = "LOW",
    Medium = "MEDIUM",
    Unspecified = "UNSPECIFIED"
}
export declare enum PatchFilterKey {
    AdvisoryId = "ADVISORY_ID",
    Arch = "ARCH",
    BugzillaId = "BUGZILLA_ID",
    CVEId = "CVE_ID",
    Classification = "CLASSIFICATION",
    Epoch = "EPOCH",
    MsrcSeverity = "MSRC_SEVERITY",
    Name = "NAME",
    PatchId = "PATCH_ID",
    PatchSet = "PATCH_SET",
    Priority = "PRIORITY",
    Product = "PRODUCT",
    ProductFamily = "PRODUCT_FAMILY",
    Release = "RELEASE",
    Repository = "REPOSITORY",
    Section = "SECTION",
    Security = "SECURITY",
    Severity = "SEVERITY",
    Version = "VERSION"
}

export interface PatchFilter {
    
    Key: PatchFilterKey | string | undefined;
    
    Values: string[] | undefined;
}

export interface PatchFilterGroup {
    
    PatchFilters: PatchFilter[] | undefined;
}

export interface PatchRule {
    
    PatchFilterGroup: PatchFilterGroup | undefined;
    
    ComplianceLevel?: PatchComplianceLevel | string;
    
    ApproveAfterDays?: number;
    
    ApproveUntilDate?: string;
    
    EnableNonSecurity?: boolean;
}

export interface PatchRuleGroup {
    
    PatchRules: PatchRule[] | undefined;
}
export declare enum OperatingSystem {
    AmazonLinux = "AMAZON_LINUX",
    AmazonLinux2 = "AMAZON_LINUX_2",
    CentOS = "CENTOS",
    Debian = "DEBIAN",
    MacOS = "MACOS",
    OracleLinux = "ORACLE_LINUX",
    Raspbian = "RASPBIAN",
    RedhatEnterpriseLinux = "REDHAT_ENTERPRISE_LINUX",
    Rocky_Linux = "ROCKY_LINUX",
    Suse = "SUSE",
    Ubuntu = "UBUNTU",
    Windows = "WINDOWS"
}
export declare enum PatchAction {
    AllowAsDependency = "ALLOW_AS_DEPENDENCY",
    Block = "BLOCK"
}

export interface PatchSource {
    
    Name: string | undefined;
    
    Products: string[] | undefined;
    
    Configuration: string | undefined;
}
export interface CreatePatchBaselineRequest {
    
    OperatingSystem?: OperatingSystem | string;
    
    Name: string | undefined;
    
    GlobalFilters?: PatchFilterGroup;
    
    ApprovalRules?: PatchRuleGroup;
    
    ApprovedPatches?: string[];
    
    ApprovedPatchesComplianceLevel?: PatchComplianceLevel | string;
    
    ApprovedPatchesEnableNonSecurity?: boolean;
    
    RejectedPatches?: string[];
    
    RejectedPatchesAction?: PatchAction | string;
    
    Description?: string;
    
    Sources?: PatchSource[];
    
    ClientToken?: string;
    
    Tags?: Tag[];
}
export interface CreatePatchBaselineResult {
    
    BaselineId?: string;
}

export interface ResourceDataSyncDestinationDataSharing {
    
    DestinationDataSharingType?: string;
}
export declare enum ResourceDataSyncS3Format {
    JSON_SERDE = "JsonSerDe"
}

export interface ResourceDataSyncS3Destination {
    
    BucketName: string | undefined;
    
    Prefix?: string;
    
    SyncFormat: ResourceDataSyncS3Format | string | undefined;
    
    Region: string | undefined;
    
    AWSKMSKeyARN?: string;
    
    DestinationDataSharing?: ResourceDataSyncDestinationDataSharing;
}

export interface ResourceDataSyncOrganizationalUnit {
    
    OrganizationalUnitId?: string;
}

export interface ResourceDataSyncAwsOrganizationsSource {
    
    OrganizationSourceType: string | undefined;
    
    OrganizationalUnits?: ResourceDataSyncOrganizationalUnit[];
}

export interface ResourceDataSyncSource {
    
    SourceType: string | undefined;
    
    AwsOrganizationsSource?: ResourceDataSyncAwsOrganizationsSource;
    
    SourceRegions: string[] | undefined;
    
    IncludeFutureRegions?: boolean;
    
    EnableAllOpsDataSources?: boolean;
}
export interface CreateResourceDataSyncRequest {
    
    SyncName: string | undefined;
    
    S3Destination?: ResourceDataSyncS3Destination;
    
    SyncType?: string;
    
    SyncSource?: ResourceDataSyncSource;
}
export interface CreateResourceDataSyncResult {
}

export declare class ResourceDataSyncAlreadyExistsException extends __BaseException {
    readonly name: "ResourceDataSyncAlreadyExistsException";
    readonly $fault: "client";
    SyncName?: string;
    
    constructor(opts: __ExceptionOptionType<ResourceDataSyncAlreadyExistsException, __BaseException>);
}

export declare class ResourceDataSyncCountExceededException extends __BaseException {
    readonly name: "ResourceDataSyncCountExceededException";
    readonly $fault: "client";
    Message?: string;
    
    constructor(opts: __ExceptionOptionType<ResourceDataSyncCountExceededException, __BaseException>);
}

export declare class ResourceDataSyncInvalidConfigurationException extends __BaseException {
    readonly name: "ResourceDataSyncInvalidConfigurationException";
    readonly $fault: "client";
    Message?: string;
    
    constructor(opts: __ExceptionOptionType<ResourceDataSyncInvalidConfigurationException, __BaseException>);
}
export interface DeleteActivationRequest {
    
    ActivationId: string | undefined;
}
export interface DeleteActivationResult {
}

export declare class InvalidActivation extends __BaseException {
    readonly name: "InvalidActivation";
    readonly $fault: "client";
    Message?: string;
    
    constructor(opts: __ExceptionOptionType<InvalidActivation, __BaseException>);
}

export declare class InvalidActivationId extends __BaseException {
    readonly name: "InvalidActivationId";
    readonly $fault: "client";
    Message?: string;
    
    constructor(opts: __ExceptionOptionType<InvalidActivationId, __BaseException>);
}

export declare class AssociationDoesNotExist extends __BaseException {
    readonly name: "AssociationDoesNotExist";
    readonly $fault: "client";
    Message?: string;
    
    constructor(opts: __ExceptionOptionType<AssociationDoesNotExist, __BaseException>);
}
export interface DeleteAssociationRequest {
    
    Name?: string;
    
    InstanceId?: string;
    
    AssociationId?: string;
}
export interface DeleteAssociationResult {
}

export declare class AssociatedInstances extends __BaseException {
    readonly name: "AssociatedInstances";
    readonly $fault: "client";
    
    constructor(opts: __ExceptionOptionType<AssociatedInstances, __BaseException>);
}
export interface DeleteDocumentRequest {
    
    Name: string | undefined;
    
    DocumentVersion?: string;
    
    VersionName?: string;
    
    Force?: boolean;
}
export interface DeleteDocumentResult {
}

export declare class InvalidDocumentOperation extends __BaseException {
    readonly name: "InvalidDocumentOperation";
    readonly $fault: "client";
    Message?: string;
    
    constructor(opts: __ExceptionOptionType<InvalidDocumentOperation, __BaseException>);
}
export declare enum InventorySchemaDeleteOption {
    DELETE_SCHEMA = "DeleteSchema",
    DISABLE_SCHEMA = "DisableSchema"
}
export interface DeleteInventoryRequest {
    
    TypeName: string | undefined;
    
    SchemaDeleteOption?: InventorySchemaDeleteOption | string;
    
    DryRun?: boolean;
    
    ClientToken?: string;
}

export interface InventoryDeletionSummaryItem {
    
    Version?: string;
    
    Count?: number;
    
    RemainingCount?: number;
}

export interface InventoryDeletionSummary {
    
    TotalCount?: number;
    
    RemainingCount?: number;
    
    SummaryItems?: InventoryDeletionSummaryItem[];
}
export interface DeleteInventoryResult {
    
    DeletionId?: string;
    
    TypeName?: string;
    
    DeletionSummary?: InventoryDeletionSummary;
}

export declare class InvalidDeleteInventoryParametersException extends __BaseException {
    readonly name: "InvalidDeleteInventoryParametersException";
    readonly $fault: "client";
    Message?: string;
    
    constructor(opts: __ExceptionOptionType<InvalidDeleteInventoryParametersException, __BaseException>);
}

export declare class InvalidInventoryRequestException extends __BaseException {
    readonly name: "InvalidInventoryRequestException";
    readonly $fault: "client";
    Message?: string;
    
    constructor(opts: __ExceptionOptionType<InvalidInventoryRequestException, __BaseException>);
}

export declare class InvalidOptionException extends __BaseException {
    readonly name: "InvalidOptionException";
    readonly $fault: "client";
    Message?: string;
    
    constructor(opts: __ExceptionOptionType<InvalidOptionException, __BaseException>);
}

export declare class InvalidTypeNameException extends __BaseException {
    readonly name: "InvalidTypeNameException";
    readonly $fault: "client";
    Message?: string;
    
    constructor(opts: __ExceptionOptionType<InvalidTypeNameException, __BaseException>);
}
export interface DeleteMaintenanceWindowRequest {
    
    WindowId: string | undefined;
}
export interface DeleteMaintenanceWindowResult {
    
    WindowId?: string;
}
export interface DeleteOpsMetadataRequest {
    
    OpsMetadataArn: string | undefined;
}
export interface DeleteOpsMetadataResult {
}

export declare class OpsMetadataNotFoundException extends __BaseException {
    readonly name: "OpsMetadataNotFoundException";
    readonly $fault: "client";
    
    constructor(opts: __ExceptionOptionType<OpsMetadataNotFoundException, __BaseException>);
}
export interface DeleteParameterRequest {
    
    Name: string | undefined;
}
export interface DeleteParameterResult {
}

export declare class ParameterNotFound extends __BaseException {
    readonly name: "ParameterNotFound";
    readonly $fault: "client";
    
    constructor(opts: __ExceptionOptionType<ParameterNotFound, __BaseException>);
}
export interface DeleteParametersRequest {
    
    Names: string[] | undefined;
}
export interface DeleteParametersResult {
    
    DeletedParameters?: string[];
    
    InvalidParameters?: string[];
}
export interface DeletePatchBaselineRequest {
    
    BaselineId: string | undefined;
}
export interface DeletePatchBaselineResult {
    
    BaselineId?: string;
}

export declare class ResourceInUseException extends __BaseException {
    readonly name: "ResourceInUseException";
    readonly $fault: "client";
    Message?: string;
    
    constructor(opts: __ExceptionOptionType<ResourceInUseException, __BaseException>);
}
export interface DeleteResourceDataSyncRequest {
    
    SyncName: string | undefined;
    
    SyncType?: string;
}
export interface DeleteResourceDataSyncResult {
}

export declare class ResourceDataSyncNotFoundException extends __BaseException {
    readonly name: "ResourceDataSyncNotFoundException";
    readonly $fault: "client";
    SyncName?: string;
    SyncType?: string;
    Message?: string;
    
    constructor(opts: __ExceptionOptionType<ResourceDataSyncNotFoundException, __BaseException>);
}
export interface DeregisterManagedInstanceRequest {
    
    InstanceId: string | undefined;
}
export interface DeregisterManagedInstanceResult {
}
export interface DeregisterPatchBaselineForPatchGroupRequest {
    
    BaselineId: string | undefined;
    
    PatchGroup: string | undefined;
}
export interface DeregisterPatchBaselineForPatchGroupResult {
    
    BaselineId?: string;
    
    PatchGroup?: string;
}
export interface DeregisterTargetFromMaintenanceWindowRequest {
    
    WindowId: string | undefined;
    
    WindowTargetId: string | undefined;
    
    Safe?: boolean;
}
export interface DeregisterTargetFromMaintenanceWindowResult {
    
    WindowId?: string;
    
    WindowTargetId?: string;
}

export declare class TargetInUseException extends __BaseException {
    readonly name: "TargetInUseException";
    readonly $fault: "client";
    Message?: string;
    
    constructor(opts: __ExceptionOptionType<TargetInUseException, __BaseException>);
}
export interface DeregisterTaskFromMaintenanceWindowRequest {
    
    WindowId: string | undefined;
    
    WindowTaskId: string | undefined;
}
export interface DeregisterTaskFromMaintenanceWindowResult {
    
    WindowId?: string;
    
    WindowTaskId?: string;
}
export declare enum DescribeActivationsFilterKeys {
    ACTIVATION_IDS = "ActivationIds",
    DEFAULT_INSTANCE_NAME = "DefaultInstanceName",
    IAM_ROLE = "IamRole"
}

export interface DescribeActivationsFilter {
    
    FilterKey?: DescribeActivationsFilterKeys | string;
    
    FilterValues?: string[];
}
export interface DescribeActivationsRequest {
    
    Filters?: DescribeActivationsFilter[];
    
    MaxResults?: number;
    
    NextToken?: string;
}
export interface DescribeActivationsResult {
    
    ActivationList?: Activation[];
    
    NextToken?: string;
}

export declare class InvalidFilter extends __BaseException {
    readonly name: "InvalidFilter";
    readonly $fault: "client";
    Message?: string;
    
    constructor(opts: __ExceptionOptionType<InvalidFilter, __BaseException>);
}

export declare class InvalidNextToken extends __BaseException {
    readonly name: "InvalidNextToken";
    readonly $fault: "client";
    Message?: string;
    
    constructor(opts: __ExceptionOptionType<InvalidNextToken, __BaseException>);
}
export interface DescribeAssociationRequest {
    
    Name?: string;
    
    InstanceId?: string;
    
    AssociationId?: string;
    
    AssociationVersion?: string;
}
export interface DescribeAssociationResult {
    
    AssociationDescription?: AssociationDescription;
}

export declare class InvalidAssociationVersion extends __BaseException {
    readonly name: "InvalidAssociationVersion";
    readonly $fault: "client";
    Message?: string;
    
    constructor(opts: __ExceptionOptionType<InvalidAssociationVersion, __BaseException>);
}
export declare enum AssociationExecutionFilterKey {
    CreatedTime = "CreatedTime",
    ExecutionId = "ExecutionId",
    Status = "Status"
}
export declare enum AssociationFilterOperatorType {
    Equal = "EQUAL",
    GreaterThan = "GREATER_THAN",
    LessThan = "LESS_THAN"
}

export interface AssociationExecutionFilter {
    
    Key: AssociationExecutionFilterKey | string | undefined;
    
    Value: string | undefined;
    
    Type: AssociationFilterOperatorType | string | undefined;
}
export interface DescribeAssociationExecutionsRequest {
    
    AssociationId: string | undefined;
    
    Filters?: AssociationExecutionFilter[];
    
    MaxResults?: number;
    
    NextToken?: string;
}

export interface AssociationExecution {
    
    AssociationId?: string;
    
    AssociationVersion?: string;
    
    ExecutionId?: string;
    
    Status?: string;
    
    DetailedStatus?: string;
    
    CreatedTime?: Date;
    
    LastExecutionDate?: Date;
    
    ResourceCountByStatus?: string;
}
export interface DescribeAssociationExecutionsResult {
    
    AssociationExecutions?: AssociationExecution[];
    
    NextToken?: string;
}

export declare class AssociationExecutionDoesNotExist extends __BaseException {
    readonly name: "AssociationExecutionDoesNotExist";
    readonly $fault: "client";
    Message?: string;
    
    constructor(opts: __ExceptionOptionType<AssociationExecutionDoesNotExist, __BaseException>);
}
export declare enum AssociationExecutionTargetsFilterKey {
    ResourceId = "ResourceId",
    ResourceType = "ResourceType",
    Status = "Status"
}

export interface AssociationExecutionTargetsFilter {
    
    Key: AssociationExecutionTargetsFilterKey | string | undefined;
    
    Value: string | undefined;
}
export interface DescribeAssociationExecutionTargetsRequest {
    
    AssociationId: string | undefined;
    
    ExecutionId: string | undefined;
    
    Filters?: AssociationExecutionTargetsFilter[];
    
    MaxResults?: number;
    
    NextToken?: string;
}

export interface OutputSource {
    
    OutputSourceId?: string;
    
    OutputSourceType?: string;
}

export interface AssociationExecutionTarget {
    
    AssociationId?: string;
    
    AssociationVersion?: string;
    
    ExecutionId?: string;
    
    ResourceId?: string;
    
    ResourceType?: string;
    
    Status?: string;
    
    DetailedStatus?: string;
    
    LastExecutionDate?: Date;
    
    OutputSource?: OutputSource;
}
export interface DescribeAssociationExecutionTargetsResult {
    
    AssociationExecutionTargets?: AssociationExecutionTarget[];
    
    NextToken?: string;
}
export declare enum AutomationExecutionFilterKey {
    AUTOMATION_SUBTYPE = "AutomationSubtype",
    AUTOMATION_TYPE = "AutomationType",
    CURRENT_ACTION = "CurrentAction",
    DOCUMENT_NAME_PREFIX = "DocumentNamePrefix",
    EXECUTION_ID = "ExecutionId",
    EXECUTION_STATUS = "ExecutionStatus",
    OPS_ITEM_ID = "OpsItemId",
    PARENT_EXECUTION_ID = "ParentExecutionId",
    START_TIME_AFTER = "StartTimeAfter",
    START_TIME_BEFORE = "StartTimeBefore",
    TAG_KEY = "TagKey",
    TARGET_RESOURCE_GROUP = "TargetResourceGroup"
}

export interface AutomationExecutionFilter {
    
    Key: AutomationExecutionFilterKey | string | undefined;
    
    Values: string[] | undefined;
}
export interface DescribeAutomationExecutionsRequest {
    
    Filters?: AutomationExecutionFilter[];
    
    MaxResults?: number;
    
    NextToken?: string;
}
export declare enum AutomationExecutionStatus {
    APPROVED = "Approved",
    CANCELLED = "Cancelled",
    CANCELLING = "Cancelling",
    CHANGE_CALENDAR_OVERRIDE_APPROVED = "ChangeCalendarOverrideApproved",
    CHANGE_CALENDAR_OVERRIDE_REJECTED = "ChangeCalendarOverrideRejected",
    COMPLETED_WITH_FAILURE = "CompletedWithFailure",
    COMPLETED_WITH_SUCCESS = "CompletedWithSuccess",
    FAILED = "Failed",
    INPROGRESS = "InProgress",
    PENDING = "Pending",
    PENDING_APPROVAL = "PendingApproval",
    PENDING_CHANGE_CALENDAR_OVERRIDE = "PendingChangeCalendarOverride",
    REJECTED = "Rejected",
    RUNBOOK_INPROGRESS = "RunbookInProgress",
    SCHEDULED = "Scheduled",
    SUCCESS = "Success",
    TIMEDOUT = "TimedOut",
    WAITING = "Waiting"
}
export declare enum AutomationSubtype {
    ChangeRequest = "ChangeRequest"
}
export declare enum AutomationType {
    CrossAccount = "CrossAccount",
    Local = "Local"
}
export declare enum ExecutionMode {
    Auto = "Auto",
    Interactive = "Interactive"
}

export interface ResolvedTargets {
    
    ParameterValues?: string[];
    
    Truncated?: boolean;
}

export interface Runbook {
    
    DocumentName: string | undefined;
    
    DocumentVersion?: string;
    
    Parameters?: Record<string, string[]>;
    
    TargetParameterName?: string;
    
    Targets?: Target[];
    
    TargetMaps?: Record<string, string[]>[];
    
    MaxConcurrency?: string;
    
    MaxErrors?: string;
    
    TargetLocations?: TargetLocation[];
}

export interface AutomationExecutionMetadata {
    
    AutomationExecutionId?: string;
    
    DocumentName?: string;
    
    DocumentVersion?: string;
    
    AutomationExecutionStatus?: AutomationExecutionStatus | string;
    
    ExecutionStartTime?: Date;
    
    ExecutionEndTime?: Date;
    
    ExecutedBy?: string;
    
    LogFile?: string;
    
    Outputs?: Record<string, string[]>;
    
    Mode?: ExecutionMode | string;
    
    ParentAutomationExecutionId?: string;
    
    CurrentStepName?: string;
    
    CurrentAction?: string;
    
    FailureMessage?: string;
    
    TargetParameterName?: string;
    
    Targets?: Target[];
    
    TargetMaps?: Record<string, string[]>[];
    
    ResolvedTargets?: ResolvedTargets;
    
    MaxConcurrency?: string;
    
    MaxErrors?: string;
    
    Target?: string;
    
    AutomationType?: AutomationType | string;
    
    AutomationSubtype?: AutomationSubtype | string;
    
    ScheduledTime?: Date;
    
    Runbooks?: Runbook[];
    
    OpsItemId?: string;
    
    AssociationId?: string;
    
    ChangeRequestName?: string;
}
export interface DescribeAutomationExecutionsResult {
    
    AutomationExecutionMetadataList?: AutomationExecutionMetadata[];
    
    NextToken?: string;
}

export declare class InvalidFilterKey extends __BaseException {
    readonly name: "InvalidFilterKey";
    readonly $fault: "client";
    
    constructor(opts: __ExceptionOptionType<InvalidFilterKey, __BaseException>);
}

export declare class InvalidFilterValue extends __BaseException {
    readonly name: "InvalidFilterValue";
    readonly $fault: "client";
    Message?: string;
    
    constructor(opts: __ExceptionOptionType<InvalidFilterValue, __BaseException>);
}

export declare class AutomationExecutionNotFoundException extends __BaseException {
    readonly name: "AutomationExecutionNotFoundException";
    readonly $fault: "client";
    Message?: string;
    
    constructor(opts: __ExceptionOptionType<AutomationExecutionNotFoundException, __BaseException>);
}
export declare enum StepExecutionFilterKey {
    ACTION = "Action",
    START_TIME_AFTER = "StartTimeAfter",
    START_TIME_BEFORE = "StartTimeBefore",
    STEP_EXECUTION_ID = "StepExecutionId",
    STEP_EXECUTION_STATUS = "StepExecutionStatus",
    STEP_NAME = "StepName"
}

export interface StepExecutionFilter {
    
    Key: StepExecutionFilterKey | string | undefined;
    
    Values: string[] | undefined;
}
export interface DescribeAutomationStepExecutionsRequest {
    
    AutomationExecutionId: string | undefined;
    
    Filters?: StepExecutionFilter[];
    
    NextToken?: string;
    
    MaxResults?: number;
    
    ReverseOrder?: boolean;
}

export interface FailureDetails {
    
    FailureStage?: string;
    
    FailureType?: string;
    
    Details?: Record<string, string[]>;
}

export interface StepExecution {
    
    StepName?: string;
    
    Action?: string;
    
    TimeoutSeconds?: number;
    
    OnFailure?: string;
    
    MaxAttempts?: number;
    
    ExecutionStartTime?: Date;
    
    ExecutionEndTime?: Date;
    
    StepStatus?: AutomationExecutionStatus | string;
    
    ResponseCode?: string;
    
    Inputs?: Record<string, string>;
    
    Outputs?: Record<string, string[]>;
    
    Response?: string;
    
    FailureMessage?: string;
    
    FailureDetails?: FailureDetails;
    
    StepExecutionId?: string;
    
    OverriddenParameters?: Record<string, string[]>;
    
    IsEnd?: boolean;
    
    NextStep?: string;
    
    IsCritical?: boolean;
    
    ValidNextSteps?: string[];
    
    Targets?: Target[];
    
    TargetLocation?: TargetLocation;
}
export interface DescribeAutomationStepExecutionsResult {
    
    StepExecutions?: StepExecution[];
    
    NextToken?: string;
}

export interface PatchOrchestratorFilter {
    
    Key?: string;
    
    Values?: string[];
}
export interface DescribeAvailablePatchesRequest {
    
    Filters?: PatchOrchestratorFilter[];
    
    MaxResults?: number;
    
    NextToken?: string;
}

export interface Patch {
    
    Id?: string;
    
    ReleaseDate?: Date;
    
    Title?: string;
    
    Description?: string;
    
    ContentUrl?: string;
    
    Vendor?: string;
    
    ProductFamily?: string;
    
    Product?: string;
    
    Classification?: string;
    
    MsrcSeverity?: string;
    
    KbNumber?: string;
    
    MsrcNumber?: string;
    
    Language?: string;
    
    AdvisoryIds?: string[];
    
    BugzillaIds?: string[];
    
    CVEIds?: string[];
    
    Name?: string;
    
    Epoch?: number;
    
    Version?: string;
    
    Release?: string;
    
    Arch?: string;
    
    Severity?: string;
    
    Repository?: string;
}
export interface DescribeAvailablePatchesResult {
    
    Patches?: Patch[];
    
    NextToken?: string;
}
export interface DescribeDocumentRequest {
    
    Name: string | undefined;
    
    DocumentVersion?: string;
    
    VersionName?: string;
}
export interface DescribeDocumentResult {
    
    Document?: DocumentDescription;
}
export declare enum DocumentPermissionType {
    SHARE = "Share"
}
export interface DescribeDocumentPermissionRequest {
    
    Name: string | undefined;
    
    PermissionType: DocumentPermissionType | string | undefined;
    
    MaxResults?: number;
    
    NextToken?: string;
}
export interface DescribeDocumentPermissionResponse {
    
    AccountIds?: string[];
    
    AccountSharingInfoList?: AccountSharingInfo[];
    
    NextToken?: string;
}

export declare class InvalidPermissionType extends __BaseException {
    readonly name: "InvalidPermissionType";
    readonly $fault: "client";
    Message?: string;
    
    constructor(opts: __ExceptionOptionType<InvalidPermissionType, __BaseException>);
}
export interface DescribeEffectiveInstanceAssociationsRequest {
    
    InstanceId: string | undefined;
    
    MaxResults?: number;
    
    NextToken?: string;
}

export interface InstanceAssociation {
    
    AssociationId?: string;
    
    InstanceId?: string;
    
    Content?: string;
    
    AssociationVersion?: string;
}
export interface DescribeEffectiveInstanceAssociationsResult {
    
    Associations?: InstanceAssociation[];
    
    NextToken?: string;
}
export interface DescribeEffectivePatchesForPatchBaselineRequest {
    
    BaselineId: string | undefined;
    
    MaxResults?: number;
    
    NextToken?: string;
}
export declare enum PatchDeploymentStatus {
    Approved = "APPROVED",
    ExplicitApproved = "EXPLICIT_APPROVED",
    ExplicitRejected = "EXPLICIT_REJECTED",
    PendingApproval = "PENDING_APPROVAL"
}

export interface PatchStatus {
    
    DeploymentStatus?: PatchDeploymentStatus | string;
    
    ComplianceLevel?: PatchComplianceLevel | string;
    
    ApprovalDate?: Date;
}

export interface EffectivePatch {
    
    Patch?: Patch;
    
    PatchStatus?: PatchStatus;
}
export interface DescribeEffectivePatchesForPatchBaselineResult {
    
    EffectivePatches?: EffectivePatch[];
    
    NextToken?: string;
}

export declare class UnsupportedOperatingSystem extends __BaseException {
    readonly name: "UnsupportedOperatingSystem";
    readonly $fault: "client";
    Message?: string;
    
    constructor(opts: __ExceptionOptionType<UnsupportedOperatingSystem, __BaseException>);
}
export interface DescribeInstanceAssociationsStatusRequest {
    
    InstanceId: string | undefined;
    
    MaxResults?: number;
    
    NextToken?: string;
}

export interface S3OutputUrl {
    
    OutputUrl?: string;
}

export interface InstanceAssociationOutputUrl {
    
    S3OutputUrl?: S3OutputUrl;
}

export interface InstanceAssociationStatusInfo {
    
    AssociationId?: string;
    
    Name?: string;
    
    DocumentVersion?: string;
    
    AssociationVersion?: string;
    
    InstanceId?: string;
    
    ExecutionDate?: Date;
    
    Status?: string;
    
    DetailedStatus?: string;
    
    ExecutionSummary?: string;
    
    ErrorCode?: string;
    
    OutputUrl?: InstanceAssociationOutputUrl;
    
    AssociationName?: string;
}
export interface DescribeInstanceAssociationsStatusResult {
    
    InstanceAssociationStatusInfos?: InstanceAssociationStatusInfo[];
    
    NextToken?: string;
}

export interface InstanceInformationStringFilter {
    
    Key: string | undefined;
    
    Values: string[] | undefined;
}
export declare enum InstanceInformationFilterKey {
    ACTIVATION_IDS = "ActivationIds",
    AGENT_VERSION = "AgentVersion",
    ASSOCIATION_STATUS = "AssociationStatus",
    IAM_ROLE = "IamRole",
    INSTANCE_IDS = "InstanceIds",
    PING_STATUS = "PingStatus",
    PLATFORM_TYPES = "PlatformTypes",
    RESOURCE_TYPE = "ResourceType"
}

export interface InstanceInformationFilter {
    
    key: InstanceInformationFilterKey | string | undefined;
    
    valueSet: string[] | undefined;
}
export interface DescribeInstanceInformationRequest {
    
    InstanceInformationFilterList?: InstanceInformationFilter[];
    
    Filters?: InstanceInformationStringFilter[];
    
    MaxResults?: number;
    
    NextToken?: string;
}

export interface InstanceAggregatedAssociationOverview {
    
    DetailedStatus?: string;
    
    InstanceAssociationStatusAggregatedCount?: Record<string, number>;
}
export declare enum PingStatus {
    CONNECTION_LOST = "ConnectionLost",
    INACTIVE = "Inactive",
    ONLINE = "Online"
}
export declare enum ResourceType {
    DOCUMENT = "Document",
    EC2_INSTANCE = "EC2Instance",
    MANAGED_INSTANCE = "ManagedInstance"
}
export declare enum SourceType {
    AWS_EC2_INSTANCE = "AWS::EC2::Instance",
    AWS_IOT_THING = "AWS::IoT::Thing",
    AWS_SSM_MANAGEDINSTANCE = "AWS::SSM::ManagedInstance"
}

export interface InstanceInformation {
    
    InstanceId?: string;
    
    PingStatus?: PingStatus | string;
    
    LastPingDateTime?: Date;
    
    AgentVersion?: string;
    
    IsLatestVersion?: boolean;
    
    PlatformType?: PlatformType | string;
    
    PlatformName?: string;
    
    PlatformVersion?: string;
    
    ActivationId?: string;
    
    IamRole?: string;
    
    RegistrationDate?: Date;
    
    ResourceType?: ResourceType | string;
    
    Name?: string;
    
    IPAddress?: string;
    
    ComputerName?: string;
    
    AssociationStatus?: string;
    
    LastAssociationExecutionDate?: Date;
    
    LastSuccessfulAssociationExecutionDate?: Date;
    
    AssociationOverview?: InstanceAggregatedAssociationOverview;
    
    SourceId?: string;
    
    SourceType?: SourceType | string;
}
export interface DescribeInstanceInformationResult {
    
    InstanceInformationList?: InstanceInformation[];
    
    NextToken?: string;
}

export declare class InvalidInstanceInformationFilterValue extends __BaseException {
    readonly name: "InvalidInstanceInformationFilterValue";
    readonly $fault: "client";
    
    constructor(opts: __ExceptionOptionType<InvalidInstanceInformationFilterValue, __BaseException>);
}
export interface DescribeInstancePatchesRequest {
    
    InstanceId: string | undefined;
    
    Filters?: PatchOrchestratorFilter[];
    
    NextToken?: string;
    
    MaxResults?: number;
}
export declare enum PatchComplianceDataState {
    Failed = "FAILED",
    Installed = "INSTALLED",
    InstalledOther = "INSTALLED_OTHER",
    InstalledPendingReboot = "INSTALLED_PENDING_REBOOT",
    InstalledRejected = "INSTALLED_REJECTED",
    Missing = "MISSING",
    NotApplicable = "NOT_APPLICABLE"
}

export interface PatchComplianceData {
    
    Title: string | undefined;
    
    KBId: string | undefined;
    
    Classification: string | undefined;
    
    Severity: string | undefined;
    
    State: PatchComplianceDataState | string | undefined;
    
    InstalledTime: Date | undefined;
    
    CVEIds?: string;
}
export interface DescribeInstancePatchesResult {
    
    Patches?: PatchComplianceData[];
    
    NextToken?: string;
}
export interface DescribeInstancePatchStatesRequest {
    
    InstanceIds: string[] | undefined;
    
    NextToken?: string;
    
    MaxResults?: number;
}
export declare enum PatchOperationType {
    INSTALL = "Install",
    SCAN = "Scan"
}
export declare enum RebootOption {
    NO_REBOOT = "NoReboot",
    REBOOT_IF_NEEDED = "RebootIfNeeded"
}

export interface InstancePatchState {
    
    InstanceId: string | undefined;
    
    PatchGroup: string | undefined;
    
    BaselineId: string | undefined;
    
    SnapshotId?: string;
    
    InstallOverrideList?: string;
    
    OwnerInformation?: string;
    
    InstalledCount?: number;
    
    InstalledOtherCount?: number;
    
    InstalledPendingRebootCount?: number;
    
    InstalledRejectedCount?: number;
    
    MissingCount?: number;
    
    FailedCount?: number;
    
    UnreportedNotApplicableCount?: number;
    
    NotApplicableCount?: number;
    
    OperationStartTime: Date | undefined;
    
    OperationEndTime: Date | undefined;
    
    Operation: PatchOperationType | string | undefined;
    
    LastNoRebootInstallOperationTime?: Date;
    
    RebootOption?: RebootOption | string;
    
    CriticalNonCompliantCount?: number;
    
    SecurityNonCompliantCount?: number;
    
    OtherNonCompliantCount?: number;
}
export interface DescribeInstancePatchStatesResult {
    
    InstancePatchStates?: InstancePatchState[];
    
    NextToken?: string;
}
export declare enum InstancePatchStateOperatorType {
    EQUAL = "Equal",
    GREATER_THAN = "GreaterThan",
    LESS_THAN = "LessThan",
    NOT_EQUAL = "NotEqual"
}

export interface InstancePatchStateFilter {
    
    Key: string | undefined;
    
    Values: string[] | undefined;
    
    Type: InstancePatchStateOperatorType | string | undefined;
}
export interface DescribeInstancePatchStatesForPatchGroupRequest {
    
    PatchGroup: string | undefined;
    
    Filters?: InstancePatchStateFilter[];
    
    NextToken?: string;
    
    MaxResults?: number;
}
export interface DescribeInstancePatchStatesForPatchGroupResult {
    
    InstancePatchStates?: InstancePatchState[];
    
    NextToken?: string;
}
export interface DescribeInventoryDeletionsRequest {
    
    DeletionId?: string;
    
    NextToken?: string;
    
    MaxResults?: number;
}
export declare enum InventoryDeletionStatus {
    COMPLETE = "Complete",
    IN_PROGRESS = "InProgress"
}

export interface InventoryDeletionStatusItem {
    
    DeletionId?: string;
    
    TypeName?: string;
    
    DeletionStartTime?: Date;
    
    LastStatus?: InventoryDeletionStatus | string;
    
    LastStatusMessage?: string;
    
    DeletionSummary?: InventoryDeletionSummary;
    
    LastStatusUpdateTime?: Date;
}
export interface DescribeInventoryDeletionsResult {
    
    InventoryDeletions?: InventoryDeletionStatusItem[];
    
    NextToken?: string;
}

export declare class InvalidDeletionIdException extends __BaseException {
    readonly name: "InvalidDeletionIdException";
    readonly $fault: "client";
    Message?: string;
    
    constructor(opts: __ExceptionOptionType<InvalidDeletionIdException, __BaseException>);
}

export interface MaintenanceWindowFilter {
    
    Key?: string;
    
    Values?: string[];
}
export interface DescribeMaintenanceWindowExecutionsRequest {
    
    WindowId: string | undefined;
    
    Filters?: MaintenanceWindowFilter[];
    
    MaxResults?: number;
    
    NextToken?: string;
}
export declare enum MaintenanceWindowExecutionStatus {
    Cancelled = "CANCELLED",
    Cancelling = "CANCELLING",
    Failed = "FAILED",
    InProgress = "IN_PROGRESS",
    Pending = "PENDING",
    SkippedOverlapping = "SKIPPED_OVERLAPPING",
    Success = "SUCCESS",
    TimedOut = "TIMED_OUT"
}

export interface MaintenanceWindowExecution {
    
    WindowId?: string;
    
    WindowExecutionId?: string;
    
    Status?: MaintenanceWindowExecutionStatus | string;
    
    StatusDetails?: string;
    
    StartTime?: Date;
    
    EndTime?: Date;
}
export interface DescribeMaintenanceWindowExecutionsResult {
    
    WindowExecutions?: MaintenanceWindowExecution[];
    
    NextToken?: string;
}
export interface DescribeMaintenanceWindowExecutionTaskInvocationsRequest {
    
    WindowExecutionId: string | undefined;
    
    TaskId: string | undefined;
    
    Filters?: MaintenanceWindowFilter[];
    
    MaxResults?: number;
    
    NextToken?: string;
}
export declare enum MaintenanceWindowTaskType {
    Automation = "AUTOMATION",
    Lambda = "LAMBDA",
    RunCommand = "RUN_COMMAND",
    StepFunctions = "STEP_FUNCTIONS"
}

export interface MaintenanceWindowExecutionTaskInvocationIdentity {
    
    WindowExecutionId?: string;
    
    TaskExecutionId?: string;
    
    InvocationId?: string;
    
    ExecutionId?: string;
    
    TaskType?: MaintenanceWindowTaskType | string;
    
    Parameters?: string;
    
    Status?: MaintenanceWindowExecutionStatus | string;
    
    StatusDetails?: string;
    
    StartTime?: Date;
    
    EndTime?: Date;
    
    OwnerInformation?: string;
    
    WindowTargetId?: string;
}
export interface DescribeMaintenanceWindowExecutionTaskInvocationsResult {
    
    WindowExecutionTaskInvocationIdentities?: MaintenanceWindowExecutionTaskInvocationIdentity[];
    
    NextToken?: string;
}
export interface DescribeMaintenanceWindowExecutionTasksRequest {
    
    WindowExecutionId: string | undefined;
    
    Filters?: MaintenanceWindowFilter[];
    
    MaxResults?: number;
    
    NextToken?: string;
}

export interface MaintenanceWindowExecutionTaskIdentity {
    
    WindowExecutionId?: string;
    
    TaskExecutionId?: string;
    
    Status?: MaintenanceWindowExecutionStatus | string;
    
    StatusDetails?: string;
    
    StartTime?: Date;
    
    EndTime?: Date;
    
    TaskArn?: string;
    
    TaskType?: MaintenanceWindowTaskType | string;
}
export interface DescribeMaintenanceWindowExecutionTasksResult {
    
    WindowExecutionTaskIdentities?: MaintenanceWindowExecutionTaskIdentity[];
    
    NextToken?: string;
}
export interface DescribeMaintenanceWindowsRequest {
    
    Filters?: MaintenanceWindowFilter[];
    
    MaxResults?: number;
    
    NextToken?: string;
}

export interface MaintenanceWindowIdentity {
    
    WindowId?: string;
    
    Name?: string;
    
    Description?: string;
    
    Enabled?: boolean;
    
    Duration?: number;
    
    Cutoff?: number;
    
    Schedule?: string;
    
    ScheduleTimezone?: string;
    
    ScheduleOffset?: number;
    
    EndDate?: string;
    
    StartDate?: string;
    
    NextExecutionTime?: string;
}
export interface DescribeMaintenanceWindowsResult {
    
    WindowIdentities?: MaintenanceWindowIdentity[];
    
    NextToken?: string;
}
export declare enum MaintenanceWindowResourceType {
    Instance = "INSTANCE",
    ResourceGroup = "RESOURCE_GROUP"
}
export interface DescribeMaintenanceWindowScheduleRequest {
    
    WindowId?: string;
    
    Targets?: Target[];
    
    ResourceType?: MaintenanceWindowResourceType | string;
    
    Filters?: PatchOrchestratorFilter[];
    
    MaxResults?: number;
    
    NextToken?: string;
}

export interface ScheduledWindowExecution {
    
    WindowId?: string;
    
    Name?: string;
    
    ExecutionTime?: string;
}
export interface DescribeMaintenanceWindowScheduleResult {
    
    ScheduledWindowExecutions?: ScheduledWindowExecution[];
    
    NextToken?: string;
}
export interface DescribeMaintenanceWindowsForTargetRequest {
    
    Targets: Target[] | undefined;
    
    ResourceType: MaintenanceWindowResourceType | string | undefined;
    
    MaxResults?: number;
    
    NextToken?: string;
}

export interface MaintenanceWindowIdentityForTarget {
    
    WindowId?: string;
    
    Name?: string;
}
export interface DescribeMaintenanceWindowsForTargetResult {
    
    WindowIdentities?: MaintenanceWindowIdentityForTarget[];
    
    NextToken?: string;
}
export interface DescribeMaintenanceWindowTargetsRequest {
    
    WindowId: string | undefined;
    
    Filters?: MaintenanceWindowFilter[];
    
    MaxResults?: number;
    
    NextToken?: string;
}

export interface MaintenanceWindowTarget {
    
    WindowId?: string;
    
    WindowTargetId?: string;
    
    ResourceType?: MaintenanceWindowResourceType | string;
    
    Targets?: Target[];
    
    OwnerInformation?: string;
    
    Name?: string;
    
    Description?: string;
}
export interface DescribeMaintenanceWindowTargetsResult {
    
    Targets?: MaintenanceWindowTarget[];
    
    NextToken?: string;
}
export interface DescribeMaintenanceWindowTasksRequest {
    
    WindowId: string | undefined;
    
    Filters?: MaintenanceWindowFilter[];
    
    MaxResults?: number;
    
    NextToken?: string;
}
export declare enum MaintenanceWindowTaskCutoffBehavior {
    CancelTask = "CANCEL_TASK",
    ContinueTask = "CONTINUE_TASK"
}

export interface LoggingInfo {
    
    S3BucketName: string | undefined;
    
    S3KeyPrefix?: string;
    
    S3Region: string | undefined;
}

export interface MaintenanceWindowTaskParameterValueExpression {
    
    Values?: string[];
}

export interface MaintenanceWindowTask {
    
    WindowId?: string;
    
    WindowTaskId?: string;
    
    TaskArn?: string;
    
    Type?: MaintenanceWindowTaskType | string;
    
    Targets?: Target[];
    
    TaskParameters?: Record<string, MaintenanceWindowTaskParameterValueExpression>;
    
    Priority?: number;
    
    LoggingInfo?: LoggingInfo;
    
    ServiceRoleArn?: string;
    
    MaxConcurrency?: string;
    
    MaxErrors?: string;
    
    Name?: string;
    
    Description?: string;
    
    CutoffBehavior?: MaintenanceWindowTaskCutoffBehavior | string;
}
export interface DescribeMaintenanceWindowTasksResult {
    
    Tasks?: MaintenanceWindowTask[];
    
    NextToken?: string;
}
export declare enum OpsItemFilterKey {
    ACTUAL_END_TIME = "ActualEndTime",
    ACTUAL_START_TIME = "ActualStartTime",
    AUTOMATION_ID = "AutomationId",
    CATEGORY = "Category",
    CHANGE_REQUEST_APPROVER_ARN = "ChangeRequestByApproverArn",
    CHANGE_REQUEST_APPROVER_NAME = "ChangeRequestByApproverName",
    CHANGE_REQUEST_REQUESTER_ARN = "ChangeRequestByRequesterArn",
    CHANGE_REQUEST_REQUESTER_NAME = "ChangeRequestByRequesterName",
    CHANGE_REQUEST_TARGETS_RESOURCE_GROUP = "ChangeRequestByTargetsResourceGroup",
    CHANGE_REQUEST_TEMPLATE = "ChangeRequestByTemplate",
    CREATED_BY = "CreatedBy",
    CREATED_TIME = "CreatedTime",
    INSIGHT_TYPE = "InsightByType",
    LAST_MODIFIED_TIME = "LastModifiedTime",
    OPERATIONAL_DATA = "OperationalData",
    OPERATIONAL_DATA_KEY = "OperationalDataKey",
    OPERATIONAL_DATA_VALUE = "OperationalDataValue",
    OPSITEM_ID = "OpsItemId",
    OPSITEM_TYPE = "OpsItemType",
    PLANNED_END_TIME = "PlannedEndTime",
    PLANNED_START_TIME = "PlannedStartTime",
    PRIORITY = "Priority",
    RESOURCE_ID = "ResourceId",
    SEVERITY = "Severity",
    SOURCE = "Source",
    STATUS = "Status",
    TITLE = "Title"
}
export declare enum OpsItemFilterOperator {
    CONTAINS = "Contains",
    EQUAL = "Equal",
    GREATER_THAN = "GreaterThan",
    LESS_THAN = "LessThan"
}

export interface OpsItemFilter {
    
    Key: OpsItemFilterKey | string | undefined;
    
    Values: string[] | undefined;
    
    Operator: OpsItemFilterOperator | string | undefined;
}
export interface DescribeOpsItemsRequest {
    
    OpsItemFilters?: OpsItemFilter[];
    
    MaxResults?: number;
    
    NextToken?: string;
}
export declare enum OpsItemStatus {
    APPROVED = "Approved",
    CANCELLED = "Cancelled",
    CANCELLING = "Cancelling",
    CHANGE_CALENDAR_OVERRIDE_APPROVED = "ChangeCalendarOverrideApproved",
    CHANGE_CALENDAR_OVERRIDE_REJECTED = "ChangeCalendarOverrideRejected",
    CLOSED = "Closed",
    COMPLETED_WITH_FAILURE = "CompletedWithFailure",
    COMPLETED_WITH_SUCCESS = "CompletedWithSuccess",
    FAILED = "Failed",
    IN_PROGRESS = "InProgress",
    OPEN = "Open",
    PENDING = "Pending",
    PENDING_APPROVAL = "PendingApproval",
    PENDING_CHANGE_CALENDAR_OVERRIDE = "PendingChangeCalendarOverride",
    REJECTED = "Rejected",
    RESOLVED = "Resolved",
    RUNBOOK_IN_PROGRESS = "RunbookInProgress",
    SCHEDULED = "Scheduled",
    TIMED_OUT = "TimedOut"
}

export interface OpsItemSummary {
    
    CreatedBy?: string;
    
    CreatedTime?: Date;
    
    LastModifiedBy?: string;
    
    LastModifiedTime?: Date;
    
    Priority?: number;
    
    Source?: string;
    
    Status?: OpsItemStatus | string;
    
    OpsItemId?: string;
    
    Title?: string;
    
    OperationalData?: Record<string, OpsItemDataValue>;
    
    Category?: string;
    
    Severity?: string;
    
    OpsItemType?: string;
    
    ActualStartTime?: Date;
    
    ActualEndTime?: Date;
    
    PlannedStartTime?: Date;
    
    PlannedEndTime?: Date;
}
export interface DescribeOpsItemsResponse {
    
    NextToken?: string;
    
    OpsItemSummaries?: OpsItemSummary[];
}
export declare enum ParametersFilterKey {
    KEY_ID = "KeyId",
    NAME = "Name",
    TYPE = "Type"
}

export interface ParametersFilter {
    
    Key: ParametersFilterKey | string | undefined;
    
    Values: string[] | undefined;
}

export interface ParameterStringFilter {
    
    Key: string | undefined;
    
    Option?: string;
    
    Values?: string[];
}
export interface DescribeParametersRequest {
    
    Filters?: ParametersFilter[];
    
    ParameterFilters?: ParameterStringFilter[];
    
    MaxResults?: number;
    
    NextToken?: string;
}

export interface ParameterInlinePolicy {
    
    PolicyText?: string;
    
    PolicyType?: string;
    
    PolicyStatus?: string;
}

export declare const AccountSharingInfoFilterSensitiveLog: (obj: AccountSharingInfo) => any;

export declare const TagFilterSensitiveLog: (obj: Tag) => any;

export declare const ActivationFilterSensitiveLog: (obj: Activation) => any;

export declare const AddTagsToResourceRequestFilterSensitiveLog: (obj: AddTagsToResourceRequest) => any;

export declare const AddTagsToResourceResultFilterSensitiveLog: (obj: AddTagsToResourceResult) => any;

export declare const AssociateOpsItemRelatedItemRequestFilterSensitiveLog: (obj: AssociateOpsItemRelatedItemRequest) => any;

export declare const AssociateOpsItemRelatedItemResponseFilterSensitiveLog: (obj: AssociateOpsItemRelatedItemResponse) => any;

export declare const CancelCommandRequestFilterSensitiveLog: (obj: CancelCommandRequest) => any;

export declare const CancelCommandResultFilterSensitiveLog: (obj: CancelCommandResult) => any;

export declare const CancelMaintenanceWindowExecutionRequestFilterSensitiveLog: (obj: CancelMaintenanceWindowExecutionRequest) => any;

export declare const CancelMaintenanceWindowExecutionResultFilterSensitiveLog: (obj: CancelMaintenanceWindowExecutionResult) => any;

export declare const RegistrationMetadataItemFilterSensitiveLog: (obj: RegistrationMetadataItem) => any;

export declare const CreateActivationRequestFilterSensitiveLog: (obj: CreateActivationRequest) => any;

export declare const CreateActivationResultFilterSensitiveLog: (obj: CreateActivationResult) => any;

export declare const S3OutputLocationFilterSensitiveLog: (obj: S3OutputLocation) => any;

export declare const InstanceAssociationOutputLocationFilterSensitiveLog: (obj: InstanceAssociationOutputLocation) => any;

export declare const TargetLocationFilterSensitiveLog: (obj: TargetLocation) => any;

export declare const TargetFilterSensitiveLog: (obj: Target) => any;

export declare const CreateAssociationRequestFilterSensitiveLog: (obj: CreateAssociationRequest) => any;

export declare const AssociationOverviewFilterSensitiveLog: (obj: AssociationOverview) => any;

export declare const AssociationStatusFilterSensitiveLog: (obj: AssociationStatus) => any;

export declare const AssociationDescriptionFilterSensitiveLog: (obj: AssociationDescription) => any;

export declare const CreateAssociationResultFilterSensitiveLog: (obj: CreateAssociationResult) => any;

export declare const CreateAssociationBatchRequestEntryFilterSensitiveLog: (obj: CreateAssociationBatchRequestEntry) => any;

export declare const CreateAssociationBatchRequestFilterSensitiveLog: (obj: CreateAssociationBatchRequest) => any;

export declare const FailedCreateAssociationFilterSensitiveLog: (obj: FailedCreateAssociation) => any;

export declare const CreateAssociationBatchResultFilterSensitiveLog: (obj: CreateAssociationBatchResult) => any;

export declare const AttachmentsSourceFilterSensitiveLog: (obj: AttachmentsSource) => any;

export declare const DocumentRequiresFilterSensitiveLog: (obj: DocumentRequires) => any;

export declare const CreateDocumentRequestFilterSensitiveLog: (obj: CreateDocumentRequest) => any;

export declare const AttachmentInformationFilterSensitiveLog: (obj: AttachmentInformation) => any;

export declare const DocumentParameterFilterSensitiveLog: (obj: DocumentParameter) => any;

export declare const ReviewInformationFilterSensitiveLog: (obj: ReviewInformation) => any;

export declare const DocumentDescriptionFilterSensitiveLog: (obj: DocumentDescription) => any;

export declare const CreateDocumentResultFilterSensitiveLog: (obj: CreateDocumentResult) => any;

export declare const CreateMaintenanceWindowRequestFilterSensitiveLog: (obj: CreateMaintenanceWindowRequest) => any;

export declare const CreateMaintenanceWindowResultFilterSensitiveLog: (obj: CreateMaintenanceWindowResult) => any;

export declare const OpsItemNotificationFilterSensitiveLog: (obj: OpsItemNotification) => any;

export declare const OpsItemDataValueFilterSensitiveLog: (obj: OpsItemDataValue) => any;

export declare const RelatedOpsItemFilterSensitiveLog: (obj: RelatedOpsItem) => any;

export declare const CreateOpsItemRequestFilterSensitiveLog: (obj: CreateOpsItemRequest) => any;

export declare const CreateOpsItemResponseFilterSensitiveLog: (obj: CreateOpsItemResponse) => any;

export declare const MetadataValueFilterSensitiveLog: (obj: MetadataValue) => any;

export declare const CreateOpsMetadataRequestFilterSensitiveLog: (obj: CreateOpsMetadataRequest) => any;

export declare const CreateOpsMetadataResultFilterSensitiveLog: (obj: CreateOpsMetadataResult) => any;

export declare const PatchFilterFilterSensitiveLog: (obj: PatchFilter) => any;

export declare const PatchFilterGroupFilterSensitiveLog: (obj: PatchFilterGroup) => any;

export declare const PatchRuleFilterSensitiveLog: (obj: PatchRule) => any;

export declare const PatchRuleGroupFilterSensitiveLog: (obj: PatchRuleGroup) => any;

export declare const PatchSourceFilterSensitiveLog: (obj: PatchSource) => any;

export declare const CreatePatchBaselineRequestFilterSensitiveLog: (obj: CreatePatchBaselineRequest) => any;

export declare const CreatePatchBaselineResultFilterSensitiveLog: (obj: CreatePatchBaselineResult) => any;

export declare const ResourceDataSyncDestinationDataSharingFilterSensitiveLog: (obj: ResourceDataSyncDestinationDataSharing) => any;

export declare const ResourceDataSyncS3DestinationFilterSensitiveLog: (obj: ResourceDataSyncS3Destination) => any;

export declare const ResourceDataSyncOrganizationalUnitFilterSensitiveLog: (obj: ResourceDataSyncOrganizationalUnit) => any;

export declare const ResourceDataSyncAwsOrganizationsSourceFilterSensitiveLog: (obj: ResourceDataSyncAwsOrganizationsSource) => any;

export declare const ResourceDataSyncSourceFilterSensitiveLog: (obj: ResourceDataSyncSource) => any;

export declare const CreateResourceDataSyncRequestFilterSensitiveLog: (obj: CreateResourceDataSyncRequest) => any;

export declare const CreateResourceDataSyncResultFilterSensitiveLog: (obj: CreateResourceDataSyncResult) => any;

export declare const DeleteActivationRequestFilterSensitiveLog: (obj: DeleteActivationRequest) => any;

export declare const DeleteActivationResultFilterSensitiveLog: (obj: DeleteActivationResult) => any;

export declare const DeleteAssociationRequestFilterSensitiveLog: (obj: DeleteAssociationRequest) => any;

export declare const DeleteAssociationResultFilterSensitiveLog: (obj: DeleteAssociationResult) => any;

export declare const DeleteDocumentRequestFilterSensitiveLog: (obj: DeleteDocumentRequest) => any;

export declare const DeleteDocumentResultFilterSensitiveLog: (obj: DeleteDocumentResult) => any;

export declare const DeleteInventoryRequestFilterSensitiveLog: (obj: DeleteInventoryRequest) => any;

export declare const InventoryDeletionSummaryItemFilterSensitiveLog: (obj: InventoryDeletionSummaryItem) => any;

export declare const InventoryDeletionSummaryFilterSensitiveLog: (obj: InventoryDeletionSummary) => any;

export declare const DeleteInventoryResultFilterSensitiveLog: (obj: DeleteInventoryResult) => any;

export declare const DeleteMaintenanceWindowRequestFilterSensitiveLog: (obj: DeleteMaintenanceWindowRequest) => any;

export declare const DeleteMaintenanceWindowResultFilterSensitiveLog: (obj: DeleteMaintenanceWindowResult) => any;

export declare const DeleteOpsMetadataRequestFilterSensitiveLog: (obj: DeleteOpsMetadataRequest) => any;

export declare const DeleteOpsMetadataResultFilterSensitiveLog: (obj: DeleteOpsMetadataResult) => any;

export declare const DeleteParameterRequestFilterSensitiveLog: (obj: DeleteParameterRequest) => any;

export declare const DeleteParameterResultFilterSensitiveLog: (obj: DeleteParameterResult) => any;

export declare const DeleteParametersRequestFilterSensitiveLog: (obj: DeleteParametersRequest) => any;

export declare const DeleteParametersResultFilterSensitiveLog: (obj: DeleteParametersResult) => any;

export declare const DeletePatchBaselineRequestFilterSensitiveLog: (obj: DeletePatchBaselineRequest) => any;

export declare const DeletePatchBaselineResultFilterSensitiveLog: (obj: DeletePatchBaselineResult) => any;

export declare const DeleteResourceDataSyncRequestFilterSensitiveLog: (obj: DeleteResourceDataSyncRequest) => any;

export declare const DeleteResourceDataSyncResultFilterSensitiveLog: (obj: DeleteResourceDataSyncResult) => any;

export declare const DeregisterManagedInstanceRequestFilterSensitiveLog: (obj: DeregisterManagedInstanceRequest) => any;

export declare const DeregisterManagedInstanceResultFilterSensitiveLog: (obj: DeregisterManagedInstanceResult) => any;

export declare const DeregisterPatchBaselineForPatchGroupRequestFilterSensitiveLog: (obj: DeregisterPatchBaselineForPatchGroupRequest) => any;

export declare const DeregisterPatchBaselineForPatchGroupResultFilterSensitiveLog: (obj: DeregisterPatchBaselineForPatchGroupResult) => any;

export declare const DeregisterTargetFromMaintenanceWindowRequestFilterSensitiveLog: (obj: DeregisterTargetFromMaintenanceWindowRequest) => any;

export declare const DeregisterTargetFromMaintenanceWindowResultFilterSensitiveLog: (obj: DeregisterTargetFromMaintenanceWindowResult) => any;

export declare const DeregisterTaskFromMaintenanceWindowRequestFilterSensitiveLog: (obj: DeregisterTaskFromMaintenanceWindowRequest) => any;

export declare const DeregisterTaskFromMaintenanceWindowResultFilterSensitiveLog: (obj: DeregisterTaskFromMaintenanceWindowResult) => any;

export declare const DescribeActivationsFilterFilterSensitiveLog: (obj: DescribeActivationsFilter) => any;

export declare const DescribeActivationsRequestFilterSensitiveLog: (obj: DescribeActivationsRequest) => any;

export declare const DescribeActivationsResultFilterSensitiveLog: (obj: DescribeActivationsResult) => any;

export declare const DescribeAssociationRequestFilterSensitiveLog: (obj: DescribeAssociationRequest) => any;

export declare const DescribeAssociationResultFilterSensitiveLog: (obj: DescribeAssociationResult) => any;

export declare const AssociationExecutionFilterFilterSensitiveLog: (obj: AssociationExecutionFilter) => any;

export declare const DescribeAssociationExecutionsRequestFilterSensitiveLog: (obj: DescribeAssociationExecutionsRequest) => any;

export declare const AssociationExecutionFilterSensitiveLog: (obj: AssociationExecution) => any;

export declare const DescribeAssociationExecutionsResultFilterSensitiveLog: (obj: DescribeAssociationExecutionsResult) => any;

export declare const AssociationExecutionTargetsFilterFilterSensitiveLog: (obj: AssociationExecutionTargetsFilter) => any;

export declare const DescribeAssociationExecutionTargetsRequestFilterSensitiveLog: (obj: DescribeAssociationExecutionTargetsRequest) => any;

export declare const OutputSourceFilterSensitiveLog: (obj: OutputSource) => any;

export declare const AssociationExecutionTargetFilterSensitiveLog: (obj: AssociationExecutionTarget) => any;

export declare const DescribeAssociationExecutionTargetsResultFilterSensitiveLog: (obj: DescribeAssociationExecutionTargetsResult) => any;

export declare const AutomationExecutionFilterFilterSensitiveLog: (obj: AutomationExecutionFilter) => any;

export declare const DescribeAutomationExecutionsRequestFilterSensitiveLog: (obj: DescribeAutomationExecutionsRequest) => any;

export declare const ResolvedTargetsFilterSensitiveLog: (obj: ResolvedTargets) => any;

export declare const RunbookFilterSensitiveLog: (obj: Runbook) => any;

export declare const AutomationExecutionMetadataFilterSensitiveLog: (obj: AutomationExecutionMetadata) => any;

export declare const DescribeAutomationExecutionsResultFilterSensitiveLog: (obj: DescribeAutomationExecutionsResult) => any;

export declare const StepExecutionFilterFilterSensitiveLog: (obj: StepExecutionFilter) => any;

export declare const DescribeAutomationStepExecutionsRequestFilterSensitiveLog: (obj: DescribeAutomationStepExecutionsRequest) => any;

export declare const FailureDetailsFilterSensitiveLog: (obj: FailureDetails) => any;

export declare const StepExecutionFilterSensitiveLog: (obj: StepExecution) => any;

export declare const DescribeAutomationStepExecutionsResultFilterSensitiveLog: (obj: DescribeAutomationStepExecutionsResult) => any;

export declare const PatchOrchestratorFilterFilterSensitiveLog: (obj: PatchOrchestratorFilter) => any;

export declare const DescribeAvailablePatchesRequestFilterSensitiveLog: (obj: DescribeAvailablePatchesRequest) => any;

export declare const PatchFilterSensitiveLog: (obj: Patch) => any;

export declare const DescribeAvailablePatchesResultFilterSensitiveLog: (obj: DescribeAvailablePatchesResult) => any;

export declare const DescribeDocumentRequestFilterSensitiveLog: (obj: DescribeDocumentRequest) => any;

export declare const DescribeDocumentResultFilterSensitiveLog: (obj: DescribeDocumentResult) => any;

export declare const DescribeDocumentPermissionRequestFilterSensitiveLog: (obj: DescribeDocumentPermissionRequest) => any;

export declare const DescribeDocumentPermissionResponseFilterSensitiveLog: (obj: DescribeDocumentPermissionResponse) => any;

export declare const DescribeEffectiveInstanceAssociationsRequestFilterSensitiveLog: (obj: DescribeEffectiveInstanceAssociationsRequest) => any;

export declare const InstanceAssociationFilterSensitiveLog: (obj: InstanceAssociation) => any;

export declare const DescribeEffectiveInstanceAssociationsResultFilterSensitiveLog: (obj: DescribeEffectiveInstanceAssociationsResult) => any;

export declare const DescribeEffectivePatchesForPatchBaselineRequestFilterSensitiveLog: (obj: DescribeEffectivePatchesForPatchBaselineRequest) => any;

export declare const PatchStatusFilterSensitiveLog: (obj: PatchStatus) => any;

export declare const EffectivePatchFilterSensitiveLog: (obj: EffectivePatch) => any;

export declare const DescribeEffectivePatchesForPatchBaselineResultFilterSensitiveLog: (obj: DescribeEffectivePatchesForPatchBaselineResult) => any;

export declare const DescribeInstanceAssociationsStatusRequestFilterSensitiveLog: (obj: DescribeInstanceAssociationsStatusRequest) => any;

export declare const S3OutputUrlFilterSensitiveLog: (obj: S3OutputUrl) => any;

export declare const InstanceAssociationOutputUrlFilterSensitiveLog: (obj: InstanceAssociationOutputUrl) => any;

export declare const InstanceAssociationStatusInfoFilterSensitiveLog: (obj: InstanceAssociationStatusInfo) => any;

export declare const DescribeInstanceAssociationsStatusResultFilterSensitiveLog: (obj: DescribeInstanceAssociationsStatusResult) => any;

export declare const InstanceInformationStringFilterFilterSensitiveLog: (obj: InstanceInformationStringFilter) => any;

export declare const InstanceInformationFilterFilterSensitiveLog: (obj: InstanceInformationFilter) => any;

export declare const DescribeInstanceInformationRequestFilterSensitiveLog: (obj: DescribeInstanceInformationRequest) => any;

export declare const InstanceAggregatedAssociationOverviewFilterSensitiveLog: (obj: InstanceAggregatedAssociationOverview) => any;

export declare const InstanceInformationFilterSensitiveLog: (obj: InstanceInformation) => any;

export declare const DescribeInstanceInformationResultFilterSensitiveLog: (obj: DescribeInstanceInformationResult) => any;

export declare const DescribeInstancePatchesRequestFilterSensitiveLog: (obj: DescribeInstancePatchesRequest) => any;

export declare const PatchComplianceDataFilterSensitiveLog: (obj: PatchComplianceData) => any;

export declare const DescribeInstancePatchesResultFilterSensitiveLog: (obj: DescribeInstancePatchesResult) => any;

export declare const DescribeInstancePatchStatesRequestFilterSensitiveLog: (obj: DescribeInstancePatchStatesRequest) => any;

export declare const InstancePatchStateFilterSensitiveLog: (obj: InstancePatchState) => any;

export declare const DescribeInstancePatchStatesResultFilterSensitiveLog: (obj: DescribeInstancePatchStatesResult) => any;

export declare const InstancePatchStateFilterFilterSensitiveLog: (obj: InstancePatchStateFilter) => any;

export declare const DescribeInstancePatchStatesForPatchGroupRequestFilterSensitiveLog: (obj: DescribeInstancePatchStatesForPatchGroupRequest) => any;

export declare const DescribeInstancePatchStatesForPatchGroupResultFilterSensitiveLog: (obj: DescribeInstancePatchStatesForPatchGroupResult) => any;

export declare const DescribeInventoryDeletionsRequestFilterSensitiveLog: (obj: DescribeInventoryDeletionsRequest) => any;

export declare const InventoryDeletionStatusItemFilterSensitiveLog: (obj: InventoryDeletionStatusItem) => any;

export declare const DescribeInventoryDeletionsResultFilterSensitiveLog: (obj: DescribeInventoryDeletionsResult) => any;

export declare const MaintenanceWindowFilterFilterSensitiveLog: (obj: MaintenanceWindowFilter) => any;

export declare const DescribeMaintenanceWindowExecutionsRequestFilterSensitiveLog: (obj: DescribeMaintenanceWindowExecutionsRequest) => any;

export declare const MaintenanceWindowExecutionFilterSensitiveLog: (obj: MaintenanceWindowExecution) => any;

export declare const DescribeMaintenanceWindowExecutionsResultFilterSensitiveLog: (obj: DescribeMaintenanceWindowExecutionsResult) => any;

export declare const DescribeMaintenanceWindowExecutionTaskInvocationsRequestFilterSensitiveLog: (obj: DescribeMaintenanceWindowExecutionTaskInvocationsRequest) => any;

export declare const MaintenanceWindowExecutionTaskInvocationIdentityFilterSensitiveLog: (obj: MaintenanceWindowExecutionTaskInvocationIdentity) => any;

export declare const DescribeMaintenanceWindowExecutionTaskInvocationsResultFilterSensitiveLog: (obj: DescribeMaintenanceWindowExecutionTaskInvocationsResult) => any;

export declare const DescribeMaintenanceWindowExecutionTasksRequestFilterSensitiveLog: (obj: DescribeMaintenanceWindowExecutionTasksRequest) => any;

export declare const MaintenanceWindowExecutionTaskIdentityFilterSensitiveLog: (obj: MaintenanceWindowExecutionTaskIdentity) => any;

export declare const DescribeMaintenanceWindowExecutionTasksResultFilterSensitiveLog: (obj: DescribeMaintenanceWindowExecutionTasksResult) => any;

export declare const DescribeMaintenanceWindowsRequestFilterSensitiveLog: (obj: DescribeMaintenanceWindowsRequest) => any;

export declare const MaintenanceWindowIdentityFilterSensitiveLog: (obj: MaintenanceWindowIdentity) => any;

export declare const DescribeMaintenanceWindowsResultFilterSensitiveLog: (obj: DescribeMaintenanceWindowsResult) => any;

export declare const DescribeMaintenanceWindowScheduleRequestFilterSensitiveLog: (obj: DescribeMaintenanceWindowScheduleRequest) => any;

export declare const ScheduledWindowExecutionFilterSensitiveLog: (obj: ScheduledWindowExecution) => any;

export declare const DescribeMaintenanceWindowScheduleResultFilterSensitiveLog: (obj: DescribeMaintenanceWindowScheduleResult) => any;

export declare const DescribeMaintenanceWindowsForTargetRequestFilterSensitiveLog: (obj: DescribeMaintenanceWindowsForTargetRequest) => any;

export declare const MaintenanceWindowIdentityForTargetFilterSensitiveLog: (obj: MaintenanceWindowIdentityForTarget) => any;

export declare const DescribeMaintenanceWindowsForTargetResultFilterSensitiveLog: (obj: DescribeMaintenanceWindowsForTargetResult) => any;

export declare const DescribeMaintenanceWindowTargetsRequestFilterSensitiveLog: (obj: DescribeMaintenanceWindowTargetsRequest) => any;

export declare const MaintenanceWindowTargetFilterSensitiveLog: (obj: MaintenanceWindowTarget) => any;

export declare const DescribeMaintenanceWindowTargetsResultFilterSensitiveLog: (obj: DescribeMaintenanceWindowTargetsResult) => any;

export declare const DescribeMaintenanceWindowTasksRequestFilterSensitiveLog: (obj: DescribeMaintenanceWindowTasksRequest) => any;

export declare const LoggingInfoFilterSensitiveLog: (obj: LoggingInfo) => any;

export declare const MaintenanceWindowTaskParameterValueExpressionFilterSensitiveLog: (obj: MaintenanceWindowTaskParameterValueExpression) => any;

export declare const MaintenanceWindowTaskFilterSensitiveLog: (obj: MaintenanceWindowTask) => any;

export declare const DescribeMaintenanceWindowTasksResultFilterSensitiveLog: (obj: DescribeMaintenanceWindowTasksResult) => any;

export declare const OpsItemFilterFilterSensitiveLog: (obj: OpsItemFilter) => any;

export declare const DescribeOpsItemsRequestFilterSensitiveLog: (obj: DescribeOpsItemsRequest) => any;

export declare const OpsItemSummaryFilterSensitiveLog: (obj: OpsItemSummary) => any;

export declare const DescribeOpsItemsResponseFilterSensitiveLog: (obj: DescribeOpsItemsResponse) => any;

export declare const ParametersFilterFilterSensitiveLog: (obj: ParametersFilter) => any;

export declare const ParameterStringFilterFilterSensitiveLog: (obj: ParameterStringFilter) => any;

export declare const DescribeParametersRequestFilterSensitiveLog: (obj: DescribeParametersRequest) => any;

export declare const ParameterInlinePolicyFilterSensitiveLog: (obj: ParameterInlinePolicy) => any;
