import { __assign, __extends } from "tslib";
import { SENSITIVE_STRING } from "@aws-sdk/smithy-client";
import { AssociationDescriptionFilterSensitiveLog, PatchSourceFilterSensitiveLog, } from "./models_0";
import { SSMServiceException as __BaseException } from "./SSMServiceException";
export var ParameterTier;
(function (ParameterTier) {
    ParameterTier["ADVANCED"] = "Advanced";
    ParameterTier["INTELLIGENT_TIERING"] = "Intelligent-Tiering";
    ParameterTier["STANDARD"] = "Standard";
})(ParameterTier || (ParameterTier = {}));
export var ParameterType;
(function (ParameterType) {
    ParameterType["SECURE_STRING"] = "SecureString";
    ParameterType["STRING"] = "String";
    ParameterType["STRING_LIST"] = "StringList";
})(ParameterType || (ParameterType = {}));
var InvalidFilterOption = (function (_super) {
    __extends(InvalidFilterOption, _super);
    function InvalidFilterOption(opts) {
        var _this = _super.call(this, __assign({ name: "InvalidFilterOption", $fault: "client" }, opts)) || this;
        _this.name = "InvalidFilterOption";
        _this.$fault = "client";
        Object.setPrototypeOf(_this, InvalidFilterOption.prototype);
        return _this;
    }
    return InvalidFilterOption;
}(__BaseException));
export { InvalidFilterOption };
export var PatchSet;
(function (PatchSet) {
    PatchSet["Application"] = "APPLICATION";
    PatchSet["Os"] = "OS";
})(PatchSet || (PatchSet = {}));
export var PatchProperty;
(function (PatchProperty) {
    PatchProperty["PatchClassification"] = "CLASSIFICATION";
    PatchProperty["PatchMsrcSeverity"] = "MSRC_SEVERITY";
    PatchProperty["PatchPriority"] = "PRIORITY";
    PatchProperty["PatchProductFamily"] = "PRODUCT_FAMILY";
    PatchProperty["PatchSeverity"] = "SEVERITY";
    PatchProperty["Product"] = "PRODUCT";
})(PatchProperty || (PatchProperty = {}));
export var SessionFilterKey;
(function (SessionFilterKey) {
    SessionFilterKey["INVOKED_AFTER"] = "InvokedAfter";
    SessionFilterKey["INVOKED_BEFORE"] = "InvokedBefore";
    SessionFilterKey["OWNER"] = "Owner";
    SessionFilterKey["SESSION_ID"] = "SessionId";
    SessionFilterKey["STATUS"] = "Status";
    SessionFilterKey["TARGET_ID"] = "Target";
})(SessionFilterKey || (SessionFilterKey = {}));
export var SessionState;
(function (SessionState) {
    SessionState["ACTIVE"] = "Active";
    SessionState["HISTORY"] = "History";
})(SessionState || (SessionState = {}));
export var SessionStatus;
(function (SessionStatus) {
    SessionStatus["CONNECTED"] = "Connected";
    SessionStatus["CONNECTING"] = "Connecting";
    SessionStatus["DISCONNECTED"] = "Disconnected";
    SessionStatus["FAILED"] = "Failed";
    SessionStatus["TERMINATED"] = "Terminated";
    SessionStatus["TERMINATING"] = "Terminating";
})(SessionStatus || (SessionStatus = {}));
var OpsItemRelatedItemAssociationNotFoundException = (function (_super) {
    __extends(OpsItemRelatedItemAssociationNotFoundException, _super);
    function OpsItemRelatedItemAssociationNotFoundException(opts) {
        var _this = _super.call(this, __assign({ name: "OpsItemRelatedItemAssociationNotFoundException", $fault: "client" }, opts)) || this;
        _this.name = "OpsItemRelatedItemAssociationNotFoundException";
        _this.$fault = "client";
        Object.setPrototypeOf(_this, OpsItemRelatedItemAssociationNotFoundException.prototype);
        _this.Message = opts.Message;
        return _this;
    }
    return OpsItemRelatedItemAssociationNotFoundException;
}(__BaseException));
export { OpsItemRelatedItemAssociationNotFoundException };
export var CalendarState;
(function (CalendarState) {
    CalendarState["CLOSED"] = "CLOSED";
    CalendarState["OPEN"] = "OPEN";
})(CalendarState || (CalendarState = {}));
var InvalidDocumentType = (function (_super) {
    __extends(InvalidDocumentType, _super);
    function InvalidDocumentType(opts) {
        var _this = _super.call(this, __assign({ name: "InvalidDocumentType", $fault: "client" }, opts)) || this;
        _this.name = "InvalidDocumentType";
        _this.$fault = "client";
        Object.setPrototypeOf(_this, InvalidDocumentType.prototype);
        _this.Message = opts.Message;
        return _this;
    }
    return InvalidDocumentType;
}(__BaseException));
export { InvalidDocumentType };
var UnsupportedCalendarException = (function (_super) {
    __extends(UnsupportedCalendarException, _super);
    function UnsupportedCalendarException(opts) {
        var _this = _super.call(this, __assign({ name: "UnsupportedCalendarException", $fault: "client" }, opts)) || this;
        _this.name = "UnsupportedCalendarException";
        _this.$fault = "client";
        Object.setPrototypeOf(_this, UnsupportedCalendarException.prototype);
        _this.Message = opts.Message;
        return _this;
    }
    return UnsupportedCalendarException;
}(__BaseException));
export { UnsupportedCalendarException };
export var CommandInvocationStatus;
(function (CommandInvocationStatus) {
    CommandInvocationStatus["CANCELLED"] = "Cancelled";
    CommandInvocationStatus["CANCELLING"] = "Cancelling";
    CommandInvocationStatus["DELAYED"] = "Delayed";
    CommandInvocationStatus["FAILED"] = "Failed";
    CommandInvocationStatus["IN_PROGRESS"] = "InProgress";
    CommandInvocationStatus["PENDING"] = "Pending";
    CommandInvocationStatus["SUCCESS"] = "Success";
    CommandInvocationStatus["TIMED_OUT"] = "TimedOut";
})(CommandInvocationStatus || (CommandInvocationStatus = {}));
var InvalidPluginName = (function (_super) {
    __extends(InvalidPluginName, _super);
    function InvalidPluginName(opts) {
        var _this = _super.call(this, __assign({ name: "InvalidPluginName", $fault: "client" }, opts)) || this;
        _this.name = "InvalidPluginName";
        _this.$fault = "client";
        Object.setPrototypeOf(_this, InvalidPluginName.prototype);
        return _this;
    }
    return InvalidPluginName;
}(__BaseException));
export { InvalidPluginName };
var InvocationDoesNotExist = (function (_super) {
    __extends(InvocationDoesNotExist, _super);
    function InvocationDoesNotExist(opts) {
        var _this = _super.call(this, __assign({ name: "InvocationDoesNotExist", $fault: "client" }, opts)) || this;
        _this.name = "InvocationDoesNotExist";
        _this.$fault = "client";
        Object.setPrototypeOf(_this, InvocationDoesNotExist.prototype);
        return _this;
    }
    return InvocationDoesNotExist;
}(__BaseException));
export { InvocationDoesNotExist };
export var ConnectionStatus;
(function (ConnectionStatus) {
    ConnectionStatus["CONNECTED"] = "Connected";
    ConnectionStatus["NOT_CONNECTED"] = "NotConnected";
})(ConnectionStatus || (ConnectionStatus = {}));
var UnsupportedFeatureRequiredException = (function (_super) {
    __extends(UnsupportedFeatureRequiredException, _super);
    function UnsupportedFeatureRequiredException(opts) {
        var _this = _super.call(this, __assign({ name: "UnsupportedFeatureRequiredException", $fault: "client" }, opts)) || this;
        _this.name = "UnsupportedFeatureRequiredException";
        _this.$fault = "client";
        Object.setPrototypeOf(_this, UnsupportedFeatureRequiredException.prototype);
        _this.Message = opts.Message;
        return _this;
    }
    return UnsupportedFeatureRequiredException;
}(__BaseException));
export { UnsupportedFeatureRequiredException };
export var AttachmentHashType;
(function (AttachmentHashType) {
    AttachmentHashType["SHA256"] = "Sha256";
})(AttachmentHashType || (AttachmentHashType = {}));
export var InventoryQueryOperatorType;
(function (InventoryQueryOperatorType) {
    InventoryQueryOperatorType["BEGIN_WITH"] = "BeginWith";
    InventoryQueryOperatorType["EQUAL"] = "Equal";
    InventoryQueryOperatorType["EXISTS"] = "Exists";
    InventoryQueryOperatorType["GREATER_THAN"] = "GreaterThan";
    InventoryQueryOperatorType["LESS_THAN"] = "LessThan";
    InventoryQueryOperatorType["NOT_EQUAL"] = "NotEqual";
})(InventoryQueryOperatorType || (InventoryQueryOperatorType = {}));
var InvalidAggregatorException = (function (_super) {
    __extends(InvalidAggregatorException, _super);
    function InvalidAggregatorException(opts) {
        var _this = _super.call(this, __assign({ name: "InvalidAggregatorException", $fault: "client" }, opts)) || this;
        _this.name = "InvalidAggregatorException";
        _this.$fault = "client";
        Object.setPrototypeOf(_this, InvalidAggregatorException.prototype);
        _this.Message = opts.Message;
        return _this;
    }
    return InvalidAggregatorException;
}(__BaseException));
export { InvalidAggregatorException };
var InvalidInventoryGroupException = (function (_super) {
    __extends(InvalidInventoryGroupException, _super);
    function InvalidInventoryGroupException(opts) {
        var _this = _super.call(this, __assign({ name: "InvalidInventoryGroupException", $fault: "client" }, opts)) || this;
        _this.name = "InvalidInventoryGroupException";
        _this.$fault = "client";
        Object.setPrototypeOf(_this, InvalidInventoryGroupException.prototype);
        _this.Message = opts.Message;
        return _this;
    }
    return InvalidInventoryGroupException;
}(__BaseException));
export { InvalidInventoryGroupException };
var InvalidResultAttributeException = (function (_super) {
    __extends(InvalidResultAttributeException, _super);
    function InvalidResultAttributeException(opts) {
        var _this = _super.call(this, __assign({ name: "InvalidResultAttributeException", $fault: "client" }, opts)) || this;
        _this.name = "InvalidResultAttributeException";
        _this.$fault = "client";
        Object.setPrototypeOf(_this, InvalidResultAttributeException.prototype);
        _this.Message = opts.Message;
        return _this;
    }
    return InvalidResultAttributeException;
}(__BaseException));
export { InvalidResultAttributeException };
export var InventoryAttributeDataType;
(function (InventoryAttributeDataType) {
    InventoryAttributeDataType["NUMBER"] = "number";
    InventoryAttributeDataType["STRING"] = "string";
})(InventoryAttributeDataType || (InventoryAttributeDataType = {}));
export var NotificationEvent;
(function (NotificationEvent) {
    NotificationEvent["ALL"] = "All";
    NotificationEvent["CANCELLED"] = "Cancelled";
    NotificationEvent["FAILED"] = "Failed";
    NotificationEvent["IN_PROGRESS"] = "InProgress";
    NotificationEvent["SUCCESS"] = "Success";
    NotificationEvent["TIMED_OUT"] = "TimedOut";
})(NotificationEvent || (NotificationEvent = {}));
export var NotificationType;
(function (NotificationType) {
    NotificationType["Command"] = "Command";
    NotificationType["Invocation"] = "Invocation";
})(NotificationType || (NotificationType = {}));
export var OpsFilterOperatorType;
(function (OpsFilterOperatorType) {
    OpsFilterOperatorType["BEGIN_WITH"] = "BeginWith";
    OpsFilterOperatorType["EQUAL"] = "Equal";
    OpsFilterOperatorType["EXISTS"] = "Exists";
    OpsFilterOperatorType["GREATER_THAN"] = "GreaterThan";
    OpsFilterOperatorType["LESS_THAN"] = "LessThan";
    OpsFilterOperatorType["NOT_EQUAL"] = "NotEqual";
})(OpsFilterOperatorType || (OpsFilterOperatorType = {}));
var InvalidKeyId = (function (_super) {
    __extends(InvalidKeyId, _super);
    function InvalidKeyId(opts) {
        var _this = _super.call(this, __assign({ name: "InvalidKeyId", $fault: "client" }, opts)) || this;
        _this.name = "InvalidKeyId";
        _this.$fault = "client";
        Object.setPrototypeOf(_this, InvalidKeyId.prototype);
        return _this;
    }
    return InvalidKeyId;
}(__BaseException));
export { InvalidKeyId };
var ParameterVersionNotFound = (function (_super) {
    __extends(ParameterVersionNotFound, _super);
    function ParameterVersionNotFound(opts) {
        var _this = _super.call(this, __assign({ name: "ParameterVersionNotFound", $fault: "client" }, opts)) || this;
        _this.name = "ParameterVersionNotFound";
        _this.$fault = "client";
        Object.setPrototypeOf(_this, ParameterVersionNotFound.prototype);
        return _this;
    }
    return ParameterVersionNotFound;
}(__BaseException));
export { ParameterVersionNotFound };
var ServiceSettingNotFound = (function (_super) {
    __extends(ServiceSettingNotFound, _super);
    function ServiceSettingNotFound(opts) {
        var _this = _super.call(this, __assign({ name: "ServiceSettingNotFound", $fault: "client" }, opts)) || this;
        _this.name = "ServiceSettingNotFound";
        _this.$fault = "client";
        Object.setPrototypeOf(_this, ServiceSettingNotFound.prototype);
        _this.Message = opts.Message;
        return _this;
    }
    return ServiceSettingNotFound;
}(__BaseException));
export { ServiceSettingNotFound };
var ParameterVersionLabelLimitExceeded = (function (_super) {
    __extends(ParameterVersionLabelLimitExceeded, _super);
    function ParameterVersionLabelLimitExceeded(opts) {
        var _this = _super.call(this, __assign({ name: "ParameterVersionLabelLimitExceeded", $fault: "client" }, opts)) || this;
        _this.name = "ParameterVersionLabelLimitExceeded";
        _this.$fault = "client";
        Object.setPrototypeOf(_this, ParameterVersionLabelLimitExceeded.prototype);
        return _this;
    }
    return ParameterVersionLabelLimitExceeded;
}(__BaseException));
export { ParameterVersionLabelLimitExceeded };
export var AssociationFilterKey;
(function (AssociationFilterKey) {
    AssociationFilterKey["AssociationId"] = "AssociationId";
    AssociationFilterKey["AssociationName"] = "AssociationName";
    AssociationFilterKey["InstanceId"] = "InstanceId";
    AssociationFilterKey["LastExecutedAfter"] = "LastExecutedAfter";
    AssociationFilterKey["LastExecutedBefore"] = "LastExecutedBefore";
    AssociationFilterKey["Name"] = "Name";
    AssociationFilterKey["ResourceGroupName"] = "ResourceGroupName";
    AssociationFilterKey["Status"] = "AssociationStatusName";
})(AssociationFilterKey || (AssociationFilterKey = {}));
export var CommandFilterKey;
(function (CommandFilterKey) {
    CommandFilterKey["DOCUMENT_NAME"] = "DocumentName";
    CommandFilterKey["EXECUTION_STAGE"] = "ExecutionStage";
    CommandFilterKey["INVOKED_AFTER"] = "InvokedAfter";
    CommandFilterKey["INVOKED_BEFORE"] = "InvokedBefore";
    CommandFilterKey["STATUS"] = "Status";
})(CommandFilterKey || (CommandFilterKey = {}));
export var CommandPluginStatus;
(function (CommandPluginStatus) {
    CommandPluginStatus["CANCELLED"] = "Cancelled";
    CommandPluginStatus["FAILED"] = "Failed";
    CommandPluginStatus["IN_PROGRESS"] = "InProgress";
    CommandPluginStatus["PENDING"] = "Pending";
    CommandPluginStatus["SUCCESS"] = "Success";
    CommandPluginStatus["TIMED_OUT"] = "TimedOut";
})(CommandPluginStatus || (CommandPluginStatus = {}));
export var CommandStatus;
(function (CommandStatus) {
    CommandStatus["CANCELLED"] = "Cancelled";
    CommandStatus["CANCELLING"] = "Cancelling";
    CommandStatus["FAILED"] = "Failed";
    CommandStatus["IN_PROGRESS"] = "InProgress";
    CommandStatus["PENDING"] = "Pending";
    CommandStatus["SUCCESS"] = "Success";
    CommandStatus["TIMED_OUT"] = "TimedOut";
})(CommandStatus || (CommandStatus = {}));
export var ComplianceQueryOperatorType;
(function (ComplianceQueryOperatorType) {
    ComplianceQueryOperatorType["BeginWith"] = "BEGIN_WITH";
    ComplianceQueryOperatorType["Equal"] = "EQUAL";
    ComplianceQueryOperatorType["GreaterThan"] = "GREATER_THAN";
    ComplianceQueryOperatorType["LessThan"] = "LESS_THAN";
    ComplianceQueryOperatorType["NotEqual"] = "NOT_EQUAL";
})(ComplianceQueryOperatorType || (ComplianceQueryOperatorType = {}));
export var ComplianceSeverity;
(function (ComplianceSeverity) {
    ComplianceSeverity["Critical"] = "CRITICAL";
    ComplianceSeverity["High"] = "HIGH";
    ComplianceSeverity["Informational"] = "INFORMATIONAL";
    ComplianceSeverity["Low"] = "LOW";
    ComplianceSeverity["Medium"] = "MEDIUM";
    ComplianceSeverity["Unspecified"] = "UNSPECIFIED";
})(ComplianceSeverity || (ComplianceSeverity = {}));
export var ComplianceStatus;
(function (ComplianceStatus) {
    ComplianceStatus["Compliant"] = "COMPLIANT";
    ComplianceStatus["NonCompliant"] = "NON_COMPLIANT";
})(ComplianceStatus || (ComplianceStatus = {}));
export var DocumentMetadataEnum;
(function (DocumentMetadataEnum) {
    DocumentMetadataEnum["DocumentReviews"] = "DocumentReviews";
})(DocumentMetadataEnum || (DocumentMetadataEnum = {}));
export var DocumentReviewCommentType;
(function (DocumentReviewCommentType) {
    DocumentReviewCommentType["Comment"] = "Comment";
})(DocumentReviewCommentType || (DocumentReviewCommentType = {}));
export var DocumentFilterKey;
(function (DocumentFilterKey) {
    DocumentFilterKey["DocumentType"] = "DocumentType";
    DocumentFilterKey["Name"] = "Name";
    DocumentFilterKey["Owner"] = "Owner";
    DocumentFilterKey["PlatformTypes"] = "PlatformTypes";
})(DocumentFilterKey || (DocumentFilterKey = {}));
export var OpsItemEventFilterKey;
(function (OpsItemEventFilterKey) {
    OpsItemEventFilterKey["OPSITEM_ID"] = "OpsItemId";
})(OpsItemEventFilterKey || (OpsItemEventFilterKey = {}));
export var OpsItemEventFilterOperator;
(function (OpsItemEventFilterOperator) {
    OpsItemEventFilterOperator["EQUAL"] = "Equal";
})(OpsItemEventFilterOperator || (OpsItemEventFilterOperator = {}));
export var OpsItemRelatedItemsFilterKey;
(function (OpsItemRelatedItemsFilterKey) {
    OpsItemRelatedItemsFilterKey["ASSOCIATION_ID"] = "AssociationId";
    OpsItemRelatedItemsFilterKey["RESOURCE_TYPE"] = "ResourceType";
    OpsItemRelatedItemsFilterKey["RESOURCE_URI"] = "ResourceUri";
})(OpsItemRelatedItemsFilterKey || (OpsItemRelatedItemsFilterKey = {}));
export var OpsItemRelatedItemsFilterOperator;
(function (OpsItemRelatedItemsFilterOperator) {
    OpsItemRelatedItemsFilterOperator["EQUAL"] = "Equal";
})(OpsItemRelatedItemsFilterOperator || (OpsItemRelatedItemsFilterOperator = {}));
export var LastResourceDataSyncStatus;
(function (LastResourceDataSyncStatus) {
    LastResourceDataSyncStatus["FAILED"] = "Failed";
    LastResourceDataSyncStatus["INPROGRESS"] = "InProgress";
    LastResourceDataSyncStatus["SUCCESSFUL"] = "Successful";
})(LastResourceDataSyncStatus || (LastResourceDataSyncStatus = {}));
var DocumentPermissionLimit = (function (_super) {
    __extends(DocumentPermissionLimit, _super);
    function DocumentPermissionLimit(opts) {
        var _this = _super.call(this, __assign({ name: "DocumentPermissionLimit", $fault: "client" }, opts)) || this;
        _this.name = "DocumentPermissionLimit";
        _this.$fault = "client";
        Object.setPrototypeOf(_this, DocumentPermissionLimit.prototype);
        _this.Message = opts.Message;
        return _this;
    }
    return DocumentPermissionLimit;
}(__BaseException));
export { DocumentPermissionLimit };
var ComplianceTypeCountLimitExceededException = (function (_super) {
    __extends(ComplianceTypeCountLimitExceededException, _super);
    function ComplianceTypeCountLimitExceededException(opts) {
        var _this = _super.call(this, __assign({ name: "ComplianceTypeCountLimitExceededException", $fault: "client" }, opts)) || this;
        _this.name = "ComplianceTypeCountLimitExceededException";
        _this.$fault = "client";
        Object.setPrototypeOf(_this, ComplianceTypeCountLimitExceededException.prototype);
        _this.Message = opts.Message;
        return _this;
    }
    return ComplianceTypeCountLimitExceededException;
}(__BaseException));
export { ComplianceTypeCountLimitExceededException };
var InvalidItemContentException = (function (_super) {
    __extends(InvalidItemContentException, _super);
    function InvalidItemContentException(opts) {
        var _this = _super.call(this, __assign({ name: "InvalidItemContentException", $fault: "client" }, opts)) || this;
        _this.name = "InvalidItemContentException";
        _this.$fault = "client";
        Object.setPrototypeOf(_this, InvalidItemContentException.prototype);
        _this.TypeName = opts.TypeName;
        _this.Message = opts.Message;
        return _this;
    }
    return InvalidItemContentException;
}(__BaseException));
export { InvalidItemContentException };
var ItemSizeLimitExceededException = (function (_super) {
    __extends(ItemSizeLimitExceededException, _super);
    function ItemSizeLimitExceededException(opts) {
        var _this = _super.call(this, __assign({ name: "ItemSizeLimitExceededException", $fault: "client" }, opts)) || this;
        _this.name = "ItemSizeLimitExceededException";
        _this.$fault = "client";
        Object.setPrototypeOf(_this, ItemSizeLimitExceededException.prototype);
        _this.TypeName = opts.TypeName;
        _this.Message = opts.Message;
        return _this;
    }
    return ItemSizeLimitExceededException;
}(__BaseException));
export { ItemSizeLimitExceededException };
export var ComplianceUploadType;
(function (ComplianceUploadType) {
    ComplianceUploadType["Complete"] = "COMPLETE";
    ComplianceUploadType["Partial"] = "PARTIAL";
})(ComplianceUploadType || (ComplianceUploadType = {}));
var TotalSizeLimitExceededException = (function (_super) {
    __extends(TotalSizeLimitExceededException, _super);
    function TotalSizeLimitExceededException(opts) {
        var _this = _super.call(this, __assign({ name: "TotalSizeLimitExceededException", $fault: "client" }, opts)) || this;
        _this.name = "TotalSizeLimitExceededException";
        _this.$fault = "client";
        Object.setPrototypeOf(_this, TotalSizeLimitExceededException.prototype);
        _this.Message = opts.Message;
        return _this;
    }
    return TotalSizeLimitExceededException;
}(__BaseException));
export { TotalSizeLimitExceededException };
var CustomSchemaCountLimitExceededException = (function (_super) {
    __extends(CustomSchemaCountLimitExceededException, _super);
    function CustomSchemaCountLimitExceededException(opts) {
        var _this = _super.call(this, __assign({ name: "CustomSchemaCountLimitExceededException", $fault: "client" }, opts)) || this;
        _this.name = "CustomSchemaCountLimitExceededException";
        _this.$fault = "client";
        Object.setPrototypeOf(_this, CustomSchemaCountLimitExceededException.prototype);
        _this.Message = opts.Message;
        return _this;
    }
    return CustomSchemaCountLimitExceededException;
}(__BaseException));
export { CustomSchemaCountLimitExceededException };
var InvalidInventoryItemContextException = (function (_super) {
    __extends(InvalidInventoryItemContextException, _super);
    function InvalidInventoryItemContextException(opts) {
        var _this = _super.call(this, __assign({ name: "InvalidInventoryItemContextException", $fault: "client" }, opts)) || this;
        _this.name = "InvalidInventoryItemContextException";
        _this.$fault = "client";
        Object.setPrototypeOf(_this, InvalidInventoryItemContextException.prototype);
        _this.Message = opts.Message;
        return _this;
    }
    return InvalidInventoryItemContextException;
}(__BaseException));
export { InvalidInventoryItemContextException };
var ItemContentMismatchException = (function (_super) {
    __extends(ItemContentMismatchException, _super);
    function ItemContentMismatchException(opts) {
        var _this = _super.call(this, __assign({ name: "ItemContentMismatchException", $fault: "client" }, opts)) || this;
        _this.name = "ItemContentMismatchException";
        _this.$fault = "client";
        Object.setPrototypeOf(_this, ItemContentMismatchException.prototype);
        _this.TypeName = opts.TypeName;
        _this.Message = opts.Message;
        return _this;
    }
    return ItemContentMismatchException;
}(__BaseException));
export { ItemContentMismatchException };
var SubTypeCountLimitExceededException = (function (_super) {
    __extends(SubTypeCountLimitExceededException, _super);
    function SubTypeCountLimitExceededException(opts) {
        var _this = _super.call(this, __assign({ name: "SubTypeCountLimitExceededException", $fault: "client" }, opts)) || this;
        _this.name = "SubTypeCountLimitExceededException";
        _this.$fault = "client";
        Object.setPrototypeOf(_this, SubTypeCountLimitExceededException.prototype);
        _this.Message = opts.Message;
        return _this;
    }
    return SubTypeCountLimitExceededException;
}(__BaseException));
export { SubTypeCountLimitExceededException };
var UnsupportedInventoryItemContextException = (function (_super) {
    __extends(UnsupportedInventoryItemContextException, _super);
    function UnsupportedInventoryItemContextException(opts) {
        var _this = _super.call(this, __assign({ name: "UnsupportedInventoryItemContextException", $fault: "client" }, opts)) || this;
        _this.name = "UnsupportedInventoryItemContextException";
        _this.$fault = "client";
        Object.setPrototypeOf(_this, UnsupportedInventoryItemContextException.prototype);
        _this.TypeName = opts.TypeName;
        _this.Message = opts.Message;
        return _this;
    }
    return UnsupportedInventoryItemContextException;
}(__BaseException));
export { UnsupportedInventoryItemContextException };
var UnsupportedInventorySchemaVersionException = (function (_super) {
    __extends(UnsupportedInventorySchemaVersionException, _super);
    function UnsupportedInventorySchemaVersionException(opts) {
        var _this = _super.call(this, __assign({ name: "UnsupportedInventorySchemaVersionException", $fault: "client" }, opts)) || this;
        _this.name = "UnsupportedInventorySchemaVersionException";
        _this.$fault = "client";
        Object.setPrototypeOf(_this, UnsupportedInventorySchemaVersionException.prototype);
        _this.Message = opts.Message;
        return _this;
    }
    return UnsupportedInventorySchemaVersionException;
}(__BaseException));
export { UnsupportedInventorySchemaVersionException };
var HierarchyLevelLimitExceededException = (function (_super) {
    __extends(HierarchyLevelLimitExceededException, _super);
    function HierarchyLevelLimitExceededException(opts) {
        var _this = _super.call(this, __assign({ name: "HierarchyLevelLimitExceededException", $fault: "client" }, opts)) || this;
        _this.name = "HierarchyLevelLimitExceededException";
        _this.$fault = "client";
        Object.setPrototypeOf(_this, HierarchyLevelLimitExceededException.prototype);
        return _this;
    }
    return HierarchyLevelLimitExceededException;
}(__BaseException));
export { HierarchyLevelLimitExceededException };
var HierarchyTypeMismatchException = (function (_super) {
    __extends(HierarchyTypeMismatchException, _super);
    function HierarchyTypeMismatchException(opts) {
        var _this = _super.call(this, __assign({ name: "HierarchyTypeMismatchException", $fault: "client" }, opts)) || this;
        _this.name = "HierarchyTypeMismatchException";
        _this.$fault = "client";
        Object.setPrototypeOf(_this, HierarchyTypeMismatchException.prototype);
        return _this;
    }
    return HierarchyTypeMismatchException;
}(__BaseException));
export { HierarchyTypeMismatchException };
var IncompatiblePolicyException = (function (_super) {
    __extends(IncompatiblePolicyException, _super);
    function IncompatiblePolicyException(opts) {
        var _this = _super.call(this, __assign({ name: "IncompatiblePolicyException", $fault: "client" }, opts)) || this;
        _this.name = "IncompatiblePolicyException";
        _this.$fault = "client";
        Object.setPrototypeOf(_this, IncompatiblePolicyException.prototype);
        return _this;
    }
    return IncompatiblePolicyException;
}(__BaseException));
export { IncompatiblePolicyException };
var InvalidAllowedPatternException = (function (_super) {
    __extends(InvalidAllowedPatternException, _super);
    function InvalidAllowedPatternException(opts) {
        var _this = _super.call(this, __assign({ name: "InvalidAllowedPatternException", $fault: "client" }, opts)) || this;
        _this.name = "InvalidAllowedPatternException";
        _this.$fault = "client";
        Object.setPrototypeOf(_this, InvalidAllowedPatternException.prototype);
        return _this;
    }
    return InvalidAllowedPatternException;
}(__BaseException));
export { InvalidAllowedPatternException };
var InvalidPolicyAttributeException = (function (_super) {
    __extends(InvalidPolicyAttributeException, _super);
    function InvalidPolicyAttributeException(opts) {
        var _this = _super.call(this, __assign({ name: "InvalidPolicyAttributeException", $fault: "client" }, opts)) || this;
        _this.name = "InvalidPolicyAttributeException";
        _this.$fault = "client";
        Object.setPrototypeOf(_this, InvalidPolicyAttributeException.prototype);
        return _this;
    }
    return InvalidPolicyAttributeException;
}(__BaseException));
export { InvalidPolicyAttributeException };
var InvalidPolicyTypeException = (function (_super) {
    __extends(InvalidPolicyTypeException, _super);
    function InvalidPolicyTypeException(opts) {
        var _this = _super.call(this, __assign({ name: "InvalidPolicyTypeException", $fault: "client" }, opts)) || this;
        _this.name = "InvalidPolicyTypeException";
        _this.$fault = "client";
        Object.setPrototypeOf(_this, InvalidPolicyTypeException.prototype);
        return _this;
    }
    return InvalidPolicyTypeException;
}(__BaseException));
export { InvalidPolicyTypeException };
var ParameterAlreadyExists = (function (_super) {
    __extends(ParameterAlreadyExists, _super);
    function ParameterAlreadyExists(opts) {
        var _this = _super.call(this, __assign({ name: "ParameterAlreadyExists", $fault: "client" }, opts)) || this;
        _this.name = "ParameterAlreadyExists";
        _this.$fault = "client";
        Object.setPrototypeOf(_this, ParameterAlreadyExists.prototype);
        return _this;
    }
    return ParameterAlreadyExists;
}(__BaseException));
export { ParameterAlreadyExists };
var ParameterLimitExceeded = (function (_super) {
    __extends(ParameterLimitExceeded, _super);
    function ParameterLimitExceeded(opts) {
        var _this = _super.call(this, __assign({ name: "ParameterLimitExceeded", $fault: "client" }, opts)) || this;
        _this.name = "ParameterLimitExceeded";
        _this.$fault = "client";
        Object.setPrototypeOf(_this, ParameterLimitExceeded.prototype);
        return _this;
    }
    return ParameterLimitExceeded;
}(__BaseException));
export { ParameterLimitExceeded };
var ParameterMaxVersionLimitExceeded = (function (_super) {
    __extends(ParameterMaxVersionLimitExceeded, _super);
    function ParameterMaxVersionLimitExceeded(opts) {
        var _this = _super.call(this, __assign({ name: "ParameterMaxVersionLimitExceeded", $fault: "client" }, opts)) || this;
        _this.name = "ParameterMaxVersionLimitExceeded";
        _this.$fault = "client";
        Object.setPrototypeOf(_this, ParameterMaxVersionLimitExceeded.prototype);
        return _this;
    }
    return ParameterMaxVersionLimitExceeded;
}(__BaseException));
export { ParameterMaxVersionLimitExceeded };
var ParameterPatternMismatchException = (function (_super) {
    __extends(ParameterPatternMismatchException, _super);
    function ParameterPatternMismatchException(opts) {
        var _this = _super.call(this, __assign({ name: "ParameterPatternMismatchException", $fault: "client" }, opts)) || this;
        _this.name = "ParameterPatternMismatchException";
        _this.$fault = "client";
        Object.setPrototypeOf(_this, ParameterPatternMismatchException.prototype);
        return _this;
    }
    return ParameterPatternMismatchException;
}(__BaseException));
export { ParameterPatternMismatchException };
var PoliciesLimitExceededException = (function (_super) {
    __extends(PoliciesLimitExceededException, _super);
    function PoliciesLimitExceededException(opts) {
        var _this = _super.call(this, __assign({ name: "PoliciesLimitExceededException", $fault: "client" }, opts)) || this;
        _this.name = "PoliciesLimitExceededException";
        _this.$fault = "client";
        Object.setPrototypeOf(_this, PoliciesLimitExceededException.prototype);
        return _this;
    }
    return PoliciesLimitExceededException;
}(__BaseException));
export { PoliciesLimitExceededException };
var UnsupportedParameterType = (function (_super) {
    __extends(UnsupportedParameterType, _super);
    function UnsupportedParameterType(opts) {
        var _this = _super.call(this, __assign({ name: "UnsupportedParameterType", $fault: "client" }, opts)) || this;
        _this.name = "UnsupportedParameterType";
        _this.$fault = "client";
        Object.setPrototypeOf(_this, UnsupportedParameterType.prototype);
        return _this;
    }
    return UnsupportedParameterType;
}(__BaseException));
export { UnsupportedParameterType };
var FeatureNotAvailableException = (function (_super) {
    __extends(FeatureNotAvailableException, _super);
    function FeatureNotAvailableException(opts) {
        var _this = _super.call(this, __assign({ name: "FeatureNotAvailableException", $fault: "client" }, opts)) || this;
        _this.name = "FeatureNotAvailableException";
        _this.$fault = "client";
        Object.setPrototypeOf(_this, FeatureNotAvailableException.prototype);
        _this.Message = opts.Message;
        return _this;
    }
    return FeatureNotAvailableException;
}(__BaseException));
export { FeatureNotAvailableException };
var AutomationStepNotFoundException = (function (_super) {
    __extends(AutomationStepNotFoundException, _super);
    function AutomationStepNotFoundException(opts) {
        var _this = _super.call(this, __assign({ name: "AutomationStepNotFoundException", $fault: "client" }, opts)) || this;
        _this.name = "AutomationStepNotFoundException";
        _this.$fault = "client";
        Object.setPrototypeOf(_this, AutomationStepNotFoundException.prototype);
        _this.Message = opts.Message;
        return _this;
    }
    return AutomationStepNotFoundException;
}(__BaseException));
export { AutomationStepNotFoundException };
var InvalidAutomationSignalException = (function (_super) {
    __extends(InvalidAutomationSignalException, _super);
    function InvalidAutomationSignalException(opts) {
        var _this = _super.call(this, __assign({ name: "InvalidAutomationSignalException", $fault: "client" }, opts)) || this;
        _this.name = "InvalidAutomationSignalException";
        _this.$fault = "client";
        Object.setPrototypeOf(_this, InvalidAutomationSignalException.prototype);
        _this.Message = opts.Message;
        return _this;
    }
    return InvalidAutomationSignalException;
}(__BaseException));
export { InvalidAutomationSignalException };
export var SignalType;
(function (SignalType) {
    SignalType["APPROVE"] = "Approve";
    SignalType["REJECT"] = "Reject";
    SignalType["RESUME"] = "Resume";
    SignalType["START_STEP"] = "StartStep";
    SignalType["STOP_STEP"] = "StopStep";
})(SignalType || (SignalType = {}));
var InvalidNotificationConfig = (function (_super) {
    __extends(InvalidNotificationConfig, _super);
    function InvalidNotificationConfig(opts) {
        var _this = _super.call(this, __assign({ name: "InvalidNotificationConfig", $fault: "client" }, opts)) || this;
        _this.name = "InvalidNotificationConfig";
        _this.$fault = "client";
        Object.setPrototypeOf(_this, InvalidNotificationConfig.prototype);
        _this.Message = opts.Message;
        return _this;
    }
    return InvalidNotificationConfig;
}(__BaseException));
export { InvalidNotificationConfig };
var InvalidOutputFolder = (function (_super) {
    __extends(InvalidOutputFolder, _super);
    function InvalidOutputFolder(opts) {
        var _this = _super.call(this, __assign({ name: "InvalidOutputFolder", $fault: "client" }, opts)) || this;
        _this.name = "InvalidOutputFolder";
        _this.$fault = "client";
        Object.setPrototypeOf(_this, InvalidOutputFolder.prototype);
        return _this;
    }
    return InvalidOutputFolder;
}(__BaseException));
export { InvalidOutputFolder };
var InvalidRole = (function (_super) {
    __extends(InvalidRole, _super);
    function InvalidRole(opts) {
        var _this = _super.call(this, __assign({ name: "InvalidRole", $fault: "client" }, opts)) || this;
        _this.name = "InvalidRole";
        _this.$fault = "client";
        Object.setPrototypeOf(_this, InvalidRole.prototype);
        _this.Message = opts.Message;
        return _this;
    }
    return InvalidRole;
}(__BaseException));
export { InvalidRole };
var InvalidAssociation = (function (_super) {
    __extends(InvalidAssociation, _super);
    function InvalidAssociation(opts) {
        var _this = _super.call(this, __assign({ name: "InvalidAssociation", $fault: "client" }, opts)) || this;
        _this.name = "InvalidAssociation";
        _this.$fault = "client";
        Object.setPrototypeOf(_this, InvalidAssociation.prototype);
        _this.Message = opts.Message;
        return _this;
    }
    return InvalidAssociation;
}(__BaseException));
export { InvalidAssociation };
var AutomationDefinitionNotFoundException = (function (_super) {
    __extends(AutomationDefinitionNotFoundException, _super);
    function AutomationDefinitionNotFoundException(opts) {
        var _this = _super.call(this, __assign({ name: "AutomationDefinitionNotFoundException", $fault: "client" }, opts)) || this;
        _this.name = "AutomationDefinitionNotFoundException";
        _this.$fault = "client";
        Object.setPrototypeOf(_this, AutomationDefinitionNotFoundException.prototype);
        _this.Message = opts.Message;
        return _this;
    }
    return AutomationDefinitionNotFoundException;
}(__BaseException));
export { AutomationDefinitionNotFoundException };
var AutomationDefinitionVersionNotFoundException = (function (_super) {
    __extends(AutomationDefinitionVersionNotFoundException, _super);
    function AutomationDefinitionVersionNotFoundException(opts) {
        var _this = _super.call(this, __assign({ name: "AutomationDefinitionVersionNotFoundException", $fault: "client" }, opts)) || this;
        _this.name = "AutomationDefinitionVersionNotFoundException";
        _this.$fault = "client";
        Object.setPrototypeOf(_this, AutomationDefinitionVersionNotFoundException.prototype);
        _this.Message = opts.Message;
        return _this;
    }
    return AutomationDefinitionVersionNotFoundException;
}(__BaseException));
export { AutomationDefinitionVersionNotFoundException };
var AutomationExecutionLimitExceededException = (function (_super) {
    __extends(AutomationExecutionLimitExceededException, _super);
    function AutomationExecutionLimitExceededException(opts) {
        var _this = _super.call(this, __assign({ name: "AutomationExecutionLimitExceededException", $fault: "client" }, opts)) || this;
        _this.name = "AutomationExecutionLimitExceededException";
        _this.$fault = "client";
        Object.setPrototypeOf(_this, AutomationExecutionLimitExceededException.prototype);
        _this.Message = opts.Message;
        return _this;
    }
    return AutomationExecutionLimitExceededException;
}(__BaseException));
export { AutomationExecutionLimitExceededException };
var InvalidAutomationExecutionParametersException = (function (_super) {
    __extends(InvalidAutomationExecutionParametersException, _super);
    function InvalidAutomationExecutionParametersException(opts) {
        var _this = _super.call(this, __assign({ name: "InvalidAutomationExecutionParametersException", $fault: "client" }, opts)) || this;
        _this.name = "InvalidAutomationExecutionParametersException";
        _this.$fault = "client";
        Object.setPrototypeOf(_this, InvalidAutomationExecutionParametersException.prototype);
        _this.Message = opts.Message;
        return _this;
    }
    return InvalidAutomationExecutionParametersException;
}(__BaseException));
export { InvalidAutomationExecutionParametersException };
var AutomationDefinitionNotApprovedException = (function (_super) {
    __extends(AutomationDefinitionNotApprovedException, _super);
    function AutomationDefinitionNotApprovedException(opts) {
        var _this = _super.call(this, __assign({ name: "AutomationDefinitionNotApprovedException", $fault: "client" }, opts)) || this;
        _this.name = "AutomationDefinitionNotApprovedException";
        _this.$fault = "client";
        Object.setPrototypeOf(_this, AutomationDefinitionNotApprovedException.prototype);
        _this.Message = opts.Message;
        return _this;
    }
    return AutomationDefinitionNotApprovedException;
}(__BaseException));
export { AutomationDefinitionNotApprovedException };
var TargetNotConnected = (function (_super) {
    __extends(TargetNotConnected, _super);
    function TargetNotConnected(opts) {
        var _this = _super.call(this, __assign({ name: "TargetNotConnected", $fault: "client" }, opts)) || this;
        _this.name = "TargetNotConnected";
        _this.$fault = "client";
        Object.setPrototypeOf(_this, TargetNotConnected.prototype);
        _this.Message = opts.Message;
        return _this;
    }
    return TargetNotConnected;
}(__BaseException));
export { TargetNotConnected };
var InvalidAutomationStatusUpdateException = (function (_super) {
    __extends(InvalidAutomationStatusUpdateException, _super);
    function InvalidAutomationStatusUpdateException(opts) {
        var _this = _super.call(this, __assign({ name: "InvalidAutomationStatusUpdateException", $fault: "client" }, opts)) || this;
        _this.name = "InvalidAutomationStatusUpdateException";
        _this.$fault = "client";
        Object.setPrototypeOf(_this, InvalidAutomationStatusUpdateException.prototype);
        _this.Message = opts.Message;
        return _this;
    }
    return InvalidAutomationStatusUpdateException;
}(__BaseException));
export { InvalidAutomationStatusUpdateException };
export var StopType;
(function (StopType) {
    StopType["CANCEL"] = "Cancel";
    StopType["COMPLETE"] = "Complete";
})(StopType || (StopType = {}));
var AssociationVersionLimitExceeded = (function (_super) {
    __extends(AssociationVersionLimitExceeded, _super);
    function AssociationVersionLimitExceeded(opts) {
        var _this = _super.call(this, __assign({ name: "AssociationVersionLimitExceeded", $fault: "client" }, opts)) || this;
        _this.name = "AssociationVersionLimitExceeded";
        _this.$fault = "client";
        Object.setPrototypeOf(_this, AssociationVersionLimitExceeded.prototype);
        _this.Message = opts.Message;
        return _this;
    }
    return AssociationVersionLimitExceeded;
}(__BaseException));
export { AssociationVersionLimitExceeded };
var InvalidUpdate = (function (_super) {
    __extends(InvalidUpdate, _super);
    function InvalidUpdate(opts) {
        var _this = _super.call(this, __assign({ name: "InvalidUpdate", $fault: "client" }, opts)) || this;
        _this.name = "InvalidUpdate";
        _this.$fault = "client";
        Object.setPrototypeOf(_this, InvalidUpdate.prototype);
        _this.Message = opts.Message;
        return _this;
    }
    return InvalidUpdate;
}(__BaseException));
export { InvalidUpdate };
var StatusUnchanged = (function (_super) {
    __extends(StatusUnchanged, _super);
    function StatusUnchanged(opts) {
        var _this = _super.call(this, __assign({ name: "StatusUnchanged", $fault: "client" }, opts)) || this;
        _this.name = "StatusUnchanged";
        _this.$fault = "client";
        Object.setPrototypeOf(_this, StatusUnchanged.prototype);
        return _this;
    }
    return StatusUnchanged;
}(__BaseException));
export { StatusUnchanged };
var DocumentVersionLimitExceeded = (function (_super) {
    __extends(DocumentVersionLimitExceeded, _super);
    function DocumentVersionLimitExceeded(opts) {
        var _this = _super.call(this, __assign({ name: "DocumentVersionLimitExceeded", $fault: "client" }, opts)) || this;
        _this.name = "DocumentVersionLimitExceeded";
        _this.$fault = "client";
        Object.setPrototypeOf(_this, DocumentVersionLimitExceeded.prototype);
        _this.Message = opts.Message;
        return _this;
    }
    return DocumentVersionLimitExceeded;
}(__BaseException));
export { DocumentVersionLimitExceeded };
var DuplicateDocumentContent = (function (_super) {
    __extends(DuplicateDocumentContent, _super);
    function DuplicateDocumentContent(opts) {
        var _this = _super.call(this, __assign({ name: "DuplicateDocumentContent", $fault: "client" }, opts)) || this;
        _this.name = "DuplicateDocumentContent";
        _this.$fault = "client";
        Object.setPrototypeOf(_this, DuplicateDocumentContent.prototype);
        _this.Message = opts.Message;
        return _this;
    }
    return DuplicateDocumentContent;
}(__BaseException));
export { DuplicateDocumentContent };
var DuplicateDocumentVersionName = (function (_super) {
    __extends(DuplicateDocumentVersionName, _super);
    function DuplicateDocumentVersionName(opts) {
        var _this = _super.call(this, __assign({ name: "DuplicateDocumentVersionName", $fault: "client" }, opts)) || this;
        _this.name = "DuplicateDocumentVersionName";
        _this.$fault = "client";
        Object.setPrototypeOf(_this, DuplicateDocumentVersionName.prototype);
        _this.Message = opts.Message;
        return _this;
    }
    return DuplicateDocumentVersionName;
}(__BaseException));
export { DuplicateDocumentVersionName };
export var DocumentReviewAction;
(function (DocumentReviewAction) {
    DocumentReviewAction["Approve"] = "Approve";
    DocumentReviewAction["Reject"] = "Reject";
    DocumentReviewAction["SendForReview"] = "SendForReview";
    DocumentReviewAction["UpdateReview"] = "UpdateReview";
})(DocumentReviewAction || (DocumentReviewAction = {}));
export var ParameterMetadataFilterSensitiveLog = function (obj) { return (__assign({}, obj)); };
export var DescribeParametersResultFilterSensitiveLog = function (obj) { return (__assign({}, obj)); };
export var DescribePatchBaselinesRequestFilterSensitiveLog = function (obj) { return (__assign({}, obj)); };
export var PatchBaselineIdentityFilterSensitiveLog = function (obj) { return (__assign({}, obj)); };
export var DescribePatchBaselinesResultFilterSensitiveLog = function (obj) { return (__assign({}, obj)); };
export var DescribePatchGroupsRequestFilterSensitiveLog = function (obj) { return (__assign({}, obj)); };
export var PatchGroupPatchBaselineMappingFilterSensitiveLog = function (obj) { return (__assign({}, obj)); };
export var DescribePatchGroupsResultFilterSensitiveLog = function (obj) { return (__assign({}, obj)); };
export var DescribePatchGroupStateRequestFilterSensitiveLog = function (obj) { return (__assign({}, obj)); };
export var DescribePatchGroupStateResultFilterSensitiveLog = function (obj) { return (__assign({}, obj)); };
export var DescribePatchPropertiesRequestFilterSensitiveLog = function (obj) { return (__assign({}, obj)); };
export var DescribePatchPropertiesResultFilterSensitiveLog = function (obj) { return (__assign({}, obj)); };
export var SessionFilterFilterSensitiveLog = function (obj) { return (__assign({}, obj)); };
export var DescribeSessionsRequestFilterSensitiveLog = function (obj) { return (__assign({}, obj)); };
export var SessionManagerOutputUrlFilterSensitiveLog = function (obj) { return (__assign({}, obj)); };
export var SessionFilterSensitiveLog = function (obj) { return (__assign({}, obj)); };
export var DescribeSessionsResponseFilterSensitiveLog = function (obj) { return (__assign({}, obj)); };
export var DisassociateOpsItemRelatedItemRequestFilterSensitiveLog = function (obj) { return (__assign({}, obj)); };
export var DisassociateOpsItemRelatedItemResponseFilterSensitiveLog = function (obj) { return (__assign({}, obj)); };
export var GetAutomationExecutionRequestFilterSensitiveLog = function (obj) { return (__assign({}, obj)); };
export var ProgressCountersFilterSensitiveLog = function (obj) { return (__assign({}, obj)); };
export var AutomationExecutionFilterSensitiveLog = function (obj) { return (__assign({}, obj)); };
export var GetAutomationExecutionResultFilterSensitiveLog = function (obj) { return (__assign({}, obj)); };
export var GetCalendarStateRequestFilterSensitiveLog = function (obj) { return (__assign({}, obj)); };
export var GetCalendarStateResponseFilterSensitiveLog = function (obj) { return (__assign({}, obj)); };
export var GetCommandInvocationRequestFilterSensitiveLog = function (obj) { return (__assign({}, obj)); };
export var CloudWatchOutputConfigFilterSensitiveLog = function (obj) { return (__assign({}, obj)); };
export var GetCommandInvocationResultFilterSensitiveLog = function (obj) { return (__assign({}, obj)); };
export var GetConnectionStatusRequestFilterSensitiveLog = function (obj) { return (__assign({}, obj)); };
export var GetConnectionStatusResponseFilterSensitiveLog = function (obj) { return (__assign({}, obj)); };
export var GetDefaultPatchBaselineRequestFilterSensitiveLog = function (obj) { return (__assign({}, obj)); };
export var GetDefaultPatchBaselineResultFilterSensitiveLog = function (obj) { return (__assign({}, obj)); };
export var BaselineOverrideFilterSensitiveLog = function (obj) { return (__assign(__assign({}, obj), (obj.Sources && { Sources: obj.Sources.map(function (item) { return PatchSourceFilterSensitiveLog(item); }) }))); };
export var GetDeployablePatchSnapshotForInstanceRequestFilterSensitiveLog = function (obj) { return (__assign({}, obj)); };
export var GetDeployablePatchSnapshotForInstanceResultFilterSensitiveLog = function (obj) { return (__assign({}, obj)); };
export var GetDocumentRequestFilterSensitiveLog = function (obj) { return (__assign({}, obj)); };
export var AttachmentContentFilterSensitiveLog = function (obj) { return (__assign({}, obj)); };
export var GetDocumentResultFilterSensitiveLog = function (obj) { return (__assign({}, obj)); };
export var InventoryFilterFilterSensitiveLog = function (obj) { return (__assign({}, obj)); };
export var InventoryGroupFilterSensitiveLog = function (obj) { return (__assign({}, obj)); };
export var ResultAttributeFilterSensitiveLog = function (obj) { return (__assign({}, obj)); };
export var InventoryResultItemFilterSensitiveLog = function (obj) { return (__assign({}, obj)); };
export var InventoryResultEntityFilterSensitiveLog = function (obj) { return (__assign({}, obj)); };
export var GetInventoryResultFilterSensitiveLog = function (obj) { return (__assign({}, obj)); };
export var GetInventorySchemaRequestFilterSensitiveLog = function (obj) { return (__assign({}, obj)); };
export var InventoryItemAttributeFilterSensitiveLog = function (obj) { return (__assign({}, obj)); };
export var InventoryItemSchemaFilterSensitiveLog = function (obj) { return (__assign({}, obj)); };
export var GetInventorySchemaResultFilterSensitiveLog = function (obj) { return (__assign({}, obj)); };
export var GetMaintenanceWindowRequestFilterSensitiveLog = function (obj) { return (__assign({}, obj)); };
export var GetMaintenanceWindowResultFilterSensitiveLog = function (obj) { return (__assign(__assign({}, obj), (obj.Description && { Description: SENSITIVE_STRING }))); };
export var GetMaintenanceWindowExecutionRequestFilterSensitiveLog = function (obj) { return (__assign({}, obj)); };
export var GetMaintenanceWindowExecutionResultFilterSensitiveLog = function (obj) { return (__assign({}, obj)); };
export var GetMaintenanceWindowExecutionTaskRequestFilterSensitiveLog = function (obj) { return (__assign({}, obj)); };
export var GetMaintenanceWindowExecutionTaskResultFilterSensitiveLog = function (obj) { return (__assign(__assign({}, obj), (obj.TaskParameters && { TaskParameters: SENSITIVE_STRING }))); };
export var GetMaintenanceWindowExecutionTaskInvocationRequestFilterSensitiveLog = function (obj) { return (__assign({}, obj)); };
export var GetMaintenanceWindowExecutionTaskInvocationResultFilterSensitiveLog = function (obj) { return (__assign(__assign(__assign({}, obj), (obj.Parameters && { Parameters: SENSITIVE_STRING })), (obj.OwnerInformation && { OwnerInformation: SENSITIVE_STRING }))); };
export var GetMaintenanceWindowTaskRequestFilterSensitiveLog = function (obj) { return (__assign({}, obj)); };
export var MaintenanceWindowAutomationParametersFilterSensitiveLog = function (obj) { return (__assign({}, obj)); };
export var MaintenanceWindowLambdaParametersFilterSensitiveLog = function (obj) { return (__assign(__assign({}, obj), (obj.Payload && { Payload: SENSITIVE_STRING }))); };
export var NotificationConfigFilterSensitiveLog = function (obj) { return (__assign({}, obj)); };
export var MaintenanceWindowRunCommandParametersFilterSensitiveLog = function (obj) { return (__assign(__assign({}, obj), (obj.Parameters && { Parameters: SENSITIVE_STRING }))); };
export var MaintenanceWindowStepFunctionsParametersFilterSensitiveLog = function (obj) { return (__assign(__assign({}, obj), (obj.Input && { Input: SENSITIVE_STRING }))); };
export var MaintenanceWindowTaskInvocationParametersFilterSensitiveLog = function (obj) { return (__assign(__assign(__assign(__assign({}, obj), (obj.RunCommand && { RunCommand: MaintenanceWindowRunCommandParametersFilterSensitiveLog(obj.RunCommand) })), (obj.StepFunctions && {
    StepFunctions: MaintenanceWindowStepFunctionsParametersFilterSensitiveLog(obj.StepFunctions),
})), (obj.Lambda && { Lambda: MaintenanceWindowLambdaParametersFilterSensitiveLog(obj.Lambda) }))); };
export var GetMaintenanceWindowTaskResultFilterSensitiveLog = function (obj) { return (__assign(__assign(__assign(__assign({}, obj), (obj.TaskParameters && { TaskParameters: SENSITIVE_STRING })), (obj.TaskInvocationParameters && {
    TaskInvocationParameters: MaintenanceWindowTaskInvocationParametersFilterSensitiveLog(obj.TaskInvocationParameters),
})), (obj.Description && { Description: SENSITIVE_STRING }))); };
export var GetOpsItemRequestFilterSensitiveLog = function (obj) { return (__assign({}, obj)); };
export var OpsItemFilterSensitiveLog = function (obj) { return (__assign({}, obj)); };
export var GetOpsItemResponseFilterSensitiveLog = function (obj) { return (__assign({}, obj)); };
export var GetOpsMetadataRequestFilterSensitiveLog = function (obj) { return (__assign({}, obj)); };
export var GetOpsMetadataResultFilterSensitiveLog = function (obj) { return (__assign({}, obj)); };
export var OpsFilterFilterSensitiveLog = function (obj) { return (__assign({}, obj)); };
export var OpsResultAttributeFilterSensitiveLog = function (obj) { return (__assign({}, obj)); };
export var OpsEntityItemFilterSensitiveLog = function (obj) { return (__assign({}, obj)); };
export var OpsEntityFilterSensitiveLog = function (obj) { return (__assign({}, obj)); };
export var GetOpsSummaryResultFilterSensitiveLog = function (obj) { return (__assign({}, obj)); };
export var GetParameterRequestFilterSensitiveLog = function (obj) { return (__assign({}, obj)); };
export var ParameterFilterSensitiveLog = function (obj) { return (__assign(__assign({}, obj), (obj.Value && { Value: SENSITIVE_STRING }))); };
export var GetParameterResultFilterSensitiveLog = function (obj) { return (__assign(__assign({}, obj), (obj.Parameter && { Parameter: ParameterFilterSensitiveLog(obj.Parameter) }))); };
export var GetParameterHistoryRequestFilterSensitiveLog = function (obj) { return (__assign({}, obj)); };
export var ParameterHistoryFilterSensitiveLog = function (obj) { return (__assign(__assign({}, obj), (obj.Value && { Value: SENSITIVE_STRING }))); };
export var GetParameterHistoryResultFilterSensitiveLog = function (obj) { return (__assign(__assign({}, obj), (obj.Parameters && { Parameters: obj.Parameters.map(function (item) { return ParameterHistoryFilterSensitiveLog(item); }) }))); };
export var GetParametersRequestFilterSensitiveLog = function (obj) { return (__assign({}, obj)); };
export var GetParametersResultFilterSensitiveLog = function (obj) { return (__assign(__assign({}, obj), (obj.Parameters && { Parameters: obj.Parameters.map(function (item) { return ParameterFilterSensitiveLog(item); }) }))); };
export var GetParametersByPathRequestFilterSensitiveLog = function (obj) { return (__assign({}, obj)); };
export var GetParametersByPathResultFilterSensitiveLog = function (obj) { return (__assign(__assign({}, obj), (obj.Parameters && { Parameters: obj.Parameters.map(function (item) { return ParameterFilterSensitiveLog(item); }) }))); };
export var GetPatchBaselineRequestFilterSensitiveLog = function (obj) { return (__assign({}, obj)); };
export var GetPatchBaselineResultFilterSensitiveLog = function (obj) { return (__assign(__assign({}, obj), (obj.Sources && { Sources: obj.Sources.map(function (item) { return PatchSourceFilterSensitiveLog(item); }) }))); };
export var GetPatchBaselineForPatchGroupRequestFilterSensitiveLog = function (obj) { return (__assign({}, obj)); };
export var GetPatchBaselineForPatchGroupResultFilterSensitiveLog = function (obj) { return (__assign({}, obj)); };
export var GetServiceSettingRequestFilterSensitiveLog = function (obj) { return (__assign({}, obj)); };
export var ServiceSettingFilterSensitiveLog = function (obj) { return (__assign({}, obj)); };
export var GetServiceSettingResultFilterSensitiveLog = function (obj) { return (__assign({}, obj)); };
export var LabelParameterVersionRequestFilterSensitiveLog = function (obj) { return (__assign({}, obj)); };
export var LabelParameterVersionResultFilterSensitiveLog = function (obj) { return (__assign({}, obj)); };
export var AssociationFilterFilterSensitiveLog = function (obj) { return (__assign({}, obj)); };
export var ListAssociationsRequestFilterSensitiveLog = function (obj) { return (__assign({}, obj)); };
export var AssociationFilterSensitiveLog = function (obj) { return (__assign({}, obj)); };
export var ListAssociationsResultFilterSensitiveLog = function (obj) { return (__assign({}, obj)); };
export var ListAssociationVersionsRequestFilterSensitiveLog = function (obj) { return (__assign({}, obj)); };
export var AssociationVersionInfoFilterSensitiveLog = function (obj) { return (__assign(__assign({}, obj), (obj.Parameters && { Parameters: SENSITIVE_STRING }))); };
export var ListAssociationVersionsResultFilterSensitiveLog = function (obj) { return (__assign(__assign({}, obj), (obj.AssociationVersions && {
    AssociationVersions: obj.AssociationVersions.map(function (item) { return AssociationVersionInfoFilterSensitiveLog(item); }),
}))); };
export var CommandFilterFilterSensitiveLog = function (obj) { return (__assign({}, obj)); };
export var ListCommandInvocationsRequestFilterSensitiveLog = function (obj) { return (__assign({}, obj)); };
export var CommandPluginFilterSensitiveLog = function (obj) { return (__assign({}, obj)); };
export var CommandInvocationFilterSensitiveLog = function (obj) { return (__assign({}, obj)); };
export var ListCommandInvocationsResultFilterSensitiveLog = function (obj) { return (__assign({}, obj)); };
export var ListCommandsRequestFilterSensitiveLog = function (obj) { return (__assign({}, obj)); };
export var CommandFilterSensitiveLog = function (obj) { return (__assign(__assign({}, obj), (obj.Parameters && { Parameters: SENSITIVE_STRING }))); };
export var ListCommandsResultFilterSensitiveLog = function (obj) { return (__assign(__assign({}, obj), (obj.Commands && { Commands: obj.Commands.map(function (item) { return CommandFilterSensitiveLog(item); }) }))); };
export var ComplianceStringFilterFilterSensitiveLog = function (obj) { return (__assign({}, obj)); };
export var ListComplianceItemsRequestFilterSensitiveLog = function (obj) { return (__assign({}, obj)); };
export var ComplianceExecutionSummaryFilterSensitiveLog = function (obj) { return (__assign({}, obj)); };
export var ComplianceItemFilterSensitiveLog = function (obj) { return (__assign({}, obj)); };
export var ListComplianceItemsResultFilterSensitiveLog = function (obj) { return (__assign({}, obj)); };
export var ListComplianceSummariesRequestFilterSensitiveLog = function (obj) { return (__assign({}, obj)); };
export var SeveritySummaryFilterSensitiveLog = function (obj) { return (__assign({}, obj)); };
export var CompliantSummaryFilterSensitiveLog = function (obj) { return (__assign({}, obj)); };
export var NonCompliantSummaryFilterSensitiveLog = function (obj) { return (__assign({}, obj)); };
export var ComplianceSummaryItemFilterSensitiveLog = function (obj) { return (__assign({}, obj)); };
export var ListComplianceSummariesResultFilterSensitiveLog = function (obj) { return (__assign({}, obj)); };
export var ListDocumentMetadataHistoryRequestFilterSensitiveLog = function (obj) { return (__assign({}, obj)); };
export var DocumentReviewCommentSourceFilterSensitiveLog = function (obj) { return (__assign({}, obj)); };
export var DocumentReviewerResponseSourceFilterSensitiveLog = function (obj) { return (__assign({}, obj)); };
export var DocumentMetadataResponseInfoFilterSensitiveLog = function (obj) { return (__assign({}, obj)); };
export var ListDocumentMetadataHistoryResponseFilterSensitiveLog = function (obj) { return (__assign({}, obj)); };
export var DocumentFilterFilterSensitiveLog = function (obj) { return (__assign({}, obj)); };
export var DocumentKeyValuesFilterFilterSensitiveLog = function (obj) { return (__assign({}, obj)); };
export var ListDocumentsRequestFilterSensitiveLog = function (obj) { return (__assign({}, obj)); };
export var DocumentIdentifierFilterSensitiveLog = function (obj) { return (__assign({}, obj)); };
export var ListDocumentsResultFilterSensitiveLog = function (obj) { return (__assign({}, obj)); };
export var ListDocumentVersionsRequestFilterSensitiveLog = function (obj) { return (__assign({}, obj)); };
export var DocumentVersionInfoFilterSensitiveLog = function (obj) { return (__assign({}, obj)); };
export var ListDocumentVersionsResultFilterSensitiveLog = function (obj) { return (__assign({}, obj)); };
export var ListInventoryEntriesRequestFilterSensitiveLog = function (obj) { return (__assign({}, obj)); };
export var ListInventoryEntriesResultFilterSensitiveLog = function (obj) { return (__assign({}, obj)); };
export var OpsItemEventFilterFilterSensitiveLog = function (obj) { return (__assign({}, obj)); };
export var ListOpsItemEventsRequestFilterSensitiveLog = function (obj) { return (__assign({}, obj)); };
export var OpsItemIdentityFilterSensitiveLog = function (obj) { return (__assign({}, obj)); };
export var OpsItemEventSummaryFilterSensitiveLog = function (obj) { return (__assign({}, obj)); };
export var ListOpsItemEventsResponseFilterSensitiveLog = function (obj) { return (__assign({}, obj)); };
export var OpsItemRelatedItemsFilterFilterSensitiveLog = function (obj) { return (__assign({}, obj)); };
export var ListOpsItemRelatedItemsRequestFilterSensitiveLog = function (obj) { return (__assign({}, obj)); };
export var OpsItemRelatedItemSummaryFilterSensitiveLog = function (obj) { return (__assign({}, obj)); };
export var ListOpsItemRelatedItemsResponseFilterSensitiveLog = function (obj) { return (__assign({}, obj)); };
export var OpsMetadataFilterFilterSensitiveLog = function (obj) { return (__assign({}, obj)); };
export var ListOpsMetadataRequestFilterSensitiveLog = function (obj) { return (__assign({}, obj)); };
export var OpsMetadataFilterSensitiveLog = function (obj) { return (__assign({}, obj)); };
export var ListOpsMetadataResultFilterSensitiveLog = function (obj) { return (__assign({}, obj)); };
export var ListResourceComplianceSummariesRequestFilterSensitiveLog = function (obj) { return (__assign({}, obj)); };
export var ResourceComplianceSummaryItemFilterSensitiveLog = function (obj) { return (__assign({}, obj)); };
export var ListResourceComplianceSummariesResultFilterSensitiveLog = function (obj) { return (__assign({}, obj)); };
export var ListResourceDataSyncRequestFilterSensitiveLog = function (obj) { return (__assign({}, obj)); };
export var ResourceDataSyncSourceWithStateFilterSensitiveLog = function (obj) { return (__assign({}, obj)); };
export var ResourceDataSyncItemFilterSensitiveLog = function (obj) { return (__assign({}, obj)); };
export var ListResourceDataSyncResultFilterSensitiveLog = function (obj) { return (__assign({}, obj)); };
export var ListTagsForResourceRequestFilterSensitiveLog = function (obj) { return (__assign({}, obj)); };
export var ListTagsForResourceResultFilterSensitiveLog = function (obj) { return (__assign({}, obj)); };
export var ModifyDocumentPermissionRequestFilterSensitiveLog = function (obj) { return (__assign({}, obj)); };
export var ModifyDocumentPermissionResponseFilterSensitiveLog = function (obj) { return (__assign({}, obj)); };
export var ComplianceItemEntryFilterSensitiveLog = function (obj) { return (__assign({}, obj)); };
export var PutComplianceItemsRequestFilterSensitiveLog = function (obj) { return (__assign({}, obj)); };
export var PutComplianceItemsResultFilterSensitiveLog = function (obj) { return (__assign({}, obj)); };
export var InventoryItemFilterSensitiveLog = function (obj) { return (__assign({}, obj)); };
export var PutInventoryRequestFilterSensitiveLog = function (obj) { return (__assign({}, obj)); };
export var PutInventoryResultFilterSensitiveLog = function (obj) { return (__assign({}, obj)); };
export var PutParameterRequestFilterSensitiveLog = function (obj) { return (__assign(__assign({}, obj), (obj.Value && { Value: SENSITIVE_STRING }))); };
export var PutParameterResultFilterSensitiveLog = function (obj) { return (__assign({}, obj)); };
export var RegisterDefaultPatchBaselineRequestFilterSensitiveLog = function (obj) { return (__assign({}, obj)); };
export var RegisterDefaultPatchBaselineResultFilterSensitiveLog = function (obj) { return (__assign({}, obj)); };
export var RegisterPatchBaselineForPatchGroupRequestFilterSensitiveLog = function (obj) { return (__assign({}, obj)); };
export var RegisterPatchBaselineForPatchGroupResultFilterSensitiveLog = function (obj) { return (__assign({}, obj)); };
export var RegisterTargetWithMaintenanceWindowRequestFilterSensitiveLog = function (obj) { return (__assign(__assign(__assign({}, obj), (obj.OwnerInformation && { OwnerInformation: SENSITIVE_STRING })), (obj.Description && { Description: SENSITIVE_STRING }))); };
export var RegisterTargetWithMaintenanceWindowResultFilterSensitiveLog = function (obj) { return (__assign({}, obj)); };
export var RegisterTaskWithMaintenanceWindowRequestFilterSensitiveLog = function (obj) { return (__assign(__assign(__assign(__assign({}, obj), (obj.TaskParameters && { TaskParameters: SENSITIVE_STRING })), (obj.TaskInvocationParameters && {
    TaskInvocationParameters: MaintenanceWindowTaskInvocationParametersFilterSensitiveLog(obj.TaskInvocationParameters),
})), (obj.Description && { Description: SENSITIVE_STRING }))); };
export var RegisterTaskWithMaintenanceWindowResultFilterSensitiveLog = function (obj) { return (__assign({}, obj)); };
export var RemoveTagsFromResourceRequestFilterSensitiveLog = function (obj) { return (__assign({}, obj)); };
export var RemoveTagsFromResourceResultFilterSensitiveLog = function (obj) { return (__assign({}, obj)); };
export var ResetServiceSettingRequestFilterSensitiveLog = function (obj) { return (__assign({}, obj)); };
export var ResetServiceSettingResultFilterSensitiveLog = function (obj) { return (__assign({}, obj)); };
export var ResumeSessionRequestFilterSensitiveLog = function (obj) { return (__assign({}, obj)); };
export var ResumeSessionResponseFilterSensitiveLog = function (obj) { return (__assign({}, obj)); };
export var SendAutomationSignalRequestFilterSensitiveLog = function (obj) { return (__assign({}, obj)); };
export var SendAutomationSignalResultFilterSensitiveLog = function (obj) { return (__assign({}, obj)); };
export var SendCommandRequestFilterSensitiveLog = function (obj) { return (__assign(__assign({}, obj), (obj.Parameters && { Parameters: SENSITIVE_STRING }))); };
export var SendCommandResultFilterSensitiveLog = function (obj) { return (__assign(__assign({}, obj), (obj.Command && { Command: CommandFilterSensitiveLog(obj.Command) }))); };
export var StartAssociationsOnceRequestFilterSensitiveLog = function (obj) { return (__assign({}, obj)); };
export var StartAssociationsOnceResultFilterSensitiveLog = function (obj) { return (__assign({}, obj)); };
export var StartAutomationExecutionRequestFilterSensitiveLog = function (obj) { return (__assign({}, obj)); };
export var StartAutomationExecutionResultFilterSensitiveLog = function (obj) { return (__assign({}, obj)); };
export var StartChangeRequestExecutionRequestFilterSensitiveLog = function (obj) { return (__assign({}, obj)); };
export var StartChangeRequestExecutionResultFilterSensitiveLog = function (obj) { return (__assign({}, obj)); };
export var StartSessionRequestFilterSensitiveLog = function (obj) { return (__assign({}, obj)); };
export var StartSessionResponseFilterSensitiveLog = function (obj) { return (__assign({}, obj)); };
export var StopAutomationExecutionRequestFilterSensitiveLog = function (obj) { return (__assign({}, obj)); };
export var StopAutomationExecutionResultFilterSensitiveLog = function (obj) { return (__assign({}, obj)); };
export var TerminateSessionRequestFilterSensitiveLog = function (obj) { return (__assign({}, obj)); };
export var TerminateSessionResponseFilterSensitiveLog = function (obj) { return (__assign({}, obj)); };
export var UnlabelParameterVersionRequestFilterSensitiveLog = function (obj) { return (__assign({}, obj)); };
export var UnlabelParameterVersionResultFilterSensitiveLog = function (obj) { return (__assign({}, obj)); };
export var UpdateAssociationRequestFilterSensitiveLog = function (obj) { return (__assign(__assign({}, obj), (obj.Parameters && { Parameters: SENSITIVE_STRING }))); };
export var UpdateAssociationResultFilterSensitiveLog = function (obj) { return (__assign(__assign({}, obj), (obj.AssociationDescription && {
    AssociationDescription: AssociationDescriptionFilterSensitiveLog(obj.AssociationDescription),
}))); };
export var UpdateAssociationStatusRequestFilterSensitiveLog = function (obj) { return (__assign({}, obj)); };
export var UpdateAssociationStatusResultFilterSensitiveLog = function (obj) { return (__assign(__assign({}, obj), (obj.AssociationDescription && {
    AssociationDescription: AssociationDescriptionFilterSensitiveLog(obj.AssociationDescription),
}))); };
export var UpdateDocumentRequestFilterSensitiveLog = function (obj) { return (__assign({}, obj)); };
export var UpdateDocumentResultFilterSensitiveLog = function (obj) { return (__assign({}, obj)); };
export var UpdateDocumentDefaultVersionRequestFilterSensitiveLog = function (obj) { return (__assign({}, obj)); };
export var DocumentDefaultVersionDescriptionFilterSensitiveLog = function (obj) { return (__assign({}, obj)); };
export var UpdateDocumentDefaultVersionResultFilterSensitiveLog = function (obj) { return (__assign({}, obj)); };
export var DocumentReviewsFilterSensitiveLog = function (obj) { return (__assign({}, obj)); };
