import { __assign, __extends } from "tslib";
import { SENSITIVE_STRING } from "@aws-sdk/smithy-client";
import { SSMServiceException as __BaseException } from "./SSMServiceException";
export var ResourceTypeForTagging;
(function (ResourceTypeForTagging) {
    ResourceTypeForTagging["AUTOMATION"] = "Automation";
    ResourceTypeForTagging["DOCUMENT"] = "Document";
    ResourceTypeForTagging["MAINTENANCE_WINDOW"] = "MaintenanceWindow";
    ResourceTypeForTagging["MANAGED_INSTANCE"] = "ManagedInstance";
    ResourceTypeForTagging["OPSMETADATA"] = "OpsMetadata";
    ResourceTypeForTagging["OPS_ITEM"] = "OpsItem";
    ResourceTypeForTagging["PARAMETER"] = "Parameter";
    ResourceTypeForTagging["PATCH_BASELINE"] = "PatchBaseline";
})(ResourceTypeForTagging || (ResourceTypeForTagging = {}));
var InternalServerError = (function (_super) {
    __extends(InternalServerError, _super);
    function InternalServerError(opts) {
        var _this = _super.call(this, __assign({ name: "InternalServerError", $fault: "server" }, opts)) || this;
        _this.name = "InternalServerError";
        _this.$fault = "server";
        Object.setPrototypeOf(_this, InternalServerError.prototype);
        _this.Message = opts.Message;
        return _this;
    }
    return InternalServerError;
}(__BaseException));
export { InternalServerError };
var InvalidResourceId = (function (_super) {
    __extends(InvalidResourceId, _super);
    function InvalidResourceId(opts) {
        var _this = _super.call(this, __assign({ name: "InvalidResourceId", $fault: "client" }, opts)) || this;
        _this.name = "InvalidResourceId";
        _this.$fault = "client";
        Object.setPrototypeOf(_this, InvalidResourceId.prototype);
        return _this;
    }
    return InvalidResourceId;
}(__BaseException));
export { InvalidResourceId };
var InvalidResourceType = (function (_super) {
    __extends(InvalidResourceType, _super);
    function InvalidResourceType(opts) {
        var _this = _super.call(this, __assign({ name: "InvalidResourceType", $fault: "client" }, opts)) || this;
        _this.name = "InvalidResourceType";
        _this.$fault = "client";
        Object.setPrototypeOf(_this, InvalidResourceType.prototype);
        return _this;
    }
    return InvalidResourceType;
}(__BaseException));
export { InvalidResourceType };
var TooManyTagsError = (function (_super) {
    __extends(TooManyTagsError, _super);
    function TooManyTagsError(opts) {
        var _this = _super.call(this, __assign({ name: "TooManyTagsError", $fault: "client" }, opts)) || this;
        _this.name = "TooManyTagsError";
        _this.$fault = "client";
        Object.setPrototypeOf(_this, TooManyTagsError.prototype);
        return _this;
    }
    return TooManyTagsError;
}(__BaseException));
export { TooManyTagsError };
var TooManyUpdates = (function (_super) {
    __extends(TooManyUpdates, _super);
    function TooManyUpdates(opts) {
        var _this = _super.call(this, __assign({ name: "TooManyUpdates", $fault: "client" }, opts)) || this;
        _this.name = "TooManyUpdates";
        _this.$fault = "client";
        Object.setPrototypeOf(_this, TooManyUpdates.prototype);
        _this.Message = opts.Message;
        return _this;
    }
    return TooManyUpdates;
}(__BaseException));
export { TooManyUpdates };
var AlreadyExistsException = (function (_super) {
    __extends(AlreadyExistsException, _super);
    function AlreadyExistsException(opts) {
        var _this = _super.call(this, __assign({ name: "AlreadyExistsException", $fault: "client" }, opts)) || this;
        _this.name = "AlreadyExistsException";
        _this.$fault = "client";
        Object.setPrototypeOf(_this, AlreadyExistsException.prototype);
        _this.Message = opts.Message;
        return _this;
    }
    return AlreadyExistsException;
}(__BaseException));
export { AlreadyExistsException };
var OpsItemInvalidParameterException = (function (_super) {
    __extends(OpsItemInvalidParameterException, _super);
    function OpsItemInvalidParameterException(opts) {
        var _this = _super.call(this, __assign({ name: "OpsItemInvalidParameterException", $fault: "client" }, opts)) || this;
        _this.name = "OpsItemInvalidParameterException";
        _this.$fault = "client";
        Object.setPrototypeOf(_this, OpsItemInvalidParameterException.prototype);
        _this.ParameterNames = opts.ParameterNames;
        _this.Message = opts.Message;
        return _this;
    }
    return OpsItemInvalidParameterException;
}(__BaseException));
export { OpsItemInvalidParameterException };
var OpsItemLimitExceededException = (function (_super) {
    __extends(OpsItemLimitExceededException, _super);
    function OpsItemLimitExceededException(opts) {
        var _this = _super.call(this, __assign({ name: "OpsItemLimitExceededException", $fault: "client" }, opts)) || this;
        _this.name = "OpsItemLimitExceededException";
        _this.$fault = "client";
        Object.setPrototypeOf(_this, OpsItemLimitExceededException.prototype);
        _this.ResourceTypes = opts.ResourceTypes;
        _this.Limit = opts.Limit;
        _this.LimitType = opts.LimitType;
        _this.Message = opts.Message;
        return _this;
    }
    return OpsItemLimitExceededException;
}(__BaseException));
export { OpsItemLimitExceededException };
var OpsItemNotFoundException = (function (_super) {
    __extends(OpsItemNotFoundException, _super);
    function OpsItemNotFoundException(opts) {
        var _this = _super.call(this, __assign({ name: "OpsItemNotFoundException", $fault: "client" }, opts)) || this;
        _this.name = "OpsItemNotFoundException";
        _this.$fault = "client";
        Object.setPrototypeOf(_this, OpsItemNotFoundException.prototype);
        _this.Message = opts.Message;
        return _this;
    }
    return OpsItemNotFoundException;
}(__BaseException));
export { OpsItemNotFoundException };
var OpsItemRelatedItemAlreadyExistsException = (function (_super) {
    __extends(OpsItemRelatedItemAlreadyExistsException, _super);
    function OpsItemRelatedItemAlreadyExistsException(opts) {
        var _this = _super.call(this, __assign({ name: "OpsItemRelatedItemAlreadyExistsException", $fault: "client" }, opts)) || this;
        _this.name = "OpsItemRelatedItemAlreadyExistsException";
        _this.$fault = "client";
        Object.setPrototypeOf(_this, OpsItemRelatedItemAlreadyExistsException.prototype);
        _this.Message = opts.Message;
        _this.ResourceUri = opts.ResourceUri;
        _this.OpsItemId = opts.OpsItemId;
        return _this;
    }
    return OpsItemRelatedItemAlreadyExistsException;
}(__BaseException));
export { OpsItemRelatedItemAlreadyExistsException };
var DuplicateInstanceId = (function (_super) {
    __extends(DuplicateInstanceId, _super);
    function DuplicateInstanceId(opts) {
        var _this = _super.call(this, __assign({ name: "DuplicateInstanceId", $fault: "client" }, opts)) || this;
        _this.name = "DuplicateInstanceId";
        _this.$fault = "client";
        Object.setPrototypeOf(_this, DuplicateInstanceId.prototype);
        return _this;
    }
    return DuplicateInstanceId;
}(__BaseException));
export { DuplicateInstanceId };
var InvalidCommandId = (function (_super) {
    __extends(InvalidCommandId, _super);
    function InvalidCommandId(opts) {
        var _this = _super.call(this, __assign({ name: "InvalidCommandId", $fault: "client" }, opts)) || this;
        _this.name = "InvalidCommandId";
        _this.$fault = "client";
        Object.setPrototypeOf(_this, InvalidCommandId.prototype);
        return _this;
    }
    return InvalidCommandId;
}(__BaseException));
export { InvalidCommandId };
var InvalidInstanceId = (function (_super) {
    __extends(InvalidInstanceId, _super);
    function InvalidInstanceId(opts) {
        var _this = _super.call(this, __assign({ name: "InvalidInstanceId", $fault: "client" }, opts)) || this;
        _this.name = "InvalidInstanceId";
        _this.$fault = "client";
        Object.setPrototypeOf(_this, InvalidInstanceId.prototype);
        _this.Message = opts.Message;
        return _this;
    }
    return InvalidInstanceId;
}(__BaseException));
export { InvalidInstanceId };
var DoesNotExistException = (function (_super) {
    __extends(DoesNotExistException, _super);
    function DoesNotExistException(opts) {
        var _this = _super.call(this, __assign({ name: "DoesNotExistException", $fault: "client" }, opts)) || this;
        _this.name = "DoesNotExistException";
        _this.$fault = "client";
        Object.setPrototypeOf(_this, DoesNotExistException.prototype);
        _this.Message = opts.Message;
        return _this;
    }
    return DoesNotExistException;
}(__BaseException));
export { DoesNotExistException };
var InvalidParameters = (function (_super) {
    __extends(InvalidParameters, _super);
    function InvalidParameters(opts) {
        var _this = _super.call(this, __assign({ name: "InvalidParameters", $fault: "client" }, opts)) || this;
        _this.name = "InvalidParameters";
        _this.$fault = "client";
        Object.setPrototypeOf(_this, InvalidParameters.prototype);
        _this.Message = opts.Message;
        return _this;
    }
    return InvalidParameters;
}(__BaseException));
export { InvalidParameters };
var AssociationAlreadyExists = (function (_super) {
    __extends(AssociationAlreadyExists, _super);
    function AssociationAlreadyExists(opts) {
        var _this = _super.call(this, __assign({ name: "AssociationAlreadyExists", $fault: "client" }, opts)) || this;
        _this.name = "AssociationAlreadyExists";
        _this.$fault = "client";
        Object.setPrototypeOf(_this, AssociationAlreadyExists.prototype);
        return _this;
    }
    return AssociationAlreadyExists;
}(__BaseException));
export { AssociationAlreadyExists };
var AssociationLimitExceeded = (function (_super) {
    __extends(AssociationLimitExceeded, _super);
    function AssociationLimitExceeded(opts) {
        var _this = _super.call(this, __assign({ name: "AssociationLimitExceeded", $fault: "client" }, opts)) || this;
        _this.name = "AssociationLimitExceeded";
        _this.$fault = "client";
        Object.setPrototypeOf(_this, AssociationLimitExceeded.prototype);
        return _this;
    }
    return AssociationLimitExceeded;
}(__BaseException));
export { AssociationLimitExceeded };
export var AssociationComplianceSeverity;
(function (AssociationComplianceSeverity) {
    AssociationComplianceSeverity["Critical"] = "CRITICAL";
    AssociationComplianceSeverity["High"] = "HIGH";
    AssociationComplianceSeverity["Low"] = "LOW";
    AssociationComplianceSeverity["Medium"] = "MEDIUM";
    AssociationComplianceSeverity["Unspecified"] = "UNSPECIFIED";
})(AssociationComplianceSeverity || (AssociationComplianceSeverity = {}));
export var AssociationSyncCompliance;
(function (AssociationSyncCompliance) {
    AssociationSyncCompliance["Auto"] = "AUTO";
    AssociationSyncCompliance["Manual"] = "MANUAL";
})(AssociationSyncCompliance || (AssociationSyncCompliance = {}));
export var AssociationStatusName;
(function (AssociationStatusName) {
    AssociationStatusName["Failed"] = "Failed";
    AssociationStatusName["Pending"] = "Pending";
    AssociationStatusName["Success"] = "Success";
})(AssociationStatusName || (AssociationStatusName = {}));
var InvalidDocument = (function (_super) {
    __extends(InvalidDocument, _super);
    function InvalidDocument(opts) {
        var _this = _super.call(this, __assign({ name: "InvalidDocument", $fault: "client" }, opts)) || this;
        _this.name = "InvalidDocument";
        _this.$fault = "client";
        Object.setPrototypeOf(_this, InvalidDocument.prototype);
        _this.Message = opts.Message;
        return _this;
    }
    return InvalidDocument;
}(__BaseException));
export { InvalidDocument };
var InvalidDocumentVersion = (function (_super) {
    __extends(InvalidDocumentVersion, _super);
    function InvalidDocumentVersion(opts) {
        var _this = _super.call(this, __assign({ name: "InvalidDocumentVersion", $fault: "client" }, opts)) || this;
        _this.name = "InvalidDocumentVersion";
        _this.$fault = "client";
        Object.setPrototypeOf(_this, InvalidDocumentVersion.prototype);
        _this.Message = opts.Message;
        return _this;
    }
    return InvalidDocumentVersion;
}(__BaseException));
export { InvalidDocumentVersion };
var InvalidOutputLocation = (function (_super) {
    __extends(InvalidOutputLocation, _super);
    function InvalidOutputLocation(opts) {
        var _this = _super.call(this, __assign({ name: "InvalidOutputLocation", $fault: "client" }, opts)) || this;
        _this.name = "InvalidOutputLocation";
        _this.$fault = "client";
        Object.setPrototypeOf(_this, InvalidOutputLocation.prototype);
        return _this;
    }
    return InvalidOutputLocation;
}(__BaseException));
export { InvalidOutputLocation };
var InvalidSchedule = (function (_super) {
    __extends(InvalidSchedule, _super);
    function InvalidSchedule(opts) {
        var _this = _super.call(this, __assign({ name: "InvalidSchedule", $fault: "client" }, opts)) || this;
        _this.name = "InvalidSchedule";
        _this.$fault = "client";
        Object.setPrototypeOf(_this, InvalidSchedule.prototype);
        _this.Message = opts.Message;
        return _this;
    }
    return InvalidSchedule;
}(__BaseException));
export { InvalidSchedule };
var InvalidTarget = (function (_super) {
    __extends(InvalidTarget, _super);
    function InvalidTarget(opts) {
        var _this = _super.call(this, __assign({ name: "InvalidTarget", $fault: "client" }, opts)) || this;
        _this.name = "InvalidTarget";
        _this.$fault = "client";
        Object.setPrototypeOf(_this, InvalidTarget.prototype);
        _this.Message = opts.Message;
        return _this;
    }
    return InvalidTarget;
}(__BaseException));
export { InvalidTarget };
var InvalidTargetMaps = (function (_super) {
    __extends(InvalidTargetMaps, _super);
    function InvalidTargetMaps(opts) {
        var _this = _super.call(this, __assign({ name: "InvalidTargetMaps", $fault: "client" }, opts)) || this;
        _this.name = "InvalidTargetMaps";
        _this.$fault = "client";
        Object.setPrototypeOf(_this, InvalidTargetMaps.prototype);
        _this.Message = opts.Message;
        return _this;
    }
    return InvalidTargetMaps;
}(__BaseException));
export { InvalidTargetMaps };
var UnsupportedPlatformType = (function (_super) {
    __extends(UnsupportedPlatformType, _super);
    function UnsupportedPlatformType(opts) {
        var _this = _super.call(this, __assign({ name: "UnsupportedPlatformType", $fault: "client" }, opts)) || this;
        _this.name = "UnsupportedPlatformType";
        _this.$fault = "client";
        Object.setPrototypeOf(_this, UnsupportedPlatformType.prototype);
        _this.Message = opts.Message;
        return _this;
    }
    return UnsupportedPlatformType;
}(__BaseException));
export { UnsupportedPlatformType };
export var AttachmentsSourceKey;
(function (AttachmentsSourceKey) {
    AttachmentsSourceKey["AttachmentReference"] = "AttachmentReference";
    AttachmentsSourceKey["S3FileUrl"] = "S3FileUrl";
    AttachmentsSourceKey["SourceUrl"] = "SourceUrl";
})(AttachmentsSourceKey || (AttachmentsSourceKey = {}));
export var DocumentFormat;
(function (DocumentFormat) {
    DocumentFormat["JSON"] = "JSON";
    DocumentFormat["TEXT"] = "TEXT";
    DocumentFormat["YAML"] = "YAML";
})(DocumentFormat || (DocumentFormat = {}));
export var DocumentType;
(function (DocumentType) {
    DocumentType["ApplicationConfiguration"] = "ApplicationConfiguration";
    DocumentType["ApplicationConfigurationSchema"] = "ApplicationConfigurationSchema";
    DocumentType["Automation"] = "Automation";
    DocumentType["ChangeCalendar"] = "ChangeCalendar";
    DocumentType["ChangeTemplate"] = "Automation.ChangeTemplate";
    DocumentType["Command"] = "Command";
    DocumentType["DeploymentStrategy"] = "DeploymentStrategy";
    DocumentType["Package"] = "Package";
    DocumentType["Policy"] = "Policy";
    DocumentType["ProblemAnalysis"] = "ProblemAnalysis";
    DocumentType["ProblemAnalysisTemplate"] = "ProblemAnalysisTemplate";
    DocumentType["Session"] = "Session";
})(DocumentType || (DocumentType = {}));
export var DocumentHashType;
(function (DocumentHashType) {
    DocumentHashType["SHA1"] = "Sha1";
    DocumentHashType["SHA256"] = "Sha256";
})(DocumentHashType || (DocumentHashType = {}));
export var PlatformType;
(function (PlatformType) {
    PlatformType["LINUX"] = "Linux";
    PlatformType["MACOS"] = "MacOS";
    PlatformType["WINDOWS"] = "Windows";
})(PlatformType || (PlatformType = {}));
export var ReviewStatus;
(function (ReviewStatus) {
    ReviewStatus["APPROVED"] = "APPROVED";
    ReviewStatus["NOT_REVIEWED"] = "NOT_REVIEWED";
    ReviewStatus["PENDING"] = "PENDING";
    ReviewStatus["REJECTED"] = "REJECTED";
})(ReviewStatus || (ReviewStatus = {}));
export var DocumentStatus;
(function (DocumentStatus) {
    DocumentStatus["Active"] = "Active";
    DocumentStatus["Creating"] = "Creating";
    DocumentStatus["Deleting"] = "Deleting";
    DocumentStatus["Failed"] = "Failed";
    DocumentStatus["Updating"] = "Updating";
})(DocumentStatus || (DocumentStatus = {}));
var DocumentAlreadyExists = (function (_super) {
    __extends(DocumentAlreadyExists, _super);
    function DocumentAlreadyExists(opts) {
        var _this = _super.call(this, __assign({ name: "DocumentAlreadyExists", $fault: "client" }, opts)) || this;
        _this.name = "DocumentAlreadyExists";
        _this.$fault = "client";
        Object.setPrototypeOf(_this, DocumentAlreadyExists.prototype);
        _this.Message = opts.Message;
        return _this;
    }
    return DocumentAlreadyExists;
}(__BaseException));
export { DocumentAlreadyExists };
var DocumentLimitExceeded = (function (_super) {
    __extends(DocumentLimitExceeded, _super);
    function DocumentLimitExceeded(opts) {
        var _this = _super.call(this, __assign({ name: "DocumentLimitExceeded", $fault: "client" }, opts)) || this;
        _this.name = "DocumentLimitExceeded";
        _this.$fault = "client";
        Object.setPrototypeOf(_this, DocumentLimitExceeded.prototype);
        _this.Message = opts.Message;
        return _this;
    }
    return DocumentLimitExceeded;
}(__BaseException));
export { DocumentLimitExceeded };
var InvalidDocumentContent = (function (_super) {
    __extends(InvalidDocumentContent, _super);
    function InvalidDocumentContent(opts) {
        var _this = _super.call(this, __assign({ name: "InvalidDocumentContent", $fault: "client" }, opts)) || this;
        _this.name = "InvalidDocumentContent";
        _this.$fault = "client";
        Object.setPrototypeOf(_this, InvalidDocumentContent.prototype);
        _this.Message = opts.Message;
        return _this;
    }
    return InvalidDocumentContent;
}(__BaseException));
export { InvalidDocumentContent };
var InvalidDocumentSchemaVersion = (function (_super) {
    __extends(InvalidDocumentSchemaVersion, _super);
    function InvalidDocumentSchemaVersion(opts) {
        var _this = _super.call(this, __assign({ name: "InvalidDocumentSchemaVersion", $fault: "client" }, opts)) || this;
        _this.name = "InvalidDocumentSchemaVersion";
        _this.$fault = "client";
        Object.setPrototypeOf(_this, InvalidDocumentSchemaVersion.prototype);
        _this.Message = opts.Message;
        return _this;
    }
    return InvalidDocumentSchemaVersion;
}(__BaseException));
export { InvalidDocumentSchemaVersion };
var MaxDocumentSizeExceeded = (function (_super) {
    __extends(MaxDocumentSizeExceeded, _super);
    function MaxDocumentSizeExceeded(opts) {
        var _this = _super.call(this, __assign({ name: "MaxDocumentSizeExceeded", $fault: "client" }, opts)) || this;
        _this.name = "MaxDocumentSizeExceeded";
        _this.$fault = "client";
        Object.setPrototypeOf(_this, MaxDocumentSizeExceeded.prototype);
        _this.Message = opts.Message;
        return _this;
    }
    return MaxDocumentSizeExceeded;
}(__BaseException));
export { MaxDocumentSizeExceeded };
var IdempotentParameterMismatch = (function (_super) {
    __extends(IdempotentParameterMismatch, _super);
    function IdempotentParameterMismatch(opts) {
        var _this = _super.call(this, __assign({ name: "IdempotentParameterMismatch", $fault: "client" }, opts)) || this;
        _this.name = "IdempotentParameterMismatch";
        _this.$fault = "client";
        Object.setPrototypeOf(_this, IdempotentParameterMismatch.prototype);
        _this.Message = opts.Message;
        return _this;
    }
    return IdempotentParameterMismatch;
}(__BaseException));
export { IdempotentParameterMismatch };
var ResourceLimitExceededException = (function (_super) {
    __extends(ResourceLimitExceededException, _super);
    function ResourceLimitExceededException(opts) {
        var _this = _super.call(this, __assign({ name: "ResourceLimitExceededException", $fault: "client" }, opts)) || this;
        _this.name = "ResourceLimitExceededException";
        _this.$fault = "client";
        Object.setPrototypeOf(_this, ResourceLimitExceededException.prototype);
        _this.Message = opts.Message;
        return _this;
    }
    return ResourceLimitExceededException;
}(__BaseException));
export { ResourceLimitExceededException };
export var OpsItemDataType;
(function (OpsItemDataType) {
    OpsItemDataType["SEARCHABLE_STRING"] = "SearchableString";
    OpsItemDataType["STRING"] = "String";
})(OpsItemDataType || (OpsItemDataType = {}));
var OpsItemAlreadyExistsException = (function (_super) {
    __extends(OpsItemAlreadyExistsException, _super);
    function OpsItemAlreadyExistsException(opts) {
        var _this = _super.call(this, __assign({ name: "OpsItemAlreadyExistsException", $fault: "client" }, opts)) || this;
        _this.name = "OpsItemAlreadyExistsException";
        _this.$fault = "client";
        Object.setPrototypeOf(_this, OpsItemAlreadyExistsException.prototype);
        _this.Message = opts.Message;
        _this.OpsItemId = opts.OpsItemId;
        return _this;
    }
    return OpsItemAlreadyExistsException;
}(__BaseException));
export { OpsItemAlreadyExistsException };
var OpsMetadataAlreadyExistsException = (function (_super) {
    __extends(OpsMetadataAlreadyExistsException, _super);
    function OpsMetadataAlreadyExistsException(opts) {
        var _this = _super.call(this, __assign({ name: "OpsMetadataAlreadyExistsException", $fault: "client" }, opts)) || this;
        _this.name = "OpsMetadataAlreadyExistsException";
        _this.$fault = "client";
        Object.setPrototypeOf(_this, OpsMetadataAlreadyExistsException.prototype);
        return _this;
    }
    return OpsMetadataAlreadyExistsException;
}(__BaseException));
export { OpsMetadataAlreadyExistsException };
var OpsMetadataInvalidArgumentException = (function (_super) {
    __extends(OpsMetadataInvalidArgumentException, _super);
    function OpsMetadataInvalidArgumentException(opts) {
        var _this = _super.call(this, __assign({ name: "OpsMetadataInvalidArgumentException", $fault: "client" }, opts)) || this;
        _this.name = "OpsMetadataInvalidArgumentException";
        _this.$fault = "client";
        Object.setPrototypeOf(_this, OpsMetadataInvalidArgumentException.prototype);
        return _this;
    }
    return OpsMetadataInvalidArgumentException;
}(__BaseException));
export { OpsMetadataInvalidArgumentException };
var OpsMetadataLimitExceededException = (function (_super) {
    __extends(OpsMetadataLimitExceededException, _super);
    function OpsMetadataLimitExceededException(opts) {
        var _this = _super.call(this, __assign({ name: "OpsMetadataLimitExceededException", $fault: "client" }, opts)) || this;
        _this.name = "OpsMetadataLimitExceededException";
        _this.$fault = "client";
        Object.setPrototypeOf(_this, OpsMetadataLimitExceededException.prototype);
        return _this;
    }
    return OpsMetadataLimitExceededException;
}(__BaseException));
export { OpsMetadataLimitExceededException };
var OpsMetadataTooManyUpdatesException = (function (_super) {
    __extends(OpsMetadataTooManyUpdatesException, _super);
    function OpsMetadataTooManyUpdatesException(opts) {
        var _this = _super.call(this, __assign({ name: "OpsMetadataTooManyUpdatesException", $fault: "client" }, opts)) || this;
        _this.name = "OpsMetadataTooManyUpdatesException";
        _this.$fault = "client";
        Object.setPrototypeOf(_this, OpsMetadataTooManyUpdatesException.prototype);
        return _this;
    }
    return OpsMetadataTooManyUpdatesException;
}(__BaseException));
export { OpsMetadataTooManyUpdatesException };
export var PatchComplianceLevel;
(function (PatchComplianceLevel) {
    PatchComplianceLevel["Critical"] = "CRITICAL";
    PatchComplianceLevel["High"] = "HIGH";
    PatchComplianceLevel["Informational"] = "INFORMATIONAL";
    PatchComplianceLevel["Low"] = "LOW";
    PatchComplianceLevel["Medium"] = "MEDIUM";
    PatchComplianceLevel["Unspecified"] = "UNSPECIFIED";
})(PatchComplianceLevel || (PatchComplianceLevel = {}));
export var PatchFilterKey;
(function (PatchFilterKey) {
    PatchFilterKey["AdvisoryId"] = "ADVISORY_ID";
    PatchFilterKey["Arch"] = "ARCH";
    PatchFilterKey["BugzillaId"] = "BUGZILLA_ID";
    PatchFilterKey["CVEId"] = "CVE_ID";
    PatchFilterKey["Classification"] = "CLASSIFICATION";
    PatchFilterKey["Epoch"] = "EPOCH";
    PatchFilterKey["MsrcSeverity"] = "MSRC_SEVERITY";
    PatchFilterKey["Name"] = "NAME";
    PatchFilterKey["PatchId"] = "PATCH_ID";
    PatchFilterKey["PatchSet"] = "PATCH_SET";
    PatchFilterKey["Priority"] = "PRIORITY";
    PatchFilterKey["Product"] = "PRODUCT";
    PatchFilterKey["ProductFamily"] = "PRODUCT_FAMILY";
    PatchFilterKey["Release"] = "RELEASE";
    PatchFilterKey["Repository"] = "REPOSITORY";
    PatchFilterKey["Section"] = "SECTION";
    PatchFilterKey["Security"] = "SECURITY";
    PatchFilterKey["Severity"] = "SEVERITY";
    PatchFilterKey["Version"] = "VERSION";
})(PatchFilterKey || (PatchFilterKey = {}));
export var OperatingSystem;
(function (OperatingSystem) {
    OperatingSystem["AmazonLinux"] = "AMAZON_LINUX";
    OperatingSystem["AmazonLinux2"] = "AMAZON_LINUX_2";
    OperatingSystem["CentOS"] = "CENTOS";
    OperatingSystem["Debian"] = "DEBIAN";
    OperatingSystem["MacOS"] = "MACOS";
    OperatingSystem["OracleLinux"] = "ORACLE_LINUX";
    OperatingSystem["Raspbian"] = "RASPBIAN";
    OperatingSystem["RedhatEnterpriseLinux"] = "REDHAT_ENTERPRISE_LINUX";
    OperatingSystem["Rocky_Linux"] = "ROCKY_LINUX";
    OperatingSystem["Suse"] = "SUSE";
    OperatingSystem["Ubuntu"] = "UBUNTU";
    OperatingSystem["Windows"] = "WINDOWS";
})(OperatingSystem || (OperatingSystem = {}));
export var PatchAction;
(function (PatchAction) {
    PatchAction["AllowAsDependency"] = "ALLOW_AS_DEPENDENCY";
    PatchAction["Block"] = "BLOCK";
})(PatchAction || (PatchAction = {}));
export var ResourceDataSyncS3Format;
(function (ResourceDataSyncS3Format) {
    ResourceDataSyncS3Format["JSON_SERDE"] = "JsonSerDe";
})(ResourceDataSyncS3Format || (ResourceDataSyncS3Format = {}));
var ResourceDataSyncAlreadyExistsException = (function (_super) {
    __extends(ResourceDataSyncAlreadyExistsException, _super);
    function ResourceDataSyncAlreadyExistsException(opts) {
        var _this = _super.call(this, __assign({ name: "ResourceDataSyncAlreadyExistsException", $fault: "client" }, opts)) || this;
        _this.name = "ResourceDataSyncAlreadyExistsException";
        _this.$fault = "client";
        Object.setPrototypeOf(_this, ResourceDataSyncAlreadyExistsException.prototype);
        _this.SyncName = opts.SyncName;
        return _this;
    }
    return ResourceDataSyncAlreadyExistsException;
}(__BaseException));
export { ResourceDataSyncAlreadyExistsException };
var ResourceDataSyncCountExceededException = (function (_super) {
    __extends(ResourceDataSyncCountExceededException, _super);
    function ResourceDataSyncCountExceededException(opts) {
        var _this = _super.call(this, __assign({ name: "ResourceDataSyncCountExceededException", $fault: "client" }, opts)) || this;
        _this.name = "ResourceDataSyncCountExceededException";
        _this.$fault = "client";
        Object.setPrototypeOf(_this, ResourceDataSyncCountExceededException.prototype);
        _this.Message = opts.Message;
        return _this;
    }
    return ResourceDataSyncCountExceededException;
}(__BaseException));
export { ResourceDataSyncCountExceededException };
var ResourceDataSyncInvalidConfigurationException = (function (_super) {
    __extends(ResourceDataSyncInvalidConfigurationException, _super);
    function ResourceDataSyncInvalidConfigurationException(opts) {
        var _this = _super.call(this, __assign({ name: "ResourceDataSyncInvalidConfigurationException", $fault: "client" }, opts)) || this;
        _this.name = "ResourceDataSyncInvalidConfigurationException";
        _this.$fault = "client";
        Object.setPrototypeOf(_this, ResourceDataSyncInvalidConfigurationException.prototype);
        _this.Message = opts.Message;
        return _this;
    }
    return ResourceDataSyncInvalidConfigurationException;
}(__BaseException));
export { ResourceDataSyncInvalidConfigurationException };
var InvalidActivation = (function (_super) {
    __extends(InvalidActivation, _super);
    function InvalidActivation(opts) {
        var _this = _super.call(this, __assign({ name: "InvalidActivation", $fault: "client" }, opts)) || this;
        _this.name = "InvalidActivation";
        _this.$fault = "client";
        Object.setPrototypeOf(_this, InvalidActivation.prototype);
        _this.Message = opts.Message;
        return _this;
    }
    return InvalidActivation;
}(__BaseException));
export { InvalidActivation };
var InvalidActivationId = (function (_super) {
    __extends(InvalidActivationId, _super);
    function InvalidActivationId(opts) {
        var _this = _super.call(this, __assign({ name: "InvalidActivationId", $fault: "client" }, opts)) || this;
        _this.name = "InvalidActivationId";
        _this.$fault = "client";
        Object.setPrototypeOf(_this, InvalidActivationId.prototype);
        _this.Message = opts.Message;
        return _this;
    }
    return InvalidActivationId;
}(__BaseException));
export { InvalidActivationId };
var AssociationDoesNotExist = (function (_super) {
    __extends(AssociationDoesNotExist, _super);
    function AssociationDoesNotExist(opts) {
        var _this = _super.call(this, __assign({ name: "AssociationDoesNotExist", $fault: "client" }, opts)) || this;
        _this.name = "AssociationDoesNotExist";
        _this.$fault = "client";
        Object.setPrototypeOf(_this, AssociationDoesNotExist.prototype);
        _this.Message = opts.Message;
        return _this;
    }
    return AssociationDoesNotExist;
}(__BaseException));
export { AssociationDoesNotExist };
var AssociatedInstances = (function (_super) {
    __extends(AssociatedInstances, _super);
    function AssociatedInstances(opts) {
        var _this = _super.call(this, __assign({ name: "AssociatedInstances", $fault: "client" }, opts)) || this;
        _this.name = "AssociatedInstances";
        _this.$fault = "client";
        Object.setPrototypeOf(_this, AssociatedInstances.prototype);
        return _this;
    }
    return AssociatedInstances;
}(__BaseException));
export { AssociatedInstances };
var InvalidDocumentOperation = (function (_super) {
    __extends(InvalidDocumentOperation, _super);
    function InvalidDocumentOperation(opts) {
        var _this = _super.call(this, __assign({ name: "InvalidDocumentOperation", $fault: "client" }, opts)) || this;
        _this.name = "InvalidDocumentOperation";
        _this.$fault = "client";
        Object.setPrototypeOf(_this, InvalidDocumentOperation.prototype);
        _this.Message = opts.Message;
        return _this;
    }
    return InvalidDocumentOperation;
}(__BaseException));
export { InvalidDocumentOperation };
export var InventorySchemaDeleteOption;
(function (InventorySchemaDeleteOption) {
    InventorySchemaDeleteOption["DELETE_SCHEMA"] = "DeleteSchema";
    InventorySchemaDeleteOption["DISABLE_SCHEMA"] = "DisableSchema";
})(InventorySchemaDeleteOption || (InventorySchemaDeleteOption = {}));
var InvalidDeleteInventoryParametersException = (function (_super) {
    __extends(InvalidDeleteInventoryParametersException, _super);
    function InvalidDeleteInventoryParametersException(opts) {
        var _this = _super.call(this, __assign({ name: "InvalidDeleteInventoryParametersException", $fault: "client" }, opts)) || this;
        _this.name = "InvalidDeleteInventoryParametersException";
        _this.$fault = "client";
        Object.setPrototypeOf(_this, InvalidDeleteInventoryParametersException.prototype);
        _this.Message = opts.Message;
        return _this;
    }
    return InvalidDeleteInventoryParametersException;
}(__BaseException));
export { InvalidDeleteInventoryParametersException };
var InvalidInventoryRequestException = (function (_super) {
    __extends(InvalidInventoryRequestException, _super);
    function InvalidInventoryRequestException(opts) {
        var _this = _super.call(this, __assign({ name: "InvalidInventoryRequestException", $fault: "client" }, opts)) || this;
        _this.name = "InvalidInventoryRequestException";
        _this.$fault = "client";
        Object.setPrototypeOf(_this, InvalidInventoryRequestException.prototype);
        _this.Message = opts.Message;
        return _this;
    }
    return InvalidInventoryRequestException;
}(__BaseException));
export { InvalidInventoryRequestException };
var InvalidOptionException = (function (_super) {
    __extends(InvalidOptionException, _super);
    function InvalidOptionException(opts) {
        var _this = _super.call(this, __assign({ name: "InvalidOptionException", $fault: "client" }, opts)) || this;
        _this.name = "InvalidOptionException";
        _this.$fault = "client";
        Object.setPrototypeOf(_this, InvalidOptionException.prototype);
        _this.Message = opts.Message;
        return _this;
    }
    return InvalidOptionException;
}(__BaseException));
export { InvalidOptionException };
var InvalidTypeNameException = (function (_super) {
    __extends(InvalidTypeNameException, _super);
    function InvalidTypeNameException(opts) {
        var _this = _super.call(this, __assign({ name: "InvalidTypeNameException", $fault: "client" }, opts)) || this;
        _this.name = "InvalidTypeNameException";
        _this.$fault = "client";
        Object.setPrototypeOf(_this, InvalidTypeNameException.prototype);
        _this.Message = opts.Message;
        return _this;
    }
    return InvalidTypeNameException;
}(__BaseException));
export { InvalidTypeNameException };
var OpsMetadataNotFoundException = (function (_super) {
    __extends(OpsMetadataNotFoundException, _super);
    function OpsMetadataNotFoundException(opts) {
        var _this = _super.call(this, __assign({ name: "OpsMetadataNotFoundException", $fault: "client" }, opts)) || this;
        _this.name = "OpsMetadataNotFoundException";
        _this.$fault = "client";
        Object.setPrototypeOf(_this, OpsMetadataNotFoundException.prototype);
        return _this;
    }
    return OpsMetadataNotFoundException;
}(__BaseException));
export { OpsMetadataNotFoundException };
var ParameterNotFound = (function (_super) {
    __extends(ParameterNotFound, _super);
    function ParameterNotFound(opts) {
        var _this = _super.call(this, __assign({ name: "ParameterNotFound", $fault: "client" }, opts)) || this;
        _this.name = "ParameterNotFound";
        _this.$fault = "client";
        Object.setPrototypeOf(_this, ParameterNotFound.prototype);
        return _this;
    }
    return ParameterNotFound;
}(__BaseException));
export { ParameterNotFound };
var ResourceInUseException = (function (_super) {
    __extends(ResourceInUseException, _super);
    function ResourceInUseException(opts) {
        var _this = _super.call(this, __assign({ name: "ResourceInUseException", $fault: "client" }, opts)) || this;
        _this.name = "ResourceInUseException";
        _this.$fault = "client";
        Object.setPrototypeOf(_this, ResourceInUseException.prototype);
        _this.Message = opts.Message;
        return _this;
    }
    return ResourceInUseException;
}(__BaseException));
export { ResourceInUseException };
var ResourceDataSyncNotFoundException = (function (_super) {
    __extends(ResourceDataSyncNotFoundException, _super);
    function ResourceDataSyncNotFoundException(opts) {
        var _this = _super.call(this, __assign({ name: "ResourceDataSyncNotFoundException", $fault: "client" }, opts)) || this;
        _this.name = "ResourceDataSyncNotFoundException";
        _this.$fault = "client";
        Object.setPrototypeOf(_this, ResourceDataSyncNotFoundException.prototype);
        _this.SyncName = opts.SyncName;
        _this.SyncType = opts.SyncType;
        _this.Message = opts.Message;
        return _this;
    }
    return ResourceDataSyncNotFoundException;
}(__BaseException));
export { ResourceDataSyncNotFoundException };
var TargetInUseException = (function (_super) {
    __extends(TargetInUseException, _super);
    function TargetInUseException(opts) {
        var _this = _super.call(this, __assign({ name: "TargetInUseException", $fault: "client" }, opts)) || this;
        _this.name = "TargetInUseException";
        _this.$fault = "client";
        Object.setPrototypeOf(_this, TargetInUseException.prototype);
        _this.Message = opts.Message;
        return _this;
    }
    return TargetInUseException;
}(__BaseException));
export { TargetInUseException };
export var DescribeActivationsFilterKeys;
(function (DescribeActivationsFilterKeys) {
    DescribeActivationsFilterKeys["ACTIVATION_IDS"] = "ActivationIds";
    DescribeActivationsFilterKeys["DEFAULT_INSTANCE_NAME"] = "DefaultInstanceName";
    DescribeActivationsFilterKeys["IAM_ROLE"] = "IamRole";
})(DescribeActivationsFilterKeys || (DescribeActivationsFilterKeys = {}));
var InvalidFilter = (function (_super) {
    __extends(InvalidFilter, _super);
    function InvalidFilter(opts) {
        var _this = _super.call(this, __assign({ name: "InvalidFilter", $fault: "client" }, opts)) || this;
        _this.name = "InvalidFilter";
        _this.$fault = "client";
        Object.setPrototypeOf(_this, InvalidFilter.prototype);
        _this.Message = opts.Message;
        return _this;
    }
    return InvalidFilter;
}(__BaseException));
export { InvalidFilter };
var InvalidNextToken = (function (_super) {
    __extends(InvalidNextToken, _super);
    function InvalidNextToken(opts) {
        var _this = _super.call(this, __assign({ name: "InvalidNextToken", $fault: "client" }, opts)) || this;
        _this.name = "InvalidNextToken";
        _this.$fault = "client";
        Object.setPrototypeOf(_this, InvalidNextToken.prototype);
        _this.Message = opts.Message;
        return _this;
    }
    return InvalidNextToken;
}(__BaseException));
export { InvalidNextToken };
var InvalidAssociationVersion = (function (_super) {
    __extends(InvalidAssociationVersion, _super);
    function InvalidAssociationVersion(opts) {
        var _this = _super.call(this, __assign({ name: "InvalidAssociationVersion", $fault: "client" }, opts)) || this;
        _this.name = "InvalidAssociationVersion";
        _this.$fault = "client";
        Object.setPrototypeOf(_this, InvalidAssociationVersion.prototype);
        _this.Message = opts.Message;
        return _this;
    }
    return InvalidAssociationVersion;
}(__BaseException));
export { InvalidAssociationVersion };
export var AssociationExecutionFilterKey;
(function (AssociationExecutionFilterKey) {
    AssociationExecutionFilterKey["CreatedTime"] = "CreatedTime";
    AssociationExecutionFilterKey["ExecutionId"] = "ExecutionId";
    AssociationExecutionFilterKey["Status"] = "Status";
})(AssociationExecutionFilterKey || (AssociationExecutionFilterKey = {}));
export var AssociationFilterOperatorType;
(function (AssociationFilterOperatorType) {
    AssociationFilterOperatorType["Equal"] = "EQUAL";
    AssociationFilterOperatorType["GreaterThan"] = "GREATER_THAN";
    AssociationFilterOperatorType["LessThan"] = "LESS_THAN";
})(AssociationFilterOperatorType || (AssociationFilterOperatorType = {}));
var AssociationExecutionDoesNotExist = (function (_super) {
    __extends(AssociationExecutionDoesNotExist, _super);
    function AssociationExecutionDoesNotExist(opts) {
        var _this = _super.call(this, __assign({ name: "AssociationExecutionDoesNotExist", $fault: "client" }, opts)) || this;
        _this.name = "AssociationExecutionDoesNotExist";
        _this.$fault = "client";
        Object.setPrototypeOf(_this, AssociationExecutionDoesNotExist.prototype);
        _this.Message = opts.Message;
        return _this;
    }
    return AssociationExecutionDoesNotExist;
}(__BaseException));
export { AssociationExecutionDoesNotExist };
export var AssociationExecutionTargetsFilterKey;
(function (AssociationExecutionTargetsFilterKey) {
    AssociationExecutionTargetsFilterKey["ResourceId"] = "ResourceId";
    AssociationExecutionTargetsFilterKey["ResourceType"] = "ResourceType";
    AssociationExecutionTargetsFilterKey["Status"] = "Status";
})(AssociationExecutionTargetsFilterKey || (AssociationExecutionTargetsFilterKey = {}));
export var AutomationExecutionFilterKey;
(function (AutomationExecutionFilterKey) {
    AutomationExecutionFilterKey["AUTOMATION_SUBTYPE"] = "AutomationSubtype";
    AutomationExecutionFilterKey["AUTOMATION_TYPE"] = "AutomationType";
    AutomationExecutionFilterKey["CURRENT_ACTION"] = "CurrentAction";
    AutomationExecutionFilterKey["DOCUMENT_NAME_PREFIX"] = "DocumentNamePrefix";
    AutomationExecutionFilterKey["EXECUTION_ID"] = "ExecutionId";
    AutomationExecutionFilterKey["EXECUTION_STATUS"] = "ExecutionStatus";
    AutomationExecutionFilterKey["OPS_ITEM_ID"] = "OpsItemId";
    AutomationExecutionFilterKey["PARENT_EXECUTION_ID"] = "ParentExecutionId";
    AutomationExecutionFilterKey["START_TIME_AFTER"] = "StartTimeAfter";
    AutomationExecutionFilterKey["START_TIME_BEFORE"] = "StartTimeBefore";
    AutomationExecutionFilterKey["TAG_KEY"] = "TagKey";
    AutomationExecutionFilterKey["TARGET_RESOURCE_GROUP"] = "TargetResourceGroup";
})(AutomationExecutionFilterKey || (AutomationExecutionFilterKey = {}));
export var AutomationExecutionStatus;
(function (AutomationExecutionStatus) {
    AutomationExecutionStatus["APPROVED"] = "Approved";
    AutomationExecutionStatus["CANCELLED"] = "Cancelled";
    AutomationExecutionStatus["CANCELLING"] = "Cancelling";
    AutomationExecutionStatus["CHANGE_CALENDAR_OVERRIDE_APPROVED"] = "ChangeCalendarOverrideApproved";
    AutomationExecutionStatus["CHANGE_CALENDAR_OVERRIDE_REJECTED"] = "ChangeCalendarOverrideRejected";
    AutomationExecutionStatus["COMPLETED_WITH_FAILURE"] = "CompletedWithFailure";
    AutomationExecutionStatus["COMPLETED_WITH_SUCCESS"] = "CompletedWithSuccess";
    AutomationExecutionStatus["FAILED"] = "Failed";
    AutomationExecutionStatus["INPROGRESS"] = "InProgress";
    AutomationExecutionStatus["PENDING"] = "Pending";
    AutomationExecutionStatus["PENDING_APPROVAL"] = "PendingApproval";
    AutomationExecutionStatus["PENDING_CHANGE_CALENDAR_OVERRIDE"] = "PendingChangeCalendarOverride";
    AutomationExecutionStatus["REJECTED"] = "Rejected";
    AutomationExecutionStatus["RUNBOOK_INPROGRESS"] = "RunbookInProgress";
    AutomationExecutionStatus["SCHEDULED"] = "Scheduled";
    AutomationExecutionStatus["SUCCESS"] = "Success";
    AutomationExecutionStatus["TIMEDOUT"] = "TimedOut";
    AutomationExecutionStatus["WAITING"] = "Waiting";
})(AutomationExecutionStatus || (AutomationExecutionStatus = {}));
export var AutomationSubtype;
(function (AutomationSubtype) {
    AutomationSubtype["ChangeRequest"] = "ChangeRequest";
})(AutomationSubtype || (AutomationSubtype = {}));
export var AutomationType;
(function (AutomationType) {
    AutomationType["CrossAccount"] = "CrossAccount";
    AutomationType["Local"] = "Local";
})(AutomationType || (AutomationType = {}));
export var ExecutionMode;
(function (ExecutionMode) {
    ExecutionMode["Auto"] = "Auto";
    ExecutionMode["Interactive"] = "Interactive";
})(ExecutionMode || (ExecutionMode = {}));
var InvalidFilterKey = (function (_super) {
    __extends(InvalidFilterKey, _super);
    function InvalidFilterKey(opts) {
        var _this = _super.call(this, __assign({ name: "InvalidFilterKey", $fault: "client" }, opts)) || this;
        _this.name = "InvalidFilterKey";
        _this.$fault = "client";
        Object.setPrototypeOf(_this, InvalidFilterKey.prototype);
        return _this;
    }
    return InvalidFilterKey;
}(__BaseException));
export { InvalidFilterKey };
var InvalidFilterValue = (function (_super) {
    __extends(InvalidFilterValue, _super);
    function InvalidFilterValue(opts) {
        var _this = _super.call(this, __assign({ name: "InvalidFilterValue", $fault: "client" }, opts)) || this;
        _this.name = "InvalidFilterValue";
        _this.$fault = "client";
        Object.setPrototypeOf(_this, InvalidFilterValue.prototype);
        _this.Message = opts.Message;
        return _this;
    }
    return InvalidFilterValue;
}(__BaseException));
export { InvalidFilterValue };
var AutomationExecutionNotFoundException = (function (_super) {
    __extends(AutomationExecutionNotFoundException, _super);
    function AutomationExecutionNotFoundException(opts) {
        var _this = _super.call(this, __assign({ name: "AutomationExecutionNotFoundException", $fault: "client" }, opts)) || this;
        _this.name = "AutomationExecutionNotFoundException";
        _this.$fault = "client";
        Object.setPrototypeOf(_this, AutomationExecutionNotFoundException.prototype);
        _this.Message = opts.Message;
        return _this;
    }
    return AutomationExecutionNotFoundException;
}(__BaseException));
export { AutomationExecutionNotFoundException };
export var StepExecutionFilterKey;
(function (StepExecutionFilterKey) {
    StepExecutionFilterKey["ACTION"] = "Action";
    StepExecutionFilterKey["START_TIME_AFTER"] = "StartTimeAfter";
    StepExecutionFilterKey["START_TIME_BEFORE"] = "StartTimeBefore";
    StepExecutionFilterKey["STEP_EXECUTION_ID"] = "StepExecutionId";
    StepExecutionFilterKey["STEP_EXECUTION_STATUS"] = "StepExecutionStatus";
    StepExecutionFilterKey["STEP_NAME"] = "StepName";
})(StepExecutionFilterKey || (StepExecutionFilterKey = {}));
export var DocumentPermissionType;
(function (DocumentPermissionType) {
    DocumentPermissionType["SHARE"] = "Share";
})(DocumentPermissionType || (DocumentPermissionType = {}));
var InvalidPermissionType = (function (_super) {
    __extends(InvalidPermissionType, _super);
    function InvalidPermissionType(opts) {
        var _this = _super.call(this, __assign({ name: "InvalidPermissionType", $fault: "client" }, opts)) || this;
        _this.name = "InvalidPermissionType";
        _this.$fault = "client";
        Object.setPrototypeOf(_this, InvalidPermissionType.prototype);
        _this.Message = opts.Message;
        return _this;
    }
    return InvalidPermissionType;
}(__BaseException));
export { InvalidPermissionType };
export var PatchDeploymentStatus;
(function (PatchDeploymentStatus) {
    PatchDeploymentStatus["Approved"] = "APPROVED";
    PatchDeploymentStatus["ExplicitApproved"] = "EXPLICIT_APPROVED";
    PatchDeploymentStatus["ExplicitRejected"] = "EXPLICIT_REJECTED";
    PatchDeploymentStatus["PendingApproval"] = "PENDING_APPROVAL";
})(PatchDeploymentStatus || (PatchDeploymentStatus = {}));
var UnsupportedOperatingSystem = (function (_super) {
    __extends(UnsupportedOperatingSystem, _super);
    function UnsupportedOperatingSystem(opts) {
        var _this = _super.call(this, __assign({ name: "UnsupportedOperatingSystem", $fault: "client" }, opts)) || this;
        _this.name = "UnsupportedOperatingSystem";
        _this.$fault = "client";
        Object.setPrototypeOf(_this, UnsupportedOperatingSystem.prototype);
        _this.Message = opts.Message;
        return _this;
    }
    return UnsupportedOperatingSystem;
}(__BaseException));
export { UnsupportedOperatingSystem };
export var InstanceInformationFilterKey;
(function (InstanceInformationFilterKey) {
    InstanceInformationFilterKey["ACTIVATION_IDS"] = "ActivationIds";
    InstanceInformationFilterKey["AGENT_VERSION"] = "AgentVersion";
    InstanceInformationFilterKey["ASSOCIATION_STATUS"] = "AssociationStatus";
    InstanceInformationFilterKey["IAM_ROLE"] = "IamRole";
    InstanceInformationFilterKey["INSTANCE_IDS"] = "InstanceIds";
    InstanceInformationFilterKey["PING_STATUS"] = "PingStatus";
    InstanceInformationFilterKey["PLATFORM_TYPES"] = "PlatformTypes";
    InstanceInformationFilterKey["RESOURCE_TYPE"] = "ResourceType";
})(InstanceInformationFilterKey || (InstanceInformationFilterKey = {}));
export var PingStatus;
(function (PingStatus) {
    PingStatus["CONNECTION_LOST"] = "ConnectionLost";
    PingStatus["INACTIVE"] = "Inactive";
    PingStatus["ONLINE"] = "Online";
})(PingStatus || (PingStatus = {}));
export var ResourceType;
(function (ResourceType) {
    ResourceType["DOCUMENT"] = "Document";
    ResourceType["EC2_INSTANCE"] = "EC2Instance";
    ResourceType["MANAGED_INSTANCE"] = "ManagedInstance";
})(ResourceType || (ResourceType = {}));
export var SourceType;
(function (SourceType) {
    SourceType["AWS_EC2_INSTANCE"] = "AWS::EC2::Instance";
    SourceType["AWS_IOT_THING"] = "AWS::IoT::Thing";
    SourceType["AWS_SSM_MANAGEDINSTANCE"] = "AWS::SSM::ManagedInstance";
})(SourceType || (SourceType = {}));
var InvalidInstanceInformationFilterValue = (function (_super) {
    __extends(InvalidInstanceInformationFilterValue, _super);
    function InvalidInstanceInformationFilterValue(opts) {
        var _this = _super.call(this, __assign({ name: "InvalidInstanceInformationFilterValue", $fault: "client" }, opts)) || this;
        _this.name = "InvalidInstanceInformationFilterValue";
        _this.$fault = "client";
        Object.setPrototypeOf(_this, InvalidInstanceInformationFilterValue.prototype);
        return _this;
    }
    return InvalidInstanceInformationFilterValue;
}(__BaseException));
export { InvalidInstanceInformationFilterValue };
export var PatchComplianceDataState;
(function (PatchComplianceDataState) {
    PatchComplianceDataState["Failed"] = "FAILED";
    PatchComplianceDataState["Installed"] = "INSTALLED";
    PatchComplianceDataState["InstalledOther"] = "INSTALLED_OTHER";
    PatchComplianceDataState["InstalledPendingReboot"] = "INSTALLED_PENDING_REBOOT";
    PatchComplianceDataState["InstalledRejected"] = "INSTALLED_REJECTED";
    PatchComplianceDataState["Missing"] = "MISSING";
    PatchComplianceDataState["NotApplicable"] = "NOT_APPLICABLE";
})(PatchComplianceDataState || (PatchComplianceDataState = {}));
export var PatchOperationType;
(function (PatchOperationType) {
    PatchOperationType["INSTALL"] = "Install";
    PatchOperationType["SCAN"] = "Scan";
})(PatchOperationType || (PatchOperationType = {}));
export var RebootOption;
(function (RebootOption) {
    RebootOption["NO_REBOOT"] = "NoReboot";
    RebootOption["REBOOT_IF_NEEDED"] = "RebootIfNeeded";
})(RebootOption || (RebootOption = {}));
export var InstancePatchStateOperatorType;
(function (InstancePatchStateOperatorType) {
    InstancePatchStateOperatorType["EQUAL"] = "Equal";
    InstancePatchStateOperatorType["GREATER_THAN"] = "GreaterThan";
    InstancePatchStateOperatorType["LESS_THAN"] = "LessThan";
    InstancePatchStateOperatorType["NOT_EQUAL"] = "NotEqual";
})(InstancePatchStateOperatorType || (InstancePatchStateOperatorType = {}));
export var InventoryDeletionStatus;
(function (InventoryDeletionStatus) {
    InventoryDeletionStatus["COMPLETE"] = "Complete";
    InventoryDeletionStatus["IN_PROGRESS"] = "InProgress";
})(InventoryDeletionStatus || (InventoryDeletionStatus = {}));
var InvalidDeletionIdException = (function (_super) {
    __extends(InvalidDeletionIdException, _super);
    function InvalidDeletionIdException(opts) {
        var _this = _super.call(this, __assign({ name: "InvalidDeletionIdException", $fault: "client" }, opts)) || this;
        _this.name = "InvalidDeletionIdException";
        _this.$fault = "client";
        Object.setPrototypeOf(_this, InvalidDeletionIdException.prototype);
        _this.Message = opts.Message;
        return _this;
    }
    return InvalidDeletionIdException;
}(__BaseException));
export { InvalidDeletionIdException };
export var MaintenanceWindowExecutionStatus;
(function (MaintenanceWindowExecutionStatus) {
    MaintenanceWindowExecutionStatus["Cancelled"] = "CANCELLED";
    MaintenanceWindowExecutionStatus["Cancelling"] = "CANCELLING";
    MaintenanceWindowExecutionStatus["Failed"] = "FAILED";
    MaintenanceWindowExecutionStatus["InProgress"] = "IN_PROGRESS";
    MaintenanceWindowExecutionStatus["Pending"] = "PENDING";
    MaintenanceWindowExecutionStatus["SkippedOverlapping"] = "SKIPPED_OVERLAPPING";
    MaintenanceWindowExecutionStatus["Success"] = "SUCCESS";
    MaintenanceWindowExecutionStatus["TimedOut"] = "TIMED_OUT";
})(MaintenanceWindowExecutionStatus || (MaintenanceWindowExecutionStatus = {}));
export var MaintenanceWindowTaskType;
(function (MaintenanceWindowTaskType) {
    MaintenanceWindowTaskType["Automation"] = "AUTOMATION";
    MaintenanceWindowTaskType["Lambda"] = "LAMBDA";
    MaintenanceWindowTaskType["RunCommand"] = "RUN_COMMAND";
    MaintenanceWindowTaskType["StepFunctions"] = "STEP_FUNCTIONS";
})(MaintenanceWindowTaskType || (MaintenanceWindowTaskType = {}));
export var MaintenanceWindowResourceType;
(function (MaintenanceWindowResourceType) {
    MaintenanceWindowResourceType["Instance"] = "INSTANCE";
    MaintenanceWindowResourceType["ResourceGroup"] = "RESOURCE_GROUP";
})(MaintenanceWindowResourceType || (MaintenanceWindowResourceType = {}));
export var MaintenanceWindowTaskCutoffBehavior;
(function (MaintenanceWindowTaskCutoffBehavior) {
    MaintenanceWindowTaskCutoffBehavior["CancelTask"] = "CANCEL_TASK";
    MaintenanceWindowTaskCutoffBehavior["ContinueTask"] = "CONTINUE_TASK";
})(MaintenanceWindowTaskCutoffBehavior || (MaintenanceWindowTaskCutoffBehavior = {}));
export var OpsItemFilterKey;
(function (OpsItemFilterKey) {
    OpsItemFilterKey["ACTUAL_END_TIME"] = "ActualEndTime";
    OpsItemFilterKey["ACTUAL_START_TIME"] = "ActualStartTime";
    OpsItemFilterKey["AUTOMATION_ID"] = "AutomationId";
    OpsItemFilterKey["CATEGORY"] = "Category";
    OpsItemFilterKey["CHANGE_REQUEST_APPROVER_ARN"] = "ChangeRequestByApproverArn";
    OpsItemFilterKey["CHANGE_REQUEST_APPROVER_NAME"] = "ChangeRequestByApproverName";
    OpsItemFilterKey["CHANGE_REQUEST_REQUESTER_ARN"] = "ChangeRequestByRequesterArn";
    OpsItemFilterKey["CHANGE_REQUEST_REQUESTER_NAME"] = "ChangeRequestByRequesterName";
    OpsItemFilterKey["CHANGE_REQUEST_TARGETS_RESOURCE_GROUP"] = "ChangeRequestByTargetsResourceGroup";
    OpsItemFilterKey["CHANGE_REQUEST_TEMPLATE"] = "ChangeRequestByTemplate";
    OpsItemFilterKey["CREATED_BY"] = "CreatedBy";
    OpsItemFilterKey["CREATED_TIME"] = "CreatedTime";
    OpsItemFilterKey["INSIGHT_TYPE"] = "InsightByType";
    OpsItemFilterKey["LAST_MODIFIED_TIME"] = "LastModifiedTime";
    OpsItemFilterKey["OPERATIONAL_DATA"] = "OperationalData";
    OpsItemFilterKey["OPERATIONAL_DATA_KEY"] = "OperationalDataKey";
    OpsItemFilterKey["OPERATIONAL_DATA_VALUE"] = "OperationalDataValue";
    OpsItemFilterKey["OPSITEM_ID"] = "OpsItemId";
    OpsItemFilterKey["OPSITEM_TYPE"] = "OpsItemType";
    OpsItemFilterKey["PLANNED_END_TIME"] = "PlannedEndTime";
    OpsItemFilterKey["PLANNED_START_TIME"] = "PlannedStartTime";
    OpsItemFilterKey["PRIORITY"] = "Priority";
    OpsItemFilterKey["RESOURCE_ID"] = "ResourceId";
    OpsItemFilterKey["SEVERITY"] = "Severity";
    OpsItemFilterKey["SOURCE"] = "Source";
    OpsItemFilterKey["STATUS"] = "Status";
    OpsItemFilterKey["TITLE"] = "Title";
})(OpsItemFilterKey || (OpsItemFilterKey = {}));
export var OpsItemFilterOperator;
(function (OpsItemFilterOperator) {
    OpsItemFilterOperator["CONTAINS"] = "Contains";
    OpsItemFilterOperator["EQUAL"] = "Equal";
    OpsItemFilterOperator["GREATER_THAN"] = "GreaterThan";
    OpsItemFilterOperator["LESS_THAN"] = "LessThan";
})(OpsItemFilterOperator || (OpsItemFilterOperator = {}));
export var OpsItemStatus;
(function (OpsItemStatus) {
    OpsItemStatus["APPROVED"] = "Approved";
    OpsItemStatus["CANCELLED"] = "Cancelled";
    OpsItemStatus["CANCELLING"] = "Cancelling";
    OpsItemStatus["CHANGE_CALENDAR_OVERRIDE_APPROVED"] = "ChangeCalendarOverrideApproved";
    OpsItemStatus["CHANGE_CALENDAR_OVERRIDE_REJECTED"] = "ChangeCalendarOverrideRejected";
    OpsItemStatus["CLOSED"] = "Closed";
    OpsItemStatus["COMPLETED_WITH_FAILURE"] = "CompletedWithFailure";
    OpsItemStatus["COMPLETED_WITH_SUCCESS"] = "CompletedWithSuccess";
    OpsItemStatus["FAILED"] = "Failed";
    OpsItemStatus["IN_PROGRESS"] = "InProgress";
    OpsItemStatus["OPEN"] = "Open";
    OpsItemStatus["PENDING"] = "Pending";
    OpsItemStatus["PENDING_APPROVAL"] = "PendingApproval";
    OpsItemStatus["PENDING_CHANGE_CALENDAR_OVERRIDE"] = "PendingChangeCalendarOverride";
    OpsItemStatus["REJECTED"] = "Rejected";
    OpsItemStatus["RESOLVED"] = "Resolved";
    OpsItemStatus["RUNBOOK_IN_PROGRESS"] = "RunbookInProgress";
    OpsItemStatus["SCHEDULED"] = "Scheduled";
    OpsItemStatus["TIMED_OUT"] = "TimedOut";
})(OpsItemStatus || (OpsItemStatus = {}));
export var ParametersFilterKey;
(function (ParametersFilterKey) {
    ParametersFilterKey["KEY_ID"] = "KeyId";
    ParametersFilterKey["NAME"] = "Name";
    ParametersFilterKey["TYPE"] = "Type";
})(ParametersFilterKey || (ParametersFilterKey = {}));
export var AccountSharingInfoFilterSensitiveLog = function (obj) { return (__assign({}, obj)); };
export var TagFilterSensitiveLog = function (obj) { return (__assign({}, obj)); };
export var ActivationFilterSensitiveLog = function (obj) { return (__assign({}, obj)); };
export var AddTagsToResourceRequestFilterSensitiveLog = function (obj) { return (__assign({}, obj)); };
export var AddTagsToResourceResultFilterSensitiveLog = function (obj) { return (__assign({}, obj)); };
export var AssociateOpsItemRelatedItemRequestFilterSensitiveLog = function (obj) { return (__assign({}, obj)); };
export var AssociateOpsItemRelatedItemResponseFilterSensitiveLog = function (obj) { return (__assign({}, obj)); };
export var CancelCommandRequestFilterSensitiveLog = function (obj) { return (__assign({}, obj)); };
export var CancelCommandResultFilterSensitiveLog = function (obj) { return (__assign({}, obj)); };
export var CancelMaintenanceWindowExecutionRequestFilterSensitiveLog = function (obj) { return (__assign({}, obj)); };
export var CancelMaintenanceWindowExecutionResultFilterSensitiveLog = function (obj) { return (__assign({}, obj)); };
export var RegistrationMetadataItemFilterSensitiveLog = function (obj) { return (__assign({}, obj)); };
export var CreateActivationRequestFilterSensitiveLog = function (obj) { return (__assign({}, obj)); };
export var CreateActivationResultFilterSensitiveLog = function (obj) { return (__assign({}, obj)); };
export var S3OutputLocationFilterSensitiveLog = function (obj) { return (__assign({}, obj)); };
export var InstanceAssociationOutputLocationFilterSensitiveLog = function (obj) { return (__assign({}, obj)); };
export var TargetLocationFilterSensitiveLog = function (obj) { return (__assign({}, obj)); };
export var TargetFilterSensitiveLog = function (obj) { return (__assign({}, obj)); };
export var CreateAssociationRequestFilterSensitiveLog = function (obj) { return (__assign(__assign({}, obj), (obj.Parameters && { Parameters: SENSITIVE_STRING }))); };
export var AssociationOverviewFilterSensitiveLog = function (obj) { return (__assign({}, obj)); };
export var AssociationStatusFilterSensitiveLog = function (obj) { return (__assign({}, obj)); };
export var AssociationDescriptionFilterSensitiveLog = function (obj) { return (__assign(__assign({}, obj), (obj.Parameters && { Parameters: SENSITIVE_STRING }))); };
export var CreateAssociationResultFilterSensitiveLog = function (obj) { return (__assign(__assign({}, obj), (obj.AssociationDescription && {
    AssociationDescription: AssociationDescriptionFilterSensitiveLog(obj.AssociationDescription),
}))); };
export var CreateAssociationBatchRequestEntryFilterSensitiveLog = function (obj) { return (__assign(__assign({}, obj), (obj.Parameters && { Parameters: SENSITIVE_STRING }))); };
export var CreateAssociationBatchRequestFilterSensitiveLog = function (obj) { return (__assign(__assign({}, obj), (obj.Entries && {
    Entries: obj.Entries.map(function (item) { return CreateAssociationBatchRequestEntryFilterSensitiveLog(item); }),
}))); };
export var FailedCreateAssociationFilterSensitiveLog = function (obj) { return (__assign(__assign({}, obj), (obj.Entry && { Entry: CreateAssociationBatchRequestEntryFilterSensitiveLog(obj.Entry) }))); };
export var CreateAssociationBatchResultFilterSensitiveLog = function (obj) { return (__assign(__assign(__assign({}, obj), (obj.Successful && { Successful: obj.Successful.map(function (item) { return AssociationDescriptionFilterSensitiveLog(item); }) })), (obj.Failed && { Failed: obj.Failed.map(function (item) { return FailedCreateAssociationFilterSensitiveLog(item); }) }))); };
export var AttachmentsSourceFilterSensitiveLog = function (obj) { return (__assign({}, obj)); };
export var DocumentRequiresFilterSensitiveLog = function (obj) { return (__assign({}, obj)); };
export var CreateDocumentRequestFilterSensitiveLog = function (obj) { return (__assign({}, obj)); };
export var AttachmentInformationFilterSensitiveLog = function (obj) { return (__assign({}, obj)); };
export var DocumentParameterFilterSensitiveLog = function (obj) { return (__assign({}, obj)); };
export var ReviewInformationFilterSensitiveLog = function (obj) { return (__assign({}, obj)); };
export var DocumentDescriptionFilterSensitiveLog = function (obj) { return (__assign({}, obj)); };
export var CreateDocumentResultFilterSensitiveLog = function (obj) { return (__assign({}, obj)); };
export var CreateMaintenanceWindowRequestFilterSensitiveLog = function (obj) { return (__assign(__assign({}, obj), (obj.Description && { Description: SENSITIVE_STRING }))); };
export var CreateMaintenanceWindowResultFilterSensitiveLog = function (obj) { return (__assign({}, obj)); };
export var OpsItemNotificationFilterSensitiveLog = function (obj) { return (__assign({}, obj)); };
export var OpsItemDataValueFilterSensitiveLog = function (obj) { return (__assign({}, obj)); };
export var RelatedOpsItemFilterSensitiveLog = function (obj) { return (__assign({}, obj)); };
export var CreateOpsItemRequestFilterSensitiveLog = function (obj) { return (__assign({}, obj)); };
export var CreateOpsItemResponseFilterSensitiveLog = function (obj) { return (__assign({}, obj)); };
export var MetadataValueFilterSensitiveLog = function (obj) { return (__assign({}, obj)); };
export var CreateOpsMetadataRequestFilterSensitiveLog = function (obj) { return (__assign({}, obj)); };
export var CreateOpsMetadataResultFilterSensitiveLog = function (obj) { return (__assign({}, obj)); };
export var PatchFilterFilterSensitiveLog = function (obj) { return (__assign({}, obj)); };
export var PatchFilterGroupFilterSensitiveLog = function (obj) { return (__assign({}, obj)); };
export var PatchRuleFilterSensitiveLog = function (obj) { return (__assign({}, obj)); };
export var PatchRuleGroupFilterSensitiveLog = function (obj) { return (__assign({}, obj)); };
export var PatchSourceFilterSensitiveLog = function (obj) { return (__assign(__assign({}, obj), (obj.Configuration && { Configuration: SENSITIVE_STRING }))); };
export var CreatePatchBaselineRequestFilterSensitiveLog = function (obj) { return (__assign(__assign({}, obj), (obj.Sources && { Sources: obj.Sources.map(function (item) { return PatchSourceFilterSensitiveLog(item); }) }))); };
export var CreatePatchBaselineResultFilterSensitiveLog = function (obj) { return (__assign({}, obj)); };
export var ResourceDataSyncDestinationDataSharingFilterSensitiveLog = function (obj) { return (__assign({}, obj)); };
export var ResourceDataSyncS3DestinationFilterSensitiveLog = function (obj) { return (__assign({}, obj)); };
export var ResourceDataSyncOrganizationalUnitFilterSensitiveLog = function (obj) { return (__assign({}, obj)); };
export var ResourceDataSyncAwsOrganizationsSourceFilterSensitiveLog = function (obj) { return (__assign({}, obj)); };
export var ResourceDataSyncSourceFilterSensitiveLog = function (obj) { return (__assign({}, obj)); };
export var CreateResourceDataSyncRequestFilterSensitiveLog = function (obj) { return (__assign({}, obj)); };
export var CreateResourceDataSyncResultFilterSensitiveLog = function (obj) { return (__assign({}, obj)); };
export var DeleteActivationRequestFilterSensitiveLog = function (obj) { return (__assign({}, obj)); };
export var DeleteActivationResultFilterSensitiveLog = function (obj) { return (__assign({}, obj)); };
export var DeleteAssociationRequestFilterSensitiveLog = function (obj) { return (__assign({}, obj)); };
export var DeleteAssociationResultFilterSensitiveLog = function (obj) { return (__assign({}, obj)); };
export var DeleteDocumentRequestFilterSensitiveLog = function (obj) { return (__assign({}, obj)); };
export var DeleteDocumentResultFilterSensitiveLog = function (obj) { return (__assign({}, obj)); };
export var DeleteInventoryRequestFilterSensitiveLog = function (obj) { return (__assign({}, obj)); };
export var InventoryDeletionSummaryItemFilterSensitiveLog = function (obj) { return (__assign({}, obj)); };
export var InventoryDeletionSummaryFilterSensitiveLog = function (obj) { return (__assign({}, obj)); };
export var DeleteInventoryResultFilterSensitiveLog = function (obj) { return (__assign({}, obj)); };
export var DeleteMaintenanceWindowRequestFilterSensitiveLog = function (obj) { return (__assign({}, obj)); };
export var DeleteMaintenanceWindowResultFilterSensitiveLog = function (obj) { return (__assign({}, obj)); };
export var DeleteOpsMetadataRequestFilterSensitiveLog = function (obj) { return (__assign({}, obj)); };
export var DeleteOpsMetadataResultFilterSensitiveLog = function (obj) { return (__assign({}, obj)); };
export var DeleteParameterRequestFilterSensitiveLog = function (obj) { return (__assign({}, obj)); };
export var DeleteParameterResultFilterSensitiveLog = function (obj) { return (__assign({}, obj)); };
export var DeleteParametersRequestFilterSensitiveLog = function (obj) { return (__assign({}, obj)); };
export var DeleteParametersResultFilterSensitiveLog = function (obj) { return (__assign({}, obj)); };
export var DeletePatchBaselineRequestFilterSensitiveLog = function (obj) { return (__assign({}, obj)); };
export var DeletePatchBaselineResultFilterSensitiveLog = function (obj) { return (__assign({}, obj)); };
export var DeleteResourceDataSyncRequestFilterSensitiveLog = function (obj) { return (__assign({}, obj)); };
export var DeleteResourceDataSyncResultFilterSensitiveLog = function (obj) { return (__assign({}, obj)); };
export var DeregisterManagedInstanceRequestFilterSensitiveLog = function (obj) { return (__assign({}, obj)); };
export var DeregisterManagedInstanceResultFilterSensitiveLog = function (obj) { return (__assign({}, obj)); };
export var DeregisterPatchBaselineForPatchGroupRequestFilterSensitiveLog = function (obj) { return (__assign({}, obj)); };
export var DeregisterPatchBaselineForPatchGroupResultFilterSensitiveLog = function (obj) { return (__assign({}, obj)); };
export var DeregisterTargetFromMaintenanceWindowRequestFilterSensitiveLog = function (obj) { return (__assign({}, obj)); };
export var DeregisterTargetFromMaintenanceWindowResultFilterSensitiveLog = function (obj) { return (__assign({}, obj)); };
export var DeregisterTaskFromMaintenanceWindowRequestFilterSensitiveLog = function (obj) { return (__assign({}, obj)); };
export var DeregisterTaskFromMaintenanceWindowResultFilterSensitiveLog = function (obj) { return (__assign({}, obj)); };
export var DescribeActivationsFilterFilterSensitiveLog = function (obj) { return (__assign({}, obj)); };
export var DescribeActivationsRequestFilterSensitiveLog = function (obj) { return (__assign({}, obj)); };
export var DescribeActivationsResultFilterSensitiveLog = function (obj) { return (__assign({}, obj)); };
export var DescribeAssociationRequestFilterSensitiveLog = function (obj) { return (__assign({}, obj)); };
export var DescribeAssociationResultFilterSensitiveLog = function (obj) { return (__assign(__assign({}, obj), (obj.AssociationDescription && {
    AssociationDescription: AssociationDescriptionFilterSensitiveLog(obj.AssociationDescription),
}))); };
export var AssociationExecutionFilterFilterSensitiveLog = function (obj) { return (__assign({}, obj)); };
export var DescribeAssociationExecutionsRequestFilterSensitiveLog = function (obj) { return (__assign({}, obj)); };
export var AssociationExecutionFilterSensitiveLog = function (obj) { return (__assign({}, obj)); };
export var DescribeAssociationExecutionsResultFilterSensitiveLog = function (obj) { return (__assign({}, obj)); };
export var AssociationExecutionTargetsFilterFilterSensitiveLog = function (obj) { return (__assign({}, obj)); };
export var DescribeAssociationExecutionTargetsRequestFilterSensitiveLog = function (obj) { return (__assign({}, obj)); };
export var OutputSourceFilterSensitiveLog = function (obj) { return (__assign({}, obj)); };
export var AssociationExecutionTargetFilterSensitiveLog = function (obj) { return (__assign({}, obj)); };
export var DescribeAssociationExecutionTargetsResultFilterSensitiveLog = function (obj) { return (__assign({}, obj)); };
export var AutomationExecutionFilterFilterSensitiveLog = function (obj) { return (__assign({}, obj)); };
export var DescribeAutomationExecutionsRequestFilterSensitiveLog = function (obj) { return (__assign({}, obj)); };
export var ResolvedTargetsFilterSensitiveLog = function (obj) { return (__assign({}, obj)); };
export var RunbookFilterSensitiveLog = function (obj) { return (__assign({}, obj)); };
export var AutomationExecutionMetadataFilterSensitiveLog = function (obj) { return (__assign({}, obj)); };
export var DescribeAutomationExecutionsResultFilterSensitiveLog = function (obj) { return (__assign({}, obj)); };
export var StepExecutionFilterFilterSensitiveLog = function (obj) { return (__assign({}, obj)); };
export var DescribeAutomationStepExecutionsRequestFilterSensitiveLog = function (obj) { return (__assign({}, obj)); };
export var FailureDetailsFilterSensitiveLog = function (obj) { return (__assign({}, obj)); };
export var StepExecutionFilterSensitiveLog = function (obj) { return (__assign({}, obj)); };
export var DescribeAutomationStepExecutionsResultFilterSensitiveLog = function (obj) { return (__assign({}, obj)); };
export var PatchOrchestratorFilterFilterSensitiveLog = function (obj) { return (__assign({}, obj)); };
export var DescribeAvailablePatchesRequestFilterSensitiveLog = function (obj) { return (__assign({}, obj)); };
export var PatchFilterSensitiveLog = function (obj) { return (__assign({}, obj)); };
export var DescribeAvailablePatchesResultFilterSensitiveLog = function (obj) { return (__assign({}, obj)); };
export var DescribeDocumentRequestFilterSensitiveLog = function (obj) { return (__assign({}, obj)); };
export var DescribeDocumentResultFilterSensitiveLog = function (obj) { return (__assign({}, obj)); };
export var DescribeDocumentPermissionRequestFilterSensitiveLog = function (obj) { return (__assign({}, obj)); };
export var DescribeDocumentPermissionResponseFilterSensitiveLog = function (obj) { return (__assign({}, obj)); };
export var DescribeEffectiveInstanceAssociationsRequestFilterSensitiveLog = function (obj) { return (__assign({}, obj)); };
export var InstanceAssociationFilterSensitiveLog = function (obj) { return (__assign({}, obj)); };
export var DescribeEffectiveInstanceAssociationsResultFilterSensitiveLog = function (obj) { return (__assign({}, obj)); };
export var DescribeEffectivePatchesForPatchBaselineRequestFilterSensitiveLog = function (obj) { return (__assign({}, obj)); };
export var PatchStatusFilterSensitiveLog = function (obj) { return (__assign({}, obj)); };
export var EffectivePatchFilterSensitiveLog = function (obj) { return (__assign({}, obj)); };
export var DescribeEffectivePatchesForPatchBaselineResultFilterSensitiveLog = function (obj) { return (__assign({}, obj)); };
export var DescribeInstanceAssociationsStatusRequestFilterSensitiveLog = function (obj) { return (__assign({}, obj)); };
export var S3OutputUrlFilterSensitiveLog = function (obj) { return (__assign({}, obj)); };
export var InstanceAssociationOutputUrlFilterSensitiveLog = function (obj) { return (__assign({}, obj)); };
export var InstanceAssociationStatusInfoFilterSensitiveLog = function (obj) { return (__assign({}, obj)); };
export var DescribeInstanceAssociationsStatusResultFilterSensitiveLog = function (obj) { return (__assign({}, obj)); };
export var InstanceInformationStringFilterFilterSensitiveLog = function (obj) { return (__assign({}, obj)); };
export var InstanceInformationFilterFilterSensitiveLog = function (obj) { return (__assign({}, obj)); };
export var DescribeInstanceInformationRequestFilterSensitiveLog = function (obj) { return (__assign({}, obj)); };
export var InstanceAggregatedAssociationOverviewFilterSensitiveLog = function (obj) { return (__assign({}, obj)); };
export var InstanceInformationFilterSensitiveLog = function (obj) { return (__assign({}, obj)); };
export var DescribeInstanceInformationResultFilterSensitiveLog = function (obj) { return (__assign({}, obj)); };
export var DescribeInstancePatchesRequestFilterSensitiveLog = function (obj) { return (__assign({}, obj)); };
export var PatchComplianceDataFilterSensitiveLog = function (obj) { return (__assign({}, obj)); };
export var DescribeInstancePatchesResultFilterSensitiveLog = function (obj) { return (__assign({}, obj)); };
export var DescribeInstancePatchStatesRequestFilterSensitiveLog = function (obj) { return (__assign({}, obj)); };
export var InstancePatchStateFilterSensitiveLog = function (obj) { return (__assign(__assign({}, obj), (obj.OwnerInformation && { OwnerInformation: SENSITIVE_STRING }))); };
export var DescribeInstancePatchStatesResultFilterSensitiveLog = function (obj) { return (__assign(__assign({}, obj), (obj.InstancePatchStates && {
    InstancePatchStates: obj.InstancePatchStates.map(function (item) { return InstancePatchStateFilterSensitiveLog(item); }),
}))); };
export var InstancePatchStateFilterFilterSensitiveLog = function (obj) { return (__assign({}, obj)); };
export var DescribeInstancePatchStatesForPatchGroupRequestFilterSensitiveLog = function (obj) { return (__assign({}, obj)); };
export var DescribeInstancePatchStatesForPatchGroupResultFilterSensitiveLog = function (obj) { return (__assign(__assign({}, obj), (obj.InstancePatchStates && {
    InstancePatchStates: obj.InstancePatchStates.map(function (item) { return InstancePatchStateFilterSensitiveLog(item); }),
}))); };
export var DescribeInventoryDeletionsRequestFilterSensitiveLog = function (obj) { return (__assign({}, obj)); };
export var InventoryDeletionStatusItemFilterSensitiveLog = function (obj) { return (__assign({}, obj)); };
export var DescribeInventoryDeletionsResultFilterSensitiveLog = function (obj) { return (__assign({}, obj)); };
export var MaintenanceWindowFilterFilterSensitiveLog = function (obj) { return (__assign({}, obj)); };
export var DescribeMaintenanceWindowExecutionsRequestFilterSensitiveLog = function (obj) { return (__assign({}, obj)); };
export var MaintenanceWindowExecutionFilterSensitiveLog = function (obj) { return (__assign({}, obj)); };
export var DescribeMaintenanceWindowExecutionsResultFilterSensitiveLog = function (obj) { return (__assign({}, obj)); };
export var DescribeMaintenanceWindowExecutionTaskInvocationsRequestFilterSensitiveLog = function (obj) { return (__assign({}, obj)); };
export var MaintenanceWindowExecutionTaskInvocationIdentityFilterSensitiveLog = function (obj) { return (__assign(__assign(__assign({}, obj), (obj.Parameters && { Parameters: SENSITIVE_STRING })), (obj.OwnerInformation && { OwnerInformation: SENSITIVE_STRING }))); };
export var DescribeMaintenanceWindowExecutionTaskInvocationsResultFilterSensitiveLog = function (obj) { return (__assign(__assign({}, obj), (obj.WindowExecutionTaskInvocationIdentities && {
    WindowExecutionTaskInvocationIdentities: obj.WindowExecutionTaskInvocationIdentities.map(function (item) {
        return MaintenanceWindowExecutionTaskInvocationIdentityFilterSensitiveLog(item);
    }),
}))); };
export var DescribeMaintenanceWindowExecutionTasksRequestFilterSensitiveLog = function (obj) { return (__assign({}, obj)); };
export var MaintenanceWindowExecutionTaskIdentityFilterSensitiveLog = function (obj) { return (__assign({}, obj)); };
export var DescribeMaintenanceWindowExecutionTasksResultFilterSensitiveLog = function (obj) { return (__assign({}, obj)); };
export var DescribeMaintenanceWindowsRequestFilterSensitiveLog = function (obj) { return (__assign({}, obj)); };
export var MaintenanceWindowIdentityFilterSensitiveLog = function (obj) { return (__assign(__assign({}, obj), (obj.Description && { Description: SENSITIVE_STRING }))); };
export var DescribeMaintenanceWindowsResultFilterSensitiveLog = function (obj) { return (__assign(__assign({}, obj), (obj.WindowIdentities && {
    WindowIdentities: obj.WindowIdentities.map(function (item) { return MaintenanceWindowIdentityFilterSensitiveLog(item); }),
}))); };
export var DescribeMaintenanceWindowScheduleRequestFilterSensitiveLog = function (obj) { return (__assign({}, obj)); };
export var ScheduledWindowExecutionFilterSensitiveLog = function (obj) { return (__assign({}, obj)); };
export var DescribeMaintenanceWindowScheduleResultFilterSensitiveLog = function (obj) { return (__assign({}, obj)); };
export var DescribeMaintenanceWindowsForTargetRequestFilterSensitiveLog = function (obj) { return (__assign({}, obj)); };
export var MaintenanceWindowIdentityForTargetFilterSensitiveLog = function (obj) { return (__assign({}, obj)); };
export var DescribeMaintenanceWindowsForTargetResultFilterSensitiveLog = function (obj) { return (__assign({}, obj)); };
export var DescribeMaintenanceWindowTargetsRequestFilterSensitiveLog = function (obj) { return (__assign({}, obj)); };
export var MaintenanceWindowTargetFilterSensitiveLog = function (obj) { return (__assign(__assign(__assign({}, obj), (obj.OwnerInformation && { OwnerInformation: SENSITIVE_STRING })), (obj.Description && { Description: SENSITIVE_STRING }))); };
export var DescribeMaintenanceWindowTargetsResultFilterSensitiveLog = function (obj) { return (__assign(__assign({}, obj), (obj.Targets && { Targets: obj.Targets.map(function (item) { return MaintenanceWindowTargetFilterSensitiveLog(item); }) }))); };
export var DescribeMaintenanceWindowTasksRequestFilterSensitiveLog = function (obj) { return (__assign({}, obj)); };
export var LoggingInfoFilterSensitiveLog = function (obj) { return (__assign({}, obj)); };
export var MaintenanceWindowTaskParameterValueExpressionFilterSensitiveLog = function (obj) { return (__assign(__assign({}, obj), (obj.Values && { Values: SENSITIVE_STRING }))); };
export var MaintenanceWindowTaskFilterSensitiveLog = function (obj) { return (__assign(__assign(__assign({}, obj), (obj.TaskParameters && { TaskParameters: SENSITIVE_STRING })), (obj.Description && { Description: SENSITIVE_STRING }))); };
export var DescribeMaintenanceWindowTasksResultFilterSensitiveLog = function (obj) { return (__assign(__assign({}, obj), (obj.Tasks && { Tasks: obj.Tasks.map(function (item) { return MaintenanceWindowTaskFilterSensitiveLog(item); }) }))); };
export var OpsItemFilterFilterSensitiveLog = function (obj) { return (__assign({}, obj)); };
export var DescribeOpsItemsRequestFilterSensitiveLog = function (obj) { return (__assign({}, obj)); };
export var OpsItemSummaryFilterSensitiveLog = function (obj) { return (__assign({}, obj)); };
export var DescribeOpsItemsResponseFilterSensitiveLog = function (obj) { return (__assign({}, obj)); };
export var ParametersFilterFilterSensitiveLog = function (obj) { return (__assign({}, obj)); };
export var ParameterStringFilterFilterSensitiveLog = function (obj) { return (__assign({}, obj)); };
export var DescribeParametersRequestFilterSensitiveLog = function (obj) { return (__assign({}, obj)); };
export var ParameterInlinePolicyFilterSensitiveLog = function (obj) { return (__assign({}, obj)); };
