import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { StartAutomationExecutionRequestFilterSensitiveLog, StartAutomationExecutionResultFilterSensitiveLog, } from "../models/models_1";
import { deserializeAws_json1_1StartAutomationExecutionCommand, serializeAws_json1_1StartAutomationExecutionCommand, } from "../protocols/Aws_json1_1";
var StartAutomationExecutionCommand = (function (_super) {
    __extends(StartAutomationExecutionCommand, _super);
    function StartAutomationExecutionCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    StartAutomationExecutionCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "SSMClient";
        var commandName = "StartAutomationExecutionCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: StartAutomationExecutionRequestFilterSensitiveLog,
            outputFilterSensitiveLog: StartAutomationExecutionResultFilterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    StartAutomationExecutionCommand.prototype.serialize = function (input, context) {
        return serializeAws_json1_1StartAutomationExecutionCommand(input, context);
    };
    StartAutomationExecutionCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_json1_1StartAutomationExecutionCommand(output, context);
    };
    return StartAutomationExecutionCommand;
}($Command));
export { StartAutomationExecutionCommand };
