import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { DescribeActivationsRequestFilterSensitiveLog, DescribeActivationsResultFilterSensitiveLog, } from "../models/models_0";
import { deserializeAws_json1_1DescribeActivationsCommand, serializeAws_json1_1DescribeActivationsCommand, } from "../protocols/Aws_json1_1";
var DescribeActivationsCommand = (function (_super) {
    __extends(DescribeActivationsCommand, _super);
    function DescribeActivationsCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    DescribeActivationsCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "SSMClient";
        var commandName = "DescribeActivationsCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: DescribeActivationsRequestFilterSensitiveLog,
            outputFilterSensitiveLog: DescribeActivationsResultFilterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    DescribeActivationsCommand.prototype.serialize = function (input, context) {
        return serializeAws_json1_1DescribeActivationsCommand(input, context);
    };
    DescribeActivationsCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_json1_1DescribeActivationsCommand(output, context);
    };
    return DescribeActivationsCommand;
}($Command));
export { DescribeActivationsCommand };
