import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { DeletePatchBaselineRequestFilterSensitiveLog, DeletePatchBaselineResultFilterSensitiveLog, } from "../models/models_0";
import { deserializeAws_json1_1DeletePatchBaselineCommand, serializeAws_json1_1DeletePatchBaselineCommand, } from "../protocols/Aws_json1_1";
var DeletePatchBaselineCommand = (function (_super) {
    __extends(DeletePatchBaselineCommand, _super);
    function DeletePatchBaselineCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    DeletePatchBaselineCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "SSMClient";
        var commandName = "DeletePatchBaselineCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: DeletePatchBaselineRequestFilterSensitiveLog,
            outputFilterSensitiveLog: DeletePatchBaselineResultFilterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    DeletePatchBaselineCommand.prototype.serialize = function (input, context) {
        return serializeAws_json1_1DeletePatchBaselineCommand(input, context);
    };
    DeletePatchBaselineCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_json1_1DeletePatchBaselineCommand(output, context);
    };
    return DeletePatchBaselineCommand;
}($Command));
export { DeletePatchBaselineCommand };
