"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.DescribeInstanceAssociationsStatusCommand = void 0;
const middleware_serde_1 = require("@aws-sdk/middleware-serde");
const smithy_client_1 = require("@aws-sdk/smithy-client");
const models_0_1 = require("../models/models_0");
const Aws_json1_1_1 = require("../protocols/Aws_json1_1");
class DescribeInstanceAssociationsStatusCommand extends smithy_client_1.Command {
    constructor(input) {
        super();
        this.input = input;
    }
    resolveMiddleware(clientStack, configuration, options) {
        this.middlewareStack.use((0, middleware_serde_1.getSerdePlugin)(configuration, this.serialize, this.deserialize));
        const stack = clientStack.concat(this.middlewareStack);
        const { logger } = configuration;
        const clientName = "SSMClient";
        const commandName = "DescribeInstanceAssociationsStatusCommand";
        const handlerExecutionContext = {
            logger,
            clientName,
            commandName,
            inputFilterSensitiveLog: models_0_1.DescribeInstanceAssociationsStatusRequestFilterSensitiveLog,
            outputFilterSensitiveLog: models_0_1.DescribeInstanceAssociationsStatusResultFilterSensitiveLog,
        };
        const { requestHandler } = configuration;
        return stack.resolve((request) => requestHandler.handle(request.request, options || {}), handlerExecutionContext);
    }
    serialize(input, context) {
        return (0, Aws_json1_1_1.serializeAws_json1_1DescribeInstanceAssociationsStatusCommand)(input, context);
    }
    deserialize(output, context) {
        return (0, Aws_json1_1_1.deserializeAws_json1_1DescribeInstanceAssociationsStatusCommand)(output, context);
    }
}
exports.DescribeInstanceAssociationsStatusCommand = DescribeInstanceAssociationsStatusCommand;
