import { __assign, __extends } from "tslib";
import { SENSITIVE_STRING } from "@aws-sdk/smithy-client";
import { SecretsManagerServiceException as __BaseException } from "./SecretsManagerServiceException";
var InternalServiceError = (function (_super) {
    __extends(InternalServiceError, _super);
    function InternalServiceError(opts) {
        var _this = _super.call(this, __assign({ name: "InternalServiceError", $fault: "server" }, opts)) || this;
        _this.name = "InternalServiceError";
        _this.$fault = "server";
        Object.setPrototypeOf(_this, InternalServiceError.prototype);
        _this.Message = opts.Message;
        return _this;
    }
    return InternalServiceError;
}(__BaseException));
export { InternalServiceError };
var InvalidParameterException = (function (_super) {
    __extends(InvalidParameterException, _super);
    function InvalidParameterException(opts) {
        var _this = _super.call(this, __assign({ name: "InvalidParameterException", $fault: "client" }, opts)) || this;
        _this.name = "InvalidParameterException";
        _this.$fault = "client";
        Object.setPrototypeOf(_this, InvalidParameterException.prototype);
        _this.Message = opts.Message;
        return _this;
    }
    return InvalidParameterException;
}(__BaseException));
export { InvalidParameterException };
var InvalidRequestException = (function (_super) {
    __extends(InvalidRequestException, _super);
    function InvalidRequestException(opts) {
        var _this = _super.call(this, __assign({ name: "InvalidRequestException", $fault: "client" }, opts)) || this;
        _this.name = "InvalidRequestException";
        _this.$fault = "client";
        Object.setPrototypeOf(_this, InvalidRequestException.prototype);
        _this.Message = opts.Message;
        return _this;
    }
    return InvalidRequestException;
}(__BaseException));
export { InvalidRequestException };
var ResourceNotFoundException = (function (_super) {
    __extends(ResourceNotFoundException, _super);
    function ResourceNotFoundException(opts) {
        var _this = _super.call(this, __assign({ name: "ResourceNotFoundException", $fault: "client" }, opts)) || this;
        _this.name = "ResourceNotFoundException";
        _this.$fault = "client";
        Object.setPrototypeOf(_this, ResourceNotFoundException.prototype);
        _this.Message = opts.Message;
        return _this;
    }
    return ResourceNotFoundException;
}(__BaseException));
export { ResourceNotFoundException };
export var StatusType;
(function (StatusType) {
    StatusType["Failed"] = "Failed";
    StatusType["InProgress"] = "InProgress";
    StatusType["InSync"] = "InSync";
})(StatusType || (StatusType = {}));
var DecryptionFailure = (function (_super) {
    __extends(DecryptionFailure, _super);
    function DecryptionFailure(opts) {
        var _this = _super.call(this, __assign({ name: "DecryptionFailure", $fault: "client" }, opts)) || this;
        _this.name = "DecryptionFailure";
        _this.$fault = "client";
        Object.setPrototypeOf(_this, DecryptionFailure.prototype);
        _this.Message = opts.Message;
        return _this;
    }
    return DecryptionFailure;
}(__BaseException));
export { DecryptionFailure };
var EncryptionFailure = (function (_super) {
    __extends(EncryptionFailure, _super);
    function EncryptionFailure(opts) {
        var _this = _super.call(this, __assign({ name: "EncryptionFailure", $fault: "client" }, opts)) || this;
        _this.name = "EncryptionFailure";
        _this.$fault = "client";
        Object.setPrototypeOf(_this, EncryptionFailure.prototype);
        _this.Message = opts.Message;
        return _this;
    }
    return EncryptionFailure;
}(__BaseException));
export { EncryptionFailure };
var LimitExceededException = (function (_super) {
    __extends(LimitExceededException, _super);
    function LimitExceededException(opts) {
        var _this = _super.call(this, __assign({ name: "LimitExceededException", $fault: "client" }, opts)) || this;
        _this.name = "LimitExceededException";
        _this.$fault = "client";
        Object.setPrototypeOf(_this, LimitExceededException.prototype);
        _this.Message = opts.Message;
        return _this;
    }
    return LimitExceededException;
}(__BaseException));
export { LimitExceededException };
var MalformedPolicyDocumentException = (function (_super) {
    __extends(MalformedPolicyDocumentException, _super);
    function MalformedPolicyDocumentException(opts) {
        var _this = _super.call(this, __assign({ name: "MalformedPolicyDocumentException", $fault: "client" }, opts)) || this;
        _this.name = "MalformedPolicyDocumentException";
        _this.$fault = "client";
        Object.setPrototypeOf(_this, MalformedPolicyDocumentException.prototype);
        _this.Message = opts.Message;
        return _this;
    }
    return MalformedPolicyDocumentException;
}(__BaseException));
export { MalformedPolicyDocumentException };
var PreconditionNotMetException = (function (_super) {
    __extends(PreconditionNotMetException, _super);
    function PreconditionNotMetException(opts) {
        var _this = _super.call(this, __assign({ name: "PreconditionNotMetException", $fault: "client" }, opts)) || this;
        _this.name = "PreconditionNotMetException";
        _this.$fault = "client";
        Object.setPrototypeOf(_this, PreconditionNotMetException.prototype);
        _this.Message = opts.Message;
        return _this;
    }
    return PreconditionNotMetException;
}(__BaseException));
export { PreconditionNotMetException };
var ResourceExistsException = (function (_super) {
    __extends(ResourceExistsException, _super);
    function ResourceExistsException(opts) {
        var _this = _super.call(this, __assign({ name: "ResourceExistsException", $fault: "client" }, opts)) || this;
        _this.name = "ResourceExistsException";
        _this.$fault = "client";
        Object.setPrototypeOf(_this, ResourceExistsException.prototype);
        _this.Message = opts.Message;
        return _this;
    }
    return ResourceExistsException;
}(__BaseException));
export { ResourceExistsException };
var InvalidNextTokenException = (function (_super) {
    __extends(InvalidNextTokenException, _super);
    function InvalidNextTokenException(opts) {
        var _this = _super.call(this, __assign({ name: "InvalidNextTokenException", $fault: "client" }, opts)) || this;
        _this.name = "InvalidNextTokenException";
        _this.$fault = "client";
        Object.setPrototypeOf(_this, InvalidNextTokenException.prototype);
        _this.Message = opts.Message;
        return _this;
    }
    return InvalidNextTokenException;
}(__BaseException));
export { InvalidNextTokenException };
export var SortOrderType;
(function (SortOrderType) {
    SortOrderType["asc"] = "asc";
    SortOrderType["desc"] = "desc";
})(SortOrderType || (SortOrderType = {}));
var PublicPolicyException = (function (_super) {
    __extends(PublicPolicyException, _super);
    function PublicPolicyException(opts) {
        var _this = _super.call(this, __assign({ name: "PublicPolicyException", $fault: "client" }, opts)) || this;
        _this.name = "PublicPolicyException";
        _this.$fault = "client";
        Object.setPrototypeOf(_this, PublicPolicyException.prototype);
        _this.Message = opts.Message;
        return _this;
    }
    return PublicPolicyException;
}(__BaseException));
export { PublicPolicyException };
export var ReplicaRegionTypeFilterSensitiveLog = function (obj) { return (__assign({}, obj)); };
export var CancelRotateSecretRequestFilterSensitiveLog = function (obj) { return (__assign({}, obj)); };
export var CancelRotateSecretResponseFilterSensitiveLog = function (obj) { return (__assign({}, obj)); };
export var TagFilterSensitiveLog = function (obj) { return (__assign({}, obj)); };
export var CreateSecretRequestFilterSensitiveLog = function (obj) { return (__assign(__assign(__assign({}, obj), (obj.SecretBinary && { SecretBinary: SENSITIVE_STRING })), (obj.SecretString && { SecretString: SENSITIVE_STRING }))); };
export var ReplicationStatusTypeFilterSensitiveLog = function (obj) { return (__assign({}, obj)); };
export var CreateSecretResponseFilterSensitiveLog = function (obj) { return (__assign({}, obj)); };
export var DeleteResourcePolicyRequestFilterSensitiveLog = function (obj) { return (__assign({}, obj)); };
export var DeleteResourcePolicyResponseFilterSensitiveLog = function (obj) { return (__assign({}, obj)); };
export var DeleteSecretRequestFilterSensitiveLog = function (obj) { return (__assign({}, obj)); };
export var DeleteSecretResponseFilterSensitiveLog = function (obj) { return (__assign({}, obj)); };
export var DescribeSecretRequestFilterSensitiveLog = function (obj) { return (__assign({}, obj)); };
export var RotationRulesTypeFilterSensitiveLog = function (obj) { return (__assign({}, obj)); };
export var DescribeSecretResponseFilterSensitiveLog = function (obj) { return (__assign({}, obj)); };
export var FilterFilterSensitiveLog = function (obj) { return (__assign({}, obj)); };
export var GetRandomPasswordRequestFilterSensitiveLog = function (obj) { return (__assign({}, obj)); };
export var GetRandomPasswordResponseFilterSensitiveLog = function (obj) { return (__assign(__assign({}, obj), (obj.RandomPassword && { RandomPassword: SENSITIVE_STRING }))); };
export var GetResourcePolicyRequestFilterSensitiveLog = function (obj) { return (__assign({}, obj)); };
export var GetResourcePolicyResponseFilterSensitiveLog = function (obj) { return (__assign({}, obj)); };
export var GetSecretValueRequestFilterSensitiveLog = function (obj) { return (__assign({}, obj)); };
export var GetSecretValueResponseFilterSensitiveLog = function (obj) { return (__assign(__assign(__assign({}, obj), (obj.SecretBinary && { SecretBinary: SENSITIVE_STRING })), (obj.SecretString && { SecretString: SENSITIVE_STRING }))); };
export var ListSecretsRequestFilterSensitiveLog = function (obj) { return (__assign({}, obj)); };
export var SecretListEntryFilterSensitiveLog = function (obj) { return (__assign({}, obj)); };
export var ListSecretsResponseFilterSensitiveLog = function (obj) { return (__assign({}, obj)); };
export var ListSecretVersionIdsRequestFilterSensitiveLog = function (obj) { return (__assign({}, obj)); };
export var SecretVersionsListEntryFilterSensitiveLog = function (obj) { return (__assign({}, obj)); };
export var ListSecretVersionIdsResponseFilterSensitiveLog = function (obj) { return (__assign({}, obj)); };
export var PutResourcePolicyRequestFilterSensitiveLog = function (obj) { return (__assign({}, obj)); };
export var PutResourcePolicyResponseFilterSensitiveLog = function (obj) { return (__assign({}, obj)); };
export var PutSecretValueRequestFilterSensitiveLog = function (obj) { return (__assign(__assign(__assign({}, obj), (obj.SecretBinary && { SecretBinary: SENSITIVE_STRING })), (obj.SecretString && { SecretString: SENSITIVE_STRING }))); };
export var PutSecretValueResponseFilterSensitiveLog = function (obj) { return (__assign({}, obj)); };
export var RemoveRegionsFromReplicationRequestFilterSensitiveLog = function (obj) { return (__assign({}, obj)); };
export var RemoveRegionsFromReplicationResponseFilterSensitiveLog = function (obj) { return (__assign({}, obj)); };
export var ReplicateSecretToRegionsRequestFilterSensitiveLog = function (obj) { return (__assign({}, obj)); };
export var ReplicateSecretToRegionsResponseFilterSensitiveLog = function (obj) { return (__assign({}, obj)); };
export var RestoreSecretRequestFilterSensitiveLog = function (obj) { return (__assign({}, obj)); };
export var RestoreSecretResponseFilterSensitiveLog = function (obj) { return (__assign({}, obj)); };
export var RotateSecretRequestFilterSensitiveLog = function (obj) { return (__assign({}, obj)); };
export var RotateSecretResponseFilterSensitiveLog = function (obj) { return (__assign({}, obj)); };
export var StopReplicationToReplicaRequestFilterSensitiveLog = function (obj) { return (__assign({}, obj)); };
export var StopReplicationToReplicaResponseFilterSensitiveLog = function (obj) { return (__assign({}, obj)); };
export var TagResourceRequestFilterSensitiveLog = function (obj) { return (__assign({}, obj)); };
export var UntagResourceRequestFilterSensitiveLog = function (obj) { return (__assign({}, obj)); };
export var UpdateSecretRequestFilterSensitiveLog = function (obj) { return (__assign(__assign(__assign({}, obj), (obj.SecretBinary && { SecretBinary: SENSITIVE_STRING })), (obj.SecretString && { SecretString: SENSITIVE_STRING }))); };
export var UpdateSecretResponseFilterSensitiveLog = function (obj) { return (__assign({}, obj)); };
export var UpdateSecretVersionStageRequestFilterSensitiveLog = function (obj) { return (__assign({}, obj)); };
export var UpdateSecretVersionStageResponseFilterSensitiveLog = function (obj) { return (__assign({}, obj)); };
export var ValidateResourcePolicyRequestFilterSensitiveLog = function (obj) { return (__assign({}, obj)); };
export var ValidationErrorsEntryFilterSensitiveLog = function (obj) { return (__assign({}, obj)); };
export var ValidateResourcePolicyResponseFilterSensitiveLog = function (obj) { return (__assign({}, obj)); };
