import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { ValidateResourcePolicyRequestFilterSensitiveLog, ValidateResourcePolicyResponseFilterSensitiveLog, } from "../models/models_0";
import { deserializeAws_json1_1ValidateResourcePolicyCommand, serializeAws_json1_1ValidateResourcePolicyCommand, } from "../protocols/Aws_json1_1";
var ValidateResourcePolicyCommand = (function (_super) {
    __extends(ValidateResourcePolicyCommand, _super);
    function ValidateResourcePolicyCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    ValidateResourcePolicyCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "SecretsManagerClient";
        var commandName = "ValidateResourcePolicyCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: ValidateResourcePolicyRequestFilterSensitiveLog,
            outputFilterSensitiveLog: ValidateResourcePolicyResponseFilterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    ValidateResourcePolicyCommand.prototype.serialize = function (input, context) {
        return serializeAws_json1_1ValidateResourcePolicyCommand(input, context);
    };
    ValidateResourcePolicyCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_json1_1ValidateResourcePolicyCommand(output, context);
    };
    return ValidateResourcePolicyCommand;
}($Command));
export { ValidateResourcePolicyCommand };
