import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { UpdateSecretVersionStageRequestFilterSensitiveLog, UpdateSecretVersionStageResponseFilterSensitiveLog, } from "../models/models_0";
import { deserializeAws_json1_1UpdateSecretVersionStageCommand, serializeAws_json1_1UpdateSecretVersionStageCommand, } from "../protocols/Aws_json1_1";
var UpdateSecretVersionStageCommand = (function (_super) {
    __extends(UpdateSecretVersionStageCommand, _super);
    function UpdateSecretVersionStageCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    UpdateSecretVersionStageCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "SecretsManagerClient";
        var commandName = "UpdateSecretVersionStageCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: UpdateSecretVersionStageRequestFilterSensitiveLog,
            outputFilterSensitiveLog: UpdateSecretVersionStageResponseFilterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    UpdateSecretVersionStageCommand.prototype.serialize = function (input, context) {
        return serializeAws_json1_1UpdateSecretVersionStageCommand(input, context);
    };
    UpdateSecretVersionStageCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_json1_1UpdateSecretVersionStageCommand(output, context);
    };
    return UpdateSecretVersionStageCommand;
}($Command));
export { UpdateSecretVersionStageCommand };
