import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { UpdateSecretRequestFilterSensitiveLog, UpdateSecretResponseFilterSensitiveLog, } from "../models/models_0";
import { deserializeAws_json1_1UpdateSecretCommand, serializeAws_json1_1UpdateSecretCommand, } from "../protocols/Aws_json1_1";
var UpdateSecretCommand = (function (_super) {
    __extends(UpdateSecretCommand, _super);
    function UpdateSecretCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    UpdateSecretCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "SecretsManagerClient";
        var commandName = "UpdateSecretCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: UpdateSecretRequestFilterSensitiveLog,
            outputFilterSensitiveLog: UpdateSecretResponseFilterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    UpdateSecretCommand.prototype.serialize = function (input, context) {
        return serializeAws_json1_1UpdateSecretCommand(input, context);
    };
    UpdateSecretCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_json1_1UpdateSecretCommand(output, context);
    };
    return UpdateSecretCommand;
}($Command));
export { UpdateSecretCommand };
