import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { RotateSecretRequestFilterSensitiveLog, RotateSecretResponseFilterSensitiveLog, } from "../models/models_0";
import { deserializeAws_json1_1RotateSecretCommand, serializeAws_json1_1RotateSecretCommand, } from "../protocols/Aws_json1_1";
var RotateSecretCommand = (function (_super) {
    __extends(RotateSecretCommand, _super);
    function RotateSecretCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    RotateSecretCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "SecretsManagerClient";
        var commandName = "RotateSecretCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: RotateSecretRequestFilterSensitiveLog,
            outputFilterSensitiveLog: RotateSecretResponseFilterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    RotateSecretCommand.prototype.serialize = function (input, context) {
        return serializeAws_json1_1RotateSecretCommand(input, context);
    };
    RotateSecretCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_json1_1RotateSecretCommand(output, context);
    };
    return RotateSecretCommand;
}($Command));
export { RotateSecretCommand };
