import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { RestoreSecretRequestFilterSensitiveLog, RestoreSecretResponseFilterSensitiveLog, } from "../models/models_0";
import { deserializeAws_json1_1RestoreSecretCommand, serializeAws_json1_1RestoreSecretCommand, } from "../protocols/Aws_json1_1";
var RestoreSecretCommand = (function (_super) {
    __extends(RestoreSecretCommand, _super);
    function RestoreSecretCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    RestoreSecretCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "SecretsManagerClient";
        var commandName = "RestoreSecretCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: RestoreSecretRequestFilterSensitiveLog,
            outputFilterSensitiveLog: RestoreSecretResponseFilterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    RestoreSecretCommand.prototype.serialize = function (input, context) {
        return serializeAws_json1_1RestoreSecretCommand(input, context);
    };
    RestoreSecretCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_json1_1RestoreSecretCommand(output, context);
    };
    return RestoreSecretCommand;
}($Command));
export { RestoreSecretCommand };
