import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { PutSecretValueRequestFilterSensitiveLog, PutSecretValueResponseFilterSensitiveLog, } from "../models/models_0";
import { deserializeAws_json1_1PutSecretValueCommand, serializeAws_json1_1PutSecretValueCommand, } from "../protocols/Aws_json1_1";
var PutSecretValueCommand = (function (_super) {
    __extends(PutSecretValueCommand, _super);
    function PutSecretValueCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    PutSecretValueCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "SecretsManagerClient";
        var commandName = "PutSecretValueCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: PutSecretValueRequestFilterSensitiveLog,
            outputFilterSensitiveLog: PutSecretValueResponseFilterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    PutSecretValueCommand.prototype.serialize = function (input, context) {
        return serializeAws_json1_1PutSecretValueCommand(input, context);
    };
    PutSecretValueCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_json1_1PutSecretValueCommand(output, context);
    };
    return PutSecretValueCommand;
}($Command));
export { PutSecretValueCommand };
