import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { ListSecretsRequestFilterSensitiveLog, ListSecretsResponseFilterSensitiveLog, } from "../models/models_0";
import { deserializeAws_json1_1ListSecretsCommand, serializeAws_json1_1ListSecretsCommand, } from "../protocols/Aws_json1_1";
var ListSecretsCommand = (function (_super) {
    __extends(ListSecretsCommand, _super);
    function ListSecretsCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    ListSecretsCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "SecretsManagerClient";
        var commandName = "ListSecretsCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: ListSecretsRequestFilterSensitiveLog,
            outputFilterSensitiveLog: ListSecretsResponseFilterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    ListSecretsCommand.prototype.serialize = function (input, context) {
        return serializeAws_json1_1ListSecretsCommand(input, context);
    };
    ListSecretsCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_json1_1ListSecretsCommand(output, context);
    };
    return ListSecretsCommand;
}($Command));
export { ListSecretsCommand };
