import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { ListSecretVersionIdsRequestFilterSensitiveLog, ListSecretVersionIdsResponseFilterSensitiveLog, } from "../models/models_0";
import { deserializeAws_json1_1ListSecretVersionIdsCommand, serializeAws_json1_1ListSecretVersionIdsCommand, } from "../protocols/Aws_json1_1";
var ListSecretVersionIdsCommand = (function (_super) {
    __extends(ListSecretVersionIdsCommand, _super);
    function ListSecretVersionIdsCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    ListSecretVersionIdsCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "SecretsManagerClient";
        var commandName = "ListSecretVersionIdsCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: ListSecretVersionIdsRequestFilterSensitiveLog,
            outputFilterSensitiveLog: ListSecretVersionIdsResponseFilterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    ListSecretVersionIdsCommand.prototype.serialize = function (input, context) {
        return serializeAws_json1_1ListSecretVersionIdsCommand(input, context);
    };
    ListSecretVersionIdsCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_json1_1ListSecretVersionIdsCommand(output, context);
    };
    return ListSecretVersionIdsCommand;
}($Command));
export { ListSecretVersionIdsCommand };
