import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { GetRandomPasswordRequestFilterSensitiveLog, GetRandomPasswordResponseFilterSensitiveLog, } from "../models/models_0";
import { deserializeAws_json1_1GetRandomPasswordCommand, serializeAws_json1_1GetRandomPasswordCommand, } from "../protocols/Aws_json1_1";
var GetRandomPasswordCommand = (function (_super) {
    __extends(GetRandomPasswordCommand, _super);
    function GetRandomPasswordCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    GetRandomPasswordCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "SecretsManagerClient";
        var commandName = "GetRandomPasswordCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: GetRandomPasswordRequestFilterSensitiveLog,
            outputFilterSensitiveLog: GetRandomPasswordResponseFilterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    GetRandomPasswordCommand.prototype.serialize = function (input, context) {
        return serializeAws_json1_1GetRandomPasswordCommand(input, context);
    };
    GetRandomPasswordCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_json1_1GetRandomPasswordCommand(output, context);
    };
    return GetRandomPasswordCommand;
}($Command));
export { GetRandomPasswordCommand };
