import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { DescribeSecretRequestFilterSensitiveLog, DescribeSecretResponseFilterSensitiveLog, } from "../models/models_0";
import { deserializeAws_json1_1DescribeSecretCommand, serializeAws_json1_1DescribeSecretCommand, } from "../protocols/Aws_json1_1";
var DescribeSecretCommand = (function (_super) {
    __extends(DescribeSecretCommand, _super);
    function DescribeSecretCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    DescribeSecretCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "SecretsManagerClient";
        var commandName = "DescribeSecretCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: DescribeSecretRequestFilterSensitiveLog,
            outputFilterSensitiveLog: DescribeSecretResponseFilterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    DescribeSecretCommand.prototype.serialize = function (input, context) {
        return serializeAws_json1_1DescribeSecretCommand(input, context);
    };
    DescribeSecretCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_json1_1DescribeSecretCommand(output, context);
    };
    return DescribeSecretCommand;
}($Command));
export { DescribeSecretCommand };
