import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { CancelRotateSecretRequestFilterSensitiveLog, CancelRotateSecretResponseFilterSensitiveLog, } from "../models/models_0";
import { deserializeAws_json1_1CancelRotateSecretCommand, serializeAws_json1_1CancelRotateSecretCommand, } from "../protocols/Aws_json1_1";
var CancelRotateSecretCommand = (function (_super) {
    __extends(CancelRotateSecretCommand, _super);
    function CancelRotateSecretCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    CancelRotateSecretCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "SecretsManagerClient";
        var commandName = "CancelRotateSecretCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: CancelRotateSecretRequestFilterSensitiveLog,
            outputFilterSensitiveLog: CancelRotateSecretResponseFilterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    CancelRotateSecretCommand.prototype.serialize = function (input, context) {
        return serializeAws_json1_1CancelRotateSecretCommand(input, context);
    };
    CancelRotateSecretCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_json1_1CancelRotateSecretCommand(output, context);
    };
    return CancelRotateSecretCommand;
}($Command));
export { CancelRotateSecretCommand };
