# project-release
> A tool to help releasing projects.

## Installation

With `pip`:
```sh
pip install project-release
```

## Usage

 - Inside your project, create a file `.project-release-config.yaml`
 - A very basic configuration can be generated with `project-release sample-config`
 - All other options are documented [below](#configuration)
 - Once configured, a project can be released by executing `project-release`

## Configuration

The file `.project-release-config.yaml` is used for the configuration.

### Conventions

The project can indicate that it follows certain conventions.

#### Version format

The version string can be limited to some standards:
 - `semver`
   Semantic Versioning: https://semver.org
 - `pep440`
   PEP 440: https://peps.python.org/pep-0440

```yaml
convention:
  version: semver
```

When not defined, the user-specified version string is unrestricted.

### File update

The project can indicate that some files need to be updated.

#### Version file

The version files can be updated in many different ways.

 - If it contains only the version string the configuration will look like:
   ```yaml
   file:
     version: VERSION
   ```
 - If something more complex is needed, it can be formatted. The current
   version string is available with the format specifier `%(version)s` :
   ```yaml
   file:
     version:
       path: VERSION
       format: 'version %(version)s'
   ```
 - The multi-line YAML format can also be used:
   ```yaml
   file:
     version:
       path: VERSION
       format: |
         # Autogenerated version file
         VERSION="%(version)s"
   ```
 - If the file is to be updated only, a pattern can be used. All matches will
   be replaced by the new version string:
   ```yaml
   file:
     version:
       path: VERSION
       pattern: '(?<=version ).*'
   ```
 - Finally multiple version files can be configured:
   ```yaml
   file:
     version:
       - version.plain
       - path: version.formatted
         format: 'version %(version)s'
       - path: version.updated
         pattern: '(?<=version ).*'
   ```

### Git branches

The `development` branch and `release` branch can be configured, so that commit
from the `development` branch are merged in the `release` branch prior to create
the release.

```yaml
git:
  branch:
    development: 'main'
    release: 'release'
```

The definition of these branches are optional. If both are omitted, the current
branch is used for the release and no merge are done. If only one is omitted,
the user will be asked to specify the missing one. Specifying a non-existent
branch will create it.

Branch pattern can be configured using the wildcards `*` and `?`. In this case
the user will be asked to specify the branch. The specified branch must match
the pattern.

```yaml
git:
  branch:
    development: 'main'
    release: 'stable-*'
```

The branches can be configured with a list a names and patterns.

```yaml
git:
  branch:
    development: 'main'
    release:
      - 'release'
      - 'stable-*'
```

### Git commit

After the merge. If some file as been updated using the `file` keyword,
a commit will be created on the `release` branch.
Some basic things can be configured:

```yaml
git:
  commit:
    message: 'bump: version %(version)s'
    sign-off: true
    gpg-sign: true
```

### Git tag

After the merge and the commit, a tag is created on the `release` branch.
Some basic things can be configured:

```yaml
git:
  tag:
    format: 'v%(version)s'
    message: 'version %(version)s'
    annotate: true
    gpg-sign: true
```

## Advanced option

### Status

At any time, the `project-release --status` command can be used to get an
overview of the current status of the release process.

### Custom commit

After the merge, if a custom commit is needed before the bump commit, the
`project-release --edit` command can be used. The procedure will stop to let
the user perform the custom commit. Use the `project-release --continue`
command to terminate the procedure.

### Merge conflicts

If the git merge is not successful, the initial `project-release` command will
stop, asking the user to resolve any conflicts.

Once the work is done (committed or staged), the `project-release --continue`
command can be used to continue the release process.

At any time, the `project-release --abort` command can be used to interrupt
the release process.
