#!/usr/bin/env python

# This script runs through all of the param files generated by mkparam
# and runs Bbarolo with both varying and fixed VDISP.
# Galaxies which fail are listed in nrad8_fail1.txt and nrad8_vdisp8_fail1.txt

import os
import glob
import subprocess
import shutil

os.system('/Users/tonywong/Work/bin/bbarolo/BBarolo -v')

tout = 180
masks = ['dilmsk']
fits  = ['fitvd', 'fixvd']
sets  = ['natv', 'smo7']
runs = []
for set in sets:
    for fit in fits:
        for mask in masks:
            runs.append(set+'_'+fit+'_'+mask)
print(runs)

for run in runs:
    noPlot_txt = open(run+'_fail1.txt','w')
    noPlot=[]
    os.chdir(run)
    plist = glob.glob('param_*.par')
    for pfile in plist:
        gal = pfile.strip('param_.par')
        print(gal)
        if os.path.isdir('output/'+gal[:8]):
            shutil.rmtree('output/'+gal[:8])
        os.makedirs('output/'+gal[:8])
        with open('output/'+gal[:8]+'/'+gal+'.bblog.txt', "wb") as outfile:
            try:
                subprocess.run(['/Users/tonywong/Work/bin/bbarolo/BBarolo','-p',pfile], 
                            timeout=tout, stdout=outfile, stderr=outfile)
            except subprocess.TimeoutExpired:
                print('Timeout after {} seconds'.format(tout))
        plot_paths=['_pv_local.pdf','_parameters.pdf','_maps_local.pdf','_chanmaps_local.pdf']
        for plot_path in plot_paths:
            if not os.path.isfile('output/'+gal[:8]+'/'+gal[:8]+plot_path):
                noPlot.append(gal)
                print(gal+' in '+ run + ' is missing plots')
                break
    os.chdir('..')
    for obj in noPlot:
        noPlot_txt.write(obj+'\n')
    noPlot_txt.close()
    print (run+' Done')

