define(["exports"],(function(_exports){"use strict";function parentWithAttribute(elem,name,value){for(;value?elem.getAttribute(name)!==value:!elem.getAttribute(name);)if(!(elem=elem.parentNode)||!elem.getAttribute)return null;return elem}function parentWithTag(elem,tagNames){for(Array.isArray(tagNames)||(tagNames=[tagNames]);-1===tagNames.indexOf(elem.tagName||"");)if(!(elem=elem.parentNode))return null;return elem}function containsAnyClass(classList,classNames){for(var i=0,length=classNames.length;i<length;i++)if(classList.contains(classNames[i]))return!0;return!1}function parentWithClass(elem,classNames){for(Array.isArray(classNames)||(classNames=[classNames]);!elem.classList||!containsAnyClass(elem.classList,classNames);)if(!(elem=elem.parentNode))return null;return elem}Object.defineProperty(_exports,"__esModule",{value:!0}),_exports.parentWithAttribute=parentWithAttribute,_exports.parentWithTag=parentWithTag,_exports.parentWithClass=parentWithClass,_exports.addEventListener=addEventListener,_exports.removeEventListener=removeEventListener,_exports.getWindowSize=getWindowSize,_exports.getScreenWidth=getScreenWidth,_exports.whichAnimationEvent=whichAnimationEvent,_exports.whichAnimationCancelEvent=whichAnimationCancelEvent,_exports.whichTransitionEvent=whichTransitionEvent,_exports.default=void 0;var windowSize,windowSizeEventsBound,supportsCaptureOption=!1;try{var opts=Object.defineProperty({},"capture",{get:function get(){supportsCaptureOption=!0}});window.addEventListener("test",null,opts)}catch(e){console.debug("error checking capture support")}function addEventListener(target,type,handler,options){var optionsOrCapture=options||{};supportsCaptureOption||(optionsOrCapture=optionsOrCapture.capture),target.addEventListener(type,handler,optionsOrCapture)}function removeEventListener(target,type,handler,options){var optionsOrCapture=options||{};supportsCaptureOption||(optionsOrCapture=optionsOrCapture.capture),target.removeEventListener(type,handler,optionsOrCapture)}function clearWindowSize(){windowSize=null}function getWindowSize(){return windowSize||(windowSize={innerHeight:window.innerHeight,innerWidth:window.innerWidth},windowSizeEventsBound||(windowSizeEventsBound=!0,addEventListener(window,"orientationchange",clearWindowSize,{passive:!0}),addEventListener(window,"resize",clearWindowSize,{passive:!0}))),windowSize}var _animationEvent,_transitionEvent,standardWidths=[480,720,1280,1440,1920,2560,3840,5120,7680];function getScreenWidth(){var width=window.innerWidth,height=window.innerHeight;return height>width&&(width=height*(16/9)),standardWidths.sort((function(a,b){return Math.abs(width-a)-Math.abs(width-b)}))[0]}function whichAnimationEvent(){if(_animationEvent)return _animationEvent;var el=document.createElement("div"),animations={animation:"animationend",OAnimation:"oAnimationEnd",MozAnimation:"animationend",WebkitAnimation:"webkitAnimationEnd"};for(var t in animations)if(void 0!==el.style[t])return _animationEvent=animations[t],animations[t];return _animationEvent="animationend"}function whichAnimationCancelEvent(){return whichAnimationEvent().replace("animationend","animationcancel").replace("AnimationEnd","AnimationCancel")}function whichTransitionEvent(){if(_transitionEvent)return _transitionEvent;var el=document.createElement("div"),transitions={transition:"transitionend",OTransition:"oTransitionEnd",MozTransition:"transitionend",WebkitTransition:"webkitTransitionEnd"};for(var t in transitions)if(void 0!==el.style[t])return _transitionEvent=transitions[t],transitions[t];return _transitionEvent="transitionend"}var _default={parentWithAttribute:parentWithAttribute,parentWithClass:parentWithClass,parentWithTag:parentWithTag,addEventListener:addEventListener,removeEventListener:removeEventListener,getWindowSize:getWindowSize,getScreenWidth:getScreenWidth,whichTransitionEvent:whichTransitionEvent,whichAnimationEvent:whichAnimationEvent,whichAnimationCancelEvent:whichAnimationCancelEvent};_exports.default=_default}));
//# sourceMappingURL=dom.js.map
