"use strict";define(["apphost","appSettings","dom","connectionManager","loading","layoutManager","browser","globalize","cardStyle","emby-checkbox"],(function(appHost,appSettings,dom,connectionManager,loading,layoutManager,browser,globalize){var enableFocusTransform=!browser.slow&&!browser.edge;function authenticateUserByName(page,apiClient,username,password){loading.show(),apiClient.authenticateUserByName(username,password).then((function(result){var user=result.User;loading.hide(),Dashboard.onServerChanged(user.Id,result.AccessToken,apiClient),Dashboard.navigate("home.html")}),(function(response){page.querySelector("#txtManualName").value="",page.querySelector("#txtManualPassword").value="",loading.hide();[401,403].includes(response.status)?require(["toast"],(function(toast){var messageKey=401===response.status?"MessageInvalidUser":"MessageUnauthorizedUser";toast(globalize.translate(messageKey))})):Dashboard.alert({message:globalize.translate("MessageUnableToConnectToServer"),title:globalize.translate("HeaderConnectionFailure")})}))}function showManualForm(context,showCancel,focusPassword){context.querySelector(".chkRememberLogin").checked=appSettings.enableAutoLogin(),context.querySelector(".manualLoginForm").classList.remove("hide"),context.querySelector(".visualLoginForm").classList.add("hide"),context.querySelector(".btnManual").classList.add("hide"),focusPassword?context.querySelector("#txtManualPassword").focus():context.querySelector("#txtManualName").focus(),showCancel?context.querySelector(".btnCancel").classList.remove("hide"):context.querySelector(".btnCancel").classList.add("hide")}var metroColors=["#6FBD45","#4BB3DD","#4164A5","#E12026","#800080","#E1B222","#008040","#0094FF","#FF00C7","#FF870F","#7F0037"];function getMetroColor(str){if(str){for(var character=String(str.substr(0,1).charCodeAt()),sum=0,i=0;i<character.length;i++)sum+=parseInt(character.charAt(i));var index=String(sum).substr(-1);return metroColors[index]}return function getRandomMetroColor(){var index=Math.floor(Math.random()*(metroColors.length-1));return metroColors[index]}()}return function(view,params){function getApiClient(){var serverId=params.serverid;return serverId?connectionManager.getOrCreateApiClient(serverId):ApiClient}function showVisualForm(){view.querySelector(".visualLoginForm").classList.remove("hide"),view.querySelector(".manualLoginForm").classList.add("hide"),view.querySelector(".btnManual").classList.remove("hide"),require(["autoFocuser"],(function(autoFocuser){autoFocuser.autoFocus(view)}))}view.querySelector("#divUsers").addEventListener("click",(function(e){var card=dom.parentWithClass(e.target,"card"),cardContent=card?card.querySelector(".cardContent"):null;if(cardContent){var context=view,id=cardContent.getAttribute("data-userid"),name=cardContent.getAttribute("data-username"),haspw=cardContent.getAttribute("data-haspw");"manual"===id?(context.querySelector("#txtManualName").value="",showManualForm(context,!0)):"false"==haspw?authenticateUserByName(context,getApiClient(),name,""):(context.querySelector("#txtManualName").value=name,context.querySelector("#txtManualPassword").value="",showManualForm(context,!0,!0))}})),view.querySelector(".manualLoginForm").addEventListener("submit",(function(e){appSettings.enableAutoLogin(view.querySelector(".chkRememberLogin").checked);var apiClient=getApiClient();return authenticateUserByName(view,apiClient,view.querySelector("#txtManualName").value,view.querySelector("#txtManualPassword").value),e.preventDefault(),!1})),view.querySelector(".btnForgotPassword").addEventListener("click",(function(){Dashboard.navigate("forgotpassword.html")})),view.querySelector(".btnCancel").addEventListener("click",showVisualForm),view.querySelector(".btnManual").addEventListener("click",(function(){view.querySelector("#txtManualName").value="",showManualForm(view,!0)})),view.querySelector(".btnSelectServer").addEventListener("click",(function(){Dashboard.selectServer()})),view.addEventListener("viewshow",(function(e){loading.show(),appHost.supports("multiserver")||view.querySelector(".btnSelectServer").classList.add("hide");var apiClient=getApiClient();apiClient.getPublicUsers().then((function(users){users.length?(showVisualForm(),function loadUserList(context,apiClient,users){for(var html="",i=0;i<users.length;i++){var user=users[i],cssClass="card squareCard scalableCard squareCard-scalable";layoutManager.tv&&(cssClass+=" show-focus",enableFocusTransform&&(cssClass+=" show-animation"));if(html+='<button type="button" class="'+cssClass+'">',html+='<div class="cardBox cardBox-bottompadded">',html+='<div class="cardScalable">',html+='<div class="cardPadder cardPadder-square"></div>',html+='<div class="cardContent" data-haspw="'+user.HasPassword+'" data-username="'+user.Name+'" data-userid="'+user.Id+'">',user.PrimaryImageTag)html+='<div class="cardImageContainer coveredImage coveredImage-noScale" style="background-image:url(\''+apiClient.getUserImageUrl(user.Id,{width:300,tag:user.PrimaryImageTag,type:"Primary"})+"');\"></div>";else html+='<div class="cardImageContainer coveredImage coveredImage-noScale" style="background-image:url(\''+"assets/img/avatar.png"+"');background-color:"+getMetroColor(user.Id)+';"></div>';html+="</div>",html+="</div>",html+='<div class="cardFooter visualCardBox-cardFooter">',html+='<div class="cardText singleCardText cardTextCentered">'+user.Name+"</div>",html+="</div>",html+="</div>",html+="</button>"}context.querySelector("#divUsers").innerHTML=html}(view,apiClient,users)):(view.querySelector("#txtManualName").value="",showManualForm(view,!1,!1))})).catch().then((function(){loading.hide()})),apiClient.getJSON(apiClient.getUrl("Branding/Configuration")).then((function(options){view.querySelector(".disclaimer").textContent=options.LoginDisclaimer||""}))}))}}));
//# sourceMappingURL=login.js.map
