define(["exports","events","connectionManager"],(function(_exports,_events,_connectionManager){"use strict";function _interopRequireDefault(obj){return obj&&obj.__esModule?obj:{default:obj}}function _classCallCheck(instance,Constructor){if(!(instance instanceof Constructor))throw new TypeError("Cannot call a class as a function")}function _defineProperties(target,props){for(var i=0;i<props.length;i++){var descriptor=props[i];descriptor.enumerable=descriptor.enumerable||!1,descriptor.configurable=!0,"value"in descriptor&&(descriptor.writable=!0),Object.defineProperty(target,descriptor.key,descriptor)}}function _createClass(Constructor,protoProps,staticProps){return protoProps&&_defineProperties(Constructor.prototype,protoProps),staticProps&&_defineProperties(Constructor,staticProps),Constructor}Object.defineProperty(_exports,"__esModule",{value:!0}),_exports.default=void 0,_events=_interopRequireDefault(_events),_connectionManager=_interopRequireDefault(_connectionManager);var Measurement=function(){function Measurement(requestSent,requestReceived,responseSent,responseReceived){_classCallCheck(this,Measurement),this.requestSent=requestSent.getTime(),this.requestReceived=requestReceived.getTime(),this.responseSent=responseSent.getTime(),this.responseReceived=responseReceived.getTime()}return _createClass(Measurement,[{key:"getOffset",value:function getOffset(){return(this.requestReceived-this.requestSent+(this.responseSent-this.responseReceived))/2}},{key:"getDelay",value:function getDelay(){return this.responseReceived-this.requestSent-(this.responseSent-this.requestReceived)}},{key:"getPing",value:function getPing(){return this.getDelay()/2}}]),Measurement}(),_default=new(function(){function TimeSyncManager(){_classCallCheck(this,TimeSyncManager),this.pingStop=!0,this.pollingInterval=1e3,this.poller=null,this.pings=0,this.measurement=null,this.measurements=[]}return _createClass(TimeSyncManager,[{key:"isReady",value:function isReady(){return!!this.measurement}},{key:"getTimeOffset",value:function getTimeOffset(){return this.measurement?this.measurement.getOffset():0}},{key:"getPing",value:function getPing(){return this.measurement?this.measurement.getPing():0}},{key:"updateTimeOffset",value:function updateTimeOffset(measurement){this.measurements.push(measurement),this.measurements.length>8&&this.measurements.shift();var sortedMeasurements=this.measurements.slice(0);sortedMeasurements.sort((function(a,b){return a.getDelay()-b.getDelay()})),this.measurement=sortedMeasurements[0]}},{key:"requestPing",value:function requestPing(){var _this=this;this.poller||(this.poller=setTimeout((function(){_this.poller=null;var apiClient=_connectionManager.default.currentApiClient(),requestSent=new Date;apiClient.getServerTime().then((function(response){var responseReceived=new Date;response.json().then((function(data){var requestReceived=new Date(data.RequestReceptionTime),responseSent=new Date(data.ResponseTransmissionTime),measurement=new Measurement(requestSent,requestReceived,responseSent,responseReceived);_this.updateTimeOffset(measurement),_this.pings>=3?_this.pollingInterval=6e4:_this.pings++,_events.default.trigger(_this,"update",[null,_this.getTimeOffset(),_this.getPing()])}))})).catch((function(error){console.error(error),_events.default.trigger(_this,"update",[error,null,null])})).finally((function(){_this.requestPing()}))}),this.pollingInterval))}},{key:"resetMeasurements",value:function resetMeasurements(){this.measurement=null,this.measurements=[]}},{key:"startPing",value:function startPing(){this.requestPing()}},{key:"stopPing",value:function stopPing(){this.poller&&(clearTimeout(this.poller),this.poller=null)}},{key:"forceUpdate",value:function forceUpdate(){this.stopPing(),this.pollingInterval=1e3,this.pings=0,this.startPing()}},{key:"serverDateToLocal",value:function serverDateToLocal(server){return new Date(server.getTime()-this.getTimeOffset())}},{key:"localDateToServer",value:function localDateToServer(local){return new Date(local.getTime()+this.getTimeOffset())}}]),TimeSyncManager}());_exports.default=_default}));
//# sourceMappingURL=timeSyncManager.js.map
