"use strict";define(["require","datetime","itemHelper","events","browser","imageLoader","layoutManager","playbackManager","nowPlayingHelper","apphost","dom","connectionManager","itemContextMenu","paper-icon-button-light","emby-ratingbutton"],(function(require,datetime,itemHelper,events,browser,imageLoader,layoutManager,playbackManager,nowPlayingHelper,appHost,dom,connectionManager,itemContextMenu){var currentPlayer,currentTimeElement,nowPlayingImageElement,nowPlayingTextElement,nowPlayingUserData,muteButton,volumeSlider,volumeSliderContainer,playPauseButtons,positionSlider,toggleRepeatButton,toggleRepeatButtonIcon,isEnabled,nowPlayingBarElement,currentImgUrl,currentPlayerSupportedCommands=[],lastUpdateTime=0,lastPlayerState={},currentRuntimeTicks=0,isVisibilityAllowed=!0;function onSlideDownComplete(){this.classList.add("hide")}function slideUp(elem){dom.removeEventListener(elem,dom.whichTransitionEvent(),onSlideDownComplete,{once:!0}),elem.classList.remove("hide"),elem.offsetWidth,elem.classList.remove("nowPlayingBar-hidden")}function onPlayPauseClick(){playbackManager.playPause(currentPlayer)}function bindEvents(elem){currentTimeElement=elem.querySelector(".nowPlayingBarCurrentTime"),nowPlayingImageElement=elem.querySelector(".nowPlayingImage"),nowPlayingTextElement=elem.querySelector(".nowPlayingBarText"),nowPlayingUserData=elem.querySelector(".nowPlayingBarUserDataButtons"),positionSlider=elem.querySelector(".nowPlayingBarPositionSlider"),muteButton=elem.querySelector(".muteButton"),playPauseButtons=elem.querySelectorAll(".playPauseButton"),toggleRepeatButton=elem.querySelector(".toggleRepeatButton"),volumeSlider=elem.querySelector(".nowPlayingBarVolumeSlider"),volumeSliderContainer=elem.querySelector(".nowPlayingBarVolumeSliderContainer"),muteButton.addEventListener("click",(function(){currentPlayer&&playbackManager.toggleMute(currentPlayer)})),elem.querySelector(".stopButton").addEventListener("click",(function(){currentPlayer&&playbackManager.stop(currentPlayer)})),playPauseButtons.forEach((function(button){button.addEventListener("click",onPlayPauseClick)})),elem.querySelector(".nextTrackButton").addEventListener("click",(function(){currentPlayer&&playbackManager.nextTrack(currentPlayer)})),elem.querySelector(".previousTrackButton").addEventListener("click",(function(e){if(currentPlayer)if("Audio"===lastPlayerState.NowPlayingItem.MediaType&&(currentPlayer._currentTime>=5||!playbackManager.previousTrack(currentPlayer))){if(e.detail>1&&playbackManager.previousTrack(currentPlayer))return;playbackManager.seekPercent(0,currentPlayer),positionSlider.value=0}else playbackManager.previousTrack(currentPlayer)})),elem.querySelector(".previousTrackButton").addEventListener("dblclick",(function(){currentPlayer&&playbackManager.previousTrack(currentPlayer)})),elem.querySelector(".btnShuffleQueue").addEventListener("click",(function(){currentPlayer&&playbackManager.toggleQueueShuffleMode()})),(toggleRepeatButton=elem.querySelector(".toggleRepeatButton")).addEventListener("click",(function(){switch(playbackManager.getRepeatMode()){case"RepeatAll":playbackManager.setRepeatMode("RepeatOne");break;case"RepeatOne":playbackManager.setRepeatMode("RepeatNone");break;case"RepeatNone":playbackManager.setRepeatMode("RepeatAll")}})),toggleRepeatButtonIcon=toggleRepeatButton.querySelector(".material-icons"),volumeSliderContainer.classList.toggle("hide",appHost.supports("physicalvolumecontrol")),volumeSlider.addEventListener("input",(function(e){currentPlayer&&currentPlayer.setVolume(e.target.value)})),positionSlider.addEventListener("change",(function(){if(currentPlayer){var newPercent=parseFloat(this.value);playbackManager.seekPercent(newPercent,currentPlayer)}})),positionSlider.getBubbleText=function(value){if(!lastPlayerState||!lastPlayerState.NowPlayingItem||!currentRuntimeTicks)return"--:--";var ticks=currentRuntimeTicks;return ticks/=100,ticks*=value,datetime.getDisplayRunningTime(ticks)},elem.addEventListener("click",(function(e){dom.parentWithTag(e.target,["BUTTON","INPUT"])||function showRemoteControl(){require(["appRouter"],(function(appRouter){appRouter.showNowPlaying()}))}()}))}function getNowPlayingBar(){return nowPlayingBarElement?Promise.resolve(nowPlayingBarElement):new Promise((function(resolve,reject){require(["appFooter-shared","itemShortcuts","css!./nowPlayingBar.css","emby-slider"],(function(appfooter,itemShortcuts){var parentContainer=appfooter.element;(nowPlayingBarElement=parentContainer.querySelector(".nowPlayingBar"))||(parentContainer.insertAdjacentHTML("afterbegin",function getNowPlayingBarHtml(){var html="";return html+='<div class="nowPlayingBar hide nowPlayingBar-hidden">',html+='<div class="nowPlayingBarTop">',html+='<div class="nowPlayingBarPositionContainer sliderContainer">',html+='<input type="range" is="emby-slider" pin step=".01" min="0" max="100" value="0" class="slider-medium-thumb nowPlayingBarPositionSlider" data-slider-keep-progress="true"/>',html+="</div>",html+='<div class="nowPlayingBarInfoContainer">',html+='<div class="nowPlayingImage"></div>',html+='<div class="nowPlayingBarText"></div>',html+="</div>",html+='<div class="nowPlayingBarCenter">',html+='<button is="paper-icon-button-light" class="previousTrackButton mediaButton"><span class="material-icons skip_previous"></span></button>',html+='<button is="paper-icon-button-light" class="playPauseButton mediaButton"><span class="material-icons pause"></span></button>',html+='<button is="paper-icon-button-light" class="stopButton mediaButton"><span class="material-icons stop"></span></button>',layoutManager.mobile||(html+='<button is="paper-icon-button-light" class="nextTrackButton mediaButton"><span class="material-icons skip_next"></span></button>'),html+='<div class="nowPlayingBarCurrentTime"></div>',html+="</div>",html+='<div class="nowPlayingBarRight">',html+='<button is="paper-icon-button-light" class="muteButton mediaButton"><span class="material-icons volume_up"></span></button>',html+='<div class="sliderContainer nowPlayingBarVolumeSliderContainer hide" style="width:9em;vertical-align:middle;display:inline-flex;">',html+='<input type="range" is="emby-slider" pin step="1" min="0" max="100" value="0" class="slider-medium-thumb nowPlayingBarVolumeSlider"/>',html+="</div>",html+='<button is="paper-icon-button-light" class="toggleRepeatButton mediaButton"><span class="material-icons repeat"></span></button>',html+='<button is="paper-icon-button-light" class="btnShuffleQueue mediaButton"><span class="material-icons shuffle"></span></button>',html+='<div class="nowPlayingBarUserDataButtons">',html+="</div>",html+='<button is="paper-icon-button-light" class="playPauseButton mediaButton"><span class="material-icons pause"></span></button>',layoutManager.mobile?html+='<button is="paper-icon-button-light" class="nextTrackButton mediaButton"><span class="material-icons skip_next"></span></button>':html+='<button is="paper-icon-button-light" class="btnToggleContextMenu mediaButton"><span class="material-icons more_vert"></span></button>',html+="</div>",html+="</div>",html+="</div>"}()),nowPlayingBarElement=parentContainer.querySelector(".nowPlayingBar"),layoutManager.mobile&&(hideButton(nowPlayingBarElement.querySelector(".btnShuffleQueue")),hideButton(nowPlayingBarElement.querySelector(".nowPlayingBarCenter"))),browser.safari&&browser.slow&&nowPlayingBarElement.classList.add("noMediaProgress"),itemShortcuts.on(nowPlayingBarElement),bindEvents(nowPlayingBarElement)),resolve(nowPlayingBarElement)}))}))}function hideButton(button){button.classList.add("hide")}function updatePlayPauseState(isPaused){playPauseButtons&&playPauseButtons.forEach((function(button){var icon=button.querySelector(".material-icons");icon.classList.remove("play_arrow","pause"),icon.classList.add(isPaused?"play_arrow":"pause")}))}function updatePlayerStateInternal(event,state,player){!function showNowPlayingBar(){if(!isVisibilityAllowed)return void hideNowPlayingBar();getNowPlayingBar().then(slideUp)}(),lastPlayerState=state;var playerInfo=playbackManager.getPlayerInfo(),playState=state.PlayState||{};updatePlayPauseState(playState.IsPaused);var supportedCommands=playerInfo.supportedCommands;if(currentPlayerSupportedCommands=supportedCommands,-1===supportedCommands.indexOf("SetRepeatMode")?toggleRepeatButton.classList.add("hide"):toggleRepeatButton.classList.remove("hide"),updateRepeatModeDisplay(playbackManager.getRepeatMode()),onQueueShuffleModeChange(),updatePlayerVolumeState(playState.IsMuted,playState.VolumeLevel),positionSlider&&!positionSlider.dragging){positionSlider.disabled=!playState.CanSeek;var isProgressClear=state.MediaSource&&null==state.MediaSource.RunTimeTicks;positionSlider.setIsClear(isProgressClear)}var nowPlayingItem=state.NowPlayingItem||{};updateTimeDisplay(playState.PositionTicks,nowPlayingItem.RunTimeTicks,playbackManager.getBufferedRanges(player)),function updateNowPlayingInfo(state){var nowPlayingItem=state.NowPlayingItem,textLines=nowPlayingItem?nowPlayingHelper.getNowPlayingNames(nowPlayingItem):[];if(nowPlayingTextElement.innerHTML="",textLines){var itemText=document.createElement("div"),secondaryText=document.createElement("div");if(secondaryText.classList.add("nowPlayingBarSecondaryText"),textLines.length>1&&(textLines[1].secondary=!0,textLines[1].text)){var text=document.createElement("a");text.innerHTML=textLines[1].text,secondaryText.appendChild(text)}if(textLines[0].text){var _text=document.createElement("a");_text.innerHTML=textLines[0].text,itemText.appendChild(_text)}nowPlayingTextElement.appendChild(itemText),nowPlayingTextElement.appendChild(secondaryText)}var url=nowPlayingItem?function seriesImageUrl(item,options){if(!item)throw new Error("item cannot be null!");if("Episode"!==item.Type)return null;if((options=options||{}).type=options.type||"Primary","Primary"===options.type&&item.SeriesPrimaryImageTag)return options.tag=item.SeriesPrimaryImageTag,connectionManager.getApiClient(item.ServerId).getScaledImageUrl(item.SeriesId,options);if("Thumb"===options.type){if(item.SeriesThumbImageTag)return options.tag=item.SeriesThumbImageTag,connectionManager.getApiClient(item.ServerId).getScaledImageUrl(item.SeriesId,options);if(item.ParentThumbImageTag)return options.tag=item.ParentThumbImageTag,connectionManager.getApiClient(item.ServerId).getScaledImageUrl(item.ParentThumbItemId,options)}return null}(nowPlayingItem,{height:70})||function imageUrl(item,options){if(!item)throw new Error("item cannot be null!");if((options=options||{}).type=options.type||"Primary",item.ImageTags&&item.ImageTags[options.type])return options.tag=item.ImageTags[options.type],connectionManager.getApiClient(item.ServerId).getScaledImageUrl(item.PrimaryImageItemId||item.Id,options);if(item.AlbumId&&item.AlbumPrimaryImageTag)return options.tag=item.AlbumPrimaryImageTag,connectionManager.getApiClient(item.ServerId).getScaledImageUrl(item.AlbumId,options);return null}(nowPlayingItem,{height:70}):null,isRefreshing=!1;url!==currentImgUrl&&(currentImgUrl=url,isRefreshing=!0,url?(imageLoader.lazyImage(nowPlayingImageElement,url),nowPlayingImageElement.style.display=null,nowPlayingTextElement.style.marginLeft=null):(nowPlayingImageElement.style.backgroundImage="",nowPlayingImageElement.style.display="none",nowPlayingTextElement.style.marginLeft="1em"));if(nowPlayingItem.Id){if(isRefreshing){var apiClient=connectionManager.getApiClient(nowPlayingItem.ServerId);apiClient.getItem(apiClient.getCurrentUserId(),nowPlayingItem.Id).then((function(item){var userData=item.UserData||{},likes=null==userData.Likes?"":userData.Likes;if(!layoutManager.mobile){var contextButton=nowPlayingBarElement.querySelector(".btnToggleContextMenu"),contextButtonClone=contextButton.cloneNode(!0);contextButton.parentNode.replaceChild(contextButtonClone,contextButton);var options={play:!1,queue:!1,clearQueue:!0,positionTo:contextButton=nowPlayingBarElement.querySelector(".btnToggleContextMenu")};apiClient.getCurrentUser().then((function(user){contextButton.addEventListener("click",(function(){itemContextMenu.show(Object.assign({item:item,user:user},options))}))}))}nowPlayingUserData.innerHTML='<button is="emby-ratingbutton" type="button" class="listItemButton mediaButton paper-icon-button-light" data-id="'+item.Id+'" data-serverid="'+item.ServerId+'" data-itemtype="'+item.Type+'" data-likes="'+likes+'" data-isfavorite="'+userData.IsFavorite+'"><span class="material-icons favorite"></span></button>'}))}}else nowPlayingUserData.innerHTML=""}(state)}function updateRepeatModeDisplay(repeatMode){toggleRepeatButtonIcon.classList.remove("repeat","repeat_one");switch(repeatMode){case"RepeatAll":toggleRepeatButtonIcon.classList.add("repeat"),toggleRepeatButton.classList.add("buttonActive");break;case"RepeatOne":toggleRepeatButtonIcon.classList.add("repeat_one"),toggleRepeatButton.classList.add("buttonActive");break;case"RepeatNone":default:toggleRepeatButtonIcon.classList.add("repeat"),toggleRepeatButton.classList.remove("buttonActive")}}function updateTimeDisplay(positionTicks,runtimeTicks,bufferedRanges){if(positionSlider&&!positionSlider.dragging)if(runtimeTicks){var pct=positionTicks/runtimeTicks;pct*=100,positionSlider.value=pct}else positionSlider.value=0;if(positionSlider&&positionSlider.setBufferedRanges(bufferedRanges,runtimeTicks,positionTicks),currentTimeElement){var timeText=null==positionTicks?"--:--":datetime.getDisplayRunningTime(positionTicks);runtimeTicks&&(timeText+=" / "+datetime.getDisplayRunningTime(runtimeTicks)),currentTimeElement.innerHTML=timeText}}function updatePlayerVolumeState(isMuted,volumeLevel){var supportedCommands=currentPlayerSupportedCommands,showMuteButton=!0,showVolumeSlider=!0;-1===supportedCommands.indexOf("ToggleMute")&&(showMuteButton=!1);var muteButtonIcon=muteButton.querySelector(".material-icons");muteButtonIcon.classList.remove("volume_off","volume_up"),muteButtonIcon.classList.add(isMuted?"volume_off":"volume_up"),-1===supportedCommands.indexOf("SetVolume")&&(showVolumeSlider=!1),currentPlayer.isLocalPlayer&&appHost.supports("physicalvolumecontrol")&&(showMuteButton=!1,showVolumeSlider=!1),showMuteButton?function showButton(button){button.classList.remove("hide")}(muteButton):hideButton(muteButton),volumeSlider&&(volumeSliderContainer.classList.toggle("hide",!showVolumeSlider),volumeSlider.dragging||(volumeSlider.value=volumeLevel||0))}function onPlaybackStart(e,state){console.debug("nowplaying event: "+e.type);onStateChanged.call(this,e,state)}function onRepeatModeChange(){isEnabled&&updateRepeatModeDisplay(playbackManager.getRepeatMode())}function onQueueShuffleModeChange(){if(isEnabled){var shuffleMode=playbackManager.getQueueShuffleMode(),toggleShuffleButton=nowPlayingBarElement.querySelector(".btnShuffleQueue");switch(shuffleMode){case"Shuffle":toggleShuffleButton.classList.add("buttonActive");break;case"Sorted":default:toggleShuffleButton.classList.remove("buttonActive")}}}function hideNowPlayingBar(){isEnabled=!1;var elem=document.getElementsByClassName("nowPlayingBar")[0];elem&&function slideDown(elem){elem.offsetWidth,elem.classList.add("nowPlayingBar-hidden"),dom.addEventListener(elem,dom.whichTransitionEvent(),onSlideDownComplete,{once:!0})}(elem)}function onPlaybackStopped(e,state){console.debug("nowplaying event: "+e.type);this.isLocalPlayer?"Audio"!==state.NextMediaType&&hideNowPlayingBar():state.NextMediaType||hideNowPlayingBar()}function onPlayPauseStateChanged(e){if(isEnabled){updatePlayPauseState(this.paused())}}function onStateChanged(event,state){console.debug("nowplaying event: "+event.type);var player=this;state.NowPlayingItem&&!layoutManager.tv?player.isLocalPlayer&&state.NowPlayingItem&&"Video"===state.NowPlayingItem.MediaType?hideNowPlayingBar():(isEnabled=!0,nowPlayingBarElement?updatePlayerStateInternal(0,state,player):getNowPlayingBar().then((function(){updatePlayerStateInternal(0,state,player)}))):hideNowPlayingBar()}function onTimeUpdate(e){if(isEnabled){var now=(new Date).getTime();if(!(now-lastUpdateTime<700)){lastUpdateTime=now;currentRuntimeTicks=playbackManager.duration(this),updateTimeDisplay(playbackManager.currentTime(this),currentRuntimeTicks,playbackManager.getBufferedRanges(this))}}}function onVolumeChanged(e){if(isEnabled){updatePlayerVolumeState(this.isMuted(),this.getVolume())}}function refreshFromPlayer(player){var state=playbackManager.getPlayerState(player);onStateChanged.call(player,{type:"init"},state)}function bindToPlayer(player){player!==currentPlayer&&(!function releaseCurrentPlayer(){var player=currentPlayer;player&&(events.off(player,"playbackstart",onPlaybackStart),events.off(player,"statechange",onPlaybackStart),events.off(player,"repeatmodechange",onRepeatModeChange),events.off(player,"shufflequeuemodechange",onQueueShuffleModeChange),events.off(player,"playbackstop",onPlaybackStopped),events.off(player,"volumechange",onVolumeChanged),events.off(player,"pause",onPlayPauseStateChanged),events.off(player,"unpause",onPlayPauseStateChanged),events.off(player,"timeupdate",onTimeUpdate),currentPlayer=null,hideNowPlayingBar())}(),currentPlayer=player,player&&(refreshFromPlayer(player),events.on(player,"playbackstart",onPlaybackStart),events.on(player,"statechange",onPlaybackStart),events.on(player,"repeatmodechange",onRepeatModeChange),events.on(player,"shufflequeuemodechange",onQueueShuffleModeChange),events.on(player,"playbackstop",onPlaybackStopped),events.on(player,"volumechange",onVolumeChanged),events.on(player,"pause",onPlayPauseStateChanged),events.on(player,"unpause",onPlayPauseStateChanged),events.on(player,"timeupdate",onTimeUpdate)))}events.on(playbackManager,"playerchange",(function(){bindToPlayer(playbackManager.getCurrentPlayer())})),bindToPlayer(playbackManager.getCurrentPlayer()),document.addEventListener("viewbeforeshow",(function(e){e.detail.options.enableMediaControl?isVisibilityAllowed||(isVisibilityAllowed=!0,currentPlayer?refreshFromPlayer(currentPlayer):hideNowPlayingBar()):isVisibilityAllowed&&(isVisibilityAllowed=!1,hideNowPlayingBar())}))}));
//# sourceMappingURL=nowPlayingBar.js.map
