"""
MetaWIBELE: check module
Check settings

Copyright (c) 2019 Harvard School of Public Health

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE.
"""

import sys


def python_version():
    """
    Check the current version of python
    """

    # required python versions (3.7+)
    required_python_version_major = [3]
    required_python_version_minor = [7]

    # check for either of the required versions
    pass_check = False
    try:
        for major, minor in zip(required_python_version_major, required_python_version_minor):
            if (sys.version_info[0] == major and sys.version_info[1] >= minor):
                pass_check = True
    except (AttributeError, IndexError):
        sys.exit("CRITICAL ERROR: The python version found (version 1) " +
                 "does not match the version required (version " +
                 str(required_python_version_major) + "." +
                 str(required_python_version_minor) + "+)")

    if not pass_check:
        sys.exit("CRITICAL ERROR: The python version found (version " +
                 str(sys.version_info[0]) + "." + str(sys.version_info[1]) + ") " +
                 "does not match the version required (version " +
                 str(required_python_version_major) + "." +
                 str(required_python_version_minor) + "+)")

if __name__=='__main__':
    pass
