import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataGitlabClusterAgentConfig extends cdktf.TerraformMetaArguments {
    /**
    * The ID of the agent.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/d/cluster_agent#agent_id DataGitlabClusterAgent#agent_id}
    */
    readonly agentId: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/d/cluster_agent#id DataGitlabClusterAgent#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * ID or full path of the project maintained by the authenticated user.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/d/cluster_agent#project DataGitlabClusterAgent#project}
    */
    readonly project: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/gitlab/d/cluster_agent gitlab_cluster_agent}
*/
export declare class DataGitlabClusterAgent extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "gitlab_cluster_agent";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/gitlab/d/cluster_agent gitlab_cluster_agent} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataGitlabClusterAgentConfig
    */
    constructor(scope: Construct, id: string, config: DataGitlabClusterAgentConfig);
    private _agentId?;
    get agentId(): number;
    set agentId(value: number);
    get agentIdInput(): number | undefined;
    get createdAt(): string;
    get createdByUserId(): number;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get name(): string;
    private _project?;
    get project(): string;
    set project(value: string);
    get projectInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
