// Copyright (c) Mito
import React from 'react';
import { StepType } from '../../../types';
// Icons
import ImportIcon from '../../icons/ImportIcon';
import MergeIcon from '../../icons/MergeIcon';
import PivotIcon from '../../icons/PivotIcon';
import DeleteColumnIcon from '../../icons/DeleteColumnIcon';
import AddColumnIcon from '../../icons/AddColumnIcon';
import { FilterIcon } from '../../icons/FilterIcons';
import EditIcon from '../../icons/EditIcon';
import MitoIcon from '../../icons/MitoIcon';
import DropDuplicatesIcon from '../../icons/DropDuplicatesIcon';
import GraphIcon from '../../icons/GraphIcon';
/*
    Gets an icon for a specific step type, to display
    with that step
*/
export function getStepIcon(stepType) {
    switch (stepType) {
        case StepType.Initialize: return (React.createElement(MitoIcon, null));
        case StepType.AddColumn: return (React.createElement(AddColumnIcon, null));
        case StepType.DeleteColumn: return (React.createElement(DeleteColumnIcon, null));
        case StepType.RenameColumn: return (React.createElement(EditIcon, null));
        case StepType.ReorderColumn: return (React.createElement(EditIcon, null));
        case StepType.FilterColumn: return (React.createElement(FilterIcon, null));
        case StepType.SetColumnFormula: return (React.createElement("div", { className: 'step-taskpane-missing-icon' }, "Fx"));
        case StepType.DataframeDelete: return (React.createElement(DeleteColumnIcon, null));
        case StepType.DataframeDuplicate: return (React.createElement(EditIcon, null));
        case StepType.DataframeRename: return (React.createElement(EditIcon, null));
        case StepType.SimpleImport: return (React.createElement(ImportIcon, null));
        case StepType.ExcelImport: return (React.createElement(ImportIcon, null));
        case StepType.Sort: return (React.createElement(EditIcon, null));
        case StepType.Pivot: return (React.createElement(PivotIcon, null));
        case StepType.Merge: return (React.createElement(MergeIcon, null));
        case StepType.DropDuplicates: return (React.createElement(DropDuplicatesIcon, null));
        case StepType.Graph: return (React.createElement(GraphIcon, null));
        // TODO: Add a case here
        default: return (React.createElement(EditIcon, null));
    }
}
/*
    An element in a list that displays information about a step, and
    eventually will allow the user to interact with that step (e.g.
    to start editing it).
*/
function StepDataElement(props) {
    const toggleStepRollBack = () => {
        if (props.isCurrIdx) {
            // If this step is checked out, we go back to the last index
            void props.mitoAPI.updateCheckoutStepByIndex(props.lastIndex);
        }
        else {
            void props.mitoAPI.updateCheckoutStepByIndex(props.stepData.step_idx);
        }
    };
    { /* We grey out any steps that are before the current step */ }
    return (React.createElement("div", { className: 'step-taskpane-step-container', style: { opacity: props.beforeCurrIdx ? '1' : '.5' }, onClick: toggleStepRollBack },
        React.createElement("div", { className: 'step-taskpane-step-icon' }, getStepIcon(props.stepData.step_type)),
        React.createElement("div", { className: 'element-width-block hide-scrollbar' },
            React.createElement("div", { className: 'text-header-3' }, props.stepData.step_display_name),
            React.createElement("div", { className: 'text-body-2 text-overflow-scroll hide-scrollbar' }, props.stepData.step_description))));
}
export default StepDataElement;
//# sourceMappingURL=StepDataElement.js.map