// Copyright (c) Mito
import React from 'react';
// import css
import '../../../../css/taskpanes/Merge/MergeSheetAndKeySelection.css';
import { MergeSheet } from './MergeTaskpane';
import Select from '../../elements/Select';
import DropdownItem from '../../elements/DropdownItem';
import { getDisplayColumnHeader } from '../../../utils/columnHeaders';
/*
  A custom component that allows you to select a sheet from the list of
  possible sheets, as well as a column header from that sheet.
*/
const MergeSheetAndKeySelection = (props) => {
    const sheetNumStr = props.sheetNum == MergeSheet.First ? 'First' : 'Second';
    return (React.createElement("div", { className: 'merge-sheet-and-key mt-15px' },
        React.createElement("div", null,
            React.createElement("p", { className: 'text-header-3' },
                sheetNumStr,
                " Sheet"),
            React.createElement(Select, { value: props.dfNames[props.sheetIndex], onChange: (dfName) => {
                    // Safe cast as df names are all strings
                    const newSheetIndex = props.dfNames.indexOf(dfName);
                    props.setNewSheetIndex(newSheetIndex);
                }, width: 'medium' }, props.dfNames.map(dfName => {
                return (React.createElement(DropdownItem, { key: dfName, title: dfName }));
            }))),
        React.createElement("div", null,
            React.createElement("p", { className: 'text-header-3' }, "Merge Key"),
            React.createElement(Select, { value: props.mergeKeyColumnID, onChange: (columnID) => { props.setNewMergeKeyColumnID(columnID); }, width: 'medium', searchable: true }, Object.entries(props.columnIDsMap || {}).map(([columnID, columnHeader]) => {
                return (React.createElement(DropdownItem, { key: columnID, id: columnID, title: getDisplayColumnHeader(columnHeader) }));
            })))));
};
export default MergeSheetAndKeySelection;
//# sourceMappingURL=MergeSheetAndKeySelection.js.map