// Copyright (c) Mito
import React from 'react';
import XIcon from '../../icons/XIcon';
import Col from '../../spacing/Col';
import Row from '../../spacing/Row';
import { TaskpaneType } from '../taskpanes';
import { getDisplayColumnHeader } from '../../../utils/columnHeaders';
/*
    A modal that displays the column name and allows the user to
    click on the header to rename the column
*/
const ColumnNameCard = (props) => {
    return (React.createElement(React.Fragment, null,
        React.createElement(Row, { justify: 'space-between', align: 'center' },
            React.createElement(Col, { span: 20 },
                React.createElement("p", { className: 'text-header-2 text-overflow-hide', title: getDisplayColumnHeader(props.columnHeader) }, getDisplayColumnHeader(props.columnHeader))),
            React.createElement(Col, { offset: 1 },
                React.createElement(XIcon, { onClick: () => {
                        props.setUIState((prevUIState) => {
                            return Object.assign(Object.assign({}, prevUIState), { currOpenTaskpane: { type: TaskpaneType.NONE } });
                        });
                    } })))));
};
export default ColumnNameCard;
//# sourceMappingURL=ColumnNameCard.js.map