"""Module for XKNX Exception handling."""
# flake8: noqa
from .exception import (
    CommunicationError,
    ConfirmationError,
    ConversionError,
    CouldNotParseAddress,
    CouldNotParseKNXIP,
    CouldNotParseTelegram,
    DeviceIllegalValue,
    IncompleteKNXIPFrame,
    InterfaceWithUserIdNotFound,
    InvalidSecureConfiguration,
    InvalidSignature,
    KNXSecureValidationError,
    ManagementConnectionError,
    ManagementConnectionRefused,
    ManagementConnectionTimeout,
    SecureException,
    TunnellingAckError,
    UnsupportedCEMIMessage,
    XKNXException,
)

__all__ = [
    "CommunicationError",
    "ConfirmationError",
    "ConversionError",
    "CouldNotParseAddress",
    "CouldNotParseKNXIP",
    "CouldNotParseTelegram",
    "DeviceIllegalValue",
    "ManagementConnectionError",
    "ManagementConnectionRefused",
    "ManagementConnectionTimeout",
    "IncompleteKNXIPFrame",
    "InterfaceWithUserIdNotFound",
    "InvalidSecureConfiguration",
    "InvalidSignature",
    "KNXSecureValidationError",
    "SecureException",
    "TunnellingAckError",
    "UnsupportedCEMIMessage",
    "XKNXException",
]
