# Python Substrate Interface Library
#
# Copyright 2018-2020 Stichting Polkascan (Polkascan Foundation).
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
# http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.


metadata_v10_hex = "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"

metadata_v12_hex = '0x6d6574610b801853797374656d011853797374656d3c1c4163636f756e7401010230543a3a4163636f756e744964944163636f756e74496e666f3c543a3a496e6465782c20543a3a4163636f756e74446174613e00150100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000004e8205468652066756c6c206163636f756e7420696e666f726d6174696f6e20666f72206120706172746963756c6172206163636f756e742049442e3845787472696e736963436f756e7400000c753332040004b820546f74616c2065787472696e7369637320636f756e7420666f72207468652063757272656e7420626c6f636b2e2c426c6f636b576569676874010064776569676874733a3a45787472696e7369637357656967687440000000000000000000000000000000000488205468652063757272656e742077656967687420666f722074686520626c6f636b2e40416c6c45787472696e736963734c656e00000c753332040004410120546f74616c206c656e6774682028696e2062797465732920666f7220616c6c2065787472696e736963732070757420746f6765746865722c20666f72207468652063757272656e7420626c6f636b2e24426c6f636b4861736801010538543a3a426c6f636b4e756d6265721c543a3a48617368008000000000000000000000000000000000000000000000000000000000000000000498204d6170206f6620626c6f636b206e756d6265727320746f20626c6f636b206861736865732e3445787472696e736963446174610101050c7533321c5665633c75383e000400043d012045787472696e73696373206461746120666f72207468652063757272656e7420626c6f636b20286d61707320616e2065787472696e736963277320696e64657820746f206974732064617461292e184e756d626572010038543a3a426c6f636b4e756d6265721000000000040901205468652063757272656e7420626c6f636b206e756d626572206265696e672070726f6365737365642e205365742062792060657865637574655f626c6f636b602e28506172656e744861736801001c543a3a4861736880000000000000000000000000000000000000000000000000000000000000000004702048617368206f66207468652070726576696f757320626c6f636b2e3845787472696e73696373526f6f7401001c543a3a486173688000000000000000000000000000000000000000000000000000000000000000000415012045787472696e7369637320726f6f74206f66207468652063757272656e7420626c6f636b2c20616c736f2070617274206f662074686520626c6f636b206865616465722e1844696765737401002c4469676573744f663c543e040004f020446967657374206f66207468652063757272656e7420626c6f636b2c20616c736f2070617274206f662074686520626c6f636b206865616465722e184576656e747301008c5665633c4576656e745265636f72643c543a3a4576656e742c20543a3a486173683e3e040004a0204576656e7473206465706f736974656420666f72207468652063757272656e7420626c6f636b2e284576656e74436f756e740100284576656e74496e646578100000000004b820546865206e756d626572206f66206576656e747320696e2074686520604576656e74733c543e60206c6973742e2c4576656e74546f706963730101021c543a3a48617368845665633c28543a3a426c6f636b4e756d6265722c204576656e74496e646578293e000400282501204d617070696e67206265747765656e206120746f7069632028726570726573656e74656420627920543a3a486173682920616e64206120766563746f72206f6620696e646578657394206f66206576656e747320696e2074686520603c4576656e74733c543e3e60206c6973742e00510120416c6c20746f70696320766563746f727320686176652064657465726d696e69737469632073746f72616765206c6f636174696f6e7320646570656e64696e67206f6e2074686520746f7069632e2054686973450120616c6c6f7773206c696768742d636c69656e747320746f206c6576657261676520746865206368616e67657320747269652073746f7261676520747261636b696e67206d656368616e69736d20616e64e420696e2063617365206f66206368616e67657320666574636820746865206c697374206f66206576656e7473206f6620696e7465726573742e004d01205468652076616c756520686173207468652074797065206028543a3a426c6f636b4e756d6265722c204576656e74496e646578296020626563617573652069662077652075736564206f6e6c79206a7573744d012074686520604576656e74496e64657860207468656e20696e20636173652069662074686520746f70696320686173207468652073616d6520636f6e74656e7473206f6e20746865206e65787420626c6f636b0101206e6f206e6f74696669636174696f6e2077696c6c20626520747269676765726564207468757320746865206576656e74206d69676874206265206c6f73742e484c61737452756e74696d65557067726164650000584c61737452756e74696d6555706772616465496e666f04000455012053746f726573207468652060737065635f76657273696f6e6020616e642060737065635f6e616d6560206f66207768656e20746865206c6173742072756e74696d6520757067726164652068617070656e65642e38457865637574696f6e50686173650000145068617365040004882054686520657865637574696f6e207068617365206f662074686520626c6f636b2e01282866696c6c5f626c6f636b04185f726174696f1c50657262696c6c040901204120646973706174636820746861742077696c6c2066696c6c2074686520626c6f636b2077656967687420757020746f2074686520676976656e20726174696f2e1872656d61726b041c5f72656d61726b1c5665633c75383e1c6c204d616b6520736f6d65206f6e2d636861696e2072656d61726b2e002c2023203c7765696768743e24202d20604f28312960e0202d2042617365205765696768743a20302e36363520c2b5732c20696e646570656e64656e74206f662072656d61726b206c656e6774682e50202d204e6f204442206f7065726174696f6e732e302023203c2f7765696768743e387365745f686561705f7061676573041470616765730c75363420fc2053657420746865206e756d626572206f6620706167657320696e2074686520576562417373656d626c7920656e7669726f6e6d656e74277320686561702e002c2023203c7765696768743e24202d20604f283129604c202d20312073746f726167652077726974652e64202d2042617365205765696768743a20312e34303520c2b57360202d203120777269746520746f20484541505f5041474553302023203c2f7765696768743e207365745f636f64650410636f64651c5665633c75383e28682053657420746865206e65772072756e74696d6520636f64652e002c2023203c7765696768743e3501202d20604f2843202b2053296020776865726520604360206c656e677468206f662060636f64656020616e642060536020636f6d706c6578697479206f66206063616e5f7365745f636f64656088202d20312073746f726167652077726974652028636f64656320604f28432960292e7901202d20312063616c6c20746f206063616e5f7365745f636f6465603a20604f28532960202863616c6c73206073705f696f3a3a6d6973633a3a72756e74696d655f76657273696f6e6020776869636820697320657870656e73697665292e2c202d2031206576656e742e7d012054686520776569676874206f6620746869732066756e6374696f6e20697320646570656e64656e74206f6e207468652072756e74696d652c206275742067656e6572616c6c792074686973206973207665727920657870656e736976652e902057652077696c6c207472656174207468697320617320612066756c6c20626c6f636b2e302023203c2f7765696768743e5c7365745f636f64655f776974686f75745f636865636b730410636f64651c5665633c75383e201d012053657420746865206e65772072756e74696d6520636f646520776974686f757420646f696e6720616e7920636865636b73206f662074686520676976656e2060636f6465602e002c2023203c7765696768743e90202d20604f2843296020776865726520604360206c656e677468206f662060636f64656088202d20312073746f726167652077726974652028636f64656320604f28432960292e2c202d2031206576656e742e75012054686520776569676874206f6620746869732066756e6374696f6e20697320646570656e64656e74206f6e207468652072756e74696d652e2057652077696c6c207472656174207468697320617320612066756c6c20626c6f636b2e302023203c2f7765696768743e5c7365745f6368616e6765735f747269655f636f6e666967044c6368616e6765735f747269655f636f6e666967804f7074696f6e3c4368616e67657354726965436f6e66696775726174696f6e3e28a02053657420746865206e6577206368616e676573207472696520636f6e66696775726174696f6e2e002c2023203c7765696768743e24202d20604f28312960b0202d20312073746f72616765207772697465206f722064656c6574652028636f64656320604f28312960292ed8202d20312063616c6c20746f20606465706f7369745f6c6f67603a20557365732060617070656e6460204150492c20736f204f28312964202d2042617365205765696768743a20372e32313820c2b57334202d204442205765696768743aa820202020202d205772697465733a204368616e67657320547269652c2053797374656d20446967657374302023203c2f7765696768743e2c7365745f73746f7261676504146974656d73345665633c4b657956616c75653e206c2053657420736f6d65206974656d73206f662073746f726167652e002c2023203c7765696768743e94202d20604f2849296020776865726520604960206c656e677468206f6620606974656d73607c202d206049602073746f72616765207772697465732028604f28312960292e74202d2042617365205765696768743a20302e353638202a206920c2b57368202d205772697465733a204e756d626572206f66206974656d73302023203c2f7765696768743e306b696c6c5f73746f7261676504106b657973205665633c4b65793e2078204b696c6c20736f6d65206974656d732066726f6d2073746f726167652e002c2023203c7765696768743efc202d20604f28494b296020776865726520604960206c656e677468206f6620606b6579736020616e6420604b60206c656e677468206f66206f6e65206b657964202d206049602073746f726167652064656c6574696f6e732e70202d2042617365205765696768743a202e333738202a206920c2b57368202d205772697465733a204e756d626572206f66206974656d73302023203c2f7765696768743e2c6b696c6c5f70726566697808187072656669780c4b6579205f7375626b6579730c7533322c1501204b696c6c20616c6c2073746f72616765206974656d7320776974682061206b657920746861742073746172747320776974682074686520676976656e207072656669782e003d01202a2a4e4f54453a2a2a2057652072656c79206f6e2074686520526f6f74206f726967696e20746f2070726f7669646520757320746865206e756d626572206f66207375626b65797320756e64657241012074686520707265666978207765206172652072656d6f76696e6720746f2061636375726174656c792063616c63756c6174652074686520776569676874206f6620746869732066756e6374696f6e2e002c2023203c7765696768743edc202d20604f285029602077686572652060506020616d6f756e74206f66206b65797320776974682070726566697820607072656669786064202d206050602073746f726167652064656c6574696f6e732e74202d2042617365205765696768743a20302e383334202a205020c2b57380202d205772697465733a204e756d626572206f66207375626b657973202b2031302023203c2f7765696768743e1c7375696369646500286501204b696c6c207468652073656e64696e67206163636f756e742c20617373756d696e6720746865726520617265206e6f207265666572656e636573206f75747374616e64696e6720616e642074686520636f6d706f7369746590206461746120697320657175616c20746f206974732064656661756c742076616c75652e002c2023203c7765696768743e24202d20604f283129607c202d20312073746f72616765207265616420616e642064656c6574696f6e2e54202d2d2d2d2d2d2d2d2d2d2d2d2d2d2d2d2d2d2d2d5c2042617365205765696768743a20382e36323620c2b5731101204e6f2044422052656164206f72205772697465206f7065726174696f6e7320626563617573652063616c6c657220697320616c726561647920696e206f7665726c6179302023203c2f7765696768743e01144045787472696e7369635375636365737304304469737061746368496e666f049420416e2065787472696e73696320636f6d706c65746564207375636365737366756c6c792e3c45787472696e7369634661696c6564083444697370617463684572726f72304469737061746368496e666f045420416e2065787472696e736963206661696c65642e2c436f64655570646174656400045420603a636f6465602077617320757064617465642e284e65774163636f756e7404244163636f756e744964046c2041206e6577206163636f756e742077617320637265617465642e344b696c6c65644163636f756e7404244163636f756e744964045c20416e206163636f756e7420776173207265617065642e1838426c6f636b48617368436f756e7438543a3a426c6f636b4e756d626572106009000004d820546865206d6178696d756d206e756d626572206f6620626c6f636b7320746f20616c6c6f7720696e206d6f7274616c20657261732e484d6178696d756d426c6f636b576569676874185765696768742000204aa9d1010000047c20546865206d6178696d756d20776569676874206f66206120626c6f636b2e2044625765696768743c52756e74696d6544625765696768744040787d010000000000e1f505000000000409012054686520776569676874206f662072756e74696d65206461746162617365206f7065726174696f6e73207468652072756e74696d652063616e20696e766f6b652e50426c6f636b457865637574696f6e576569676874185765696768742000f2052a0100000004510120546865206261736520776569676874206f6620657865637574696e67206120626c6f636b2c20696e646570656e64656e74206f6620746865207472616e73616374696f6e7320696e2074686520626c6f636b2e4c45787472696e736963426173655765696768741857656967687420405973070000000004790120546865206261736520776569676874206f6620616e2045787472696e73696320696e2074686520626c6f636b2c20696e646570656e64656e74206f6620746865206f662065787472696e736963206265696e672065786563757465642e484d6178696d756d426c6f636b4c656e6774680c753332100000500004a820546865206d6178696d756d206c656e677468206f66206120626c6f636b2028696e206279746573292e143c496e76616c6964537065634e616d6508150120546865206e616d65206f662073706563696669636174696f6e20646f6573206e6f74206d61746368206265747765656e207468652063757272656e742072756e74696d655420616e6420746865206e65772072756e74696d652e685370656356657273696f6e4e65656473546f496e637265617365084501205468652073706563696669636174696f6e2076657273696f6e206973206e6f7420616c6c6f77656420746f206465637265617365206265747765656e207468652063757272656e742072756e74696d655420616e6420746865206e65772072756e74696d652e744661696c6564546f4578747261637452756e74696d6556657273696f6e0cf0204661696c656420746f2065787472616374207468652072756e74696d652076657273696f6e2066726f6d20746865206e65772072756e74696d652e000d01204569746865722063616c6c696e672060436f72655f76657273696f6e60206f72206465636f64696e67206052756e74696d6556657273696f6e60206661696c65642e4c4e6f6e44656661756c74436f6d706f7369746504010120537569636964652063616c6c6564207768656e20746865206163636f756e7420686173206e6f6e2d64656661756c7420636f6d706f7369746520646174612e3c4e6f6e5a65726f526566436f756e740439012054686572652069732061206e6f6e2d7a65726f207265666572656e636520636f756e742070726576656e74696e6720746865206163636f756e742066726f6d206265696e67207075726765642e1c5574696c69747900010c146261746368041463616c6c735c5665633c3c542061732054726169743e3a3a43616c6c3e50802053656e642061206261746368206f662064697370617463682063616c6c732e007c204d61792062652063616c6c65642066726f6d20616e79206f726967696e2e00f0202d206063616c6c73603a205468652063616c6c7320746f20626520646973706174636865642066726f6d207468652073616d65206f726967696e2e006101204966206f726967696e20697320726f6f74207468656e2063616c6c2061726520646973706174636820776974686f757420636865636b696e67206f726967696e2066696c7465722e20285468697320696e636c75646573c820627970617373696e6720606672616d655f73797374656d3a3a54726169743a3a4261736543616c6c46696c74657260292e002c2023203c7765696768743e90202d2042617365207765696768743a2031342e3339202b202e393837202a206320c2b573b8202d20506c7573207468652073756d206f66207468652077656967687473206f6620746865206063616c6c73602ec4202d20506c7573206f6e65206164646974696f6e616c206576656e742e202872657065617420726561642f777269746529302023203c2f7765696768743e00590120546869732077696c6c2072657475726e20604f6b6020696e20616c6c2063697263756d7374616e6365732e20546f2064657465726d696e65207468652073756363657373206f66207468652062617463682c20616e3501206576656e74206973206465706f73697465642e20496620612063616c6c206661696c656420616e64207468652062617463682077617320696e7465727275707465642c207468656e20746865590120604261746368496e74657272757074656460206576656e74206973206465706f73697465642c20616c6f6e67207769746820746865206e756d626572206f66207375636365737366756c2063616c6c73206d616465510120616e6420746865206572726f72206f6620746865206661696c65642063616c6c2e20496620616c6c2077657265207375636365737366756c2c207468656e2074686520604261746368436f6d706c657465646050206576656e74206973206465706f73697465642e1861735f7375620814696e6465780c7531361063616c6c5c426f783c3c542061732054726169743e3a3a43616c6c3e30e02053656e6420612063616c6c207468726f75676820616e20696e64657865642070736575646f6e796d206f66207468652073656e6465722e005901204e4f54453a20496620796f75206e65656420746f20656e73757265207468617420616e79206163636f756e742d62617365642066696c746572696e6720697320686f6e6f7265642028692e652e2062656361757365650120796f7520657870656374206070726f78796020746f2068617665206265656e2075736564207072696f7220696e207468652063616c6c20737461636b20616e6420796f752077616e7420697420746f206170706c7920746fd820616e79207375622d6163636f756e7473292c207468656e20757365206061735f6c696d697465645f7375626020696e73746561642e00d020546865206469737061746368206f726967696e20666f7220746869732063616c6c206d757374206265205f5369676e65645f2e002c2023203c7765696768743e64202d2042617365207765696768743a20322e38363120c2b57380202d20506c75732074686520776569676874206f6620746865206063616c6c60302023203c2f7765696768743e3861735f6c696d697465645f7375620814696e6465780c7531361063616c6c5c426f783c3c542061732054726169743e3a3a43616c6c3e3ce02053656e6420612063616c6c207468726f75676820616e20696e64657865642070736575646f6e796d206f66207468652073656e6465722e0059012046696c7465722066726f6d206f726967696e206172652070617373656420616c6f6e672e205468652063616c6c2077696c6c2062652064697370617463686564207769746820616e206f726967696e207768696368c020757365207468652073616d652066696c74657220617320746865206f726967696e206f6620746869732063616c6c2e004901204e4f54453a20496620796f75206e65656420746f20656e73757265207468617420616e79206163636f756e742d62617365642066696c746572696e67206973206e6f7420686f6e6f7265642028692e652e6501206265636175736520796f7520657870656374206070726f78796020746f2068617665206265656e2075736564207072696f7220696e207468652063616c6c20737461636b20616e6420796f7520646f206e6f742077616e744101207468652063616c6c207265737472696374696f6e7320746f206170706c7920746f20616e79207375622d6163636f756e7473292c207468656e20757365206061735f7375626020696e73746561642e00d020546865206469737061746368206f726967696e20666f7220746869732063616c6c206d757374206265205f5369676e65645f2e002c2023203c7765696768743e64202d2042617365207765696768743a20322e38363120c2b57380202d20506c75732074686520776569676874206f6620746865206063616c6c60302023203c2f7765696768743e0108404261746368496e746572727570746564080c7533323444697370617463684572726f72085901204261746368206f66206469737061746368657320646964206e6f7420636f6d706c6574652066756c6c792e20496e646578206f66206669727374206661696c696e6720646973706174636820676976656e2c2061734c2077656c6c20617320746865206572726f722e384261746368436f6d706c657465640004cc204261746368206f66206469737061746368657320636f6d706c657465642066756c6c792077697468206e6f206572726f722e000010426162650110426162652c2845706f6368496e64657801000c75363420000000000000000004542043757272656e742065706f636820696e6465782e2c417574686f72697469657301009c5665633c28417574686f7269747949642c2042616265417574686f72697479576569676874293e0400046c2043757272656e742065706f636820617574686f7269746965732e2c47656e65736973536c6f7401000c75363420000000000000000008f82054686520736c6f74206174207768696368207468652066697273742065706f63682061637475616c6c7920737461727465642e205468697320697320309020756e74696c2074686520666972737420626c6f636b206f662074686520636861696e2e2c43757272656e74536c6f7401000c75363420000000000000000004542043757272656e7420736c6f74206e756d6265722e2852616e646f6d6e6573730100587363686e6f72726b656c3a3a52616e646f6d6e65737380000000000000000000000000000000000000000000000000000000000000000028b8205468652065706f63682072616e646f6d6e65737320666f7220746865202a63757272656e742a2065706f63682e002c20232053656375726974790005012054686973204d555354204e4f54206265207573656420666f722067616d626c696e672c2061732069742063616e20626520696e666c75656e6365642062792061f8206d616c6963696f75732076616c696461746f7220696e207468652073686f7274207465726d2e204974204d4159206265207573656420696e206d616e7915012063727970746f677261706869632070726f746f636f6c732c20686f77657665722c20736f206c6f6e67206173206f6e652072656d656d6265727320746861742074686973150120286c696b652065766572797468696e6720656c7365206f6e2d636861696e29206974206973207075626c69632e20466f72206578616d706c652c2069742063616e206265050120757365642077686572652061206e756d626572206973206e656564656420746861742063616e6e6f742068617665206265656e2063686f73656e20627920616e0d01206164766572736172792c20666f7220707572706f7365732073756368206173207075626c69632d636f696e207a65726f2d6b6e6f776c656467652070726f6f66732e3c4e65787445706f6368436f6e6669670000504e657874436f6e66696744657363726970746f7204000498204e6578742065706f636820636f6e66696775726174696f6e2c206966206368616e6765642e384e65787452616e646f6d6e6573730100587363686e6f72726b656c3a3a52616e646f6d6e657373800000000000000000000000000000000000000000000000000000000000000000045c204e6578742065706f63682072616e646f6d6e6573732e305365676d656e74496e64657801000c7533321000000000247c2052616e646f6d6e65737320756e64657220636f6e737472756374696f6e2e00f4205765206d616b6520612074726164656f6666206265747765656e2073746f7261676520616363657373657320616e64206c697374206c656e6774682e01012057652073746f72652074686520756e6465722d636f6e737472756374696f6e2072616e646f6d6e65737320696e207365676d656e7473206f6620757020746f942060554e4445525f434f4e535452554354494f4e5f5345474d454e545f4c454e475448602e00ec204f6e63652061207365676d656e7420726561636865732074686973206c656e6774682c20776520626567696e20746865206e657874206f6e652e090120576520726573657420616c6c207365676d656e747320616e642072657475726e20746f206030602061742074686520626567696e6e696e67206f662065766572791c2065706f63682e44556e646572436f6e737472756374696f6e0101050c7533326c5665633c7363686e6f72726b656c3a3a52616e646f6d6e6573733e0004000415012054574f582d4e4f54453a20605365676d656e74496e6465786020697320616e20696e6372656173696e6720696e74656765722c20736f2074686973206973206f6b61792e2c496e697469616c697a656400003c4d6179626552616e646f6d6e65737304000801012054656d706f726172792076616c75652028636c656172656420617420626c6f636b2066696e616c697a6174696f6e292077686963682069732060536f6d65601d01206966207065722d626c6f636b20696e697469616c697a6174696f6e2068617320616c7265616479206265656e2063616c6c656420666f722063757272656e7420626c6f636b2e204c6174656e657373010038543a3a426c6f636b4e756d626572100000000014d820486f77206c617465207468652063757272656e7420626c6f636b20697320636f6d706172656420746f2069747320706172656e742e001501205468697320656e74727920697320706f70756c617465642061732070617274206f6620626c6f636b20657865637574696f6e20616e6420697320636c65616e65642075701101206f6e20626c6f636b2066696e616c697a6174696f6e2e205175657279696e6720746869732073746f7261676520656e747279206f757473696465206f6620626c6f636bb020657865637574696f6e20636f6e746578742073686f756c6420616c77617973207969656c64207a65726f2e010000083445706f63684475726174696f6e0c75363420c800000000000000080d0120546865206e756d626572206f66202a2a736c6f74732a2a207468617420616e2065706f63682074616b65732e20576520636f75706c652073657373696f6e7320746ffc2065706f6368732c20692e652e2077652073746172742061206e65772073657373696f6e206f6e636520746865206e65772065706f636820626567696e732e444578706563746564426c6f636b54696d6524543a3a4d6f6d656e7420b80b00000000000014050120546865206578706563746564206176657261676520626c6f636b2074696d6520617420776869636820424142452073686f756c64206265206372656174696e67110120626c6f636b732e2053696e636520424142452069732070726f626162696c6973746963206974206973206e6f74207472697669616c20746f20666967757265206f75740501207768617420746865206578706563746564206176657261676520626c6f636b2074696d652073686f756c64206265206261736564206f6e2074686520736c6f740901206475726174696f6e20616e642074686520736563757269747920706172616d657465722060636020287768657265206031202d20636020726570726573656e7473a0207468652070726f626162696c697479206f66206120736c6f74206265696e6720656d707479292e002454696d657374616d70012454696d657374616d70080c4e6f77010024543a3a4d6f6d656e7420000000000000000004902043757272656e742074696d6520666f72207468652063757272656e7420626c6f636b2e24446964557064617465010010626f6f6c040004b420446964207468652074696d657374616d7020676574207570646174656420696e207468697320626c6f636b3f01040c736574040c6e6f7748436f6d706163743c543a3a4d6f6d656e743e485820536574207468652063757272656e742074696d652e00590120546869732063616c6c2073686f756c6420626520696e766f6b65642065786163746c79206f6e63652070657220626c6f636b2e2049742077696c6c2070616e6963206174207468652066696e616c697a6174696f6ed82070686173652c20696620746869732063616c6c206861736e2774206265656e20696e766f6b656420627920746861742074696d652e004501205468652074696d657374616d702073686f756c642062652067726561746572207468616e207468652070726576696f7573206f6e652062792074686520616d6f756e74207370656369666965642062794420604d696e696d756d506572696f64602e00d820546865206469737061746368206f726967696e20666f7220746869732063616c6c206d7573742062652060496e686572656e74602e002c2023203c7765696768743ed0202d20604f285429602077686572652060546020636f6d706c6578697479206f6620606f6e5f74696d657374616d705f73657460a101202d20312073746f72616765207265616420616e6420312073746f72616765206d75746174696f6e2028636f64656320604f28312960292e202862656361757365206f6620604469645570646174653a3a74616b656020696e20606f6e5f66696e616c697a656029b4202d2031206576656e742068616e646c657220606f6e5f74696d657374616d705f7365746020604f285429602ea8202d2042656e63686d61726b3a20372e36373820286d696e207371756172657320616e616c797369732981012020202d204e4f54453a20546869732062656e63686d61726b2077617320646f6e6520666f7220612072756e74696d65207769746820696e7369676e69666963616e7420606f6e5f74696d657374616d705f736574602068616e646c6572732ee420202020204e65772062656e63686d61726b696e67206973206e6565646564207768656e20616464696e67206e65772068616e646c6572732e302023203c2f7765696768743e0004344d696e696d756d506572696f6424543a3a4d6f6d656e7420dc0500000000000010690120546865206d696e696d756d20706572696f64206265747765656e20626c6f636b732e204265776172652074686174207468697320697320646966666572656e7420746f20746865202a65787065637465642a20706572696f64690120746861742074686520626c6f636b2070726f64756374696f6e206170706172617475732070726f76696465732e20596f75722063686f73656e20636f6e73656e7375732073797374656d2077696c6c2067656e6572616c6c79650120776f726b2077697468207468697320746f2064657465726d696e6520612073656e7369626c6520626c6f636b2074696d652e20652e672e20466f7220417572612c2069742077696c6c20626520646f75626c6520746869737020706572696f64206f6e2064656661756c742073657474696e67732e0028417574686f72736869700128417574686f72736869700c18556e636c65730100e85665633c556e636c65456e7472794974656d3c543a3a426c6f636b4e756d6265722c20543a3a486173682c20543a3a4163636f756e7449643e3e0400041c20556e636c657318417574686f72000030543a3a4163636f756e7449640400046420417574686f72206f662063757272656e7420626c6f636b2e30446964536574556e636c6573010010626f6f6c040004bc205768657468657220756e636c6573207765726520616c72656164792073657420696e207468697320626c6f636b2e0104287365745f756e636c657304286e65775f756e636c6573385665633c543a3a4865616465723e04642050726f76696465206120736574206f6620756e636c65732e00001c48496e76616c6964556e636c65506172656e74048c2054686520756e636c6520706172656e74206e6f7420696e2074686520636861696e2e40556e636c6573416c7265616479536574048420556e636c657320616c72656164792073657420696e2074686520626c6f636b2e34546f6f4d616e79556e636c6573044420546f6f206d616e7920756e636c65732e3047656e65736973556e636c6504582054686520756e636c652069732067656e657369732e30546f6f48696768556e636c6504802054686520756e636c6520697320746f6f206869676820696e20636861696e2e50556e636c65416c7265616479496e636c75646564047c2054686520756e636c6520697320616c726561647920696e636c756465642e204f6c64556e636c6504b82054686520756e636c652069736e277420726563656e7420656e6f75676820746f20626520696e636c756465642e1c496e6469636573011c496e646963657304204163636f756e74730001023c543a3a4163636f756e74496e6465788828543a3a4163636f756e7449642c2042616c616e63654f663c543e2c20626f6f6c29000400048820546865206c6f6f6b75702066726f6d20696e64657820746f206163636f756e742e011414636c61696d0414696e6465783c543a3a4163636f756e74496e6465784c9c2041737369676e20616e2070726576696f75736c7920756e61737369676e656420696e6465782e00e0205061796d656e743a20604465706f736974602069732072657365727665642066726f6d207468652073656e646572206163636f756e742e00d020546865206469737061746368206f726967696e20666f7220746869732063616c6c206d757374206265205f5369676e65645f2e00f4202d2060696e646578603a2074686520696e64657820746f20626520636c61696d65642e2054686973206d757374206e6f7420626520696e207573652e009420456d6974732060496e64657841737369676e656460206966207375636365737366756c2e002c2023203c7765696768743e28202d20604f283129602e9c202d204f6e652073746f72616765206d75746174696f6e2028636f64656320604f28312960292e64202d204f6e652072657365727665206f7065726174696f6e2e34202d204f6e65206576656e742e50202d2d2d2d2d2d2d2d2d2d2d2d2d2d2d2d2d2d2d64202d2042617365205765696768743a2032382e363920c2b57394202d204442205765696768743a203120526561642f577269746520284163636f756e747329302023203c2f7765696768743e207472616e73666572080c6e657730543a3a4163636f756e74496414696e6465783c543a3a4163636f756e74496e6465785461012041737369676e20616e20696e64657820616c7265616479206f776e6564206279207468652073656e64657220746f20616e6f74686572206163636f756e742e205468652062616c616e6365207265736572766174696f6ebc206973206566666563746976656c79207472616e7366657272656420746f20746865206e6577206163636f756e742e00d020546865206469737061746368206f726967696e20666f7220746869732063616c6c206d757374206265205f5369676e65645f2e002901202d2060696e646578603a2074686520696e64657820746f2062652072652d61737369676e65642e2054686973206d757374206265206f776e6564206279207468652073656e6465722e6101202d20606e6577603a20746865206e6577206f776e6572206f662074686520696e6465782e20546869732066756e6374696f6e2069732061206e6f2d6f7020696620697420697320657175616c20746f2073656e6465722e009420456d6974732060496e64657841737369676e656460206966207375636365737366756c2e002c2023203c7765696768743e28202d20604f283129602e9c202d204f6e652073746f72616765206d75746174696f6e2028636f64656320604f28312960292e68202d204f6e65207472616e73666572206f7065726174696f6e2e34202d204f6e65206576656e742e50202d2d2d2d2d2d2d2d2d2d2d2d2d2d2d2d2d2d2d64202d2042617365205765696768743a2033332e373420c2b57334202d204442205765696768743ae4202020202d2052656164733a20496e6469636573204163636f756e74732c2053797374656d204163636f756e742028726563697069656e7429e8202020202d205772697465733a20496e6469636573204163636f756e74732c2053797374656d204163636f756e742028726563697069656e7429302023203c2f7765696768743e10667265650414696e6465783c543a3a4163636f756e74496e6465784c98204672656520757020616e20696e646578206f776e6564206279207468652073656e6465722e006101205061796d656e743a20416e792070726576696f7573206465706f73697420706c6163656420666f722074686520696e64657820697320756e726573657276656420696e207468652073656e646572206163636f756e742e00590120546865206469737061746368206f726967696e20666f7220746869732063616c6c206d757374206265205f5369676e65645f20616e64207468652073656e646572206d757374206f776e2074686520696e6465782e001101202d2060696e646578603a2074686520696e64657820746f2062652066726565642e2054686973206d757374206265206f776e6564206279207468652073656e6465722e008820456d6974732060496e646578467265656460206966207375636365737366756c2e002c2023203c7765696768743e28202d20604f283129602e9c202d204f6e652073746f72616765206d75746174696f6e2028636f64656320604f28312960292e64202d204f6e652072657365727665206f7065726174696f6e2e34202d204f6e65206576656e742e50202d2d2d2d2d2d2d2d2d2d2d2d2d2d2d2d2d2d2d64202d2042617365205765696768743a2032352e353320c2b57394202d204442205765696768743a203120526561642f577269746520284163636f756e747329302023203c2f7765696768743e38666f7263655f7472616e736665720c0c6e657730543a3a4163636f756e74496414696e6465783c543a3a4163636f756e74496e64657818667265657a6510626f6f6c58590120466f72636520616e20696e64657820746f20616e206163636f756e742e205468697320646f65736e277420726571756972652061206465706f7369742e2049662074686520696e64657820697320616c7265616479ec2068656c642c207468656e20616e79206465706f736974206973207265696d62757273656420746f206974732063757272656e74206f776e65722e00c820546865206469737061746368206f726967696e20666f7220746869732063616c6c206d757374206265205f526f6f745f2e00a8202d2060696e646578603a2074686520696e64657820746f206265202872652d2961737369676e65642e6101202d20606e6577603a20746865206e6577206f776e6572206f662074686520696e6465782e20546869732066756e6374696f6e2069732061206e6f2d6f7020696620697420697320657175616c20746f2073656e6465722e4501202d2060667265657a65603a2069662073657420746f206074727565602c2077696c6c20667265657a652074686520696e64657820736f2069742063616e6e6f74206265207472616e736665727265642e009420456d6974732060496e64657841737369676e656460206966207375636365737366756c2e002c2023203c7765696768743e28202d20604f283129602e9c202d204f6e652073746f72616765206d75746174696f6e2028636f64656320604f28312960292e7c202d20557020746f206f6e652072657365727665206f7065726174696f6e2e34202d204f6e65206576656e742e50202d2d2d2d2d2d2d2d2d2d2d2d2d2d2d2d2d2d2d64202d2042617365205765696768743a2032362e383320c2b57334202d204442205765696768743af8202020202d2052656164733a20496e6469636573204163636f756e74732c2053797374656d204163636f756e7420286f726967696e616c206f776e657229fc202020202d205772697465733a20496e6469636573204163636f756e74732c2053797374656d204163636f756e7420286f726967696e616c206f776e657229302023203c2f7765696768743e18667265657a650414696e6465783c543a3a4163636f756e74496e64657848690120467265657a6520616e20696e64657820736f2069742077696c6c20616c7761797320706f696e7420746f207468652073656e646572206163636f756e742e205468697320636f6e73756d657320746865206465706f7369742e005d0120546865206469737061746368206f726967696e20666f7220746869732063616c6c206d757374206265205f5369676e65645f20616e6420746865207369676e696e67206163636f756e74206d7573742068617665206170206e6f6e2d66726f7a656e206163636f756e742060696e646578602e00b0202d2060696e646578603a2074686520696e64657820746f2062652066726f7a656e20696e20706c6163652e008c20456d6974732060496e64657846726f7a656e60206966207375636365737366756c2e002c2023203c7765696768743e28202d20604f283129602e9c202d204f6e652073746f72616765206d75746174696f6e2028636f64656320604f28312960292e74202d20557020746f206f6e6520736c617368206f7065726174696f6e2e34202d204f6e65206576656e742e50202d2d2d2d2d2d2d2d2d2d2d2d2d2d2d2d2d2d2d64202d2042617365205765696768743a2033302e383620c2b57394202d204442205765696768743a203120526561642f577269746520284163636f756e747329302023203c2f7765696768743e010c34496e64657841737369676e656408244163636f756e744964304163636f756e74496e64657804782041206163636f756e7420696e646578207761732061737369676e65642e28496e646578467265656404304163636f756e74496e64657804c02041206163636f756e7420696e64657820686173206265656e2066726565642075702028756e61737369676e6564292e2c496e64657846726f7a656e08304163636f756e74496e646578244163636f756e74496404ec2041206163636f756e7420696e64657820686173206265656e2066726f7a656e20746f206974732063757272656e74206163636f756e742049442e00002042616c616e636573012042616c616e6365731034546f74616c49737375616e6365010028543a3a42616c616e6365400000000000000000000000000000000004982054686520746f74616c20756e6974732069737375656420696e207468652073797374656d2e1c4163636f756e7401010230543a3a4163636f756e7449645c4163636f756e74446174613c543a3a42616c616e63653e000101000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000c6c205468652062616c616e6365206f6620616e206163636f756e742e004101204e4f54453a2054686973206973206f6e6c79207573656420696e20746865206361736520746861742074686973206d6f64756c65206973207573656420746f2073746f72652062616c616e6365732e144c6f636b7301010230543a3a4163636f756e744964705665633c42616c616e63654c6f636b3c543a3a42616c616e63653e3e00040008b820416e79206c6971756964697479206c6f636b73206f6e20736f6d65206163636f756e742062616c616e6365732e2501204e4f54453a2053686f756c64206f6e6c79206265206163636573736564207768656e2073657474696e672c206368616e67696e6720616e642066726565696e672061206c6f636b2e3853746f7261676556657273696f6e01002052656c656173657304000c7c2053746f726167652076657273696f6e206f66207468652070616c6c65742e00a020546869732069732073657420746f2076322e302e3020666f72206e6577206e6574776f726b732e0110207472616e736665720810646573748c3c543a3a4c6f6f6b7570206173205374617469634c6f6f6b75703e3a3a536f757263651476616c75654c436f6d706163743c543a3a42616c616e63653e6cd8205472616e7366657220736f6d65206c697175696420667265652062616c616e636520746f20616e6f74686572206163636f756e742e00090120607472616e73666572602077696c6c207365742074686520604672656542616c616e636560206f66207468652073656e64657220616e642072656365697665722e21012049742077696c6c2064656372656173652074686520746f74616c2069737375616e6365206f66207468652073797374656d2062792074686520605472616e73666572466565602e1501204966207468652073656e6465722773206163636f756e742069732062656c6f7720746865206578697374656e7469616c206465706f736974206173206120726573756c74b4206f6620746865207472616e736665722c20746865206163636f756e742077696c6c206265207265617065642e00190120546865206469737061746368206f726967696e20666f7220746869732063616c6c206d75737420626520605369676e65646020627920746865207472616e736163746f722e002c2023203c7765696768743e3101202d20446570656e64656e74206f6e20617267756d656e747320627574206e6f7420637269746963616c2c20676976656e2070726f70657220696d706c656d656e746174696f6e7320666f72cc202020696e70757420636f6e6669672074797065732e205365652072656c617465642066756e6374696f6e732062656c6f772e6901202d20497420636f6e7461696e732061206c696d69746564206e756d626572206f6620726561647320616e642077726974657320696e7465726e616c6c7920616e64206e6f20636f6d706c657820636f6d7075746174696f6e2e004c2052656c617465642066756e6374696f6e733a0051012020202d2060656e737572655f63616e5f77697468647261776020697320616c776179732063616c6c656420696e7465726e616c6c792062757420686173206120626f756e64656420636f6d706c65786974792e2d012020202d205472616e7366657272696e672062616c616e63657320746f206163636f756e7473207468617420646964206e6f74206578697374206265666f72652077696c6c206361757365d420202020202060543a3a4f6e4e65774163636f756e743a3a6f6e5f6e65775f6163636f756e746020746f2062652063616c6c65642e61012020202d2052656d6f76696e6720656e6f7567682066756e64732066726f6d20616e206163636f756e742077696c6c20747269676765722060543a3a4475737452656d6f76616c3a3a6f6e5f756e62616c616e636564602e49012020202d20607472616e736665725f6b6565705f616c6976656020776f726b73207468652073616d652077617920617320607472616e73666572602c206275742068617320616e206164646974696f6e616cf82020202020636865636b207468617420746865207472616e736665722077696c6c206e6f74206b696c6c20746865206f726967696e206163636f756e742e88202d2d2d2d2d2d2d2d2d2d2d2d2d2d2d2d2d2d2d2d2d2d2d2d2d2d2d2d2d2d2d2d2d4501202d2042617365205765696768743a2037332e363420c2b5732c20776f7273742063617365207363656e6172696f20286163636f756e7420637265617465642c206163636f756e742072656d6f76656429dc202d204442205765696768743a2031205265616420616e64203120577269746520746f2064657374696e6174696f6e206163636f756e741501202d204f726967696e206163636f756e7420697320616c726561647920696e206d656d6f72792c20736f206e6f204442206f7065726174696f6e7320666f72207468656d2e302023203c2f7765696768743e2c7365745f62616c616e63650c0c77686f8c3c543a3a4c6f6f6b7570206173205374617469634c6f6f6b75703e3a3a536f75726365206e65775f667265654c436f6d706163743c543a3a42616c616e63653e306e65775f72657365727665644c436f6d706163743c543a3a42616c616e63653e489420536574207468652062616c616e636573206f66206120676976656e206163636f756e742e00210120546869732077696c6c20616c74657220604672656542616c616e63656020616e642060526573657276656442616c616e63656020696e2073746f726167652e2069742077696c6c090120616c736f2064656372656173652074686520746f74616c2069737375616e6365206f66207468652073797374656d202860546f74616c49737375616e636560292e190120496620746865206e65772066726565206f722072657365727665642062616c616e63652069732062656c6f7720746865206578697374656e7469616c206465706f7369742c01012069742077696c6c20726573657420746865206163636f756e74206e6f6e63652028606672616d655f73797374656d3a3a4163636f756e744e6f6e636560292e00b420546865206469737061746368206f726967696e20666f7220746869732063616c6c2069732060726f6f74602e002c2023203c7765696768743e80202d20496e646570656e64656e74206f662074686520617267756d656e74732ec4202d20436f6e7461696e732061206c696d69746564206e756d626572206f6620726561647320616e64207772697465732e58202d2d2d2d2d2d2d2d2d2d2d2d2d2d2d2d2d2d2d2d2d3c202d2042617365205765696768743a6820202020202d204372656174696e673a2032372e353620c2b5736420202020202d204b696c6c696e673a2033352e313120c2b57398202d204442205765696768743a203120526561642c203120577269746520746f206077686f60302023203c2f7765696768743e38666f7263655f7472616e736665720c18736f757263658c3c543a3a4c6f6f6b7570206173205374617469634c6f6f6b75703e3a3a536f7572636510646573748c3c543a3a4c6f6f6b7570206173205374617469634c6f6f6b75703e3a3a536f757263651476616c75654c436f6d706163743c543a3a42616c616e63653e1851012045786163746c7920617320607472616e73666572602c2065786365707420746865206f726967696e206d75737420626520726f6f7420616e642074686520736f75726365206163636f756e74206d61792062652c207370656369666965642e2c2023203c7765696768743e4101202d2053616d65206173207472616e736665722c20627574206164646974696f6e616c207265616420616e6420777269746520626563617573652074686520736f75726365206163636f756e74206973902020206e6f7420617373756d656420746f20626520696e20746865206f7665726c61792e302023203c2f7765696768743e4c7472616e736665725f6b6565705f616c6976650810646573748c3c543a3a4c6f6f6b7570206173205374617469634c6f6f6b75703e3a3a536f757263651476616c75654c436f6d706163743c543a3a42616c616e63653e2c51012053616d6520617320746865205b607472616e73666572605d2063616c6c2c206275742077697468206120636865636b207468617420746865207472616e736665722077696c6c206e6f74206b696c6c2074686540206f726967696e206163636f756e742e00bc20393925206f66207468652074696d6520796f752077616e74205b607472616e73666572605d20696e73746561642e00c4205b607472616e73666572605d3a207374727563742e4d6f64756c652e68746d6c236d6574686f642e7472616e736665722c2023203c7765696768743ee8202d2043686561706572207468616e207472616e736665722062656361757365206163636f756e742063616e6e6f74206265206b696c6c65642e60202d2042617365205765696768743a2035312e3420c2b5731d01202d204442205765696768743a2031205265616420616e64203120577269746520746f2064657374202873656e64657220697320696e206f7665726c617920616c7265616479292c20233c2f7765696768743e01201c456e646f77656408244163636f756e7449641c42616c616e636504bc20416e206163636f756e74207761732063726561746564207769746820736f6d6520667265652062616c616e63652e20447573744c6f737408244163636f756e7449641c42616c616e636508410120416e206163636f756e74207761732072656d6f7665642077686f73652062616c616e636520776173206e6f6e2d7a65726f206275742062656c6f77204578697374656e7469616c4465706f7369742c7c20726573756c74696e6720696e20616e206f75747269676874206c6f73732e205472616e736665720c244163636f756e744964244163636f756e7449641c42616c616e63650498205472616e7366657220737563636565646564202866726f6d2c20746f2c2076616c7565292e2842616c616e63655365740c244163636f756e7449641c42616c616e63651c42616c616e636504c420412062616c616e6365207761732073657420627920726f6f74202877686f2c20667265652c207265736572766564292e1c4465706f73697408244163636f756e7449641c42616c616e636504dc20536f6d6520616d6f756e7420776173206465706f73697465642028652e672e20666f72207472616e73616374696f6e2066656573292e20526573657276656408244163636f756e7449641c42616c616e636504e420536f6d652062616c616e63652077617320726573657276656420286d6f7665642066726f6d206672656520746f207265736572766564292e28556e726573657276656408244163636f756e7449641c42616c616e636504ec20536f6d652062616c616e63652077617320756e726573657276656420286d6f7665642066726f6d20726573657276656420746f2066726565292e4852657365727665526570617472696174656410244163636f756e744964244163636f756e7449641c42616c616e63651853746174757308510120536f6d652062616c616e636520776173206d6f7665642066726f6d207468652072657365727665206f6620746865206669727374206163636f756e7420746f20746865207365636f6e64206163636f756e742edc2046696e616c20617267756d656e7420696e64696361746573207468652064657374696e6174696f6e2062616c616e636520747970652e04484578697374656e7469616c4465706f73697428543a3a42616c616e63654000407a10f35a0000000000000000000004d420546865206d696e696d756d20616d6f756e7420726571756972656420746f206b65657020616e206163636f756e74206f70656e2e203856657374696e6742616c616e6365049c2056657374696e672062616c616e636520746f6f206869676820746f2073656e642076616c7565544c69717569646974795265737472696374696f6e7304c8204163636f756e74206c6971756964697479207265737472696374696f6e732070726576656e74207769746864726177616c204f766572666c6f77047420476f7420616e206f766572666c6f7720616674657220616464696e674c496e73756666696369656e7442616c616e636504782042616c616e636520746f6f206c6f7720746f2073656e642076616c7565484578697374656e7469616c4465706f73697404ec2056616c756520746f6f206c6f7720746f20637265617465206163636f756e742064756520746f206578697374656e7469616c206465706f736974244b656570416c6976650490205472616e736665722f7061796d656e7420776f756c64206b696c6c206163636f756e745c4578697374696e6756657374696e675363686564756c6504cc20412076657374696e67207363686564756c6520616c72656164792065786973747320666f722074686973206163636f756e742c446561644163636f756e74048c2042656e6566696369617279206163636f756e74206d757374207072652d6578697374485472616e73616374696f6e5061796d656e7401485472616e73616374696f6e5061796d656e7408444e6578744665654d756c7469706c6965720100284d756c7469706c69657240000064a7b3b6e00d0000000000000000003853746f7261676556657273696f6e01002052656c6561736573040000000008485472616e73616374696f6e427974654665653042616c616e63654f663c543e4000e40b54020000000000000000000000040d01205468652066656520746f206265207061696420666f72206d616b696e672061207472616e73616374696f6e3b20746865207065722d6279746520706f7274696f6e2e2c576569676874546f466565a45665633c576569676874546f466565436f656666696369656e743c42616c616e63654f663c543e3e3e5c0401000000000000000000000000000000000000000001040d012054686520706f6c796e6f6d69616c2074686174206973206170706c69656420696e206f7264657220746f20646572697665206665652066726f6d207765696768742e001c5374616b696e67011c5374616b696e678c30486973746f7279446570746801000c75333210540000001c8c204e756d626572206f66206572617320746f206b65657020696e20686973746f72792e00390120496e666f726d6174696f6e206973206b65707420666f72206572617320696e20605b63757272656e745f657261202d20686973746f72795f64657074683b2063757272656e745f6572615d602e006101204d757374206265206d6f7265207468616e20746865206e756d626572206f6620657261732064656c617965642062792073657373696f6e206f74686572776973652e20492e652e2061637469766520657261206d757374390120616c7761797320626520696e20686973746f72792e20492e652e20606163746976655f657261203e2063757272656e745f657261202d20686973746f72795f646570746860206d757374206265302067756172616e746565642e3856616c696461746f72436f756e7401000c753332100000000004a82054686520696465616c206e756d626572206f66207374616b696e67207061727469636970616e74732e544d696e696d756d56616c696461746f72436f756e7401000c7533321004000000044101204d696e696d756d206e756d626572206f66207374616b696e67207061727469636970616e7473206265666f726520656d657267656e637920636f6e646974696f6e732061726520696d706f7365642e34496e76756c6e657261626c65730100445665633c543a3a4163636f756e7449643e04000c590120416e792076616c696461746f72732074686174206d6179206e6576657220626520736c6173686564206f7220666f726369626c79206b69636b65642e20497427732061205665632073696e636520746865792772654d01206561737920746f20696e697469616c697a6520616e642074686520706572666f726d616e636520686974206973206d696e696d616c2028776520657870656374206e6f206d6f7265207468616e20666f7572ac20696e76756c6e657261626c65732920616e64207265737472696374656420746f20746573746e6574732e18426f6e64656400010530543a3a4163636f756e74496430543a3a4163636f756e744964000400040101204d61702066726f6d20616c6c206c6f636b65642022737461736822206163636f756e747320746f2074686520636f6e74726f6c6c6572206163636f756e742e184c656467657200010230543a3a4163636f756e744964a45374616b696e674c65646765723c543a3a4163636f756e7449642c2042616c616e63654f663c543e3e000400044501204d61702066726f6d20616c6c2028756e6c6f636b6564292022636f6e74726f6c6c657222206163636f756e747320746f2074686520696e666f20726567617264696e6720746865207374616b696e672e14506179656501010530543a3a4163636f756e7449644452657761726444657374696e6174696f6e00040004e42057686572652074686520726577617264207061796d656e742073686f756c64206265206d6164652e204b657965642062792073746173682e2856616c696461746f727301010530543a3a4163636f756e7449643856616c696461746f72507265667300040004450120546865206d61702066726f6d202877616e6e616265292076616c696461746f72207374617368206b657920746f2074686520707265666572656e636573206f6620746861742076616c696461746f722e284e6f6d696e61746f727300010530543a3a4163636f756e744964644e6f6d696e6174696f6e733c543a3a4163636f756e7449643e00040004650120546865206d61702066726f6d206e6f6d696e61746f72207374617368206b657920746f2074686520736574206f66207374617368206b657973206f6620616c6c2076616c696461746f727320746f206e6f6d696e6174652e2843757272656e74457261000020457261496e6465780400105c205468652063757272656e742065726120696e6465782e006501205468697320697320746865206c617465737420706c616e6e6564206572612c20646570656e64696e67206f6e20686f77207468652053657373696f6e2070616c6c657420717565756573207468652076616c696461746f7280207365742c206974206d6967687420626520616374697665206f72206e6f742e24416374697665457261000034416374697665457261496e666f040010d820546865206163746976652065726120696e666f726d6174696f6e2c20697420686f6c647320696e64657820616e642073746172742e00b820546865206163746976652065726120697320746865206572612063757272656e746c792072657761726465642e2d012056616c696461746f7220736574206f66207468697320657261206d75737420626520657175616c20746f206053657373696f6e496e746572666163653a3a76616c696461746f7273602e5445726173537461727453657373696f6e496e64657800010520457261496e6465783053657373696f6e496e646578000400043101205468652073657373696f6e20696e646578206174207768696368207468652065726120737461727420666f7220746865206c6173742060484953544f52595f44455054486020657261732e2c457261735374616b65727301020520457261496e64657830543a3a4163636f756e744964904578706f737572653c543a3a4163636f756e7449642c2042616c616e63654f663c543e3e050c0000001878204578706f73757265206f662076616c696461746f72206174206572612e0061012054686973206973206b65796564206669727374206279207468652065726120696e64657820746f20616c6c6f772062756c6b2064656c6574696f6e20616e64207468656e20746865207374617368206163636f756e742e00a82049732069742072656d6f7665642061667465722060484953544f52595f44455054486020657261732e4101204966207374616b657273206861736e2774206265656e20736574206f7220686173206265656e2072656d6f766564207468656e20656d707479206578706f737572652069732072657475726e65642e48457261735374616b657273436c697070656401020520457261496e64657830543a3a4163636f756e744964904578706f737572653c543a3a4163636f756e7449642c2042616c616e63654f663c543e3e050c0000002c9820436c6970706564204578706f73757265206f662076616c696461746f72206174206572612e00590120546869732069732073696d696c617220746f205b60457261735374616b657273605d20627574206e756d626572206f66206e6f6d696e61746f7273206578706f736564206973207265647563656420746f20746865dc2060543a3a4d61784e6f6d696e61746f72526577617264656450657256616c696461746f72602062696767657374207374616b6572732e1d0120284e6f74653a20746865206669656c642060746f74616c6020616e6420606f776e60206f6620746865206578706f737572652072656d61696e7320756e6368616e676564292ef42054686973206973207573656420746f206c696d69742074686520692f6f20636f737420666f7220746865206e6f6d696e61746f72207061796f75742e005d012054686973206973206b657965642066697374206279207468652065726120696e64657820746f20616c6c6f772062756c6b2064656c6574696f6e20616e64207468656e20746865207374617368206163636f756e742e00a82049732069742072656d6f7665642061667465722060484953544f52595f44455054486020657261732e4101204966207374616b657273206861736e2774206265656e20736574206f7220686173206265656e2072656d6f766564207468656e20656d707479206578706f737572652069732072657475726e65642e484572617356616c696461746f72507265667301020520457261496e64657830543a3a4163636f756e7449643856616c696461746f7250726566730504001411012053696d696c617220746f2060457261735374616b657273602c207468697320686f6c64732074686520707265666572656e636573206f662076616c696461746f72732e0061012054686973206973206b65796564206669727374206279207468652065726120696e64657820746f20616c6c6f772062756c6b2064656c6574696f6e20616e64207468656e20746865207374617368206163636f756e742e00a82049732069742072656d6f7665642061667465722060484953544f52595f44455054486020657261732e4c4572617356616c696461746f7252657761726400010520457261496e6465783042616c616e63654f663c543e0004000c09012054686520746f74616c2076616c696461746f7220657261207061796f757420666f7220746865206c6173742060484953544f52595f44455054486020657261732e0021012045726173207468617420686176656e27742066696e697368656420796574206f7220686173206265656e2072656d6f76656420646f65736e27742068617665207265776172642e4045726173526577617264506f696e747301010520457261496e64657874457261526577617264506f696e74733c543a3a4163636f756e7449643e0014000000000008ac205265776172647320666f7220746865206c6173742060484953544f52595f44455054486020657261732e250120496620726577617264206861736e2774206265656e20736574206f7220686173206265656e2072656d6f766564207468656e2030207265776172642069732072657475726e65642e3845726173546f74616c5374616b6501010520457261496e6465783042616c616e63654f663c543e00400000000000000000000000000000000008ec2054686520746f74616c20616d6f756e74207374616b656420666f7220746865206c6173742060484953544f52595f44455054486020657261732e1d0120496620746f74616c206861736e2774206265656e20736574206f7220686173206265656e2072656d6f766564207468656e2030207374616b652069732072657475726e65642e20466f72636545726101001c466f7263696e6704000454204d6f6465206f662065726120666f7263696e672e4c536c6173685265776172644672616374696f6e01001c50657262696c6c10000000000cf8205468652070657263656e74616765206f662074686520736c617368207468617420697320646973747269627574656420746f207265706f72746572732e00e4205468652072657374206f662074686520736c61736865642076616c75652069732068616e646c6564206279207468652060536c617368602e4c43616e63656c6564536c6173685061796f757401003042616c616e63654f663c543e40000000000000000000000000000000000815012054686520616d6f756e74206f662063757272656e637920676976656e20746f207265706f7274657273206f66206120736c617368206576656e7420776869636820776173ec2063616e63656c65642062792065787472616f7264696e6172792063697263756d7374616e6365732028652e672e20676f7665726e616e6365292e40556e6170706c696564536c617368657301010520457261496e646578bc5665633c556e6170706c696564536c6173683c543a3a4163636f756e7449642c2042616c616e63654f663c543e3e3e00040004c420416c6c20756e6170706c69656420736c61736865732074686174206172652071756575656420666f72206c617465722e28426f6e646564457261730100745665633c28457261496e6465782c2053657373696f6e496e646578293e04001025012041206d617070696e672066726f6d207374696c6c2d626f6e646564206572617320746f207468652066697273742073657373696f6e20696e646578206f662074686174206572612e00c8204d75737420636f6e7461696e7320696e666f726d6174696f6e20666f72206572617320666f72207468652072616e67653abc20605b6163746976655f657261202d20626f756e64696e675f6475726174696f6e3b206163746976655f6572615d604c56616c696461746f72536c617368496e45726100020520457261496e64657830543a3a4163636f756e7449645c2850657262696c6c2c2042616c616e63654f663c543e2905040008450120416c6c20736c617368696e67206576656e7473206f6e2076616c696461746f72732c206d61707065642062792065726120746f20746865206869676865737420736c6173682070726f706f7274696f6e7020616e6420736c6173682076616c7565206f6620746865206572612e4c4e6f6d696e61746f72536c617368496e45726100020520457261496e64657830543a3a4163636f756e7449643042616c616e63654f663c543e05040004610120416c6c20736c617368696e67206576656e7473206f6e206e6f6d696e61746f72732c206d61707065642062792065726120746f20746865206869676865737420736c6173682076616c7565206f6620746865206572612e34536c617368696e675370616e7300010530543a3a4163636f756e7449645c736c617368696e673a3a536c617368696e675370616e73000400048c20536c617368696e67207370616e7320666f72207374617368206163636f756e74732e245370616e536c6173680101058c28543a3a4163636f756e7449642c20736c617368696e673a3a5370616e496e6465782988736c617368696e673a3a5370616e5265636f72643c42616c616e63654f663c543e3e00800000000000000000000000000000000000000000000000000000000000000000083d01205265636f72647320696e666f726d6174696f6e2061626f757420746865206d6178696d756d20736c617368206f6620612073746173682077697468696e206120736c617368696e67207370616e2cb82061732077656c6c20617320686f77206d7563682072657761726420686173206265656e2070616964206f75742e584561726c69657374556e6170706c696564536c617368000020457261496e646578040004fc20546865206561726c696573742065726120666f72207768696368207765206861766520612070656e64696e672c20756e6170706c69656420736c6173682e48536e617073686f7456616c696461746f72730000445665633c543a3a4163636f756e7449643e040008650120536e617073686f74206f662076616c696461746f72732061742074686520626567696e6e696e67206f66207468652063757272656e7420656c656374696f6e2077696e646f772e20546869732073686f756c64206f6e6c791901206861766520612076616c7565207768656e205b60457261456c656374696f6e537461747573605d203d3d2060456c656374696f6e5374617475733a3a4f70656e285f29602e48536e617073686f744e6f6d696e61746f72730000445665633c543a3a4163636f756e7449643e040008650120536e617073686f74206f66206e6f6d696e61746f72732061742074686520626567696e6e696e67206f66207468652063757272656e7420656c656374696f6e2077696e646f772e20546869732073686f756c64206f6e6c791901206861766520612076616c7565207768656e205b60457261456c656374696f6e537461747573605d203d3d2060456c656374696f6e5374617475733a3a4f70656e285f29602e34517565756564456c65637465640000a8456c656374696f6e526573756c743c543a3a4163636f756e7449642c2042616c616e63654f663c543e3e04000c650120546865206e6578742076616c696461746f72207365742e2041742074686520656e64206f6620616e206572612c206966207468697320697320617661696c61626c652028706f74656e7469616c6c792066726f6d20746865610120726573756c74206f6620616e206f6666636861696e20776f726b6572292c20697420697320696d6d6564696174656c7920757365642e204f74686572776973652c20746865206f6e2d636861696e20656c656374696f6e342069732065786563757465642e2c51756575656453636f7265000034456c656374696f6e53636f7265040004b0205468652073636f7265206f66207468652063757272656e74205b60517565756564456c6563746564605d2e44457261456c656374696f6e537461747573010078456c656374696f6e5374617475733c543a3a426c6f636b4e756d6265723e040008490120466c616720746f20636f6e74726f6c2074686520657865637574696f6e206f6620746865206f6666636861696e20656c656374696f6e2e205768656e20604f70656e285f29602c207765206163636570746c20736f6c7574696f6e7320746f206265207375626d69747465642e54497343757272656e7453657373696f6e46696e616c010010626f6f6c0400084d012054727565206966207468652063757272656e74202a2a706c616e6e65642a2a2073657373696f6e2069732066696e616c2e204e6f74652074686174207468697320646f6573206e6f742074616b65206572615820666f7263696e6720696e746f206163636f756e742e3853746f7261676556657273696f6e01002052656c6561736573040310cc2054727565206966206e6574776f726b20686173206265656e20757067726164656420746f20746869732076657273696f6e2e7c2053746f726167652076657273696f6e206f66207468652070616c6c65742e00a020546869732069732073657420746f2076332e302e3020666f72206e6577206e6574776f726b732e016010626f6e640c28636f6e74726f6c6c65728c3c543a3a4c6f6f6b7570206173205374617469634c6f6f6b75703e3a3a536f757263651476616c756554436f6d706163743c42616c616e63654f663c543e3e1470617965654452657761726444657374696e6174696f6e5865012054616b6520746865206f726967696e206163636f756e74206173206120737461736820616e64206c6f636b207570206076616c756560206f66206974732062616c616e63652e2060636f6e74726f6c6c6572602077696c6c8420626520746865206163636f756e74207468617420636f6e74726f6c732069742e003101206076616c756560206d757374206265206d6f7265207468616e2074686520606d696e696d756d5f62616c616e636560207370656369666965642062792060543a3a43757272656e6379602e00250120546865206469737061746368206f726967696e20666f7220746869732063616c6c206d757374206265205f5369676e65645f20627920746865207374617368206163636f756e742e004020456d6974732060426f6e646564602e002c2023203c7765696768743ed4202d20496e646570656e64656e74206f662074686520617267756d656e74732e204d6f64657261746520636f6d706c65786974792e20202d204f2831292e68202d20546872656520657874726120444220656e74726965732e005101204e4f54453a2054776f206f66207468652073746f726167652077726974657320286053656c663a3a626f6e646564602c206053656c663a3a7061796565602920617265205f6e657665725f20636c65616e6564410120756e6c6573732074686520606f726967696e602066616c6c732062656c6f77205f6578697374656e7469616c206465706f7369745f20616e6420676574732072656d6f76656420617320647573742e4c202d2d2d2d2d2d2d2d2d2d2d2d2d2d2d2d2d2d5c2042617365205765696768743a2036372e383720c2b5732c204442205765696768743a3101202d20526561643a20426f6e6465642c204c65646765722c205b4f726967696e204163636f756e745d2c2043757272656e74204572612c20486973746f72792044657074682c204c6f636b73e0202d2057726974653a20426f6e6465642c2050617965652c205b4f726967696e204163636f756e745d2c204c6f636b732c204c6564676572302023203c2f7765696768743e28626f6e645f657874726104386d61785f6164646974696f6e616c54436f6d706163743c42616c616e63654f663c543e3e5865012041646420736f6d6520657874726120616d6f756e742074686174206861766520617070656172656420696e207468652073746173682060667265655f62616c616e63656020696e746f207468652062616c616e63652075703420666f72207374616b696e672e00510120557365207468697320696620746865726520617265206164646974696f6e616c2066756e647320696e20796f7572207374617368206163636f756e74207468617420796f75207769736820746f20626f6e642e650120556e6c696b65205b60626f6e64605d206f72205b60756e626f6e64605d20746869732066756e6374696f6e20646f6573206e6f7420696d706f736520616e79206c696d69746174696f6e206f6e2074686520616d6f756e744c20746861742063616e2062652061646465642e00610120546865206469737061746368206f726967696e20666f7220746869732063616c6c206d757374206265205f5369676e65645f206279207468652073746173682c206e6f742074686520636f6e74726f6c6c657220616e64f82069742063616e206265206f6e6c792063616c6c6564207768656e205b60457261456c656374696f6e537461747573605d2069732060436c6f736564602e004020456d6974732060426f6e646564602e002c2023203c7765696768743ee8202d20496e646570656e64656e74206f662074686520617267756d656e74732e20496e7369676e69666963616e7420636f6d706c65786974792e20202d204f2831292e40202d204f6e6520444220656e7472792e34202d2d2d2d2d2d2d2d2d2d2d2d5c2042617365205765696768743a2035342e383820c2b5732c204442205765696768743a1501202d20526561643a2045726120456c656374696f6e205374617475732c20426f6e6465642c204c65646765722c205b4f726967696e204163636f756e745d2c204c6f636b73a4202d2057726974653a205b4f726967696e204163636f756e745d2c204c6f636b732c204c6564676572302023203c2f7765696768743e18756e626f6e64041476616c756554436f6d706163743c42616c616e63654f663c543e3e805501205363686564756c65206120706f7274696f6e206f662074686520737461736820746f20626520756e6c6f636b656420726561647920666f72207472616e73666572206f75742061667465722074686520626f6e64010120706572696f6420656e64732e2049662074686973206c656176657320616e20616d6f756e74206163746976656c7920626f6e646564206c657373207468616e250120543a3a43757272656e63793a3a6d696e696d756d5f62616c616e636528292c207468656e20697420697320696e6372656173656420746f207468652066756c6c20616d6f756e742e004901204f6e63652074686520756e6c6f636b20706572696f6420697320646f6e652c20796f752063616e2063616c6c206077697468647261775f756e626f6e6465646020746f2061637475616c6c79206d6f7665c0207468652066756e6473206f7574206f66206d616e6167656d656e7420726561647920666f72207472616e736665722e003d01204e6f206d6f7265207468616e2061206c696d69746564206e756d626572206f6620756e6c6f636b696e67206368756e6b73202873656520604d41585f554e4c4f434b494e475f4348554e4b5360293d012063616e20636f2d657869737473206174207468652073616d652074696d652e20496e207468617420636173652c205b6043616c6c3a3a77697468647261775f756e626f6e646564605d206e656564fc20746f2062652063616c6c656420666972737420746f2072656d6f766520736f6d65206f6620746865206368756e6b732028696620706f737369626c65292e00550120546865206469737061746368206f726967696e20666f7220746869732063616c6c206d757374206265205f5369676e65645f2062792074686520636f6e74726f6c6c65722c206e6f74207468652073746173682e0d0120416e642c2069742063616e206265206f6e6c792063616c6c6564207768656e205b60457261456c656374696f6e537461747573605d2069732060436c6f736564602e004820456d6974732060556e626f6e646564602e00982053656520616c736f205b6043616c6c3a3a77697468647261775f756e626f6e646564605d2e002c2023203c7765696768743e4101202d20496e646570656e64656e74206f662074686520617267756d656e74732e204c696d697465642062757420706f74656e7469616c6c79206578706c6f697461626c6520636f6d706c65786974792e98202d20436f6e7461696e732061206c696d69746564206e756d626572206f662072656164732e6501202d20456163682063616c6c20287265717569726573207468652072656d61696e646572206f662074686520626f6e6465642062616c616e636520746f2062652061626f766520606d696e696d756d5f62616c616e63656029710120202077696c6c2063617573652061206e657720656e74727920746f20626520696e73657274656420696e746f206120766563746f722028604c65646765722e756e6c6f636b696e676029206b65707420696e2073746f726167652e5101202020546865206f6e6c792077617920746f20636c65616e207468652061666f72656d656e74696f6e65642073746f72616765206974656d20697320616c736f20757365722d636f6e74726f6c6c6564207669615c2020206077697468647261775f756e626f6e646564602e40202d204f6e6520444220656e7472792e2c202d2d2d2d2d2d2d2d2d2d5c2042617365205765696768743a2035302e333420c2b5732c204442205765696768743a2901202d20526561643a2045726120456c656374696f6e205374617475732c204c65646765722c2043757272656e74204572612c204c6f636b732c205b4f726967696e204163636f756e745da4202d2057726974653a205b4f726967696e204163636f756e745d2c204c6f636b732c204c656467657228203c2f7765696768743e4477697468647261775f756e626f6e64656404486e756d5f736c617368696e675f7370616e730c753332782d012052656d6f766520616e7920756e6c6f636b6564206368756e6b732066726f6d207468652060756e6c6f636b696e67602071756575652066726f6d206f7572206d616e6167656d656e742e003501205468697320657373656e7469616c6c7920667265657320757020746861742062616c616e636520746f206265207573656420627920746865207374617368206163636f756e7420746f20646f4c2077686174657665722069742077616e74732e00550120546865206469737061746368206f726967696e20666f7220746869732063616c6c206d757374206265205f5369676e65645f2062792074686520636f6e74726f6c6c65722c206e6f74207468652073746173682e0d0120416e642c2069742063616e206265206f6e6c792063616c6c6564207768656e205b60457261456c656374696f6e537461747573605d2069732060436c6f736564602e004c20456d697473206057697468647261776e602e006c2053656520616c736f205b6043616c6c3a3a756e626f6e64605d2e002c2023203c7765696768743e5501202d20436f756c6420626520646570656e64656e74206f6e2074686520606f726967696e6020617267756d656e7420616e6420686f77206d7563682060756e6c6f636b696e6760206368756e6b732065786973742e45012020497420696d706c6965732060636f6e736f6c69646174655f756e6c6f636b656460207768696368206c6f6f7073206f76657220604c65646765722e756e6c6f636b696e67602c207768696368206973f42020696e6469726563746c7920757365722d636f6e74726f6c6c65642e20536565205b60756e626f6e64605d20666f72206d6f72652064657461696c2e7901202d20436f6e7461696e732061206c696d69746564206e756d626572206f662072656164732c20796574207468652073697a65206f6620776869636820636f756c64206265206c61726765206261736564206f6e20606c6564676572602ec8202d2057726974657320617265206c696d6974656420746f2074686520606f726967696e60206163636f756e74206b65792e40202d2d2d2d2d2d2d2d2d2d2d2d2d2d2d090120436f6d706c6578697479204f285329207768657265205320697320746865206e756d626572206f6620736c617368696e67207370616e7320746f2072656d6f7665342042617365205765696768743a74205570646174653a2035302e3532202b202e303238202a205320c2b5732501202d2052656164733a20457261456c656374696f6e5374617475732c204c65646765722c2043757272656e74204572612c204c6f636b732c205b4f726967696e204163636f756e745da8202d205772697465733a205b4f726967696e204163636f756e745d2c204c6f636b732c204c656467657270204b696c6c3a2037392e3431202b20322e333636202a205320c2b5738501202d2052656164733a20457261456c656374696f6e5374617475732c204c65646765722c2043757272656e74204572612c20426f6e6465642c20536c617368696e67205370616e732c205b4f726967696e204163636f756e745d2c204c6f636b73b101202d205772697465733a20426f6e6465642c20536c617368696e67205370616e73202869662053203e2030292c204c65646765722c2050617965652c2056616c696461746f72732c204e6f6d696e61746f72732c205b4f726967696e204163636f756e745d2c204c6f636b7374202d2057726974657320456163683a205370616e536c617368202a20530d01204e4f54453a2057656967687420616e6e6f746174696f6e20697320746865206b696c6c207363656e6172696f2c20776520726566756e64206f74686572776973652e302023203c2f7765696768743e2076616c6964617465041470726566733856616c696461746f72507265667344e8204465636c617265207468652064657369726520746f2076616c696461746520666f7220746865206f726967696e20636f6e74726f6c6c65722e00dc20456666656374732077696c6c2062652066656c742061742074686520626567696e6e696e67206f6620746865206e657874206572612e00550120546865206469737061746368206f726967696e20666f7220746869732063616c6c206d757374206265205f5369676e65645f2062792074686520636f6e74726f6c6c65722c206e6f74207468652073746173682e0d0120416e642c2069742063616e206265206f6e6c792063616c6c6564207768656e205b60457261456c656374696f6e537461747573605d2069732060436c6f736564602e002c2023203c7765696768743ee8202d20496e646570656e64656e74206f662074686520617267756d656e74732e20496e7369676e69666963616e7420636f6d706c65786974792e98202d20436f6e7461696e732061206c696d69746564206e756d626572206f662072656164732ec8202d2057726974657320617265206c696d6974656420746f2074686520606f726967696e60206163636f756e74206b65792e30202d2d2d2d2d2d2d2d2d2d2d5c2042617365205765696768743a2031372e313320c2b5732c204442205765696768743a90202d20526561643a2045726120456c656374696f6e205374617475732c204c656467657280202d2057726974653a204e6f6d696e61746f72732c2056616c696461746f7273302023203c2f7765696768743e206e6f6d696e617465041c74617267657473a05665633c3c543a3a4c6f6f6b7570206173205374617469634c6f6f6b75703e3a3a536f757263653e4c1101204465636c617265207468652064657369726520746f206e6f6d696e6174652060746172676574736020666f7220746865206f726967696e20636f6e74726f6c6c65722e00510120456666656374732077696c6c2062652066656c742061742074686520626567696e6e696e67206f6620746865206e657874206572612e20546869732063616e206f6e6c792062652063616c6c6564207768656e8c205b60457261456c656374696f6e537461747573605d2069732060436c6f736564602e00550120546865206469737061746368206f726967696e20666f7220746869732063616c6c206d757374206265205f5369676e65645f2062792074686520636f6e74726f6c6c65722c206e6f74207468652073746173682e0d0120416e642c2069742063616e206265206f6e6c792063616c6c6564207768656e205b60457261456c656374696f6e537461747573605d2069732060436c6f736564602e002c2023203c7765696768743e3101202d20546865207472616e73616374696f6e277320636f6d706c65786974792069732070726f706f7274696f6e616c20746f207468652073697a65206f662060746172676574736020284e2901012077686963682069732063617070656420617420436f6d7061637441737369676e6d656e74733a3a4c494d495420284d41585f4e4f4d494e4154494f4e53292ed8202d20426f74682074686520726561647320616e642077726974657320666f6c6c6f7720612073696d696c6172207061747465726e2e28202d2d2d2d2d2d2d2d2d842042617365205765696768743a2032322e3334202b202e3336202a204e20c2b57384207768657265204e20697320746865206e756d626572206f6620746172676574732c204442205765696768743ac8202d2052656164733a2045726120456c656374696f6e205374617475732c204c65646765722c2043757272656e742045726184202d205772697465733a2056616c696461746f72732c204e6f6d696e61746f7273302023203c2f7765696768743e146368696c6c0044c8204465636c617265206e6f2064657369726520746f206569746865722076616c6964617465206f72206e6f6d696e6174652e00dc20456666656374732077696c6c2062652066656c742061742074686520626567696e6e696e67206f6620746865206e657874206572612e00550120546865206469737061746368206f726967696e20666f7220746869732063616c6c206d757374206265205f5369676e65645f2062792074686520636f6e74726f6c6c65722c206e6f74207468652073746173682e0d0120416e642c2069742063616e206265206f6e6c792063616c6c6564207768656e205b60457261456c656374696f6e537461747573605d2069732060436c6f736564602e002c2023203c7765696768743ee8202d20496e646570656e64656e74206f662074686520617267756d656e74732e20496e7369676e69666963616e7420636f6d706c65786974792e54202d20436f6e7461696e73206f6e6520726561642ec8202d2057726974657320617265206c696d6974656420746f2074686520606f726967696e60206163636f756e74206b65792e24202d2d2d2d2d2d2d2d5c2042617365205765696768743a2031362e353320c2b5732c204442205765696768743a88202d20526561643a20457261456c656374696f6e5374617475732c204c656467657280202d2057726974653a2056616c696461746f72732c204e6f6d696e61746f7273302023203c2f7765696768743e247365745f7061796565041470617965654452657761726444657374696e6174696f6e40b8202852652d2973657420746865207061796d656e742074617267657420666f72206120636f6e74726f6c6c65722e00dc20456666656374732077696c6c2062652066656c742061742074686520626567696e6e696e67206f6620746865206e657874206572612e00550120546865206469737061746368206f726967696e20666f7220746869732063616c6c206d757374206265205f5369676e65645f2062792074686520636f6e74726f6c6c65722c206e6f74207468652073746173682e002c2023203c7765696768743ee8202d20496e646570656e64656e74206f662074686520617267756d656e74732e20496e7369676e69666963616e7420636f6d706c65786974792e98202d20436f6e7461696e732061206c696d69746564206e756d626572206f662072656164732ec8202d2057726974657320617265206c696d6974656420746f2074686520606f726967696e60206163636f756e74206b65792e28202d2d2d2d2d2d2d2d2d64202d2042617365205765696768743a2031312e333320c2b57334202d204442205765696768743a4c20202020202d20526561643a204c65646765724c20202020202d2057726974653a205061796565302023203c2f7765696768743e387365745f636f6e74726f6c6c65720428636f6e74726f6c6c65728c3c543a3a4c6f6f6b7570206173205374617469634c6f6f6b75703e3a3a536f757263654090202852652d297365742074686520636f6e74726f6c6c6572206f6620612073746173682e00dc20456666656374732077696c6c2062652066656c742061742074686520626567696e6e696e67206f6620746865206e657874206572612e00550120546865206469737061746368206f726967696e20666f7220746869732063616c6c206d757374206265205f5369676e65645f206279207468652073746173682c206e6f742074686520636f6e74726f6c6c65722e002c2023203c7765696768743ee8202d20496e646570656e64656e74206f662074686520617267756d656e74732e20496e7369676e69666963616e7420636f6d706c65786974792e98202d20436f6e7461696e732061206c696d69746564206e756d626572206f662072656164732ec8202d2057726974657320617265206c696d6974656420746f2074686520606f726967696e60206163636f756e74206b65792e2c202d2d2d2d2d2d2d2d2d2d5c2042617365205765696768743a2032352e323220c2b5732c204442205765696768743af4202d20526561643a20426f6e6465642c204c6564676572204e657720436f6e74726f6c6c65722c204c6564676572204f6c6420436f6e74726f6c6c6572f8202d2057726974653a20426f6e6465642c204c6564676572204e657720436f6e74726f6c6c65722c204c6564676572204f6c6420436f6e74726f6c6c6572302023203c2f7765696768743e4c7365745f76616c696461746f725f636f756e74040c6e657730436f6d706163743c7533323e209420536574732074686520696465616c206e756d626572206f662076616c696461746f72732e008820546865206469737061746368206f726967696e206d75737420626520526f6f742e002c2023203c7765696768743e5c2042617365205765696768743a20312e37313720c2b5735c2057726974653a2056616c696461746f7220436f756e74302023203c2f7765696768743e60696e6372656173655f76616c696461746f725f636f756e7404286164646974696f6e616c30436f6d706163743c7533323e20ac20496e6372656d656e74732074686520696465616c206e756d626572206f662076616c696461746f72732e008820546865206469737061746368206f726967696e206d75737420626520526f6f742e002c2023203c7765696768743e5c2042617365205765696768743a20312e37313720c2b5737020526561642f57726974653a2056616c696461746f7220436f756e74302023203c2f7765696768743e547363616c655f76616c696461746f725f636f756e740418666163746f721c50657263656e7420d4205363616c652075702074686520696465616c206e756d626572206f662076616c696461746f7273206279206120666163746f722e008820546865206469737061746368206f726967696e206d75737420626520526f6f742e002c2023203c7765696768743e5c2042617365205765696768743a20312e37313720c2b5737020526561642f57726974653a2056616c696461746f7220436f756e74302023203c2f7765696768743e34666f7263655f6e6f5f657261730024b020466f72636520746865726520746f206265206e6f206e6577206572617320696e646566696e6974656c792e008820546865206469737061746368206f726967696e206d75737420626520526f6f742e002c2023203c7765696768743e40202d204e6f20617267756d656e74732e64202d2042617365205765696768743a20312e38353720c2b57348202d2057726974653a20466f726365457261302023203c2f7765696768743e34666f7263655f6e65775f65726100284d0120466f72636520746865726520746f2062652061206e6577206572612061742074686520656e64206f6620746865206e6578742073657373696f6e2e20416674657220746869732c2069742077696c6c206265a020726573657420746f206e6f726d616c20286e6f6e2d666f7263656429206265686176696f75722e008820546865206469737061746368206f726967696e206d75737420626520526f6f742e002c2023203c7765696768743e40202d204e6f20617267756d656e74732e64202d2042617365205765696768743a20312e39353920c2b57344202d20577269746520466f726365457261302023203c2f7765696768743e447365745f696e76756c6e657261626c6573042876616c696461746f7273445665633c543a3a4163636f756e7449643e24cc20536574207468652076616c696461746f72732077686f2063616e6e6f7420626520736c61736865642028696620616e79292e008820546865206469737061746368206f726967696e206d75737420626520526f6f742e002c2023203c7765696768743e1c202d204f28562990202d2042617365205765696768743a20322e323038202b202e303036202a205620c2b5735c202d2057726974653a20496e76756c6e657261626c6573302023203c2f7765696768743e34666f7263655f756e7374616b650814737461736830543a3a4163636f756e744964486e756d5f736c617368696e675f7370616e730c7533322c0d0120466f72636520612063757272656e74207374616b657220746f206265636f6d6520636f6d706c6574656c7920756e7374616b65642c20696d6d6564696174656c792e008820546865206469737061746368206f726967696e206d75737420626520526f6f742e002c2023203c7765696768743eec204f285329207768657265205320697320746865206e756d626572206f6620736c617368696e67207370616e7320746f2062652072656d6f7665648c2042617365205765696768743a2035332e3037202b20322e333635202a205320c2b573b82052656164733a20426f6e6465642c20536c617368696e67205370616e732c204163636f756e742c204c6f636b738501205772697465733a20426f6e6465642c20536c617368696e67205370616e73202869662053203e2030292c204c65646765722c2050617965652c2056616c696461746f72732c204e6f6d696e61746f72732c204163636f756e742c204c6f636b736c2057726974657320456163683a205370616e536c617368202a2053302023203c2f7765696768743e50666f7263655f6e65775f6572615f616c776179730020050120466f72636520746865726520746f2062652061206e6577206572612061742074686520656e64206f662073657373696f6e7320696e646566696e6974656c792e008820546865206469737061746368206f726967696e206d75737420626520526f6f742e002c2023203c7765696768743e60202d2042617365205765696768743a20322e303520c2b57348202d2057726974653a20466f726365457261302023203c2f7765696768743e5463616e63656c5f64656665727265645f736c617368080c65726120457261496e64657834736c6173685f696e6469636573205665633c7533323e38982043616e63656c20656e6163746d656e74206f66206120646566657272656420736c6173682e00b42043616e2062652063616c6c6564206279207468652060543a3a536c61736843616e63656c4f726967696e602e00050120506172616d65746572733a2065726120616e6420696e6469636573206f662074686520736c617368657320666f7220746861742065726120746f206b696c6c2e002c2023203c7765696768743e5420436f6d706c65786974793a204f2855202b205329b82077697468205520756e6170706c69656420736c6173686573207765696768746564207769746820553d31303030d420616e64205320697320746865206e756d626572206f6620736c61736820696e646963657320746f2062652063616e63656c65642e74202d20426173653a2035383730202b2033342e3631202a205320c2b57368202d20526561643a20556e6170706c69656420536c61736865736c202d2057726974653a20556e6170706c69656420536c6173686573302023203c2f7765696768743e387061796f75745f7374616b657273083c76616c696461746f725f737461736830543a3a4163636f756e7449640c65726120457261496e64657864110120506179206f757420616c6c20746865207374616b65727320626568696e6420612073696e676c652076616c696461746f7220666f7220612073696e676c65206572612e004d01202d206076616c696461746f725f73746173686020697320746865207374617368206163636f756e74206f66207468652076616c696461746f722e205468656972206e6f6d696e61746f72732c20757020746f290120202060543a3a4d61784e6f6d696e61746f72526577617264656450657256616c696461746f72602c2077696c6c20616c736f207265636569766520746865697220726577617264732e3501202d206065726160206d617920626520616e7920657261206265747765656e20605b63757272656e745f657261202d20686973746f72795f64657074683b2063757272656e745f6572615d602e00590120546865206f726967696e206f6620746869732063616c6c206d757374206265205f5369676e65645f2e20416e79206163636f756e742063616e2063616c6c20746869732066756e6374696f6e2c206576656e20696678206974206973206e6f74206f6e65206f6620746865207374616b6572732e00010120546869732063616e206f6e6c792062652063616c6c6564207768656e205b60457261456c656374696f6e537461747573605d2069732060436c6f736564602e002c2023203c7765696768743e0101202d2054696d6520636f6d706c65786974793a206174206d6f7374204f284d61784e6f6d696e61746f72526577617264656450657256616c696461746f72292ec4202d20436f6e7461696e732061206c696d69746564206e756d626572206f6620726561647320616e64207772697465732e30202d2d2d2d2d2d2d2d2d2d2d1d01204e20697320746865204e756d626572206f66207061796f75747320666f72207468652076616c696461746f722028696e636c7564696e67207468652076616c696461746f7229342042617365205765696768743a0101202d205265776172642044657374696e6174696f6e205374616b65643a20313130202b2035342e32202a204e20c2b57320284d656469616e20536c6f706573294101202d205265776172642044657374696e6174696f6e20436f6e74726f6c6c657220284372656174696e67293a20313230202b2034312e3935202a204e20c2b57320284d656469616e20536c6f706573292c204442205765696768743a2901202d20526561643a20457261456c656374696f6e5374617475732c2043757272656e744572612c20486973746f727944657074682c204572617356616c696461746f725265776172642c2d01202020202020202020457261735374616b657273436c69707065642c2045726173526577617264506f696e74732c204572617356616c696461746f725072656673202838206974656d73291101202d205265616420456163683a20426f6e6465642c204c65646765722c2050617965652c204c6f636b732c2053797374656d204163636f756e74202835206974656d7329d8202d20577269746520456163683a2053797374656d204163636f756e742c204c6f636b732c204c6564676572202833206974656d7329302023203c2f7765696768743e187265626f6e64041476616c756554436f6d706163743c42616c616e63654f663c543e3e3ce0205265626f6e64206120706f7274696f6e206f6620746865207374617368207363686564756c656420746f20626520756e6c6f636b65642e00550120546865206469737061746368206f726967696e206d757374206265207369676e65642062792074686520636f6e74726f6c6c65722c20616e642069742063616e206265206f6e6c792063616c6c6564207768656e8c205b60457261456c656374696f6e537461747573605d2069732060436c6f736564602e002c2023203c7765696768743ed4202d2054696d6520636f6d706c65786974793a204f284c292c207768657265204c20697320756e6c6f636b696e67206368756e6b7394202d20426f756e64656420627920604d41585f554e4c4f434b494e475f4348554e4b53602ef4202d2053746f72616765206368616e6765733a2043616e277420696e6372656173652073746f726167652c206f6e6c792064656372656173652069742e40202d2d2d2d2d2d2d2d2d2d2d2d2d2d2d98202d2042617365205765696768743a2033342e353120c2b573202a202e303438204c20c2b57334202d204442205765696768743a010120202020202d2052656164733a20457261456c656374696f6e5374617475732c204c65646765722c204c6f636b732c205b4f726967696e204163636f756e745db820202020202d205772697465733a205b4f726967696e204163636f756e745d2c204c6f636b732c204c6564676572302023203c2f7765696768743e447365745f686973746f72795f646570746808446e65775f686973746f72795f646570746844436f6d706163743c457261496e6465783e485f6572615f6974656d735f64656c6574656430436f6d706163743c7533323e543101205365742060486973746f72794465707468602076616c75652e20546869732066756e6374696f6e2077696c6c2064656c65746520616e7920686973746f727920696e666f726d6174696f6e80207768656e2060486973746f727944657074686020697320726564756365642e003020506172616d65746572733a1101202d20606e65775f686973746f72795f6465707468603a20546865206e657720686973746f727920646570746820796f7520776f756c64206c696b6520746f207365742e4901202d20606572615f6974656d735f64656c65746564603a20546865206e756d626572206f66206974656d7320746861742077696c6c2062652064656c6574656420627920746869732064697370617463682e450120202020546869732073686f756c64207265706f727420616c6c207468652073746f72616765206974656d7320746861742077696c6c2062652064656c6574656420627920636c656172696e67206f6c6445012020202065726120686973746f72792e204e656564656420746f207265706f727420616e2061636375726174652077656967687420666f72207468652064697370617463682e2054727573746564206279a02020202060526f6f746020746f207265706f727420616e206163637572617465206e756d6265722e0054204f726967696e206d75737420626520726f6f742e002c2023203c7765696768743ee0202d20453a204e756d626572206f6620686973746f7279206465707468732072656d6f7665642c20692e652e203130202d3e2037203d203374202d2042617365205765696768743a2032392e3133202a204520c2b57334202d204442205765696768743aa020202020202d2052656164733a2043757272656e74204572612c20486973746f72792044657074687020202020202d205772697465733a20486973746f7279204465707468310120202020202d20436c6561722050726566697820456163683a20457261205374616b6572732c204572615374616b657273436c69707065642c204572617356616c696461746f725072656673810120202020202d2057726974657320456163683a204572617356616c696461746f725265776172642c2045726173526577617264506f696e74732c2045726173546f74616c5374616b652c2045726173537461727453657373696f6e496e646578302023203c2f7765696768743e28726561705f73746173680814737461736830543a3a4163636f756e744964486e756d5f736c617368696e675f7370616e730c7533324039012052656d6f766520616c6c20646174612073747275637475726520636f6e6365726e696e672061207374616b65722f7374617368206f6e6365206974732062616c616e6365206973207a65726f2e6101205468697320697320657373656e7469616c6c79206571756976616c656e7420746f206077697468647261775f756e626f6e64656460206578636570742069742063616e2062652063616c6c656420627920616e796f6e65c020616e6420746865207461726765742060737461736860206d7573742068617665206e6f2066756e6473206c6566742e009020546869732063616e2062652063616c6c65642066726f6d20616e79206f726967696e2e000101202d20607374617368603a20546865207374617368206163636f756e7420746f20726561702e204974732062616c616e6365206d757374206265207a65726f2e002c2023203c7765696768743e250120436f6d706c65786974793a204f285329207768657265205320697320746865206e756d626572206f6620736c617368696e67207370616e73206f6e20746865206163636f756e742e8c2042617365205765696768743a2037352e3934202b20322e333936202a205320c2b5732c204442205765696768743ad8202d2052656164733a205374617368204163636f756e742c20426f6e6465642c20536c617368696e67205370616e732c204c6f636b73a501202d205772697465733a20426f6e6465642c20536c617368696e67205370616e73202869662053203e2030292c204c65646765722c2050617965652c2056616c696461746f72732c204e6f6d696e61746f72732c205374617368204163636f756e742c204c6f636b7374202d2057726974657320456163683a205370616e536c617368202a2053302023203c2f7765696768743e607375626d69745f656c656374696f6e5f736f6c7574696f6e141c77696e6e6572734c5665633c56616c696461746f72496e6465783e1c636f6d7061637448436f6d7061637441737369676e6d656e74731473636f726534456c656374696f6e53636f72650c65726120457261496e6465781073697a6530456c656374696f6e53697a65bce4205375626d697420616e20656c656374696f6e20726573756c7420746f2074686520636861696e2e2049662074686520736f6c7574696f6e3a003420312e2069732076616c69642e150120322e206861732061206265747465722073636f7265207468616e206120706f74656e7469616c6c79206578697374696e6720736f6c7574696f6e206f6e20636861696e2e0084207468656e2c2069742077696c6c206265205f7075745f206f6e20636861696e2e00ac204120736f6c7574696f6e20636f6e7369737473206f662074776f20706965636573206f6620646174613a00f420312e206077696e6e657273603a206120666c617420766563746f72206f6620616c6c207468652077696e6e657273206f662074686520726f756e642e510120322e206061737369676e6d656e7473603a2074686520636f6d706163742076657273696f6e206f6620616e2061737369676e6d656e7420766563746f72207468617420656e636f6465732074686520656467653020202020776569676874732e00210120426f7468206f66207768696368206d617920626520636f6d7075746564207573696e67205f70687261676d656e5f2c206f7220616e79206f7468657220616c676f726974686d2e00a8204164646974696f6e616c6c792c20746865207375626d6974746572206d7573742070726f766964653a00c8202d20546865206073636f7265602074686174207468657920636c61696d20746865697220736f6c7574696f6e206861732e004d0120426f74682076616c696461746f727320616e64206e6f6d696e61746f72732077696c6c20626520726570726573656e74656420627920696e646963657320696e2074686520736f6c7574696f6e2e205468651d0120696e64696365732073686f756c6420726573706563742074686520636f72726573706f6e64696e6720747970657320285b6056616c696461746f72496e646578605d20616e643101205b604e6f6d696e61746f72496e646578605d292e204d6f72656f7665722c20746865792073686f756c642062652076616c6964207768656e207573656420746f20696e64657820696e746f5101205b60536e617073686f7456616c696461746f7273605d20616e64205b60536e617073686f744e6f6d696e61746f7273605d2e20416e7920696e76616c696420696e6465782077696c6c20636175736520746865610120736f6c7574696f6e20746f2062652072656a65637465642e2054686573652074776f2073746f72616765206974656d73206172652073657420647572696e672074686520656c656374696f6e2077696e646f7720616e6498206d6179206265207573656420746f2064657465726d696e652074686520696e64696365732e0060204120736f6c7574696f6e2069732076616c69642069663a00e420302e204974206973207375626d6974746564207768656e205b60457261456c656374696f6e537461747573605d20697320604f70656e602ef820312e2049747320636c61696d65642073636f726520697320657175616c20746f207468652073636f726520636f6d7075746564206f6e2d636861696e2eac20322e2050726573656e74732074686520636f7272656374206e756d626572206f662077696e6e6572732e550120332e20416c6c20696e6465786573206d7573742062652076616c7565206163636f7264696e6720746f2074686520736e617073686f7420766563746f72732e20416c6c20656467652076616c756573206d7573745d0120202020616c736f20626520636f727265637420616e642073686f756c64206e6f74206f766572666c6f7720746865206772616e756c6172697479206f662074686520726174696f20747970652028692e652e2032353640202020206f722062696c6c696f6e292e0d0120342e20466f72206561636820656467652c20616c6c2074617267657473206172652061637475616c6c79206e6f6d696e617465642062792074686520766f7465722e6c20352e2048617320636f72726563742073656c662d766f7465732e00c0204120736f6c7574696f6e732073636f726520697320636f6e736973746564206f66203320706172616d65746572733a00650120312e20606d696e207b20737570706f72742e746f74616c207d6020666f72206561636820737570706f7274206f6620612077696e6e65722e20546869732076616c75652073686f756c64206265206d6178696d697a65642e650120322e206073756d207b20737570706f72742e746f74616c207d6020666f72206561636820737570706f7274206f6620612077696e6e65722e20546869732076616c75652073686f756c64206265206d696e696d697a65642e410120332e206073756d207b20737570706f72742e746f74616c5e32207d6020666f72206561636820737570706f7274206f6620612077696e6e65722e20546869732076616c75652073686f756c642062659c202020206d696e696d697a65642028746f20656e73757265206c6573732076617269616e636529002c2023203c7765696768743e7020536565206063726174653a3a77656967687460206d6f64756c652e302023203c2f7765696768743e847375626d69745f656c656374696f6e5f736f6c7574696f6e5f756e7369676e6564141c77696e6e6572734c5665633c56616c696461746f72496e6465783e1c636f6d7061637448436f6d7061637441737369676e6d656e74731473636f726534456c656374696f6e53636f72650c65726120457261496e6465781073697a6530456c656374696f6e53697a6524c020556e7369676e65642076657273696f6e206f6620607375626d69745f656c656374696f6e5f736f6c7574696f6e602e005d01204e6f746520746861742074686973206d757374207061737320746865205b6056616c6964617465556e7369676e6564605d20636865636b207768696368206f6e6c7920616c6c6f7773207472616e73616374696f6e7361012066726f6d20746865206c6f63616c206e6f646520746f20626520696e636c756465642e20496e206f7468657220776f7264732c206f6e6c792074686520626c6f636b20617574686f722063616e20696e636c756465206168207472616e73616374696f6e20696e2074686520626c6f636b2e002c2023203c7765696768743e7020536565206063726174653a3a77656967687460206d6f64756c652e302023203c2f7765696768743e0124244572615061796f75740c20457261496e6465781c42616c616e63651c42616c616e63650859012054686520657261207061796f757420686173206265656e207365743b207468652066697273742062616c616e6365206973207468652076616c696461746f722d7061796f75743b20746865207365636f6e64206973c4207468652072656d61696e6465722066726f6d20746865206d6178696d756d20616d6f756e74206f66207265776172642e1852657761726408244163636f756e7449641c42616c616e6365043d0120546865207374616b657220686173206265656e207265776172646564206279207468697320616d6f756e742e20604163636f756e7449646020697320746865207374617368206163636f756e742e14536c61736808244163636f756e7449641c42616c616e6365042501204f6e652076616c696461746f722028616e6420697473206e6f6d696e61746f72732920686173206265656e20736c61736865642062792074686520676976656e20616d6f756e742e684f6c64536c617368696e675265706f7274446973636172646564043053657373696f6e496e646578081d0120416e206f6c6420736c617368696e67207265706f72742066726f6d2061207072696f72206572612077617320646973636172646564206265636175736520697420636f756c6448206e6f742062652070726f6365737365642e3c5374616b696e67456c656374696f6e043c456c656374696f6e436f6d707574650411012041206e657720736574206f66207374616b6572732077617320656c656374656420776974682074686520676976656e20636f6d7075746174696f6e206d6574686f642e38536f6c7574696f6e53746f726564043c456c656374696f6e436f6d7075746504e82041206e657720736f6c7574696f6e20666f7220746865207570636f6d696e6720656c656374696f6e20686173206265656e2073746f7265642e18426f6e64656408244163636f756e7449641c42616c616e6365108c20416e206163636f756e742068617320626f6e646564207468697320616d6f756e742e005101204e4f54453a2054686973206576656e74206973206f6e6c7920656d6974746564207768656e2066756e64732061726520626f6e64656420766961206120646973706174636861626c652e204e6f7461626c792c25012069742077696c6c206e6f7420626520656d697474656420666f72207374616b696e672072657761726473207768656e20746865792061726520616464656420746f207374616b652e20556e626f6e64656408244163636f756e7449641c42616c616e6365049420416e206163636f756e742068617320756e626f6e646564207468697320616d6f756e742e2457697468647261776e08244163636f756e7449641c42616c616e6365085d0120416e206163636f756e74206861732063616c6c6564206077697468647261775f756e626f6e6465646020616e642072656d6f76656420756e626f6e64696e67206368756e6b7320776f727468206042616c616e636560682066726f6d2074686520756e6c6f636b696e672071756575652e1c3853657373696f6e735065724572613053657373696f6e496e64657810060000000470204e756d626572206f662073657373696f6e7320706572206572612e3c426f6e64696e674475726174696f6e20457261496e64657810a002000004e4204e756d626572206f6620657261732074686174207374616b65642066756e6473206d7573742072656d61696e20626f6e64656420666f722e48536c61736844656665724475726174696f6e20457261496e64657810a8000000140101204e756d626572206f662065726173207468617420736c6173686573206172652064656665727265642062792c20616674657220636f6d7075746174696f6e2e00bc20546869732073686f756c64206265206c657373207468616e2074686520626f6e64696e67206475726174696f6e2e2d012053657420746f203020696620736c61736865732073686f756c64206265206170706c69656420696d6d6564696174656c792c20776974686f7574206f70706f7274756e69747920666f723820696e74657276656e74696f6e2e44456c656374696f6e4c6f6f6b616865616438543a3a426c6f636b4e756d62657210320000001c710120546865206e756d626572206f6620626c6f636b73206265666f72652074686520656e64206f6620746865206572612066726f6d20776869636820656c656374696f6e207375626d697373696f6e732061726520616c6c6f7765642e006d012053657474696e67207468697320746f207a65726f2077696c6c2064697361626c6520746865206f6666636861696e20636f6d7075746520616e64206f6e6c79206f6e2d636861696e207365712d70687261676d656e2077696c6c2420626520757365642e007501205468697320697320626f756e646564206279206265696e672077697468696e20746865206c6173742073657373696f6e2e2048656e63652c2073657474696e6720697420746f20612076616c7565206d6f7265207468616e207468659c206c656e677468206f6620612073657373696f6e2077696c6c20626520706f696e746c6573732e344d6178497465726174696f6e730c753332100a0000000c2901204d6178696d756d206e756d626572206f662062616c616e63696e6720697465726174696f6e7320746f2072756e20696e20746865206f6666636861696e207375626d697373696f6e2e00ec2049662073657420746f20302c2062616c616e63655f736f6c7574696f6e2077696c6c206e6f7420626520657865637574656420617420616c6c2e504d696e536f6c7574696f6e53636f726542756d701c50657262696c6c1020a1070004610120546865207468726573686f6c64206f6620696d70726f76656d656e7420746861742073686f756c642062652070726f766964656420666f722061206e657720736f6c7574696f6e20746f2062652061636365707465642e804d61784e6f6d696e61746f72526577617264656450657256616c696461746f720c753332104000000010f820546865206d6178696d756d206e756d626572206f66206e6f6d696e61746f727320726577617264656420666f7220656163682076616c696461746f722e00690120466f7220656163682076616c696461746f72206f6e6c79207468652060244d61784e6f6d696e61746f72526577617264656450657256616c696461746f72602062696767657374207374616b6572732063616e20636c61696d2101207468656972207265776172642e2054686973207573656420746f206c696d69742074686520692f6f20636f737420666f7220746865206e6f6d696e61746f72207061796f75742e7c344e6f74436f6e74726f6c6c65720468204e6f74206120636f6e74726f6c6c6572206163636f756e742e204e6f7453746173680454204e6f742061207374617368206163636f756e742e34416c7265616479426f6e646564046420537461736820697320616c726561647920626f6e6465642e34416c7265616479506169726564047820436f6e74726f6c6c657220697320616c7265616479207061697265642e30456d70747954617267657473046420546172676574732063616e6e6f7420626520656d7074792e384475706c6963617465496e6465780444204475706c696361746520696e6465782e44496e76616c6964536c617368496e646578048820536c617368207265636f726420696e646578206f7574206f6620626f756e64732e44496e73756666696369656e7456616c756504cc2043616e206e6f7420626f6e6420776974682076616c7565206c657373207468616e206d696e696d756d2062616c616e63652e304e6f4d6f72654368756e6b7304942043616e206e6f74207363686564756c65206d6f726520756e6c6f636b206368756e6b732e344e6f556e6c6f636b4368756e6b04a42043616e206e6f74207265626f6e6420776974686f757420756e6c6f636b696e67206368756e6b732e3046756e64656454617267657404cc20417474656d7074696e6720746f2074617267657420612073746173682074686174207374696c6c206861732066756e64732e48496e76616c6964457261546f526577617264045c20496e76616c69642065726120746f207265776172642e68496e76616c69644e756d6265724f664e6f6d696e6174696f6e73047c20496e76616c6964206e756d626572206f66206e6f6d696e6174696f6e732e484e6f74536f72746564416e64556e697175650484204974656d7320617265206e6f7420736f7274656420616e6420756e697175652e38416c7265616479436c61696d6564040d01205265776172647320666f72207468697320657261206861766520616c7265616479206265656e20636c61696d656420666f7220746869732076616c696461746f722e5c50687261676d656e4561726c795375626d697373696f6e04e420546865207375626d697474656420726573756c74206973207265636569766564206f7574206f6620746865206f70656e2077696e646f772e5850687261676d656e5765616b5375626d697373696f6e04010120546865207375626d697474656420726573756c74206973206e6f7420617320676f6f6420617320746865206f6e652073746f726564206f6e20636861696e2e4c536e617073686f74556e617661696c61626c6504d02054686520736e617073686f742064617461206f66207468652063757272656e742077696e646f77206973206d697373696e672e6050687261676d656e426f67757357696e6e6572436f756e7404b020496e636f7272656374206e756d626572206f662077696e6e65727320776572652070726573656e7465642e4c50687261676d656e426f67757357696e6e6572086101204f6e65206f6620746865207375626d69747465642077696e6e657273206973206e6f7420616e206163746976652063616e646964617465206f6e20636861696e2028696e646578206973206f7574206f662072616e67653820696e20736e617073686f74292e5050687261676d656e426f677573436f6d70616374085d01204572726f72207768696c65206275696c64696e67207468652061737369676e6d656e7420747970652066726f6d2074686520636f6d706163742e20546869732063616e2068617070656e20696620616e20696e646578a820697320696e76616c69642c206f72206966207468652077656967687473205f6f766572666c6f775f2e5850687261676d656e426f6775734e6f6d696e61746f72041501204f6e65206f6620746865207375626d6974746564206e6f6d696e61746f7273206973206e6f7420616e20616374697665206e6f6d696e61746f72206f6e20636861696e2e5c50687261676d656e426f6775734e6f6d696e6174696f6e044d01204f6e65206f6620746865207375626d6974746564206e6f6d696e61746f72732068617320616e206564676520746f20776869636820746865792068617665206e6f7420766f746564206f6e20636861696e2e6450687261676d656e536c61736865644e6f6d696e6174696f6e086101204f6e65206f6620746865207375626d6974746564206e6f6d696e61746f72732068617320616e2065646765207768696368206973207375626d6974746564206265666f726520746865206c617374206e6f6e2d7a65726f5420736c617368206f6620746865207461726765742e5450687261676d656e426f67757353656c66566f746504250120412073656c6620766f7465206d757374206f6e6c79206265206f726967696e617465642066726f6d20612076616c696461746f7220746f204f4e4c59207468656d73656c7665732e4450687261676d656e426f6775734564676504450120546865207375626d697474656420726573756c742068617320756e6b6e6f776e206564676573207468617420617265206e6f7420616d6f6e67207468652070726573656e7465642077696e6e6572732e4850687261676d656e426f67757353636f72650419012054686520636c61696d65642073636f726520646f6573206e6f74206d61746368207769746820746865206f6e6520636f6d70757465642066726f6d2074686520646174612e6450687261676d656e426f677573456c656374696f6e53697a6504782054686520656c656374696f6e2073697a6520697320696e76616c69642e3843616c6c4e6f74416c6c6f776564044901205468652063616c6c206973206e6f7420616c6c6f7765642061742074686520676976656e2074696d652064756520746f207265737472696374696f6e73206f6620656c656374696f6e20706572696f642e54496e636f7272656374486973746f7279446570746804c420496e636f72726563742070726576696f757320686973746f727920646570746820696e7075742070726f76696465642e58496e636f7272656374536c617368696e675370616e7304b420496e636f7272656374206e756d626572206f6620736c617368696e67207370616e732070726f76696465642e1c53657373696f6e011c53657373696f6e1c2856616c696461746f727301004c5665633c543a3a56616c696461746f7249643e0400047c205468652063757272656e7420736574206f662076616c696461746f72732e3043757272656e74496e64657801003053657373696f6e496e646578100000000004782043757272656e7420696e646578206f66207468652073657373696f6e2e345175657565644368616e676564010010626f6f6c040008390120547275652069662074686520756e6465726c79696e672065636f6e6f6d6963206964656e746974696573206f7220776569676874696e6720626568696e64207468652076616c696461746f7273a420686173206368616e67656420696e20746865207175657565642076616c696461746f72207365742e285175657565644b6579730100785665633c28543a3a56616c696461746f7249642c20543a3a4b657973293e0400083d012054686520717565756564206b65797320666f7220746865206e6578742073657373696f6e2e205768656e20746865206e6578742073657373696f6e20626567696e732c207468657365206b657973e02077696c6c206265207573656420746f2064657465726d696e65207468652076616c696461746f7227732073657373696f6e206b6579732e4844697361626c656456616c696461746f72730100205665633c7533323e04000c8020496e6469636573206f662064697361626c65642076616c696461746f72732e003501205468652073657420697320636c6561726564207768656e20606f6e5f73657373696f6e5f656e64696e67602072657475726e732061206e657720736574206f66206964656e7469746965732e204e6578744b65797300010538543a3a56616c696461746f7249641c543a3a4b657973000400049c20546865206e6578742073657373696f6e206b65797320666f7220612076616c696461746f722e204b65794f776e657200010550284b65795479706549642c205665633c75383e2938543a3a56616c696461746f72496400040004090120546865206f776e6572206f662061206b65792e20546865206b65792069732074686520604b657954797065496460202b2074686520656e636f646564206b65792e0108207365745f6b65797308106b6579731c543a3a4b6579731470726f6f661c5665633c75383e38e82053657473207468652073657373696f6e206b6579287329206f66207468652066756e6374696f6e2063616c6c657220746f20606b657973602e210120416c6c6f777320616e206163636f756e7420746f20736574206974732073657373696f6e206b6579207072696f7220746f206265636f6d696e6720612076616c696461746f722ec4205468697320646f65736e27742074616b652065666665637420756e74696c20746865206e6578742073657373696f6e2e00d420546865206469737061746368206f726967696e206f6620746869732066756e6374696f6e206d757374206265207369676e65642e002c2023203c7765696768743e54202d20436f6d706c65786974793a20604f28312960590120202041637475616c20636f737420646570656e6473206f6e20746865206e756d626572206f66206c656e677468206f662060543a3a4b6579733a3a6b65795f6964732829602077686963682069732066697865642ef0202d20446252656164733a20606f726967696e206163636f756e74602c2060543a3a56616c696461746f7249644f66602c20604e6578744b65797360a4202d2044625772697465733a20606f726967696e206163636f756e74602c20604e6578744b6579736084202d204462526561647320706572206b65792069643a20604b65794f776e65726088202d20446257726974657320706572206b65792069643a20604b65794f776e657260302023203c2f7765696768743e2870757267655f6b6579730030cc2052656d6f76657320616e792073657373696f6e206b6579287329206f66207468652066756e6374696f6e2063616c6c65722ec4205468697320646f65736e27742074616b652065666665637420756e74696c20746865206e6578742073657373696f6e2e00d420546865206469737061746368206f726967696e206f6620746869732066756e6374696f6e206d757374206265207369676e65642e002c2023203c7765696768743eb4202d20436f6d706c65786974793a20604f2831296020696e206e756d626572206f66206b65792074797065732e590120202041637475616c20636f737420646570656e6473206f6e20746865206e756d626572206f66206c656e677468206f662060543a3a4b6579733a3a6b65795f6964732829602077686963682069732066697865642ef0202d20446252656164733a2060543a3a56616c696461746f7249644f66602c20604e6578744b657973602c20606f726967696e206163636f756e7460a4202d2044625772697465733a20604e6578744b657973602c20606f726967696e206163636f756e74608c202d20446257726974657320706572206b65792069643a20604b65794f776e64657260302023203c2f7765696768743e0104284e657753657373696f6e043053657373696f6e496e646578085501204e65772073657373696f6e206861732068617070656e65642e204e6f746520746861742074686520617267756d656e74206973207468652073657373696f6e20696e6465782c206e6f742074686520626c6f636b88206e756d626572206173207468652074797065206d6967687420737567676573742e001030496e76616c696450726f6f66046420496e76616c6964206f776e6572736869702070726f6f662e5c4e6f4173736f63696174656456616c696461746f72496404a0204e6f206173736f6369617465642076616c696461746f7220494420666f72206163636f756e742e344475706c6963617465644b657904682052656769737465726564206475706c6963617465206b65792e184e6f4b65797304a8204e6f206b65797320617265206173736f63696174656420776974682074686973206163636f756e742e2444656d6f6372616379012444656d6f6372616379383c5075626c696350726f70436f756e7401002450726f70496e646578100000000004f420546865206e756d626572206f6620287075626c6963292070726f706f73616c7320746861742068617665206265656e206d61646520736f206661722e2c5075626c696350726f707301009c5665633c2850726f70496e6465782c20543a3a486173682c20543a3a4163636f756e744964293e040004210120546865207075626c69632070726f706f73616c732e20556e736f727465642e20546865207365636f6e64206974656d206973207468652070726f706f73616c277320686173682e244465706f7369744f660001052450726f70496e64657884285665633c543a3a4163636f756e7449643e2c2042616c616e63654f663c543e290004000c842054686f73652077686f2068617665206c6f636b65642061206465706f7369742e00d82054574f582d4e4f54453a20536166652c20617320696e6372656173696e6720696e7465676572206b6579732061726520736166652e24507265696d616765730001061c543a3a48617368e8507265696d6167655374617475733c543a3a4163636f756e7449642c2042616c616e63654f663c543e2c20543a3a426c6f636b4e756d6265723e000400086101204d6170206f662068617368657320746f207468652070726f706f73616c20707265696d6167652c20616c6f6e6720776974682077686f207265676973746572656420697420616e64207468656972206465706f7369742ee42054686520626c6f636b206e756d6265722069732074686520626c6f636b20617420776869636820697420776173206465706f73697465642e3c5265666572656e64756d436f756e7401003c5265666572656e64756d496e646578100000000004310120546865206e6578742066726565207265666572656e64756d20696e6465782c20616b6120746865206e756d626572206f66207265666572656e6461207374617274656420736f206661722e344c6f77657374556e62616b656401003c5265666572656e64756d496e646578100000000008250120546865206c6f77657374207265666572656e64756d20696e64657820726570726573656e74696e6720616e20756e62616b6564207265666572656e64756d2e20457175616c20746fdc20605265666572656e64756d436f756e74602069662074686572652069736e2774206120756e62616b6564207265666572656e64756d2e405265666572656e64756d496e666f4f660001053c5265666572656e64756d496e646578d45265666572656e64756d496e666f3c543a3a426c6f636b4e756d6265722c20543a3a486173682c2042616c616e63654f663c543e3e0004000cb420496e666f726d6174696f6e20636f6e6365726e696e6720616e7920676976656e207265666572656e64756d2e0009012054574f582d4e4f54453a205341464520617320696e646578657320617265206e6f7420756e64657220616e2061747461636b6572e280997320636f6e74726f6c2e20566f74696e674f6601010530543a3a4163636f756e744964c8566f74696e673c42616c616e63654f663c543e2c20543a3a4163636f756e7449642c20543a3a426c6f636b4e756d6265723e00d8000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000105d0120416c6c20766f74657320666f72206120706172746963756c617220766f7465722e2057652073746f7265207468652062616c616e636520666f7220746865206e756d626572206f6620766f74657320746861742077655d012068617665207265636f726465642e20546865207365636f6e64206974656d2069732074686520746f74616c20616d6f756e74206f662064656c65676174696f6e732c20746861742077696c6c2062652061646465642e00e82054574f582d4e4f54453a205341464520617320604163636f756e7449646073206172652063727970746f2068617368657320616e797761792e144c6f636b7300010530543a3a4163636f756e74496438543a3a426c6f636b4e756d626572000400105d01204163636f756e747320666f7220776869636820746865726520617265206c6f636b7320696e20616374696f6e207768696368206d61792062652072656d6f76656420617420736f6d6520706f696e7420696e207468655101206675747572652e205468652076616c75652069732074686520626c6f636b206e756d62657220617420776869636820746865206c6f636b206578706972657320616e64206d61792062652072656d6f7665642e00c02054574f582d4e4f54453a204f4b20e2809520604163636f756e7449646020697320612073656375726520686173682e544c6173745461626c656457617345787465726e616c010010626f6f6c0400085901205472756520696620746865206c617374207265666572656e64756d207461626c656420776173207375626d69747465642065787465726e616c6c792e2046616c7365206966206974207761732061207075626c6963282070726f706f73616c2e304e65787445787465726e616c00006028543a3a486173682c20566f74655468726573686f6c6429040010590120546865207265666572656e64756d20746f206265207461626c6564207768656e6576657220697420776f756c642062652076616c696420746f207461626c6520616e2065787465726e616c2070726f706f73616c2e550120546869732068617070656e73207768656e2061207265666572656e64756d206e6565647320746f206265207461626c656420616e64206f6e65206f662074776f20636f6e646974696f6e7320617265206d65743aa4202d20604c6173745461626c656457617345787465726e616c60206973206066616c7365603b206f7268202d20605075626c696350726f70736020697320656d7074792e24426c61636b6c6973740001061c543a3a486173688c28543a3a426c6f636b4e756d6265722c205665633c543a3a4163636f756e7449643e290004000851012041207265636f7264206f662077686f207665746f656420776861742e204d6170732070726f706f73616c206861736820746f206120706f737369626c65206578697374656e7420626c6f636b206e756d626572e82028756e74696c207768656e206974206d6179206e6f742062652072657375626d69747465642920616e642077686f207665746f65642069742e3443616e63656c6c6174696f6e730101061c543a3a4861736810626f6f6c000400042901205265636f7264206f6620616c6c2070726f706f73616c7320746861742068617665206265656e207375626a65637420746f20656d657267656e63792063616e63656c6c6174696f6e2e3853746f7261676556657273696f6e00002052656c656173657304000c7c2053746f726167652076657273696f6e206f66207468652070616c6c65742e0098204e6577206e6574776f726b732073746172742077697468206c6173742076657273696f6e2e015c1c70726f706f7365083470726f706f73616c5f686173681c543a3a486173681476616c756554436f6d706163743c42616c616e63654f663c543e3e44a02050726f706f736520612073656e73697469766520616374696f6e20746f2062652074616b656e2e00190120546865206469737061746368206f726967696e206f6620746869732063616c6c206d757374206265205f5369676e65645f20616e64207468652073656e646572206d7573748420686176652066756e647320746f20636f76657220746865206465706f7369742e00d8202d206070726f706f73616c5f68617368603a205468652068617368206f66207468652070726f706f73616c20707265696d6167652e1901202d206076616c7565603a2054686520616d6f756e74206f66206465706f73697420286d757374206265206174206c6561737420604d696e696d756d4465706f73697460292e004820456d697473206050726f706f736564602e002c2023203c7765696768743e54202d20436f6d706c65786974793a20604f28312960b4202d2044622072656164733a20605075626c696350726f70436f756e74602c20605075626c696350726f707360ec202d204462207772697465733a20605075626c696350726f70436f756e74602c20605075626c696350726f7073602c20604465706f7369744f666050202d2d2d2d2d2d2d2d2d2d2d2d2d2d2d2d2d2d2d45012042617365205765696768743a2034322e3538202b202e313237202a205020c2b57320776974682060506020746865206e756d626572206f662070726f706f73616c7320605075626c696350726f707360302023203c2f7765696768743e187365636f6e64082070726f706f73616c48436f6d706163743c50726f70496e6465783e4c7365636f6e64735f75707065725f626f756e6430436f6d706163743c7533323e40b8205369676e616c732061677265656d656e742077697468206120706172746963756c61722070726f706f73616c2e00050120546865206469737061746368206f726967696e206f6620746869732063616c6c206d757374206265205f5369676e65645f20616e64207468652073656e6465721501206d75737420686176652066756e647320746f20636f76657220746865206465706f7369742c20657175616c20746f20746865206f726967696e616c206465706f7369742e00cc202d206070726f706f73616c603a2054686520696e646578206f66207468652070726f706f73616c20746f207365636f6e642e4501202d20607365636f6e64735f75707065725f626f756e64603a20616e20757070657220626f756e64206f6e207468652063757272656e74206e756d626572206f66207365636f6e6473206f6e2074686973290120202070726f706f73616c2e2045787472696e736963206973207765696768746564206163636f7264696e6720746f20746869732076616c75652077697468206e6f20726566756e642e002c2023203c7765696768743e3901202d20436f6d706c65786974793a20604f28532960207768657265205320697320746865206e756d626572206f66207365636f6e647320612070726f706f73616c20616c7265616479206861732e60202d2044622072656164733a20604465706f7369744f666064202d204462207772697465733a20604465706f7369744f666028202d2d2d2d2d2d2d2d2d90202d2042617365205765696768743a2032322e3238202b202e323239202a205320c2b573302023203c2f7765696768743e10766f746508247265665f696e64657860436f6d706163743c5265666572656e64756d496e6465783e10766f7465644163636f756e74566f74653c42616c616e63654f663c543e3e48350120566f746520696e2061207265666572656e64756d2e2049662060766f74652e69735f6179652829602c2074686520766f746520697320746f20656e616374207468652070726f706f73616c3bbc206f7468657277697365206974206973206120766f746520746f206b65657020746865207374617475732071756f2e00cc20546865206469737061746368206f726967696e206f6620746869732063616c6c206d757374206265205f5369676e65645f2e00e0202d20607265665f696e646578603a2054686520696e646578206f6620746865207265666572656e64756d20746f20766f746520666f722e88202d2060766f7465603a2054686520766f746520636f6e66696775726174696f6e2e002c2023203c7765696768743e4901202d20436f6d706c65786974793a20604f28522960207768657265205220697320746865206e756d626572206f66207265666572656e64756d732074686520766f7465722068617320766f746564206f6e2ea42020207765696768742069732063686172676564206173206966206d6178696d756d20766f7465732ef4202d2044622072656164733a20605265666572656e64756d496e666f4f66602c2060566f74696e674f66602c206062616c616e636573206c6f636b7360f8202d204462207772697465733a20605265666572656e64756d496e666f4f66602c2060566f74696e674f66602c206062616c616e636573206c6f636b736054202d2d2d2d2d2d2d2d2d2d2d2d2d2d2d2d2d2d2d2d3c202d2042617365205765696768743a9420202020202d20566f7465204e65773a2034392e3234202b202e333333202a205220c2b573a820202020202d20566f7465204578697374696e673a2034392e3934202b202e333433202a205220c2b573302023203c2f7765696768743e40656d657267656e63795f63616e63656c04247265665f696e6465783c5265666572656e64756d496e646578385101205363686564756c6520616e20656d657267656e63792063616e63656c6c6174696f6e206f662061207265666572656e64756d2e2043616e6e6f742068617070656e20747769636520746f207468652073616d6530207265666572656e64756d2e00fc20546865206469737061746368206f726967696e206f6620746869732063616c6c206d757374206265206043616e63656c6c6174696f6e4f726967696e602e00d4202d607265665f696e646578603a2054686520696e646578206f6620746865207265666572656e64756d20746f2063616e63656c2e002c2023203c7765696768743e58202d20436f6d706c65786974793a20604f283129602ec0202d2044622072656164733a20605265666572656e64756d496e666f4f66602c206043616e63656c6c6174696f6e7360c4202d204462207772697465733a20605265666572656e64756d496e666f4f66602c206043616e63656c6c6174696f6e736038202d2d2d2d2d2d2d2d2d2d2d2d2d64202d2042617365205765696768743a2033342e323520c2b573302023203c2f7765696768743e4065787465726e616c5f70726f706f7365043470726f706f73616c5f686173681c543a3a48617368383101205363686564756c652061207265666572656e64756d20746f206265207461626c6564206f6e6365206974206973206c6567616c20746f207363686564756c6520616e2065787465726e616c30207265666572656e64756d2e00ec20546865206469737061746368206f726967696e206f6620746869732063616c6c206d757374206265206045787465726e616c4f726967696e602e00d8202d206070726f706f73616c5f68617368603a2054686520707265696d6167652068617368206f66207468652070726f706f73616c2e002c2023203c7765696768743e2d01202d20436f6d706c657869747920604f2856296020776974682056206e756d626572206f66207665746f65727320696e2074686520626c61636b6c697374206f662070726f706f73616c2ebc2020204465636f64696e6720766563206f66206c656e67746820562e2043686172676564206173206d6178696d756da0202d2044622072656164733a20604e65787445787465726e616c602c2060426c61636b6c6973746070202d204462207772697465733a20604e65787445787465726e616c608c202d2042617365205765696768743a2031332e38202b202e313036202a205620c2b573302023203c2f7765696768743e6465787465726e616c5f70726f706f73655f6d616a6f72697479043470726f706f73616c5f686173681c543a3a486173683c5901205363686564756c652061206d616a6f726974792d63617272696573207265666572656e64756d20746f206265207461626c6564206e657874206f6e6365206974206973206c6567616c20746f207363686564756c656020616e2065787465726e616c207265666572656e64756d2e00f020546865206469737061746368206f6620746869732063616c6c206d757374206265206045787465726e616c4d616a6f726974794f726967696e602e00d8202d206070726f706f73616c5f68617368603a2054686520707265696d6167652068617368206f66207468652070726f706f73616c2e004d0120556e6c696b65206065787465726e616c5f70726f706f7365602c20626c61636b6c697374696e6720686173206e6f20656666656374206f6e207468697320616e64206974206d6179207265706c61636520619c207072652d7363686564756c6564206065787465726e616c5f70726f706f7365602063616c6c2e002c2023203c7765696768743e54202d20436f6d706c65786974793a20604f283129606c202d2044622077726974653a20604e65787445787465726e616c6064202d2042617365205765696768743a20332e30363520c2b573302023203c2f7765696768743e6065787465726e616c5f70726f706f73655f64656661756c74043470726f706f73616c5f686173681c543a3a486173683c4901205363686564756c652061206e656761746976652d7475726e6f75742d62696173207265666572656e64756d20746f206265207461626c6564206e657874206f6e6365206974206973206c6567616c20746f84207363686564756c6520616e2065787465726e616c207265666572656e64756d2e00ec20546865206469737061746368206f6620746869732063616c6c206d757374206265206045787465726e616c44656661756c744f726967696e602e00d8202d206070726f706f73616c5f68617368603a2054686520707265696d6167652068617368206f66207468652070726f706f73616c2e004d0120556e6c696b65206065787465726e616c5f70726f706f7365602c20626c61636b6c697374696e6720686173206e6f20656666656374206f6e207468697320616e64206974206d6179207265706c61636520619c207072652d7363686564756c6564206065787465726e616c5f70726f706f7365602063616c6c2e002c2023203c7765696768743e54202d20436f6d706c65786974793a20604f283129606c202d2044622077726974653a20604e65787445787465726e616c6064202d2042617365205765696768743a20332e30383720c2b573302023203c2f7765696768743e28666173745f747261636b0c3470726f706f73616c5f686173681c543a3a4861736834766f74696e675f706572696f6438543a3a426c6f636b4e756d6265721464656c617938543a3a426c6f636b4e756d626572505101205363686564756c65207468652063757272656e746c792065787465726e616c6c792d70726f706f736564206d616a6f726974792d63617272696573207265666572656e64756d20746f206265207461626c6564650120696d6d6564696174656c792e204966207468657265206973206e6f2065787465726e616c6c792d70726f706f736564207265666572656e64756d2063757272656e746c792c206f72206966207468657265206973206f6e65ec20627574206974206973206e6f742061206d616a6f726974792d63617272696573207265666572656e64756d207468656e206974206661696c732e00d420546865206469737061746368206f6620746869732063616c6c206d757374206265206046617374547261636b4f726967696e602e00f8202d206070726f706f73616c5f68617368603a205468652068617368206f66207468652063757272656e742065787465726e616c2070726f706f73616c2e6101202d2060766f74696e675f706572696f64603a2054686520706572696f64207468617420697320616c6c6f77656420666f7220766f74696e67206f6e20746869732070726f706f73616c2e20496e6372656173656420746f982020206046617374547261636b566f74696e67506572696f646020696620746f6f206c6f772e5501202d206064656c6179603a20546865206e756d626572206f6620626c6f636b20616674657220766f74696e672068617320656e64656420696e20617070726f76616c20616e6420746869732073686f756c64206265bc202020656e61637465642e205468697320646f65736e277420686176652061206d696e696d756d20616d6f756e742e004420456d697473206053746172746564602e002c2023203c7765696768743e54202d20436f6d706c65786974793a20604f28312960b8202d2044622072656164733a20604e65787445787465726e616c602c20605265666572656e64756d436f756e74600d01202d204462207772697465733a20604e65787445787465726e616c602c20605265666572656e64756d436f756e74602c20605265666572656e64756d496e666f4f666060202d2042617365205765696768743a2033302e3120c2b573302023203c2f7765696768743e347665746f5f65787465726e616c043470726f706f73616c5f686173681c543a3a486173683cbc205665746f20616e6420626c61636b6c697374207468652065787465726e616c2070726f706f73616c20686173682e00dc20546865206469737061746368206f726967696e206f6620746869732063616c6c206d75737420626520605665746f4f726967696e602e003101202d206070726f706f73616c5f68617368603a2054686520707265696d6167652068617368206f66207468652070726f706f73616c20746f207665746f20616e6420626c61636b6c6973742e004020456d69747320605665746f6564602e002c2023203c7765696768743e1901202d20436f6d706c65786974793a20604f2856202b206c6f6728562929602077686572652056206973206e756d626572206f6620606578697374696e67207665746f657273604501202020506572666f726d7320612062696e61727920736561726368206f6e20606578697374696e675f7665746f657273602077686963682073686f756c64206e6f742062652076657279206c617267652ea0202d2044622072656164733a20604e65787445787465726e616c602c2060426c61636b6c69737460a4202d204462207772697465733a20604e65787445787465726e616c602c2060426c61636b6c6973746090202d2042617365205765696768743a2032392e3837202b202e313838202a205620c2b573302023203c2f7765696768743e4463616e63656c5f7265666572656e64756d04247265665f696e64657860436f6d706163743c5265666572656e64756d496e6465783e2c542052656d6f76652061207265666572656e64756d2e00c420546865206469737061746368206f726967696e206f6620746869732063616c6c206d757374206265205f526f6f745f2e00d8202d20607265665f696e646578603a2054686520696e646578206f6620746865207265666572656e64756d20746f2063616e63656c2e002c2023203c7765696768743e58202d20436f6d706c65786974793a20604f283129602e80202d204462207772697465733a20605265666572656e64756d496e666f4f666064202d2042617365205765696768743a2032312e353720c2b573302023203c2f7765696768743e3463616e63656c5f717565756564041477686963683c5265666572656e64756d496e64657830a02043616e63656c20612070726f706f73616c2071756575656420666f7220656e6163746d656e742e00c420546865206469737061746368206f726967696e206f6620746869732063616c6c206d757374206265205f526f6f745f2e00c8202d20607768696368603a2054686520696e646578206f6620746865207265666572656e64756d20746f2063616e63656c2e002c2023203c7765696768743e3501202d20604f284429602077686572652060446020697320746865206974656d7320696e207468652064697370617463682071756575652e205765696768746564206173206044203d203130602ec8202d2044622072656164733a20607363686564756c6572206c6f6f6b7570602c207363686564756c6572206167656e646160cc202d204462207772697465733a20607363686564756c6572206c6f6f6b7570602c207363686564756c6572206167656e64616094202d2042617365205765696768743a2033362e3738202b20332e323737202a204420c2b573302023203c2f7765696768743e2064656c65676174650c08746f30543a3a4163636f756e74496428636f6e76696374696f6e28436f6e76696374696f6e1c62616c616e63653042616c616e63654f663c543e6c3d012044656c65676174652074686520766f74696e6720706f77657220287769746820736f6d6520676976656e20636f6e76696374696f6e29206f66207468652073656e64696e67206163636f756e742e005901205468652062616c616e63652064656c656761746564206973206c6f636b656420666f72206173206c6f6e6720617320697427732064656c6567617465642c20616e64207468657265616674657220666f7220746865cc2074696d6520617070726f70726961746520666f722074686520636f6e76696374696f6e2773206c6f636b20706572696f642e00610120546865206469737061746368206f726967696e206f6620746869732063616c6c206d757374206265205f5369676e65645f2c20616e6420746865207369676e696e67206163636f756e74206d757374206569746865723a782020202d2062652064656c65676174696e6720616c72656164793b206f725d012020202d2068617665206e6f20766f74696e67206163746976697479202869662074686572652069732c207468656e2069742077696c6c206e65656420746f2062652072656d6f7665642f636f6e736f6c6964617465649820202020207468726f7567682060726561705f766f746560206f722060756e766f746560292e004901202d2060746f603a20546865206163636f756e742077686f736520766f74696e6720746865206074617267657460206163636f756e74277320766f74696e6720706f7765722077696c6c20666f6c6c6f772e5901202d2060636f6e76696374696f6e603a2054686520636f6e76696374696f6e20746861742077696c6c20626520617474616368656420746f207468652064656c65676174656420766f7465732e205768656e2074686545012020206163636f756e7420697320756e64656c6567617465642c207468652066756e64732077696c6c206265206c6f636b656420666f722074686520636f72726573706f6e64696e6720706572696f642e5501202d206062616c616e6365603a2054686520616d6f756e74206f6620746865206163636f756e7427732062616c616e636520746f206265207573656420696e2064656c65676174696e672e2054686973206d757374c82020206e6f74206265206d6f7265207468616e20746865206163636f756e7427732063757272656e742062616c616e63652e004c20456d697473206044656c656761746564602e002c2023203c7765696768743e5901202d20436f6d706c65786974793a20604f28522960207768657265205220697320746865206e756d626572206f66207265666572656e64756d732074686520766f7465722064656c65676174696e6720746f20686173cc202020766f746564206f6e2e205765696768742069732063686172676564206173206966206d6178696d756d20766f7465732eac202d2044622072656164733a20322a60566f74696e674f66602c206062616c616e636573206c6f636b7360b0202d204462207772697465733a20322a60566f74696e674f66602c206062616c616e636573206c6f636b7360a4202d2044622072656164732070657220766f7465733a20605265666572656e64756d496e666f4f6660a8202d204462207772697465732070657220766f7465733a20605265666572656e64756d496e666f4f666094202d2042617365205765696768743a2036352e3738202b20382e323239202a205220c2b573302023203c2f7765696768743e28756e64656c6567617465004cd020556e64656c65676174652074686520766f74696e6720706f776572206f66207468652073656e64696e67206163636f756e742e00610120546f6b656e73206d617920626520756e6c6f636b656420666f6c6c6f77696e67206f6e636520616e20616d6f756e74206f662074696d6520636f6e73697374656e74207769746820746865206c6f636b20706572696f64e0206f662074686520636f6e76696374696f6e2077697468207768696368207468652064656c65676174696f6e20776173206973737565642e00490120546865206469737061746368206f726967696e206f6620746869732063616c6c206d757374206265205f5369676e65645f20616e6420746865207369676e696e67206163636f756e74206d757374206265582063757272656e746c792064656c65676174696e672e005420456d6974732060556e64656c656761746564602e002c2023203c7765696768743e5901202d20436f6d706c65786974793a20604f28522960207768657265205220697320746865206e756d626572206f66207265666572656e64756d732074686520766f7465722064656c65676174696e6720746f20686173cc202020766f746564206f6e2e205765696768742069732063686172676564206173206966206d6178696d756d20766f7465732e64202d2044622072656164733a20322a60566f74696e674f666068202d204462207772697465733a20322a60566f74696e674f6660a4202d2044622072656164732070657220766f7465733a20605265666572656e64756d496e666f4f6660a8202d204462207772697465732070657220766f7465733a20605265666572656e64756d496e666f4f666094202d2042617365205765696768743a2033332e3239202b20382e313034202a205220c2b573302023203c2f7765696768743e58636c6561725f7075626c69635f70726f706f73616c7300247420436c6561727320616c6c207075626c69632070726f706f73616c732e00c420546865206469737061746368206f726967696e206f6620746869732063616c6c206d757374206265205f526f6f745f2e002c2023203c7765696768743e28202d20604f283129602e6c202d204462207772697465733a20605075626c696350726f70736064202d2042617365205765696768743a20322e35303520c2b573302023203c2f7765696768743e346e6f74655f707265696d6167650440656e636f6465645f70726f706f73616c1c5665633c75383e3061012052656769737465722074686520707265696d61676520666f7220616e207570636f6d696e672070726f706f73616c2e205468697320646f65736e27742072657175697265207468652070726f706f73616c20746f206265250120696e207468652064697370617463682071756575652062757420646f657320726571756972652061206465706f7369742c2072657475726e6564206f6e636520656e61637465642e00cc20546865206469737061746368206f726967696e206f6620746869732063616c6c206d757374206265205f5369676e65645f2e00c8202d2060656e636f6465645f70726f706f73616c603a2054686520707265696d616765206f6620612070726f706f73616c2e005c20456d6974732060507265696d6167654e6f746564602e002c2023203c7765696768743e802073656520607765696768745f666f723a3a6e6f74655f707265696d61676560302023203c2f7765696768743e646e6f74655f707265696d6167655f6f7065726174696f6e616c0440656e636f6465645f70726f706f73616c1c5665633c75383e040d012053616d6520617320606e6f74655f707265696d6167656020627574206f726967696e20697320604f7065726174696f6e616c507265696d6167654f726967696e602e586e6f74655f696d6d696e656e745f707265696d6167650440656e636f6465645f70726f706f73616c1c5665633c75383e3045012052656769737465722074686520707265696d61676520666f7220616e207570636f6d696e672070726f706f73616c2e2054686973207265717569726573207468652070726f706f73616c20746f206265b420696e207468652064697370617463682071756575652e204e6f206465706f736974206973206e65656465642e00cc20546865206469737061746368206f726967696e206f6620746869732063616c6c206d757374206265205f5369676e65645f2e00c8202d2060656e636f6465645f70726f706f73616c603a2054686520707265696d616765206f6620612070726f706f73616c2e005c20456d6974732060507265696d6167654e6f746564602e002c2023203c7765696768743e802073656520607765696768745f666f723a3a6e6f74655f707265696d61676560302023203c2f7765696768743e886e6f74655f696d6d696e656e745f707265696d6167655f6f7065726174696f6e616c0440656e636f6465645f70726f706f73616c1c5665633c75383e0431012053616d6520617320606e6f74655f696d6d696e656e745f707265696d6167656020627574206f726967696e20697320604f7065726174696f6e616c507265696d6167654f726967696e602e34726561705f707265696d616765083470726f706f73616c5f686173681c543a3a486173686070726f706f73616c5f6c656e5f75707065725f626f756e6430436f6d706163743c7533323e50f42052656d6f766520616e20657870697265642070726f706f73616c20707265696d61676520616e6420636f6c6c65637420746865206465706f7369742e00cc20546865206469737061746368206f726967696e206f6620746869732063616c6c206d757374206265205f5369676e65645f2e00d0202d206070726f706f73616c5f68617368603a2054686520707265696d6167652068617368206f6620612070726f706f73616c2e2d01202d206070726f706f73616c5f6c656e6774685f75707065725f626f756e64603a20616e20757070657220626f756e64206f6e206c656e677468206f66207468652070726f706f73616c2e010120202045787472696e736963206973207765696768746564206163636f7264696e6720746f20746869732076616c75652077697468206e6f20726566756e642e00510120546869732077696c6c206f6e6c7920776f726b2061667465722060566f74696e67506572696f646020626c6f636b732066726f6d207468652074696d6520746861742074686520707265696d616765207761735d01206e6f7465642c2069662069742773207468652073616d65206163636f756e7420646f696e672069742e2049662069742773206120646966666572656e74206163636f756e742c207468656e206974276c6c206f6e6c79b020776f726b20616e206164646974696f6e616c2060456e6163746d656e74506572696f6460206c617465722e006020456d6974732060507265696d616765526561706564602e002c2023203c7765696768743ed0202d20436f6d706c65786974793a20604f284429602077686572652044206973206c656e677468206f662070726f706f73616c2e60202d2044622072656164733a2060507265696d616765736064202d204462207772697465733a2060507265696d616765736090202d2042617365205765696768743a2033392e3331202b202e303033202a206220c2b573302023203c2f7765696768743e18756e6c6f636b041874617267657430543a3a4163636f756e74496438a420556e6c6f636b20746f6b656e732074686174206861766520616e2065787069726564206c6f636b2e00cc20546865206469737061746368206f726967696e206f6620746869732063616c6c206d757374206265205f5369676e65645f2e00bc202d2060746172676574603a20546865206163636f756e7420746f2072656d6f766520746865206c6f636b206f6e2e002c2023203c7765696768743ed4202d20436f6d706c657869747920604f2852296020776974682052206e756d626572206f6620766f7465206f66207461726765742eec202d2044622072656164733a2060566f74696e674f66602c206062616c616e636573206c6f636b73602c2060746172676574206163636f756e7460f0202d204462207772697465733a2060566f74696e674f66602c206062616c616e636573206c6f636b73602c2060746172676574206163636f756e74603c202d2042617365205765696768743a9820202020202d20556e6c6f636b2052656d6f76653a2034322e3936202b202e303438202a20528c20202020202d20556e6c6f636b205365743a2033372e3633202b202e333237202a2052302023203c2f7765696768743e2c72656d6f76655f766f74650414696e6465783c5265666572656e64756d496e64657880802052656d6f7665206120766f746520666f722061207265666572656e64756d2e00102049663a8c202d20746865207265666572656e64756d207761732063616e63656c6c65642c206f7280202d20746865207265666572656e64756d206973206f6e676f696e672c206f7294202d20746865207265666572656e64756d2068617320656e6465642073756368207468617401012020202d2074686520766f7465206f6620746865206163636f756e742077617320696e206f70706f736974696f6e20746f2074686520726573756c743b206f72d82020202d20746865726520776173206e6f20636f6e76696374696f6e20746f20746865206163636f756e74277320766f74653b206f72882020202d20746865206163636f756e74206d61646520612073706c697420766f74656101202e2e2e7468656e2074686520766f74652069732072656d6f76656420636c65616e6c7920616e64206120666f6c6c6f77696e672063616c6c20746f2060756e6c6f636b60206d617920726573756c7420696e206d6f72655c2066756e6473206265696e6720617661696c61626c652e00ac2049662c20686f77657665722c20746865207265666572656e64756d2068617320656e64656420616e643af0202d2069742066696e697368656420636f72726573706f6e64696e6720746f2074686520766f7465206f6620746865206163636f756e742c20616e64e0202d20746865206163636f756e74206d6164652061207374616e6461726420766f7465207769746820636f6e76696374696f6e2c20616e64c0202d20746865206c6f636b20706572696f64206f662074686520636f6e76696374696f6e206973206e6f74206f7665725d01202e2e2e7468656e20746865206c6f636b2077696c6c206265206167677265676174656420696e746f20746865206f766572616c6c206163636f756e742773206c6f636b2c207768696368206d617920696e766f6c76655d01202a6f7665726c6f636b696e672a20287768657265207468652074776f206c6f636b732061726520636f6d62696e656420696e746f20612073696e676c65206c6f636b207468617420697320746865206d6178696d756de8206f6620626f74682074686520616d6f756e74206c6f636b656420616e64207468652074696d65206973206974206c6f636b656420666f72292e004d0120546865206469737061746368206f726967696e206f6620746869732063616c6c206d757374206265205f5369676e65645f2c20616e6420746865207369676e6572206d7573742068617665206120766f74658c207265676973746572656420666f72207265666572656e64756d2060696e646578602e00f8202d2060696e646578603a2054686520696e646578206f66207265666572656e64756d206f662074686520766f746520746f2062652072656d6f7665642e002c2023203c7765696768743e4101202d20604f2852202b206c6f6720522960207768657265205220697320746865206e756d626572206f66207265666572656e646120746861742060746172676574602068617320766f746564206f6e2edc2020205765696768742069732063616c63756c6174656420666f7220746865206d6178696d756d206e756d626572206f6620766f74652eac202d2044622072656164733a20605265666572656e64756d496e666f4f66602c2060566f74696e674f6660b0202d204462207772697465733a20605265666572656e64756d496e666f4f66602c2060566f74696e674f666080202d2042617365205765696768743a2032312e3033202b202e333539202a2052302023203c2f7765696768743e4472656d6f76655f6f746865725f766f7465081874617267657430543a3a4163636f756e74496414696e6465783c5265666572656e64756d496e64657850802052656d6f7665206120766f746520666f722061207265666572656e64756d2e0051012049662074686520607461726765746020697320657175616c20746f20746865207369676e65722c207468656e20746869732066756e6374696f6e2069732065786163746c79206571756976616c656e7420746f3101206072656d6f76655f766f7465602e204966206e6f7420657175616c20746f20746865207369676e65722c207468656e2074686520766f7465206d757374206861766520657870697265642c590120656974686572206265636175736520746865207265666572656e64756d207761732063616e63656c6c65642c20626563617573652074686520766f746572206c6f737420746865207265666572656e64756d206f729c20626563617573652074686520636f6e76696374696f6e20706572696f64206973206f7665722e00cc20546865206469737061746368206f726967696e206f6620746869732063616c6c206d757374206265205f5369676e65645f2e005101202d2060746172676574603a20546865206163636f756e74206f662074686520766f746520746f2062652072656d6f7665643b2074686973206163636f756e74206d757374206861766520766f74656420666f72582020207265666572656e64756d2060696e646578602ef8202d2060696e646578603a2054686520696e646578206f66207265666572656e64756d206f662074686520766f746520746f2062652072656d6f7665642e002c2023203c7765696768743e4101202d20604f2852202b206c6f6720522960207768657265205220697320746865206e756d626572206f66207265666572656e646120746861742060746172676574602068617320766f746564206f6e2edc2020205765696768742069732063616c63756c6174656420666f7220746865206d6178696d756d206e756d626572206f6620766f74652eac202d2044622072656164733a20605265666572656e64756d496e666f4f66602c2060566f74696e674f6660b0202d204462207772697465733a20605265666572656e64756d496e666f4f66602c2060566f74696e674f666080202d2042617365205765696768743a2031392e3135202b202e333732202a2052302023203c2f7765696768743e38656e6163745f70726f706f73616c083470726f706f73616c5f686173681c543a3a4861736814696e6465783c5265666572656e64756d496e64657804510120456e61637420612070726f706f73616c2066726f6d2061207265666572656e64756d2e20466f72206e6f77207765206a757374206d616b65207468652077656967687420626520746865206d6178696d756d2e01442050726f706f736564082450726f70496e6465781c42616c616e636504c02041206d6f74696f6e20686173206265656e2070726f706f7365642062792061207075626c6963206163636f756e742e185461626c65640c2450726f70496e6465781c42616c616e6365385665633c4163636f756e7449643e04dc2041207075626c69632070726f706f73616c20686173206265656e207461626c656420666f72207265666572656e64756d20766f74652e3845787465726e616c5461626c656400049820416e2065787465726e616c2070726f706f73616c20686173206265656e207461626c65642e1c53746172746564083c5265666572656e64756d496e64657834566f74655468726573686f6c6404602041207265666572656e64756d2068617320626567756e2e18506173736564043c5265666572656e64756d496e64657804b020412070726f706f73616c20686173206265656e20617070726f766564206279207265666572656e64756d2e244e6f74506173736564043c5265666572656e64756d496e64657804b020412070726f706f73616c20686173206265656e2072656a6563746564206279207265666572656e64756d2e2443616e63656c6c6564043c5265666572656e64756d496e64657804842041207265666572656e64756d20686173206265656e2063616e63656c6c65642e204578656375746564083c5265666572656e64756d496e64657810626f6f6c047420412070726f706f73616c20686173206265656e20656e61637465642e2444656c65676174656408244163636f756e744964244163636f756e74496404e020416e206163636f756e74206861732064656c65676174656420746865697220766f746520746f20616e6f74686572206163636f756e742e2c556e64656c65676174656404244163636f756e74496404e820416e206163636f756e74206861732063616e63656c6c656420612070726576696f75732064656c65676174696f6e206f7065726174696f6e2e185665746f65640c244163636f756e74496410486173682c426c6f636b4e756d626572049820416e2065787465726e616c2070726f706f73616c20686173206265656e207665746f65642e34507265696d6167654e6f7465640c1048617368244163636f756e7449641c42616c616e636504e020412070726f706f73616c277320707265696d61676520776173206e6f7465642c20616e6420746865206465706f7369742074616b656e2e30507265696d616765557365640c1048617368244163636f756e7449641c42616c616e636504150120412070726f706f73616c20707265696d616765207761732072656d6f76656420616e6420757365642028746865206465706f736974207761732072657475726e6564292e3c507265696d616765496e76616c69640810486173683c5265666572656e64756d496e646578040d0120412070726f706f73616c20636f756c64206e6f7420626520657865637574656420626563617573652069747320707265696d6167652077617320696e76616c69642e3c507265696d6167654d697373696e670810486173683c5265666572656e64756d496e646578040d0120412070726f706f73616c20636f756c64206e6f7420626520657865637574656420626563617573652069747320707265696d61676520776173206d697373696e672e38507265696d616765526561706564101048617368244163636f756e7449641c42616c616e6365244163636f756e744964045d012041207265676973746572656420707265696d616765207761732072656d6f76656420616e6420746865206465706f73697420636f6c6c6563746564206279207468652072656170657220286c617374206974656d292e20556e6c6f636b656404244163636f756e74496404ac20416e206163636f756e7420686173206265656e20756e6c6f636b6564207375636365737366756c6c792e203c456e6163746d656e74506572696f6438543a3a426c6f636b4e756d62657210002f0d0014710120546865206d696e696d756d20706572696f64206f66206c6f636b696e6720616e642074686520706572696f64206265747765656e20612070726f706f73616c206265696e6720617070726f76656420616e6420656e61637465642e0031012049742073686f756c642067656e6572616c6c792062652061206c6974746c65206d6f7265207468616e2074686520756e7374616b6520706572696f6420746f20656e737572652074686174690120766f74696e67207374616b657273206861766520616e206f70706f7274756e69747920746f2072656d6f7665207468656d73656c7665732066726f6d207468652073797374656d20696e2074686520636173652077686572659c207468657920617265206f6e20746865206c6f73696e672073696465206f66206120766f74652e304c61756e6368506572696f6438543a3a426c6f636b4e756d62657210004e0c0004e420486f77206f6674656e2028696e20626c6f636b7329206e6577207075626c6963207265666572656e646120617265206c61756e636865642e30566f74696e67506572696f6438543a3a426c6f636b4e756d62657210004e0c0004b820486f77206f6674656e2028696e20626c6f636b732920746f20636865636b20666f72206e657720766f7465732e384d696e696d756d4465706f7369743042616c616e63654f663c543e400000c16ff2862300000000000000000004350120546865206d696e696d756d20616d6f756e7420746f20626520757365642061732061206465706f73697420666f722061207075626c6963207265666572656e64756d2070726f706f73616c2e5446617374547261636b566f74696e67506572696f6438543a3a426c6f636b4e756d626572108051010004ec204d696e696d756d20766f74696e6720706572696f6420616c6c6f77656420666f7220616e20656d657267656e6379207265666572656e64756d2e34436f6f6c6f6666506572696f6438543a3a426c6f636b4e756d62657210004e0c0004610120506572696f6420696e20626c6f636b7320776865726520616e2065787465726e616c2070726f706f73616c206d6179206e6f742062652072652d7375626d6974746564206166746572206265696e67207665746f65642e4c507265696d616765427974654465706f7369743042616c616e63654f663c543e400010a5d4e800000000000000000000000429012054686520616d6f756e74206f662062616c616e63652074686174206d757374206265206465706f7369746564207065722062797465206f6620707265696d6167652073746f7265642e204d6178566f7465730c753332106400000004b020546865206d6178696d756d206e756d626572206f6620766f74657320666f7220616e206163636f756e742e842056616c75654c6f7704382056616c756520746f6f206c6f773c50726f706f73616c4d697373696e6704602050726f706f73616c20646f6573206e6f7420657869737420426164496e646578043820556e6b6e6f776e20696e6465783c416c726561647943616e63656c656404982043616e6e6f742063616e63656c207468652073616d652070726f706f73616c207477696365444475706c696361746550726f706f73616c04582050726f706f73616c20616c7265616479206d6164654c50726f706f73616c426c61636b6c6973746564046c2050726f706f73616c207374696c6c20626c61636b6c6973746564444e6f7453696d706c654d616a6f7269747904ac204e6578742065787465726e616c2070726f706f73616c206e6f742073696d706c65206d616a6f726974792c496e76616c696448617368043420496e76616c69642068617368284e6f50726f706f73616c0454204e6f2065787465726e616c2070726f706f73616c34416c72656164795665746f6564049c204964656e74697479206d6179206e6f74207665746f20612070726f706f73616c207477696365304e6f7444656c6567617465640438204e6f742064656c656761746564444475706c6963617465507265696d616765045c20507265696d61676520616c7265616479206e6f7465642c4e6f74496d6d696e656e740434204e6f7420696d6d696e656e7420546f6f4561726c79042820546f6f206561726c7920496d6d696e656e74042420496d6d696e656e743c507265696d6167654d697373696e67044c20507265696d616765206e6f7420666f756e64445265666572656e64756d496e76616c6964048820566f746520676976656e20666f7220696e76616c6964207265666572656e64756d3c507265696d616765496e76616c6964044420496e76616c696420707265696d6167652c4e6f6e6557616974696e670454204e6f2070726f706f73616c732077616974696e67244e6f744c6f636b656404a42054686520746172676574206163636f756e7420646f6573206e6f7420686176652061206c6f636b2e284e6f744578706972656404f020546865206c6f636b206f6e20746865206163636f756e7420746f20626520756e6c6f636b656420686173206e6f742079657420657870697265642e204e6f74566f74657204c82054686520676976656e206163636f756e7420646964206e6f7420766f7465206f6e20746865207265666572656e64756d2e304e6f5065726d697373696f6e04cc20546865206163746f7220686173206e6f207065726d697373696f6e20746f20636f6e647563742074686520616374696f6e2e44416c726561647944656c65676174696e67048c20546865206163636f756e7420697320616c72656164792064656c65676174696e672e204f766572666c6f7704a420416e20756e657870656374656420696e7465676572206f766572666c6f77206f636375727265642e24556e646572666c6f7704a820416e20756e657870656374656420696e746567657220756e646572666c6f77206f636375727265642e44496e73756666696369656e7446756e647304010120546f6f206869676820612062616c616e6365207761732070726f7669646564207468617420746865206163636f756e742063616e6e6f74206166666f72642e344e6f7444656c65676174696e6704a420546865206163636f756e74206973206e6f742063757272656e746c792064656c65676174696e672e28566f746573457869737408590120546865206163636f756e742063757272656e746c792068617320766f74657320617474616368656420746f20697420616e6420746865206f7065726174696f6e2063616e6e6f74207375636365656420756e74696cec207468657365206172652072656d6f7665642c20656974686572207468726f7567682060756e766f746560206f722060726561705f766f7465602e44496e7374616e744e6f74416c6c6f77656404dc2054686520696e7374616e74207265666572656e64756d206f726967696e2069732063757272656e746c7920646973616c6c6f7765642e204e6f6e73656e736504982044656c65676174696f6e20746f206f6e6573656c66206d616b6573206e6f2073656e73652e3c57726f6e675570706572426f756e64045420496e76616c696420757070657220626f756e642e3c4d6178566f746573526561636865640484204d6178696d756d206e756d626572206f6620766f74657320726561636865642e1c436f756e63696c014c496e7374616e636531436f6c6c656374697665182450726f706f73616c730100305665633c543a3a486173683e040004902054686520686173686573206f6620746865206163746976652070726f706f73616c732e2850726f706f73616c4f660001061c543a3a48617368643c542061732054726169743c493e3e3a3a50726f706f73616c00040004cc2041637475616c2070726f706f73616c20666f72206120676976656e20686173682c20696620697427732063757272656e742e18566f74696e670001061c543a3a486173688c566f7465733c543a3a4163636f756e7449642c20543a3a426c6f636b4e756d6265723e00040004b420566f746573206f6e206120676976656e2070726f706f73616c2c206966206974206973206f6e676f696e672e3450726f706f73616c436f756e7401000c753332100000000004482050726f706f73616c7320736f206661722e1c4d656d626572730100445665633c543a3a4163636f756e7449643e0400043901205468652063757272656e74206d656d62657273206f662074686520636f6c6c6563746976652e20546869732069732073746f72656420736f7274656420286a7573742062792076616c7565292e145072696d65000030543a3a4163636f756e7449640400085d0120546865206d656d6265722077686f2070726f7669646573207468652064656661756c7420766f746520666f7220616e79206f74686572206d656d62657273207468617420646f206e6f7420766f7465206265666f7265e4207468652074696d656f75742e204966204e6f6e652c207468656e206e6f206d656d6265722068617320746861742070726976696c6567652e01182c7365745f6d656d626572730c2c6e65775f6d656d62657273445665633c543a3a4163636f756e7449643e147072696d65504f7074696f6e3c543a3a4163636f756e7449643e246f6c645f636f756e742c4d656d626572436f756e746084205365742074686520636f6c6c6563746976652773206d656d626572736869702e004901202d20606e65775f6d656d62657273603a20546865206e6577206d656d626572206c6973742e204265206e69636520746f2074686520636861696e20616e642070726f7669646520697420736f727465642ee4202d20607072696d65603a20546865207072696d65206d656d6265722077686f736520766f74652073657473207468652064656661756c742e3901202d20606f6c645f636f756e74603a2054686520757070657220626f756e6420666f72207468652070726576696f7573206e756d626572206f66206d656d6265727320696e2073746f726167652eac202020202020202020202020202020205573656420666f722077656967687420657374696d6174696f6e2e005820526571756972657320726f6f74206f726967696e2e005901204e4f54453a20446f6573206e6f7420656e666f7263652074686520657870656374656420604d41585f4d454d4245525360206c696d6974206f6e2074686520616d6f756e74206f66206d656d626572732c206275742501202020202020207468652077656967687420657374696d6174696f6e732072656c79206f6e20697420746f20657374696d61746520646973706174636861626c65207765696768742e002c2023203c7765696768743e282023232057656967687454202d20604f284d50202b204e29602077686572653ae42020202d20604d60206f6c642d6d656d626572732d636f756e742028636f64652d20616e6420676f7665726e616e63652d626f756e64656429e42020202d20604e60206e65772d6d656d626572732d636f756e742028636f64652d20616e6420676f7665726e616e63652d626f756e646564299c2020202d206050602070726f706f73616c732d636f756e742028636f64652d626f756e6465642918202d2044423a75012020202d20312073746f72616765206d75746174696f6e2028636f64656320604f284d296020726561642c20604f284e29602077726974652920666f722072656164696e6720616e642077726974696e6720746865206d656d62657273f02020202d20312073746f7261676520726561642028636f64656320604f285029602920666f722072656164696e67207468652070726f706f73616c7349012020202d206050602073746f72616765206d75746174696f6e732028636f64656320604f284d29602920666f72207570646174696e672074686520766f74657320666f7220656163682070726f706f73616c61012020202d20312073746f726167652077726974652028636f64656320604f283129602920666f722064656c6574696e6720746865206f6c6420607072696d656020616e642073657474696e6720746865206e6577206f6e65302023203c2f7765696768743e1c65786563757465082070726f706f73616c78426f783c3c542061732054726169743c493e3e3a3a50726f706f73616c3e306c656e6774685f626f756e6430436f6d706163743c7533323e28f420446973706174636820612070726f706f73616c2066726f6d2061206d656d626572207573696e672074686520604d656d62657260206f726967696e2e00ac204f726967696e206d7573742062652061206d656d626572206f662074686520636f6c6c6563746976652e002c2023203c7765696768743e28202323205765696768748501202d20604f284d202b2050296020776865726520604d60206d656d626572732d636f756e742028636f64652d626f756e6465642920616e642060506020636f6d706c6578697479206f66206469737061746368696e67206070726f706f73616c60d8202d2044423a203120726561642028636f64656320604f284d296029202b20444220616363657373206f66206070726f706f73616c6028202d2031206576656e74302023203c2f7765696768743e1c70726f706f73650c247468726573686f6c6450436f6d706163743c4d656d626572436f756e743e2070726f706f73616c78426f783c3c542061732054726169743c493e3e3a3a50726f706f73616c3e306c656e6774685f626f756e6430436f6d706163743c7533323e6cfc204164642061206e65772070726f706f73616c20746f2065697468657220626520766f746564206f6e206f72206578656375746564206469726563746c792e0088205265717569726573207468652073656e64657220746f206265206d656d6265722e00450120607468726573686f6c64602064657465726d696e65732077686574686572206070726f706f73616c60206973206578656375746564206469726563746c792028607468726573686f6c64203c2032602958206f722070757420757020666f7220766f74696e672e002c2023203c7765696768743e2820232320576569676874b0202d20604f2842202b204d202b2050312960206f7220604f2842202b204d202b20503229602077686572653ae42020202d20604260206973206070726f706f73616c602073697a6520696e20627974657320286c656e6774682d6665652d626f756e64656429e02020202d20604d60206973206d656d626572732d636f756e742028636f64652d20616e6420676f7665726e616e63652d626f756e64656429c82020202d206272616e6368696e6720697320696e666c75656e63656420627920607468726573686f6c64602077686572653af820202020202d20605031602069732070726f706f73616c20657865637574696f6e20636f6d706c65786974792028607468726573686f6c64203c20326029010120202020202d20605032602069732070726f706f73616c732d636f756e742028636f64652d626f756e646564292028607468726573686f6c64203e3d2032602918202d2044423ab82020202d20312073746f726167652072656164206069735f6d656d626572602028636f64656320604f284d296029f42020202d20312073746f726167652072656164206050726f706f73616c4f663a3a636f6e7461696e735f6b6579602028636f64656320604f2831296029ac2020202d20444220616363657373657320696e666c75656e63656420627920607468726573686f6c64603a0d0120202020202d204549544845522073746f7261676520616363657373657320646f6e65206279206070726f706f73616c602028607468726573686f6c64203c20326029bc20202020202d204f522070726f706f73616c20696e73657274696f6e2028607468726573686f6c64203c3d20326029dc202020202020202d20312073746f72616765206d75746174696f6e206050726f706f73616c73602028636f64656320604f285032296029e8202020202020202d20312073746f72616765206d75746174696f6e206050726f706f73616c436f756e74602028636f64656320604f2831296029d0202020202020202d20312073746f72616765207772697465206050726f706f73616c4f66602028636f64656320604f2842296029c0202020202020202d20312073746f726167652077726974652060566f74696e67602028636f64656320604f284d296029302020202d2031206576656e74302023203c2f7765696768743e10766f74650c2070726f706f73616c1c543a3a4861736814696e64657858436f6d706163743c50726f706f73616c496e6465783e1c617070726f766510626f6f6c30f42041646420616e20617965206f72206e617920766f746520666f72207468652073656e64657220746f2074686520676976656e2070726f706f73616c2e0090205265717569726573207468652073656e64657220746f2062652061206d656d6265722e002c2023203c7765696768743e28202323205765696768740d01202d20604f284d296020776865726520604d60206973206d656d626572732d636f756e742028636f64652d20616e6420676f7665726e616e63652d626f756e6465642918202d2044423ab02020202d20312073746f72616765207265616420604d656d62657273602028636f64656320604f284d296029bc2020202d20312073746f72616765206d75746174696f6e2060566f74696e67602028636f64656320604f284d29602928202d2031206576656e74302023203c2f7765696768743e14636c6f7365103470726f706f73616c5f686173681c543a3a4861736814696e64657858436f6d706163743c50726f706f73616c496e6465783e5470726f706f73616c5f7765696768745f626f756e643c436f6d706163743c5765696768743e306c656e6774685f626f756e6430436f6d706163743c7533323e6c510120436c6f7365206120766f746520746861742069732065697468657220617070726f7665642c20646973617070726f766564206f722077686f736520766f74696e6720706572696f642068617320656e6465642e005901204d61792062652063616c6c656420627920616e79207369676e6564206163636f756e7420696e206f7264657220746f2066696e69736820766f74696e6720616e6420636c6f7365207468652070726f706f73616c2e004d012049662063616c6c6564206265666f72652074686520656e64206f662074686520766f74696e6720706572696f642069742077696c6c206f6e6c7920636c6f73652074686520766f7465206966206974206973c02068617320656e6f75676820766f74657320746f20626520617070726f766564206f7220646973617070726f7665642e004d012049662063616c6c65642061667465722074686520656e64206f662074686520766f74696e6720706572696f642061627374656e74696f6e732061726520636f756e7465642061732072656a656374696f6e73290120756e6c6573732074686572652069732061207072696d65206d656d6265722073657420616e6420746865207072696d65206d656d626572206361737420616e20617070726f76616c2e008d01202b206070726f706f73616c5f7765696768745f626f756e64603a20546865206d6178696d756d20616d6f756e74206f662077656967687420636f6e73756d656420627920657865637574696e672074686520636c6f7365642070726f706f73616c2e6501202b20606c656e6774685f626f756e64603a2054686520757070657220626f756e6420666f7220746865206c656e677468206f66207468652070726f706f73616c20696e2073746f726167652e20436865636b6564207669618101202020202020202020202020202020202020206073746f726167653a3a726561646020736f206974206973206073697a655f6f663a3a3c7533323e2829203d3d203460206c6172676572207468616e207468652070757265206c656e6774682e002c2023203c7765696768743e282023232057656967687478202d20604f2842202b204d202b205031202b20503229602077686572653ae42020202d20604260206973206070726f706f73616c602073697a6520696e20627974657320286c656e6774682d6665652d626f756e64656429e02020202d20604d60206973206d656d626572732d636f756e742028636f64652d20616e6420676f7665726e616e63652d626f756e64656429cc2020202d20605031602069732074686520636f6d706c6578697479206f66206070726f706f73616c6020707265696d6167652ea82020202d20605032602069732070726f706f73616c2d636f756e742028636f64652d626f756e6465642918202d2044423a110120202d20322073746f726167652072656164732028604d656d62657273603a20636f64656320604f284d29602c20605072696d65603a20636f64656320604f2831296029810120202d2033206d75746174696f6e73202860566f74696e67603a20636f64656320604f284d29602c206050726f706f73616c4f66603a20636f64656320604f284229602c206050726f706f73616c73603a20636f64656320604f285032296029e020202d20616e79206d75746174696f6e7320646f6e65207768696c6520657865637574696e67206070726f706f73616c602028605031602944202d20757020746f2033206576656e7473302023203c2f7765696768743e4c646973617070726f76655f70726f706f73616c043470726f706f73616c5f686173681c543a3a4861736838790120446973617070726f766520612070726f706f73616c2c20636c6f73652c20616e642072656d6f76652069742066726f6d207468652073797374656d2c207265676172646c657373206f66206974732063757272656e742073746174652e008c204d7573742062652063616c6c65642062792074686520526f6f74206f726967696e2e003020506172616d65746572733a2101202a206070726f706f73616c5f68617368603a205468652068617368206f66207468652070726f706f73616c20746861742073686f756c6420626520646973617070726f7665642e002c2023203c7765696768743ee020436f6d706c65786974793a204f285029207768657265205020697320746865206e756d626572206f66206d61782070726f706f73616c73542042617365205765696768743a202e3439202a20502c204442205765696768743a4c202a2052656164733a2050726f706f73616c73a0202a205772697465733a20566f74696e672c2050726f706f73616c732c2050726f706f73616c4f66302023203c2f7765696768743e011c2050726f706f73656410244163636f756e7449643450726f706f73616c496e64657810486173682c4d656d626572436f756e74084d012041206d6f74696f6e2028676976656e20686173682920686173206265656e2070726f706f7365642028627920676976656e206163636f756e742920776974682061207468726573686f6c642028676976656e4020604d656d626572436f756e7460292e14566f74656414244163636f756e744964104861736810626f6f6c2c4d656d626572436f756e742c4d656d626572436f756e740809012041206d6f74696f6e2028676976656e20686173682920686173206265656e20766f746564206f6e20627920676976656e206163636f756e742c206c656176696e67190120612074616c6c79202879657320766f74657320616e64206e6f20766f74657320676976656e20726573706563746976656c7920617320604d656d626572436f756e7460292e20417070726f76656404104861736804c42041206d6f74696f6e2077617320617070726f76656420627920746865207265717569726564207468726573686f6c642e2c446973617070726f76656404104861736804d42041206d6f74696f6e20776173206e6f7420617070726f76656420627920746865207265717569726564207468726573686f6c642e204578656375746564081048617368384469737061746368526573756c740425012041206d6f74696f6e207761732065786563757465643b20726573756c742077696c6c20626520604f6b602069662069742072657475726e656420776974686f7574206572726f722e384d656d6265724578656375746564081048617368384469737061746368526573756c74044d0120412073696e676c65206d656d6265722064696420736f6d6520616374696f6e3b20726573756c742077696c6c20626520604f6b602069662069742072657475726e656420776974686f7574206572726f722e18436c6f7365640c10486173682c4d656d626572436f756e742c4d656d626572436f756e7404590120412070726f706f73616c2077617320636c6f736564206265636175736520697473207468726573686f6c64207761732072656163686564206f7220616674657220697473206475726174696f6e207761732075702e0028244e6f744d656d6265720460204163636f756e74206973206e6f742061206d656d626572444475706c696361746550726f706f73616c0480204475706c69636174652070726f706f73616c73206e6f7420616c6c6f7765643c50726f706f73616c4d697373696e6704502050726f706f73616c206d7573742065786973742857726f6e67496e6465780444204d69736d61746368656420696e646578344475706c6963617465566f7465045c204475706c696361746520766f74652069676e6f72656448416c7265616479496e697469616c697a65640484204d656d626572732061726520616c726561647920696e697469616c697a65642120546f6f4561726c790405012054686520636c6f73652063616c6c20776173206d61646520746f6f206561726c792c206265666f72652074686520656e64206f662074686520766f74696e672e40546f6f4d616e7950726f706f73616c730401012054686572652063616e206f6e6c792062652061206d6178696d756d206f6620604d617850726f706f73616c7360206163746976652070726f706f73616c732e4c57726f6e6750726f706f73616c57656967687404d42054686520676976656e2077656967687420626f756e6420666f72207468652070726f706f73616c2077617320746f6f206c6f772e4c57726f6e6750726f706f73616c4c656e67746804d42054686520676976656e206c656e67746820626f756e6420666f72207468652070726f706f73616c2077617320746f6f206c6f772e48546563686e6963616c436f6d6d6974746565014c496e7374616e636532436f6c6c656374697665182450726f706f73616c730100305665633c543a3a486173683e040004902054686520686173686573206f6620746865206163746976652070726f706f73616c732e2850726f706f73616c4f660001061c543a3a48617368643c542061732054726169743c493e3e3a3a50726f706f73616c00040004cc2041637475616c2070726f706f73616c20666f72206120676976656e20686173682c20696620697427732063757272656e742e18566f74696e670001061c543a3a486173688c566f7465733c543a3a4163636f756e7449642c20543a3a426c6f636b4e756d6265723e00040004b420566f746573206f6e206120676976656e2070726f706f73616c2c206966206974206973206f6e676f696e672e3450726f706f73616c436f756e7401000c753332100000000004482050726f706f73616c7320736f206661722e1c4d656d626572730100445665633c543a3a4163636f756e7449643e0400043901205468652063757272656e74206d656d62657273206f662074686520636f6c6c6563746976652e20546869732069732073746f72656420736f7274656420286a7573742062792076616c7565292e145072696d65000030543a3a4163636f756e7449640400085d0120546865206d656d6265722077686f2070726f7669646573207468652064656661756c7420766f746520666f7220616e79206f74686572206d656d62657273207468617420646f206e6f7420766f7465206265666f7265e4207468652074696d656f75742e204966204e6f6e652c207468656e206e6f206d656d6265722068617320746861742070726976696c6567652e01182c7365745f6d656d626572730c2c6e65775f6d656d62657273445665633c543a3a4163636f756e7449643e147072696d65504f7074696f6e3c543a3a4163636f756e7449643e246f6c645f636f756e742c4d656d626572436f756e746084205365742074686520636f6c6c6563746976652773206d656d626572736869702e004901202d20606e65775f6d656d62657273603a20546865206e6577206d656d626572206c6973742e204265206e69636520746f2074686520636861696e20616e642070726f7669646520697420736f727465642ee4202d20607072696d65603a20546865207072696d65206d656d6265722077686f736520766f74652073657473207468652064656661756c742e3901202d20606f6c645f636f756e74603a2054686520757070657220626f756e6420666f72207468652070726576696f7573206e756d626572206f66206d656d6265727320696e2073746f726167652eac202020202020202020202020202020205573656420666f722077656967687420657374696d6174696f6e2e005820526571756972657320726f6f74206f726967696e2e005901204e4f54453a20446f6573206e6f7420656e666f7263652074686520657870656374656420604d41585f4d454d4245525360206c696d6974206f6e2074686520616d6f756e74206f66206d656d626572732c206275742501202020202020207468652077656967687420657374696d6174696f6e732072656c79206f6e20697420746f20657374696d61746520646973706174636861626c65207765696768742e002c2023203c7765696768743e282023232057656967687454202d20604f284d50202b204e29602077686572653ae42020202d20604d60206f6c642d6d656d626572732d636f756e742028636f64652d20616e6420676f7665726e616e63652d626f756e64656429e42020202d20604e60206e65772d6d656d626572732d636f756e742028636f64652d20616e6420676f7665726e616e63652d626f756e646564299c2020202d206050602070726f706f73616c732d636f756e742028636f64652d626f756e6465642918202d2044423a75012020202d20312073746f72616765206d75746174696f6e2028636f64656320604f284d296020726561642c20604f284e29602077726974652920666f722072656164696e6720616e642077726974696e6720746865206d656d62657273f02020202d20312073746f7261676520726561642028636f64656320604f285029602920666f722072656164696e67207468652070726f706f73616c7349012020202d206050602073746f72616765206d75746174696f6e732028636f64656320604f284d29602920666f72207570646174696e672074686520766f74657320666f7220656163682070726f706f73616c61012020202d20312073746f726167652077726974652028636f64656320604f283129602920666f722064656c6574696e6720746865206f6c6420607072696d656020616e642073657474696e6720746865206e6577206f6e65302023203c2f7765696768743e1c65786563757465082070726f706f73616c78426f783c3c542061732054726169743c493e3e3a3a50726f706f73616c3e306c656e6774685f626f756e6430436f6d706163743c7533323e28f420446973706174636820612070726f706f73616c2066726f6d2061206d656d626572207573696e672074686520604d656d62657260206f726967696e2e00ac204f726967696e206d7573742062652061206d656d626572206f662074686520636f6c6c6563746976652e002c2023203c7765696768743e28202323205765696768748501202d20604f284d202b2050296020776865726520604d60206d656d626572732d636f756e742028636f64652d626f756e6465642920616e642060506020636f6d706c6578697479206f66206469737061746368696e67206070726f706f73616c60d8202d2044423a203120726561642028636f64656320604f284d296029202b20444220616363657373206f66206070726f706f73616c6028202d2031206576656e74302023203c2f7765696768743e1c70726f706f73650c247468726573686f6c6450436f6d706163743c4d656d626572436f756e743e2070726f706f73616c78426f783c3c542061732054726169743c493e3e3a3a50726f706f73616c3e306c656e6774685f626f756e6430436f6d706163743c7533323e6cfc204164642061206e65772070726f706f73616c20746f2065697468657220626520766f746564206f6e206f72206578656375746564206469726563746c792e0088205265717569726573207468652073656e64657220746f206265206d656d6265722e00450120607468726573686f6c64602064657465726d696e65732077686574686572206070726f706f73616c60206973206578656375746564206469726563746c792028607468726573686f6c64203c2032602958206f722070757420757020666f7220766f74696e672e002c2023203c7765696768743e2820232320576569676874b0202d20604f2842202b204d202b2050312960206f7220604f2842202b204d202b20503229602077686572653ae42020202d20604260206973206070726f706f73616c602073697a6520696e20627974657320286c656e6774682d6665652d626f756e64656429e02020202d20604d60206973206d656d626572732d636f756e742028636f64652d20616e6420676f7665726e616e63652d626f756e64656429c82020202d206272616e6368696e6720697320696e666c75656e63656420627920607468726573686f6c64602077686572653af820202020202d20605031602069732070726f706f73616c20657865637574696f6e20636f6d706c65786974792028607468726573686f6c64203c20326029010120202020202d20605032602069732070726f706f73616c732d636f756e742028636f64652d626f756e646564292028607468726573686f6c64203e3d2032602918202d2044423ab82020202d20312073746f726167652072656164206069735f6d656d626572602028636f64656320604f284d296029f42020202d20312073746f726167652072656164206050726f706f73616c4f663a3a636f6e7461696e735f6b6579602028636f64656320604f2831296029ac2020202d20444220616363657373657320696e666c75656e63656420627920607468726573686f6c64603a0d0120202020202d204549544845522073746f7261676520616363657373657320646f6e65206279206070726f706f73616c602028607468726573686f6c64203c20326029bc20202020202d204f522070726f706f73616c20696e73657274696f6e2028607468726573686f6c64203c3d20326029dc202020202020202d20312073746f72616765206d75746174696f6e206050726f706f73616c73602028636f64656320604f285032296029e8202020202020202d20312073746f72616765206d75746174696f6e206050726f706f73616c436f756e74602028636f64656320604f2831296029d0202020202020202d20312073746f72616765207772697465206050726f706f73616c4f66602028636f64656320604f2842296029c0202020202020202d20312073746f726167652077726974652060566f74696e67602028636f64656320604f284d296029302020202d2031206576656e74302023203c2f7765696768743e10766f74650c2070726f706f73616c1c543a3a4861736814696e64657858436f6d706163743c50726f706f73616c496e6465783e1c617070726f766510626f6f6c30f42041646420616e20617965206f72206e617920766f746520666f72207468652073656e64657220746f2074686520676976656e2070726f706f73616c2e0090205265717569726573207468652073656e64657220746f2062652061206d656d6265722e002c2023203c7765696768743e28202323205765696768740d01202d20604f284d296020776865726520604d60206973206d656d626572732d636f756e742028636f64652d20616e6420676f7665726e616e63652d626f756e6465642918202d2044423ab02020202d20312073746f72616765207265616420604d656d62657273602028636f64656320604f284d296029bc2020202d20312073746f72616765206d75746174696f6e2060566f74696e67602028636f64656320604f284d29602928202d2031206576656e74302023203c2f7765696768743e14636c6f7365103470726f706f73616c5f686173681c543a3a4861736814696e64657858436f6d706163743c50726f706f73616c496e6465783e5470726f706f73616c5f7765696768745f626f756e643c436f6d706163743c5765696768743e306c656e6774685f626f756e6430436f6d706163743c7533323e6c510120436c6f7365206120766f746520746861742069732065697468657220617070726f7665642c20646973617070726f766564206f722077686f736520766f74696e6720706572696f642068617320656e6465642e005901204d61792062652063616c6c656420627920616e79207369676e6564206163636f756e7420696e206f7264657220746f2066696e69736820766f74696e6720616e6420636c6f7365207468652070726f706f73616c2e004d012049662063616c6c6564206265666f72652074686520656e64206f662074686520766f74696e6720706572696f642069742077696c6c206f6e6c7920636c6f73652074686520766f7465206966206974206973c02068617320656e6f75676820766f74657320746f20626520617070726f766564206f7220646973617070726f7665642e004d012049662063616c6c65642061667465722074686520656e64206f662074686520766f74696e6720706572696f642061627374656e74696f6e732061726520636f756e7465642061732072656a656374696f6e73290120756e6c6573732074686572652069732061207072696d65206d656d6265722073657420616e6420746865207072696d65206d656d626572206361737420616e20617070726f76616c2e008d01202b206070726f706f73616c5f7765696768745f626f756e64603a20546865206d6178696d756d20616d6f756e74206f662077656967687420636f6e73756d656420627920657865637574696e672074686520636c6f7365642070726f706f73616c2e6501202b20606c656e6774685f626f756e64603a2054686520757070657220626f756e6420666f7220746865206c656e677468206f66207468652070726f706f73616c20696e2073746f726167652e20436865636b6564207669618101202020202020202020202020202020202020206073746f726167653a3a726561646020736f206974206973206073697a655f6f663a3a3c7533323e2829203d3d203460206c6172676572207468616e207468652070757265206c656e6774682e002c2023203c7765696768743e282023232057656967687478202d20604f2842202b204d202b205031202b20503229602077686572653ae42020202d20604260206973206070726f706f73616c602073697a6520696e20627974657320286c656e6774682d6665652d626f756e64656429e02020202d20604d60206973206d656d626572732d636f756e742028636f64652d20616e6420676f7665726e616e63652d626f756e64656429cc2020202d20605031602069732074686520636f6d706c6578697479206f66206070726f706f73616c6020707265696d6167652ea82020202d20605032602069732070726f706f73616c2d636f756e742028636f64652d626f756e6465642918202d2044423a110120202d20322073746f726167652072656164732028604d656d62657273603a20636f64656320604f284d29602c20605072696d65603a20636f64656320604f2831296029810120202d2033206d75746174696f6e73202860566f74696e67603a20636f64656320604f284d29602c206050726f706f73616c4f66603a20636f64656320604f284229602c206050726f706f73616c73603a20636f64656320604f285032296029e020202d20616e79206d75746174696f6e7320646f6e65207768696c6520657865637574696e67206070726f706f73616c602028605031602944202d20757020746f2033206576656e7473302023203c2f7765696768743e4c646973617070726f76655f70726f706f73616c043470726f706f73616c5f686173681c543a3a4861736838790120446973617070726f766520612070726f706f73616c2c20636c6f73652c20616e642072656d6f76652069742066726f6d207468652073797374656d2c207265676172646c657373206f66206974732063757272656e742073746174652e008c204d7573742062652063616c6c65642062792074686520526f6f74206f726967696e2e003020506172616d65746572733a2101202a206070726f706f73616c5f68617368603a205468652068617368206f66207468652070726f706f73616c20746861742073686f756c6420626520646973617070726f7665642e002c2023203c7765696768743ee020436f6d706c65786974793a204f285029207768657265205020697320746865206e756d626572206f66206d61782070726f706f73616c73542042617365205765696768743a202e3439202a20502c204442205765696768743a4c202a2052656164733a2050726f706f73616c73a0202a205772697465733a20566f74696e672c2050726f706f73616c732c2050726f706f73616c4f66302023203c2f7765696768743e011c2050726f706f73656410244163636f756e7449643450726f706f73616c496e64657810486173682c4d656d626572436f756e74084d012041206d6f74696f6e2028676976656e20686173682920686173206265656e2070726f706f7365642028627920676976656e206163636f756e742920776974682061207468726573686f6c642028676976656e4020604d656d626572436f756e7460292e14566f74656414244163636f756e744964104861736810626f6f6c2c4d656d626572436f756e742c4d656d626572436f756e740809012041206d6f74696f6e2028676976656e20686173682920686173206265656e20766f746564206f6e20627920676976656e206163636f756e742c206c656176696e67190120612074616c6c79202879657320766f74657320616e64206e6f20766f74657320676976656e20726573706563746976656c7920617320604d656d626572436f756e7460292e20417070726f76656404104861736804c42041206d6f74696f6e2077617320617070726f76656420627920746865207265717569726564207468726573686f6c642e2c446973617070726f76656404104861736804d42041206d6f74696f6e20776173206e6f7420617070726f76656420627920746865207265717569726564207468726573686f6c642e204578656375746564081048617368384469737061746368526573756c740425012041206d6f74696f6e207761732065786563757465643b20726573756c742077696c6c20626520604f6b602069662069742072657475726e656420776974686f7574206572726f722e384d656d6265724578656375746564081048617368384469737061746368526573756c74044d0120412073696e676c65206d656d6265722064696420736f6d6520616374696f6e3b20726573756c742077696c6c20626520604f6b602069662069742072657475726e656420776974686f7574206572726f722e18436c6f7365640c10486173682c4d656d626572436f756e742c4d656d626572436f756e7404590120412070726f706f73616c2077617320636c6f736564206265636175736520697473207468726573686f6c64207761732072656163686564206f7220616674657220697473206475726174696f6e207761732075702e0028244e6f744d656d6265720460204163636f756e74206973206e6f742061206d656d626572444475706c696361746550726f706f73616c0480204475706c69636174652070726f706f73616c73206e6f7420616c6c6f7765643c50726f706f73616c4d697373696e6704502050726f706f73616c206d7573742065786973742857726f6e67496e6465780444204d69736d61746368656420696e646578344475706c6963617465566f7465045c204475706c696361746520766f74652069676e6f72656448416c7265616479496e697469616c697a65640484204d656d626572732061726520616c726561647920696e697469616c697a65642120546f6f4561726c790405012054686520636c6f73652063616c6c20776173206d61646520746f6f206561726c792c206265666f72652074686520656e64206f662074686520766f74696e672e40546f6f4d616e7950726f706f73616c730401012054686572652063616e206f6e6c792062652061206d6178696d756d206f6620604d617850726f706f73616c7360206163746976652070726f706f73616c732e4c57726f6e6750726f706f73616c57656967687404d42054686520676976656e2077656967687420626f756e6420666f72207468652070726f706f73616c2077617320746f6f206c6f772e4c57726f6e6750726f706f73616c4c656e67746804d42054686520676976656e206c656e67746820626f756e6420666f72207468652070726f706f73616c2077617320746f6f206c6f772e24456c656374696f6e73014050687261676d656e456c656374696f6e141c4d656d626572730100845665633c28543a3a4163636f756e7449642c2042616c616e63654f663c543e293e040004f0205468652063757272656e7420656c6563746564206d656d626572736869702e20536f72746564206261736564206f6e206163636f756e742069642e2452756e6e65727355700100845665633c28543a3a4163636f756e7449642c2042616c616e63654f663c543e293e0400044901205468652063757272656e742072756e6e6572735f75702e20536f72746564206261736564206f6e206c6f7720746f2068696768206d657269742028776f72736520746f20626573742072756e6e6572292e38456c656374696f6e526f756e647301000c75333210000000000441012054686520746f74616c206e756d626572206f6620766f746520726f756e6473207468617420686176652068617070656e65642c206578636c7564696e6720746865207570636f6d696e67206f6e652e18566f74696e6701010530543a3a4163636f756e744964842842616c616e63654f663c543e2c205665633c543a3a4163636f756e7449643e29004400000000000000000000000000000000000cb820566f74657320616e64206c6f636b6564207374616b65206f66206120706172746963756c617220766f7465722e00c02054574f582d4e4f54453a205341464520617320604163636f756e7449646020697320612063727970746f20686173682843616e646964617465730100445665633c543a3a4163636f756e7449643e0400085901205468652070726573656e742063616e646964617465206c6973742e20536f72746564206261736564206f6e206163636f756e742d69642e20412063757272656e74206d656d626572206f722072756e6e65722d757041012063616e206e6576657220656e746572207468697320766563746f7220616e6420697320616c7761797320696d706c696369746c7920617373756d656420746f20626520612063616e6469646174652e011810766f74650814766f746573445665633c543a3a4163636f756e7449643e1476616c756554436f6d706163743c42616c616e63654f663c543e3e645d0120566f746520666f72206120736574206f662063616e6469646174657320666f7220746865207570636f6d696e6720726f756e64206f6620656c656374696f6e2e20546869732063616e2062652063616c6c656420746fe4207365742074686520696e697469616c20766f7465732c206f722075706461746520616c7265616479206578697374696e6720766f7465732e0055012055706f6e20696e697469616c20766f74696e672c206076616c75656020756e697473206f66206077686f6027732062616c616e6365206973206c6f636b656420616e64206120626f6e6420616d6f756e74206973282072657365727665642e0050205468652060766f746573602073686f756c643a482020202d206e6f7420626520656d7074792e59012020202d206265206c657373207468616e20746865206e756d626572206f6620706f737369626c652063616e646964617465732e204e6f7465207468617420616c6c2063757272656e74206d656d6265727320616e641501202020202072756e6e6572732d75702061726520616c736f206175746f6d61746963616c6c792063616e6469646174657320666f7220746865206e65787420726f756e642e005d012049742069732074686520726573706f6e736962696c697479206f66207468652063616c6c657220746f206e6f7420706c61636520616c6c206f662074686569722062616c616e636520696e746f20746865206c6f636ba020616e64206b65657020736f6d6520666f722066757274686572207472616e73616374696f6e732e002c2023203c7765696768743e5c2042617365207765696768743a2034372e393320c2b573342053746174652072656164733ad820092d2043616e646964617465732e6c656e2829202b204d656d626572732e6c656e2829202b2052756e6e65727355702e6c656e28295420092d20566f74696e67202869735f766f74657229d420092d205b4163636f756e7442616c616e63652877686f292028756e72657365727665202b20746f74616c5f62616c616e6365295d38205374617465207772697465733a2820092d20566f74696e672020092d204c6f636b1d0120092d205b4163636f756e7442616c616e63652877686f292028756e72657365727665202d2d206f6e6c79207768656e206372656174696e672061206e657720766f746572295d302023203c2f7765696768743e3072656d6f76655f766f746572003421012052656d6f766520606f726967696e60206173206120766f7465722e20546869732072656d6f76657320746865206c6f636b20616e642072657475726e732074686520626f6e642e002c2023203c7765696768743e582042617365207765696768743a2033362e3820c2b573a820416c6c207374617465206163636573732069732066726f6d20646f5f72656d6f76655f766f7465722e342053746174652072656164733a2820092d20566f74696e675820092d205b4163636f756e74446174612877686f295d38205374617465207772697465733a2820092d20566f74696e672420092d204c6f636b735820092d205b4163636f756e74446174612877686f295d302023203c2f7765696768743e507265706f72745f646566756e63745f766f746572041c646566756e6374c4446566756e6374566f7465723c3c543a3a4c6f6f6b7570206173205374617469634c6f6f6b75703e3a3a536f757263653e6c5d01205265706f727420607461726765746020666f72206265696e6720616e20646566756e637420766f7465722e20496e2063617365206f6620612076616c6964207265706f72742c20746865207265706f727465722069735d012072657761726465642062792074686520626f6e6420616d6f756e74206f662060746172676574602e204f74686572776973652c20746865207265706f7274657220697473656c662069732072656d6f76656420616e645c20746865697220626f6e6420697320736c61736865642e0088204120646566756e637420766f74657220697320646566696e656420746f2062653a4d012020202d206120766f7465722077686f73652063757272656e74207375626d697474656420766f7465732061726520616c6c20696e76616c69642e20692e652e20616c6c206f66207468656d20617265206e6ff020202020206c6f6e67657220612063616e646964617465206e6f7220616e20616374697665206d656d626572206f7220612072756e6e65722d75702e0000690120546865206f726967696e206d7573742070726f7669646520746865206e756d626572206f662063757272656e742063616e6469646174657320616e6420766f746573206f6620746865207265706f7274656420746172676574c020666f722074686520707572706f7365206f66206163637572617465207765696768742063616c63756c6174696f6e2e002c2023203c7765696768743eb4204e6f204261736520776569676874206261736564206f6e206d696e2073717561726520616e616c797369732ea420436f6d706c6578697479206f662063616e6469646174655f636f756e743a20312e37353520c2b5739020436f6d706c6578697479206f6620766f74655f636f756e743a2031382e353120c2b573342053746174652072656164733a542020092d20566f74696e67287265706f7274657229502020092d2043616e6469646174652e6c656e28294c2020092d20566f74696e672854617267657429d82020092d2043616e646964617465732c204d656d626572732c2052756e6e6572735570202869735f646566756e63745f766f7465722938205374617465207772697465733a7020092d204c6f636b287265706f72746572207c7c2074617267657429dc20092d205b4163636f756e7442616c616e6365287265706f72746572295d202b204163636f756e7442616c616e636528746172676574297820092d20566f74696e67287265706f72746572207c7c20746172676574295901204e6f74653a207468652064622061636365737320697320776f7273652077697468207265737065637420746f2064622c207768696368206973207768656e20746865207265706f727420697320636f72726563742e302023203c2f7765696768743e407375626d69745f63616e646964616379043c63616e6469646174655f636f756e7430436f6d706163743c7533323e5478205375626d6974206f6e6573656c6620666f722063616e6469646163792e006420412063616e6469646174652077696c6c206569746865723aec2020202d204c6f73652061742074686520656e64206f6620746865207465726d20616e6420666f7266656974207468656972206465706f7369742e2d012020202d2057696e20616e64206265636f6d652061206d656d6265722e204d656d626572732077696c6c206576656e7475616c6c7920676574207468656972207374617368206261636b2e55012020202d204265636f6d6520612072756e6e65722d75702e2052756e6e6572732d75707320617265207265736572766564206d656d6265727320696e2063617365206f6e65206765747320666f72636566756c6c7934202020202072656d6f7665642e002c2023203c7765696768743e60204261736520776569676874203d2033332e333320c2b573a420436f6d706c6578697479206f662063616e6469646174655f636f756e743a20302e33373520c2b573342053746174652072656164733a5020092d2043616e646964617465732e6c656e28293820092d2043616e646964617465732c20092d204d656d626572733420092d2052756e6e65727355706420092d205b4163636f756e7442616c616e63652877686f295d38205374617465207772697465733a6420092d205b4163636f756e7442616c616e63652877686f295d3820092d2043616e64696461746573302023203c2f7765696768743e4872656e6f756e63655f63616e646964616379042872656e6f756e63696e672852656e6f756e63696e679851012052656e6f756e6365206f6e65277320696e74656e74696f6e20746f20626520612063616e64696461746520666f7220746865206e65787420656c656374696f6e20726f756e642e203320706f74656e7469616c40206f7574636f6d65732065786973743a4101202d20606f726967696e6020697320612063616e64696461746520616e64206e6f7420656c656374656420696e20616e79207365742e20496e207468697320636173652c2074686520626f6e64206973f4202020756e72657365727665642c2072657475726e656420616e64206f726967696e2069732072656d6f76656420617320612063616e6469646174652e5901202d20606f726967696e6020697320612063757272656e742072756e6e65722d75702e20496e207468697320636173652c2074686520626f6e6420697320756e72657365727665642c2072657475726e656420616e64902020206f726967696e2069732072656d6f76656420617320612072756e6e65722d75702e4d01202d20606f726967696e6020697320612063757272656e74206d656d6265722e20496e207468697320636173652c2074686520626f6e6420697320756e726573657276656420616e64206f726967696e206973590120202072656d6f7665642061732061206d656d6265722c20636f6e73657175656e746c79206e6f74206265696e6720612063616e64696461746520666f7220746865206e65787420726f756e6420616e796d6f72652e650120202053696d696c617220746f205b6072656d6f76655f766f746572605d2c206966207265706c6163656d656e742072756e6e657273206578697374732c20746865792061726520696d6d6564696174656c7920757365642e24203c7765696768743e7820496620612063616e6469646174652069732072656e6f756e63696e673a60200942617365207765696768743a2031372e323820c2b573a82009436f6d706c6578697479206f662063616e6469646174655f636f756e743a20302e32333520c2b57338200953746174652072656164733a3c2009092d2043616e64696461746573982009092d205b4163636f756e7442616c616e63652877686f292028756e72657365727665295d3c20095374617465207772697465733a3c2009092d2043616e64696461746573982009092d205b4163636f756e7442616c616e63652877686f292028756e72657365727665295d64204966206d656d6265722069732072656e6f756e63696e673a60200942617365207765696768743a2034362e323520c2b57338200953746174652072656164733ad02009092d204d656d626572732c2052756e6e6572735570202872656d6f76655f616e645f7265706c6163655f6d656d626572292c8c2009092d205b4163636f756e74446174612877686f292028756e72657365727665295d3c20095374617465207772697465733ad02009092d204d656d626572732c2052756e6e6572735570202872656d6f76655f616e645f7265706c6163655f6d656d626572292c8c2009092d205b4163636f756e74446174612877686f292028756e72657365727665295d642049662072756e6e65722069732072656e6f756e63696e673a60200942617365207765696768743a2034362e323520c2b57338200953746174652072656164733aac2009092d2052756e6e6572735570202872656d6f76655f616e645f7265706c6163655f6d656d626572292c8c2009092d205b4163636f756e74446174612877686f292028756e72657365727665295d3c20095374617465207772697465733aac2009092d2052756e6e6572735570202872656d6f76655f616e645f7265706c6163655f6d656d626572292c8c2009092d205b4163636f756e74446174612877686f292028756e72657365727665295d000d0120576569676874206e6f74653a205468652063616c6c20696e746f206368616e67654d656d62657273206e65656420746f206265206163636f756e74656420666f722e28203c2f7765696768743e3472656d6f76655f6d656d626572080c77686f8c3c543a3a4c6f6f6b7570206173205374617469634c6f6f6b75703e3a3a536f757263653c6861735f7265706c6163656d656e7410626f6f6c485d012052656d6f7665206120706172746963756c6172206d656d6265722066726f6d20746865207365742e20546869732069732065666665637469766520696d6d6564696174656c7920616e642074686520626f6e64206f668020746865206f7574676f696e67206d656d62657220697320736c61736865642e00590120496620612072756e6e65722d757020697320617661696c61626c652c207468656e2074686520626573742072756e6e65722d75702077696c6c2062652072656d6f76656420616e64207265706c61636573207468650101206f7574676f696e67206d656d6265722e204f74686572776973652c2061206e65772070687261676d656e20656c656374696f6e20697320737461727465642e004501204e6f74652074686174207468697320646f6573206e6f7420616666656374207468652064657369676e6174656420626c6f636b206e756d626572206f6620746865206e65787420656c656374696f6e2e002c2023203c7765696768743e6820496620776520686176652061207265706c6163656d656e743a6820092d2042617365207765696768743a2035302e393320c2b5734020092d2053746174652072656164733a502009092d2052756e6e65727355702e6c656e2829cc2009092d204d656d626572732c2052756e6e6572735570202872656d6f76655f616e645f7265706c6163655f6d656d626572294420092d205374617465207772697465733acc2009092d204d656d626572732c2052756e6e6572735570202872656d6f76655f616e645f7265706c6163655f6d656d62657229650120456c73652c2073696e63652074686973206973206120726f6f742063616c6c20616e642077696c6c20676f20696e746f2070687261676d656e2c20776520617373756d652066756c6c20626c6f636b20666f72206e6f772e302023203c2f7765696768743e01141c4e65775465726d04645665633c284163636f756e7449642c2042616c616e6365293e1059012041206e6577207465726d2077697468206e6577206d656d626572732e205468697320696e64696361746573207468617420656e6f7567682063616e64696461746573206578697374656420746f2072756e20746865590120656c656374696f6e2c206e6f74207468617420656e6f756768206861766520686173206265656e20656c65637465642e2054686520696e6e65722076616c7565206d757374206265206578616d696e656420666f726101207468697320707572706f73652e204120604e65775465726d285b5d296020696e64696361746573207468617420736f6d652063616e6469646174657320676f7420746865697220626f6e6420736c617368656420616e645901206e6f6e65207765726520656c65637465642c207768696c73742060456d7074795465726d60206d65616e732074686174206e6f2063616e64696461746573206578697374656420746f20626567696e20776974682e24456d7074795465726d00083501204e6f20286f72206e6f7420656e6f756768292063616e64696461746573206578697374656420666f72207468697320726f756e642e205468697320697320646966666572656e742066726f6dc420604e65775465726d285b5d29602e2053656520746865206465736372697074696f6e206f6620604e65775465726d602e304d656d6265724b69636b656404244163636f756e7449640845012041206d656d62657220686173206265656e2072656d6f7665642e20546869732073686f756c6420616c7761797320626520666f6c6c6f7765642062792065697468657220604e65775465726d60206f74342060456d7074795465726d602e3c4d656d62657252656e6f756e63656404244163636f756e74496404a02041206d656d626572206861732072656e6f756e6365642074686569722063616e6469646163792e34566f7465725265706f727465640c244163636f756e744964244163636f756e74496410626f6f6c086101204120766f7465722028666972737420656c656d656e742920776173207265706f72746564202862797420746865207365636f6e6420656c656d656e742920776974682074686520746865207265706f7274206265696e678c207375636365737366756c206f72206e6f742028746869726420656c656d656e74292e183443616e646964616379426f6e643042616c616e63654f663c543e400080c6a47e8d030000000000000000000028566f74696e67426f6e643042616c616e63654f663c543e4000407a10f35a000000000000000000000038446573697265644d656d626572730c753332100d00000000404465736972656452756e6e65727355700c753332100700000000305465726d4475726174696f6e38543a3a426c6f636b4e756d626572108013030000204d6f64756c654964384c6f636b4964656e74696669657220706872656c656374004430556e61626c65546f566f746504c42043616e6e6f7420766f7465207768656e206e6f2063616e64696461746573206f72206d656d626572732065786973742e1c4e6f566f7465730498204d75737420766f746520666f72206174206c65617374206f6e652063616e6469646174652e30546f6f4d616e79566f74657304882043616e6e6f7420766f7465206d6f7265207468616e2063616e646964617465732e504d6178696d756d566f7465734578636565646564049c2043616e6e6f7420766f7465206d6f7265207468616e206d6178696d756d20616c6c6f7765642e284c6f7742616c616e636504c82043616e6e6f7420766f74652077697468207374616b65206c657373207468616e206d696e696d756d2062616c616e63652e3c556e61626c65546f506179426f6e64047c20566f7465722063616e206e6f742070617920766f74696e6720626f6e642e2c4d7573744265566f7465720444204d757374206265206120766f7465722e285265706f727453656c6604502043616e6e6f74207265706f72742073656c662e4c4475706c69636174656443616e6469646174650484204475706c6963617465642063616e646964617465207375626d697373696f6e2e304d656d6265725375626d6974048c204d656d6265722063616e6e6f742072652d7375626d69742063616e6469646163792e3052756e6e65725375626d6974048c2052756e6e65722063616e6e6f742072652d7375626d69742063616e6469646163792e68496e73756666696369656e7443616e64696461746546756e647304982043616e64696461746520646f6573206e6f74206861766520656e6f7567682066756e64732e244e6f744d656d6265720438204e6f742061206d656d6265722e54496e76616c696443616e646964617465436f756e7404e4205468652070726f766964656420636f756e74206f66206e756d626572206f662063616e6469646174657320697320696e636f72726563742e40496e76616c6964566f7465436f756e7404d0205468652070726f766964656420636f756e74206f66206e756d626572206f6620766f74657320697320696e636f72726563742e44496e76616c696452656e6f756e63696e67040101205468652072656e6f756e63696e67206f726967696e2070726573656e74656420612077726f6e67206052656e6f756e63696e676020706172616d657465722e48496e76616c69645265706c6163656d656e740401012050726564696374696f6e20726567617264696e67207265706c6163656d656e74206166746572206d656d6265722072656d6f76616c2069732077726f6e672e4c546563686e6963616c4d656d62657273686970014c496e7374616e6365314d656d62657273686970081c4d656d626572730100445665633c543a3a4163636f756e7449643e040004c8205468652063757272656e74206d656d626572736869702c2073746f72656420617320616e206f726465726564205665632e145072696d65000030543a3a4163636f756e744964040004a4205468652063757272656e74207072696d65206d656d6265722c206966206f6e65206578697374732e011c286164645f6d656d626572040c77686f30543a3a4163636f756e7449640c7c204164642061206d656d626572206077686f6020746f20746865207365742e00a0204d6179206f6e6c792062652063616c6c65642066726f6d2060543a3a4164644f726967696e602e3472656d6f76655f6d656d626572040c77686f30543a3a4163636f756e7449640c902052656d6f76652061206d656d626572206077686f602066726f6d20746865207365742e00ac204d6179206f6e6c792062652063616c6c65642066726f6d2060543a3a52656d6f76654f726967696e602e2c737761705f6d656d626572081872656d6f766530543a3a4163636f756e7449640c61646430543a3a4163636f756e74496414c02053776170206f7574206f6e65206d656d626572206072656d6f76656020666f7220616e6f746865722060616464602e00a4204d6179206f6e6c792062652063616c6c65642066726f6d2060543a3a537761704f726967696e602e001101205072696d65206d656d62657273686970206973202a6e6f742a207061737365642066726f6d206072656d6f76656020746f2060616464602c20696620657874616e742e3472657365745f6d656d62657273041c6d656d62657273445665633c543a3a4163636f756e7449643e105901204368616e676520746865206d656d6265727368697020746f2061206e6577207365742c20646973726567617264696e6720746865206578697374696e67206d656d626572736869702e204265206e69636520616e646c207061737320606d656d6265727360207072652d736f727465642e00a8204d6179206f6e6c792062652063616c6c65642066726f6d2060543a3a52657365744f726967696e602e286368616e67655f6b6579040c6e657730543a3a4163636f756e74496414d82053776170206f7574207468652073656e64696e67206d656d62657220666f7220736f6d65206f74686572206b657920606e6577602e00f4204d6179206f6e6c792062652063616c6c65642066726f6d20605369676e656460206f726967696e206f6620612063757272656e74206d656d6265722e002101205072696d65206d656d62657273686970206973207061737365642066726f6d20746865206f726967696e206163636f756e7420746f20606e6577602c20696620657874616e742e247365745f7072696d65040c77686f30543a3a4163636f756e7449640cc02053657420746865207072696d65206d656d6265722e204d75737420626520612063757272656e74206d656d6265722e00a8204d6179206f6e6c792062652063616c6c65642066726f6d2060543a3a5072696d654f726967696e602e2c636c6561725f7072696d65000c982052656d6f766520746865207072696d65206d656d626572206966206974206578697374732e00a8204d6179206f6e6c792062652063616c6c65642066726f6d2060543a3a5072696d654f726967696e602e01182c4d656d62657241646465640004e42054686520676976656e206d656d626572207761732061646465643b2073656520746865207472616e73616374696f6e20666f722077686f2e344d656d62657252656d6f7665640004ec2054686520676976656e206d656d626572207761732072656d6f7665643b2073656520746865207472616e73616374696f6e20666f722077686f2e384d656d62657273537761707065640004dc2054776f206d656d62657273207765726520737761707065643b2073656520746865207472616e73616374696f6e20666f722077686f2e304d656d6265727352657365740004190120546865206d656d62657273686970207761732072657365743b2073656520746865207472616e73616374696f6e20666f722077686f20746865206e6577207365742069732e284b65794368616e676564000488204f6e65206f6620746865206d656d6265727327206b657973206368616e6765642e1444756d6d7904bc73705f7374643a3a6d61726b65723a3a5068616e746f6d446174613c284163636f756e7449642c204576656e74293e0470205068616e746f6d206d656d6265722c206e6576657220757365642e00003c46696e616c697479547261636b65720001042866696e616c5f68696e74041068696e745c436f6d706163743c543a3a426c6f636b4e756d6265723e08f42048696e7420746861742074686520617574686f72206f66207468697320626c6f636b207468696e6b732074686520626573742066696e616c697a65646c20626c6f636b2069732074686520676976656e206e756d6265722e00082857696e646f7753697a6538543a3a426c6f636b4e756d626572106500000004190120546865206e756d626572206f6620726563656e742073616d706c657320746f206b6565702066726f6d207468697320636861696e2e2044656661756c74206973203130312e345265706f72744c6174656e637938543a3a426c6f636b4e756d62657210e8030000041d01205468652064656c617920616674657220776869636820706f696e74207468696e6773206265636f6d6520737573706963696f75732e2044656661756c7420697320313030302e0838416c72656164795570646174656404c82046696e616c2068696e74206d7573742062652075706461746564206f6e6c79206f6e636520696e2074686520626c6f636b1c42616448696e7404902046696e616c697a6564206865696768742061626f766520626c6f636b206e756d6265721c4772616e647061013c4772616e64706146696e616c6974791814537461746501006c53746f72656453746174653c543a3a426c6f636b4e756d6265723e04000490205374617465206f66207468652063757272656e7420617574686f72697479207365742e3450656e64696e674368616e676500008c53746f72656450656e64696e674368616e67653c543a3a426c6f636b4e756d6265723e040004c42050656e64696e67206368616e67653a20287369676e616c65642061742c207363686564756c6564206368616e6765292e284e657874466f72636564000038543a3a426c6f636b4e756d626572040004bc206e65787420626c6f636b206e756d6265722077686572652077652063616e20666f7263652061206368616e67652e1c5374616c6c656400008028543a3a426c6f636b4e756d6265722c20543a3a426c6f636b4e756d626572290400049020607472756560206966207765206172652063757272656e746c79207374616c6c65642e3043757272656e7453657449640100145365744964200000000000000000085d0120546865206e756d626572206f66206368616e6765732028626f746820696e207465726d73206f66206b65797320616e6420756e6465726c79696e672065636f6e6f6d696320726573706f6e736962696c697469657329c420696e20746865202273657422206f66204772616e6470612076616c696461746f72732066726f6d2067656e657369732e30536574496453657373696f6e0001051453657449643053657373696f6e496e6465780004001059012041206d617070696e672066726f6d206772616e6470612073657420494420746f2074686520696e646578206f6620746865202a6d6f737420726563656e742a2073657373696f6e20666f722077686963682069747368206d656d62657273207765726520726573706f6e7369626c652e00b82054574f582d4e4f54453a2060536574496460206973206e6f7420756e646572207573657220636f6e74726f6c2e01044c7265706f72745f65717569766f636174696f6e084865717569766f636174696f6e5f70726f6f66a845717569766f636174696f6e50726f6f663c543a3a486173682c20543a3a426c6f636b4e756d6265723e3c6b65795f6f776e65725f70726f6f6640543a3a4b65794f776e657250726f6f66200d01205265706f727420766f7465722065717569766f636174696f6e2f6d69736265686176696f722e2054686973206d6574686f642077696c6c2076657269667920746865f82065717569766f636174696f6e2070726f6f6620616e642076616c69646174652074686520676976656e206b6579206f776e6572736869702070726f6f66fc20616761696e73742074686520657874726163746564206f6666656e6465722e20496620626f7468206172652076616c69642c20746865206f6666656e6365482077696c6c206265207265706f727465642e0005012053696e63652074686520776569676874206f66207468652065787472696e73696320697320302c20696e206f7264657220746f2061766f696420446f532062792901207375626d697373696f6e206f6620696e76616c69642065717569766f636174696f6e207265706f7274732c2061206d616e6461746f7279207072652d76616c69646174696f6e206f66d4207468652065787472696e73696320697320696d706c656d656e74656420696e206120605369676e6564457874656e73696f6e602e010c384e6577417574686f7269746965730434417574686f726974794c6973740490204e657720617574686f726974792073657420686173206265656e206170706c6965642e1850617573656400049c2043757272656e7420617574686f726974792073657420686173206265656e207061757365642e1c526573756d65640004a02043757272656e7420617574686f726974792073657420686173206265656e20726573756d65642e00182c50617573654661696c656408090120417474656d707420746f207369676e616c204752414e445041207061757365207768656e2074686520617574686f72697479207365742069736e2774206c697665a8202865697468657220706175736564206f7220616c72656164792070656e64696e67207061757365292e30526573756d654661696c656408150120417474656d707420746f207369676e616c204752414e44504120726573756d65207768656e2074686520617574686f72697479207365742069736e277420706175736564a42028656974686572206c697665206f7220616c72656164792070656e64696e6720726573756d65292e344368616e676550656e64696e6704ec20417474656d707420746f207369676e616c204752414e445041206368616e67652077697468206f6e6520616c72656164792070656e64696e672e1c546f6f536f6f6e04c02043616e6e6f74207369676e616c20666f72636564206368616e676520736f20736f6f6e206166746572206c6173742e60496e76616c69644b65794f776e65727368697050726f6f660435012041206b6579206f776e6572736869702070726f6f662070726f76696465642061732070617274206f6620616e2065717569766f636174696f6e207265706f727420697320696e76616c69642e584475706c69636174654f6666656e63655265706f7274041901204120676976656e2065717569766f636174696f6e207265706f72742069732076616c69642062757420616c72656164792070726576696f75736c79207265706f727465642e20547265617375727901205472656173757279143450726f706f73616c436f756e7401003450726f706f73616c496e646578100000000004a4204e756d626572206f662070726f706f73616c7320746861742068617665206265656e206d6164652e2450726f706f73616c730001053450726f706f73616c496e6465789050726f706f73616c3c543a3a4163636f756e7449642c2042616c616e63654f663c543e3e000400047c2050726f706f73616c7320746861742068617665206265656e206d6164652e24417070726f76616c730100485665633c50726f706f73616c496e6465783e040004f82050726f706f73616c20696e646963657320746861742068617665206265656e20617070726f76656420627574206e6f742079657420617761726465642e10546970730001051c543a3a48617368f04f70656e5469703c543a3a4163636f756e7449642c2042616c616e63654f663c543e2c20543a3a426c6f636b4e756d6265722c20543a3a486173683e0004000c59012054697073207468617420617265206e6f742079657420636f6d706c657465642e204b65796564206279207468652068617368206f66206028726561736f6e2c2077686f29602066726f6d207468652076616c75652e3d012054686973206861732074686520696e73656375726520656e756d657261626c6520686173682066756e6374696f6e2073696e636520746865206b657920697473656c6620697320616c7265616479802067756172616e7465656420746f20626520612073656375726520686173682e1c526561736f6e730001061c543a3a486173681c5665633c75383e0004000849012053696d706c6520707265696d616765206c6f6f6b75702066726f6d2074686520726561736f6e2773206861736820746f20746865206f726967696e616c20646174612e20416761696e2c2068617320616e610120696e73656375726520656e756d657261626c6520686173682073696e636520746865206b65792069732067756172616e7465656420746f2062652074686520726573756c74206f6620612073656375726520686173682e01203470726f706f73655f7370656e64081476616c756554436f6d706163743c42616c616e63654f663c543e3e2c62656e65666963696172798c3c543a3a4c6f6f6b7570206173205374617469634c6f6f6b75703e3a3a536f75726365242d012050757420666f727761726420612073756767657374696f6e20666f72207370656e64696e672e2041206465706f7369742070726f706f7274696f6e616c20746f207468652076616c7565350120697320726573657276656420616e6420736c6173686564206966207468652070726f706f73616c2069732072656a65637465642e2049742069732072657475726e6564206f6e636520746865542070726f706f73616c20697320617761726465642e002c2023203c7765696768743e4c202d20436f6d706c65786974793a204f283129b4202d20446252656164733a206050726f706f73616c436f756e74602c20606f726967696e206163636f756e7460ec202d2044625772697465733a206050726f706f73616c436f756e74602c206050726f706f73616c73602c20606f726967696e206163636f756e7460302023203c2f7765696768743e3c72656a6563745f70726f706f73616c042c70726f706f73616c5f696458436f6d706163743c50726f706f73616c496e6465783e24fc2052656a65637420612070726f706f736564207370656e642e20546865206f726967696e616c206465706f7369742077696c6c20626520736c61736865642e00ac204d6179206f6e6c792062652063616c6c65642066726f6d2060543a3a52656a6563744f726967696e602e002c2023203c7765696768743e4c202d20436f6d706c65786974793a204f283129d0202d20446252656164733a206050726f706f73616c73602c206072656a65637465642070726f706f736572206163636f756e7460d4202d2044625772697465733a206050726f706f73616c73602c206072656a65637465642070726f706f736572206163636f756e7460302023203c2f7765696768743e40617070726f76655f70726f706f73616c042c70726f706f73616c5f696458436f6d706163743c50726f706f73616c496e6465783e285d0120417070726f766520612070726f706f73616c2e2041742061206c617465722074696d652c207468652070726f706f73616c2077696c6c20626520616c6c6f636174656420746f207468652062656e6566696369617279ac20616e6420746865206f726967696e616c206465706f7369742077696c6c2062652072657475726e65642e00b0204d6179206f6e6c792062652063616c6c65642066726f6d2060543a3a417070726f76654f726967696e602e002c2023203c7765696768743e50202d20436f6d706c65786974793a204f2831292e90202d20446252656164733a206050726f706f73616c73602c2060417070726f76616c73605c202d20446257726974653a2060417070726f76616c7360302023203c2f7765696768743e387265706f72745f617765736f6d650818726561736f6e1c5665633c75383e0c77686f30543a3a4163636f756e7449644c5d01205265706f727420736f6d657468696e672060726561736f6e60207468617420646573657276657320612074697020616e6420636c61696d20616e79206576656e7475616c207468652066696e6465722773206665652e00d020546865206469737061746368206f726967696e20666f7220746869732063616c6c206d757374206265205f5369676e65645f2e005501205061796d656e743a20605469705265706f72744465706f73697442617365602077696c6c2062652072657365727665642066726f6d20746865206f726967696e206163636f756e742c2061732077656c6c206173d420605469705265706f72744465706f736974506572427974656020666f722065616368206279746520696e2060726561736f6e602e006101202d2060726561736f6e603a2054686520726561736f6e20666f722c206f7220746865207468696e6720746861742064657365727665732c20746865207469703b2067656e6572616c6c7920746869732077696c6c2062655c20202061205554462d382d656e636f6465642055524c2eec202d206077686f603a20546865206163636f756e742077686963682073686f756c6420626520637265646974656420666f7220746865207469702e007820456d69747320604e657754697060206966207375636365737366756c2e002c2023203c7765696768743ecc202d20436f6d706c65786974793a20604f2852296020776865726520605260206c656e677468206f662060726561736f6e602e942020202d20656e636f64696e6720616e642068617368696e67206f662027726561736f6e27c4202d20446252656164733a2060526561736f6e73602c206054697073602c206077686f206163636f756e742064617461609c202d2044625772697465733a206054697073602c206077686f206163636f756e74206461746160302023203c2f7765696768743e2c726574726163745f7469700410686173681c543a3a486173684c550120526574726163742061207072696f72207469702d7265706f72742066726f6d20607265706f72745f617765736f6d65602c20616e642063616e63656c207468652070726f63657373206f662074697070696e672e00e0204966207375636365737366756c2c20746865206f726967696e616c206465706f7369742077696c6c20626520756e72657365727665642e00510120546865206469737061746368206f726967696e20666f7220746869732063616c6c206d757374206265205f5369676e65645f20616e642074686520746970206964656e746966696564206279206068617368604501206d7573742068617665206265656e207265706f7274656420627920746865207369676e696e67206163636f756e74207468726f75676820607265706f72745f617765736f6d65602028616e64206e6f7450207468726f75676820607469705f6e657760292e006501202d206068617368603a20546865206964656e74697479206f6620746865206f70656e2074697020666f722077686963682061207469702076616c7565206973206465636c617265642e205468697320697320666f726d656461012020206173207468652068617368206f6620746865207475706c65206f6620746865206f726967696e616c207469702060726561736f6e6020616e64207468652062656e6566696369617279206163636f756e742049442e009020456d697473206054697052657472616374656460206966207375636365737366756c2e002c2023203c7765696768743e54202d20436f6d706c65786974793a20604f28312960dc2020202d20446570656e6473206f6e20746865206c656e677468206f662060543a3a48617368602077686963682069732066697865642e90202d20446252656164733a206054697073602c20606f726967696e206163636f756e7460c0202d2044625772697465733a2060526561736f6e73602c206054697073602c20606f726967696e206163636f756e7460302023203c2f7765696768743e1c7469705f6e65770c18726561736f6e1c5665633c75383e0c77686f30543a3a4163636f756e744964247469705f76616c75653042616c616e63654f663c543e58f4204769766520612074697020666f7220736f6d657468696e67206e65773b206e6f2066696e6465722773206665652077696c6c2062652074616b656e2e00550120546865206469737061746368206f726967696e20666f7220746869732063616c6c206d757374206265205f5369676e65645f20616e6420746865207369676e696e67206163636f756e74206d757374206265206174206d656d626572206f662074686520605469707065727360207365742e006101202d2060726561736f6e603a2054686520726561736f6e20666f722c206f7220746865207468696e6720746861742064657365727665732c20746865207469703b2067656e6572616c6c7920746869732077696c6c2062655c20202061205554462d382d656e636f6465642055524c2eec202d206077686f603a20546865206163636f756e742077686963682073686f756c6420626520637265646974656420666f7220746865207469702e5101202d20607469705f76616c7565603a2054686520616d6f756e74206f66207469702074686174207468652073656e64657220776f756c64206c696b6520746f20676976652e20546865206d656469616e20746970d820202076616c7565206f662061637469766520746970706572732077696c6c20626520676976656e20746f20746865206077686f602e007820456d69747320604e657754697060206966207375636365737366756c2e002c2023203c7765696768743e5501202d20436f6d706c65786974793a20604f2852202b2054296020776865726520605260206c656e677468206f662060726561736f6e602c2060546020697320746865206e756d626572206f6620746970706572732ec02020202d20604f285429603a206465636f64696e6720605469707065726020766563206f66206c656e6774682060546009012020202020605460206973206368617267656420617320757070657220626f756e6420676976656e2062792060436f6e7461696e734c656e677468426f756e64602e0d0120202020205468652061637475616c20636f737420646570656e6473206f6e2074686520696d706c656d656e746174696f6e206f662060543a3a54697070657273602ee42020202d20604f285229603a2068617368696e6720616e6420656e636f64696e67206f6620726561736f6e206f66206c656e6774682060526080202d20446252656164733a206054697070657273602c2060526561736f6e736078202d2044625772697465733a2060526561736f6e73602c20605469707360302023203c2f7765696768743e0c7469700810686173681c543a3a48617368247469705f76616c75653042616c616e63654f663c543e64b4204465636c6172652061207469702076616c756520666f7220616e20616c72656164792d6f70656e207469702e00550120546865206469737061746368206f726967696e20666f7220746869732063616c6c206d757374206265205f5369676e65645f20616e6420746865207369676e696e67206163636f756e74206d757374206265206174206d656d626572206f662074686520605469707065727360207365742e006501202d206068617368603a20546865206964656e74697479206f6620746865206f70656e2074697020666f722077686963682061207469702076616c7565206973206465636c617265642e205468697320697320666f726d656461012020206173207468652068617368206f6620746865207475706c65206f66207468652068617368206f6620746865206f726967696e616c207469702060726561736f6e6020616e64207468652062656e6566696369617279382020206163636f756e742049442e5101202d20607469705f76616c7565603a2054686520616d6f756e74206f66207469702074686174207468652073656e64657220776f756c64206c696b6520746f20676976652e20546865206d656469616e20746970d820202076616c7565206f662061637469766520746970706572732077696c6c20626520676976656e20746f20746865206077686f602e00650120456d6974732060546970436c6f73696e676020696620746865207468726573686f6c64206f66207469707065727320686173206265656e207265616368656420616e642074686520636f756e74646f776e20706572696f64342068617320737461727465642e002c2023203c7765696768743ee4202d20436f6d706c65786974793a20604f285429602077686572652060546020697320746865206e756d626572206f6620746970706572732e15012020206465636f64696e6720605469707065726020766563206f66206c656e677468206054602c20696e736572742074697020616e6420636865636b20636c6f73696e672c0101202020605460206973206368617267656420617320757070657220626f756e6420676976656e2062792060436f6e7461696e734c656e677468426f756e64602e05012020205468652061637475616c20636f737420646570656e6473206f6e2074686520696d706c656d656e746174696f6e206f662060543a3a54697070657273602e00610120202041637475616c6c792077656967687420636f756c64206265206c6f77657220617320697420646570656e6473206f6e20686f77206d616e7920746970732061726520696e20604f70656e5469706020627574206974d4202020697320776569676874656420617320696620616c6d6f73742066756c6c20692e65206f66206c656e6774682060542d31602e74202d20446252656164733a206054697070657273602c206054697073604c202d2044625772697465733a20605469707360302023203c2f7765696768743e24636c6f73655f7469700410686173681c543a3a48617368446020436c6f736520616e64207061796f75742061207469702e00d020546865206469737061746368206f726967696e20666f7220746869732063616c6c206d757374206265205f5369676e65645f2e0019012054686520746970206964656e74696669656420627920606861736860206d75737420686176652066696e69736865642069747320636f756e74646f776e20706572696f642e006501202d206068617368603a20546865206964656e74697479206f6620746865206f70656e2074697020666f722077686963682061207469702076616c7565206973206465636c617265642e205468697320697320666f726d656461012020206173207468652068617368206f6620746865207475706c65206f6620746865206f726967696e616c207469702060726561736f6e6020616e64207468652062656e6566696369617279206163636f756e742049442e002c2023203c7765696768743ee4202d20436f6d706c65786974793a20604f285429602077686572652060546020697320746865206e756d626572206f6620746970706572732e9c2020206465636f64696e6720605469707065726020766563206f66206c656e677468206054602e0101202020605460206973206368617267656420617320757070657220626f756e6420676976656e2062792060436f6e7461696e734c656e677468426f756e64602e05012020205468652061637475616c20636f737420646570656e6473206f6e2074686520696d706c656d656e746174696f6e206f662060543a3a54697070657273602eac202d20446252656164733a206054697073602c206054697070657273602c20607469702066696e64657260dc202d2044625772697465733a2060526561736f6e73602c206054697073602c206054697070657273602c20607469702066696e64657260302023203c2f7765696768743e012c2050726f706f736564043450726f706f73616c496e6465780438204e65772070726f706f73616c2e205370656e64696e67041c42616c616e636504e8205765206861766520656e6465642061207370656e6420706572696f6420616e642077696c6c206e6f7720616c6c6f636174652066756e64732e1c417761726465640c3450726f706f73616c496e6465781c42616c616e6365244163636f756e744964048020536f6d652066756e64732068617665206265656e20616c6c6f63617465642e2052656a6563746564083450726f706f73616c496e6465781c42616c616e636504b420412070726f706f73616c207761732072656a65637465643b2066756e6473207765726520736c61736865642e144275726e74041c42616c616e6365048c20536f6d65206f66206f75722066756e64732068617665206265656e206275726e742e20526f6c6c6f766572041c42616c616e6365043101205370656e64696e67206861732066696e69736865643b20746869732069732074686520616d6f756e74207468617420726f6c6c73206f76657220756e74696c206e657874207370656e642e1c4465706f736974041c42616c616e6365048020536f6d652066756e64732068617665206265656e206465706f73697465642e184e657754697004104861736804982041206e6577207469702073756767657374696f6e20686173206265656e206f70656e65642e28546970436c6f73696e6704104861736804dc2041207469702073756767657374696f6e206861732072656163686564207468726573686f6c6420616e6420697320636c6f73696e672e24546970436c6f7365640c1048617368244163636f756e7449641c42616c616e636504882041207469702073756767657374696f6e20686173206265656e20636c6f7365642e3054697052657472616374656404104861736804942041207469702073756767657374696f6e20686173206265656e207265747261637465642e243050726f706f73616c426f6e641c5065726d696c6c1050c30000085501204672616374696f6e206f6620612070726f706f73616c27732076616c756520746861742073686f756c6420626520626f6e64656420696e206f7264657220746f20706c616365207468652070726f706f73616c2e110120416e2061636365707465642070726f706f73616c2067657473207468657365206261636b2e20412072656a65637465642070726f706f73616c20646f6573206e6f742e4c50726f706f73616c426f6e644d696e696d756d3042616c616e63654f663c543e4000407a10f35a00000000000000000000044901204d696e696d756d20616d6f756e74206f662066756e647320746861742073686f756c6420626520706c6163656420696e2061206465706f73697420666f72206d616b696e6720612070726f706f73616c2e2c5370656e64506572696f6438543a3a426c6f636b4e756d6265721080700000048820506572696f64206265747765656e2073756363657373697665207370656e64732e104275726e1c5065726d696c6c1020a107000411012050657263656e74616765206f662073706172652066756e64732028696620616e7929207468617420617265206275726e7420706572207370656e6420706572696f642e30546970436f756e74646f776e38543a3a426c6f636b4e756d62657210807000000445012054686520706572696f6420666f722077686963682061207469702072656d61696e73206f70656e20616674657220697320686173206163686965766564207468726573686f6c6420746970706572732e3454697046696e646572734665651c50657263656e7404140431012054686520616d6f756e74206f66207468652066696e616c2074697020776869636820676f657320746f20746865206f726967696e616c207265706f72746572206f6620746865207469702e505469705265706f72744465706f736974426173653042616c616e63654f663c543e4000407a10f35a0000000000000000000004d42054686520616d6f756e742068656c64206f6e206465706f73697420666f7220706c6163696e67206120746970207265706f72742e5c5469705265706f72744465706f736974506572427974653042616c616e63654f663c543e400010a5d4e800000000000000000000000409012054686520616d6f756e742068656c64206f6e206465706f7369742070657220627974652077697468696e2074686520746970207265706f727420726561736f6e2e204d6f64756c654964204d6f64756c6549642070792f7472737279041901205468652074726561737572792773206d6f64756c652069642c207573656420666f72206465726976696e672069747320736f7665726569676e206163636f756e742049442e2070496e73756666696369656e7450726f706f7365727342616c616e6365047c2050726f706f73657227732062616c616e636520697320746f6f206c6f772e50496e76616c696450726f706f73616c496e646578046c204e6f2070726f706f73616c206174207468617420696e6465782e30526561736f6e546f6f42696704882054686520726561736f6e20676976656e206973206a75737420746f6f206269672e30416c72656164794b6e6f776e048c20546865207469702077617320616c726561647920666f756e642f737461727465642e28556e6b6e6f776e54697004642054686520746970206861736820697320756e6b6e6f776e2e244e6f7446696e64657204210120546865206163636f756e7420617474656d7074696e6720746f20726574726163742074686520746970206973206e6f74207468652066696e646572206f6620746865207469702e245374696c6c4f70656e042d0120546865207469702063616e6e6f7420626520636c61696d65642f636c6f736564206265636175736520746865726520617265206e6f7420656e6f7567682074697070657273207965742e245072656d617475726504350120546865207469702063616e6e6f7420626520636c61696d65642f636c6f73656420626563617573652069742773207374696c6c20696e2074686520636f756e74646f776e20706572696f642e24436f6e7472616374730124436f6e747261637473143c43757272656e745363686564756c650100205363686564756c6525020000000020a107000000000020a107000000000020a107000000000020a107000000000020a107000000000020a107000000000020a1070000000000e0f7050400000000e024370500000000e0f705040000000020a107000000000020a107000000000080f0fa020000000000e1f5050000000004000000000001001000000000400000002000000004942043757272656e7420636f7374207363686564756c6520666f7220636f6e7472616374732e305072697374696e65436f64650001062c436f6465486173683c543e1c5665633c75383e0004000465012041206d617070696e672066726f6d20616e206f726967696e616c20636f6465206861736820746f20746865206f726967696e616c20636f64652c20756e746f756368656420627920696e737472756d656e746174696f6e2e2c436f646553746f726167650001062c436f6465486173683c543e587761736d3a3a5072656661625761736d4d6f64756c650004000465012041206d617070696e67206265747765656e20616e206f726967696e616c20636f6465206861736820616e6420696e737472756d656e746564207761736d20636f64652c20726561647920666f7220657865637574696f6e2e384163636f756e74436f756e74657201000c753634200000000000000000045420546865207375627472696520636f756e7465722e38436f6e7472616374496e666f4f6600010530543a3a4163636f756e7449643c436f6e7472616374496e666f3c543e0004000ca82054686520636f6465206173736f6369617465642077697468206120676976656e206163636f756e742e00d02054574f582d4e4f54453a20534146452073696e636520604163636f756e7449646020697320612073656375726520686173682e01143c7570646174655f7363686564756c6504207363686564756c65205363686564756c650cb4205570646174657320746865207363686564756c6520666f72206d65746572696e6720636f6e7472616374732e000d0120546865207363686564756c65206d7573742068617665206120677265617465722076657273696f6e207468616e207468652073746f726564207363686564756c652e207075745f636f64650410636f64651c5665633c75383e085d012053746f7265732074686520676976656e2062696e617279205761736d20636f646520696e746f2074686520636861696e27732073746f7261676520616e642072657475726e73206974732060636f646568617368602ed420596f752063616e20696e7374616e746961746520636f6e747261637473206f6e6c7920776974682073746f72656420636f64652e1063616c6c1010646573748c3c543a3a4c6f6f6b7570206173205374617469634c6f6f6b75703e3a3a536f757263651476616c756554436f6d706163743c42616c616e63654f663c543e3e246761735f6c696d697430436f6d706163743c4761733e10646174611c5665633c75383e1c0901204d616b657320612063616c6c20746f20616e206163636f756e742c206f7074696f6e616c6c79207472616e7366657272696e6720736f6d652062616c616e63652e002901202a20496620746865206163636f756e74206973206120736d6172742d636f6e7472616374206163636f756e742c20746865206173736f63696174656420636f64652077696c6c206265b020657865637574656420616e6420616e792076616c75652077696c6c206265207472616e736665727265642e1901202a20496620746865206163636f756e74206973206120726567756c6172206163636f756e742c20616e792076616c75652077696c6c206265207472616e736665727265642e4901202a204966206e6f206163636f756e742065786973747320616e64207468652063616c6c2076616c7565206973206e6f74206c657373207468616e20606578697374656e7469616c5f6465706f736974602c1501206120726567756c6172206163636f756e742077696c6c206265206372656174656420616e6420616e792076616c75652077696c6c206265207472616e736665727265642e2c696e7374616e74696174651024656e646f776d656e7454436f6d706163743c42616c616e63654f663c543e3e246761735f6c696d697430436f6d706163743c4761733e24636f64655f686173682c436f6465486173683c543e10646174611c5665633c75383e28bd0120496e7374616e7469617465732061206e657720636f6e74726163742066726f6d207468652060636f646568617368602067656e65726174656420627920607075745f636f6465602c206f7074696f6e616c6c79207472616e7366657272696e6720736f6d652062616c616e63652e009820496e7374616e74696174696f6e20697320657865637574656420617320666f6c6c6f77733a004101202d205468652064657374696e6174696f6e206164647265737320697320636f6d7075746564206261736564206f6e207468652073656e64657220616e642068617368206f662074686520636f64652e0501202d2054686520736d6172742d636f6e7472616374206163636f756e7420697320637265617465642061742074686520636f6d707574656420616464726573732e6d01202d20546865206063746f725f636f64656020697320657865637574656420696e2074686520636f6e74657874206f6620746865206e65776c792d63726561746564206163636f756e742e204275666665722072657475726e65645d0120202061667465722074686520657865637574696f6e206973207361766564206173207468652060636f646560206f6620746865206163636f756e742e205468617420636f64652077696c6c20626520696e766f6b6564a820202075706f6e20616e792063616c6c2072656365697665642062792074686973206163636f756e742e7c202d2054686520636f6e747261637420697320696e697469616c697a65642e3c636c61696d5f73757263686172676508106465737430543a3a4163636f756e744964286175785f73656e646572504f7074696f6e3c543a3a4163636f756e7449643e14710120416c6c6f777320626c6f636b2070726f64756365727320746f20636c61696d206120736d616c6c2072657761726420666f72206576696374696e67206120636f6e74726163742e204966206120626c6f636b2070726f64756365721501206661696c7320746f20646f20736f2c206120726567756c61722075736572732077696c6c20626520616c6c6f77656420746f20636c61696d20746865207265776172642e00390120496620636f6e7472616374206973206e6f742065766963746564206173206120726573756c74206f6620746869732063616c6c2c206e6f20616374696f6e73206172652074616b656e20616e64ac207468652073656e646572206973206e6f7420656c696769626c6520666f7220746865207265776172642e011c30496e7374616e74696174656408244163636f756e744964244163636f756e74496404dc20436f6e7472616374206465706c6f7965642062792061646472657373206174207468652073706563696669656420616464726573732e1c4576696374656408244163636f756e74496410626f6f6c18e420436f6e747261637420686173206265656e206576696374656420616e64206973206e6f7720696e20746f6d6273746f6e652073746174652e0024202320506172616d73000d01202d2060636f6e7472616374603a20604163636f756e744964603a20546865206163636f756e74204944206f6620746865206576696374656420636f6e74726163742e3501202d2060746f6d6273746f6e65603a2060626f6f6c603a205472756520696620746865206576696374656420636f6e7472616374206c65667420626568696e64206120746f6d6273746f6e652e20526573746f72656410244163636f756e744964244163636f756e74496410486173681c42616c616e636520c020526573746f726174696f6e20666f72206120636f6e747261637420686173206265656e207375636365737366756c2e0024202320506172616d7300f4202d2060646f6e6f72603a20604163636f756e744964603a204163636f756e74204944206f662074686520726573746f72696e6720636f6e7472616374ec202d206064657374603a20604163636f756e744964603a204163636f756e74204944206f662074686520726573746f72656420636f6e7472616374e8202d2060636f64655f68617368603a206048617368603a20436f64652068617368206f662074686520726573746f72656420636f6e74726163741901202d206072656e745f616c6c6f77616e63653a206042616c616e6365603a2052656e7420616c6c6f77616e6365206f662074686520726573746f72656420636f6e747261637428436f646553746f72656404104861736804b820436f646520776974682074686520737065636966696564206861736820686173206265656e2073746f7265642e3c5363686564756c6555706461746564040c75333204c020547269676765726564207768656e207468652063757272656e74207363686564756c6520697320757064617465642e284469737061746368656408244163636f756e74496410626f6f6c08390120412063616c6c2077617320646973706174636865642066726f6d2074686520676976656e206163636f756e742e2054686520626f6f6c207369676e616c7320776865746865722069742077617374207375636365737366756c20657865637574696f6e206f72206e6f742e44436f6e7472616374457865637574696f6e08244163636f756e7449641c5665633c75383e04090120416e206576656e74206465706f73697465642075706f6e20657865637574696f6e206f66206120636f6e74726163742066726f6d20746865206163636f756e742e204c5369676e6564436c61696d48616e646963617038543a3a426c6f636b4e756d626572100200000010e0204e756d626572206f6620626c6f636b2064656c617920616e2065787472696e73696320636c61696d20737572636861726765206861732e000d01205768656e20636c61696d207375726368617267652069732063616c6c656420627920616e2065787472696e736963207468652072656e7420697320636865636b65646820666f722063757272656e745f626c6f636b202d2064656c617940546f6d6273746f6e654465706f7369743042616c616e63654f663c543e4000a0acb903000000000000000000000004d420546865206d696e696d756d20616d6f756e7420726571756972656420746f2067656e6572617465206120746f6d6273746f6e652e4453746f7261676553697a654f66667365740c753332100800000018710120412073697a65206f666673657420666f7220616e20636f6e74726163742e2041206a7573742063726561746564206163636f756e74207769746820756e746f75636865642073746f726167652077696c6c20686176652074686174e0206d756368206f662073746f726167652066726f6d20746865207065727370656374697665206f66207468652073746174652072656e742e006101205468697320697320612073696d706c652077617920746f20656e73757265207468617420636f6e747261637473207769746820656d7074792073746f72616765206576656e7475616c6c79206765742064656c657465646501206279206d616b696e67207468656d207061792072656e742e2054686973206372656174657320616e20696e63656e7469766520746f2072656d6f7665207468656d206561726c7920696e206f7264657220746f2073617665182072656e742e2c52656e74427974654665653042616c616e63654f663c543e4000286bee000000000000000000000000043501205072696365206f6620612062797465206f662073746f7261676520706572206f6e6520626c6f636b20696e74657276616c2e2053686f756c642062652067726561746572207468616e20302e4452656e744465706f7369744f66667365743042616c616e63654f663c543e400010a5d4e800000000000000000000001c05012054686520616d6f756e74206f662066756e6473206120636f6e74726163742073686f756c64206465706f73697420696e206f7264657220746f206f6666736574582074686520636f7374206f66206f6e6520627974652e006901204c6574277320737570706f736520746865206465706f73697420697320312c303030204255202862616c616e636520756e697473292f6279746520616e64207468652072656e7420697320312042552f627974652f6461792c5901207468656e206120636f6e7472616374207769746820312c3030302c3030302042552074686174207573657320312c303030206279746573206f662073746f7261676520776f756c6420706179206e6f2072656e742e4d0120427574206966207468652062616c616e6365207265647563656420746f203530302c30303020425520616e64207468652073746f7261676520737461796564207468652073616d6520617420312c3030302c78207468656e20697420776f756c6420706179203530302042552f6461792e3c5375726368617267655265776172643042616c616e63654f663c543e40005cb2ec22000000000000000000000008e4205265776172642074686174206973207265636569766564206279207468652070617274792077686f736520746f75636820686173206c65646820746f2072656d6f76616c206f66206120636f6e74726163742e204d617844657074680c753332102000000008310120546865206d6178696d756d206e657374696e67206c6576656c206f6620612063616c6c2f696e7374616e746961746520737461636b2e204120726561736f6e61626c652064656661756c74382076616c7565206973203130302e304d617856616c756553697a650c753332100040000004390120546865206d6178696d756d2073697a65206f6620612073746f726167652076616c756520696e2062797465732e204120726561736f6e61626c652064656661756c74206973203136204b69422e1858496e76616c69645363686564756c6556657273696f6e0405012041206e6577207363686564756c65206d7573742068617665206120677265617465722076657273696f6e207468616e207468652063757272656e74206f6e652e54496e76616c6964537572636861726765436c61696d04550120416e206f726967696e206d757374206265207369676e6564206f7220696e686572656e7420616e6420617578696c696172792073656e646572206f6e6c792070726f7669646564206f6e20696e686572656e742e54496e76616c6964536f75726365436f6e747261637404dc2043616e6e6f7420726573746f72652066726f6d206e6f6e6578697374696e67206f7220746f6d6273746f6e6520636f6e74726163742e68496e76616c696444657374696e6174696f6e436f6e747261637404c42043616e6e6f7420726573746f726520746f206e6f6e6578697374696e67206f7220616c69766520636f6e74726163742e40496e76616c6964546f6d6273746f6e65046020546f6d6273746f6e657320646f6e2774206d617463682e54496e76616c6964436f6e74726163744f726967696e04bc20416e206f726967696e20547269654964207772697474656e20696e207468652063757272656e7420626c6f636b2e105375646f01105375646f040c4b6579010030543a3a4163636f756e74496480000000000000000000000000000000000000000000000000000000000000000004842054686520604163636f756e74496460206f6620746865207375646f206b65792e0110107375646f041063616c6c5c426f783c3c542061732054726169743e3a3a43616c6c3e2839012041757468656e7469636174657320746865207375646f206b657920616e64206469737061746368657320612066756e6374696f6e2063616c6c20776974682060526f6f7460206f726967696e2e00d020546865206469737061746368206f726967696e20666f7220746869732063616c6c206d757374206265205f5369676e65645f2e002c2023203c7765696768743e20202d204f2831292e64202d204c696d697465642073746f726167652072656164732e60202d204f6e6520444220777269746520286576656e74292ec8202d20576569676874206f662064657269766174697665206063616c6c6020657865637574696f6e202b2031302c3030302e302023203c2f7765696768743e547375646f5f756e636865636b65645f776569676874081063616c6c5c426f783c3c542061732054726169743e3a3a43616c6c3e1c5f776569676874185765696768742839012041757468656e7469636174657320746865207375646f206b657920616e64206469737061746368657320612066756e6374696f6e2063616c6c20776974682060526f6f7460206f726967696e2e310120546869732066756e6374696f6e20646f6573206e6f7420636865636b2074686520776569676874206f66207468652063616c6c2c20616e6420696e737465616420616c6c6f777320746865b4205375646f207573657220746f20737065636966792074686520776569676874206f66207468652063616c6c2e00d020546865206469737061746368206f726967696e20666f7220746869732063616c6c206d757374206265205f5369676e65645f2e002c2023203c7765696768743e20202d204f2831292ed0202d2054686520776569676874206f6620746869732063616c6c20697320646566696e6564206279207468652063616c6c65722e302023203c2f7765696768743e1c7365745f6b6579040c6e65778c3c543a3a4c6f6f6b7570206173205374617469634c6f6f6b75703e3a3a536f757263652475012041757468656e74696361746573207468652063757272656e74207375646f206b657920616e6420736574732074686520676976656e204163636f756e7449642028606e6577602920617320746865206e6577207375646f206b65792e00d020546865206469737061746368206f726967696e20666f7220746869732063616c6c206d757374206265205f5369676e65645f2e002c2023203c7765696768743e20202d204f2831292e64202d204c696d697465642073746f726167652072656164732e44202d204f6e65204442206368616e67652e302023203c2f7765696768743e1c7375646f5f6173080c77686f8c3c543a3a4c6f6f6b7570206173205374617469634c6f6f6b75703e3a3a536f757263651063616c6c5c426f783c3c542061732054726169743e3a3a43616c6c3e2c51012041757468656e7469636174657320746865207375646f206b657920616e64206469737061746368657320612066756e6374696f6e2063616c6c207769746820605369676e656460206f726967696e2066726f6d44206120676976656e206163636f756e742e00d020546865206469737061746368206f726967696e20666f7220746869732063616c6c206d757374206265205f5369676e65645f2e002c2023203c7765696768743e20202d204f2831292e64202d204c696d697465642073746f726167652072656164732e60202d204f6e6520444220777269746520286576656e74292ec8202d20576569676874206f662064657269766174697665206063616c6c6020657865637574696f6e202b2031302c3030302e302023203c2f7765696768743e010c14537564696404384469737061746368526573756c7404602041207375646f206a75737420746f6f6b20706c6163652e284b65794368616e67656404244163636f756e74496404f020546865207375646f6572206a757374207377697463686564206964656e746974793b20746865206f6c64206b657920697320737570706c6965642e285375646f4173446f6e650410626f6f6c04602041207375646f206a75737420746f6f6b20706c6163652e00042c526571756972655375646f04802053656e646572206d75737420626520746865205375646f206163636f756e7420496d4f6e6c696e650120496d4f6e6c696e6510384865617274626561744166746572010038543a3a426c6f636b4e756d62657210000000001831012054686520626c6f636b206e756d6265722061667465722077686963682069742773206f6b20746f2073656e64206865617274626561747320696e2063757272656e742073657373696f6e2e0011012041742074686520626567696e6e696e67206f6620656163682073657373696f6e20776520736574207468697320746f20612076616c756520746861742073686f756c64d02066616c6c20726f7567686c7920696e20746865206d6964646c65206f66207468652073657373696f6e206475726174696f6e2e010120546865206964656120697320746f206669727374207761697420666f72207468652076616c696461746f727320746f2070726f64756365206120626c6f636b390120696e207468652063757272656e742073657373696f6e2c20736f20746861742074686520686561727462656174206c61746572206f6e2077696c6c206e6f74206265206e65636573736172792e104b65797301004c5665633c543a3a417574686f7269747949643e040004d0205468652063757272656e7420736574206f66206b6579732074686174206d61792069737375652061206865617274626561742e485265636569766564486561727462656174730002053053657373696f6e496e6465782441757468496e6465781c5665633c75383e05040008f020466f7220656163682073657373696f6e20696e6465782c207765206b6565702061206d617070696e67206f66206041757468496e6465786020746f8020606f6666636861696e3a3a4f70617175654e6574776f726b5374617465602e38417574686f726564426c6f636b730102053053657373696f6e496e64657838543a3a56616c696461746f7249640c75333205100000000008150120466f7220656163682073657373696f6e20696e6465782c207765206b6565702061206d617070696e67206f662060543a3a56616c696461746f7249646020746f20746865c8206e756d626572206f6620626c6f636b7320617574686f7265642062792074686520676976656e20617574686f726974792e0104246865617274626561740824686561727462656174644865617274626561743c543a3a426c6f636b4e756d6265723e285f7369676e6174757265bc3c543a3a417574686f7269747949642061732052756e74696d654170705075626c69633e3a3a5369676e6174757265282c2023203c7765696768743e2101202d20436f6d706c65786974793a20604f284b202b20452960207768657265204b206973206c656e677468206f6620604b6579736020616e642045206973206c656e677468206f66b4202020604865617274626561742e6e6574776f726b5f73746174652e65787465726e616c5f6164647265737360008c2020202d20604f284b29603a206465636f64696e67206f66206c656e67746820604b60b02020202d20604f284529603a206465636f64696e672f656e636f64696e67206f66206c656e677468206045603d01202d20446252656164733a2070616c6c65745f73657373696f6e206056616c696461746f7273602c2070616c6c65745f73657373696f6e206043757272656e74496e646578602c20604b657973602c5c202020605265636569766564486561727462656174736084202d2044625772697465733a206052656365697665644865617274626561747360302023203c2f7765696768743e010c444865617274626561745265636569766564042c417574686f72697479496404c02041206e657720686561727462656174207761732072656365697665642066726f6d2060417574686f726974794964601c416c6c476f6f640004d42041742074686520656e64206f66207468652073657373696f6e2c206e6f206f6666656e63652077617320636f6d6d69747465642e2c536f6d654f66666c696e6504605665633c4964656e74696669636174696f6e5475706c653e042d012041742074686520656e64206f66207468652073657373696f6e2c206174206c65617374206f6e652076616c696461746f722077617320666f756e6420746f206265206f66666c696e652e000828496e76616c69644b65790464204e6f6e206578697374656e74207075626c6963206b65792e4c4475706c6963617465644865617274626561740458204475706c696361746564206865617274626561742e48417574686f72697479446973636f76657279000100000000204f6666656e63657301204f6666656e636573101c5265706f727473000105345265706f727449644f663c543ed04f6666656e636544657461696c733c543a3a4163636f756e7449642c20543a3a4964656e74696669636174696f6e5475706c653e00040004490120546865207072696d61727920737472756374757265207468617420686f6c647320616c6c206f6666656e6365207265636f726473206b65796564206279207265706f7274206964656e746966696572732e4044656665727265644f6666656e6365730100645665633c44656665727265644f6666656e63654f663c543e3e0400086501204465666572726564207265706f72747320746861742068617665206265656e2072656a656374656420627920746865206f6666656e63652068616e646c657220616e64206e65656420746f206265207375626d6974746564442061742061206c617465722074696d652e58436f6e63757272656e745265706f727473496e646578010205104b696e64384f706171756554696d65536c6f74485665633c5265706f727449644f663c543e3e050400042901204120766563746f72206f66207265706f727473206f66207468652073616d65206b696e6420746861742068617070656e6564206174207468652073616d652074696d6520736c6f742e485265706f72747342794b696e64496e646578010105104b696e641c5665633c75383e00040018110120456e756d65726174657320616c6c207265706f727473206f662061206b696e6420616c6f6e672077697468207468652074696d6520746865792068617070656e65642e00bc20416c6c207265706f7274732061726520736f72746564206279207468652074696d65206f66206f6666656e63652e004901204e6f74652074686174207468652061637475616c2074797065206f662074686973206d617070696e6720697320605665633c75383e602c207468697320697320626563617573652076616c756573206f66690120646966666572656e7420747970657320617265206e6f7420737570706f7274656420617420746865206d6f6d656e7420736f2077652061726520646f696e6720746865206d616e75616c2073657269616c697a6174696f6e2e010001041c4f6666656e63650c104b696e64384f706171756554696d65536c6f7410626f6f6c0c550120546865726520697320616e206f6666656e6365207265706f72746564206f662074686520676976656e20606b696e64602068617070656e656420617420746865206073657373696f6e5f696e6465786020616e644d0120286b696e642d7370656369666963292074696d6520736c6f742e2054686973206576656e74206973206e6f74206465706f736974656420666f72206475706c696361746520736c61736865732e206c6173741d0120656c656d656e7420696e64696361746573206f6620746865206f6666656e636520776173206170706c69656420287472756529206f7220717565756564202866616c7365292e000028486973746f726963616c00000000006052616e646f6d6e657373436f6c6c656374697665466c6970016052616e646f6d6e657373436f6c6c656374697665466c6970043852616e646f6d4d6174657269616c0100305665633c543a3a486173683e04000c610120536572696573206f6620626c6f636b20686561646572732066726f6d20746865206c61737420383120626c6f636b73207468617420616374732061732072616e646f6d2073656564206d6174657269616c2e2054686973610120697320617272616e67656420617320612072696e672062756666657220776974682060626c6f636b5f6e756d626572202520383160206265696e672074686520696e64657820696e746f20746865206056656360206f664420746865206f6c6465737420686173682e0100000000204964656e7469747901204964656e7469747910284964656e746974794f6600010530543a3a4163636f756e74496468526567697374726174696f6e3c42616c616e63654f663c543e3e0004000c210120496e666f726d6174696f6e20746861742069732070657274696e656e7420746f206964656e746966792074686520656e7469747920626568696e6420616e206163636f756e742e00c02054574f582d4e4f54453a204f4b20e2809520604163636f756e7449646020697320612073656375726520686173682e1c53757065724f6600010230543a3a4163636f756e7449645028543a3a4163636f756e7449642c204461746129000400086101205468652073757065722d6964656e74697479206f6620616e20616c7465726e6174697665202273756222206964656e7469747920746f676574686572207769746820697473206e616d652c2077697468696e2074686174510120636f6e746578742e20496620746865206163636f756e74206973206e6f7420736f6d65206f74686572206163636f756e742773207375622d6964656e746974792c207468656e206a75737420604e6f6e65602e18537562734f6601010530543a3a4163636f756e744964842842616c616e63654f663c543e2c205665633c543a3a4163636f756e7449643e290044000000000000000000000000000000000014b820416c7465726e6174697665202273756222206964656e746974696573206f662074686973206163636f756e742e001d0120546865206669727374206974656d20697320746865206465706f7369742c20746865207365636f6e64206973206120766563746f72206f6620746865206163636f756e74732e00c02054574f582d4e4f54453a204f4b20e2809520604163636f756e7449646020697320612073656375726520686173682e28526567697374726172730100d85665633c4f7074696f6e3c526567697374726172496e666f3c42616c616e63654f663c543e2c20543a3a4163636f756e7449643e3e3e0400104d012054686520736574206f6620726567697374726172732e204e6f7420657870656374656420746f206765742076657279206269672061732063616e206f6e6c79206265206164646564207468726f7567682061a8207370656369616c206f726967696e20286c696b656c79206120636f756e63696c206d6f74696f6e292e0029012054686520696e64657820696e746f20746869732063616e206265206361737420746f2060526567697374726172496e6465786020746f2067657420612076616c69642076616c75652e012c346164645f726567697374726172041c6163636f756e7430543a3a4163636f756e744964347c2041646420612072656769737472617220746f207468652073797374656d2e00010120546865206469737061746368206f726967696e20666f7220746869732063616c6c206d7573742062652060543a3a5265676973747261724f726967696e602e00ac202d20606163636f756e74603a20746865206163636f756e74206f6620746865207265676973747261722e009820456d6974732060526567697374726172416464656460206966207375636365737366756c2e002c2023203c7765696768743e2901202d20604f2852296020776865726520605260207265676973747261722d636f756e742028676f7665726e616e63652d626f756e64656420616e6420636f64652d626f756e646564292e9c202d204f6e652073746f72616765206d75746174696f6e2028636f64656320604f28522960292e34202d204f6e65206576656e742e302023203c2f7765696768743e307365745f6964656e746974790410696e666f304964656e74697479496e666f4c2d012053657420616e206163636f756e742773206964656e7469747920696e666f726d6174696f6e20616e6420726573657276652074686520617070726f707269617465206465706f7369742e00590120496620746865206163636f756e7420616c726561647920686173206964656e7469747920696e666f726d6174696f6e2c20746865206465706f7369742069732074616b656e2061732070617274207061796d656e745420666f7220746865206e6577206465706f7369742e00d020546865206469737061746368206f726967696e20666f7220746869732063616c6c206d757374206265205f5369676e65645f2e0090202d2060696e666f603a20546865206964656e7469747920696e666f726d6174696f6e2e008c20456d69747320604964656e7469747953657460206966207375636365737366756c2e002c2023203c7765696768743e48202d20604f2858202b205827202b2052296021012020202d20776865726520605860206164646974696f6e616c2d6669656c642d636f756e7420286465706f7369742d626f756e64656420616e6420636f64652d626f756e64656429e42020202d20776865726520605260206a756467656d656e74732d636f756e7420287265676973747261722d636f756e742d626f756e6465642984202d204f6e652062616c616e63652072657365727665206f7065726174696f6e2e2501202d204f6e652073746f72616765206d75746174696f6e2028636f6465632d7265616420604f285827202b205229602c20636f6465632d777269746520604f2858202b20522960292e34202d204f6e65206576656e742e302023203c2f7765696768743e207365745f73756273041073756273645665633c28543a3a4163636f756e7449642c2044617461293e54902053657420746865207375622d6163636f756e7473206f66207468652073656e6465722e005901205061796d656e743a20416e79206167677265676174652062616c616e63652072657365727665642062792070726576696f757320607365745f73756273602063616c6c732077696c6c2062652072657475726e6564310120616e6420616e20616d6f756e7420605375624163636f756e744465706f736974602077696c6c20626520726573657276656420666f722065616368206974656d20696e206073756273602e00650120546865206469737061746368206f726967696e20666f7220746869732063616c6c206d757374206265205f5369676e65645f20616e64207468652073656e646572206d75737420686176652061207265676973746572656428206964656e746974792e00b4202d206073756273603a20546865206964656e74697479277320286e657729207375622d6163636f756e74732e002c2023203c7765696768743e34202d20604f2850202b20532960e82020202d20776865726520605060206f6c642d737562732d636f756e742028686172642d20616e64206465706f7369742d626f756e646564292ed82020202d2077686572652060536020737562732d636f756e742028686172642d20616e64206465706f7369742d626f756e646564292e88202d204174206d6f7374206f6e652062616c616e6365206f7065726174696f6e732e18202d2044423ae02020202d206050202b2053602073746f72616765206d75746174696f6e732028636f64656320636f6d706c657869747920604f2831296029c02020202d204f6e652073746f7261676520726561642028636f64656320636f6d706c657869747920604f28502960292ec42020202d204f6e652073746f726167652077726974652028636f64656320636f6d706c657869747920604f28532960292ed42020202d204f6e652073746f726167652d6578697374732028604964656e746974794f663a3a636f6e7461696e735f6b657960292e302023203c2f7765696768743e38636c6561725f6964656e7469747900483d0120436c65617220616e206163636f756e742773206964656e7469747920696e666f20616e6420616c6c207375622d6163636f756e747320616e642072657475726e20616c6c206465706f736974732e00f0205061796d656e743a20416c6c2072657365727665642062616c616e636573206f6e20746865206163636f756e74206172652072657475726e65642e00650120546865206469737061746368206f726967696e20666f7220746869732063616c6c206d757374206265205f5369676e65645f20616e64207468652073656e646572206d75737420686176652061207265676973746572656428206964656e746974792e009c20456d69747320604964656e74697479436c656172656460206966207375636365737366756c2e002c2023203c7765696768743e44202d20604f2852202b2053202b20582960d02020202d20776865726520605260207265676973747261722d636f756e742028676f7665726e616e63652d626f756e646564292ed82020202d2077686572652060536020737562732d636f756e742028686172642d20616e64206465706f7369742d626f756e646564292e25012020202d20776865726520605860206164646974696f6e616c2d6669656c642d636f756e7420286465706f7369742d626f756e64656420616e6420636f64652d626f756e646564292e8c202d204f6e652062616c616e63652d756e72657365727665206f7065726174696f6e2ecc202d206032602073746f7261676520726561647320616e64206053202b2032602073746f726167652064656c6574696f6e732e34202d204f6e65206576656e742e302023203c2f7765696768743e44726571756573745f6a756467656d656e7408247265675f696e6465785c436f6d706163743c526567697374726172496e6465783e1c6d61785f66656554436f6d706163743c42616c616e63654f663c543e3e5c9820526571756573742061206a756467656d656e742066726f6d2061207265676973747261722e005901205061796d656e743a204174206d6f737420606d61785f666565602077696c6c20626520726573657276656420666f72207061796d656e7420746f2074686520726567697374726172206966206a756467656d656e741c20676976656e2e00390120546865206469737061746368206f726967696e20666f7220746869732063616c6c206d757374206265205f5369676e65645f20616e64207468652073656e646572206d75737420686176652061542072656769737465726564206964656e746974792e002101202d20607265675f696e646578603a2054686520696e646578206f6620746865207265676973747261722077686f7365206a756467656d656e74206973207265717565737465642e5901202d20606d61785f666565603a20546865206d6178696d756d206665652074686174206d617920626520706169642e20546869732073686f756c64206a757374206265206175746f2d706f70756c617465642061733a0034206060606e6f636f6d70696c65bc2053656c663a3a7265676973747261727328292e676574287265675f696e646578292e756e7772617028292e666565102060606000a820456d69747320604a756467656d656e7452657175657374656460206966207375636365737366756c2e002c2023203c7765696768743e38202d20604f2852202b205829602e84202d204f6e652062616c616e63652d72657365727665206f7065726174696f6e2ebc202d2053746f726167653a2031207265616420604f285229602c2031206d757461746520604f2858202b205229602e34202d204f6e65206576656e742e302023203c2f7765696768743e3863616e63656c5f7265717565737404247265675f696e64657838526567697374726172496e646578446c2043616e63656c20612070726576696f757320726571756573742e00fc205061796d656e743a20412070726576696f75736c79207265736572766564206465706f7369742069732072657475726e6564206f6e20737563636573732e00390120546865206469737061746368206f726967696e20666f7220746869732063616c6c206d757374206265205f5369676e65645f20616e64207468652073656e646572206d75737420686176652061542072656769737465726564206964656e746974792e004901202d20607265675f696e646578603a2054686520696e646578206f6620746865207265676973747261722077686f7365206a756467656d656e74206973206e6f206c6f6e676572207265717565737465642e00b020456d69747320604a756467656d656e74556e72657175657374656460206966207375636365737366756c2e002c2023203c7765696768743e38202d20604f2852202b205829602e84202d204f6e652062616c616e63652d72657365727665206f7065726174696f6e2e8c202d204f6e652073746f72616765206d75746174696f6e20604f2852202b205829602e30202d204f6e65206576656e74302023203c2f7765696768743e1c7365745f6665650814696e6465785c436f6d706163743c526567697374726172496e6465783e0c66656554436f6d706163743c42616c616e63654f663c543e3e341d0120536574207468652066656520726571756972656420666f722061206a756467656d656e7420746f206265207265717565737465642066726f6d2061207265676973747261722e00590120546865206469737061746368206f726967696e20666f7220746869732063616c6c206d757374206265205f5369676e65645f20616e64207468652073656e646572206d75737420626520746865206163636f756e74a4206f6620746865207265676973747261722077686f736520696e6465782069732060696e646578602e00f8202d2060696e646578603a2074686520696e646578206f6620746865207265676973747261722077686f73652066656520697320746f206265207365742e58202d2060666565603a20746865206e6577206665652e002c2023203c7765696768743e28202d20604f285229602e7c202d204f6e652073746f72616765206d75746174696f6e20604f285229602ee8202d2042656e63686d61726b3a20372e333135202b2052202a20302e33323920c2b57320286d696e207371756172657320616e616c7973697329302023203c2f7765696768743e387365745f6163636f756e745f69640814696e6465785c436f6d706163743c526567697374726172496e6465783e0c6e657730543a3a4163636f756e74496434c0204368616e676520746865206163636f756e74206173736f63696174656420776974682061207265676973747261722e00590120546865206469737061746368206f726967696e20666f7220746869732063616c6c206d757374206265205f5369676e65645f20616e64207468652073656e646572206d75737420626520746865206163636f756e74a4206f6620746865207265676973747261722077686f736520696e6465782069732060696e646578602e00f8202d2060696e646578603a2074686520696e646578206f6620746865207265676973747261722077686f73652066656520697320746f206265207365742e74202d20606e6577603a20746865206e6577206163636f756e742049442e002c2023203c7765696768743e28202d20604f285229602e7c202d204f6e652073746f72616765206d75746174696f6e20604f285229602ee4202d2042656e63686d61726b3a20382e383233202b2052202a20302e333220c2b57320286d696e207371756172657320616e616c7973697329302023203c2f7765696768743e287365745f6669656c64730814696e6465785c436f6d706163743c526567697374726172496e6465783e186669656c6473384964656e746974794669656c647334ac2053657420746865206669656c6420696e666f726d6174696f6e20666f722061207265676973747261722e00590120546865206469737061746368206f726967696e20666f7220746869732063616c6c206d757374206265205f5369676e65645f20616e64207468652073656e646572206d75737420626520746865206163636f756e74a4206f6620746865207265676973747261722077686f736520696e6465782069732060696e646578602e00f8202d2060696e646578603a2074686520696e646578206f6620746865207265676973747261722077686f73652066656520697320746f206265207365742e1101202d20606669656c6473603a20746865206669656c64732074686174207468652072656769737472617220636f6e6365726e73207468656d73656c76657320776974682e002c2023203c7765696768743e28202d20604f285229602e7c202d204f6e652073746f72616765206d75746174696f6e20604f285229602ee8202d2042656e63686d61726b3a20372e343634202b2052202a20302e33323520c2b57320286d696e207371756172657320616e616c7973697329302023203c2f7765696768743e4470726f766964655f6a756467656d656e740c247265675f696e6465785c436f6d706163743c526567697374726172496e6465783e187461726765748c3c543a3a4c6f6f6b7570206173205374617469634c6f6f6b75703e3a3a536f75726365246a756467656d656e745c4a756467656d656e743c42616c616e63654f663c543e3e4cbc2050726f766964652061206a756467656d656e7420666f7220616e206163636f756e742773206964656e746974792e00590120546865206469737061746368206f726967696e20666f7220746869732063616c6c206d757374206265205f5369676e65645f20616e64207468652073656e646572206d75737420626520746865206163636f756e74b4206f6620746865207265676973747261722077686f736520696e64657820697320607265675f696e646578602e002501202d20607265675f696e646578603a2074686520696e646578206f6620746865207265676973747261722077686f7365206a756467656d656e74206973206265696e67206d6164652e5901202d2060746172676574603a20746865206163636f756e742077686f7365206964656e7469747920746865206a756467656d656e742069732075706f6e2e2054686973206d75737420626520616e206163636f756e74782020207769746820612072656769737465726564206964656e746974792e4d01202d20606a756467656d656e74603a20746865206a756467656d656e74206f662074686520726567697374726172206f6620696e64657820607265675f696e646578602061626f75742060746172676574602e009820456d69747320604a756467656d656e74476976656e60206966207375636365737366756c2e002c2023203c7765696768743e38202d20604f2852202b205829602e88202d204f6e652062616c616e63652d7472616e73666572206f7065726174696f6e2e98202d20557020746f206f6e65206163636f756e742d6c6f6f6b7570206f7065726174696f6e2ebc202d2053746f726167653a2031207265616420604f285229602c2031206d757461746520604f2852202b205829602e34202d204f6e65206576656e742e302023203c2f7765696768743e346b696c6c5f6964656e7469747904187461726765748c3c543a3a4c6f6f6b7570206173205374617469634c6f6f6b75703e3a3a536f757263654c45012052656d6f766520616e206163636f756e742773206964656e7469747920616e64207375622d6163636f756e7420696e666f726d6174696f6e20616e6420736c61736820746865206465706f736974732e006501205061796d656e743a2052657365727665642062616c616e6365732066726f6d20607365745f737562736020616e6420607365745f6964656e74697479602061726520736c617368656420616e642068616e646c656420627949012060536c617368602e20566572696669636174696f6e2072657175657374206465706f7369747320617265206e6f742072657475726e65643b20746865792073686f756c642062652063616e63656c6c656484206d616e75616c6c79207573696e67206063616e63656c5f72657175657374602e00fc20546865206469737061746368206f726967696e20666f7220746869732063616c6c206d757374206d617463682060543a3a466f7263654f726967696e602e005901202d2060746172676574603a20746865206163636f756e742077686f7365206964656e7469747920746865206a756467656d656e742069732075706f6e2e2054686973206d75737420626520616e206163636f756e74782020207769746820612072656769737465726564206964656e746974792e009820456d69747320604964656e746974794b696c6c656460206966207375636365737366756c2e002c2023203c7765696768743e48202d20604f2852202b2053202b205829602e84202d204f6e652062616c616e63652d72657365727665206f7065726174696f6e2e74202d206053202b2032602073746f72616765206d75746174696f6e732e34202d204f6e65206576656e742e302023203c2f7765696768743e011c2c4964656e7469747953657404244163636f756e74496404f02041206e616d652077617320736574206f72207265736574202877686963682077696c6c2072656d6f766520616c6c206a756467656d656e7473292e3c4964656e74697479436c656172656408244163636f756e7449641c42616c616e636504d02041206e616d652077617320636c65617265642c20616e642074686520676976656e2062616c616e63652072657475726e65642e384964656e746974794b696c6c656408244163636f756e7449641c42616c616e636504c82041206e616d65207761732072656d6f76656420616e642074686520676976656e2062616c616e636520736c61736865642e484a756467656d656e7452657175657374656408244163636f756e74496438526567697374726172496e64657804a02041206a756467656d656e74207761732061736b65642066726f6d2061207265676973747261722e504a756467656d656e74556e72657175657374656408244163636f756e74496438526567697374726172496e646578048c2041206a756467656d656e74207265717565737420776173207265747261637465642e384a756467656d656e74476976656e08244163636f756e74496438526567697374726172496e64657804982041206a756467656d656e742077617320676976656e2062792061207265676973747261722e3852656769737472617241646465640438526567697374726172496e646578045c204120726567697374726172207761732061646465642e183042617369634465706f7369743042616c616e63654f663c543e400080c6a47e8d0300000000000000000004d82054686520616d6f756e742068656c64206f6e206465706f73697420666f7220612072656769737465726564206964656e746974792e304669656c644465706f7369743042616c616e63654f663c543e4000a031a95fe300000000000000000000042d012054686520616d6f756e742068656c64206f6e206465706f73697420706572206164646974696f6e616c206669656c6420666f7220612072656769737465726564206964656e746974792e445375624163636f756e744465706f7369743042616c616e63654f663c543e400080f420e6b5000000000000000000000c65012054686520616d6f756e742068656c64206f6e206465706f73697420666f7220612072656769737465726564207375626163636f756e742e20546869732073686f756c64206163636f756e7420666f7220746865206661637471012074686174206f6e652073746f72616765206974656d27732076616c75652077696c6c20696e637265617365206279207468652073697a65206f6620616e206163636f756e742049442c20616e642074686572652077696c6c206265290120616e6f746865722074726965206974656d2077686f73652076616c7565206973207468652073697a65206f6620616e206163636f756e7420494420706c75732033322062797465732e384d61785375624163636f756e74730c7533321064000000040d0120546865206d6178696d756d206e756d626572206f66207375622d6163636f756e747320616c6c6f77656420706572206964656e746966696564206163636f756e742e4c4d61784164646974696f6e616c4669656c64730c7533321064000000086501204d6178696d756d206e756d626572206f66206164646974696f6e616c206669656c64732074686174206d61792062652073746f72656420696e20616e2049442e204e656564656420746f20626f756e642074686520492f4fe020726571756972656420746f2061636365737320616e206964656e746974792c206275742063616e2062652070726574747920686967682e344d6178526567697374726172730c7533321014000000085101204d61786d696d756d206e756d626572206f66207265676973747261727320616c6c6f77656420696e207468652073797374656d2e204e656564656420746f20626f756e642074686520636f6d706c65786974797c206f662c20652e672e2c207570646174696e67206a756467656d656e74732e3448546f6f4d616e795375624163636f756e7473046020546f6f206d616e7920737562732d6163636f756e74732e204e6f74466f756e640454204163636f756e742069736e277420666f756e642e204e6f744e616d65640454204163636f756e742069736e2774206e616d65642e28456d707479496e646578043420456d70747920696e6465782e284665654368616e676564044020466565206973206368616e6765642e284e6f4964656e74697479044c204e6f206964656e7469747920666f756e642e3c537469636b794a756467656d656e74044820537469636b79206a756467656d656e742e384a756467656d656e74476976656e0444204a756467656d656e7420676976656e2e40496e76616c69644a756467656d656e74044c20496e76616c6964206a756467656d656e742e30496e76616c6964496e64657804582054686520696e64657820697320696e76616c69642e34496e76616c6964546172676574045c205468652074617267657420697320696e76616c69642e34546f6f4d616e794669656c6473047020546f6f206d616e79206164646974696f6e616c206669656c64732e44546f6f4d616e795265676973747261727304ec204d6178696d756d20616d6f756e74206f66207265676973747261727320726561636865642e2043616e6e6f742061646420616e79206d6f72652e1c536f6369657479011c536f6369657479401c466f756e646572000030543a3a4163636f756e7449640400044820546865206669727374206d656d6265722e1452756c657300001c543a3a48617368040008510120412068617368206f66207468652072756c6573206f66207468697320736f636965747920636f6e6365726e696e67206d656d626572736869702e2043616e206f6e6c7920626520736574206f6e636520616e6454206f6e6c792062792074686520666f756e6465722e2843616e6469646174657301009c5665633c4269643c543a3a4163636f756e7449642c2042616c616e63654f663c542c20493e3e3e0400043901205468652063757272656e7420736574206f662063616e646964617465733b206269646465727320746861742061726520617474656d7074696e6720746f206265636f6d65206d656d626572732e4c53757370656e64656443616e6469646174657300010530543a3a4163636f756e744964e42842616c616e63654f663c542c20493e2c204269644b696e643c543a3a4163636f756e7449642c2042616c616e63654f663c542c20493e3e2900040004842054686520736574206f662073757370656e6465642063616e646964617465732e0c506f7401003c42616c616e63654f663c542c20493e400000000000000000000000000000000004410120416d6f756e74206f66206f7572206163636f756e742062616c616e63652074686174206973207370656369666963616c6c7920666f7220746865206e65787420726f756e642773206269642873292e1048656164000030543a3a4163636f756e744964040004e820546865206d6f7374207072696d6172792066726f6d20746865206d6f737420726563656e746c7920617070726f766564206d656d626572732e1c4d656d626572730100445665633c543a3a4163636f756e7449643e04000494205468652063757272656e7420736574206f66206d656d626572732c206f7264657265642e4053757370656e6465644d656d6265727301010530543a3a4163636f756e74496410626f6f6c00040004782054686520736574206f662073757370656e646564206d656d626572732e104269647301009c5665633c4269643c543a3a4163636f756e7449642c2042616c616e63654f663c542c20493e3e3e040004e8205468652063757272656e7420626964732c2073746f726564206f726465726564206279207468652076616c7565206f6620746865206269642e20566f756368696e6700010530543a3a4163636f756e74496438566f756368696e6753746174757300040004e4204d656d626572732063757272656e746c7920766f756368696e67206f722062616e6e65642066726f6d20766f756368696e6720616761696e1c5061796f75747301010530543a3a4163636f756e744964985665633c28543a3a426c6f636b4e756d6265722c2042616c616e63654f663c542c20493e293e000400044d012050656e64696e67207061796f7574733b206f72646572656420627920626c6f636b206e756d6265722c20776974682074686520616d6f756e7420746861742073686f756c642062652070616964206f75742e1c537472696b657301010530543a3a4163636f756e7449642c537472696b65436f756e7400100000000004dc20546865206f6e676f696e67206e756d626572206f66206c6f73696e6720766f746573206361737420627920746865206d656d6265722e14566f74657300020530543a3a4163636f756e74496430543a3a4163636f756e74496410566f746505040004d020446f75626c65206d61702066726f6d2043616e646964617465202d3e20566f746572202d3e20284d617962652920566f74652e20446566656e646572000030543a3a4163636f756e744964040004c42054686520646566656e64696e67206d656d6265722063757272656e746c79206265696e67206368616c6c656e6765642e34446566656e646572566f74657300010530543a3a4163636f756e74496410566f7465000400046020566f74657320666f722074686520646566656e6465722e284d61784d656d6265727301000c753332100000000004dc20546865206d6178206e756d626572206f66206d656d6265727320666f722074686520736f6369657479206174206f6e652074696d652e01300c626964041476616c75653c42616c616e63654f663c542c20493e84e020412075736572206f757473696465206f662074686520736f63696574792063616e206d616b6520612062696420666f7220656e7472792e003901205061796d656e743a206043616e6469646174654465706f736974602077696c6c20626520726573657276656420666f72206d616b696e672061206269642e2049742069732072657475726e6564f0207768656e2074686520626964206265636f6d65732061206d656d6265722c206f7220696620746865206269642063616c6c732060756e626964602e00d020546865206469737061746368206f726967696e20666f7220746869732063616c6c206d757374206265205f5369676e65645f2e003020506172616d65746572733a5901202d206076616c7565603a2041206f6e652074696d65207061796d656e74207468652062696420776f756c64206c696b6520746f2072656365697665207768656e206a6f696e696e672074686520736f63696574792e002c2023203c7765696768743e5501204b65793a204220286c656e206f662062696473292c204320286c656e206f662063616e64696461746573292c204d20286c656e206f66206d656d62657273292c2058202862616c616e636520726573657276652944202d2053746f726167652052656164733aec20092d204f6e652073746f72616765207265616420746f20636865636b20666f722073757370656e6465642063616e6469646174652e204f283129e020092d204f6e652073746f72616765207265616420746f20636865636b20666f722073757370656e646564206d656d6265722e204f283129dc20092d204f6e652073746f72616765207265616420746f20726574726965766520616c6c2063757272656e7420626964732e204f284229f420092d204f6e652073746f72616765207265616420746f20726574726965766520616c6c2063757272656e742063616e646964617465732e204f284329c820092d204f6e652073746f72616765207265616420746f20726574726965766520616c6c206d656d626572732e204f284d2948202d2053746f72616765205772697465733a810120092d204f6e652073746f72616765206d757461746520746f206164642061206e65772062696420746f2074686520766563746f72204f2842292028544f444f3a20706f737369626c65206f7074696d697a6174696f6e20772f207265616429010120092d20557020746f206f6e652073746f726167652072656d6f76616c206966206269642e6c656e2829203e204d41585f4249445f434f554e542e204f2831295c202d204e6f7461626c6520436f6d7075746174696f6e3a2d0120092d204f2842202b2043202b206c6f67204d292073656172636820746f20636865636b2075736572206973206e6f7420616c726561647920612070617274206f6620736f63696574792ec420092d204f286c6f672042292073656172636820746f20696e7365727420746865206e65772062696420736f727465642e78202d2045787465726e616c204d6f64756c65204f7065726174696f6e733a9c20092d204f6e652062616c616e63652072657365727665206f7065726174696f6e2e204f285829210120092d20557020746f206f6e652062616c616e636520756e72657365727665206f7065726174696f6e20696620626964732e6c656e2829203e204d41585f4249445f434f554e542e28202d204576656e74733a6820092d204f6e65206576656e7420666f72206e6577206269642efc20092d20557020746f206f6e65206576656e7420666f72204175746f556e626964206966206269642e6c656e2829203e204d41585f4249445f434f554e542e00c420546f74616c20436f6d706c65786974793a204f284d202b2042202b2043202b206c6f674d202b206c6f6742202b205829302023203c2f7765696768743e14756e626964040c706f730c7533324cd82041206269646465722063616e2072656d6f76652074686569722062696420666f7220656e74727920696e746f20736f63696574792e010120427920646f696e6720736f2c20746865792077696c6c20686176652074686569722063616e646964617465206465706f7369742072657475726e6564206f728420746865792077696c6c20756e766f75636820746865697220766f75636865722e00fc205061796d656e743a2054686520626964206465706f73697420697320756e7265736572766564206966207468652075736572206d6164652061206269642e00050120546865206469737061746368206f726967696e20666f7220746869732063616c6c206d757374206265205f5369676e65645f20616e642061206269646465722e003020506172616d65746572733a1901202d2060706f73603a20506f736974696f6e20696e207468652060426964736020766563746f72206f6620746865206269642077686f2077616e747320746f20756e6269642e002c2023203c7765696768743eb0204b65793a204220286c656e206f662062696473292c2058202862616c616e636520756e72657365727665290d01202d204f6e652073746f72616765207265616420616e6420777269746520746f20726574726965766520616e64207570646174652074686520626964732e204f2842294501202d20456974686572206f6e6520756e726573657276652062616c616e636520616374696f6e204f285829206f72206f6e6520766f756368696e672073746f726167652072656d6f76616c2e204f28312934202d204f6e65206576656e742e006c20546f74616c20436f6d706c65786974793a204f2842202b205829302023203c2f7765696768743e14766f7563680c0c77686f30543a3a4163636f756e7449641476616c75653c42616c616e63654f663c542c20493e0c7469703c42616c616e63654f663c542c20493eb045012041732061206d656d6265722c20766f75636820666f7220736f6d656f6e6520746f206a6f696e20736f636965747920627920706c6163696e67206120626964206f6e20746865697220626568616c662e005501205468657265206973206e6f206465706f73697420726571756972656420746f20766f75636820666f722061206e6577206269642c206275742061206d656d6265722063616e206f6e6c7920766f75636820666f725d01206f6e652062696420617420612074696d652e2049662074686520626964206265636f6d657320612073757370656e6465642063616e64696461746520616e6420756c74696d6174656c792072656a65637465642062794101207468652073757370656e73696f6e206a756467656d656e74206f726967696e2c20746865206d656d6265722077696c6c2062652062616e6e65642066726f6d20766f756368696e6720616761696e2e005901204173206120766f756368696e67206d656d6265722c20796f752063616e20636c61696d206120746970206966207468652063616e6469646174652069732061636365707465642e2054686973207469702077696c6c51012062652070616964206173206120706f7274696f6e206f66207468652072657761726420746865206d656d6265722077696c6c207265636569766520666f72206a6f696e696e672074686520736f63696574792e00050120546865206469737061746368206f726967696e20666f7220746869732063616c6c206d757374206265205f5369676e65645f20616e642061206d656d6265722e003020506172616d65746572733acc202d206077686f603a2054686520757365722077686f20796f7520776f756c64206c696b6520746f20766f75636820666f722e5101202d206076616c7565603a2054686520746f74616c2072657761726420746f2062652070616964206265747765656e20796f7520616e64207468652063616e6469646174652069662074686579206265636f6d65642061206d656d62657220696e2074686520736f63696574792e4901202d2060746970603a20596f757220637574206f662074686520746f74616c206076616c756560207061796f7574207768656e207468652063616e64696461746520697320696e64756374656420696e746f15012074686520736f63696574792e2054697073206c6172676572207468616e206076616c7565602077696c6c206265207361747572617465642075706f6e207061796f75742e002c2023203c7765696768743e0101204b65793a204220286c656e206f662062696473292c204320286c656e206f662063616e64696461746573292c204d20286c656e206f66206d656d626572732944202d2053746f726167652052656164733ac820092d204f6e652073746f72616765207265616420746f20726574726965766520616c6c206d656d626572732e204f284d29090120092d204f6e652073746f72616765207265616420746f20636865636b206d656d626572206973206e6f7420616c726561647920766f756368696e672e204f283129ec20092d204f6e652073746f72616765207265616420746f20636865636b20666f722073757370656e6465642063616e6469646174652e204f283129e020092d204f6e652073746f72616765207265616420746f20636865636b20666f722073757370656e646564206d656d6265722e204f283129dc20092d204f6e652073746f72616765207265616420746f20726574726965766520616c6c2063757272656e7420626964732e204f284229f420092d204f6e652073746f72616765207265616420746f20726574726965766520616c6c2063757272656e742063616e646964617465732e204f28432948202d2053746f72616765205772697465733a0d0120092d204f6e652073746f7261676520777269746520746f20696e7365727420766f756368696e672073746174757320746f20746865206d656d6265722e204f283129810120092d204f6e652073746f72616765206d757461746520746f206164642061206e65772062696420746f2074686520766563746f72204f2842292028544f444f3a20706f737369626c65206f7074696d697a6174696f6e20772f207265616429010120092d20557020746f206f6e652073746f726167652072656d6f76616c206966206269642e6c656e2829203e204d41585f4249445f434f554e542e204f2831295c202d204e6f7461626c6520436f6d7075746174696f6e3ac020092d204f286c6f67204d292073656172636820746f20636865636b2073656e6465722069732061206d656d6265722e2d0120092d204f2842202b2043202b206c6f67204d292073656172636820746f20636865636b2075736572206973206e6f7420616c726561647920612070617274206f6620736f63696574792ec420092d204f286c6f672042292073656172636820746f20696e7365727420746865206e65772062696420736f727465642e78202d2045787465726e616c204d6f64756c65204f7065726174696f6e733a9c20092d204f6e652062616c616e63652072657365727665206f7065726174696f6e2e204f285829210120092d20557020746f206f6e652062616c616e636520756e72657365727665206f7065726174696f6e20696620626964732e6c656e2829203e204d41585f4249445f434f554e542e28202d204576656e74733a6020092d204f6e65206576656e7420666f7220766f7563682efc20092d20557020746f206f6e65206576656e7420666f72204175746f556e626964206966206269642e6c656e2829203e204d41585f4249445f434f554e542e00c420546f74616c20436f6d706c65786974793a204f284d202b2042202b2043202b206c6f674d202b206c6f6742202b205829302023203c2f7765696768743e1c756e766f756368040c706f730c753332442d01204173206120766f756368696e67206d656d6265722c20756e766f7563682061206269642e2054686973206f6e6c7920776f726b73207768696c6520766f7563686564207573657220697394206f6e6c792061206269646465722028616e64206e6f7420612063616e646964617465292e00290120546865206469737061746368206f726967696e20666f7220746869732063616c6c206d757374206265205f5369676e65645f20616e64206120766f756368696e67206d656d6265722e003020506172616d65746572733a2d01202d2060706f73603a20506f736974696f6e20696e207468652060426964736020766563746f72206f6620746865206269642077686f2073686f756c6420626520756e766f75636865642e002c2023203c7765696768743e54204b65793a204220286c656e206f662062696473290901202d204f6e652073746f726167652072656164204f28312920746f20636865636b20746865207369676e6572206973206120766f756368696e67206d656d6265722eec202d204f6e652073746f72616765206d757461746520746f20726574726965766520616e64207570646174652074686520626964732e204f28422994202d204f6e6520766f756368696e672073746f726167652072656d6f76616c2e204f28312934202d204f6e65206576656e742e005c20546f74616c20436f6d706c65786974793a204f284229302023203c2f7765696768743e10766f7465082463616e6469646174658c3c543a3a4c6f6f6b7570206173205374617469634c6f6f6b75703e3a3a536f757263651c617070726f766510626f6f6c4c882041732061206d656d6265722c20766f7465206f6e20612063616e6469646174652e00050120546865206469737061746368206f726967696e20666f7220746869732063616c6c206d757374206265205f5369676e65645f20616e642061206d656d6265722e003020506172616d65746572733a0d01202d206063616e646964617465603a205468652063616e646964617465207468617420746865206d656d62657220776f756c64206c696b6520746f20626964206f6e2ef4202d2060617070726f7665603a204120626f6f6c65616e2077686963682073617973206966207468652063616e6469646174652073686f756c64206265d82020202020202020202020202020617070726f766564202860747275656029206f722072656a656374656420286066616c736560292e002c2023203c7765696768743ebc204b65793a204320286c656e206f662063616e64696461746573292c204d20286c656e206f66206d656d62657273291d01202d204f6e652073746f726167652072656164204f284d2920616e64204f286c6f67204d292073656172636820746f20636865636b20757365722069732061206d656d6265722e58202d204f6e65206163636f756e74206c6f6f6b75702e2d01202d204f6e652073746f726167652072656164204f28432920616e64204f2843292073656172636820746f20636865636b2074686174207573657220697320612063616e6469646174652ebc202d204f6e652073746f7261676520777269746520746f2061646420766f746520746f20766f7465732e204f28312934202d204f6e65206576656e742e008820546f74616c20436f6d706c65786974793a204f284d202b206c6f674d202b204329302023203c2f7765696768743e34646566656e6465725f766f7465041c617070726f766510626f6f6c408c2041732061206d656d6265722c20766f7465206f6e2074686520646566656e6465722e00050120546865206469737061746368206f726967696e20666f7220746869732063616c6c206d757374206265205f5369676e65645f20616e642061206d656d6265722e003020506172616d65746572733af4202d2060617070726f7665603a204120626f6f6c65616e2077686963682073617973206966207468652063616e6469646174652073686f756c64206265a420617070726f766564202860747275656029206f722072656a656374656420286066616c736560292e002c2023203c7765696768743e68202d204b65793a204d20286c656e206f66206d656d62657273291d01202d204f6e652073746f726167652072656164204f284d2920616e64204f286c6f67204d292073656172636820746f20636865636b20757365722069732061206d656d6265722ebc202d204f6e652073746f7261676520777269746520746f2061646420766f746520746f20766f7465732e204f28312934202d204f6e65206576656e742e007820546f74616c20436f6d706c65786974793a204f284d202b206c6f674d29302023203c2f7765696768743e187061796f757400504501205472616e7366657220746865206669727374206d617475726564207061796f757420666f72207468652073656e64657220616e642072656d6f76652069742066726f6d20746865207265636f7264732e006901204e4f54453a20546869732065787472696e736963206e6565647320746f2062652063616c6c6564206d756c7469706c652074696d657320746f20636c61696d206d756c7469706c65206d617475726564207061796f7574732e002101205061796d656e743a20546865206d656d6265722077696c6c20726563656976652061207061796d656e7420657175616c20746f207468656972206669727374206d61747572656478207061796f757420746f20746865697220667265652062616c616e63652e00150120546865206469737061746368206f726967696e20666f7220746869732063616c6c206d757374206265205f5369676e65645f20616e642061206d656d62657220776974684c207061796f7574732072656d61696e696e672e002c2023203c7765696768743e1d01204b65793a204d20286c656e206f66206d656d62657273292c205020286e756d626572206f66207061796f75747320666f72206120706172746963756c6172206d656d626572292501202d204f6e652073746f726167652072656164204f284d2920616e64204f286c6f67204d292073656172636820746f20636865636b207369676e65722069732061206d656d6265722ee4202d204f6e652073746f726167652072656164204f28502920746f2067657420616c6c207061796f75747320666f722061206d656d6265722ee4202d204f6e652073746f726167652072656164204f28312920746f20676574207468652063757272656e7420626c6f636b206e756d6265722e8c202d204f6e652063757272656e6379207472616e736665722063616c6c2e204f2858291101202d204f6e652073746f72616765207772697465206f722072656d6f76616c20746f2075706461746520746865206d656d6265722773207061796f7574732e204f285029009820546f74616c20436f6d706c65786974793a204f284d202b206c6f674d202b2050202b205829302023203c2f7765696768743e14666f756e640c1c666f756e64657230543a3a4163636f756e7449642c6d61785f6d656d626572730c7533321472756c65731c5665633c75383e4c4c20466f756e642074686520736f63696574792e00f0205468697320697320646f6e65206173206120646973637265746520616374696f6e20696e206f7264657220746f20616c6c6f7720666f72207468651901206d6f64756c6520746f20626520696e636c7564656420696e746f20612072756e6e696e6720636861696e20616e642063616e206f6e6c7920626520646f6e65206f6e63652e001d0120546865206469737061746368206f726967696e20666f7220746869732063616c6c206d7573742062652066726f6d20746865205f466f756e6465725365744f726967696e5f2e003020506172616d65746572733a1901202d2060666f756e64657260202d20546865206669727374206d656d62657220616e642068656164206f6620746865206e65776c7920666f756e64656420736f63696574792e1501202d20606d61785f6d656d6265727360202d2054686520696e697469616c206d6178206e756d626572206f66206d656d6265727320666f722074686520736f63696574792ef4202d206072756c657360202d205468652072756c6573206f66207468697320736f636965747920636f6e6365726e696e67206d656d626572736869702e002c2023203c7765696768743ee0202d2054776f2073746f72616765206d75746174657320746f207365742060486561646020616e642060466f756e646572602e204f283129f4202d204f6e652073746f7261676520777269746520746f2061646420746865206669727374206d656d62657220746f20736f63696574792e204f28312934202d204f6e65206576656e742e005c20546f74616c20436f6d706c65786974793a204f283129302023203c2f7765696768743e1c756e666f756e6400348c20416e6e756c2074686520666f756e64696e67206f662074686520736f63696574792e005d0120546865206469737061746368206f726967696e20666f7220746869732063616c6c206d757374206265205369676e65642c20616e6420746865207369676e696e67206163636f756e74206d75737420626520626f74685901207468652060466f756e6465726020616e6420746865206048656164602e205468697320696d706c6965732074686174206974206d6179206f6e6c7920626520646f6e65207768656e207468657265206973206f6e6520206d656d6265722e002c2023203c7765696768743e68202d2054776f2073746f72616765207265616473204f2831292e78202d20466f75722073746f726167652072656d6f76616c73204f2831292e34202d204f6e65206576656e742e005c20546f74616c20436f6d706c65786974793a204f283129302023203c2f7765696768743e586a756467655f73757370656e6465645f6d656d626572080c77686f30543a3a4163636f756e7449641c666f726769766510626f6f6c6c2d0120416c6c6f772073757370656e73696f6e206a756467656d656e74206f726967696e20746f206d616b65206a756467656d656e74206f6e20612073757370656e646564206d656d6265722e00590120496620612073757370656e646564206d656d62657220697320666f72676976656e2c2077652073696d706c7920616464207468656d206261636b2061732061206d656d6265722c206e6f7420616666656374696e67cc20616e79206f6620746865206578697374696e672073746f72616765206974656d7320666f722074686174206d656d6265722e00490120496620612073757370656e646564206d656d6265722069732072656a65637465642c2072656d6f766520616c6c206173736f6369617465642073746f72616765206974656d732c20696e636c7564696e670101207468656972207061796f7574732c20616e642072656d6f766520616e7920766f7563686564206269647320746865792063757272656e746c7920686176652e00410120546865206469737061746368206f726967696e20666f7220746869732063616c6c206d7573742062652066726f6d20746865205f53757370656e73696f6e4a756467656d656e744f726967696e5f2e003020506172616d65746572733ab4202d206077686f60202d205468652073757370656e646564206d656d62657220746f206265206a75646765642e3501202d2060666f726769766560202d204120626f6f6c65616e20726570726573656e74696e672077686574686572207468652073757370656e73696f6e206a756467656d656e74206f726967696e2501202020202020202020202020202020666f726769766573202860747275656029206f722072656a6563747320286066616c7365602920612073757370656e646564206d656d6265722e002c2023203c7765696768743ea4204b65793a204220286c656e206f662062696473292c204d20286c656e206f66206d656d6265727329f8202d204f6e652073746f72616765207265616420746f20636865636b206077686f6020697320612073757370656e646564206d656d6265722e204f2831297101202d20557020746f206f6e652073746f72616765207772697465204f284d292077697468204f286c6f67204d292062696e6172792073656172636820746f206164642061206d656d626572206261636b20746f20736f63696574792ef8202d20557020746f20332073746f726167652072656d6f76616c73204f28312920746f20636c65616e20757020612072656d6f766564206d656d6265722e4501202d20557020746f206f6e652073746f72616765207772697465204f2842292077697468204f2842292073656172636820746f2072656d6f766520766f7563686564206269642066726f6d20626964732ed4202d20557020746f206f6e65206164646974696f6e616c206576656e7420696620756e766f7563682074616b657320706c6163652e70202d204f6e652073746f726167652072656d6f76616c2e204f2831297c202d204f6e65206576656e7420666f7220746865206a756467656d656e742e008820546f74616c20436f6d706c65786974793a204f284d202b206c6f674d202b204229302023203c2f7765696768743e646a756467655f73757370656e6465645f63616e646964617465080c77686f30543a3a4163636f756e744964246a756467656d656e74244a756467656d656e74a0350120416c6c6f772073757370656e646564206a756467656d656e74206f726967696e20746f206d616b65206a756467656d656e74206f6e20612073757370656e6465642063616e6469646174652e005d0120496620746865206a756467656d656e742069732060417070726f7665602c20776520616464207468656d20746f20736f63696574792061732061206d656d62657220776974682074686520617070726f70726961746574207061796d656e7420666f72206a6f696e696e6720736f63696574792e00550120496620746865206a756467656d656e74206973206052656a656374602c2077652065697468657220736c61736820746865206465706f736974206f6620746865206269642c20676976696e67206974206261636b110120746f2074686520736f63696574792074726561737572792c206f722077652062616e2074686520766f75636865722066726f6d20766f756368696e6720616761696e2e005d0120496620746865206a756467656d656e7420697320605265626964602c20776520707574207468652063616e646964617465206261636b20696e207468652062696420706f6f6c20616e64206c6574207468656d20676f94207468726f7567682074686520696e64756374696f6e2070726f6365737320616761696e2e00410120546865206469737061746368206f726967696e20666f7220746869732063616c6c206d7573742062652066726f6d20746865205f53757370656e73696f6e4a756467656d656e744f726967696e5f2e003020506172616d65746572733ac0202d206077686f60202d205468652073757370656e6465642063616e64696461746520746f206265206a75646765642ec4202d20606a756467656d656e7460202d2060417070726f7665602c206052656a656374602c206f7220605265626964602e002c2023203c7765696768743ef4204b65793a204220286c656e206f662062696473292c204d20286c656e206f66206d656d62657273292c2058202862616c616e636520616374696f6e29f0202d204f6e652073746f72616765207265616420746f20636865636b206077686f6020697320612073757370656e6465642063616e6469646174652ec8202d204f6e652073746f726167652072656d6f76616c206f66207468652073757370656e6465642063616e6469646174652e40202d20417070726f7665204c6f676963150120092d204f6e652073746f72616765207265616420746f206765742074686520617661696c61626c6520706f7420746f2070617920757365727320776974682e204f283129dc20092d204f6e652073746f7261676520777269746520746f207570646174652074686520617661696c61626c6520706f742e204f283129e820092d204f6e652073746f72616765207265616420746f20676574207468652063757272656e7420626c6f636b206e756d6265722e204f283129b420092d204f6e652073746f72616765207265616420746f2067657420616c6c206d656d626572732e204f284d29a020092d20557020746f206f6e6520756e726573657276652063757272656e637920616374696f6e2eb020092d20557020746f2074776f206e65772073746f726167652077726974657320746f207061796f7574732e4d0120092d20557020746f206f6e652073746f726167652077726974652077697468204f286c6f67204d292062696e6172792073656172636820746f206164642061206d656d62657220746f20736f63696574792e3c202d2052656a656374204c6f676963dc20092d20557020746f206f6e6520726570617472696174652072657365727665642063757272656e637920616374696f6e2e204f2858292d0120092d20557020746f206f6e652073746f7261676520777269746520746f2062616e2074686520766f756368696e67206d656d6265722066726f6d20766f756368696e6720616761696e2e38202d205265626964204c6f676963410120092d2053746f72616765206d75746174652077697468204f286c6f672042292062696e6172792073656172636820746f20706c616365207468652075736572206261636b20696e746f20626964732ed4202d20557020746f206f6e65206164646974696f6e616c206576656e7420696620756e766f7563682074616b657320706c6163652e5c202d204f6e652073746f726167652072656d6f76616c2e7c202d204f6e65206576656e7420666f7220746865206a756467656d656e742e009820546f74616c20436f6d706c65786974793a204f284d202b206c6f674d202b2042202b205829302023203c2f7765696768743e3c7365745f6d61785f6d656d62657273040c6d61780c753332381d0120416c6c6f777320726f6f74206f726967696e20746f206368616e676520746865206d6178696d756d206e756d626572206f66206d656d6265727320696e20736f63696574792eb4204d6178206d656d6265727368697020636f756e74206d7573742062652067726561746572207468616e20312e00dc20546865206469737061746368206f726967696e20666f7220746869732063616c6c206d7573742062652066726f6d205f524f4f545f2e003020506172616d65746572733ae4202d20606d617860202d20546865206d6178696d756d206e756d626572206f66206d656d6265727320666f722074686520736f63696574792e002c2023203c7765696768743eb0202d204f6e652073746f7261676520777269746520746f2075706461746520746865206d61782e204f28312934202d204f6e65206576656e742e005c20546f74616c20436f6d706c65786974793a204f283129302023203c2f7765696768743e013c1c466f756e64656404244163636f756e74496404b82054686520736f636965747920697320666f756e6465642062792074686520676976656e206964656e746974792e0c42696408244163636f756e7449641c42616c616e63650861012041206d656d6265727368697020626964206a7573742068617070656e65642e2054686520676976656e206163636f756e74206973207468652063616e646964617465277320494420616e64207468656972206f666665723c20697320746865207365636f6e642e14566f7563680c244163636f756e7449641c42616c616e6365244163636f756e7449640861012041206d656d6265727368697020626964206a7573742068617070656e656420627920766f756368696e672e2054686520676976656e206163636f756e74206973207468652063616e646964617465277320494420616e64f0207468656972206f6666657220697320746865207365636f6e642e2054686520766f756368696e67207061727479206973207468652074686972642e244175746f556e62696404244163636f756e74496404090120412063616e646964617465207761732064726f70706564202864756520746f20616e20657863657373206f66206269647320696e207468652073797374656d292e14556e62696404244163636f756e74496404b020412063616e646964617465207761732064726f70706564202862792074686569722072657175657374292e1c556e766f75636804244163636f756e74496404f820412063616e646964617465207761732064726f70706564202862792072657175657374206f662077686f20766f756368656420666f72207468656d292e20496e64756374656408244163636f756e744964385665633c4163636f756e7449643e08590120412067726f7570206f662063616e646964617465732068617665206265656e20696e6475637465642e205468652062617463682773207072696d617279206973207468652066697273742076616c75652c207468657420626174636820696e2066756c6c20697320746865207365636f6e642e6053757370656e6465644d656d6265724a756467656d656e7408244163636f756e74496410626f6f6c048c20412073757370656e646564206d656d62657220686173206265656e206a75646765644843616e64696461746553757370656e64656404244163636f756e744964047c20412063616e64696461746520686173206265656e2073757370656e6465643c4d656d62657253757370656e64656404244163636f756e74496404702041206d656d62657220686173206265656e2073757370656e646564284368616c6c656e67656404244163636f756e74496404742041206d656d62657220686173206265656e206368616c6c656e67656410566f74650c244163636f756e744964244163636f756e74496410626f6f6c04c0204120766f746520686173206265656e20706c61636564202863616e6469646174652c20766f7465722c20766f74652930446566656e646572566f746508244163636f756e74496410626f6f6c04f0204120766f746520686173206265656e20706c6163656420666f72206120646566656e64696e67206d656d6265722028766f7465722c20766f746529344e65774d61784d656d62657273040c75333204902041206e6577206d6178206d656d62657220636f756e7420686173206265656e2073657424556e666f756e64656404244163636f756e744964045820536f636965747920697320756e666f756e6465642e1c4043616e6469646174654465706f7369743c42616c616e63654f663c542c20493e400080c6a47e8d0300000000000000000004fc20546865206d696e696d756d20616d6f756e74206f662061206465706f73697420726571756972656420666f7220612062696420746f206265206d6164652e4857726f6e6753696465446564756374696f6e3c42616c616e63654f663c542c20493e400080f420e6b5000000000000000000000855012054686520616d6f756e74206f662074686520756e70616964207265776172642074686174206765747320646564756374656420696e207468652063617365207468617420656974686572206120736b6570746963c020646f65736e277420766f7465206f7220736f6d656f6e6520766f74657320696e207468652077726f6e67207761792e284d6178537472696b65730c753332100a00000008750120546865206e756d626572206f662074696d65732061206d656d626572206d617920766f7465207468652077726f6e672077617920286f72206e6f7420617420616c6c2c207768656e207468657920617265206120736b65707469632978206265666f72652074686579206265636f6d652073757370656e6465642e2c506572696f645370656e643c42616c616e63654f663c542c20493e400000c52ebca2b1000000000000000000042d012054686520616d6f756e74206f6620696e63656e7469766520706169642077697468696e206561636820706572696f642e20446f65736e277420696e636c75646520566f7465725469702e38526f746174696f6e506572696f6438543a3a426c6f636b4e756d626572100077010004110120546865206e756d626572206f6620626c6f636b73206265747765656e2063616e6469646174652f6d656d6265727368697020726f746174696f6e20706572696f64732e3c4368616c6c656e6765506572696f6438543a3a426c6f636b4e756d626572108013030004d020546865206e756d626572206f6620626c6f636b73206265747765656e206d656d62657273686970206368616c6c656e6765732e204d6f64756c654964204d6f64756c6549642070792f736f63696504682054686520736f636965746965732773206d6f64756c65206964482c426164506f736974696f6e049020416e20696e636f727265637420706f736974696f6e207761732070726f76696465642e244e6f744d656d62657204582055736572206973206e6f742061206d656d6265722e34416c72656164794d656d6265720468205573657220697320616c72656164792061206d656d6265722e2453757370656e646564044c20557365722069732073757370656e6465642e304e6f7453757370656e646564045c2055736572206973206e6f742073757370656e6465642e204e6f5061796f7574044c204e6f7468696e6720746f207061796f75742e38416c7265616479466f756e646564046420536f636965747920616c726561647920666f756e6465642e3c496e73756666696369656e74506f74049c204e6f7420656e6f75676820696e20706f7420746f206163636570742063616e6469646174652e3c416c7265616479566f756368696e6704e8204d656d62657220697320616c726561647920766f756368696e67206f722062616e6e65642066726f6d20766f756368696e6720616761696e2e2c4e6f74566f756368696e670460204d656d626572206973206e6f7420766f756368696e672e104865616404942043616e6e6f742072656d6f7665207468652068656164206f662074686520636861696e2e1c466f756e646572046c2043616e6e6f742072656d6f76652074686520666f756e6465722e28416c7265616479426964047420557365722068617320616c7265616479206d6164652061206269642e40416c726561647943616e6469646174650474205573657220697320616c726561647920612063616e6469646174652e304e6f7443616e64696461746504642055736572206973206e6f7420612063616e6469646174652e284d61784d656d62657273048420546f6f206d616e79206d656d6265727320696e2074686520736f63696574792e284e6f74466f756e646572047c205468652063616c6c6572206973206e6f742074686520666f756e6465722e1c4e6f74486561640470205468652063616c6c6572206973206e6f742074686520686561642e205265636f7665727901205265636f766572790c2c5265636f76657261626c6500010530543a3a4163636f756e744964e85265636f76657279436f6e6669673c543a3a426c6f636b4e756d6265722c2042616c616e63654f663c543e2c20543a3a4163636f756e7449643e0004000409012054686520736574206f66207265636f76657261626c65206163636f756e747320616e64207468656972207265636f7665727920636f6e66696775726174696f6e2e404163746976655265636f76657269657300020530543a3a4163636f756e74496430543a3a4163636f756e744964e84163746976655265636f766572793c543a3a426c6f636b4e756d6265722c2042616c616e63654f663c543e2c20543a3a4163636f756e7449643e050400106820416374697665207265636f7665727920617474656d7074732e001501204669727374206163636f756e7420697320746865206163636f756e7420746f206265207265636f76657265642c20616e6420746865207365636f6e64206163636f756e74ac20697320746865207573657220747279696e6720746f207265636f76657220746865206163636f756e742e1450726f787900010230543a3a4163636f756e74496430543a3a4163636f756e7449640004000c9020546865206c697374206f6620616c6c6f7765642070726f7879206163636f756e74732e00f8204d61702066726f6d2074686520757365722077686f2063616e2061636365737320697420746f20746865207265636f7665726564206163636f756e742e01243061735f7265636f7665726564081c6163636f756e7430543a3a4163636f756e7449641063616c6c5c426f783c3c542061732054726169743e3a3a43616c6c3e34a42053656e6420612063616c6c207468726f7567682061207265636f7665726564206163636f756e742e00150120546865206469737061746368206f726967696e20666f7220746869732063616c6c206d757374206265205f5369676e65645f20616e64207265676973746572656420746fe82062652061626c6520746f206d616b652063616c6c73206f6e20626568616c66206f6620746865207265636f7665726564206163636f756e742e003020506172616d65746572733a2501202d20606163636f756e74603a20546865207265636f7665726564206163636f756e7420796f752077616e7420746f206d616b6520612063616c6c206f6e2d626568616c662d6f662e0101202d206063616c6c603a205468652063616c6c20796f752077616e7420746f206d616b65207769746820746865207265636f7665726564206163636f756e742e002c2023203c7765696768743e94202d2054686520776569676874206f6620746865206063616c6c60202b2031302c3030302e0901202d204f6e652073746f72616765206c6f6f6b757020746f20636865636b206163636f756e74206973207265636f7665726564206279206077686f602e204f283129302023203c2f7765696768743e347365745f7265636f766572656408106c6f737430543a3a4163636f756e7449641c7265736375657230543a3a4163636f756e744964341d0120416c6c6f7720524f4f5420746f2062797061737320746865207265636f766572792070726f6365737320616e642073657420616e20612072657363756572206163636f756e747420666f722061206c6f7374206163636f756e74206469726563746c792e00c820546865206469737061746368206f726967696e20666f7220746869732063616c6c206d757374206265205f524f4f545f2e003020506172616d65746572733ab8202d20606c6f7374603a2054686520226c6f7374206163636f756e742220746f206265207265636f76657265642e1d01202d206072657363756572603a20546865202272657363756572206163636f756e74222077686963682063616e2063616c6c20617320746865206c6f7374206163636f756e742e002c2023203c7765696768743e64202d204f6e652073746f72616765207772697465204f28312930202d204f6e65206576656e74302023203c2f7765696768743e3c6372656174655f7265636f766572790c1c667269656e6473445665633c543a3a4163636f756e7449643e247468726573686f6c640c7531363064656c61795f706572696f6438543a3a426c6f636b4e756d6265726c5d01204372656174652061207265636f7665727920636f6e66696775726174696f6e20666f7220796f7572206163636f756e742e2054686973206d616b657320796f7572206163636f756e74207265636f76657261626c652e003101205061796d656e743a2060436f6e6669674465706f7369744261736560202b2060467269656e644465706f736974466163746f7260202a20235f6f665f667269656e64732062616c616e636549012077696c6c20626520726573657276656420666f722073746f72696e6720746865207265636f7665727920636f6e66696775726174696f6e2e2054686973206465706f7369742069732072657475726e6564bc20696e2066756c6c207768656e2074686520757365722063616c6c73206072656d6f76655f7265636f76657279602e00d020546865206469737061746368206f726967696e20666f7220746869732063616c6c206d757374206265205f5369676e65645f2e003020506172616d65746572733a2501202d2060667269656e6473603a2041206c697374206f6620667269656e647320796f7520747275737420746f20766f75636820666f72207265636f7665727920617474656d7074732ed420202053686f756c64206265206f72646572656420616e6420636f6e7461696e206e6f206475706c69636174652076616c7565732e3101202d20607468726573686f6c64603a20546865206e756d626572206f6620667269656e64732074686174206d75737420766f75636820666f722061207265636f7665727920617474656d70741d012020206265666f726520746865206163636f756e742063616e206265207265636f76657265642e2053686f756c64206265206c657373207468616e206f7220657175616c20746f94202020746865206c656e677468206f6620746865206c697374206f6620667269656e64732e3d01202d206064656c61795f706572696f64603a20546865206e756d626572206f6620626c6f636b732061667465722061207265636f7665727920617474656d707420697320696e697469616c697a6564e820202074686174206e6565647320746f2070617373206265666f726520746865206163636f756e742063616e206265207265636f76657265642e002c2023203c7765696768743e68202d204b65793a204620286c656e206f6620667269656e6473292d01202d204f6e652073746f72616765207265616420746f20636865636b2074686174206163636f756e74206973206e6f7420616c7265616479207265636f76657261626c652e204f2831292eec202d204120636865636b20746861742074686520667269656e6473206c69737420697320736f7274656420616e6420756e697175652e204f2846299c202d204f6e652063757272656e63792072657365727665206f7065726174696f6e2e204f2858299c202d204f6e652073746f726167652077726974652e204f2831292e20436f646563204f2846292e34202d204f6e65206576656e742e006c20546f74616c20436f6d706c65786974793a204f2846202b205829302023203c2f7765696768743e44696e6974696174655f7265636f76657279041c6163636f756e7430543a3a4163636f756e74496458ec20496e697469617465207468652070726f6365737320666f72207265636f766572696e672061207265636f76657261626c65206163636f756e742e001d01205061796d656e743a20605265636f766572794465706f736974602062616c616e63652077696c6c20626520726573657276656420666f7220696e6974696174696e67207468652501207265636f766572792070726f636573732e2054686973206465706f7369742077696c6c20616c7761797320626520726570617472696174656420746f20746865206163636f756e74b820747279696e6720746f206265207265636f76657265642e205365652060636c6f73655f7265636f76657279602e00d020546865206469737061746368206f726967696e20666f7220746869732063616c6c206d757374206265205f5369676e65645f2e003020506172616d65746572733a1501202d20606163636f756e74603a20546865206c6f7374206163636f756e74207468617420796f752077616e7420746f207265636f7665722e2054686973206163636f756e7401012020206e6565647320746f206265207265636f76657261626c652028692e652e20686176652061207265636f7665727920636f6e66696775726174696f6e292e002c2023203c7765696768743ef8202d204f6e652073746f72616765207265616420746f20636865636b2074686174206163636f756e74206973207265636f76657261626c652e204f2846295101202d204f6e652073746f72616765207265616420746f20636865636b20746861742074686973207265636f766572792070726f63657373206861736e277420616c726561647920737461727465642e204f2831299c202d204f6e652063757272656e63792072657365727665206f7065726174696f6e2e204f285829e4202d204f6e652073746f72616765207265616420746f20676574207468652063757272656e7420626c6f636b206e756d6265722e204f2831296c202d204f6e652073746f726167652077726974652e204f2831292e34202d204f6e65206576656e742e006c20546f74616c20436f6d706c65786974793a204f2846202b205829302023203c2f7765696768743e38766f7563685f7265636f7665727908106c6f737430543a3a4163636f756e7449641c7265736375657230543a3a4163636f756e74496464290120416c6c6f7720612022667269656e6422206f662061207265636f76657261626c65206163636f756e7420746f20766f75636820666f7220616e20616374697665207265636f76657279682070726f6365737320666f722074686174206163636f756e742e00290120546865206469737061746368206f726967696e20666f7220746869732063616c6c206d757374206265205f5369676e65645f20616e64206d75737420626520612022667269656e64227420666f7220746865207265636f76657261626c65206163636f756e742e003020506172616d65746572733ad4202d20606c6f7374603a20546865206c6f7374206163636f756e74207468617420796f752077616e7420746f207265636f7665722e1101202d206072657363756572603a20546865206163636f756e7420747279696e6720746f2072657363756520746865206c6f7374206163636f756e74207468617420796f755420202077616e7420746f20766f75636820666f722e0025012054686520636f6d62696e6174696f6e206f662074686573652074776f20706172616d6574657273206d75737420706f696e7420746f20616e20616374697665207265636f76657279242070726f636573732e002c2023203c7765696768743efc204b65793a204620286c656e206f6620667269656e647320696e20636f6e666967292c205620286c656e206f6620766f756368696e6720667269656e6473291d01202d204f6e652073746f72616765207265616420746f2067657420746865207265636f7665727920636f6e66696775726174696f6e2e204f2831292c20436f646563204f2846292101202d204f6e652073746f72616765207265616420746f206765742074686520616374697665207265636f766572792070726f636573732e204f2831292c20436f646563204f285629ec202d204f6e652062696e6172792073656172636820746f20636f6e6669726d2063616c6c6572206973206120667269656e642e204f286c6f6746291d01202d204f6e652062696e6172792073656172636820746f20636f6e6669726d2063616c6c657220686173206e6f7420616c726561647920766f75636865642e204f286c6f6756299c202d204f6e652073746f726167652077726974652e204f2831292c20436f646563204f2856292e34202d204f6e65206576656e742e00a420546f74616c20436f6d706c65786974793a204f2846202b206c6f6746202b2056202b206c6f675629302023203c2f7765696768743e38636c61696d5f7265636f76657279041c6163636f756e7430543a3a4163636f756e74496450f420416c6c6f772061207375636365737366756c207265736375657220746f20636c61696d207468656972207265636f7665726564206163636f756e742e002d0120546865206469737061746368206f726967696e20666f7220746869732063616c6c206d757374206265205f5369676e65645f20616e64206d7573742062652061202272657363756572221d012077686f20686173207375636365737366756c6c7920636f6d706c6574656420746865206163636f756e74207265636f766572792070726f636573733a20636f6c6c6563746564310120607468726573686f6c6460206f72206d6f726520766f75636865732c20776169746564206064656c61795f706572696f646020626c6f636b732073696e636520696e6974696174696f6e2e003020506172616d65746572733a2d01202d20606163636f756e74603a20546865206c6f7374206163636f756e74207468617420796f752077616e7420746f20636c61696d20686173206265656e207375636365737366756c6c79502020207265636f766572656420627920796f752e002c2023203c7765696768743efc204b65793a204620286c656e206f6620667269656e647320696e20636f6e666967292c205620286c656e206f6620766f756368696e6720667269656e6473291d01202d204f6e652073746f72616765207265616420746f2067657420746865207265636f7665727920636f6e66696775726174696f6e2e204f2831292c20436f646563204f2846292101202d204f6e652073746f72616765207265616420746f206765742074686520616374697665207265636f766572792070726f636573732e204f2831292c20436f646563204f285629e4202d204f6e652073746f72616765207265616420746f20676574207468652063757272656e7420626c6f636b206e756d6265722e204f2831299c202d204f6e652073746f726167652077726974652e204f2831292c20436f646563204f2856292e34202d204f6e65206576656e742e006c20546f74616c20436f6d706c65786974793a204f2846202b205629302023203c2f7765696768743e38636c6f73655f7265636f76657279041c7265736375657230543a3a4163636f756e7449645015012041732074686520636f6e74726f6c6c6572206f662061207265636f76657261626c65206163636f756e742c20636c6f736520616e20616374697665207265636f76657279682070726f6365737320666f7220796f7572206163636f756e742e002101205061796d656e743a2042792063616c6c696e6720746869732066756e6374696f6e2c20746865207265636f76657261626c65206163636f756e742077696c6c2072656365697665f820746865207265636f76657279206465706f73697420605265636f766572794465706f7369746020706c616365642062792074686520726573637565722e00050120546865206469737061746368206f726967696e20666f7220746869732063616c6c206d757374206265205f5369676e65645f20616e64206d7573742062652061f0207265636f76657261626c65206163636f756e74207769746820616e20616374697665207265636f766572792070726f6365737320666f722069742e003020506172616d65746572733a1101202d206072657363756572603a20546865206163636f756e7420747279696e6720746f207265736375652074686973207265636f76657261626c65206163636f756e742e002c2023203c7765696768743e84204b65793a205620286c656e206f6620766f756368696e6720667269656e6473293d01202d204f6e652073746f7261676520726561642f72656d6f766520746f206765742074686520616374697665207265636f766572792070726f636573732e204f2831292c20436f646563204f285629c0202d204f6e652062616c616e63652063616c6c20746f20726570617472696174652072657365727665642e204f28582934202d204f6e65206576656e742e006c20546f74616c20436f6d706c65786974793a204f2856202b205829302023203c2f7765696768743e3c72656d6f76655f7265636f7665727900545d012052656d6f766520746865207265636f766572792070726f6365737320666f7220796f7572206163636f756e742e205265636f7665726564206163636f756e747320617265207374696c6c2061636365737369626c652e001501204e4f54453a205468652075736572206d757374206d616b65207375726520746f2063616c6c2060636c6f73655f7265636f7665727960206f6e20616c6c206163746976650901207265636f7665727920617474656d707473206265666f72652063616c6c696e6720746869732066756e6374696f6e20656c73652069742077696c6c206661696c2e002501205061796d656e743a2042792063616c6c696e6720746869732066756e6374696f6e20746865207265636f76657261626c65206163636f756e742077696c6c20756e7265736572766598207468656972207265636f7665727920636f6e66696775726174696f6e206465706f7369742ef4202860436f6e6669674465706f7369744261736560202b2060467269656e644465706f736974466163746f7260202a20235f6f665f667269656e64732900050120546865206469737061746368206f726967696e20666f7220746869732063616c6c206d757374206265205f5369676e65645f20616e64206d7573742062652061e4207265636f76657261626c65206163636f756e742028692e652e206861732061207265636f7665727920636f6e66696775726174696f6e292e002c2023203c7765696768743e60204b65793a204620286c656e206f6620667269656e6473292901202d204f6e652073746f72616765207265616420746f206765742074686520707265666978206974657261746f7220666f7220616374697665207265636f7665726965732e204f2831293901202d204f6e652073746f7261676520726561642f72656d6f766520746f2067657420746865207265636f7665727920636f6e66696775726174696f6e2e204f2831292c20436f646563204f2846299c202d204f6e652062616c616e63652063616c6c20746f20756e72657365727665642e204f28582934202d204f6e65206576656e742e006c20546f74616c20436f6d706c65786974793a204f2846202b205829302023203c2f7765696768743e4063616e63656c5f7265636f7665726564041c6163636f756e7430543a3a4163636f756e7449642ce02043616e63656c20746865206162696c69747920746f20757365206061735f7265636f76657265646020666f7220606163636f756e74602e00150120546865206469737061746368206f726967696e20666f7220746869732063616c6c206d757374206265205f5369676e65645f20616e64207265676973746572656420746fe82062652061626c6520746f206d616b652063616c6c73206f6e20626568616c66206f6620746865207265636f7665726564206163636f756e742e003020506172616d65746572733a1901202d20606163636f756e74603a20546865207265636f7665726564206163636f756e7420796f75206172652061626c6520746f2063616c6c206f6e2d626568616c662d6f662e002c2023203c7765696768743e1101202d204f6e652073746f72616765206d75746174696f6e20746f20636865636b206163636f756e74206973207265636f7665726564206279206077686f602e204f283129302023203c2f7765696768743e01183c5265636f766572794372656174656404244163636f756e74496404c82041207265636f766572792070726f6365737320686173206265656e2073657420757020666f7220616e206163636f756e74445265636f76657279496e6974696174656408244163636f756e744964244163636f756e7449640405012041207265636f766572792070726f6365737320686173206265656e20696e6974696174656420666f72206163636f756e745f31206279206163636f756e745f323c5265636f76657279566f75636865640c244163636f756e744964244163636f756e744964244163636f756e7449640441012041207265636f766572792070726f6365737320666f72206163636f756e745f31206279206163636f756e745f3220686173206265656e20766f756368656420666f72206279206163636f756e745f33385265636f76657279436c6f73656408244163636f756e744964244163636f756e74496404f82041207265636f766572792070726f6365737320666f72206163636f756e745f31206279206163636f756e745f3220686173206265656e20636c6f736564404163636f756e745265636f766572656408244163636f756e744964244163636f756e74496404dc204163636f756e745f3120686173206265656e207375636365737366756c6c79207265636f7665726564206279206163636f756e745f323c5265636f7665727952656d6f76656404244163636f756e74496404cc2041207265636f766572792070726f6365737320686173206265656e2072656d6f76656420666f7220616e206163636f756e741044436f6e6669674465706f736974426173653042616c616e63654f663c543e4000406352bfc60100000000000000000004550120546865206261736520616d6f756e74206f662063757272656e6379206e656564656420746f207265736572766520666f72206372656174696e672061207265636f7665727920636f6e66696775726174696f6e2e4c467269656e644465706f736974466163746f723042616c616e63654f663c543e4000203d88792d000000000000000000000469012054686520616d6f756e74206f662063757272656e6379206e656564656420706572206164646974696f6e616c2075736572207768656e206372656174696e672061207265636f7665727920636f6e66696775726174696f6e2e284d6178467269656e64730c753136080900040d0120546865206d6178696d756d20616d6f756e74206f6620667269656e647320616c6c6f77656420696e2061207265636f7665727920636f6e66696775726174696f6e2e3c5265636f766572794465706f7369743042616c616e63654f663c543e4000406352bfc601000000000000000000041d0120546865206261736520616d6f756e74206f662063757272656e6379206e656564656420746f207265736572766520666f72207374617274696e672061207265636f766572792e40284e6f74416c6c6f77656404f42055736572206973206e6f7420616c6c6f77656420746f206d616b6520612063616c6c206f6e20626568616c66206f662074686973206163636f756e74345a65726f5468726573686f6c640490205468726573686f6c64206d7573742062652067726561746572207468616e207a65726f404e6f74456e6f756768467269656e647304d420467269656e6473206c697374206d7573742062652067726561746572207468616e207a65726f20616e64207468726573686f6c64284d6178467269656e647304ac20467269656e6473206c697374206d757374206265206c657373207468616e206d617820667269656e6473244e6f74536f7274656404cc20467269656e6473206c697374206d75737420626520736f7274656420616e642066726565206f66206475706c696361746573384e6f745265636f76657261626c6504a02054686973206163636f756e74206973206e6f742073657420757020666f72207265636f7665727948416c72656164795265636f76657261626c6504b02054686973206163636f756e7420697320616c72656164792073657420757020666f72207265636f7665727938416c72656164795374617274656404e02041207265636f766572792070726f636573732068617320616c7265616479207374617274656420666f722074686973206163636f756e74284e6f745374617274656404d02041207265636f766572792070726f6365737320686173206e6f74207374617274656420666f7220746869732072657363756572244e6f74467269656e6404ac2054686973206163636f756e74206973206e6f74206120667269656e642077686f2063616e20766f7563682c44656c6179506572696f64041d012054686520667269656e64206d757374207761697420756e74696c207468652064656c617920706572696f6420746f20766f75636820666f722074686973207265636f7665727938416c7265616479566f756368656404c0205468697320757365722068617320616c726561647920766f756368656420666f722074686973207265636f76657279245468726573686f6c6404ec20546865207468726573686f6c6420666f72207265636f766572696e672074686973206163636f756e7420686173206e6f74206265656e206d65742c5374696c6c41637469766504010120546865726520617265207374696c6c20616374697665207265636f7665727920617474656d7074732074686174206e65656420746f20626520636c6f736564204f766572666c6f77049c2054686572652077617320616e206f766572666c6f7720696e20612063616c63756c6174696f6e30416c726561647950726f787904b02054686973206163636f756e7420697320616c72656164792073657420757020666f72207265636f766572791c56657374696e67011c56657374696e67041c56657374696e6700010230543a3a4163636f756e744964a456657374696e67496e666f3c42616c616e63654f663c543e2c20543a3a426c6f636b4e756d6265723e00040004d820496e666f726d6174696f6e20726567617264696e67207468652076657374696e67206f66206120676976656e206163636f756e742e011010766573740044bc20556e6c6f636b20616e79207665737465642066756e6473206f66207468652073656e646572206163636f756e742e00610120546865206469737061746368206f726967696e20666f7220746869732063616c6c206d757374206265205f5369676e65645f20616e64207468652073656e646572206d75737420686176652066756e6473207374696c6c68206c6f636b656420756e6465722074686973206d6f64756c652e00d420456d69747320656974686572206056657374696e67436f6d706c6574656460206f72206056657374696e6755706461746564602e002c2023203c7765696768743e28202d20604f283129602e78202d2044625765696768743a20322052656164732c203220577269746573fc20202020202d2052656164733a2056657374696e672053746f726167652c2042616c616e636573204c6f636b732c205b53656e646572204163636f756e745d010120202020202d205772697465733a2056657374696e672053746f726167652c2042616c616e636573204c6f636b732c205b53656e646572204163636f756e745d34202d2042656e63686d61726b3aec20202020202d20556e6c6f636b65643a2034382e3736202b202e303438202a206c20c2b57320286d696e2073717561726520616e616c7973697329e420202020202d204c6f636b65643a2034342e3433202b202e323834202a206c20c2b57320286d696e2073717561726520616e616c7973697329ad01202d205573696e6720353020c2b5732066697865642e20417373756d696e67206c657373207468616e203530206c6f636b73206f6e20616e7920757365722c20656c7365207765206d61792077616e7420666163746f7220696e206e756d626572206f66206c6f636b732e302023203c2f7765696768743e28766573745f6f7468657204187461726765748c3c543a3a4c6f6f6b7570206173205374617469634c6f6f6b75703e3a3a536f757263654cbc20556e6c6f636b20616e79207665737465642066756e6473206f662061206074617267657460206163636f756e742e00d020546865206469737061746368206f726967696e20666f7220746869732063616c6c206d757374206265205f5369676e65645f2e005501202d2060746172676574603a20546865206163636f756e742077686f7365207665737465642066756e64732073686f756c6420626520756e6c6f636b65642e204d75737420686176652066756e6473207374696c6c68206c6f636b656420756e6465722074686973206d6f64756c652e00d420456d69747320656974686572206056657374696e67436f6d706c6574656460206f72206056657374696e6755706461746564602e002c2023203c7765696768743e28202d20604f283129602e78202d2044625765696768743a20332052656164732c203320577269746573f420202020202d2052656164733a2056657374696e672053746f726167652c2042616c616e636573204c6f636b732c20546172676574204163636f756e74f820202020202d205772697465733a2056657374696e672053746f726167652c2042616c616e636573204c6f636b732c20546172676574204163636f756e7434202d2042656e63686d61726b3ae820202020202d20556e6c6f636b65643a2034342e33202b202e323934202a206c20c2b57320286d696e2073717561726520616e616c7973697329e420202020202d204c6f636b65643a2034382e3136202b202e313033202a206c20c2b57320286d696e2073717561726520616e616c7973697329ad01202d205573696e6720353020c2b5732066697865642e20417373756d696e67206c657373207468616e203530206c6f636b73206f6e20616e7920757365722c20656c7365207765206d61792077616e7420666163746f7220696e206e756d626572206f66206c6f636b732e302023203c2f7765696768743e3c7665737465645f7472616e7366657208187461726765748c3c543a3a4c6f6f6b7570206173205374617469634c6f6f6b75703e3a3a536f75726365207363686564756c65a456657374696e67496e666f3c42616c616e63654f663c543e2c20543a3a426c6f636b4e756d6265723e486820437265617465206120766573746564207472616e736665722e00d020546865206469737061746368206f726967696e20666f7220746869732063616c6c206d757374206265205f5369676e65645f2e001501202d2060746172676574603a20546865206163636f756e7420746861742073686f756c64206265207472616e7366657272656420746865207665737465642066756e64732e0101202d2060616d6f756e74603a2054686520616d6f756e74206f662066756e647320746f207472616e7366657220616e642077696c6c206265207665737465642ef4202d20607363686564756c65603a205468652076657374696e67207363686564756c6520617474616368656420746f20746865207472616e736665722e006020456d697473206056657374696e6743726561746564602e002c2023203c7765696768743e28202d20604f283129602e78202d2044625765696768743a20332052656164732c2033205772697465733d0120202020202d2052656164733a2056657374696e672053746f726167652c2042616c616e636573204c6f636b732c20546172676574204163636f756e742c205b53656e646572204163636f756e745d410120202020202d205772697465733a2056657374696e672053746f726167652c2042616c616e636573204c6f636b732c20546172676574204163636f756e742c205b53656e646572204163636f756e745de0202d2042656e63686d61726b3a203130302e33202b202e333635202a206c20c2b57320286d696e2073717561726520616e616c7973697329b101202d205573696e672031303020c2b5732066697865642e20417373756d696e67206c657373207468616e203530206c6f636b73206f6e20616e7920757365722c20656c7365207765206d61792077616e7420666163746f7220696e206e756d626572206f66206c6f636b732e302023203c2f7765696768743e54666f7263655f7665737465645f7472616e736665720c18736f757263658c3c543a3a4c6f6f6b7570206173205374617469634c6f6f6b75703e3a3a536f75726365187461726765748c3c543a3a4c6f6f6b7570206173205374617469634c6f6f6b75703e3a3a536f75726365207363686564756c65a456657374696e67496e666f3c42616c616e63654f663c543e2c20543a3a426c6f636b4e756d6265723e4c6420466f726365206120766573746564207472616e736665722e00c820546865206469737061746368206f726967696e20666f7220746869732063616c6c206d757374206265205f526f6f745f2e00ec202d2060736f75726365603a20546865206163636f756e742077686f73652066756e64732073686f756c64206265207472616e736665727265642e1501202d2060746172676574603a20546865206163636f756e7420746861742073686f756c64206265207472616e7366657272656420746865207665737465642066756e64732e0101202d2060616d6f756e74603a2054686520616d6f756e74206f662066756e647320746f207472616e7366657220616e642077696c6c206265207665737465642ef4202d20607363686564756c65603a205468652076657374696e67207363686564756c6520617474616368656420746f20746865207472616e736665722e006020456d697473206056657374696e6743726561746564602e002c2023203c7765696768743e28202d20604f283129602e78202d2044625765696768743a20342052656164732c203420577269746573350120202020202d2052656164733a2056657374696e672053746f726167652c2042616c616e636573204c6f636b732c20546172676574204163636f756e742c20536f75726365204163636f756e74390120202020202d205772697465733a2056657374696e672053746f726167652c2042616c616e636573204c6f636b732c20546172676574204163636f756e742c20536f75726365204163636f756e74e0202d2042656e63686d61726b3a203130302e33202b202e333635202a206c20c2b57320286d696e2073717561726520616e616c7973697329b101202d205573696e672031303020c2b5732066697865642e20417373756d696e67206c657373207468616e203530206c6f636b73206f6e20616e7920757365722c20656c7365207765206d61792077616e7420666163746f7220696e206e756d626572206f66206c6f636b732e302023203c2f7765696768743e01083856657374696e675570646174656408244163636f756e7449641c42616c616e63650859012054686520616d6f756e742076657374656420686173206265656e20757064617465642e205468697320636f756c6420696e646963617465206d6f72652066756e64732061726520617661696c61626c652e2054686519012062616c616e636520676976656e2069732074686520616d6f756e74207768696368206973206c65667420756e7665737465642028616e642074687573206c6f636b6564292e4056657374696e67436f6d706c6574656404244163636f756e744964042d0120416e206163636f756e742028676976656e2920686173206265636f6d652066756c6c79207665737465642e204e6f20667572746865722076657374696e672063616e2068617070656e2e04444d696e5665737465645472616e736665723042616c616e63654f663c543e400000c16ff28623000000000000000000041d0120546865206d696e696d756d20616d6f756e7420746f206265207472616e7366657272656420746f206372656174652061206e65772076657374696e67207363686564756c652e0c284e6f7456657374696e67048820546865206163636f756e7420676976656e206973206e6f742076657374696e672e5c4578697374696e6756657374696e675363686564756c65045d0120416e206578697374696e672076657374696e67207363686564756c6520616c72656164792065786973747320666f722074686973206163636f756e7420746861742063616e6e6f7420626520636c6f6262657265642e24416d6f756e744c6f7704090120416d6f756e74206265696e67207472616e7366657272656420697320746f6f206c6f7720746f2063726561746520612076657374696e67207363686564756c652e245363686564756c657201245363686564756c657208184167656e646101010538543a3a426c6f636b4e756d626572e85665633c4f7074696f6e3c5363686564756c65643c3c542061732054726169743e3a3a43616c6c2c20543a3a426c6f636b4e756d6265723e3e3e000400044d01204974656d7320746f2062652065786563757465642c20696e64657865642062792074686520626c6f636b206e756d626572207468617420746865792073686f756c64206265206578656375746564206f6e2e184c6f6f6b75700001051c5665633c75383e6c5461736b416464726573733c543a3a426c6f636b4e756d6265723e000400040101204c6f6f6b75702066726f6d206964656e7469747920746f2074686520626c6f636b206e756d62657220616e6420696e646578206f6620746865207461736b2e0110207363686564756c6510107768656e38543a3a426c6f636b4e756d626572386d617962655f706572696f646963a04f7074696f6e3c7363686564756c653a3a506572696f643c543a3a426c6f636b4e756d6265723e3e207072696f72697479487363686564756c653a3a5072696f726974791063616c6c5c426f783c3c542061732054726169743e3a3a43616c6c3e287420416e6f6e796d6f75736c79207363686564756c652061207461736b2e002c2023203c7765696768743ea0202d2053203d204e756d626572206f6620616c7265616479207363686564756c65642063616c6c7390202d2042617365205765696768743a2032322e3239202b202e313236202a205320c2b57334202d204442205765696768743a4c20202020202d20526561643a204167656e64615020202020202d2057726974653a204167656e64613d01202d2057696c6c20757365206261736520776569676874206f662032352077686963682073686f756c6420626520676f6f6420666f7220757020746f203330207363686564756c65642063616c6c73302023203c2f7765696768743e1863616e63656c08107768656e38543a3a426c6f636b4e756d62657214696e6465780c75333228982043616e63656c20616e20616e6f6e796d6f75736c79207363686564756c6564207461736b2e002c2023203c7765696768743ea0202d2053203d204e756d626572206f6620616c7265616479207363686564756c65642063616c6c7394202d2042617365205765696768743a2032322e3135202b20322e383639202a205320c2b57334202d204442205765696768743a4c20202020202d20526561643a204167656e64617020202020202d2057726974653a204167656e64612c204c6f6f6b75704101202d2057696c6c20757365206261736520776569676874206f66203130302077686963682073686f756c6420626520676f6f6420666f7220757020746f203330207363686564756c65642063616c6c73302023203c2f7765696768743e387363686564756c655f6e616d6564140869641c5665633c75383e107768656e38543a3a426c6f636b4e756d626572386d617962655f706572696f646963a04f7074696f6e3c7363686564756c653a3a506572696f643c543a3a426c6f636b4e756d6265723e3e207072696f72697479487363686564756c653a3a5072696f726974791063616c6c5c426f783c3c542061732054726169743e3a3a43616c6c3e285c205363686564756c652061206e616d6564207461736b2e002c2023203c7765696768743ea0202d2053203d204e756d626572206f6620616c7265616479207363686564756c65642063616c6c738c202d2042617365205765696768743a2032392e36202b202e313539202a205320c2b57334202d204442205765696768743a6c20202020202d20526561643a204167656e64612c204c6f6f6b75707020202020202d2057726974653a204167656e64612c204c6f6f6b75704d01202d2057696c6c20757365206261736520776569676874206f662033352077686963682073686f756c6420626520676f6f6420666f72206d6f7265207468616e203330207363686564756c65642063616c6c73302023203c2f7765696768743e3063616e63656c5f6e616d6564040869641c5665633c75383e287c2043616e63656c2061206e616d6564207363686564756c6564207461736b2e002c2023203c7765696768743ea0202d2053203d204e756d626572206f6620616c7265616479207363686564756c65642063616c6c7394202d2042617365205765696768743a2032342e3931202b20322e393037202a205320c2b57334202d204442205765696768743a6c20202020202d20526561643a204167656e64612c204c6f6f6b75707020202020202d2057726974653a204167656e64612c204c6f6f6b75704101202d2057696c6c20757365206261736520776569676874206f66203130302077686963682073686f756c6420626520676f6f6420666f7220757020746f203330207363686564756c65642063616c6c73302023203c2f7765696768743e010c245363686564756c6564082c426c6f636b4e756d6265720c753332002043616e63656c6564082c426c6f636b4e756d6265720c7533320028446973706174636865640c605461736b416464726573733c426c6f636b4e756d6265723e3c4f7074696f6e3c5665633c75383e3e384469737061746368526573756c740000001450726f7879011450726f7879041c50726f7869657301010530543a3a4163636f756e744964c4285665633c28543a3a4163636f756e7449642c20543a3a50726f787954797065293e2c2042616c616e63654f663c543e29004400000000000000000000000000000000000845012054686520736574206f66206163636f756e742070726f786965732e204d61707320746865206163636f756e74207768696368206861732064656c65676174656420746f20746865206163636f756e7473210120776869636820617265206265696e672064656c65676174656420746f2c20746f67657468657220776974682074686520616d6f756e742068656c64206f6e206465706f7369742e01181470726f78790c107265616c30543a3a4163636f756e74496440666f7263655f70726f78795f74797065504f7074696f6e3c543a3a50726f7879547970653e1063616c6c5c426f783c3c542061732054726169743e3a3a43616c6c3e4051012044697370617463682074686520676976656e206063616c6c602066726f6d20616e206163636f756e742074686174207468652073656e64657220697320617574686f726973656420666f72207468726f7567683420606164645f70726f7879602e00d020546865206469737061746368206f726967696e20666f7220746869732063616c6c206d757374206265205f5369676e65645f2e003020506172616d65746572733a1101202d20607265616c603a20546865206163636f756e742074686174207468652070726f78792077696c6c206d616b6520612063616c6c206f6e20626568616c66206f662e6501202d2060666f7263655f70726f78795f74797065603a2053706563696679207468652065786163742070726f7879207479706520746f206265207573656420616e6420636865636b656420666f7220746869732063616c6c2ed4202d206063616c6c603a205468652063616c6c20746f206265206d6164652062792074686520607265616c60206163636f756e742e002c2023203c7765696768743ea0205020697320746865206e756d626572206f662070726f786965732074686520757365722068617390202d2042617365207765696768743a2031392e3837202b202e313431202a205020c2b57374202d204442207765696768743a20312073746f7261676520726561642e80202d20506c75732074686520776569676874206f6620746865206063616c6c60302023203c2f7765696768743e246164645f70726f7879081470726f787930543a3a4163636f756e7449642870726f78795f7479706530543a3a50726f78795479706534490120526567697374657220612070726f7879206163636f756e7420666f72207468652073656e64657220746861742069732061626c6520746f206d616b652063616c6c73206f6e2069747320626568616c662e00d020546865206469737061746368206f726967696e20666f7220746869732063616c6c206d757374206265205f5369676e65645f2e003020506172616d65746572733a1501202d206070726f7879603a20546865206163636f756e74207468617420746865206063616c6c65726020776f756c64206c696b6520746f206d616b6520612070726f78792e0101202d206070726f78795f74797065603a20546865207065726d697373696f6e7320616c6c6f77656420666f7220746869732070726f7879206163636f756e742e002c2023203c7765696768743ea0205020697320746865206e756d626572206f662070726f786965732074686520757365722068617390202d2042617365207765696768743a2031372e3438202b202e313736202a205020c2b5739c202d204442207765696768743a20312073746f72616765207265616420616e642077726974652e302023203c2f7765696768743e3072656d6f76655f70726f7879081470726f787930543a3a4163636f756e7449642870726f78795f7479706530543a3a50726f78795479706534ac20556e726567697374657220612070726f7879206163636f756e7420666f72207468652073656e6465722e00d020546865206469737061746368206f726967696e20666f7220746869732063616c6c206d757374206265205f5369676e65645f2e003020506172616d65746572733a2901202d206070726f7879603a20546865206163636f756e74207468617420746865206063616c6c65726020776f756c64206c696b6520746f2072656d6f766520617320612070726f78792e4501202d206070726f78795f74797065603a20546865207065726d697373696f6e732063757272656e746c7920656e61626c656420666f72207468652072656d6f7665642070726f7879206163636f756e742e002c2023203c7765696768743ea0205020697320746865206e756d626572206f662070726f786965732074686520757365722068617390202d2042617365207765696768743a2031342e3337202b202e313634202a205020c2b5739c202d204442207765696768743a20312073746f72616765207265616420616e642077726974652e302023203c2f7765696768743e3872656d6f76655f70726f786965730030b820556e726567697374657220616c6c2070726f7879206163636f756e747320666f72207468652073656e6465722e00d020546865206469737061746368206f726967696e20666f7220746869732063616c6c206d757374206265205f5369676e65645f2e005901205741524e494e473a2054686973206d61792062652063616c6c6564206f6e206163636f756e747320637265617465642062792060616e6f6e796d6f7573602c20686f776576657220696620646f6e652c207468656e5d012074686520756e726573657276656420666565732077696c6c20626520696e61636365737369626c652e202a2a416c6c2061636365737320746f2074686973206163636f756e742077696c6c206265206c6f73742e2a2a002c2023203c7765696768743ea0205020697320746865206e756d626572206f662070726f786965732074686520757365722068617390202d2042617365207765696768743a2031332e3733202b202e313239202a205020c2b5739c202d204442207765696768743a20312073746f72616765207265616420616e642077726974652e302023203c2f7765696768743e24616e6f6e796d6f7573082870726f78795f7479706530543a3a50726f78795479706514696e6465780c753136583d0120537061776e2061206672657368206e6577206163636f756e7420746861742069732067756172616e7465656420746f206265206f746865727769736520696e61636365737369626c652c20616e64010120696e697469616c697a65206974207769746820612070726f7879206f66206070726f78795f747970656020666f7220606f726967696e602073656e6465722e0070205265717569726573206120605369676e656460206f726967696e2e005501202d206070726f78795f74797065603a205468652074797065206f66207468652070726f78792074686174207468652073656e6465722077696c6c2062652072656769737465726564206173206f766572207468655101206e6577206163636f756e742e20546869732077696c6c20616c6d6f737420616c7761797320626520746865206d6f7374207065726d697373697665206050726f7879547970656020706f737369626c6520746f7c20616c6c6f7720666f72206d6178696d756d20666c65786962696c6974792e5501202d2060696e646578603a204120646973616d626967756174696f6e20696e6465782c20696e206361736520746869732069732063616c6c6564206d756c7469706c652074696d657320696e207468652073616d656101207472616e73616374696f6e2028652e672e207769746820607574696c6974793a3a626174636860292e20556e6c65737320796f75277265207573696e67206062617463686020796f752070726f6261626c79206a757374442077616e7420746f20757365206030602e005501204661696c73207769746820604475706c69636174656020696620746869732068617320616c7265616479206265656e2063616c6c656420696e2074686973207472616e73616374696f6e2c2066726f6d207468659c2073616d652073656e6465722c2077697468207468652073616d6520706172616d65746572732e00e8204661696c732069662074686572652061726520696e73756666696369656e742066756e647320746f2070617920666f72206465706f7369742e002c2023203c7765696768743ea0205020697320746865206e756d626572206f662070726f786965732074686520757365722068617390202d2042617365207765696768743a2033362e3438202b202e303339202a205020c2b5739c202d204442207765696768743a20312073746f72616765207265616420616e642077726974652e302023203c2f7765696768743e386b696c6c5f616e6f6e796d6f7573141c737061776e657230543a3a4163636f756e7449642870726f78795f7479706530543a3a50726f78795479706514696e6465780c753136186865696768745c436f6d706163743c543a3a426c6f636b4e756d6265723e246578745f696e64657830436f6d706163743c7533323e58b82052656d6f76657320612070726576696f75736c7920737061776e656420616e6f6e796d6f75732070726f78792e004d01205741524e494e473a202a2a416c6c2061636365737320746f2074686973206163636f756e742077696c6c206265206c6f73742e2a2a20416e792066756e64732068656c6420696e2069742077696c6c2062653820696e61636365737369626c652e005d01205265717569726573206120605369676e656460206f726967696e2c20616e64207468652073656e646572206163636f756e74206d7573742068617665206265656e206372656174656420627920612063616c6c20746fac2060616e6f6e796d6f757360207769746820636f72726573706f6e64696e6720706172616d65746572732e005101202d2060737061776e6572603a20546865206163636f756e742074686174206f726967696e616c6c792063616c6c65642060616e6f6e796d6f75736020746f206372656174652074686973206163636f756e742e5101202d2060696e646578603a2054686520646973616d626967756174696f6e20696e646578206f726967696e616c6c792070617373656420746f2060616e6f6e796d6f7573602e2050726f6261626c79206030602e0501202d206070726f78795f74797065603a205468652070726f78792074797065206f726967696e616c6c792070617373656420746f2060616e6f6e796d6f7573602e4101202d2060686569676874603a2054686520686569676874206f662074686520636861696e207768656e207468652063616c6c20746f2060616e6f6e796d6f757360207761732070726f6365737365642e4d01202d20606578745f696e646578603a205468652065787472696e73696320696e64657820696e207768696368207468652063616c6c20746f2060616e6f6e796d6f757360207761732070726f6365737365642e004d01204661696c73207769746820604e6f5065726d697373696f6e6020696e2063617365207468652063616c6c6572206973206e6f7420612070726576696f75736c79206372656174656420616e6f6e796d6f7573f4206163636f756e742077686f73652060616e6f6e796d6f7573602063616c6c2068617320636f72726573706f6e64696e6720706172616d65746572732e002c2023203c7765696768743ea0205020697320746865206e756d626572206f662070726f786965732074686520757365722068617390202d2042617365207765696768743a2031352e3635202b202e313337202a205020c2b5739c202d204442207765696768743a20312073746f72616765207265616420616e642077726974652e302023203c2f7765696768743e01083450726f7879457865637574656404384469737061746368526573756c7404dc20412070726f78792077617320657865637574656420636f72726563746c792c20776974682074686520676976656e20726573756c742e40416e6f6e796d6f75734372656174656410244163636f756e744964244163636f756e7449642450726f7879547970650c75313608590120416e6f6e796d6f7573206163636f756e742028666972737420706172616d657465722920686173206265656e2063726561746564206279206e65772070726f787920287365636f6e6429207769746820676976656e9420646973616d626967756174696f6e20696e64657820616e642070726f787920747970652e0c4050726f78794465706f736974426173653042616c616e63654f663c543e4000f09e544c390000000000000000000004110120546865206261736520616d6f756e74206f662063757272656e6379206e656564656420746f207265736572766520666f72206372656174696e6720612070726f78792e4850726f78794465706f736974466163746f723042616c616e63654f663c543e400060aa7714b40000000000000000000004bc2054686520616d6f756e74206f662063757272656e6379206e6565646564207065722070726f78792061646465642e284d617850726f786965730c75313608200004f020546865206d6178696d756d20616d6f756e74206f662070726f7869657320616c6c6f77656420666f7220612073696e676c65206163636f756e742e181c546f6f4d616e79049c2054686572652061726520746f6f206d616e792070726f7869657320726567697374657265642e204e6f74466f756e6404782050726f787920726567697374726174696f6e206e6f7420666f756e642e204e6f7450726f787904d02053656e646572206973206e6f7420612070726f7879206f6620746865206163636f756e7420746f2062652070726f786965642e2c556e70726f787961626c6504250120412063616c6c20776869636820697320696e636f6d70617469626c652077697468207468652070726f7879207479706527732066696c7465722077617320617474656d707465642e244475706c69636174650470204163636f756e7420697320616c726561647920612070726f78792e304e6f5065726d697373696f6e0419012043616c6c206d6179206e6f74206265206d6164652062792070726f78792062656361757365206974206d617920657363616c617465206974732070726976696c656765732e204d756c746973696701204d756c746973696708244d756c74697369677300020530543a3a4163636f756e744964205b75383b2033325dd04d756c74697369673c543a3a426c6f636b4e756d6265722c2042616c616e63654f663c543e2c20543a3a4163636f756e7449643e02040004942054686520736574206f66206f70656e206d756c7469736967206f7065726174696f6e732e1443616c6c73000106205b75383b2033325d94285665633c75383e2c20543a3a4163636f756e7449642c2042616c616e63654f663c543e290004000001105061735f6d756c74695f7468726573686f6c645f3108446f746865725f7369676e61746f72696573445665633c543a3a4163636f756e7449643e1063616c6c5c426f783c3c542061732054726169743e3a3a43616c6c3e44550120496d6d6564696174656c792064697370617463682061206d756c74692d7369676e61747572652063616c6c207573696e6720612073696e676c6520617070726f76616c2066726f6d207468652063616c6c65722e00d020546865206469737061746368206f726967696e20666f7220746869732063616c6c206d757374206265205f5369676e65645f2e004101202d20606f746865725f7369676e61746f72696573603a20546865206163636f756e747320286f74686572207468616e207468652073656e646572292077686f206172652070617274206f66207468650501206d756c74692d7369676e61747572652c2062757420646f206e6f7420706172746963697061746520696e2074686520617070726f76616c2070726f636573732e8c202d206063616c6c603a205468652063616c6c20746f2062652065786563757465642e00bc20526573756c74206973206571756976616c656e7420746f20746865206469737061746368656420726573756c742e002c2023203c7765696768743e1d01204f285a202b204329207768657265205a20697320746865206c656e677468206f66207468652063616c6c20616e6420432069747320657865637574696f6e207765696768742e80202d2d2d2d2d2d2d2d2d2d2d2d2d2d2d2d2d2d2d2d2d2d2d2d2d2d2d2d2d2d2d94202d2042617365205765696768743a2033332e3732202b20302e303032202a205a20c2b57348202d204442205765696768743a204e6f6e654c202d20506c75732043616c6c20576569676874302023203c2f7765696768743e2061735f6d756c746918247468726573686f6c640c753136446f746865725f7369676e61746f72696573445665633c543a3a4163636f756e7449643e3c6d617962655f74696d65706f696e74844f7074696f6e3c54696d65706f696e743c543a3a426c6f636b4e756d6265723e3e1063616c6c1c5665633c75383e2873746f72655f63616c6c10626f6f6c286d61785f77656967687418576569676874cc590120526567697374657220617070726f76616c20666f72206120646973706174636820746f206265206d6164652066726f6d20612064657465726d696e697374696320636f6d706f73697465206163636f756e74206966fc20617070726f766564206279206120746f74616c206f6620607468726573686f6c64202d203160206f6620606f746865725f7369676e61746f72696573602e00b42049662074686572652061726520656e6f7567682c207468656e206469737061746368207468652063616c6c2e003101205061796d656e743a20604465706f73697442617365602077696c6c20626520726573657276656420696620746869732069732074686520666972737420617070726f76616c2c20706c7573410120607468726573686f6c64602074696d657320604465706f736974466163746f72602e2049742069732072657475726e6564206f6e636520746869732064697370617463682068617070656e73206f72382069732063616e63656c6c65642e00d020546865206469737061746368206f726967696e20666f7220746869732063616c6c206d757374206265205f5369676e65645f2e005901202d20607468726573686f6c64603a2054686520746f74616c206e756d626572206f6620617070726f76616c7320666f722074686973206469737061746368206265666f72652069742069732065786563757465642e4501202d20606f746865725f7369676e61746f72696573603a20546865206163636f756e747320286f74686572207468616e207468652073656e646572292077686f2063616e20617070726f76652074686973702064697370617463682e204d6179206e6f7420626520656d7074792e5d01202d20606d617962655f74696d65706f696e74603a20496620746869732069732074686520666972737420617070726f76616c2c207468656e2074686973206d75737420626520604e6f6e65602e2049662069742069735501206e6f742074686520666972737420617070726f76616c2c207468656e206974206d7573742062652060536f6d65602c2077697468207468652074696d65706f696e742028626c6f636b206e756d62657220616e64d8207472616e73616374696f6e20696e64657829206f662074686520666972737420617070726f76616c207472616e73616374696f6e2e8c202d206063616c6c603a205468652063616c6c20746f2062652065786563757465642e002101204e4f54453a20556e6c6573732074686973206973207468652066696e616c20617070726f76616c2c20796f752077696c6c2067656e6572616c6c792077616e7420746f207573651d012060617070726f76655f61735f6d756c74696020696e73746561642c2073696e6365206974206f6e6c7920726571756972657320612068617368206f66207468652063616c6c2e005d0120526573756c74206973206571756976616c656e7420746f20746865206469737061746368656420726573756c7420696620607468726573686f6c64602069732065786163746c79206031602e204f74686572776973655901206f6e20737563636573732c20726573756c7420697320604f6b6020616e642074686520726573756c742066726f6d2074686520696e746572696f722063616c6c2c206966206974207761732065786563757465642ce0206d617920626520666f756e6420696e20746865206465706f736974656420604d756c7469736967457865637574656460206576656e742e002c2023203c7765696768743e54202d20604f2853202b205a202b2043616c6c29602ed0202d20557020746f206f6e652062616c616e63652d72657365727665206f7220756e72657365727665206f7065726174696f6e2e4101202d204f6e6520706173737468726f756768206f7065726174696f6e2c206f6e6520696e736572742c20626f746820604f285329602077686572652060536020697320746865206e756d626572206f6649012020207369676e61746f726965732e206053602069732063617070656420627920604d61785369676e61746f72696573602c207769746820776569676874206265696e672070726f706f7274696f6e616c2e2501202d204f6e652063616c6c20656e636f6465202620686173682c20626f7468206f6620636f6d706c657869747920604f285a296020776865726520605a602069732074782d6c656e2ec0202d204f6e6520656e636f6465202620686173682c20626f7468206f6620636f6d706c657869747920604f285329602ed8202d20557020746f206f6e652062696e6172792073656172636820616e6420696e736572742028604f286c6f6753202b20532960292efc202d20492f4f3a2031207265616420604f285329602c20757020746f2031206d757461746520604f285329602e20557020746f206f6e652072656d6f76652e34202d204f6e65206576656e742e70202d2054686520776569676874206f6620746865206063616c6c602e3101202d2053746f726167653a20696e7365727473206f6e65206974656d2c2076616c75652073697a6520626f756e64656420627920604d61785369676e61746f72696573602c20776974682061902020206465706f7369742074616b656e20666f7220697473206c69666574696d65206f66b4202020604465706f73697442617365202b207468726573686f6c64202a204465706f736974466163746f72602e80202d2d2d2d2d2d2d2d2d2d2d2d2d2d2d2d2d2d2d2d2d2d2d2d2d2d2d2d2d2d2d3c202d2042617365205765696768743ae020202020202d204372656174653a2020202020202020202034312e3839202b20302e313138202a2053202b202e303032202a205a20c2b573e020202020202d2043726561746520772f2053746f72653a2035332e3537202b20302e313139202a2053202b202e303033202a205a20c2b573e020202020202d20417070726f76653a20202020202020202033312e3339202b20302e313336202a2053202b202e303032202a205a20c2b573e020202020202d20436f6d706c6574653a202020202020202033392e3934202b20302e323620202a2053202b202e303032202a205a20c2b57334202d204442205765696768743a250120202020202d2052656164733a204d756c74697369672053746f726167652c205b43616c6c6572204163636f756e745d2c2043616c6c7320286966206073746f72655f63616c6c6029290120202020202d205772697465733a204d756c74697369672053746f726167652c205b43616c6c6572204163636f756e745d2c2043616c6c7320286966206073746f72655f63616c6c60294c202d20506c75732043616c6c20576569676874302023203c2f7765696768743e40617070726f76655f61735f6d756c746914247468726573686f6c640c753136446f746865725f7369676e61746f72696573445665633c543a3a4163636f756e7449643e3c6d617962655f74696d65706f696e74844f7074696f6e3c54696d65706f696e743c543a3a426c6f636b4e756d6265723e3e2463616c6c5f68617368205b75383b2033325d286d61785f776569676874185765696768749c590120526567697374657220617070726f76616c20666f72206120646973706174636820746f206265206d6164652066726f6d20612064657465726d696e697374696320636f6d706f73697465206163636f756e74206966fc20617070726f766564206279206120746f74616c206f6620607468726573686f6c64202d203160206f6620606f746865725f7369676e61746f72696573602e003101205061796d656e743a20604465706f73697442617365602077696c6c20626520726573657276656420696620746869732069732074686520666972737420617070726f76616c2c20706c7573410120607468726573686f6c64602074696d657320604465706f736974466163746f72602e2049742069732072657475726e6564206f6e636520746869732064697370617463682068617070656e73206f72382069732063616e63656c6c65642e00d020546865206469737061746368206f726967696e20666f7220746869732063616c6c206d757374206265205f5369676e65645f2e005901202d20607468726573686f6c64603a2054686520746f74616c206e756d626572206f6620617070726f76616c7320666f722074686973206469737061746368206265666f72652069742069732065786563757465642e4501202d20606f746865725f7369676e61746f72696573603a20546865206163636f756e747320286f74686572207468616e207468652073656e646572292077686f2063616e20617070726f76652074686973702064697370617463682e204d6179206e6f7420626520656d7074792e5d01202d20606d617962655f74696d65706f696e74603a20496620746869732069732074686520666972737420617070726f76616c2c207468656e2074686973206d75737420626520604e6f6e65602e2049662069742069735501206e6f742074686520666972737420617070726f76616c2c207468656e206974206d7573742062652060536f6d65602c2077697468207468652074696d65706f696e742028626c6f636b206e756d62657220616e64d8207472616e73616374696f6e20696e64657829206f662074686520666972737420617070726f76616c207472616e73616374696f6e2ed0202d206063616c6c5f68617368603a205468652068617368206f66207468652063616c6c20746f2062652065786563757465642e003901204e4f54453a2049662074686973206973207468652066696e616c20617070726f76616c2c20796f752077696c6c2077616e7420746f20757365206061735f6d756c74696020696e73746561642e002c2023203c7765696768743e28202d20604f285329602ed0202d20557020746f206f6e652062616c616e63652d72657365727665206f7220756e72657365727665206f7065726174696f6e2e4101202d204f6e6520706173737468726f756768206f7065726174696f6e2c206f6e6520696e736572742c20626f746820604f285329602077686572652060536020697320746865206e756d626572206f6649012020207369676e61746f726965732e206053602069732063617070656420627920604d61785369676e61746f72696573602c207769746820776569676874206265696e672070726f706f7274696f6e616c2ec0202d204f6e6520656e636f6465202620686173682c20626f7468206f6620636f6d706c657869747920604f285329602ed8202d20557020746f206f6e652062696e6172792073656172636820616e6420696e736572742028604f286c6f6753202b20532960292efc202d20492f4f3a2031207265616420604f285329602c20757020746f2031206d757461746520604f285329602e20557020746f206f6e652072656d6f76652e34202d204f6e65206576656e742e3101202d2053746f726167653a20696e7365727473206f6e65206974656d2c2076616c75652073697a6520626f756e64656420627920604d61785369676e61746f72696573602c20776974682061902020206465706f7369742074616b656e20666f7220697473206c69666574696d65206f66b4202020604465706f73697442617365202b207468726573686f6c64202a204465706f736974466163746f72602e8c202d2d2d2d2d2d2d2d2d2d2d2d2d2d2d2d2d2d2d2d2d2d2d2d2d2d2d2d2d2d2d2d2d2d3c202d2042617365205765696768743a8020202020202d204372656174653a2034342e3731202b20302e303838202a20538420202020202d20417070726f76653a2033312e3438202b20302e313136202a205334202d204442205765696768743abc20202020202d20526561643a204d756c74697369672053746f726167652c205b43616c6c6572204163636f756e745dc020202020202d2057726974653a204d756c74697369672053746f726167652c205b43616c6c6572204163636f756e745d302023203c2f7765696768743e3c63616e63656c5f61735f6d756c746910247468726573686f6c640c753136446f746865725f7369676e61746f72696573445665633c543a3a4163636f756e7449643e2474696d65706f696e746454696d65706f696e743c543a3a426c6f636b4e756d6265723e2463616c6c5f68617368205b75383b2033325d6c59012043616e63656c2061207072652d6578697374696e672c206f6e2d676f696e67206d756c7469736967207472616e73616374696f6e2e20416e79206465706f7369742072657365727665642070726576696f75736c79c820666f722074686973206f7065726174696f6e2077696c6c20626520756e7265736572766564206f6e20737563636573732e00d020546865206469737061746368206f726967696e20666f7220746869732063616c6c206d757374206265205f5369676e65645f2e005901202d20607468726573686f6c64603a2054686520746f74616c206e756d626572206f6620617070726f76616c7320666f722074686973206469737061746368206265666f72652069742069732065786563757465642e4501202d20606f746865725f7369676e61746f72696573603a20546865206163636f756e747320286f74686572207468616e207468652073656e646572292077686f2063616e20617070726f76652074686973702064697370617463682e204d6179206e6f7420626520656d7074792e6101202d206074696d65706f696e74603a205468652074696d65706f696e742028626c6f636b206e756d62657220616e64207472616e73616374696f6e20696e64657829206f662074686520666972737420617070726f76616c7c207472616e73616374696f6e20666f7220746869732064697370617463682ed0202d206063616c6c5f68617368603a205468652068617368206f66207468652063616c6c20746f2062652065786563757465642e002c2023203c7765696768743e28202d20604f285329602ed0202d20557020746f206f6e652062616c616e63652d72657365727665206f7220756e72657365727665206f7065726174696f6e2e4101202d204f6e6520706173737468726f756768206f7065726174696f6e2c206f6e6520696e736572742c20626f746820604f285329602077686572652060536020697320746865206e756d626572206f6649012020207369676e61746f726965732e206053602069732063617070656420627920604d61785369676e61746f72696573602c207769746820776569676874206265696e672070726f706f7274696f6e616c2ec0202d204f6e6520656e636f6465202620686173682c20626f7468206f6620636f6d706c657869747920604f285329602e34202d204f6e65206576656e742e88202d20492f4f3a2031207265616420604f285329602c206f6e652072656d6f76652e74202d2053746f726167653a2072656d6f766573206f6e65206974656d2e8c202d2d2d2d2d2d2d2d2d2d2d2d2d2d2d2d2d2d2d2d2d2d2d2d2d2d2d2d2d2d2d2d2d2d84202d2042617365205765696768743a2033362e3037202b20302e313234202a205334202d204442205765696768743a190120202020202d20526561643a204d756c74697369672053746f726167652c205b43616c6c6572204163636f756e745d2c20526566756e64204163636f756e742c2043616c6c731d0120202020202d2057726974653a204d756c74697369672053746f726167652c205b43616c6c6572204163636f756e745d2c20526566756e64204163636f756e742c2043616c6c73302023203c2f7765696768743e01102c4e65774d756c74697369670c244163636f756e744964244163636f756e7449642043616c6c486173680849012041206e6577206d756c7469736967206f7065726174696f6e2068617320626567756e2e20466972737420706172616d20697320746865206163636f756e74207468617420697320617070726f76696e672cec207365636f6e6420697320746865206d756c7469736967206163636f756e742c2074686972642069732068617368206f66207468652063616c6c2e404d756c7469736967417070726f76616c10244163636f756e7449645854696d65706f696e743c426c6f636b4e756d6265723e244163636f756e7449642043616c6c486173680859012041206d756c7469736967206f7065726174696f6e20686173206265656e20617070726f76656420627920736f6d656f6e652e20466972737420706172616d20697320746865206163636f756e742074686174206973190120617070726f76696e672c20746869726420697320746865206d756c7469736967206163636f756e742c20666f757274682069732068617368206f66207468652063616c6c2e404d756c7469736967457865637574656414244163636f756e7449645854696d65706f696e743c426c6f636b4e756d6265723e244163636f756e7449642043616c6c48617368384469737061746368526573756c74082d012041206d756c7469736967206f7065726174696f6e20686173206265656e2065786563757465642e20466972737420706172616d20697320746865206163636f756e742074686174206973550120617070726f76696e672c20746869726420697320746865206d756c7469736967206163636f756e742c20666f757274682069732068617368206f66207468652063616c6c20746f2062652065786563757465642e444d756c746973696743616e63656c6c656410244163636f756e7449645854696d65706f696e743c426c6f636b4e756d6265723e244163636f756e7449642043616c6c486173680831012041206d756c7469736967206f7065726174696f6e20686173206265656e2063616e63656c6c65642e20466972737420706172616d20697320746865206163636f756e7420746861742069731d012063616e63656c6c696e672c20746869726420697320746865206d756c7469736967206163636f756e742c20666f757274682069732068617368206f66207468652063616c6c2e0038404d696e696d756d5468726573686f6c640480205468726573686f6c64206d7573742062652032206f7220677265617465722e3c416c7265616479417070726f76656404b02043616c6c20697320616c726561647920617070726f7665642062792074686973207369676e61746f72792e444e6f417070726f76616c734e656564656404a02043616c6c20646f65736e2774206e65656420616e7920286d6f72652920617070726f76616c732e44546f6f4665775369676e61746f7269657304ac2054686572652061726520746f6f20666577207369676e61746f7269657320696e20746865206c6973742e48546f6f4d616e795369676e61746f7269657304b02054686572652061726520746f6f206d616e79207369676e61746f7269657320696e20746865206c6973742e545369676e61746f726965734f75744f664f7264657204110120546865207369676e61746f7269657320776572652070726f7669646564206f7574206f66206f726465723b20746865792073686f756c64206265206f7264657265642e4c53656e646572496e5369676e61746f72696573041101205468652073656e6465722077617320636f6e7461696e656420696e20746865206f74686572207369676e61746f726965733b2069742073686f756c646e27742062652e204e6f74466f756e6404e0204d756c7469736967206f7065726174696f6e206e6f7420666f756e64207768656e20617474656d7074696e6720746f2063616e63656c2e204e6f744f776e6572043101204f6e6c7920746865206163636f756e742074686174206f726967696e616c6c79206372656174656420746865206d756c74697369672069732061626c6520746f2063616e63656c2069742e2c4e6f54696d65706f696e74042101204e6f2074696d65706f696e742077617320676976656e2c2079657420746865206d756c7469736967206f7065726174696f6e20697320616c726561647920756e6465727761792e3857726f6e6754696d65706f696e74043101204120646966666572656e742074696d65706f696e742077617320676976656e20746f20746865206d756c7469736967206f7065726174696f6e207468617420697320756e6465727761792e4c556e657870656374656454696d65706f696e7404f820412074696d65706f696e742077617320676976656e2c20796574206e6f206d756c7469736967206f7065726174696f6e20697320756e6465727761792e30576569676874546f6f4c6f7704d420546865206d6178696d756d2077656967687420696e666f726d6174696f6e2070726f76696465642077617320746f6f206c6f772e34416c726561647953746f72656404a420546865206461746120746f2062652073746f72656420697320616c72656164792073746f7265642e042040436865636b5370656356657273696f6e38436865636b547856657273696f6e30436865636b47656e6573697320436865636b45726128436865636b4e6f6e63652c436865636b576569676874604368617267655472616e73616374696f6e5061796d656e746856616c696461746545717569766f636174696f6e5265706f7274'
