# coding: utf-8

"""
    Phrase TMS API

    Welcome to Phrase's TMS API documentation.    Please visit our [help center](https://support.phrase.com/hc/en-us/sections/5709662083612) for more information about the APIs.    If you have any questions, please contact [Support](https://support.phrase.com/hc/requests/new).    Please, include the `User-Agent` header with the name of your application or project. It might be a good idea to include some sort of contact information as well, so that we can get in touch if necessary. Examples of excellent `User-Agent` headers:  > User-Agent: Example mobile app (example@phrase.com) <br/> User-Agent: ACME Inc Java 1.8 Client (http://acmeinc.com/contact)  # noqa: E501

    The version of the OpenAPI document: Latest
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Optional
from pydantic import BaseModel, Field, StrictBool, StrictStr, validator

class YamlSettingsDto(BaseModel):
    """
    YamlSettingsDto
    """
    html_sub_filter: Optional[StrictBool] = Field(None, alias="htmlSubFilter", description="Default: false")
    tag_regexp: Optional[StrictStr] = Field(None, alias="tagRegexp")
    include_key_regexp: Optional[StrictStr] = Field(None, alias="includeKeyRegexp")
    exclude_value_regexp: Optional[StrictStr] = Field(None, alias="excludeValueRegexp")
    context_path: Optional[StrictStr] = Field(None, alias="contextPath")
    context_key_path: Optional[StrictStr] = Field(None, alias="contextKeyPath")
    markdown_subfilter: Optional[StrictBool] = Field(None, alias="markdownSubfilter", description="Default: false")
    update_root_element_lang: Optional[StrictBool] = Field(None, alias="updateRootElementLang", description="Default: false")
    locale_format: Optional[StrictStr] = Field(None, alias="localeFormat")
    indent_empty_lines_in_string: Optional[StrictBool] = Field(None, alias="indentEmptyLinesInString", description="Default: true")
    icu_sub_filter: Optional[StrictBool] = Field(None, alias="icuSubFilter", description="Default: `false`")
    __properties = ["htmlSubFilter", "tagRegexp", "includeKeyRegexp", "excludeValueRegexp", "contextPath", "contextKeyPath", "markdownSubfilter", "updateRootElementLang", "localeFormat", "indentEmptyLinesInString", "icuSubFilter"]

    @validator('locale_format')
    def locale_format_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in ('MEMSOURCE', 'RFC_5646', 'ANDROID_QUALIFIER', 'ANDROID_QUALIFIER_BCP'):
            raise ValueError("must be one of enum values ('MEMSOURCE', 'RFC_5646', 'ANDROID_QUALIFIER', 'ANDROID_QUALIFIER_BCP')")
        return value

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> YamlSettingsDto:
        """Create an instance of YamlSettingsDto from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> YamlSettingsDto:
        """Create an instance of YamlSettingsDto from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return YamlSettingsDto.parse_obj(obj)

        _obj = YamlSettingsDto.parse_obj({
            "html_sub_filter": obj.get("htmlSubFilter"),
            "tag_regexp": obj.get("tagRegexp"),
            "include_key_regexp": obj.get("includeKeyRegexp"),
            "exclude_value_regexp": obj.get("excludeValueRegexp"),
            "context_path": obj.get("contextPath"),
            "context_key_path": obj.get("contextKeyPath"),
            "markdown_subfilter": obj.get("markdownSubfilter"),
            "update_root_element_lang": obj.get("updateRootElementLang"),
            "locale_format": obj.get("localeFormat"),
            "indent_empty_lines_in_string": obj.get("indentEmptyLinesInString"),
            "icu_sub_filter": obj.get("icuSubFilter")
        })
        return _obj

