# coding: utf-8

"""
    Phrase TMS API

    Welcome to Phrase's TMS API documentation.    Please visit our [help center](https://support.phrase.com/hc/en-us/sections/5709662083612) for more information about the APIs.    If you have any questions, please contact [Support](https://support.phrase.com/hc/requests/new).    Please, include the `User-Agent` header with the name of your application or project. It might be a good idea to include some sort of contact information as well, so that we can get in touch if necessary. Examples of excellent `User-Agent` headers:  > User-Agent: Example mobile app (example@phrase.com) <br/> User-Agent: ACME Inc Java 1.8 Client (http://acmeinc.com/contact)  # noqa: E501

    The version of the OpenAPI document: Latest
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Optional
from pydantic import BaseModel, Field, StrictBool, StrictStr, validator

class XmlSettingsDto(BaseModel):
    """
    XmlSettingsDto
    """
    rules_format: Optional[StrictStr] = Field(None, alias="rulesFormat", description="Default: `\"PLAIN\"`")
    include_elements_plain: Optional[StrictStr] = Field(None, alias="includeElementsPlain", description="Default: `\"*\"`, example: `\"para,heading\"`")
    exclude_elements_plain: Optional[StrictStr] = Field(None, alias="excludeElementsPlain", description="Example: `\"script,par\"`")
    include_attributes_plain: Optional[StrictStr] = Field(None, alias="includeAttributesPlain", description="Example: `\"title\"`")
    exclude_attributes_plain: Optional[StrictStr] = Field(None, alias="excludeAttributesPlain", description="Example: `\"lang,href\"`")
    inline_elements_non_translatable_plain: Optional[StrictStr] = Field(None, alias="inlineElementsNonTranslatablePlain", description="Example: `\"tt,b\"`")
    inline_elements_plain: Optional[StrictStr] = Field(None, alias="inlineElementsPlain")
    inline_elements_auto_plain: Optional[StrictBool] = Field(None, alias="inlineElementsAutoPlain", description="Default: `false`")
    html_subfilter_elements_plain: Optional[StrictStr] = Field(None, alias="htmlSubfilterElementsPlain", description="Example: `\"tt,b\"`")
    entities: Optional[StrictBool] = Field(None, description="Default: `false`")
    lock_elements_plain: Optional[StrictStr] = Field(None, alias="lockElementsPlain")
    lock_attributes_plain: Optional[StrictStr] = Field(None, alias="lockAttributesPlain")
    include_x_path: Optional[StrictStr] = Field(None, alias="includeXPath")
    inline_elements_xpath: Optional[StrictStr] = Field(None, alias="inlineElementsXpath")
    inline_elements_non_translatable_x_path: Optional[StrictStr] = Field(None, alias="inlineElementsNonTranslatableXPath")
    inline_elements_auto_x_path: Optional[StrictBool] = Field(None, alias="inlineElementsAutoXPath", description="Default: `false`")
    html_subfilter_elements_xpath: Optional[StrictStr] = Field(None, alias="htmlSubfilterElementsXpath")
    lock_x_path: Optional[StrictStr] = Field(None, alias="lockXPath")
    segmentation: Optional[StrictBool] = Field(None, description="Default: `true`")
    tag_regexp: Optional[StrictStr] = Field(None, alias="tagRegexp")
    context_note_xpath: Optional[StrictStr] = Field(None, alias="contextNoteXpath")
    max_len_x_path: Optional[StrictStr] = Field(None, alias="maxLenXPath")
    preserve_whitespace_x_path: Optional[StrictStr] = Field(None, alias="preserveWhitespaceXPath")
    preserve_char_entities: Optional[StrictStr] = Field(None, alias="preserveCharEntities")
    context_key_x_path: Optional[StrictStr] = Field(None, alias="contextKeyXPath")
    xsl_url: Optional[StrictStr] = Field(None, alias="xslUrl")
    xsl_file: Optional[StrictStr] = Field(None, alias="xslFile", description="UID of uploaded XSL file, overrides `xslUrl`")
    import_comments: Optional[StrictBool] = Field(None, alias="importComments", description="Default: `true`")
    icu_sub_filter: Optional[StrictBool] = Field(None, alias="icuSubFilter", description="Default: `false`")
    __properties = ["rulesFormat", "includeElementsPlain", "excludeElementsPlain", "includeAttributesPlain", "excludeAttributesPlain", "inlineElementsNonTranslatablePlain", "inlineElementsPlain", "inlineElementsAutoPlain", "htmlSubfilterElementsPlain", "entities", "lockElementsPlain", "lockAttributesPlain", "includeXPath", "inlineElementsXpath", "inlineElementsNonTranslatableXPath", "inlineElementsAutoXPath", "htmlSubfilterElementsXpath", "lockXPath", "segmentation", "tagRegexp", "contextNoteXpath", "maxLenXPath", "preserveWhitespaceXPath", "preserveCharEntities", "contextKeyXPath", "xslUrl", "xslFile", "importComments", "icuSubFilter"]

    @validator('rules_format')
    def rules_format_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in ('PLAIN', 'XPATH'):
            raise ValueError("must be one of enum values ('PLAIN', 'XPATH')")
        return value

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> XmlSettingsDto:
        """Create an instance of XmlSettingsDto from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> XmlSettingsDto:
        """Create an instance of XmlSettingsDto from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return XmlSettingsDto.parse_obj(obj)

        _obj = XmlSettingsDto.parse_obj({
            "rules_format": obj.get("rulesFormat"),
            "include_elements_plain": obj.get("includeElementsPlain"),
            "exclude_elements_plain": obj.get("excludeElementsPlain"),
            "include_attributes_plain": obj.get("includeAttributesPlain"),
            "exclude_attributes_plain": obj.get("excludeAttributesPlain"),
            "inline_elements_non_translatable_plain": obj.get("inlineElementsNonTranslatablePlain"),
            "inline_elements_plain": obj.get("inlineElementsPlain"),
            "inline_elements_auto_plain": obj.get("inlineElementsAutoPlain"),
            "html_subfilter_elements_plain": obj.get("htmlSubfilterElementsPlain"),
            "entities": obj.get("entities"),
            "lock_elements_plain": obj.get("lockElementsPlain"),
            "lock_attributes_plain": obj.get("lockAttributesPlain"),
            "include_x_path": obj.get("includeXPath"),
            "inline_elements_xpath": obj.get("inlineElementsXpath"),
            "inline_elements_non_translatable_x_path": obj.get("inlineElementsNonTranslatableXPath"),
            "inline_elements_auto_x_path": obj.get("inlineElementsAutoXPath"),
            "html_subfilter_elements_xpath": obj.get("htmlSubfilterElementsXpath"),
            "lock_x_path": obj.get("lockXPath"),
            "segmentation": obj.get("segmentation"),
            "tag_regexp": obj.get("tagRegexp"),
            "context_note_xpath": obj.get("contextNoteXpath"),
            "max_len_x_path": obj.get("maxLenXPath"),
            "preserve_whitespace_x_path": obj.get("preserveWhitespaceXPath"),
            "preserve_char_entities": obj.get("preserveCharEntities"),
            "context_key_x_path": obj.get("contextKeyXPath"),
            "xsl_url": obj.get("xslUrl"),
            "xsl_file": obj.get("xslFile"),
            "import_comments": obj.get("importComments"),
            "icu_sub_filter": obj.get("icuSubFilter")
        })
        return _obj

