# coding: utf-8

"""
    Phrase TMS API

    Welcome to Phrase's TMS API documentation.    Please visit our [help center](https://support.phrase.com/hc/en-us/sections/5709662083612) for more information about the APIs.    If you have any questions, please contact [Support](https://support.phrase.com/hc/requests/new).    Please, include the `User-Agent` header with the name of your application or project. It might be a good idea to include some sort of contact information as well, so that we can get in touch if necessary. Examples of excellent `User-Agent` headers:  > User-Agent: Example mobile app (example@phrase.com) <br/> User-Agent: ACME Inc Java 1.8 Client (http://acmeinc.com/contact)  # noqa: E501

    The version of the OpenAPI document: Latest
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Optional
from pydantic import BaseModel, Field, StrictBool, StrictStr, validator

class XlsSettingsDto(BaseModel):
    """
    XlsSettingsDto
    """
    sheet_names: Optional[StrictBool] = Field(None, alias="sheetNames", description="Default: false")
    hidden: Optional[StrictBool] = Field(None, description="Default: false")
    comments: Optional[StrictBool] = Field(None, description="Default: false")
    other: Optional[StrictBool] = Field(None, description="Default: false")
    cell_flow: Optional[StrictStr] = Field(None, alias="cellFlow", description="Default: DownRight")
    html_subfilter: Optional[StrictBool] = Field(None, alias="htmlSubfilter", description="Default: false")
    tag_regexp: Optional[StrictStr] = Field(None, alias="tagRegexp")
    specified_columns: Optional[StrictStr] = Field(None, alias="specifiedColumns")
    __properties = ["sheetNames", "hidden", "comments", "other", "cellFlow", "htmlSubfilter", "tagRegexp", "specifiedColumns"]

    @validator('cell_flow')
    def cell_flow_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in ('DownRight', 'RightDown', 'DownLeft', 'LeftDown'):
            raise ValueError("must be one of enum values ('DownRight', 'RightDown', 'DownLeft', 'LeftDown')")
        return value

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> XlsSettingsDto:
        """Create an instance of XlsSettingsDto from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> XlsSettingsDto:
        """Create an instance of XlsSettingsDto from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return XlsSettingsDto.parse_obj(obj)

        _obj = XlsSettingsDto.parse_obj({
            "sheet_names": obj.get("sheetNames"),
            "hidden": obj.get("hidden"),
            "comments": obj.get("comments"),
            "other": obj.get("other"),
            "cell_flow": obj.get("cellFlow"),
            "html_subfilter": obj.get("htmlSubfilter"),
            "tag_regexp": obj.get("tagRegexp"),
            "specified_columns": obj.get("specifiedColumns")
        })
        return _obj

