# coding: utf-8

"""
    Phrase TMS API

    Welcome to Phrase's TMS API documentation.    Please visit our [help center](https://support.phrase.com/hc/en-us/sections/5709662083612) for more information about the APIs.    If you have any questions, please contact [Support](https://support.phrase.com/hc/requests/new).    Please, include the `User-Agent` header with the name of your application or project. It might be a good idea to include some sort of contact information as well, so that we can get in touch if necessary. Examples of excellent `User-Agent` headers:  > User-Agent: Example mobile app (example@phrase.com) <br/> User-Agent: ACME Inc Java 1.8 Client (http://acmeinc.com/contact)  # noqa: E501

    The version of the OpenAPI document: Latest
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Optional
from pydantic import BaseModel, Field, StrictBool, StrictStr

class Xlf2SettingsDto(BaseModel):
    """
    Xlf2SettingsDto
    """
    icu_sub_filter: Optional[StrictBool] = Field(None, alias="icuSubFilter", description="Default: false")
    import_notes: Optional[StrictBool] = Field(None, alias="importNotes", description="Default: true")
    save_confirmed_segments: Optional[StrictBool] = Field(None, alias="saveConfirmedSegments", description="Default: true")
    segmentation: Optional[StrictBool] = Field(None, description="Default: true")
    line_break_tags: Optional[StrictBool] = Field(None, alias="lineBreakTags", description="Default: false")
    preserve_whitespace: Optional[StrictBool] = Field(None, alias="preserveWhitespace", description="Default: true")
    copy_source_to_target_if_not_imported: Optional[StrictBool] = Field(None, alias="copySourceToTargetIfNotImported", description="Default: true")
    respect_translate_attr: Optional[StrictBool] = Field(None, alias="respectTranslateAttr", description="Default: true")
    skip_import_rules: Optional[StrictStr] = Field(None, alias="skipImportRules")
    import_as_confirmed_rules: Optional[StrictStr] = Field(None, alias="importAsConfirmedRules", description="Default: state=final")
    import_as_locked_rules: Optional[StrictStr] = Field(None, alias="importAsLockedRules")
    export_attrs_when_confirmed_and_locked: Optional[StrictStr] = Field(None, alias="exportAttrsWhenConfirmedAndLocked", description="Default: state=final")
    export_attrs_when_confirmed_and_not_locked: Optional[StrictStr] = Field(None, alias="exportAttrsWhenConfirmedAndNotLocked", description="Default: state=final")
    export_attrs_when_not_confirmed_and_locked: Optional[StrictStr] = Field(None, alias="exportAttrsWhenNotConfirmedAndLocked")
    export_attrs_when_not_confirmed_and_not_locked: Optional[StrictStr] = Field(None, alias="exportAttrsWhenNotConfirmedAndNotLocked")
    context_key_x_path: Optional[StrictStr] = Field(None, alias="contextKeyXPath")
    preserve_char_entities: Optional[StrictStr] = Field(None, alias="preserveCharEntities")
    xsl_url: Optional[StrictStr] = Field(None, alias="xslUrl")
    xsl_file: Optional[StrictStr] = Field(None, alias="xslFile", description="UID of uploaded XSL file, overrides xslUrl")
    tag_regexp: Optional[StrictStr] = Field(None, alias="tagRegexp")
    __properties = ["icuSubFilter", "importNotes", "saveConfirmedSegments", "segmentation", "lineBreakTags", "preserveWhitespace", "copySourceToTargetIfNotImported", "respectTranslateAttr", "skipImportRules", "importAsConfirmedRules", "importAsLockedRules", "exportAttrsWhenConfirmedAndLocked", "exportAttrsWhenConfirmedAndNotLocked", "exportAttrsWhenNotConfirmedAndLocked", "exportAttrsWhenNotConfirmedAndNotLocked", "contextKeyXPath", "preserveCharEntities", "xslUrl", "xslFile", "tagRegexp"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Xlf2SettingsDto:
        """Create an instance of Xlf2SettingsDto from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> Xlf2SettingsDto:
        """Create an instance of Xlf2SettingsDto from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return Xlf2SettingsDto.parse_obj(obj)

        _obj = Xlf2SettingsDto.parse_obj({
            "icu_sub_filter": obj.get("icuSubFilter"),
            "import_notes": obj.get("importNotes"),
            "save_confirmed_segments": obj.get("saveConfirmedSegments"),
            "segmentation": obj.get("segmentation"),
            "line_break_tags": obj.get("lineBreakTags"),
            "preserve_whitespace": obj.get("preserveWhitespace"),
            "copy_source_to_target_if_not_imported": obj.get("copySourceToTargetIfNotImported"),
            "respect_translate_attr": obj.get("respectTranslateAttr"),
            "skip_import_rules": obj.get("skipImportRules"),
            "import_as_confirmed_rules": obj.get("importAsConfirmedRules"),
            "import_as_locked_rules": obj.get("importAsLockedRules"),
            "export_attrs_when_confirmed_and_locked": obj.get("exportAttrsWhenConfirmedAndLocked"),
            "export_attrs_when_confirmed_and_not_locked": obj.get("exportAttrsWhenConfirmedAndNotLocked"),
            "export_attrs_when_not_confirmed_and_locked": obj.get("exportAttrsWhenNotConfirmedAndLocked"),
            "export_attrs_when_not_confirmed_and_not_locked": obj.get("exportAttrsWhenNotConfirmedAndNotLocked"),
            "context_key_x_path": obj.get("contextKeyXPath"),
            "preserve_char_entities": obj.get("preserveCharEntities"),
            "xsl_url": obj.get("xslUrl"),
            "xsl_file": obj.get("xslFile"),
            "tag_regexp": obj.get("tagRegexp")
        })
        return _obj

