# coding: utf-8

"""
    Phrase TMS API

    Welcome to Phrase's TMS API documentation.    Please visit our [help center](https://support.phrase.com/hc/en-us/sections/5709662083612) for more information about the APIs.    If you have any questions, please contact [Support](https://support.phrase.com/hc/requests/new).    Please, include the `User-Agent` header with the name of your application or project. It might be a good idea to include some sort of contact information as well, so that we can get in touch if necessary. Examples of excellent `User-Agent` headers:  > User-Agent: Example mobile app (example@phrase.com) <br/> User-Agent: ACME Inc Java 1.8 Client (http://acmeinc.com/contact)  # noqa: E501

    The version of the OpenAPI document: Latest
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import List, Optional
from pydantic import BaseModel, Field, conlist
from phrasetms_client.models.id_reference import IdReference
from phrasetms_client.models.project_template_notify_provider_dto import ProjectTemplateNotifyProviderDto
from phrasetms_client.models.project_template_workflow_settings_assigned_to_dto import ProjectTemplateWorkflowSettingsAssignedToDto
from phrasetms_client.models.uid_reference import UidReference

class WorkflowStepSettingsEditDto(BaseModel):
    """
    WorkflowStepSettingsEditDto
    """
    workflow_step: Optional[IdReference] = Field(None, alias="workflowStep")
    assigned_to: Optional[conlist(ProjectTemplateWorkflowSettingsAssignedToDto)] = Field(None, alias="assignedTo")
    notify_provider: Optional[ProjectTemplateNotifyProviderDto] = Field(None, alias="notifyProvider")
    lqa_profile: Optional[UidReference] = Field(None, alias="lqaProfile")
    __properties = ["workflowStep", "assignedTo", "notifyProvider", "lqaProfile"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> WorkflowStepSettingsEditDto:
        """Create an instance of WorkflowStepSettingsEditDto from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of workflow_step
        if self.workflow_step:
            _dict['workflowStep'] = self.workflow_step.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in assigned_to (list)
        _items = []
        if self.assigned_to:
            for _item in self.assigned_to:
                if _item:
                    _items.append(_item.to_dict())
            _dict['assignedTo'] = _items
        # override the default output from pydantic by calling `to_dict()` of notify_provider
        if self.notify_provider:
            _dict['notifyProvider'] = self.notify_provider.to_dict()
        # override the default output from pydantic by calling `to_dict()` of lqa_profile
        if self.lqa_profile:
            _dict['lqaProfile'] = self.lqa_profile.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> WorkflowStepSettingsEditDto:
        """Create an instance of WorkflowStepSettingsEditDto from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return WorkflowStepSettingsEditDto.parse_obj(obj)

        _obj = WorkflowStepSettingsEditDto.parse_obj({
            "workflow_step": IdReference.from_dict(obj.get("workflowStep")) if obj.get("workflowStep") is not None else None,
            "assigned_to": [ProjectTemplateWorkflowSettingsAssignedToDto.from_dict(_item) for _item in obj.get("assignedTo")] if obj.get("assignedTo") is not None else None,
            "notify_provider": ProjectTemplateNotifyProviderDto.from_dict(obj.get("notifyProvider")) if obj.get("notifyProvider") is not None else None,
            "lqa_profile": UidReference.from_dict(obj.get("lqaProfile")) if obj.get("lqaProfile") is not None else None
        })
        return _obj

