# coding: utf-8

"""
    Phrase TMS API

    Welcome to Phrase's TMS API documentation.    Please visit our [help center](https://support.phrase.com/hc/en-us/sections/5709662083612) for more information about the APIs.    If you have any questions, please contact [Support](https://support.phrase.com/hc/requests/new).    Please, include the `User-Agent` header with the name of your application or project. It might be a good idea to include some sort of contact information as well, so that we can get in touch if necessary. Examples of excellent `User-Agent` headers:  > User-Agent: Example mobile app (example@phrase.com) <br/> User-Agent: ACME Inc Java 1.8 Client (http://acmeinc.com/contact)  # noqa: E501

    The version of the OpenAPI document: Latest
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from typing import Optional
from pydantic import BaseModel, Field, StrictBool, StrictInt, StrictStr, validator
from phrasetms_client.models.uid_reference import UidReference

class WebhookCallDto(BaseModel):
    """
    WebhookCallDto
    """
    uid: Optional[StrictStr] = None
    parent_uid: Optional[StrictStr] = Field(None, alias="parentUid")
    event_uid: Optional[StrictStr] = Field(None, alias="eventUid")
    webhook_settings: Optional[UidReference] = Field(None, alias="webhookSettings")
    created_at: Optional[datetime] = Field(None, alias="createdAt")
    url: Optional[StrictStr] = None
    forced: Optional[StrictBool] = None
    last_forced_at: Optional[datetime] = Field(None, alias="lastForcedAt")
    body: Optional[StrictStr] = None
    trigger_event: Optional[StrictStr] = Field(None, alias="triggerEvent")
    retry_attempt: Optional[StrictInt] = Field(None, alias="retryAttempt")
    status_code: Optional[StrictInt] = Field(None, alias="statusCode")
    error_message: Optional[StrictStr] = Field(None, alias="errorMessage")
    __properties = ["uid", "parentUid", "eventUid", "webhookSettings", "createdAt", "url", "forced", "lastForcedAt", "body", "triggerEvent", "retryAttempt", "statusCode", "errorMessage"]

    @validator('trigger_event')
    def trigger_event_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in ('JOB_STATUS_CHANGED', 'JOB_CREATED', 'JOB_DELETED', 'JOB_ASSIGNED', 'JOB_DUE_DATE_CHANGED', 'JOB_UPDATED', 'JOB_TARGET_UPDATED', 'JOB_EXPORTED', 'JOB_UNEXPORTED', 'PROJECT_CREATED', 'PROJECT_DELETED', 'PROJECT_STATUS_CHANGED', 'PROJECT_DUE_DATE_CHANGED', 'SHARED_PROJECT_ASSIGNED', 'PROJECT_METADATA_UPDATED', 'PRE_TRANSLATION_FINISHED', 'ANALYSIS_CREATED', 'CONTINUOUS_JOB_UPDATED', 'PROJECT_TEMPLATE_CREATED', 'PROJECT_TEMPLATE_UPDATED', 'PROJECT_TEMPLATE_DELETED'):
            raise ValueError("must be one of enum values ('JOB_STATUS_CHANGED', 'JOB_CREATED', 'JOB_DELETED', 'JOB_ASSIGNED', 'JOB_DUE_DATE_CHANGED', 'JOB_UPDATED', 'JOB_TARGET_UPDATED', 'JOB_EXPORTED', 'JOB_UNEXPORTED', 'PROJECT_CREATED', 'PROJECT_DELETED', 'PROJECT_STATUS_CHANGED', 'PROJECT_DUE_DATE_CHANGED', 'SHARED_PROJECT_ASSIGNED', 'PROJECT_METADATA_UPDATED', 'PRE_TRANSLATION_FINISHED', 'ANALYSIS_CREATED', 'CONTINUOUS_JOB_UPDATED', 'PROJECT_TEMPLATE_CREATED', 'PROJECT_TEMPLATE_UPDATED', 'PROJECT_TEMPLATE_DELETED')")
        return value

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> WebhookCallDto:
        """Create an instance of WebhookCallDto from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of webhook_settings
        if self.webhook_settings:
            _dict['webhookSettings'] = self.webhook_settings.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> WebhookCallDto:
        """Create an instance of WebhookCallDto from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return WebhookCallDto.parse_obj(obj)

        _obj = WebhookCallDto.parse_obj({
            "uid": obj.get("uid"),
            "parent_uid": obj.get("parentUid"),
            "event_uid": obj.get("eventUid"),
            "webhook_settings": UidReference.from_dict(obj.get("webhookSettings")) if obj.get("webhookSettings") is not None else None,
            "created_at": obj.get("createdAt"),
            "url": obj.get("url"),
            "forced": obj.get("forced"),
            "last_forced_at": obj.get("lastForcedAt"),
            "body": obj.get("body"),
            "trigger_event": obj.get("triggerEvent"),
            "retry_attempt": obj.get("retryAttempt"),
            "status_code": obj.get("statusCode"),
            "error_message": obj.get("errorMessage")
        })
        return _obj

