# coding: utf-8

"""
    Phrase TMS API

    Welcome to Phrase's TMS API documentation.    Please visit our [help center](https://support.phrase.com/hc/en-us/sections/5709662083612) for more information about the APIs.    If you have any questions, please contact [Support](https://support.phrase.com/hc/requests/new).    Please, include the `User-Agent` header with the name of your application or project. It might be a good idea to include some sort of contact information as well, so that we can get in touch if necessary. Examples of excellent `User-Agent` headers:  > User-Agent: Example mobile app (example@phrase.com) <br/> User-Agent: ACME Inc Java 1.8 Client (http://acmeinc.com/contact)  # noqa: E501

    The version of the OpenAPI document: Latest
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import List, Optional
from pydantic import BaseModel, Field, conlist
from phrasetms_client.models.create_custom_field_instance_dto import CreateCustomFieldInstanceDto
from phrasetms_client.models.uid_reference import UidReference
from phrasetms_client.models.update_custom_field_instance_with_uid_dto import UpdateCustomFieldInstanceWithUidDto

class UpdateCustomFieldInstancesDto(BaseModel):
    """
    UpdateCustomFieldInstancesDto
    """
    add_instances: Optional[conlist(CreateCustomFieldInstanceDto)] = Field(None, alias="addInstances")
    remove_instances: Optional[conlist(UidReference)] = Field(None, alias="removeInstances")
    update_instances: Optional[conlist(UpdateCustomFieldInstanceWithUidDto)] = Field(None, alias="updateInstances")
    __properties = ["addInstances", "removeInstances", "updateInstances"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> UpdateCustomFieldInstancesDto:
        """Create an instance of UpdateCustomFieldInstancesDto from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of each item in add_instances (list)
        _items = []
        if self.add_instances:
            for _item in self.add_instances:
                if _item:
                    _items.append(_item.to_dict())
            _dict['addInstances'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in remove_instances (list)
        _items = []
        if self.remove_instances:
            for _item in self.remove_instances:
                if _item:
                    _items.append(_item.to_dict())
            _dict['removeInstances'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in update_instances (list)
        _items = []
        if self.update_instances:
            for _item in self.update_instances:
                if _item:
                    _items.append(_item.to_dict())
            _dict['updateInstances'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> UpdateCustomFieldInstancesDto:
        """Create an instance of UpdateCustomFieldInstancesDto from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return UpdateCustomFieldInstancesDto.parse_obj(obj)

        _obj = UpdateCustomFieldInstancesDto.parse_obj({
            "add_instances": [CreateCustomFieldInstanceDto.from_dict(_item) for _item in obj.get("addInstances")] if obj.get("addInstances") is not None else None,
            "remove_instances": [UidReference.from_dict(_item) for _item in obj.get("removeInstances")] if obj.get("removeInstances") is not None else None,
            "update_instances": [UpdateCustomFieldInstanceWithUidDto.from_dict(_item) for _item in obj.get("updateInstances")] if obj.get("updateInstances") is not None else None
        })
        return _obj

