# coding: utf-8

"""
    Phrase TMS API

    Welcome to Phrase's TMS API documentation.    Please visit our [help center](https://support.phrase.com/hc/en-us/sections/5709662083612) for more information about the APIs.    If you have any questions, please contact [Support](https://support.phrase.com/hc/requests/new).    Please, include the `User-Agent` header with the name of your application or project. It might be a good idea to include some sort of contact information as well, so that we can get in touch if necessary. Examples of excellent `User-Agent` headers:  > User-Agent: Example mobile app (example@phrase.com) <br/> User-Agent: ACME Inc Java 1.8 Client (http://acmeinc.com/contact)  # noqa: E501

    The version of the OpenAPI document: Latest
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import List, Optional
from pydantic import BaseModel, Field, conlist, constr
from phrasetms_client.models.uid_reference import UidReference

class UpdateCustomFieldInstanceWithUidDto(BaseModel):
    """
    UpdateCustomFieldInstanceWithUidDto
    """
    custom_field_instance: Optional[UidReference] = Field(None, alias="customFieldInstance")
    custom_field: Optional[UidReference] = Field(None, alias="customField")
    selected_options: Optional[conlist(UidReference)] = Field(None, alias="selectedOptions")
    value: Optional[constr(strict=True, max_length=4096, min_length=0)] = None
    __properties = ["customFieldInstance", "customField", "selectedOptions", "value"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> UpdateCustomFieldInstanceWithUidDto:
        """Create an instance of UpdateCustomFieldInstanceWithUidDto from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of custom_field_instance
        if self.custom_field_instance:
            _dict['customFieldInstance'] = self.custom_field_instance.to_dict()
        # override the default output from pydantic by calling `to_dict()` of custom_field
        if self.custom_field:
            _dict['customField'] = self.custom_field.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in selected_options (list)
        _items = []
        if self.selected_options:
            for _item in self.selected_options:
                if _item:
                    _items.append(_item.to_dict())
            _dict['selectedOptions'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> UpdateCustomFieldInstanceWithUidDto:
        """Create an instance of UpdateCustomFieldInstanceWithUidDto from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return UpdateCustomFieldInstanceWithUidDto.parse_obj(obj)

        _obj = UpdateCustomFieldInstanceWithUidDto.parse_obj({
            "custom_field_instance": UidReference.from_dict(obj.get("customFieldInstance")) if obj.get("customFieldInstance") is not None else None,
            "custom_field": UidReference.from_dict(obj.get("customField")) if obj.get("customField") is not None else None,
            "selected_options": [UidReference.from_dict(_item) for _item in obj.get("selectedOptions")] if obj.get("selectedOptions") is not None else None,
            "value": obj.get("value")
        })
        return _obj

