# coding: utf-8

"""
    Phrase TMS API

    Welcome to Phrase's TMS API documentation.    Please visit our [help center](https://support.phrase.com/hc/en-us/sections/5709662083612) for more information about the APIs.    If you have any questions, please contact [Support](https://support.phrase.com/hc/requests/new).    Please, include the `User-Agent` header with the name of your application or project. It might be a good idea to include some sort of contact information as well, so that we can get in touch if necessary. Examples of excellent `User-Agent` headers:  > User-Agent: Example mobile app (example@phrase.com) <br/> User-Agent: ACME Inc Java 1.8 Client (http://acmeinc.com/contact)  # noqa: E501

    The version of the OpenAPI document: Latest
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import List, Optional
from pydantic import BaseModel, Field, conlist
from phrasetms_client.models.machine_translate_settings_reference import MachineTranslateSettingsReference
from phrasetms_client.models.project_term_base_reference import ProjectTermBaseReference
from phrasetms_client.models.project_translation_memory_reference import ProjectTranslationMemoryReference

class TranslationResourcesDto(BaseModel):
    """
    TranslationResourcesDto
    """
    machine_translate_settings: Optional[MachineTranslateSettingsReference] = Field(None, alias="machineTranslateSettings")
    translation_memories: Optional[conlist(ProjectTranslationMemoryReference)] = Field(None, alias="translationMemories")
    term_bases: Optional[conlist(ProjectTermBaseReference)] = Field(None, alias="termBases")
    __properties = ["machineTranslateSettings", "translationMemories", "termBases"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> TranslationResourcesDto:
        """Create an instance of TranslationResourcesDto from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of machine_translate_settings
        if self.machine_translate_settings:
            _dict['machineTranslateSettings'] = self.machine_translate_settings.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in translation_memories (list)
        _items = []
        if self.translation_memories:
            for _item in self.translation_memories:
                if _item:
                    _items.append(_item.to_dict())
            _dict['translationMemories'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in term_bases (list)
        _items = []
        if self.term_bases:
            for _item in self.term_bases:
                if _item:
                    _items.append(_item.to_dict())
            _dict['termBases'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> TranslationResourcesDto:
        """Create an instance of TranslationResourcesDto from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return TranslationResourcesDto.parse_obj(obj)

        _obj = TranslationResourcesDto.parse_obj({
            "machine_translate_settings": MachineTranslateSettingsReference.from_dict(obj.get("machineTranslateSettings")) if obj.get("machineTranslateSettings") is not None else None,
            "translation_memories": [ProjectTranslationMemoryReference.from_dict(_item) for _item in obj.get("translationMemories")] if obj.get("translationMemories") is not None else None,
            "term_bases": [ProjectTermBaseReference.from_dict(_item) for _item in obj.get("termBases")] if obj.get("termBases") is not None else None
        })
        return _obj

