# coding: utf-8

"""
    Phrase TMS API

    Welcome to Phrase's TMS API documentation.    Please visit our [help center](https://support.phrase.com/hc/en-us/sections/5709662083612) for more information about the APIs.    If you have any questions, please contact [Support](https://support.phrase.com/hc/requests/new).    Please, include the `User-Agent` header with the name of your application or project. It might be a good idea to include some sort of contact information as well, so that we can get in touch if necessary. Examples of excellent `User-Agent` headers:  > User-Agent: Example mobile app (example@phrase.com) <br/> User-Agent: ACME Inc Java 1.8 Client (http://acmeinc.com/contact)  # noqa: E501

    The version of the OpenAPI document: Latest
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import List, Optional, Union
from pydantic import BaseModel, Field, StrictFloat, StrictInt, StrictStr, conlist
from phrasetms_client.models.translation_price_dto import TranslationPriceDto

class TranslationPriceSetDto(BaseModel):
    """
    Language pair for translation price list, owns minimalPrice
    """
    source_lang: Optional[StrictStr] = Field(None, alias="sourceLang")
    target_lang: Optional[StrictStr] = Field(None, alias="targetLang")
    minimum_price: Optional[Union[StrictFloat, StrictInt]] = Field(None, alias="minimumPrice")
    prices: Optional[conlist(TranslationPriceDto)] = None
    __properties = ["sourceLang", "targetLang", "minimumPrice", "prices"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> TranslationPriceSetDto:
        """Create an instance of TranslationPriceSetDto from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of each item in prices (list)
        _items = []
        if self.prices:
            for _item in self.prices:
                if _item:
                    _items.append(_item.to_dict())
            _dict['prices'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> TranslationPriceSetDto:
        """Create an instance of TranslationPriceSetDto from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return TranslationPriceSetDto.parse_obj(obj)

        _obj = TranslationPriceSetDto.parse_obj({
            "source_lang": obj.get("sourceLang"),
            "target_lang": obj.get("targetLang"),
            "minimum_price": obj.get("minimumPrice"),
            "prices": [TranslationPriceDto.from_dict(_item) for _item in obj.get("prices")] if obj.get("prices") is not None else None
        })
        return _obj

