# coding: utf-8

"""
    Phrase TMS API

    Welcome to Phrase's TMS API documentation.    Please visit our [help center](https://support.phrase.com/hc/en-us/sections/5709662083612) for more information about the APIs.    If you have any questions, please contact [Support](https://support.phrase.com/hc/requests/new).    Please, include the `User-Agent` header with the name of your application or project. It might be a good idea to include some sort of contact information as well, so that we can get in touch if necessary. Examples of excellent `User-Agent` headers:  > User-Agent: Example mobile app (example@phrase.com) <br/> User-Agent: ACME Inc Java 1.8 Client (http://acmeinc.com/contact)  # noqa: E501

    The version of the OpenAPI document: Latest
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from typing import List, Optional
from pydantic import BaseModel, Field, StrictStr, conlist, validator
from phrasetms_client.models.translation_price_set_dto import TranslationPriceSetDto

class TranslationPriceListDto(BaseModel):
    """
    Price list with set of prices for language pairs
    """
    id: Optional[StrictStr] = None
    uid: Optional[StrictStr] = None
    date_created: Optional[datetime] = Field(None, alias="dateCreated")
    name: StrictStr = Field(...)
    currency_code: Optional[StrictStr] = Field(None, alias="currencyCode")
    billing_unit: Optional[StrictStr] = Field(None, alias="billingUnit")
    price_sets: Optional[conlist(TranslationPriceSetDto)] = Field(None, alias="priceSets")
    __properties = ["id", "uid", "dateCreated", "name", "currencyCode", "billingUnit", "priceSets"]

    @validator('billing_unit')
    def billing_unit_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in ('Character', 'Word', 'Page', 'Hour'):
            raise ValueError("must be one of enum values ('Character', 'Word', 'Page', 'Hour')")
        return value

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> TranslationPriceListDto:
        """Create an instance of TranslationPriceListDto from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                            "id",
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of each item in price_sets (list)
        _items = []
        if self.price_sets:
            for _item in self.price_sets:
                if _item:
                    _items.append(_item.to_dict())
            _dict['priceSets'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> TranslationPriceListDto:
        """Create an instance of TranslationPriceListDto from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return TranslationPriceListDto.parse_obj(obj)

        _obj = TranslationPriceListDto.parse_obj({
            "id": obj.get("id"),
            "uid": obj.get("uid"),
            "date_created": obj.get("dateCreated"),
            "name": obj.get("name"),
            "currency_code": obj.get("currencyCode"),
            "billing_unit": obj.get("billingUnit"),
            "price_sets": [TranslationPriceSetDto.from_dict(_item) for _item in obj.get("priceSets")] if obj.get("priceSets") is not None else None
        })
        return _obj

