# coding: utf-8

"""
    Phrase TMS API

    Welcome to Phrase's TMS API documentation.    Please visit our [help center](https://support.phrase.com/hc/en-us/sections/5709662083612) for more information about the APIs.    If you have any questions, please contact [Support](https://support.phrase.com/hc/requests/new).    Please, include the `User-Agent` header with the name of your application or project. It might be a good idea to include some sort of contact information as well, so that we can get in touch if necessary. Examples of excellent `User-Agent` headers:  > User-Agent: Example mobile app (example@phrase.com) <br/> User-Agent: ACME Inc Java 1.8 Client (http://acmeinc.com/contact)  # noqa: E501

    The version of the OpenAPI document: Latest
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Optional, Union
from pydantic import BaseModel, Field, StrictBool, confloat, conint

class TranslationMemorySettingsDto(BaseModel):
    """
    Translation memory related settings
    """
    use_translation_memory: Optional[StrictBool] = Field(None, alias="useTranslationMemory", description="Pre-translate from translation memory. Default: false")
    translation_memory_threshold: Optional[Union[confloat(le=1.01, ge=0, strict=True), conint(le=1, ge=0, strict=True)]] = Field(None, alias="translationMemoryThreshold", description="Pre-translation threshold percent")
    confirm100_percent_matches: Optional[StrictBool] = Field(None, alias="confirm100PercentMatches", description="Set segment status to confirmed for: 100% translation memory matches. Default: false")
    confirm101_percent_matches: Optional[StrictBool] = Field(None, alias="confirm101PercentMatches", description="Set segment status to confirmed for: 101% translation memory matches. Default: false")
    lock100_percent_matches: Optional[StrictBool] = Field(None, alias="lock100PercentMatches", description="Lock section: 100% translation memory matches. Default: false")
    lock101_percent_matches: Optional[StrictBool] = Field(None, alias="lock101PercentMatches", description="Lock section: 101% translation memory matches. Default: false")
    __properties = ["useTranslationMemory", "translationMemoryThreshold", "confirm100PercentMatches", "confirm101PercentMatches", "lock100PercentMatches", "lock101PercentMatches"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> TranslationMemorySettingsDto:
        """Create an instance of TranslationMemorySettingsDto from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> TranslationMemorySettingsDto:
        """Create an instance of TranslationMemorySettingsDto from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return TranslationMemorySettingsDto.parse_obj(obj)

        _obj = TranslationMemorySettingsDto.parse_obj({
            "use_translation_memory": obj.get("useTranslationMemory"),
            "translation_memory_threshold": obj.get("translationMemoryThreshold"),
            "confirm100_percent_matches": obj.get("confirm100PercentMatches"),
            "confirm101_percent_matches": obj.get("confirm101PercentMatches"),
            "lock100_percent_matches": obj.get("lock100PercentMatches"),
            "lock101_percent_matches": obj.get("lock101PercentMatches")
        })
        return _obj

