# coding: utf-8

"""
    Phrase TMS API

    Welcome to Phrase's TMS API documentation.    Please visit our [help center](https://support.phrase.com/hc/en-us/sections/5709662083612) for more information about the APIs.    If you have any questions, please contact [Support](https://support.phrase.com/hc/requests/new).    Please, include the `User-Agent` header with the name of your application or project. It might be a good idea to include some sort of contact information as well, so that we can get in touch if necessary. Examples of excellent `User-Agent` headers:  > User-Agent: Example mobile app (example@phrase.com) <br/> User-Agent: ACME Inc Java 1.8 Client (http://acmeinc.com/contact)  # noqa: E501

    The version of the OpenAPI document: Latest
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from typing import List, Optional
from pydantic import BaseModel, Field, StrictInt, StrictStr, conlist
from phrasetms_client.models.business_unit_reference import BusinessUnitReference
from phrasetms_client.models.client_reference import ClientReference
from phrasetms_client.models.domain_reference import DomainReference
from phrasetms_client.models.sub_domain_reference import SubDomainReference
from phrasetms_client.models.user_reference import UserReference

class TransMemoryDto(BaseModel):
    """
    TransMemoryDto
    """
    id: Optional[StrictStr] = None
    uid: Optional[StrictStr] = None
    internal_id: Optional[StrictInt] = Field(None, alias="internalId")
    name: Optional[StrictStr] = None
    source_lang: Optional[StrictStr] = Field(None, alias="sourceLang")
    target_langs: Optional[conlist(StrictStr)] = Field(None, alias="targetLangs")
    client: Optional[ClientReference] = None
    business_unit: Optional[BusinessUnitReference] = Field(None, alias="businessUnit")
    domain: Optional[DomainReference] = None
    sub_domain: Optional[SubDomainReference] = Field(None, alias="subDomain")
    note: Optional[StrictStr] = None
    date_created: Optional[datetime] = Field(None, alias="dateCreated")
    created_by: Optional[UserReference] = Field(None, alias="createdBy")
    owner: Optional[UserReference] = None
    __properties = ["id", "uid", "internalId", "name", "sourceLang", "targetLangs", "client", "businessUnit", "domain", "subDomain", "note", "dateCreated", "createdBy", "owner"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> TransMemoryDto:
        """Create an instance of TransMemoryDto from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of client
        if self.client:
            _dict['client'] = self.client.to_dict()
        # override the default output from pydantic by calling `to_dict()` of business_unit
        if self.business_unit:
            _dict['businessUnit'] = self.business_unit.to_dict()
        # override the default output from pydantic by calling `to_dict()` of domain
        if self.domain:
            _dict['domain'] = self.domain.to_dict()
        # override the default output from pydantic by calling `to_dict()` of sub_domain
        if self.sub_domain:
            _dict['subDomain'] = self.sub_domain.to_dict()
        # override the default output from pydantic by calling `to_dict()` of created_by
        if self.created_by:
            _dict['createdBy'] = self.created_by.to_dict()
        # override the default output from pydantic by calling `to_dict()` of owner
        if self.owner:
            _dict['owner'] = self.owner.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> TransMemoryDto:
        """Create an instance of TransMemoryDto from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return TransMemoryDto.parse_obj(obj)

        _obj = TransMemoryDto.parse_obj({
            "id": obj.get("id"),
            "uid": obj.get("uid"),
            "internal_id": obj.get("internalId"),
            "name": obj.get("name"),
            "source_lang": obj.get("sourceLang"),
            "target_langs": obj.get("targetLangs"),
            "client": ClientReference.from_dict(obj.get("client")) if obj.get("client") is not None else None,
            "business_unit": BusinessUnitReference.from_dict(obj.get("businessUnit")) if obj.get("businessUnit") is not None else None,
            "domain": DomainReference.from_dict(obj.get("domain")) if obj.get("domain") is not None else None,
            "sub_domain": SubDomainReference.from_dict(obj.get("subDomain")) if obj.get("subDomain") is not None else None,
            "note": obj.get("note"),
            "date_created": obj.get("dateCreated"),
            "created_by": UserReference.from_dict(obj.get("createdBy")) if obj.get("createdBy") is not None else None,
            "owner": UserReference.from_dict(obj.get("owner")) if obj.get("owner") is not None else None
        })
        return _obj

