# coding: utf-8

"""
    Phrase TMS API

    Welcome to Phrase's TMS API documentation.    Please visit our [help center](https://support.phrase.com/hc/en-us/sections/5709662083612) for more information about the APIs.    If you have any questions, please contact [Support](https://support.phrase.com/hc/requests/new).    Please, include the `User-Agent` header with the name of your application or project. It might be a good idea to include some sort of contact information as well, so that we can get in touch if necessary. Examples of excellent `User-Agent` headers:  > User-Agent: Example mobile app (example@phrase.com) <br/> User-Agent: ACME Inc Java 1.8 Client (http://acmeinc.com/contact)  # noqa: E501

    The version of the OpenAPI document: Latest
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from typing import List, Optional
from pydantic import BaseModel, Field, StrictBool, StrictStr, conlist, validator
from phrasetms_client.models.user_reference import UserReference

class TermDto(BaseModel):
    """
    TermDto
    """
    id: Optional[StrictStr] = None
    text: StrictStr = Field(...)
    lang: Optional[StrictStr] = None
    rtl: Optional[StrictBool] = None
    modified_at: Optional[datetime] = Field(None, alias="modifiedAt")
    created_at: Optional[datetime] = Field(None, alias="createdAt")
    modified_by: Optional[UserReference] = Field(None, alias="modifiedBy")
    created_by: Optional[UserReference] = Field(None, alias="createdBy")
    case_sensitive: Optional[StrictBool] = Field(None, alias="caseSensitive")
    exact_match: Optional[StrictBool] = Field(None, alias="exactMatch")
    forbidden: Optional[StrictBool] = None
    preferred: Optional[StrictBool] = None
    status: Optional[StrictStr] = None
    concept_id: Optional[StrictStr] = Field(None, alias="conceptId")
    usage: Optional[StrictStr] = None
    note: Optional[StrictStr] = None
    writable: Optional[StrictBool] = None
    short_translation: Optional[StrictStr] = Field(None, alias="shortTranslation")
    term_type: Optional[StrictStr] = Field(None, alias="termType")
    part_of_speech: Optional[StrictStr] = Field(None, alias="partOfSpeech")
    gender: Optional[StrictStr] = None
    number: Optional[StrictStr] = None
    definition: Optional[StrictStr] = None
    domain: Optional[StrictStr] = None
    sub_domains: Optional[conlist(StrictStr)] = Field(None, alias="subDomains")
    url: Optional[StrictStr] = None
    concept_note: Optional[StrictStr] = Field(None, alias="conceptNote")
    __properties = ["id", "text", "lang", "rtl", "modifiedAt", "createdAt", "modifiedBy", "createdBy", "caseSensitive", "exactMatch", "forbidden", "preferred", "status", "conceptId", "usage", "note", "writable", "shortTranslation", "termType", "partOfSpeech", "gender", "number", "definition", "domain", "subDomains", "url", "conceptNote"]

    @validator('status')
    def status_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in ('New', 'Approved'):
            raise ValueError("must be one of enum values ('New', 'Approved')")
        return value

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> TermDto:
        """Create an instance of TermDto from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of modified_by
        if self.modified_by:
            _dict['modifiedBy'] = self.modified_by.to_dict()
        # override the default output from pydantic by calling `to_dict()` of created_by
        if self.created_by:
            _dict['createdBy'] = self.created_by.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> TermDto:
        """Create an instance of TermDto from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return TermDto.parse_obj(obj)

        _obj = TermDto.parse_obj({
            "id": obj.get("id"),
            "text": obj.get("text"),
            "lang": obj.get("lang"),
            "rtl": obj.get("rtl"),
            "modified_at": obj.get("modifiedAt"),
            "created_at": obj.get("createdAt"),
            "modified_by": UserReference.from_dict(obj.get("modifiedBy")) if obj.get("modifiedBy") is not None else None,
            "created_by": UserReference.from_dict(obj.get("createdBy")) if obj.get("createdBy") is not None else None,
            "case_sensitive": obj.get("caseSensitive"),
            "exact_match": obj.get("exactMatch"),
            "forbidden": obj.get("forbidden"),
            "preferred": obj.get("preferred"),
            "status": obj.get("status"),
            "concept_id": obj.get("conceptId"),
            "usage": obj.get("usage"),
            "note": obj.get("note"),
            "writable": obj.get("writable"),
            "short_translation": obj.get("shortTranslation"),
            "term_type": obj.get("termType"),
            "part_of_speech": obj.get("partOfSpeech"),
            "gender": obj.get("gender"),
            "number": obj.get("number"),
            "definition": obj.get("definition"),
            "domain": obj.get("domain"),
            "sub_domains": obj.get("subDomains"),
            "url": obj.get("url"),
            "concept_note": obj.get("conceptNote")
        })
        return _obj

