# coding: utf-8

"""
    Phrase TMS API

    Welcome to Phrase's TMS API documentation.    Please visit our [help center](https://support.phrase.com/hc/en-us/sections/5709662083612) for more information about the APIs.    If you have any questions, please contact [Support](https://support.phrase.com/hc/requests/new).    Please, include the `User-Agent` header with the name of your application or project. It might be a good idea to include some sort of contact information as well, so that we can get in touch if necessary. Examples of excellent `User-Agent` headers:  > User-Agent: Example mobile app (example@phrase.com) <br/> User-Agent: ACME Inc Java 1.8 Client (http://acmeinc.com/contact)  # noqa: E501

    The version of the OpenAPI document: Latest
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Optional
from pydantic import BaseModel, Field, StrictBool, StrictStr, validator

class TermCreateByJobDto(BaseModel):
    """
    TermCreateByJobDto
    """
    text: StrictStr = Field(...)
    case_sensitive: Optional[StrictBool] = Field(None, alias="caseSensitive", description="Default: false")
    exact_match: Optional[StrictBool] = Field(None, alias="exactMatch", description="Default: false")
    forbidden: Optional[StrictBool] = Field(None, description="Default: false")
    preferred: Optional[StrictBool] = Field(None, description="Default: false")
    usage: Optional[StrictStr] = None
    note: Optional[StrictStr] = None
    short_translation: Optional[StrictStr] = Field(None, alias="shortTranslation")
    term_type: Optional[StrictStr] = Field(None, alias="termType")
    part_of_speech: Optional[StrictStr] = Field(None, alias="partOfSpeech")
    gender: Optional[StrictStr] = None
    number: Optional[StrictStr] = None
    __properties = ["text", "caseSensitive", "exactMatch", "forbidden", "preferred", "usage", "note", "shortTranslation", "termType", "partOfSpeech", "gender", "number"]

    @validator('term_type')
    def term_type_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in ('FULL_FORM', 'SHORT_FORM', 'ACRONYM', 'ABBREVIATION', 'PHRASE', 'VARIANT'):
            raise ValueError("must be one of enum values ('FULL_FORM', 'SHORT_FORM', 'ACRONYM', 'ABBREVIATION', 'PHRASE', 'VARIANT')")
        return value

    @validator('part_of_speech')
    def part_of_speech_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in ('ADJECTIVE', 'NOUN', 'VERB', 'ADVERB'):
            raise ValueError("must be one of enum values ('ADJECTIVE', 'NOUN', 'VERB', 'ADVERB')")
        return value

    @validator('gender')
    def gender_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in ('MASCULINE', 'FEMININE', 'NEUTRAL'):
            raise ValueError("must be one of enum values ('MASCULINE', 'FEMININE', 'NEUTRAL')")
        return value

    @validator('number')
    def number_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in ('SINGULAR', 'PLURAL', 'UNCOUNTABLE'):
            raise ValueError("must be one of enum values ('SINGULAR', 'PLURAL', 'UNCOUNTABLE')")
        return value

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> TermCreateByJobDto:
        """Create an instance of TermCreateByJobDto from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> TermCreateByJobDto:
        """Create an instance of TermCreateByJobDto from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return TermCreateByJobDto.parse_obj(obj)

        _obj = TermCreateByJobDto.parse_obj({
            "text": obj.get("text"),
            "case_sensitive": obj.get("caseSensitive"),
            "exact_match": obj.get("exactMatch"),
            "forbidden": obj.get("forbidden"),
            "preferred": obj.get("preferred"),
            "usage": obj.get("usage"),
            "note": obj.get("note"),
            "short_translation": obj.get("shortTranslation"),
            "term_type": obj.get("termType"),
            "part_of_speech": obj.get("partOfSpeech"),
            "gender": obj.get("gender"),
            "number": obj.get("number")
        })
        return _obj

